<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
// Copyright, Jim Symonds AutomaticWebSoftware.com, 2018, All Rights Reserved.
//ACCESS THIS PAGE TO GET IP INTO admin_ips TABLE, THEN AUTHORIZE IT IN DB TABLE (admin_ips).
// NOTE!! admin_ips TABLE FIELD "username" WILL ALWAYS SHOW THE LAST USERNAME WHO LOGGED IN FROM THAT IP!
//unset($_SESSION);
session_start();
require_once('./../Sub/Config.inc.php');
include './../phpcpr.php';
include 'admin_ip_checker.inc.php';
$use_sendgrid = $Global['use_sendgrid'];
 
if ($use_sendgrid == true) include $Global['path'].'/sendgrid.inc.php'; // load sendgrid functions if using them

$error_captcha = '';
//if ($_GET['reset'] == 'jim') $_SESSION['debug'] = true;	
//$debug = $_SESSION['debug'];
//$debug = false; // FOR PRODUCTION
//$debug = true; // QQQ COMMENT!

$send_email = false; // INI VAR
$send_sms = false; // INI VAR

// QQQ E1UP DEBUG
//if ($buffer_admin_lookup['ip'] == '') $debug = true

/*if ($debug == true) {
	echo 'PRINT R POST: ';
	echo '<pre>';
	print_r($_POST);
	echo '</pre>';
}*/
// SET IN CONFIG FILE - IF FALSE WE OVERRIDE SETTINGS - THIS WILL ALLOW ANYONE TO ACCESS THE ADMIN LOGIN PAGE!
//$Global['admin_ip_lock'] = false; // QQQ SETTING FOR TESTING - COMMENT OUT!
// SET UP FAILSAFE, SO CONFIG FILE DOES NOT NEED TO BE UPDATED RIGHT AWAY ON ALL SITES
if (empty($Global['admin_ip_lock'])) $Global['admin_ip_lock'] = false;
if ($Global['admin_ip_lock'] == false) $admin_ip = true;

if (!isset($_SESSION['admin_login'])) $_SESSION['admin_login'] = false; 


if ($_SESSION['admin_login'] == true) {
	//WE ARE ALREADY LOGGED IN - JUST REDIRECT ADMIN TO Finduser.php
    header("Location: {$Global['webpage_url_ssl']}{$Global['admin_dir']}/Sub/Finduser.php");
    exit; 
}

if ($Global['use_twilio'] == true) { // EDIT ACCOUNT INFO, AND PHONE NUMBERS AND XML FILES IN 2 SPOTS BELOW!
	//load twilio library
	include $Global['path'].'/sms.inc.php';	// includes Twilio library
	//$AccountSid = $Global['twilio_AccountSid'];
	//$AuthToken = $Global['twilio_AuthToken'];
}

// CREATE SIMPLE RANDOM CAPTCHA NUMBERS
if (empty($_SESSION['captcha'])) {
	$_SESSION['captcha'] = rand(111,999);
	if ($_SESSION['captcha'] == 665 + 1) $_SESSION['captcha'] = 777;
	$captcha_password = $_SESSION['captcha'];
} else {
	$captcha_password = $_SESSION['captcha'];
}

if ($admin_ip == true || $_GET['au'] != '') { 
	$_SESSION['admin_login_deny'] = false;
	unset($_SESSION['date']);
	$logged_visit = false;
	//$debug = true;
}
//$logged_visit = false;

$date_now = date("Y-m-d H:i:s");
if (empty($_SESSION['date'])) $_SESSION['date'] = $date_now;
$date = $_SESSION['date'];


$https = substr($Global['webpage_url_ssl'], 0, 5);

if (!isset($_SERVER['HTTPS']) && $https == 'https') {
	header("Location: {$Global['webpage_url_ssl']}admin/login.php");
	exit;
}

/*
//session_destroy();
error_reporting(-1);
echo 'PRINT R SESSION: ';
echo '<pre>';
print_r($_SESSION);
echo '</pre>';

echo 'PRINT R GET: ';
echo '<pre>';
print_r($_GET);
echo '</pre>';

echo 'PRINT R REQUEST: ';
echo '<pre>';
print_r($_REQUEST);
echo '</pre>';

echo 'PRINT R POST: ';
echo '<pre>';
print_r($_POST);
echo '</pre>';

echo 'sitename: ';
echo $Global['webpage_name'];
*/


/**
 * Logs the login attempt
 * if it's successfull saves the member id and username
 *
 * @param bool $username		The username the user tried to login with
 * @param bool $success			Whether the login was successfull
 * @param array $buffer			The info of the logged member if the login was a success
 */

// KEEP THIS SECTION ABOVE BELOW FUNCTION - md5 value WAS GETTING CLOBBERED SOMEHOW!
$set_md5 = md5(microtime().rand(0, 1000));
$md5 = $buffer_admin_lookup['md5'] ?? $set_md5;
 
function log_login($username, $success = false, $buffer_admin_lookup = array(), $date) {
	// Check if the IP address is available in the server variables and sanitize it.
	$ip = isset($_SERVER['REMOTE_ADDR']) ? sanitize($_SERVER['REMOTE_ADDR']) : '0.0.0.0';

	// Get the DNS host name for the IP address, if available.
	$dns = gethostbyaddr($ip);

	// Check if the user agent is set, sanitize it, and handle cases where it's not available.
	$user_agent = isset($_SERVER['HTTP_USER_AGENT']) ? sanitize($_SERVER['HTTP_USER_AGENT']) : '';

	// Now `$ip`, `$dns`, and `$user_agent` are set and sanitized appropriately.
	
	$log_time = $date;
	if ($success === true) {
		$admin_id = $buffer_admin_lookup['ID'];
		$login_success = 1;
	} else {
		$admin_id = 0;
		$login_success = 0;
	}

	$data = [
		'ID' => $admin_id,
		'log_login_username' => $username,
		'log_ip' => $ip,
		'log_dns' => $dns,
		'log_user_agent' => $user_agent,
		'log_time' => $log_time,
		'log_login_success' => $login_success,
		'type' => 'visit'
	];
	insert('admin_log', $data, 1, 1);
}
$successMsg = '';
// LET ADMIN VERIFY IP ADDRESSES - NOTE THIS NEXT SECTION OF CODE STARTED OUT BELOW IP LOCK AND WITH "$admin_ip == true" HOWEVER, REALIZED IF ADMIN IS ON A NEW IP, THIS WILL KEEP THEM LOCKED OUT, SO... WE TRUST ADMIN EMAIL AND PHONE ARE SECURE, I.E. IF YOU GOT THIS LINK, YOU SHOULD BE ABLE TO MOVE AHEAD! REQUIRED FOR ADMIN TO MOVE LOCATIONS AND APPROVE NEW IP ACCESS!!	
if (isset($_GET['au'])) { // AUTHORIZATION LINK FOUND!
	$au = htmlspecialchars($_GET['au'], ENT_QUOTES, 'UTF-8');
	$au = sanitize($au);
	
	$selectFields = '*';
	$mainTable = 'admin_ips';
	$where = ['md5' => $au];
	$buffer = select($selectFields, $mainTable, [], $where, null, null, null, 0, $debug);
	
	if (isset($buffer['authorized']) && $buffer['authorized'] === 0) {
		$data = [
			'username' => 'AUTHORIZED',
			'authorized' => 1,
			'auth_date' => $date,
			'auth_ip' => $Global_userip
		];
		$where = [
			'md5' => $au,
			'authorized' => 0
		];
		update('admin_ips', $data, [], $where, 1, 1, $debug);
		
		$successMsg = 'Confirmation Complete! '.$buffer['name'].' has been emailed at '.$buffer['email'].', that their IP address has been granted access.<br/><br/>NOTE: they will still need proper login credentials to login.';
		
		// EMAIL THE NEW ADMIN USER WHO HAS JUST BEEN UNBLOCKED FROM THIS PAGE!
		$to = $buffer['email'];
		$subject = 'Admin Panel Access Granted!';
		$message = 'Hello '.$buffer['name'].',

Your IP address '.$buffer['ip'].' has been granted admin panel login access on '.$Global['webpage_name'].'.

If you have proper login credentials, you may now login here: 

'.$Global['webpage_url_ssl'].'admin/login.php';

		if ($use_sendgrid == true) { // USING SENDGRID
			sendgrid_email($to, $subject, $message);
		} else { // NO SENDGRID CREDENTIALS - - - USING PHP MAIL	
			mail($to, $subject, $message, "From: {$Global['admin_email_heading']} <{$Global['admin_email']}>\r\n");
		}
		
	} else {
		$errorMsg = 'You already confirmed this IP for: '.$buffer['name'].', who was then also emailed at '.$buffer['email'].', that their IP address '.$buffer['ip'].' had been granted admin panel access.<br/><br/>NOTE: they will still need proper login credentials to login.';
	}
} // END ADMIN VERIFIED THE IP ADDRESS

if ($admin_ip != true) {
	$login_username = 'UNAUTHORIZED';
} else {
	$login_username = 'AUTHORIZED';
}

// LOG ACCESS ATTEMPT INTO admin_log
if ($date == $date_now && $_SESSION['admin_login_deny'] == false && $logged_visit == false) {
	log_login($login_username, false, $buffer_admin_lookup, $date);
	$logged_visit = true;
}


// ADD IP INTO admin_ips, IF NOT ALREADY THERE
if ($admin_ip == true && !isset($buffer_admin_lookup['ip'])) {
	$data = [
		'username' => 'UNAUTHORIZED',
		'ip' => $Global_userip,
		'md5' => $set_md5,
		'created' => $date
	];
	insert('admin_ips', $data, 1, 1);
}

// IF NOT AUTHORIZED - WE HANDLE THEM HERE!!
if ($admin_ip != true && $successMsg == '') {
	
	$_SESSION['admin_login_deny'] = true;
	
	// UPDATE LOG ATTEMPT TYPE TO DENIED	
	$updateData = [
		'type' => 'DENIED',
		'ID' => '',
		'log_login_username' => $login_username,
		'log_login_success' => 0
	];
	$updateWhere = [
		'log_ip' => $Global_userip,
		'log_time' => $date
	];
	update('admin_log', $updateData, [], $updateWhere, 1, 1, 1);
	
			
	// ADD IP INTO admin_ips, IF NOT ALREADY THERE
	if ($buffer_admin_lookup['ip'] == '') {
		$insertData = [
			'username' => 'UNAUTHORIZED',
			'ip' => $Global_userip,
			'md5' => $set_md5,
			'created' => $date
		];
		insert('admin_ips', $insertData, 1, 1);
	}
	
	
	//NOW WE COULD TRY TO FOOL THEM WITH A 404 PAGE, BUT THEIR HISTORY LOGS WILL KNOW BETTER, IF THEY ARE CLEVER ENOUGH
	//ALSO WE ARE GOING ON ASSUMPTION ADMINS WILL NEED TO SEE WHAT IS HAPPENING FOR PROPER SUPPORT, SO NOT USING THIS NOW 	
	//header("Location: {$Global['webpage_url_ssl']}404.php");
    //exit;
	include 'header.php';	
	?>
	<div class="table-responsive centered">
	<p></p>
	<table class="table">
	<tr>
	<td style="width:; text-align:right;">
	<img src="./../images/warning-aws.png">
	</td>
	<td>

	<h4 style="text-align:center;"><span style="color:red; text-decoration:underline">
	UNAUTHORIZED IP!</span></h4>
	</td>
	</tr>
	</table><hr style="margin-top:-20px">	
	<h4><span style="color:#000">
	<i class="fa fa-hand-o-right" style="color:#B0B0B0"></i> 
	
	<b><span style="color:red">Your IP address is: <?php echo $Global_userip; ?></span></b>
	
	<br/>All accesses to this page are logged. 
	</span></h4>
	<?php if ($_POST['get_authorized'] != 'yes' || ($_POST['name'] != '' && trim($_POST['captcha']) != $captcha_password)) {	?>
	<h4>To request access, provide your full name and email</h4>
	
	<form name="loginform" id="loginform" action="<?php print $_SERVER['PHP_SELF']; ?>" method="post">
	 <div class="form-group input-group">
		<span class="input-group-addon"><i class="fa fa-user"></i></span>
		<input class="form-control" type="text" placeholder="Your Full Name" name="name"
		 onMouseover="this.focus()" required maxlength="70"/>
	  </div>
	 <div class="form-group input-group">
		<span class="input-group-addon"><i class="fa fa-user"></i></span>
		<input class="form-control" type="email" placeholder="Your Email" name="email"
		 onMouseover="this.focus()" required maxlength="70"/>
	  </div>

	<?php if ($_POST['name'] != '' && trim($_POST['captcha']) != $captcha_password) {
		$error_captcha = 'Please enter the Captcha number: '.$captcha_password.'<br/>below, to pass the human test.';		   
		echo '<span style="font-weight:bold; color:red">'.$error_captcha.'</span>';
	}
	?>	
	  
      <div class="form-group input-group">
        <span class="input-group-addon"><i class="fa fa-chain"></i></span>
		<input class="form-control" type="text" placeholder="Enter Captcha Code: <?php echo $captcha_password; ?>" name="captcha" required value="<?php if (!empty($_POST['captcha'])) echo htmlspecialchars($_POST['captcha'], ENT_QUOTES, 'UTF-8'); ?>" onMouseover="this.focus()" maxlength="10">
      </div>
	  
	  	<input type="hidden" name="get_authorized" value="yes">
		<input type="submit" value="Request Access" class="btn btn-lg btn-primary" style="margin-top:5px; background-color:#00b3fe;" name="Submit" id="submit">	  
	</form>
	</div>
	<?php
	} else { ?>
		<hr>
		<h2>Your request for access has been sent to admin!</h2>
		Watch your email for a response from admin.
	<?php	
		unset($_SESSION['captcha']);
	}
	include 'footer.php';
	
	/* // OLD WAY - GET LAST LOG TIME - WHEN THEY LAST ACCESSED THIS PAGE!
	$qry = "SELECT log_time FROM admin_log WHERE log_ip='{$Global_userip}' ORDER BY admin_log_id DESC LIMIT 1";
	$result = mysql_query($qry) or die($qry.' '.mysql_error());
	if ($debug == true) echo $qry."<br/>";
	$buffer = mysql_fetch_assoc($result);
	if ($debug == true) {
		echo 'IP: '.$Global_userip;
		print_r($buffer);
	}	
	// CODE TESTED HERE AND BELOW FOR 1 DAY AGO - WORKS GREAT
	$one_day_ago = date("Y-m-d H:i:s",strtotime("-1 day"));
	
	// OLD WAY - ONCE PER DAY
	//if (!empty($buffer['log_time']) && $buffer['log_time'] < $one_day_ago) {}
	*/
	// NEW WAY - EMAIL / SMS UPON REQUEST!
	if ($_POST['get_authorized'] == 'yes' && trim($_POST['captcha']) == $captcha_password) {
		$name = $_POST['name'];
		$email = $_POST['email'];

		$data = [
			'name' => $name,
			'email' => $email
		];
		$where = [
			'ip' => $Global_userip,
			'authorized' => 0
		];
		update('admin_ips', $data, [], $where, 0, 1, 1);
		
		// ONLY SEND EMAIL ALERT ONCE PER DAY
		// FOUND SESSION WAS UNRELIABLE - BOTS SEEM TO BYPASS SESSION SOMEHOW, SO CHANGED TO THIS CODE NOW INSTEAD
		//if ($debug == true) echo 'No Login Last 24 Hours From This IP';
		$send_email = true;
		$send_sms = true;
	} else {
		//if ($debug == true) echo 'Last login from this IP was within last day';
		$send_email = false;
		$send_sms = false;
	}
	//if ($debug == true) exit;
	
// NOTE!! WE DO NOT EXIT HERE AS WE MAY STILL NEED TO EMAIL & SMS - ALSO FORM WILL NOT SHOW UP ANYWAY.	
} // END IP IS NOT AUTHORIZED 	
	
if ($send_email == true) {	
	// EMAIL ADMIN - NOTIFY ADMIN OF ATTEMPT, ALLOW THEM TO AUTHORIZE THE IP!
	//$to = 'tech@automaticwebsoftware.com';
	//$to = 'jim.symonds@automaticwebsoftware.com';	
	$to  = $Global['admin_email'];
	//$to .= ',tech@automaticwebsoftware.com'; // send to existing email in the members table
	//$to = array($Global['admin_email'],'tech@automaticwebsoftware.com')
	$subject = 'Admin Panel Access Attempted!';
	
	$message = 'Hello '.$Global['administrator_first_name'].',

An attempt has just been made to access the admin panel on '.$Global['webpage_name'].' at '.$date.'. The IP address used for this login attempt was '.$Global_userip.'

You may research the location of this IP here: https://whatismyipaddress.com/ip/'.$Global_userip.'.

This visitor has identified themself as '.$name.', using the email '.$email.'. 

If this IP should be granted access to the admin panel, please confirm that you want to authorize this IP by clicking on this link: 

'.$Global['webpage_url_ssl'].'admin/login.php?au='.$md5.'

If you do not wish to authorize this IP address, you may simply ignore this email.';

	if ($use_sendgrid == true) { // USING SENDGRID
		sendgrid_email($to, $subject, $message);
	} else { // NO SENDGRID CREDENTIALS - - - USING PHP MAIL	
		mail($to, $subject, $message, "From: {$Global['admin_email_heading']} <{$Global['admin_email']}>\r\n");
	}
} // END SEND EMAIL IS TRUE	

// GET THE ADMIN'S CELLPHONE
$selectFields = 'cellphone';
$mainTable = 'members';
$where = ['ID' => 1];
$resultp = select($selectFields, $mainTable, [], $where);

$bufferp = $resultp[0];
$admin_cellphone = $bufferp['cellphone'];


//echo $admin_cellphone;
//exit;

// SMS TEXT MESSAGE ADMIN ALSO - NOTIFY ADMIN OF ATTEMPT, ALLOW THEM TO AUTHORIZE THE IP!
if ($send_sms == true) {
	$send_text = "IP ".$Global_userip." wants admin access. Claims to be ".$name." email: ".$email.". To grant access click here ".$Global['webpage_url_ssl']."admin/login.php?au=".$md5." IF LINK IS BROKEN, ADD BACK";
	if ($Global['use_twilio'] == true) {
		send_twilio_sms($admin_cellphone,$send_text); // send welcome text to new member
	} else { // IF NOT USING TWILIO, WE CAN SEND AN SMS VIA EMAIL
	// QQQ NEEDS MORE WORK TO DEFINE THE ADMIN'S PHONE / CARRIER -- I.E. TO BE AUTOMATED ADMIN WOULD NEED TO CHOOSE THEIR CARRIER, THEN WE'D NEED TO STORE THAT AND CREATE THE NEEDED CODE TO ASSEMBLE THE ENTIRE NUMBER (NUMBER PLUS CARRIER)
		$to  = '2073218774@txt.att.net';
		//$to .= ',tech@automaticwebsoftware.com'; // send to existing email in the members table
		//$to = array($Global['admin_email'],'tech@automaticwebsoftware.com')
		$subject = 'Admin Panel Access Attempted!';
		$message = $send_text;
		$header = "From: site ".$Global['webpage_name']."\r\n";
		$header .= "MIME-VERSION: 1.0\r\n";
		$header .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
		$phpversion = phpversion();
		$header .= "X-Mailer: PHP v$phpversion\r\n";
		mail($to, $subject, $message, "From: {$Global['admin_email_heading']} <{$Global['admin_email']}>\r\n");
	}
	
} // END TEXT NEW MEMBER

////////////////////////////////////////////////////////////////////
//
//
// BEGIN LOGIN PROCEEDURE
//
//
////////////////////////////////////////////////////////////////////
if ($admin_ip == true && isset($_POST['action']) && $_POST['action'] == 'login') {
	$_SESSION['admin_login'] = false;
  
	if (empty($_POST['login']) || empty($_POST['password']) ) {
		$errorMsg = 'Please specify your username and password';
	} else if ($admin_ip != true && trim($_POST['captcha']) != $captcha_password) {
		$errorMsg = 'Invalid Captcha';
		$error_captcha = 'Please enter the Captcha number: '.$captcha_password.'<br/>below, to pass the human test.';
	} else {
	
    $username = htmlspecialchars($_POST['login'], ENT_QUOTES, 'UTF-8');
	//$password = htmlspecialchars($_POST['password'], ENT_QUOTES, 'UTF-8');
	// THIS WAS NOT ALLOWING SPECIAL CHARS IN PW!
	$password = $_POST['password'];
	
	/*if ($username == 'admin') {
	
		if (substr($password,-5) == 'winds') { // SETTING ADDITIONAL HIDDEN SECRET PASSWORD
			$password = substr($password,0,strlen($password)-5);

		} else {
			$password = '';
			$errorMsg = 'Invalid Username or Password';		
		}
	}	
	*/		
    //the username must not only be present in the members table, 
    //but also must have at least one administrative privilege 	
	$selectFields = 'count(*) as total';
	$mainTable = 'members';
	$joinConditions = [
		[
        'table' => 'user_permission',
        'as' => 'u',
        'condition' => 'u.user_id = members.ID'
		]
    ];	
	$where = [
		'Username' => $username
	];
	// /*'Password' => $password */ // OLD WAY! 
	$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, 0, $debug);
	$row = isset($result[0]) ? $result[0] : null;
	
	//print_r($row);
	
	// FIND USER ID	
	$selectFields = 'ID, Password';
	$mainTable = 'members';
	$where = ['Username' => $username];
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, $debug);
	$buffer = isset($result[0]) ? $result[0] : null;
	
	//print_r($buffer);
	
	$ID = $buffer['ID'] ?? 0;
	
	// INI VARIABLE
	$passwordAccepted = false;

	// Verify the password
	// Here, $password is the plain password entered by the user
	// $buffer['Password'] should be the hashed password stored in database
	if (isset($buffer['Password'])) {
	$passwordAccepted = password_verify($password, $buffer['Password']);
	
	// Backward compatibility (before pw got hashed)
	if ($_POST['password'] == $buffer['Password']) $passwordAccepted = true;
	}
	if ($passwordAccepted == true) {
		
		if ($row['total'] >= 1) {
			$updateDataLog = [
				'type' => 'entry',
				'log_login_username' => $username,
				'log_login_success' => 1
			];
			$updateWhereLog = [
				'log_ip' => $Global_userip,
				'log_time' => $date
			];
			update('admin_log', $updateDataLog, [], $updateWhereLog, 1, 1, 1);

			//unset($_SESSION['date']);

			if ($Global['admin_ip_lock'] == false) {
				$updateDataIps = [
					'username' => 'AUTHORIZED',
					'authorized' => 1,
					'auth_date' => $date,
					'auth_ip' => $Global_userip
				];
				$updateWhereIps = [
					'ip' => $Global_userip,
					'authorized' => 0
				];
				update('admin_ips', $updateDataIps, [], $updateWhereIps, 1, 1, 1);
			}
		}
			

		//ok, the user indeed is the admin user and not just a normal member
		//session_destroy();
		$_SESSION['admin_login']    = true;
		$_SESSION['admin_username'] = $username;
		$_SESSION['admin_session']  = $password;
		
		// UPDATE USER ID AND USERNAME - SET IT TO WHO LOGGED IN LAST AS THAT USER
		$updateData = [
			'ID' => $ID,
			'username' => $username
		];
		$updateWhere = [
			'ip' => $Global_userip
		];
		update('admin_ips', $updateData, [], $updateWhere, 1, 1, 1);
		
		/*
		//check to see if this user has a store associated with him/her
		$sql = 'SELECT s.store_id FROM store s INNER JOIN members m ON m.ID=s.member_id WHERE m.Username="'.mysql_real_escape_string($username).'" LIMIT 1';
		$result = mysql_query($sql);
		$buffer = mysql_fetch_assoc($result);
		if (!empty($buffer['store_id'])) {
			header("Location: {$Global['webpage_url_ssl']}{$Global['admin_dir']}/Store/Selectstore.php?store=".$buffer['store_id']);
			exit;
		}
		*/
		unset($_SESSION['captcha']);	
		//REDIRECT ADMIN TO Finduser.php
		header("Location: {$Global['webpage_url_ssl']}{$Global['admin_dir']}/Sub/Finduser.php");
		exit;
    
	} else {
		$errorMsg = 'Invalid Username or Password';  
    }
	}	
} // END LOGIN PROCEEDURE


////////////////////////////////////////////////////////////////////////////
//
// PAINT THE PAGE!!
//
////////////////////////////////////////////////////////////////////////////
if ($admin_ip == true || $successMsg != '') { // CREDENTIALS ARE GOOD - SHOW FORM!
	include 'header.php'; ?>

	<div class="centered wow fadeIn quick" data-wow-duration="1s" data-wow-delay="1s">
	<h3>Admin Login</h3>
	</div>
	<?php	if (!empty($successMsg)) { 
		echo '<div class="wow fadeIn quick" style="text-align:left; text-align:justify; text-justify: inter-word; font-weight:bold; color:green; margin:20px" data-wow-duration="1s" data-wow-delay="1s">'.$successMsg.'</div>';
	}	
	if (!empty($errorMsg)) { 
		echo '<div class="wow fadeIn quick" style="text-align:left; text-align:justify; text-justify: inter-word; font-weight:bold; color:red; margin:20px" data-wow-duration="1s" data-wow-delay="1s">'.$errorMsg.'</div>';
	}	
	?><br/>
	<form name="loginform" id="loginform" action="login.php" method="post">
	 <div class="form-group input-group wow fadeInRight">
		<span class="input-group-addon"><i class="fa fa-user"></i></span>
		<input class="form-control" type="text" placeholder="Username" name="login" id="log"
		value="<?php echo isset($_POST['login']) ? htmlspecialchars($_POST['login'], ENT_QUOTES, 'UTF-8') : ''; ?>" onMouseover="this.focus()" required maxlength="20"/>
		
	 </div>
	  <div class="form-group input-group wow fadeInLeft">
		<span class="input-group-addon"><i class="fa fa-lock"></i></span>
		<input class="form-control" type="password" placeholder="Password" name="password" id="pwd"
		value="<?php // NEVER DO THIS! //echo $_POST['pass']; ?>" onMouseover="this.focus()" required maxlength="50"/>
	  </div> 
	<?php if ($admin_ip != true) {		  
	if (!empty($error_captcha)) { 
		echo '<span style="font-weight:bold; color:red">'.$error_captcha.'</span>';
	}
	?>
      <div class="form-group input-group wow fadeInRight">
        <span class="input-group-addon"><i class="fa fa-chain"></i></span>
		<input class="form-control" type="text" placeholder="Enter Captcha Code: <?php echo $captcha_password; ?>" name="captcha" required value="<?php if (!empty($_POST['captcha'])) echo htmlspecialchars($_POST['captcha'], ENT_QUOTES, 'UTF-8'); ?>" onMouseover="this.focus()" maxlength="10">
      </div>
	<?php
	} // END ADMIN IP IS NOT TRUE
	?>
	<div class="centered"> <!-- <div class="centered wow fadeIn quick" data-wow-duration="1s" data-wow-delay="1s"> -->
	<input type="hidden" name="action" value="login">
	<input type="submit" value="Submit To Login" class="btn btn-success" style="margin-top:5px; background-color:#00b3fe;" name="Submit" id="submit">			
	</div>  
	</form>
	<?php
	include 'footer.php';
} // END PAINTING PAGE
?>