<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include ''.$_SERVER['DOCUMENT_ROOT'].'/Members/logincheck.php';
$pageName = ''; // THIS IS SHOWN AS A BREADCRUMB UNDER THE MENU, AND IS ALSO USED AS THE PAGE TITLE, IF $pageDesc IS LEFT EMPTY.
$pageDesc = ''; // IF USED, THIS IS SHOWN AS THE TITLE IN THE PAGE (BLUE BAR SECTION, END OF HEADER), REPLACING $pageName.
$pageIcon = ''; // THE ICON USED IN THE PAGE
$pageAlign = 'center'; // HOW YOU WANT TO ALIGN THE PAGE CONTENT
$pageClass = 'full'; // FOR CUSTOM PROGRAMMING USES
$do_not_display_ads = true; // STOPS FILE FROM BEING INCLUDED FROM B.O. HEADER
if (!isset($debug)) {
	header('Cache-Control: no-cache');
	header('Pragma: no-cache');
}
//$debug = false;
//$debug = true;
/*
echo 'admin_login '.$_SESSION['admin_login'];
echo ' admin jv login '.$_SESSION['admin_jv_login'];
echo ' userID '.$_SESSION['UserID'];
exit;
*/
// COMMENTED - THE Status field is now unpaid, paid, or Cancelled which was not the case when this was made.
// So to support more admin users, need to consider a new field to use for JV status.
/*if ($_SESSION['admin_login'] == false && $_SESSION['admin_jv_login'] != $_SESSION['UserID']) {
	$qry_admin = "SELECT Status FROM members WHERE ID={$_SESSION['UserID']}";
	if ($debug == true) echo $qry_admin."<br/>";
	$result_admin = mysql_query($qry_admin) or die($qry_admin.' '.mysql_error());
	$buffer_admin = mysql_fetch_assoc($result_admin);
	if ($buffer_admin['Status'] != 'JV') {
		header("Location: /ads/dashboard.php");
		exit;
	} else {
		$_SESSION['admin_jv_login'] = $_SESSION['UserID'];
	}
}*/


$whereMain = [];
if (isset($_GET['type'])) {
	$type = $_GET['type'];
	$type = htmlspecialchars($type, ENT_QUOTES, 'UTF-8');
	$whereMain['adtype'] = ['=', $type];
}

if ($_REQUEST['status'] == 1) {
	$whereMain['status'] = ['>', 0];
} else if ($_REQUEST['status'] == 'denied') {
	$whereMain['status'] = ['=', '-1'];	
} else if ($_REQUEST['status'] == '0') { // 0 MUST BE IN QUOTES!
	$whereMain['status'] = ['=', 0];	
}

if (isset($_REQUEST['traffic_started']) && $_REQUEST['traffic_started'] == 'Y') {
	$whereMain['adcredits'] = ['<', 'stcredits'];
	$whereMain['adcredits'] = ['!=', 0]; // QQQ WORK IN PROGRESS - CANNOT RE-USE ARRAY VAR, WILL OVERWRITE FIRST ONE
	// SEE POWERLINE EMAIL EXAMPLES	
}	
if (isset($_REQUEST['traffic_delivered']) && $_REQUEST['traffic_delivered'] == 'Y') {
	$whereMain['adcredits'] = ['=', 0];
	$whereMain['adtype'] = ['=', 'traffic']; 
	$whereMain['status'] = ['>', 0];	
}
if (isset($_POST['username']) && $_POST['username'] != '') {
	$selectFields = 'ID';
	$mainTable = 'members';
	$where = [
		'Username' => ['=', $_POST['username']]
	];
	$limit = 1;
	$show_debug = 1;

	$result = select($selectFields, $mainTable, [], $where, null, null, null, $limit, $show_debug);
	$buffer = isset($result[0]) ? $result[0] : null;

	$user_ID = $buffer['ID'];
	$whrsql = " AND ID=$user_ID";
}

if (isset($_POST['short']) && $_POST['short'] != '') {
	$short_lookup = $_POST['short'];
	$whereMain['short'] = ['=', $short_lookup];
}


//if (is_array($_REQUEST['idx'])) $idx = sanitize($_REQUEST['idx']);
//else $idx = isset($_REQUEST['idx']) ? htmlspecialchars($_REQUEST['idx'], ENT_QUOTES, 'UTF-8') : '';

$idx = isset($_REQUEST['idx']) ? sanitize($_REQUEST['idx'], 'idx') : '';

$c = isset($_REQUEST['c']) ? htmlspecialchars($_REQUEST['c'], ENT_QUOTES, 'UTF-8') : '';
$shortchange = isset($_GET['shortchange']) ? htmlspecialchars($_GET['shortchange'], ENT_QUOTES, 'UTF-8') : '';


if ($_POST != '') {
	//echo $idx;
	//exit;
}

$AID = $_SESSION['UserID']; // THE ADMIN MODERATOR
$datetime = date("Y-m-d H:i:s");

include $Global['path'].'Sub/tpl/header_tpl.php';
include './../../admin/Lib/Pagination.function.php';

/*include './../../admin/Inc/Login.inc.php';
if ($loggedUser->checkPermisson('BANNER') === false) {
	$errorMessage = 'You are not allowed to access this page.';
	require_once('./../Inc/error.php');
	exit();
}
*/
$short_updated = false;
if (isset($_REQUEST['shortchange']) && $_REQUEST['shortchange'] != '') {
	
	if ($_POST['newshort'] != '') {
		$newshort = htmlspecialchars($_REQUEST['newshort'], ENT_QUOTES, 'UTF-8');
		$newshort = strtoupper($newshort);
		
		$selectFields = 'idx AS USED'; // SPECIFIC COLUMN ALIAS
		$mainTable = 'campaigns';
		$where = [
			'short' => ['=', $newshort] 
		];
		$show_debug = 1;
		$resultcmp = select($selectFields, $mainTable, [], $where, null, null, null, 0, $show_debug);
		$cmpinfo = isset($resultcmp[0]) ? $resultcmp[0] : null;
		
		if ($cmpinfo['USED'] != '') { // THIS SHORT IS TAKEN!
			echo '<h2>That Short is Already Taken!<br/>';
			echo 'Please choose another Short URL Code</h2>';
		} else {
			$short_updated = true;
			echo '<h2>Success! Short URL Code Updated!</h2>';
						
			$table = 'campaigns';
			$data = ['short' => $newshort];
			$where = ['short' => ['=', $shortchange]];
			$live = 1;
			$show_debug = $debug ? 1 : 0;
			$update_campaigns = update($table, $data, [], $where, $live, 0, $show_debug);

			$table = 'shares';
			$data = ['share' => $newshort];
			$where = ['share' => ['=', $shortchange]];
			$update_shares = update($table, $data, [], $where, $live, 0, $show_debug);

			$table = 'support_tickets';
			$data = ['ticket_id' => $newshort];
			$where = ['ticket_id' => ['=', $shortchange]];
			$update_support_tickets = update($table, $data, [], $where, $live, 0, $show_debug);
		}
	}
?>	
	<div class="col-md-4 col-centered">
	&nbsp;
	</div>

	<div class="col-md-4" style="text-align:center; margin: 0 auto;">
	<?php if ($short_updated != true) { ?>
	<h3>Change Short URL (From <?php echo $shortchange; ?>)</h3>

	<form method="post" name="myForm" onsubmit="document.getElementById('submit').disabled=true; document.getElementById('submit').value='Submitting, please wait...';">

	<input type="hidden" name="shortchange" value="<?php echo $_GET['shortchange']; ?>">					
		
	<input class="form-control" style="margin: 0 auto; width:250px;" onMouseover="this.focus()" size="10" name="newshort" value="<?php if(isset($_POST['newshort'])) : echo $_POST['newshort']; else : echo ''; endif; ?>" id="inputSuccess" placeholder="New Short URL Code">

	<br/><br/>
	
	<input type="submit" value="Change Short Code" name="Change Short Code" class="btn btn-info btn-default">
	</form>
	<?php } ?>
	
	<br/><br/>
		
	<a href="campaigns_manage.php" class="btn btn-sm btn-warning" style="background-color:;">Return to Campaign Manager</a>
	</div>
	
	<div class="col-md-4 col-centered">
	&nbsp;
	</div>	
	
<?php
include $Global['path'].'Sub/tpl/footer_tpl.php';
exit;	
}

if (isset($_GET['action']) && $_GET['action'] == 'thumbchange_confirm') { 
	$selectFields = 's.*, c.idx, c.ID, c.name, c.status';
	$mainTable = ['table' => 'shares', 'as' => 's'];
	$joinConditions = [
		['table' => 'campaigns', 'as' => 'c', 'condition' => 's.share = c.short']
	];
	$where = [
		's.share' => ['=', $c]
	];
	$orderBy = 'c.status DESC, s.idx DESC';
	$limit = 1;
	$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, $orderBy, $limit, $show_debug);
	$buffer = isset($result[0]) ? $result[0] : null;

	if ($debug) {
		$debug_text .= '<br><br><b>MASTER QRY Executed</b><br/><br>';
	}


	if ($buffer['type'] == 'youtube') {
		$thumbnail_img = "/images/youtube/".$buffer['embed'].".jpg";
	} else if ($buffer['type'] == 'vimeo') {
		$thumbnail_img = "/images/vimeo/".$buffer['embed'].".jpg";
	} else {
		$thumbnail_img = "";
	}
	if ($thumbnail_img != '') { ?>	

		<div class="col-md-4 col-centered">
		&nbsp;
		</div>	
		<div class="col-md-4 col-centered">
		
			<h3 style="text-align:center">Current Thumbnail for
			<br>"<?php echo $buffer['name']; ?>"<br>
			&nbsp;<img src="<?php echo $thumbnail_img; ?>" width="100%" height="">
			<br><?php echo $thumbnail_img; ?></h3>
		
		<a href="campaigns_manage.php?c=<?php echo $c; ?>&action=thumbchange_confirmed" class="btn btn-sm btn-warning" style="background-color:;">Change Thumbnail to Default</a>
		
		<?php if ($Global['webpage_name'] == 'SocialPaysMe.com') { ?>
		<a href="https://sharethisagain.com/ads/thumb-update.php?c=<?php echo $c; ?>&action=thumbchange_confirmed" class="btn btn-sm btn-info" style="background-color:;">Change Thumbnail to Default on STA</a>
		<?php } ?>
		
		</div>
		<div class="col-md-4 col-centered">
		&nbsp;
		</div>	

	<?php }
	include $Global['path'].'Sub/tpl/footer_tpl.php';
	exit;	
}

$error = '';
//include './../Inc/Header.inc.php';
//$pageColor = 'white';
echo '<div style="text-align:center; background-color:#F2F3F4">';
echo '<br/><h2 style="color:#">Campaign Management System</h2>';
//if ($_REQUEST['action'] != 'update') {
	echo '<a href="../dashboard.php" class="btn btn-sm btn-info" style="background-color:;">Promotion Dashboard</a>&nbsp;';
//} else if ($_REQUEST['action'] == 'update') {
	echo '<a href="index.php?show_index=yes" class="btn btn-danger btn-sm" style="background-color:;">Admin Dashboard</a>';
//}
if (isset($_REQUEST['action']) && $_REQUEST['action'] == 'update') {
	echo '<a href="campaigns_manage.php" class="btn btn-sm btn-warning" style="background-color:;">Campaign Manager</a>';
}

if (isset($_REQUEST['username']) && $_POST['username'] != '') {
	$collapse = '';
} else {
	$collapse = 'collapse';
}
?>

<button type="button" class="btn btn-primary btn-sm" data-target="#search" data-toggle="collapse">
Show Search
</button>

<br/>
<style>
table, td, th {
    border: 1px solid #CCCCCC;
	padding:3px;
	width:1100px;
	text-align:center;
}
table {
	background-color:#fff;
}
h4 {
	font-weight:bold;
}
</style>

<?php
//////////////////////////////////////////////////////////////////// ALL UPDATES HAPPEN UP HERE!!!!!!!!!!!!!!!!!!!!!!
if (isset($_REQUEST['action']) && $_REQUEST['action'] == 'delete' && $idx != '') {
	
	$selectFields = 'adcredits, ID, short';
	$mainTable = 'campaigns';
	$where = [
		'idx' => ['=', $idx]
	];
	$show_debug = 1;

	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, $show_debug);
	$buffer = isset($result[0]) ? $result[0] : null;
	
	
	$adcredits = $buffer['adcredits'];
	$ID = $buffer['ID'];
	$short_to_delete = $buffer['short'];
	
	$table = 'campaigns';
	$where = [
		'idx' => ['=', $idx]
	];
	delete($table, [], $where, null, 1, 1, 1);

	$table = 'shares';
	$where = [
		'share' => ['=', $short_to_delete]
	];
	delete($table, [], $where, null,  1, 1, 1);

	// ADD THE REMAINING AD CREDITS FROM THIS CAMPAIGN BACK TO USER ACCOUNT! 
	$table = 'members';
	$data = [
		'user_credits' => ['expression', 'user_credits'.'+'.$adcredits]
	];
	$where = [
		'ID' => ['=', $ID]
	];
	$show_debug = 0; // Adjust this as needed for debugging

	update($table, $data, [], $where, 0, $show_debug);
	echo "Campaign Deleted Successfully! <br><br>";
}  

if (isset($_REQUEST['action']) && $_REQUEST['action'] == 'make_pending' && $idx != '') {
			
	$table = 'campaigns';
	$data = [
		'status' => '0',
		'admin_id' => $AID,
		'moderated' => $datetime
	];
	$where = [
		'idx' => ['=', $idx]
	];
	$live = 1;
	$show_debug = 1;

	update($table, $data, [], $where, $live, 1, $show_debug);
	
	$whereMain['idx'] = ['=', $idx];
	echo "Campaign Made Pending! <br><br>";	
	
} 

if (isset($_REQUEST['action']) && $_REQUEST['action'] == 'thumbchange_confirmed' && $c != '') {

	$selectFields = 's.*, c.idx, c.ID, c.name, c.status';
	$mainTable = ['table' => 'shares', 'as' => 's'];
	$joinConditions = [
		['table' => 'campaigns', 'as' => 'c', 'condition' => 's.share = c.short']
	];
	$where = [
		's.share' => ['=', $c]
	];
	$orderBy = 'c.status DESC, s.idx DESC';
	$limit = 1;
	$show_debug = 1;

	$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, $orderBy, $limit, $show_debug);
	$buffer = isset($result[0]) ? $result[0] : null;

	if ($debug) {
		$debug_text .= '<br><br><b>MASTER QRY </b>' . var_export($result, true) . '<br/><br>';
	}

	
	//$debug = true;
	$embed_code = $buffer['embed'];
	$use_default_thumb = true;
	$type = $buffer['type'];
	//include $Global['path'].'ads/get-thumb.php';
	
	$imagePath = $Global['path']."images/default_video_thumb.jpg";
	$newPath = $Global['path']."/images/".$type."/";
	$ext = '.jpg';
	$newName  = $newPath.$embed_code.$ext;

	$copied = copy($imagePath, $newName);

	if ((!$copied)) 
	{
		echo "Error : Not Copied";
	}
	else
	{ 
		echo "Copied Successful";
	}

	//echo "Campaign Updated Successfully! <br><br>";	
}

//if ($_POST != '') {
	//if ($debug == true) 
		//echo $idx;
	//exit;
//}

if (isset($_REQUEST['action'], $_REQUEST['approve'], $_REQUEST['confirmed'], $idx) && 
    $_REQUEST['action'] == 'update' && 
    $_REQUEST['approve'] === '' && 
    $idx != '' && 
    $_REQUEST['confirmed'] != 'yes') {
	// GET REJECTION FEEDBACK!
		
	echo '<div class="row">
    <div class="form-group col-md-4 col-md-offset-4 text-align:center"><h4>Please Enter Rejection Reason:</h4>

	<form method="post" action="campaigns_manage.php?action=update&idx='.$idx.'&c='.$c.'&confirmed=yes">
	<select class="form-control" name="rej_reason_subj">
	<option value="We found inappropriate content.">Inappropriate Content
	<option value="Your video was too long. Please use content around 5 minutes or less.">Video Was Too Long
	<option value="">Other
	</select><br />
	<h4>Explain Rejection Reason For User:</h4>

	<textarea class="form-control" rows="5" cols="100%" name="rej_reason" maxlength="1000">';
	echo (!empty($_POST['rej_reason']))?$_POST['rej_reason']:'';
	echo '</textarea><br/><br /><input type="submit" class="btn btn-danger" value="Finish Processing Campaign" /></form></div></div>';
	include $Global['path'].'Sub/tpl/footer_tpl.php';	
	exit;
} else if (isset($_REQUEST['action'], $_REQUEST['confirmed'], $idx) && $_REQUEST['action'] == 'update' && $idx != '' && $_REQUEST['confirmed'] == 'yes') { // POSTING UPDATE!
		
		if ($_REQUEST['approve'] == '') {
			// REJECT CAMPAIGN
			$table = 'campaigns';
			$data = [
				'status' => '-1', 
				'admin_id' => $AID, 
				'moderated' => $datetime
			];
			$where = [
				'idx' => ['=', $idx]
			];
			$live = 1;
			$show_debug = 1;

			update($table, $data, [], $where, $live, 1, $show_debug);
			
			
			//QQQ SET UP SUPPORT TICKET, AND EMAIL THE USER!!
			
			$priority = 'High';
			
	 	} else { // APPROVE CAMPAIGNS
		
			$priority = 'Normal';
			
			$aprve_array=$_REQUEST['approve'];
			// GET MEMBER STATUS			
			$approved_status = '';
			$selectFields = 'c.status, u.ID, u.program_id, u.user_status';
			$mainTable = ['table' => 'user_program', 'as' => 'u'];
			$joinConditions = [
				['table' => 'campaigns', 'as' => 'c', 'condition' => 'u.ID = c.ID']
			];
			$where = [
				'c.idx' => ['=', $idx]
			];
			$orderBy = 'u.program_id ASC';
			$show_debug = 1;

			$result_status = select($selectFields, $mainTable, $joinConditions, $where, null, null, $orderBy, 0, $show_debug);
			$approved_status = '';

			if ($result_status && is_array($result_status)) {
				foreach ($result_status as $buffer_status) {	
					if ($debug == true) print_r($buffer_status);
					// LEAVE THIS CODE AS IS!
					if ($buffer_status['program_id'] == 1 && ($buffer_status['user_status'] == 'Active' || $buffer_status['user_status'] == 'Comped')) {
						$approved_status = 2; // STARTER MEMBER
					}
					if ($buffer_status['program_id'] == 2 && ($buffer_status['user_status'] == 'Active' || $buffer_status['user_status'] == 'Comped')) {
						$approved_status = 3; // PRO MEMBER
					}
					if ($approved_status == '')	$approved_status = 1; // FREE MEMBER
					
					if ($debug == true) echo '<br>approved_status: '.$approved_status;
				
					$table = 'campaigns';
					$data = [
						'status' => $approved_status,
						'admin_id' => $AID,
						'moderated' => $datetime
					];
					$where = [
						'idx' => ['=', $idx]
					];
					$live = 1;
					$show_debug = 1;

					// Update a single campaign
					update($table, $data, [], $where, $live, 1, $show_debug);

					// Update multiple campaigns
					foreach ($aprve_array as $val) {
						$where = [
							'idx' => ['=', $val]
						];
						update($table, $data, [], $where, $live, 1, $show_debug);
					}
					
					$mem_id = $buffer_status['ID'];
					
					if ($buffer_status['status'] > 0) { // USER WAS ALREADY APPROVED! EXIT NOW.
						echo 'This Campaign was already approved!';
						include $Global['path'].'Sub/tpl/footer_tpl.php';
						exit;
					}
				} // END LOOP
			} // END RESULT
			
			$selectFields = 'Username';
			$mainTable = 'members';
			$where = [
				'ID' => ['=', $mem_id]
			];
			$show_debug = 1;

			$result_mem = select($selectFields, $mainTable, [], $where, null, null, null, 0, $show_debug);
			$buffer_mem = isset($result_mem[0]) ? $result_mem[0] : null;
			
			
			
			// FINAL CAMP STATUS TYPES
			// -1 REJECTED
			//  0 PENDING
			//  1 APPROVED FREE
			//  2 APPROVED STARTER
			//  3 APPROVED PRO SUBSCRIBER (PAYMENT PLAN)
					// NOT USING - TO DETERMINE - GET LATEST PAYMENT LOG, IF AMOUNT IS LESS THAN $500, IT IS PRO SUBSCRIBER (PRO ON PAYMENT PLAN) // FOR NOW, IF THEY PAID 1000 OR MORE, WE'LL CALL THEM A PRO AFFILIATE
			//  4 APPROVED PRO ADVERTISER
			//	5 APPROVED PRO AFFILIATE
				//SUM PAYMENT LOGS WITHIN LAST YEAR FOR PROGRAM 2 WHERE PAYER_USERNAME=. IF UNDER OR == $1000, THEY ARE A PRO ADVERTISER.
				$payer = $buffer_mem['Username'];
				$selectFields = 'SUM(amount) as tot_amount';
				$mainTable = 'payment_log';
				$where = [
					'payer_username' => ['=', $payer],
					'program_id' => ['=', 2]
				];
				$limit = 0; // In case of aggregation, limit is typically not needed
				$show_debug = 1;

				// Calculating the sum of amounts
				$resultsum = select($selectFields, $mainTable, [], $where, null, null, null, $limit, $show_debug);
				$buffersum = isset($resultsum[0]) ? $resultsum[0] : null;
				
				$total_paid = $buffersum['tot_amount'];
				
				// CHK LAST LOG AMOUNT // PRO COMPED MEMBERS ALSO GET HIGHEST STATUS!
				// THEN CHECK PAYMENT PLAN FOR ADMIN FEE PAYMENTS
				
				if (($total_paid > 1000 || $_SESSION['p2_status'] == 'Comped') && $approved_status == 3) { // PRO AFFILIATE
					$final_approved_status = 5;
				} else if ($total_paid >= 1000 && $total_paid < 1100 && $approved_status == 3) { // PRO ADVERTISER
					$final_approved_status = 4;
				} else if ($total_paid < 1000 && $approved_status == 3) { // PRO SUBSCRIBER
					$final_approved_status = 3;
				}
				if ($final_approved_status == '') $final_approved_status = $approved_status;		
			
		// 7/30/18 MOVED OUT OF LOOP!
		$table = 'campaigns';
		$data = [
			'status' => $final_approved_status, 
			'admin_id' => $AID, 
			'moderated' => $datetime
		];
		$where = [
			'idx' => ['=', $idx]
		];
		$live = 1;
		$show_debug = 1;

		// Perform the update
		update($table, $data, [], $where, $live, 1, $show_debug);
		
	} // END APPROVING CAMPIGNS	

	$whereMain['idx'] = ['=', $idx];		
	echo "Campaign Status Updated Successfully! <br><br>";
	
	// DEFINE SUPPORT "FROM" EMAIL 
	$loggedin = $_SESSION['loggedin'];
	
	$selectFields = 'email';
	$mainTable = 'members';
	$where = [
		'Username' => ['=', $loggedin]
	];
	$show_debug = 1;

	// Execute the selection
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, $show_debug);
	$buffer = isset($result[0]) ? $result[0] : null;
	
	$support_email = $buffer['email'];

	$head = '';
	$sub = '';
	$redirect = '';
	$call_to_action = '';
	$embed = '';
	$notice = '';
	$share_wall = '';
	
	// CHECK SHARES FIRST
	$selectFields = 's.*, m.First_Name, m.Last_Name, m.email, m.Username, m.SponsorID';
	$mainTable = ['table' => 'members', 'as' => 'm'];
	$joinConditions = [
		['table' => 'shares', 'as' => 's', 'condition' => 'm.ID = s.ID']
	];
	$where = [
		's.share' => ['=', $c]
	];
	$show_debug = 1;

	// Perform the join and selection
	$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, 0, $show_debug);
	$buffer = isset($result[0]) ? $result[0] : null;

	$username = $buffer['Username'];
	if (!empty($buffer['email'])) {
		$notice = 'Please promote or share your campaign link now:';
	
		if ($buffer['type'] == 'youtube') {
			$embed = 'https://www.youtube.com/watch?v='.$buffer['embed'];
			$share_wall = 'Look for your share here: https://sharethisagain.com/shares.php?id='.$username;
			//$camp_link = 'https://sharethisagain.com/'.$c;
			$camp_link = 'https://sharethisagain.com/share.php?c='.$c.'&admin_preview=Y';
		} else if ($buffer['type'] == 'vimeo') {
			$embed = 'https://vimeo.com/'.$buffer['embed'];
			$share_wall = 'Look for your share here: https://sharethisagain.com/shares.php?id='.$username;
			//$camp_link = 'https://sharethisagain.com/'.$c;
			$camp_link = 'https://sharethisagain.com/share.php?c='.$c.'&admin_preview=Y';
			
		} else if ($buffer['type'] == 'tweet') {
			$embed = $buffer['embed'];
			$share_wall = 'Look for your tweet here: https://sharemytweet.com/share.php?id='.$username;
			//$camp_link = 'https://sharemytweet.com/'.$c;
			$camp_link = 'https://sharemytweet.com/share.php?c='.$c.'&admin_preview=Y';
		}

		if ($share_wall != '') { // MEMBERS SHARE WALL - TO FIND THEIR SHARE TO EDIT (THUS VIEWING MORE SHARES ALSO)
			$edit_link = $Global['webpage_url_ssl'].'ads/view.php';
		} else { // DIRECT AD CAMPAIGN EDIT LINK - SHOWN WHEN IT IS NOT A SHARE
			$edit_link = $Global['webpage_url_ssl'].'ads/campaign-creator.php?edit='.$c;
		}
		if ($buffer['headline'] != '') $head = 'Headline: '.$buffer['headline'];
		if ($buffer['subhead'] != '') $sub = 'Sub Headline: '.$buffer['subhead'];
		if ($buffer['redirect'] != '') $redirect = 'Redirect Link: '.$buffer['redirect'];
		if ($buffer['text'] != '') $call_to_action = 'Call To Action: '.$buffer['text'];
			
	// IF NO RESULTS, THEN CHECK ONLY CAMPAIGNS
	} else if (empty($buffer['email'])) {

		$selectFields = 'c.*, m.First_Name, m.Last_Name, m.email, m.Username, m.SponsorID';
		$mainTable = ['table' => 'members', 'as' => 'm'];
		$joinConditions = [
			['table' => 'campaigns', 'as' => 'c', 'condition' => 'm.ID = c.ID']
		];
		$where = [
			'c.short' => ['=', $c]
		];		
		$show_debug = 1;

		$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, 0, $show_debug);
		$buffer = isset($result[0]) ? $result[0] : null;
		
	}
	
	if ($buffer['adtype'] == 'share' || $buffer['adtype'] == 'tweet' || $buffer['adtype'] == 'url') {
		$notice = 'Please promote or share your campaign link now:';
	} else {
		$notice = 'Your ad is now in rotation in our members area.';
		$camp_link = $Global['webpage_url_ssl'].'login.php';
		$share_wall = '';
	}
	
	if ($buffer['adtype'] == 'url') $camp_link = $Global['webpage_url_ssl'].$c;
	if ($camp_link == '') $camp_link = $Global['webpage_url_ssl'].'?c='.$c;
	
	// QQQ SHORT TERM SOLUTION - ONCE PAGES GET MERGED, USE ONLY THE 2ND LINK BELOW!!
	if ($buffer['adtype'] == 'share' || $buffer['adtype'] == 'tweet') {
		$edit_link = $Global['webpage_url_ssl'].'ads/add-share.php?s='.$c;
	} else {
		$edit_link = $Global['webpage_url_ssl'].'ads/campaign-creator.php?edit='.$c;
	}
	$email = $buffer['email'];	
	
// EMAIL THE USER!
$sitename = $Global['webpage_name'];
$fromemail = $Global['admin_email'];
$name = $buffer['First_Name'].' '.$buffer['Last_Name'];
$username = $buffer['Username'];
$SponsorID = $buffer['SponsorID'];

$campname = $buffer['name'];

// THIS WAS CREATED FOR USE ON JV PARTNERS, WHO HELP MAY HELP MODERATE POSTS IN THE FUTURE.
// COMMENTING NOW, SINCE I HAVE BEEN SENDING POSTS FROM USERS OWN LOGIN SESSIONS (LOGGED IN AS THAT USER), WHICH ENDS UP SHOWING THEM THEIR OWN NAME AS THE SIG - BAD FORM!! SO UNTIL THIS GETS FIXED, NOW USING "JIM" AS SENDER
// TO FIX THIS, NEED TO LOOK UP USER IN MEMBERS TABLE. IF STATUS == 'JV', THEN USE THIER LOGGEDIN NAME, ELSE USE "JIM".
//$tech_name = $_SESSION['Firstname_loggedin'].' '.$_SESSION['Lastname_loggedin'];

//$tech_name = $sitename.' Bot';
//$tech_name = 'Monique W.'; 

$rej_reason_subj = $_POST['rej_reason_subj'];
$rej_reason_comments = $_POST['rej_reason'];

//if ($rej_reason_subj = 'Other') $rej_reason_subj = '';

$rej_reason = 'Reason for rejection: '.$rej_reason_subj.' '.$rej_reason_comments;

$subject_text = "Your Campaign Has Been Rejected - Your Attention Required!";

$message_text = "Hi {$name},

We had to reject your campaign: {$campname}

This campaign link is broken, or contains negative or inappropriate material.

{$head} {$sub}

{$embed}

{$redirect} {$call_to_action}

{$rej_reason}

Please edit this campaign accordingly, so it may be approved.

Go here to edit: {$edit_link}

Thanks for using {$sitename}!

Sincerely,
{$tech_name}
{$sitename} Support";


if ($priority == 'Normal') {
	
$subject_text = "Your Campaign Has Been Approved!";

$message_text = "Hi {$name},

Congrats! Your campaign: {$campname} has just been approved.

{$notice}

{$camp_link}

{$share_wall}

Thanks for using {$sitename}!

Sincerely,
{$tech_name}
{$sitename} Support";
}

$message_text = str_replace('\r\n', '', $message_text);
$message_text = str_replace('\n', '', $message_text);
$message_text = str_replace('\r', '', $message_text);

$message_text = htmlspecialchars(trim($message_text));
$subject_text = htmlspecialchars(trim($subject_text));

if ($use_sendgrid == true) {
	sendgrid_email($email,$subject_text,$message_text);
} else {
	mail($email,$subject_text,$message_text,"From: {$sitename} <{$fromemail}>\r\n","-f{$fromemail}");	
}

// PREVENT SQL INJECTION!

$subject = $subject_text;
$message = $message_text;
$loggedin_username = $_SESSION['loggedin'];

$HTTP_USER_AGENT = sanitize($_SERVER['HTTP_USER_AGENT']);
$HTTP_REFERER = sanitize($_SERVER['HTTP_REFERER']); 
$REMOTE_HOST = sanitize($_SERVER['REMOTE_HOST']);
$REMOTE_ADDR = sanitize($_SERVER['REMOTE_ADDR']);

$datetime = date("Y-m-d H:i:s");


// DB INSERT HERE
if (!isset($c)) $c = '';
if (!isset($name)) $name = '';
if (!isset($username)) $username = '';
if (!isset($loggedin_username)) $loggedin_username = '';
if (!isset($fromemail)) $fromemail = '';
if (!isset($email)) $email = '';
if (!isset($subject)) $subject = '';
if (!isset($message)) $message = '';
if (!isset($datetime)) $datetime = '';
if (!isset($priority)) $priority = '';
if (!isset($SponsorID)) $SponsorID = '';
if (!isset($REMOTE_ADDR)) $REMOTE_ADDR = '';
if (!isset($HTTP_USER_AGENT)) $HTTP_USER_AGENT = '';
if (!isset($HTTP_REFERER)) $HTTP_REFERER = '';
if (!isset($REMOTE_HOST)) $REMOTE_HOST = '';

$table = 'support_tickets';
$data = [
    'ticket_id' => $c,
    'status' => 'closed',
    'name' => $name,
    'username' => $username,
    'loggedin' => $loggedin_username,
    'email' => $fromemail,
    'sent_to' => $email,
    'subject' => $subject,
    'message' => $message,
    'datetime' => $datetime,
    'priority' => $priority,
    'sponsor' => $SponsorID,
    'ip' => $REMOTE_ADDR,
    'HTTP_USER_AGENT' => $HTTP_USER_AGENT,
    'HTTP_REFERER' => $HTTP_REFERER,
    'REMOTE_HOST' => $REMOTE_HOST
];
$live = 1;
$show_debug = 1;

// Execute the insert operation
insert($table, $data, $live, $show_debug);


// END EMAILING THE USER	

} // END UPDATE

//$GLOBALS['debug'] = true;
if (isset($_REQUEST['action']) && $_REQUEST['action'] == 'deny') {
    $key = sanitize($_REQUEST['c'], 'key'); // Assume sanitize is your custom function for cleaning input
    // Update campaign status
    $updateData = [
        'status' => -1
    ];
    update('campaigns', $updateData, [], ['short' => ['=', $key]], 1, 1, 1);

    // Retrieve ad credits and ID for the campaign
    $selectFields = 'adcredits, ID';
    $mainTable = 'campaigns';
    $where = ['idx' => ['=', $key]];
    $result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
	//$buffer = isset($result[0]) ? $result[0] : null;
    $rows = is_array($result) ? count($result) : 0;

	/*// GIVE CREDITS BACK TO USERS - DON'T DO THIS NOW! - THEY MAY EDIT CAMPAIGN. WE DO THIS WHEN THEY DELETE!
    if ($rows > 0) {
        foreach ($result as $buffer) {
            $adcredits = $buffer['adcredits'];
            $member_id = $buffer['ID'];

            // Update member credits
            $updateData = [
                'user_credits' => ['expression' => 'user_credits + ' . $adcredits]
            ];
            update('members', $updateData, [], ['ID' => ['=', $member_id]], 1, 1, 1);
        }
    }*/
    echo 'Campaign Status Updated Successfully! <br><br>';
	//exit;
}



/*	// SAVE FOR SENDING SOLO IDEAS	
if ($adinfo['subject'] != '') {
	$solo = "insert into soload_send_email set email_subject='".mysql_real_escape_string($adinfo['subject'])."',email_text='".mysql_real_escape_string($adinfo['email_message'])."',email_date=NOW()";
		
	//mysql_query("insert into soload_send_email_member set email_id='".$emailid."',ID='".$mrow['ID']."' ");
}*/	 

///////////////////////////////////////// END ALL UPDATES!!!!!!!!!!!!!
?>
<div id="search" class="<?php echo $collapse;?>">
	<div class="col-md-4 col-centered">
	&nbsp;
	</div>
	<div class="col-md-4 col-centered">	
	<br/>
<form method="post" name="myForm" onsubmit="document.getElementById('submit').disabled=true; document.getElementById('submit').value='Submitting, please wait...';">

	<input class="form-control" style="margin: 0 auto; width:250px;" onMouseover="this.focus()" size="10" name="username" value="<?php if(isset($_POST['username'])) : echo $_POST['username']; else : echo ''; endif; ?>" id="inputSuccess" placeholder="Search Username">
		
<input type="submit" value="Search Username" name="search" id="submit" class="btn btn-block btn-info btn-default">
</form>	
	<br/>
<form method="post" name="myForm2" onsubmit="document.getElementById('submit').disabled=true; document.getElementById('submit').value='Submitting, please wait...';">

	<input class="form-control" style="margin: 0 auto; width:250px;" onMouseover="this.focus()" size="10" name="short" value="<?php if(isset($_POST['short'])) : echo $_POST['short']; else : echo ''; endif; ?>" id="inputSuccess" placeholder="Search Campaign Short URL">
		
<input type="submit" value="Search Campaign Short URL" name="search" id="submit2" class="btn btn-block btn-info btn-default">
</form>
<br/><br/>	
</div>

	<div class="col-md-4 col-centered">
	&nbsp;
	</div>

	<div class="clearfix"></div>
</div>
Filter: &nbsp;<a href="?type=share">Videos</a> &nbsp;&nbsp;

<a href="?type=url">Tracking Links</a> &nbsp;&nbsp;

<a href="?type=text">Text Ads</a> &nbsp;&nbsp;<a href="?type=banner">Banner Ads</a>&nbsp;&nbsp;
 
<a href="?type=solo">Solo Ads</a> &nbsp;&nbsp;<a href="?type=te">TE Ads</a>&nbsp;&nbsp;

<a href="?type=login">Login Ads</a> &nbsp;&nbsp;<a href="?type=logout">Logout Ads</a>&nbsp;&nbsp;
 
<br /><br />
<!--
<a href="campaigns_manage.php?status=1&traffic_delivered=Y" class="btn btn-primary btn-xs">Traffic Delivered</a> &nbsp;&nbsp;&nbsp;   
<a href="campaigns_manage.php?status=1&traffic_started=Y" class="btn btn-success btn-xs">Traffic In Progress</a> &nbsp;&nbsp;&nbsp;-->
<a href="campaigns_manage.php?status=1" class="btn btn-success btn-xs">All Approved</a> &nbsp;&nbsp;&nbsp;
<a href="campaigns_manage.php?status=denied" class="btn btn-danger btn-xs">All UnApproved</a> &nbsp;&nbsp;&nbsp;
<a href="campaigns_manage.php?status=0" class="btn btn-warning btn-xs">All Pending</a> &nbsp;&nbsp;&nbsp;
<a href="campaigns_manage.php?status=all" class="btn btn-info btn-xs">All</a> &nbsp;&nbsp;&nbsp;
   
<p></p>
<a href="javascript:SetAllCheckBoxes('myForm', 'approve[]', false);" class="btn btn-info btn-xs">Deselect All</a>
<a href="javascript:SetAllCheckBoxes('myForm', 'approve[]', true);" class="btn btn-info btn-xs">Select All</a> 
<p></p>

<form action="" method="post" name="myForm" ENCTYPE="multipart/form-data">
<input type="hidden" name="action" value="update">
<table style="margin: auto;">


<?php
$whereMain['name'] = ['!=', 'My Affiliate Link']; //  DO NOT SHOW AFF LINK CAMPS!

if (isset($_REQUEST['traffic_delivered']) && $_REQUEST['traffic_delivered'] != 'Y') $whereMain['adcredits'] = ['>', 0];  // TTR TWEAK FOR TRAFFIC CAMPGAINS - HE ONLY WANTS TO SEE THOSE OWED TRAFFIC!
//get the count of the campaigns
$selectFields = 'COUNT(idx) AS cnt';
$mainTable = 'campaigns';
$show_debug = $debug ? 1 : 0;

// Execute the selection
$result = select($selectFields, $mainTable, [], $whereMain, null, null, null, 0, $show_debug);
$cmpinfo = isset($result[0]) ? $result[0] : null;


echo '<h4>'.$cmpinfo['cnt'].' Total Results</h4>';

//paging params
$results_per_page = 25;
$total_pages = ceil($cmpinfo['cnt']/$results_per_page);
$page = (isset($_GET['page']) && ctype_digit((string)$_GET['page']) ? $_GET['page']:1);
if ($page > $total_pages && $total_pages > 0) {
	$page = $total_pages;
} elseif ($page < 1) {
	$page = 1;
}

//styling results table
$nr = 1;
//$color[0] = 'FFFFFF';
$color[0] = 'F2F3F4';
$color[1] = 'F2F3F4';

$selectFields = '*';
$mainTable = 'campaigns';
$orderBy = 'idx DESC';
$offset = ($page - 1) * $results_per_page;
$limit = [
    'offset' => $offset,	
    'count' => $results_per_page
];
$show_debug = 1;

// Execute the selection with pagination
$resultcmp = select($selectFields, $mainTable, [], $whereMain, null, null, $orderBy, $limit, $show_debug);

// Assuming you process the results similarly
foreach ($resultcmp as $cmpinfo) {

	$selectFields = '*';
	$mainTable = 'members';
	$where = [
		'ID' => ['=', $cmpinfo['ID']]
	];
	$show_debug = 1;

	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, $show_debug);
	$member_info = isset($result[0]) ? $result[0] : null;
	

	$sel1='';
	$sel2='';
	if($cmpinfo['status']=="-1"){$sel1='selected';$sel2='';}
	if($cmpinfo['status']>"0"){$sel2='checked';$sel1='';}

	$type = $cmpinfo['adtype'];
	if($cmpinfo['adtype']=='solo') $campaign='Solo Ad';
	if($cmpinfo['adtype']=='text') $campaign='Text Ad';
	if($cmpinfo['adtype']=='banner') $campaign='Banner Ad';
	if($cmpinfo['adtype']=='te') $campaign='Traffic Exchange Ad';
	if($cmpinfo['adtype']=='login') $campaign='Login Ad';
	if($cmpinfo['adtype']=='logout') $campaign='Logout Ad';
	if($cmpinfo['adtype']=='share') $campaign='Share';
	if($cmpinfo['adtype']=='tweet') $campaign='Tweet';
	if($cmpinfo['adtype']=='url') $campaign='URL';	
	
	$c = $cmpinfo['short'];
	?>
	
<tr>
<th>CID</th>
<th>Username</th>
<th>Campaign Name</th>
<th>Campaign Short URL</th>
<th>Type</th>
<th>Approve</th>
</tr>	
	
	<tr style="background-color:#<?php echo (($nr % 2 == 0)?$color[0]:$color[1]); ?>">
	<td><?php echo $cmpinfo['idx']; ?></td>
	<td><a href="/admin/Sub/Finduser.php?username=<?php echo $member_info['Username'];?>" target="_blank"><?php echo $member_info['Username']; ?></td>
	<td><?php echo $cmpinfo['name']; ?></td>
	<!-- WILL BE WRONG LINK QUITE OFTEN HERE, SO ONLY SHOW THE SHORT CAMP CODE!!
	<td><a href="<?php echo $Global['webpage_url_ssl'].$cmpinfo['short'];?>" target="_blank"><?php echo $cmpinfo['short']; ?></a></td>-->
	
	<!-- SHORT SHORT CODE - AND MAKE IT LOGIN AS MEMBER TO THEIR PROMO DASHBOARD -->
	<td><a href="/admin/Sub/memberlogin.php?id=<?php echo $member_info['ID']; ?>&prd=ads/campaign-stats.php" target="_blank">
	<?php echo $cmpinfo['short']; ?></a>
	&nbsp;
	<small><a href="campaigns_manage.php?shortchange=<?php echo $cmpinfo['short']; ?>"><i class="fa fa-pencil-square-o" style="color:#00b3fe" aria-hidden="true" title="Change Short URL Code"></i></a>
	</small>
	
	<small><a href="campaigns_manage.php?c=<?php echo $c; ?>&action=thumbchange_confirm"><i class="fa fa-pencil-square-o" style="color:#00b3fe" aria-hidden="true" title="Change Thumbnail To Default"></i></a>
	</small>
	
	
	</td>	
	
	<td><?php echo $campaign; ?></td>
 
	<td>
	<?php if (true || $member_info['user_credits'] > 0) { 
	$sel2='';
	?>
	<input type="checkbox" <?php echo $sel2;?> name="approve[]" value="<?php echo $cmpinfo['idx'];?>">
	<input type="hidden" name="idx['<?php echo $cmpinfo['idx'];?>']" value="<?php echo $cmpinfo['status'];?>">
	<?php } ?>
	</td>
	</tr>
	<tr>
	<td colspan="6">
	<?php
	$title = '';
	$url = stripslashes($cmpinfo['url']);
	//echo '<b><a href="'.$url.'" target="_blank">'.$url.'</a></b>';
	//if ($cmpinfo['banneradurl']) $purl=str_replace("http://","",$cmpinfo['banneradurl']);
	$purl=str_replace("http://","",$cmpinfo['url']);
	$purl=str_replace("www.","",$purl);

	/* // NOT GOING TO POLICE URLS NOW
	if ($url != '') {
		$qry_url = "SELECT status FROM url_list WHERE url like '%".$purl."%'";
		if ($debug == true) echo "<br/>".$qry_url."<br/>";
		$result_url = mysql_query($qry_url) or die($qry_url.' '.mysql_error());
		
		while ($urllistinfo = mysql_fetch_array($result_url)) {
			
			if ($debug == true) print_r($urllistinfo);
				
			if ($urllistinfo['status'] == 'bad') { // QQQ TEST CLASSES - ADD CLASS HERE
				$title = '<h4 class="text-danger">URL REJECTED</h4>';
			} else if ($urllistinfo['status']=='pending')	{
				$title = '<h4 class="text-info">URL PENDING APPROVAL</h4>';
			} else if ($urllistinfo['status']=='good')	{
				$title = '<h4 class="text-success">URL APPROVED</h4>';
			} 
			
			if ($title == '' && $buffer['adtype'] != 'share' && $buffer['adtype'] != 'tweet') 
			$title = '<h4 class="text-danger">URL NOT FOUND IN URL LIST!</h4>';
			
		} // END LOOP FOR URL LIST
	} // END URL IS NOT EMPTY */
	if ($cmpinfo['status'] == 5) {
		$title .= '<h4 class="text-success">APPROVED (PRO AFFILIATE)</h4>';
	} else if ($cmpinfo['status'] == 4) {
		$title .= '<h4 class="text-success">APPROVED (PRO ADVERTISER)</h4>';
	} else if ($cmpinfo['status'] == 3) {
		$title .= '<h4 class="text-success">APPROVED (PRO SUBSCRIBER)</h4>';
	} else if ($cmpinfo['status'] == 2) {
		$title .= '<h4 class="text-success">APPROVED - <u>'.$cmpinfo['stcredits'].'</u> CREDITS SPENT - <u>'.$cmpinfo['adcredits'].'</u> CREDITS LEFT</h4>';
	} else if ($cmpinfo['status'] == 1) {
		$title .= '<h4 class="text-success">APPROVED (FREE)</h4>';
	} else if ($cmpinfo['status'] == 0) {
		$title .= '<h4 class="text-warning">PENDING APPROVAL</h4>';	
	} else if ($cmpinfo['status'] == -1) {
		$title .= '<h4 class="text-danger">REJECTED</h4>';
	}
	echo '<input type="hidden" name="deny['.$cmpinfo['idx'].']" value="1">';

	echo $title; 
	//echo '<b>Subject</b>: '.stripslashes($cmpinfo['subject']).'<br/>';
	//echo '<br/><b>Body</b>: '.stripslashes($cmpinfo['body']);
					
	//echo '<b>Email Subject</b> <br>'.stripslashes($cmpinfo['email_subject']);
	//echo '<br><b>Email Message</b> <br>'.stripslashes($cmpinfo['email_message']);
	$short = '';
	$share = '';
	
	$short = $cmpinfo['short'];
	$share = $cmpinfo['short'];
	
	if ($type == 'share' || $type == 'tweet') {

		$selectFields = '*';
		$mainTable = 'shares';
		$where = [
			'share' => ['=', $short]
		];
		$show_debug = 1;

		// Execute the selection for shares
		$result_share = select($selectFields, $mainTable, [], $where, null, null, null, 0, $show_debug);

		$title = '';
		foreach ($result_share as $buffer) {
			
		if ($debug == true) print_r($buffer);
		$embed = '';
		$headline = '';
		$subhead = '';
		$share = $buffer['share'];
		$url = '';

		if ($type == 'share' || $type == 'tweet') { // THIS IS A SHARE
			//$thumbnail_img = "https://img.youtube.com/vi/".$buffer['embed'] . "/0.jpg";
			//$thumbnail_img = "https://i3.ytimg.com/vi/".$buffer['embed']."/hqdefault.jpg";
			$embed = $buffer['embed'];
			$embed_type = $buffer['type'];
			$headline = $buffer['headline'];
			$subhead = $buffer['subhead'];	
		
			if ($buffer['type'] == 'tweet') {
				$url_root = "https://sharemytweet.com/";
			} else {
				$url_root = "https://sharethisagain.com/";
			}
			//$url = $url_root.$share;
			$url = $url_root.'share.php?c='.$share;
		} /*else if ($type == 'url') { // TYPE IS URL - SHORT URL REDIRECT LINK
			$headline = $buffer['subject'];
			$subhead = $buffer['body'];
			$share = $buffer['short'];	
			$url_root = $Global['webpage_url_ssl'];
			$url = $url_root.$buffer['short'];
		} else { // TYPE IS AN AD
			$headline = $buffer['subject'];
			$subhead = $buffer['body'];
			$share = $buffer['short'];	
			$url_root = $Global['webpage_url_ssl'];
			$url = $url_root.'ads?c='.$buffer['short'];
		}*/
		
		if (strpos($embed_type, 'youtube') !== false) {

			//https://www.youtube.com/embed/

			$yt_id = substr($embed, 30, 100); // STRIP AWAY FIRST 30 DIGITS, TO GET ONLY THE CAMP ID!
			$thumbnail_img = "https://i3.ytimg.com/vi/".$yt_id.$embed."/hqdefault.jpg";

		} else if (strpos($embed_type, 'vimeo') !== false) {

			$thumbnail_img = "/images/vimeo.png";
		}
		echo $thumbnail;
	?><!--
		<h4>
		<i class="fa fa-arrow-circle-right fa-lg" style="color:#00b3fe"></i> &nbsp;&nbsp;<?php echo '<a href="'.$url.'" target="_blank">Review This Share</a>';
		?>	</h4>-->
	<?php	
		} // END SHARE LOOP
	} // END TYPE IS SHARE	
	
	if ($type == 'url') { // TYPE IS URL - SHORT URL REDIRECT LINK
			//$headline = $buffer['subject'];
			//$subhead = $buffer['body'];
			//$share = $buffer['short'];	
			$url_root = $Global['webpage_url_ssl'];
			$url = $url_root.$cmpinfo['short'];
	} else if ($type == 'text' || $type == 'banner' || $type == 'solo' || $type == 'te' || $type == 'login' || $type == 'logout') { // TYPE IS AN AD
			//$headline = $buffer['subject'];
			//$subhead = $buffer['body'];
			//$share = $buffer['short'];	
			$url_root = $Global['webpage_url_ssl'];
			$url = $url_root.'ads?c='.$cmpinfo['short'].'&ADMIN_PREVIEW=Y';
	}	
	if ($cmpinfo['banners'] != '') {
	
		//echo '<b>Banner Ad Code</b> <br>'.stripslashes($cmpinfo['banners']);
		//echo '<br><b>Banner URL</b> <a href="'.$url.'" target="_blank">'.$url.'</a>';
			
		// NEXT LINE APPEARS BAD SYNTAX, ALSO NOT NEEDED
		//$bnrsids="('".str_replace(":","','",$cmpinfo['banners']
		//SO NOW DOING THIS INSTEAD
		$bnrsids=$cmpinfo['banners'];
		
		echo "<br>";
		$selectFields = '*';
		$mainTable = 'banners';
		$where = [ 'bannerid' => ['IN', explode(',', $bnrsids)] ];	
		$limit = 1;
		$show_debug = 1;

		// Execute the selection for banners
		$result_banners = select($selectFields, $mainTable, [], $where, null, null, null, $limit, $show_debug);
		
		$cmpbanners = ''; // INI VAR! OR SHOWS PRIOR BANNERS IN RESULTS
		
		// WHILE LOOP IS TO SUPPORT ROTATING BANNERS, NOT USING AT THIS TIME, BUT MAY BRING BACK!
		foreach ($result_banners as $cmpbrow) {
			$cmpbanners .= "<img src='/images/banners/".$cmpbrow['bannername']."'><br>";
		}
		
		echo $cmpbanners;

	} ?>
		<h4>
		<i class="fa fa-arrow-circle-right fa-lg" style="color:#00b3fe"></i> &nbsp;&nbsp;<?php echo '<a href="'.$url.'" target="_blank">Review Campaign</a> | <a href="/admin/Sub/memberlogin.php?id='.$member_info['ID'].'&prd=ads/campaign-stats.php" target="_blank">See Camp Stats</a>';
		?>	</h4>		
	
<?php
	
	// PAGINATION PARAMETERS
	$ptr = ''; // Initialize the $ptr variable.

	if (isset($_REQUEST['status'])) {
		$ptr .= 'status=' . $_REQUEST['status'] . '&';
	}

	if (isset($_REQUEST['type'])) {
		$ptr .= 'type=' . $_REQUEST['type'] . '&';
	}

	?><br />
	
<a OnClick="return confirm('Are You Sure?');" href="campaigns_manage.php?action=delete&idx=<?php echo $cmpinfo['idx']; ?>" class="btn btn-danger btn-xs">Delete Campaign</a>

<?php if ($cmpinfo['status'] != 0) { ?>
<a href="campaigns_manage.php?action=make_pending&idx=<?php echo $cmpinfo['idx']; ?>&confirmed=yes" class="btn btn-warning btn-xs">Make Pending</a>	

<?php } 
if ($cmpinfo['status'] !='-1') { ?>
<a href="campaigns_manage.php?action=deny&idx=<?php echo $cmpinfo['idx']; ?>&c=<?php echo $share; ?>" class="btn btn-warning btn-xs">Disapprove Campaign</a>

<?php } 
if ($cmpinfo['status'] < 1) { ?>
<a href="campaigns_manage.php?action=update&idx=<?php echo $cmpinfo['idx']; ?>&approve=<?php echo $cmpinfo['idx']; ?>&c=<?php echo $share; ?>&confirmed=yes" class="btn btn-success btn-xs">Approve Campaign</a>
<?php } ?>

<?php
if ($cmpinfo['status'] > 0) { ?>
<a href="../../admin/Sub/mailmembers.php?&c=<?php echo $share; ?>" target="_blank" class="btn btn-primary btn-xs">Email Campaign</a>
<?php } ?>
<br/><br/>	
</td>
</tr>
<?php
	++$nr;
} // END LOOP	
?>

<tr>
<td colspan="4" align="right">
<?php echo pagination_links($page, $total_pages, 6, 'campaigns_manage.php?'.$ptr, array('page' => 'Page', 'first' => 'first', 'last' => 'last' )); ?>
</td>
</tr>
</table>

<input type="submit" name="submit" value="Approve" class="btn btn-success btn-lg">
</form>
</div>
<?php //include './../Inc/Footer.inc.php'; 
include $Global['path'].'Sub/tpl/footer_tpl.php';
?>