<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
//include '../Members/logincheck.php'; // DO NOT USE HERE!! WE'RE COUNTING IMPRESSIONS FROM THE PUBLIC, WHO ARE NOT LOGGED IN!
include ''.$_SERVER['DOCUMENT_ROOT'].'/Sub/Config.inc.php';
include ''.$_SERVER['DOCUMENT_ROOT'].'/phpcpr.php';

//include './../Sub/Config.inc.php';
//include './../phpcpr.php';

//$campurl = sanitize(trim($_REQUEST['campurl']), 'campurl');
$campurl = sanitize(trim($_REQUEST['c']));
$bannerid = sanitize(trim($_REQUEST['bannerid']));

//$campurl = trim($_REQUEST['c']);
//$bannerid = trim($_REQUEST['bannerid']);

// Select campaign info
$selectFields = '*';
$mainTable = 'campaigns';
$where = [
    'short' => ['=', $campurl]
];
$show_debug = 1;
$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, $show_debug);
$campinfo = isset($result[0]) ? $result[0] : null;

// Select banner info
$selectFields = 'bannername';
$mainTable = 'banners';
$where = [
    'bannerid' => ['=', $bannerid]
];
$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, $show_debug);
$banner_info = isset($result[0]) ? $result[0] : null;

// Banner imps count
$selectFields = '*';
$mainTable = 'banner_stats';
$where = [
    'banner_id' => ['=', $bannerid],
    'campaign_id' => ['=', $campinfo['idx']]
];
$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, $show_debug);
$bnrs_imps_info = isset($result[0]) ? $result[0] : null;

if ($bnrs_imps_info) {
    // Update banner_stats
    $table = 'banner_stats';
    $data = [
        'impcount' => ['expression' => 'impcount'.'+'.'1']
    ];
    $where = [
        'impid' => ['=', $bnrs_imps_info['impid']]
    ];
    $live = 1;
    $show_debug = 1;
    update($table, $data, [], $where, $live, 1, $show_debug);
} else {
    // Insert into banner_stats
    $table = 'banner_stats';
    $data = [
        'impcount' => 1,
        'banner_id' => $bannerid,
        'campaign_id' => $campinfo['idx']
    ];
    $live = 1;
    $show_debug = 1;
    insert($table, $data, $live, $show_debug);
}

// NOW DEDUCT A CREDIT FOR THIS IMPRESSION!
// THIS SHOULD BE UPDATED TO SELECT IMPRESSION COST FROM DB, BUT FOR NOW, IT IS SIMPLY "1"
$table = 'campaigns';
$data = [
    'adcredits' => ['expression' => 'adcredits'.'-'.'1']
];
$where = [
    'short' => ['=', $campurl]
];
$show_debug = 1;

update($table, $data, [], $where, $live, 1, $show_debug);


// Assuming $banner_info['bannername'] is defined and contains a filename like 'image.jpg'
$banner_arr = explode('.', $banner_info['bannername']);

if (!empty($campinfo['idx'])) {
    // Validate if the extension is set and correct
    $file_extension = strtolower(end($banner_arr)); // Get the last element after explode, ensure it's lowercase
    $allowed_extensions = ['jpg', 'jpeg', 'png', 'gif']; // Define allowed extensions for safety

    if (in_array($file_extension, $allowed_extensions)) {
        $file_path = $Global['webpage_url'] . 'images/banners/' . $banner_info['bannername'];
        
        // Make sure the file exists to prevent errors
        if (file_exists($file_path)) {
            // It's generally safer to specify the content type explicitly rather than relying on file extension
            switch ($file_extension) {
                case 'jpg':
                case 'jpeg':
                    header('Content-Type: image/jpeg');
                    break;
                case 'png':
                    header('Content-Type: image/png');
                    break;
                case 'gif':
                    header('Content-Type: image/gif');
                    break;
                default:
                    // Handle unknown types or throw an error
                    http_response_code(404); // Not Found
                    exit('File format not supported.');
            }

            readfile($file_path); // This will output the file directly
            exit;
        } else {
            // File doesn't exist
            http_response_code(404); // Not Found
            exit('File not found.');
        }
    } else {
        // Extension not allowed
        http_response_code(400); // Bad Request
        exit('Invalid file format.');
    }
}
