<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include '../Members/logincheck.php'; 
$pageName = 'Banner Management Console'; // THIS IS SHOWN AS A BREADCRUMB UNDER THE MENU, AND IS ALSO USED AS THE PAGE TITLE, IF $pageDesc IS LEFT EMPTY.
$pageDesc = ''; // IF USED, THIS IS SHOWN AS THE TITLE IN THE PAGE (BLUE BAR SECTION, END OF HEADER), REPLACING $pageName.
$pageIcon = ''; // THE ICON USED IN THE PAGE
$pageAlign = 'center'; // HOW YOU WANT TO ALIGN THE PAGE CONTENT
$pageClass = ''; // FOR CUSTOM PROGRAMMING USES
$do_not_display_ads = true; // STOPS FILE FROM BEING INCLUDED FROM B.O. HEADER
include $Global['path'].'Sub/tpl/header_tpl.php';
include '../'.$Global['admin_dir'].'/Lib/Pagination.function.php';
echo '<h2>Banner Management System</h2>'; ?>
<p>

<?php
// MEMBER UPLOADS BANNERS
$member_id = intval($_SESSION['UserID']);

// Allowed image file types
$allowed_types = array("jpg", "jpeg", "gif", "png");

// Allowed image sizes
$allowed_sizes = [
    '125x125', // Square
    '468x60',  // Banner
    '300x250', // Medium Rectangle
    '336x280', // Large Rectangle
    '234x60',  // Half Banner
    '320x50',  // Mobile Leaderboard
];

/*$allowed_sizes = [
    '125x125', // Square
    '468x60',  // Banner
    '300x250', // Medium Rectangle
    '336x280', // Large Rectangle
    '234x60',  // Half Banner
    '728x90',  // Leaderboard
    '160x600', // Wide Skyscraper
    '120x600', // Skyscraper
    '320x50',  // Mobile Leaderboard
];*/


// Convert the allowed sizes array into a string for display
$allowed_sizes_display = implode(' or ', $allowed_sizes);
?>

We will only approve banners that are <b><?php echo $allowed_sizes_display; ?></b>.
<br>All others will go unapproved.
<br>
<br>
No spaces are allowed in the banner file name.
<br>
<br>
<b>Supported image file types are: "jpg", "jpeg", "gif", "png"</b>
<br><br>


<?php
// Upload path
$upload_path = $_SERVER['DOCUMENT_ROOT'] . '/images/banners/';

// Check for form submission and action type
if (isset($_REQUEST['action']) && $_REQUEST['action'] == 'save') {
	// Check if a file was uploaded
	if (isset($_FILES['banner']['name']) && !empty($_FILES['banner']['name'])) {
		
		// Get the file extension
		$file_info = pathinfo($_FILES['banner']['name']);
		$ext = strtolower($file_info['extension']);

		// Check if the file type is allowed
		if (in_array($ext, $allowed_types)) {
			
			// Check for spaces in file name
			if (strpos($_FILES['banner']['name'], ' ') !== false) {
				echo "<span style='color: red;'>Error: File name contains spaces. Please remove spaces from the file name before uploading.</span><br/><br/>";
				echo '<a href="banner_man.php" class="btn btn-info btn-lg">Return To Banner Upload</a>';
				include $Global['path'].'Sub/tpl/footer_tpl.php';				
				exit;
			}			

            // Get image size
            $imageSize = getimagesize($_FILES['banner']['tmp_name']);
            if ($imageSize === false) {
                echo "<span style='color: red;'>Error: Unable to get image size.</span><br/><br/>";
				echo '<a href="banner_man.php" class="btn btn-info btn-lg">Return To Banner Upload</a>';
				include $Global['path'].'Sub/tpl/footer_tpl.php';
                exit;
            }
			
			$sizeString = $imageSize[0] . 'x' . $imageSize[1];
            if (!in_array($sizeString, $allowed_sizes)) {
                echo "<span style='color: red;'>Error: Image size is not allowed. Only $allowed_sizes_display are accepted.</span><br/><br/>";
				echo '<a href="banner_man.php" class="btn btn-info btn-lg">Return To Banner Upload</a>';
				include $Global['path'].'Sub/tpl/footer_tpl.php';
                exit;
            }
			

			//$bannername = preg_replace("/[^A-Za-z0-9_.-]+/", "", $_FILES['banner']['name']);
			$bannername = preg_replace('/[^A-Za-z0-9 .\/:_-]/', '', $_FILES['banner']['name']);
			
			// Check if the banner name already exists in the database
			$selectFields = 'bannername';
			$mainTable = 'banners';
			$where = [
				'bannername' => ['=', $bannername]
			];
			$live = 1;
			$show_debug = 1;
			$result_check = select($selectFields, $mainTable, [], $where, null, null, null, 0, $show_debug);
			$banner_exists_in_db = is_array($result_check) && count($result_check) > 0;

			if (!$banner_exists_in_db) {			
			
				$image_exists_already = false;
				// Move the uploaded file to the specified location				
				move_uploaded_file($_FILES['banner']['tmp_name'], $upload_path.$bannername);
						
				// Escape the banner name for security
				//$bannername = htmlspecialchars($bannername, ENT_QUOTES);

				// Insert the data into the database
				$member_id = sanitize($member_id, 'member_id');
				$bannername = sanitize($bannername, 'bannername');
				$table = 'banners';
				$data = [
						'member_id' => $member_id,
						'bannername' => $bannername
					];
				$live = 1;
				$show_debug = 1;
				$result_ins = insert($table, $data, $live, $show_debug);
			}	
			// Check if the query was successful
			if ($result_ins && (isset($image_exists_already) && $image_exists_already === false)) {
				echo "Banner Uploaded Successfully! <br><br>";
				echo '<a href="campaign-creator.php?type=banner" class="btn btn-info btn-lg">Click Here to Add Your Banner Campaign</a></p>';
			} else {
				echo "<span style='color: red;'>Error: Banner name already exists. Please rename the banner before uploading, or delete the current banner of the same name (below), or choose another banner. </span><br><br>";
			}
        } else {
            echo "<span style='color: red;'>Error: Unsupported file extension.</span><br/><br/>";
        }
    } else {
        echo "<span style='color: red;'>Please choose a file to upload.</span><br/><br/>";
	}	
}


if (isset($_REQUEST['action']) && $_REQUEST['action'] == 'delete') {
    // Escape the banner name for security
    $bannerid = htmlspecialchars($_REQUEST['bannerid'], ENT_QUOTES);
	  
	if(is_file($upload_path.$bannerid)) unlink($upload_path.$bannerid);

    // delete the record from database
	$table = 'banners';
	$where = [
		'member_id' => ['=', $member_id],
		'bannerid' => ['=', $bannerid]
	];
	$live = 1;
	$show_debug = 1;
	$result = delete($table, [], $where, null, $live, 1, $show_debug);
	echo "Banner Deleted Successfully <br><br>";
}
?>


<table style="width:600px; margin: auto;">
<tr>
<td>
<form action="" method="post" ENCTYPE="multipart/form-data">
<input type="hidden" name="action" value="save">

Add Banner:</td>
<td> <input name="banner" type="file" class="form-control" size="35" id="banner">
</td>
<td><input type="submit" value="Upload">
</form>
</td>
</tr>
</table> 
 

	<br/><br/>
<table style="width:100%; border:1px;">
<tr>
<td style="font-weight: bold">ID</td>
<td style="font-weight: bold">Banner Name</td>
<td style="font-weight: bold">Banner</td>
</tr>

<?php

//get the count of the banners
$selectFields = 'COUNT(bannerid) AS cnt';
$mainTable = 'banners';
$where = [
    'member_id' => ['=', $_SESSION['UserID']]
];
$live = 1;
$show_debug = 1;
$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, $show_debug);
$buffer = isset($result[0]) ? $result[0] : '';

//paging params
$results_per_page = 25;
// Ensure $buffer['cnt'] is set and is a number; otherwise, default to 0
$total_results = isset($buffer['cnt']) ? (int)$buffer['cnt'] : 0;
$total_pages = $total_results > 0 ? ceil($total_results / $results_per_page) : 0;

$page = (isset($_GET['page']) && ctype_digit((string)$_GET['page']) ? $_GET['page']:1);
if ($page > $total_pages && $total_pages > 0) {
	$page = $total_pages;
} elseif ($page < 1) {
	$page = 1;
}

//the styling of the results table
$nr = 1;
$color[0] = 'FFFFFF';
$color[1] = 'A3FFA3';
	
$selectFields = '*';
$mainTable = 'banners';
$where = [
    'member_id' => ['=', $_SESSION['UserID']]
];

$offset = ($page - 1) * $results_per_page;
//$limit = $offset.','.$results_per_page; // NOT SURE IF PHPCPR SUPPORTS THIS FORMAT?
$limit = [
	'offset' => $offset,	
	'count' => $results_per_page
];
$live = 1;
$show_debug = 1;
$result = select($selectFields, $mainTable, [], $where, null, null, null, $limit, $show_debug);

// Process the results
foreach ($result as $buffer) {
	?>
	<tr style="background-color:<?php echo (($nr % 2 == 0)?$color[0]:$color[1]); ?>">
	<td><?php echo $buffer['bannerid']; ?></td>
	<td><?php echo $buffer['bannername']."<br>";   ?></td>
	<td>
	<?php echo "<a href='#' OnClick=\"Javascript:window.open('".$Global['webpage_url_ssl']."images/banners/".stripslashes($buffer['bannername'])."','name','height=200,width=650');\" ><img src='".$Global['webpage_url_ssl']."images/banners/".stripslashes($buffer['bannername'])."' width=150></a><br>"; 
	?>
	</td>
	<td>
	<?php echo "
	<a href='?action=delete&bannerid=".$buffer['bannerid']."' Onclick='return confirm(\"Are You Sure?\");'>Delete Pic</a>";
	?>
	</td>
		
	</tr>
	<?php
	++$nr;
}
?>

<tr>
	<td colspan="4"><?php echo pagination_links($page, $total_pages, 6, 'banner_man.php?', array('page' => 'Page', 'first' => 'first', 'last' => 'last')); ?></td>
</tr>
</table>
<p>
<br/><br/>
<!--
<a href="banner-ad-instructions.php">Click Here</a> to return to Banner Ad 
Instructions.<br>
-->

<?php include $Global['path'].'Sub/tpl/footer_tpl.php'; ?>