<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
session_start();
include './../Sub/Config.inc.php';
include './../phpcpr.php'; 
include '../admin/admin_ip_checker.inc.php'; 
// REMEMBER SESSIONS DON'T RUN ACROSS DOMAINS

$debug = false;
//$debug = true;
//$_SESSION['admin_login'] = false;
$allow_debugging = false;
//$allow_debugging = true;

// QQQ FAKE IT TO TEST!!
//$admin_ip = true; // NEVER USE IN LIVE PRODUCTION!!
if ($allow_debugging == true && $admin_ip == true) {
	$debug = true;	
	$_SESSION['admin_login'] = true;
	// CSS CAN ONLY EVER BE SHOWN IN DEBUGGING, AS IT IS HEADER OUTPUT, AND WILL KILL THE REDIRECT!
?>
	<link rel="stylesheet" href="//maxcdn.bootstrapcdn.com/bootstrap/3.3.5/css/bootstrap.min.css" type="text/css">
	<link href="//maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
<?php
}	
// SET DELAY ON REDIRECTION FOR BAD CAMPAIGN URLS // Tip: 1000 ms = 1 second

if (isset($_SESSION['loggedin'])) { // ASSUME USER IS TESTING OWN LINKS, SHOW ERROR MESSAGE
	$timeout = 2000; // USE THIS IF YOU WANT TO SHOW ERROR, THEN REDIRECT IN 3 SECONDS
} else {
	$timeout = 0; // SET TO 0 IF YOU DO NOT WANT TO SHOW ERROR, AND JUST REDIRECT TO CAMPAIGN
}

if (isset($_SESSION['admin_login']) && $_SESSION['admin_login'] == true) $timeout = 0;

$idx = '';
//$ID = $_SESSION['UserID'];

$c = $_REQUEST['c'] ?? 0;
$c = trim($c); 
if (isset($_REQUEST['bannerid'])) $bannerid = trim($_REQUEST['bannerid']);
else $bannerid = '';
$pass_to_gateway = 'c='.$c;

//if ($c == 'gmolina') $debug = true;

if (isset($_GET['id'])) {
	$id = htmlspecialchars($_GET['id'], ENT_QUOTES, 'UTF-8');
	$pass_to_gateway = 'id='.$id.'&c='.$c; // ID MUST COME FIRST!!
}
//echo 'GET ID: '.$_GET['id'];
//exit;


$selectFields = 's.*, c.*, c.idx AS cidx';
$mainTable = ['table' => 'shares', 'as' => 's'];
$joinConditions = [
    [
        'table' => 'campaigns',
        'as' => 'c',
        'condition' => 's.share = c.short'
    ]
];
$where = [
    'c.short' => ['=', $c]
];

$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, 0, 1);
$buffer = $result ? reset($result) : null;

$idx = $buffer['cidx'] ?? null;
$embed = $buffer['embed'] ?? null;
$type = $buffer['type'] ?? null; // HERE, TYPE IS SET IN SHARES TABLE
$unique_clicks = $buffer['unique_clicks'] ?? 0;

if ($debug == true)
if (is_array($buffer)) print_r($buffer).'<br>';
if ($debug == true) echo '<br>idx: '.$idx.'<br>';
if ($debug == true) echo 'embed: '.$embed.'<br>';
if ($debug == true) echo 'type: '.$type.'<br><br>';
//echo '<br>';


// SET REDIRECT URL, DEPENDING ON USE
if (is_array($buffer) && $buffer['share'] != '' && ($buffer['type'] == 'video' || $buffer['type'] == 'youtube' || $buffer['type'] == 'vimeo')) {
	
	if (!file_exists($_SERVER['DOCUMENT_ROOT'] . "/images/youtube/".$embed.".jpg") && $type == 'youtube') {
		include './get-thumb.php';
	} else if (!file_exists($_SERVER['DOCUMENT_ROOT'] . "/images/vimeo/".$embed.".jpg") && $type == 'vimeo') {
		include './get-thumb.php';
	}
	$url = '/gateway.php?'.$pass_to_gateway; 
	
} else if (is_array($buffer) && $buffer['share'] != '' && $buffer['type'] == 'tweet') {
	
	$url = '/gateway.php?'.$pass_to_gateway;	

} else { // NO VALID SHARE FOUND - GET CAMPAIGN ONLY!

	$selectFields = '*';
	$mainTable = ['table' => 'campaigns', 'as' => 'campaigns'];
	$joinConditions = [];
	$where = [
		'short' => ['=', $c]
	];

	$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, 0, 1);
	$buffer = $result ? reset($result) : null;	
	
	$idx = $buffer['idx'] ?? null;
	$embed = $buffer['embed'] ?? null;
	$type = $buffer['adtype'] ?? null; // HERE, TYPE IS FROM CAMP TABLE
	$unique_clicks = $buffer['unique_clicks'] ?? 0;
	$url = $buffer['url'] ?? '/';
	$idxA = $buffer['idx'] ?? null;

}

// SHARE OR OTHER, WE NEED THESE VALUES DEFINED FROM THE BUFFER NOW, OUTSIDE ABOVE COND.
$status = $buffer['status'] ?? null;
$creator_ID = $buffer['ID'] ?? null;
$banners = $buffer['banners'] ?? null;

if ($debug == true) {
	echo '<br><br>LAST BUFFER: ';
	if (is_array($buffer)) print_r($buffer).'<br><br>';
}


if (is_array($buffer) && isset($buffer['adtype']) && $buffer['adtype'] == 'abtest') { // GET THE AB TEST CAMPAIGN NOW
	// NOTE - THE "B" CAMPAIGN IS TIED IN VIA THE IDX OF THE "A" CAMPAIGN. IDX OF CAMP "A" IS THE SHORT OF CAMP "B".
		
	$where = [
		'short' => ['=', $idx]
	];

	$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, 0, 1);
	$bufferab = $result ? reset($result) : null;	

	$ab_test_limit = 100; // HOW MANY VISITS DO WE WANT TO PROCESS, TO DETERMINE THE A/B TEST WINNER?
	$ab_test_total_unique_clicks = ($buffer['unique_clicks'] + $bufferab['unique_clicks']);
	$ab_test_complete = false; // INI VAR
	$show_b_campaign = false; // INI VAR

	// HAVE WE DONE ENOUGH TESTING YET? LET'S FIND OUT NOW
	if ($ab_test_total_unique_clicks >= $ab_test_limit) { // TEST LIMIT REACHED - TEST IS OVER.
		if ($debug == true) echo 'A/B TEST COMPLETE!<br/>';
		$ab_test_complete = true;
		$testA_convrate=$buffer['leads']/$buffer['unique_clicks'];
		$testB_convrate=$bufferab['leads']/$bufferab['unique_clicks'];	
		if ($testA_convrate > $testB_convrate) { // WINNER IS "A" URL - DO NOTHING - VARS ARE ALREADY SET TO USE CAMP "A" BY $buffer, ABOVE. SO WE KEEP / USE THIS AS THE WINNING URL.
		if ($debug == true) echo 'WINNER IS "A"<br/>';
		} else { // WINNER IS "B" URL - SWITCH TO USE THIS CAMPAIGN NOW!
			if ($debug == true) echo 'WINNER IS "B"<br/>';
			$show_b_campaign = true; // OVERRIDE BUFFER TO USE "B" CAMPAIGN
		}
	} // END TEST LIMIT REACHED - TEST IS OVER.

	// TEST IS NOT OVER - WE EVENLY DISTRIBUTE ALL CLICKS
	if ($debug == true) echo 'A/B TEST IN PROGRESS <br/>';	
	// IF MAIN URL (THE A TEST) HAS MORE TOTAL CLICKS, WE SEND THIS VISIT TO THE B URL NOW!
	// STARTED THIS ORIGINALLY USING UNIQUE CLICKS, BUT ALL TESTS FAILED - SINCE YOUR IP DOES NOT CHANGE - ADMIN AND OTHER USERS MUST BE ABLE TO TEST THEIR OWN A/B TESTS EFFECTIVELY, SO SWITCHED OUT TO TOTAL CLICKS INSTEAD!
	// WE STILL USE UNIQUE CLICKS TO DETERMINE WHEN TEST IS COMPLETE (ABOVE)
	// SO THIS SHOULD BE FINE FOR A LONG TERM SOLUTION
	if ($ab_test_complete == false && $buffer['total_clicks'] != 0 && ($buffer['total_clicks'] > $bufferab['total_clicks'])) {
		if ($debug == true) echo 'THIS VISIT GOES TO "B" URL <br/>';
		
		// SWITCH TO USE THE "B" CAMPAIGN NOW!
		$show_b_campaign = true;
	}
	
	if ($show_b_campaign == true) {
		$c = $idx; // NOW WE RESET $c TO THE IDX OF THE "A" URL TEST OF THE AB TEST!
		$url = $bufferab['url'] ?? '/';
		$idx = $bufferab['idx'] ?? null;
		$status = $bufferab['status'] ?? null;
		$creator_ID = $bufferab['ID'] ?? null;
		$banners = $bufferab['banners'] ?? null;
	}	
}

if ($debug == true) {
	echo '<br><br>';
	echo 'idx: '.$idx.'<br>';
	echo 'url: '.$url.'<br>';
	echo 'status: '.$status.'<br>';
	echo 'creator_ID: '.$creator_ID.'<br>';
	echo 'banners: '.$banners.'<br><br>';
}
$error = '';
$error2 = '';
$pending = false;
$bad_url = false;

if ($idx != '' && ($status == '' || $status == 0)) { ?>
	<link rel="stylesheet" href="//maxcdn.bootstrapcdn.com/bootstrap/3.3.5/css/bootstrap.min.css" type="text/css">
	<link href="//maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet" type="text/css" />	
<?php	
	$error = 'ERROR: This Campaign is still pending approval.<br/>Please check back later.';
	$pending = true;
	$camp_edit = $Global['webpage_url_ssl'].'ads/campaign-creator.php?edit='.$c;
} else if ($status == -1) {
	$error = 'ERROR: This Campaign listing was rejected.';
	$camp_edit = $Global['webpage_url_ssl'].'ads/campaign-creator.php?edit='.$c;
	if ($_SESSION['loggedin'] != '' && ($creator_ID == $_SESSION['UserID'])) {
		$error2 = '<h3>Please edit it for approval.</h3><h3><li class="fa fa-pencil-square-o" style="color:#00b3fe" aria-hidden="true" title="Edit Campaign"></li>&nbsp;&nbsp;<a href="'.$camp_edit.'">EDIT MY CAMPAIGN</a></h3>';
	}
} else if (empty($idx)) {
	//header('Location: /404.php');
	//exit;
	$error = 'ERROR: Invalid Campaign ID.';
	$bad_url = true;
	$url = '/';
}

// CHECK TO SEE IF THE SHORT IS A USERNAME!	
$selectFields = 'ID, Username';
$mainTable = 'members';
$where = [
	'Username' => ['=', $c]
];

$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
$buffermem = $result[0] ?? null;

// Check if $c exists in the campaigns table
$selectFields = 'ID'; // Checking existence, so just select the ID
$mainTable = 'campaigns';
$where = [
	'short' => ['=', $c]
];
$limit = 1; 
$show_debug = 1;

// Execute the select query
$res = select($selectFields, $mainTable, [], $where, null, null, null, $limit, $show_debug);
$exists = isset($res[0]) ? $res[0] : null;

// IF $c IS A UNAME AND NOT A CAMP, LET'S MAKE IT ONE!
if (isset($buffermem['ID']) && !isset($exists) && $c != 'ADMIN' && $c != 'admin') { // $c IS A USERNAME!
	// CAMPAIGN IS NOT SET UP, OR CAMPAIGN STATUS IS PENDING OR REJECTED
	// SO LET'S JUST REDIRECT THEM TO THEIR AFFILIATE SITE
	//header("location: /lc.php?id=$c");
	//exit;
	// NOW WE SET UP CAMPAIGN INSTANTLY FOR THEIR USERNAME
	//echo ' gonna set up aff camp link';
	$memID = $buffermem['ID'];
	$camp_create_url = $Global['webpage_url_ssl'].'lc.php?id='.$c;
	//$camp_create_url = $Global['webpage_url_ssl'].'lc1.php?id='.$c;		
	$data = [
		'status' => 1,
		'name' => 'My Affiliate Link',
		'url' => $camp_create_url,
		'short' => $c,
		'adtype' => 'url',
		'ID' => $memID
	];

	$result = insert('campaigns', $data, 1, 1);
	if ($debug == true) echo '<br>INSERTED AFF CAMP URL<br>';
	// CAMP IS SET UP, SO NOW LET'S REDIRECT THEM THERE AND MAKE SOME STATS!
	header("location: /$c");
	exit;
} else if (isset($buffermem['ID']) && isset($exists) && $c != 'ADMIN' && $c != 'admin') {
	if ($debug == true) echo '<br>URL IS NOW RESET TO GO TO LEAD CAP<br>';
	$url = $Global['webpage_url_ssl'].'lc.php?id='.$c;
} else {
	if ($debug == true) echo '<br>NO URL RE-WRITE<br>';
}

if ($error != ''/* && $bad_url != true*/) {
	
	echo '<div class="col-md-6 col-md-offset-3 text-center"><h3 style="color:red"><li class="fa fa-warning" aria-hidden="true" title="Campaign Unapproved"></li> &nbsp;'.$error.'</h3>';
	echo $error2;
	if ($pending == true && $_SESSION['loggedin'] != '' && ($creator_ID == $_SESSION['UserID'])) {
		echo '<hr>';
		echo '<h3 style="color:green"><li class="fa fa-thumbs-o-up text-info" aria-hidden="true" title="Review"></li> &nbsp;Since you are logged in, and this is your campaign,<br/>you may preview it for accuracy.</h3><hr>';
		if (isset($buffer['share']) && $buffer['share'] != '') {
			$title = 'SHARE';
			$share_edit = $Global['webpage_url_ssl'].'ads/add-share.php?s='.$c;
		} else {
			$title = 'CAMPAIGN';
		}
		echo '<h3><li class="fa fa-binoculars text-info" aria-hidden="true" title="Preview"></li>
		&nbsp;&nbsp;<a href="'.$url.'">PREVIEW MY '.$title.'</a></h3>';
		echo '<h3><li class="fa fa-pencil-square-o" style="color:#00b3fe" aria-hidden="true" title="Edit Campaign"></li>
		&nbsp;&nbsp;<a href="'.$camp_edit.'">EDIT MY CAMPAIGN</a></h3>';
		if (isset($buffer['share']) && $buffer['share'] != '') echo '<h3><li class="fa fa-pencil-square-o" style="color:#00b3fe" aria-hidden="true" title="Edit Share"></li>&nbsp;&nbsp;<a href="'.$share_edit.'">EDIT MY SHARE</a></h3>';	
		echo '<h3><li class="fa fa-check" style="color:#00b3fe" aria-hidden="true" title="Go To Campaigns"></li>
		&nbsp;&nbsp;<a href="'.$Global['webpage_url_ssl'].'ads/campaign-stats.php">RETURN TO PROMO DASHBOARD</a></h3>';		
	}
		if (isset($_SESSION['admin_login']) && $_SESSION['admin_login'] == true) { ?>
		<h1>Admin Moderator Login Detected! Redirecting Now...</h1>
			<script type="text/javascript">
			setTimeout("location.href='<?php echo $url; ?>'", <?php echo $timeout; ?>);
			</script>	
  <?php }	
	exit;
} else if ($error != '' && $_SESSION['admin_login'] == true) {
	if ($timeout != 0) echo '<h3 style="color:red">'.$error.'</h3>';
	
	if ($bad_url != true) { // URL IS GOOD! 
		echo '<hr>';
		echo '<h3>Admin, please review this campaign, to approve or deny.</h3>';
			if ($buffer['share'] != '') {
				$title = 'SHARE';
			} else {
				$title = 'CAMPAIGN';
			}
		echo '<h2><a href="'.$url.'">PREVIEW '.$title.'</a></h2>';
	} else { // URL IS BAD! REDIRECT TO MAIN SITE
	?>
			<script type="text/javascript">
			setTimeout("location.href='<?php echo $url; ?>'", <?php echo $timeout; ?>);
			</script>	
	
	
		<?php	
		exit;
	} // END URL IS BAD
} // END NO ERROR AND ADMIN LOGIN IS TRUE	


// CHECK IF IP ALREADY EXISTS FOR THE DAY
$today = date("Y-m-d");

$selectFields = 'id';
$mainTable = 'campaign_ip_check';
$where = [
    'ip' => ['=', $_SERVER['REMOTE_ADDR']],
    'campaign_id' => ['=', $idx],
    'curlstamp' => ['=', $today]
];

$result_ip = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
$buffer_ip = $result_ip ? reset($result_ip) : '';


//******************************************************************************************************
//
// ALL INSERTS / UPDATES BELOW THIS POINT!!!!!!!!
//
//******************************************************************************************************
// THIS NEXT OUTSIDE COND - SEEMED LIKE GOOD IDEA TO NOT CREATE STATS WHEN ADMIN IS CHECKING
// ISSUE IS, IT CAN CAUSE ALSO CONFUSION ON ADMIN TESTS!!
// LEAVING IN PLACE FOR CASE BY CASE USE
if (true || $admin_ip != true) {
	// REGISTER IP ADDRESS
	if (!isset($buffer_ip['id']) || $buffer_ip['id'] == '') {
		$data = [
			'ip' => $_SERVER['REMOTE_ADDR'],
			'campaign_id' => $idx,
			'curlstamp' => date("Y-m-d")
		];

		insert('campaign_ip_check', $data, 1, 1);
	}	
		
	// THIS NEXT UPDATE (BELOW) REMOVED FROM ABOVE COND ON 8/15/21 -- IT WAS FLAWED BCUZ -- IF THE (BANNER OR TEXT?) IMPRESSION LOADED IN THE campaign_ip_check TABLE FOR TODAY, THE ABOVE COND WOULD FAIL TO SET UNIQUE CLICKS! I.E. THE UPDATE WOULD NEVER FIRE IN ABOVE COND. NEW SOLUTION IS BELOW, COVERING BOTH CASES.	
	// NOW WE CHECK TO SEE IF UNIQUE CLICKS WAS EMTPY, (REGARDLESS). IF SO, IT SHOULD BE POPULATED NOW (THE CAMP LINK GOT CLICKED)!
		
	if ((!isset($buffer_ip['id']) || $buffer_ip['id'] == '') || $unique_clicks == 0) {
		// REGISTER UNIQUE AND TOTAL CLICKS
		$data = [
			'unique_clicks' => ['expression' => 'unique_clicks'.'+'.'1'],
			'total_clicks' => ['expression' => 'total_clicks'.'+'.'1']
		];
		$where = [
			'idx' => ['=', $idx],
			'status' => ['>', 0]
		];
		update('campaigns', $data, [], $where, 1, 1, 1);
	} else {
		// IP EXISTS FOR DAY, NOT UNIQUE - JUST UPDATE TOTAL CLICKS
		$data = [
			'total_clicks' => ['expression' => 'total_clicks'.'+'.'1']
		];
		$where = [
			'idx' => ['=', $idx],
			'status' => ['>', 0]
		];
		update('campaigns', $data, [], $where, 1, 1, 1);
	}
}

// NEW TYPE "TRAFFIC", WE DEDUCT CREDITS ON CLICK THRUS!
if ($type == 'traffic') {
	$data = [
		'adcredits' => ['expression' => 'adcredits'.'-'.'1']
	];
	$where = [
		'idx' => ['=', $idx],
		'status' => ['>', 0],
		'adcredits' => ['>', 0]
	];

	update('campaigns', $data, [], $where, 1, 1, 1);
}	
	
if (false && $banners != '') { // SHOULD ALREADY HAVE ALL FIELDS NEEDED IN CAMPAIGNS TABLE
	// check ip if already exists for the day for banners

	$qry_ipb = "SELECT * FROM banner_url_check WHERE ip='".$_SERVER['REMOTE_ADDR']."' AND banner_id='".$bannerid."' AND curlstamp='".date("Y-m-d")."'";
	if ($debug == true) echo $qry_ipb."<br/>";
	$result_ipb = mysql_query($qry_ipb) or die($qry_ipb.' '.mysql_error());
	$buffer_ipb = mysql_fetch_assoc($result_ipb);	
	
	//$ipbannercheckinfo=mysql_fetch_array(mysql_query("SELECT * FROM banner_url_check WHERE ip='".$_SERVER['REMOTE_ADDR']."' AND banner_id='".$bannerid."' AND curlstamp='".date("Y-m-d")."'"));

	// insert ip for clicks count
	if ($buffer_ipb['id'] == '') {
		mysql_query("INSERT INTO banner_url_check SET ip='".$_SERVER['REMOTE_ADDR']."',banner_id='".$bannerid."',curlstamp='".date("Y-m-d")."'");
	
		// reg ip clicks count for banners
		mysql_query("UPDATE banner_stats SET unique_clicks=unique_clicks+1,total_clicks=total_clicks+1 WHERE banner_id='".$bannerid."' AND campaign_id='".$idx."'");
		
		} else {
		
		// reg ip clicks count for banners
		mysql_query("UPDATE banner_stats SET total_clicks=total_clicks+1 WHERE banner_id='".$bannerid."' and campaign_id='".$idx."'");
		}
} // END BANNERS
								
if ($url != '' && $url != '/') {
	$_SESSION['campaign_id'] = $idx ?? null;
	$_SESSION['short'] = $c ?? null;
	$_SESSION['campaign_tracked'] = false;
}

// THESE METHODS BREAK URL ALREADY SET TO HTTPS BY ADDING ANOTHER HTTP
//if(!preg_match("http",$url)) $url="http://".$url;

// THIS SEEMS TO BE OK!!
if (strpos($url,'http') === false && strpos($url,'https') === false) {
	$url="https://".$url;
}

if ($debug == true) {
	echo 'URL BEFORE DOMAIN CHECK IS: '.$url.'<br><br>';
}

$root_domain_length = strlen($Global['webpage_url_ssl']);
$campaign_url_length = strlen($url);
$lowercase_url = strtolower($url);
$stripped_url = substr($lowercase_url,0,$root_domain_length);

// ADDED TRUE OR, TO BELOW COND, SINCE TRACKING VISITS ON END POINTS PROVED UNRELIABLE
// SO NOW GOING TO USE THIS FILE TO TRACK ALL CAMPAIGN VISITS (FOR TIME BEING ANYWAY)! 
//if (true || strtolower($Global['webpage_url_ssl']) != $stripped_url) { // TESTED AND WORKING NOW!
if (strtolower($Global['webpage_url_ssl']) != $stripped_url) { // TESTED AND WORKING NOW!
	
	// URL IS NOT ON THIS DOMAIN. SKIP IT AND USE (REDIRECT TO) outbound.php TO PROCESS THE REDIRECT
	$url = 'outbound.php?c='.$c;
	
	// outbound.php will never trigger on internal A/B TESTS (done on same domain)!
	// but adding support now for this anyway. IF A/B TESTS DO GO TO 3RD PARTY URL, THEN IT WOULD MAKE SENSE TO ALSO GIVE USERS A TRACKING PIXEL, THEY CAN PLACE FOR 3RD PARTY SITE LEAD SIGN UPS, AND ANOTHER FOR 3RD PARTY SITE SALES!
	// FUTURE POSSIBLE DEV IDEA
	if ($buffer['adtype'] == 'abtest' && $show_b_campaign == true) $url = 'outbound.php?c='.$idxA; // TESTED AND WORKING NOW!
}

if ($debug == true) {
	echo 'root domain length: '.$root_domain_length;
	echo '<br>camp url length: '.$campaign_url_length;
	echo '<br>LOWERCASE URL: '.$lowercase_url;	
	echo '<br>STRIPPED URL IS:'.$stripped_url;
	echo '<br>SESSION CAMP ID: '.$_SESSION['campaign_id'].'<br><br>';
	echo $url;
	exit;
}

header("Location: ".$url);
exit;
?>