<?php
/*
 * YouTube Thumbnail Enchancer by Hal Gatewood
 * License: The just-use-it license. Have fun!
 *
 * Dependances:
 * curl
 * GD Library
 * coffee
 *
 * Parameters:
 * inpt = YouTube URL or YouTube ID
 * quality = hq or mq
 * refresh = skips the cache to grab a fresh one
 * play = show play button in middle
 *
 * Usage:
 * http://example.com/yt-thumb.php?quality=hq&inpt=http://www.youtube.com/watch?v=XZ4X1wcZ1GE
 * http://example.com/yt-thumb.php?quality=mq&inpt=http://www.youtube.com/watch?v=XZ4X1wcZ1GE
 * http://example.com/yt-thumb.php?quality=hq&inpt=XZ4X1wcZ1GE
 * http://example.com/yt-thumb.php?quality=mq&inpt=XZ4X1wcZ1GE
 * http://example.com/yt-thumb.php?quality=hq&inpt=XZ4X1wcZ1GE&play
 * http://example.com/yt-thumb.php?quality=hq&inpt=XZ4X1wcZ1GE&play&refresh
 *
 */
 
if ($Global['webpage_name'] == 'ShareThisAgain.com') {

} 
 
$get_url = 'https://i3.ytimg.com/vi/0cEfJxDLmmg/hqdefault.jpg';
//$path = $Global['path'];

if ($debug == true) echo 'GOT TO GET THUMB INC! TYPE IS '.$type.' embed is '.$embed_code;
//exit;

// GET YOUTUBE ID FROM THE SLEW OF YOUTUBE URLS 
// (FOUND ON STACKEXCHANGE SOMEWHERE)
function getYouTubeIdFromURL($get_url) 
{
	$pattern = '/(?:youtube\.com\/(?:[^\/]+\/.+\/|(?:v|e(?:mbed)?)\/|.*[?&]v=)|youtu\.be\/)([^"&?\/ ]{11})/i';
	preg_match($pattern, $get_url, $matches);
	return isset($matches[1]) ? $matches[1] : false;
}


// PARAMETERS
$is_url 				= false;
//$quality 				= $_REQUEST['quality'];
//$quality 				= ($quality == "hq") ? "hq" : "mq";
$quality 				= "hq";
$show_play_icon			= true;
$play_btn_file_name 	= ($show_play_icon) ? "-play" : "";

// FILENAME
//$filename = ($quality == "mq") ? $embed_code . "-mq": $embed_code;
//$filename .= $play_btn_file_name;
$filename = $embed_code;

// CREATE IMAGE FROM YOUTUBE THUMB
if ($use_default_thumb == true) {
//$Global['webpage_name']	
$image = imagecreatefromjpeg( "/images/default_video_thumb.jpg" );

// CREATE IMAGE FROM YOUTUBE THUMB
} else if ($type == 'youtube') {
$image = imagecreatefromjpeg( "http://img.youtube.com/vi/" . $embed_code . "/" . $quality . "default.jpg" );
} else if ($type == 'vimeo') {

	/**
	 * Vimeo Thumbnail Script - Gets the poster frame for a Vimeo video id.
	 * @author Bramus Van Damme <bramus@bram.us>
	 *
	 * Example Request: vimeothumb.php?id=83936766
	 */
	// Perform a GET request to a given URL.
	// Uses `allow_url_fopen` if supported, or curl as a fallback.
	function get($get_url) {
			if (ini_get('allow_url_fopen')) return file_get_contents($get_url);
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, $get_url);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			$result = curl_exec($ch);
			curl_close($ch);
			return $result;
	}
	// Extract ID from the URL
	//$embed_code = isset($_GET['id']) ? $_GET['id'] : 0;
	// Request the image hash with Vimeo
	if ($embed_code > 0) $hash = unserialize(get('http://vimeo.com/api/v2/video/' . $embed_code . '.php'));
	// Thumbnail found
	if ($hash && isset($hash[0]) && isset($hash[0]['thumbnail_large'])) {
			//header('Content-type: image/jpeg');
			//echo get($hash[0]['thumbnail_large']);
	} // No thumbnail found: return a valid, but blank image
	else {
		/*
		header('Cache-Control: no-cache');
		header('Content-type: image/gif');
		header('Content-length: 43');
		echo base64_decode('R0lGODlhAQABAIAAAP///wAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==');
		*/
	}

$image = imagecreatefromjpeg($hash[0]['thumbnail_large']);
} // END VIMEO



// IF HIGH QUALITY WE CREATE A NEW CANVAS WITHOUT THE BLACK BARS
if($quality == "hq")
{
	$cleft = 0;
	$ctop = 45;
	$canvas = imagecreatetruecolor(480, 270);
	imagecopy($canvas, $image, 0, 0, $cleft, $ctop, 480, 360);
	$image = $canvas;
}


$imageWidth 	= imagesx($image);
$imageHeight 	= imagesy($image);



// ADD THE PLAY ICON
$play_icon = $show_play_icon ? "play-" : "noplay-";
$play_icon .= $quality . ".png";
$logoImage = imagecreatefrompng( $play_icon );

imagealphablending($logoImage, true);

$logoWidth 		= imagesx($logoImage);
$logoHeight 	= imagesy($logoImage);

// CENTER PLAY ICON
$left = round($imageWidth / 2) - round($logoWidth / 2);
$top = round($imageHeight / 2) - round($logoHeight / 2);


// CONVERT TO PNG SO WE CAN GET THAT PLAY BUTTON ON THERE
imagecopy( $image, $logoImage, $left, $top, 0, 0, $logoWidth, $logoHeight);
imagepng( $image, $filename .".png", 9);


// MASHUP FINAL IMAGE AS A JPEG
$input = imagecreatefrompng($filename .".png");
$output = imagecreatetruecolor($imageWidth, $imageHeight);
$white = imagecolorallocate($output,  255, 255, 255);
imagefilledrectangle($output, 0, 0, $imageWidth, $imageHeight, $white);
imagecopy($output, $input, 0, 0, 0, 0, $imageWidth, $imageHeight);

// OUTPUT IMAGES TO FOLDER
if ($type == 'youtube') {
imagejpeg($output, $Global['path']."images/youtube/" . $filename . ".jpg", 95);
//imagejpeg($output, $filename . ".jpg", 95);
} else if ($type == 'vimeo') {
imagejpeg($output, $Global['path']."images/vimeo/" . $filename . ".jpg", 95);
}
// UNLINK PNG VERSION
@unlink($filename .".png");

// REDIRECT TO NEW IMAGE
//header("Location: i/" . $filename . ".jpg");
//die;

?>
