<?php
if (IPN_PROCESS !== true) {
	echo '
	//----------------------------------------------------------------------<br />
	//Date: October 14 2012																							<br />
	//Last Modified: October 15 2012																			<br />
	//Copyright(C) 2012 Jim Symonds, All Rights Reserved.	<br />
	//----------------------------------------------------------------------<br />
	';
	exit;
	}

if ($Global['MinFraudLicenseKey'] != "") {
	require("minfraud/src/CreditCardFraudDetection.php");
	$_SESSION['MinFraudLicenseKey'] = $Global['MinFraudLicenseKey'];
} else {
	$_SESSION['MinFraudLicenseKey'] = "";
}

// QQQ DISABLE MINFRAUD BY REMOVING LICENSE KEY
//$_SESSION['MinFraudLicenseKey'] = '';

function MinFraudCheck($creditcard,$billing) {
	
//require("../conf/minFraud/CreditCardFraudDetection.php");

// Create a new CreditCardFraudDetection object
$ccfs = new CreditCardFraudDetection;

// Set inputs and store them in a hash
// See http://www.maxmind.com/app/ccv for more details on the input fields
// Enter your license key here (Required)

$h["license_key"] = $_SESSION['MinFraudLicenseKey']; // 
// Required fields

$h["i"] = $_SERVER['REMOTE_ADDR'];             // set the client ip address
$h["city"] = $billing["city"];             // set the billing city
if($_POST["country"] == "US"){
	$h["region"] = $billing["state"];                 // set the billing state
}else{
	$h["region"] = "";                 // set the billing state
}
$h["postal"] = $billing["zip"];              // set the billing zip code
$h["country"] = $billing["country"];                // set the billing country

// Recommended fields

//$h["domain"] = "yahoo.com";		// Email domain
$h["bin"] = substr($creditcard['number'],0,6);			// bank identification number
//$h["forwardedIP"] = $_SERVER['HTTP_X_FORWARDED_FOR'];	// X-Forwarded-For or Client-IP HTTP Header

// CreditCardFraudDetection.php will take
// MD5 hash of e-mail address passed to emailMD5 if it detects '@' in the string
//$h["emailMD5"] = "Adeeb@Hackstyle.com";

// CreditCardFraudDetection.php will take the MD5 hash of the username/password if the length of the string is not 32
//$h["usernameMD5"] = "test_carder_username"; 
//$h["passwordMD5"] = "test_carder_password"; 

// Optional fields
//$h["binName"] = "MBNA America Bank";	// bank name
//$h["binPhone"] = "800-421-2110";	// bank customer service phone number on back of credit card
//$h["custPhone"] = "212-242";		// Area-code and local prefix of customer phone number
//$h["requested_type"] = "premium";	// Which level (free, city, premium) of CCFD to use
//$h["shipAddr"] = "145-50 157TH STREET";	// Shipping Address
//$h["shipCity"] = "Jamaica";	// the City to Ship to
//$h["shipRegion"] = "NY";	// the Region to Ship to
//$h["shipPostal"] = "11434";	// the Postal Code to Ship to
//$h["shipCountry"] = "US";	// the country to Ship to
//$h["txnID"] = "1234";			// Transaction ID
//$h["sessionID"] = "abcd9876";		// Session ID

$h["accept_language"] = "de-de";
$h["user_agent"] = "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10_5_5; de-de) AppleWebKit/525.18 (KHTML, like Gecko) Version/3.1.2 Safari/525.20.1";

// If you want to disable Secure HTTPS or don't have Curl and OpenSSL installed
// uncomment the next line
// $ccfs->isSecure = 0;

// set the timeout to be five seconds
$ccfs->timeout = 5;

// uncomment to turn on debugging
// $ccfs->debug = 1;

// how many seconds to cache the ip addresses
// $ccfs->wsIpaddrRefreshTimeout = 3600*5;

// file to store the ip address for minfraud3.maxmind.com, minfraud1.maxmind.com and minfraud2.maxmind.com
// $ccfs->wsIpaddrCacheFile = "/tmp/maxmind.ws.cache";

// if useDNS is 1 then use DNS, otherwise use ip addresses directly
$ccfs->useDNS = 0;
$ccfs->isSecure = 1;

// next we set up the input hash
$ccfs->input($h);

// then we query the server
$ccfs->query();

// then we get the result from the server
$h = $ccfs->output();

// then finally we print out the result
$foundkey = array(FALSE, FALSE, FALSE);
$ccfd_error = "N";
$outputkeys = array_keys($h);
$numoutputkeys = count($h);
$post_back = "";

for ($i = 0; $i < $numoutputkeys; $i++) {
  $key = $outputkeys[$i];
  $value = preg_replace("/'/","", $h[$key]);
  //print $key . " = " . $value . "<br/>\n";
  $post_back .= $key." = ".$value.", ";

  if ($key == "countryMatch") {
            $foundkey[0] = TRUE;
			if($value == "No"){
					$ccfd_error = "Y";
			}
	} elseif ($key == "anonymousProxy") {
            $foundkey[1] = TRUE;
			if($value == "Yes"){
					$ccfd_error = "Y";
			}

	} elseif ($key == "riskScore") {
            $foundkey[2] = TRUE; // QQQ SET FRAUD RISK SCORE HERE!
// HIGHER VALUE NUMBER IS "LOOSER" SETTING, LOWER NUMBER IS MORE RESTRICTIVE. GOES FROM 0 - 100
			if ($value >60) {
					$ccfd_error = "Y";
			}
	}
}
if (($foundkey[0] && $foundkey[1] && $foundkey[2]) == FALSE) $ccfd_error = "Y";

$ret_array = array($ccfd_error,$post_back);
return($ret_array);
}
/**
 * E4 Processing Function
 */	
function E4process($gateway_id, $gateway_password, $order, $billing, $creditcard, $test_mode=FALSE) { 

	// DEBUGGING 
	if ($_SESSION['debug'] == true) {
	echo "<br/>We got inside E4process function<br/>";
echo "gateway id: ";
echo $gateway_id;
echo "gateway password: ";
echo $gateway_password;
echo "order"; 
print_r($order);
echo "billing: ";
print_r($billing); 
echo "creditcard: ";
print_r($creditcard);
if ($test_mode == true) echo "test_mode on";
else echo "test_mode off";

	}

	//$test_mode = TRUE; // UNCOMMENT this line to force TEST mode
	$avs = substr($billing['address1'],0,28) . "|" . $billing['zip'];
	if ($billing['country'] != "US") $avs = "";
	if ($creditcard['number'] != "") {
		$Last4 = substr($creditcard['number'],-4);
		$CVindicator = "1";
	} else if ($creditcard['token'] != "") {
		$Last4 = substr($creditcard['token'],-4);
		$CVindicator = "";
	}
	if ($creditcard['exp'] != "") $expirationMMYY = $creditcard['exp'];
	else $expirationMMYY = $creditcard['month'] . $creditcard['year'];

	if ($order['total_amount'] == 0) $transtype_code = "01";  // preauth-only if zero amount
	else $transtype_code = "00";
	// IF using Minfraud, check it first before processing through gateway

	if ($test_mode == TRUE || $_SESSION['test_credit_cards'] == true) { 
echo '<br>E4.class.php says cc test session is true<br>';
	$gateway_id = 'AD4989-05';
	$gateway_password = '7qp17na6';
	$gateway_url = "https://api.demo.globalgatewaye4.firstdata.com/transaction/v11/wsdl";
	} else { $gateway_url = "https://api.globalgatewaye4.firstdata.com/transaction/v11/wsdl";  
	}
	
	$trxnProperties = array(
	  "User_Name"=>"",
	  "Secure_AuthResult"=>"",
	  "Ecommerce_Flag"=>"",
	  "XID"=>"",
	  "ExactID"=>$gateway_id,				    //Payment Gateway
	  "CAVV"=>"",
	  "Password"=>$gateway_password,					                //Gateway Password
	  "CAVV_Algorithm"=>"",
	  "Transaction_Type"=>$transtype_code,//Transaction Code I.E. Purchase="00" Pre-Authorization="01" etc.
	  "Reference_No"=>$order['id'],
	  "Customer_Ref"=>$order['ref'],
	  "Reference_3"=>$order['ref3'],
	  "Client_IP"=>$order['ip'],					                    //This value is only used for fraud investigation.
	  "Client_Email"=>$billing['email'],			//This value is only used for fraud investigation.
	  "Language"=>"en",				//English="en" French="fr"
	  "Card_Number"=>$creditcard['number'],		    //For Testing, Use Test#s VISA="4111111111111111" MasterCard="5500000000000004" etc.
	  "Expiry_Date"=>$expirationMMYY,        //This value should be in the format MMYY.
	  "CardHoldersName"=>$billing['name'],
	  "Track1"=>"",
	  "Track2"=>"",
	  "TransarmorToken"=>$creditcard['token'],
	  "CardType"=>$creditcard['CardType'],
	  "Authorization_Num"=>"",
	  "Transaction_Tag"=>"",
	  "DollarAmount"=>round($order['total_amount'],2),
	  "VerificationStr1"=>$avs,
	  "VerificationStr2"=>$creditcard['cvm'],
	  "CVD_Presence_Ind"=>$CVindicator,
	  "Secure_AuthRequired"=>"",
	  "Currency"=>"",
	  "PartialRedemption"=>"",
	  
	  // Level 2 fields 
	  "ZipCode"=>"",
	  "Tax1Amount"=>"",
	  "Tax1Number"=>"",
	  "Tax2Amount"=>"",
	  "Tax2Number"=>"",
	  
	  "SurchargeAmount"=>"",	//Used for debit transactions only
	  "PAN"=>""							//Used for debit transactions only
	  );
// DEBUGGING 
if ($_SESSION['debug'] == true) {
echo "<br/>Debugging Statments From apay/Lib/E4.class.php<br/>";
echo "<br/>BEFORE TRANSACTION:<br/>";
print_r($trxnProperties);
echo "<br/>";
if (!extension_loaded('soap')) echo '<br/>ERROR: You need soap added to your php library! Ask your host to add this.<br/>';
echo '<br/>If you cannot connect to the E4 gateway, make certain port 80 is open.<br/>';
}
	$trxn = array("Transaction"=>$trxnProperties);
	$gatewayerror = FALSE;
	$frauderror = FALSE;
	if ($_SESSION['MinFraudLicenseKey'] != ""  && $creditcard['number'] != "") {
	// Check if username or ip is in minfraudbypass table, and if so, disable MINFRAUD for this transaction
		$minfraud_qry = "SELECT idx from minfraudbypass WHERE (username='".$order['ref']."' || ip='".$order['ip']."')";
		$minfraud_q_res = mysql_query($minfraud_qry);
		if ($minfraud_q_res !== false && mysql_num_rows($minfraud_q_res) > 0) {
			$_SESSION['MinFraudLicenseKey'] = ""; // DISABLE MINFRAUD FOR THIS TRANSACTION
			if ($_SESSION['debug']) echo "MinFraud Bypassed for user ".$order['ref']." / IP ".$order['ip']."<br />";
		}
	}
	if ($_SESSION['MinFraudLicenseKey'] != "" && $creditcard['number'] != "") {
		$minfraud = MinFraudCheck($creditcard,$billing);
		$minfraud_data = $minfraud[1];
if ($_SESSION['debug'] == true) {
	echo "<br/>MinFraud Data: <br>".$minfraud_data."<br>";
}
		if ($minfraud[0] == "Y") {
if ($_SESSION['debug'] == true) {
echo "<br/>MinFraud Found a Problem: <br>";
}
			$frauderror = TRUE;
			$trxnResult["CTR"] = "There was an error while processing. No TRANSACTION DATA IN CTR!";
			$trxnResult["Transaction_Error"] = 1;
			$trxnResult["EXact_Message"] = "DUE TO ANTI-FRAUD CONTROLS, THIS CARD CANNOT BE ACCEPTED AT THIS TIME";
			$trxnResult["Reference_No"] = $order['id'];
			$trxnResult["Authorization_Num"] = "";
			$trxnResult["Customer_Ref"] = $order['ref'];
			$trxnResult["TransarmorToken"] = "";
		}
	} else {
		$minfraud_data = "";
	}
			
if ($frauderror == FALSE) {		
	try {
		$client = @new SoapClient($gateway_url,array("exceptions" => 1,'login' => $gateway_id,
												'password'       => $gateway_password));  

if ($_SESSION['debug'] == true) {
echo "<br/>We logged into the e4 gateway.<br>";
}

	} catch (SoapFault $E) {  
		//echo $E->faultstring;
		$trxnResult["CTR"] = "There was an error while processing. No TRANSACTION DATA IN CTR!";
		$trxnResult["Transaction_Error"] = 1;
		$trxnResult["EXact_Message"] = "Cannot Connect to Gateway";
		$gatewayerror = TRUE;
	} 

	if ($gatewayerror === FALSE) {
		try {

			$trxnResult = $client->__soapCall('SendAndCommit', $trxn);

if ($_SESSION['debug'] == true) {
echo "<br/>We processed the transaction!<br>";
}

		} catch (SoapFault $E) {
			$trxnResult["CTR"] = "There was an error while processing. No TRANSACTION DATA IN CTR!";
			$trxnResult["Transaction_Error"] = 1;
			$trxnResult["EXact_Message"] = "Invalid GatewayID or Password";
		}
	
	}
}

	
	// Iterpretation of results
	$archive_response = "";
	$cc_result = array(); 
	foreach($trxnResult as $key=>$value){
		//if ($key != "CTR" && substr($key,0,8) != "Merchant" && $key != "VerificationStr2") $archive_response .= $key."=>".$value."|";
		$cc_result[$key] = $value;
	}
	
	if ($cc_result['Transaction_Approved'] == "1") {
		$trans_status = "APPROVED";
		$cc_err = "";
	} else if ($cc_result['Transaction_Error'] == "1") {
		$trans_status = "Not Processed";
		$cc_err = $cc_result['EXact_Message'];
		if ($cc_result['Bank_Message'] != "") $cc_err  .= "<br/>". $cc_result['Bank_Message'];
	} else {
		$trans_status = "Not Processed";
		$cc_err = $trans_status .": " . $cc_result['Bank_Message'];
	}
	$cc_result['error'] = $cc_err;
	$cc_result['result_code'] = $trans_status;
	$cc_result['transaction'] = $cc_result["Reference_No"];
	$cc_result['auth'] = $cc_result["Authorization_Num"];
	$cc_result['reference'] = $cc_result["Customer_Ref"];
	$cc_result['TransArmorToken'] = $cc_result["TransarmorToken"];
	$cc_result['Last4'] = $Last4;
	$cc_result['minfraud_data'] = $minfraud_data;


if ($_SESSION['debug'] == true) {
echo "<br/>AFTER TRANSACTION:<br/>";
print_r($cc_result);
echo "<br/><br/>End Debugging Statments From apay/Lib/E4.class.php<br>";
}
	return($cc_result);

}

?>