<?phpif (IPN_PROCESS !== true) {	echo '	//----------------------------------------------------------------------<br />	//Made by: Sven Arild Helleland 																				<br />	//Firm: Kaizen Web-Productions (http://www.kaizen-web.com)							<br />	//Date: 10th September 2007																							<br />	//Last Modified: 13th September 2007																		<br />	//Copyright(C), Kaizen Web-Productions, 2004-2007, All Rights Reserved.	<br />	//----------------------------------------------------------------------<br />	';	exit;	}//When transferring the class to php 5, perhaps utilize apache_request_headers to fetch the authorize headers... note, should implent a apache check. as it only works under apache. I.e. either this or the .htaccess would require apache, but .htaccess will work on apache 1 while the function req apache2. Check up and perhaps create fallback functionality that users on different servers/modules should run to be able to use Google Checkout as well./** * Google Checkout Library *   * @author Sven Arild Helleland - Kaizen Web-Productions (http://www.kaizen-web.com) * @version 0.1 * @copyright Copyright(C), Kaizen Web-Productions, 2004-2007, All Rights Reserved. * @package GoogleCheckout */class google_checkout {		var $merchant_id;	var $merchant_key;	var $master_merchant_id;	var $server_url;	var $request_url;	var $schema_url = 'http://checkout.google.com/schema/2';	var $form_url;	var $currency;	var $item = array();	var $xml_purchase = '';	var $error = array();		/**	 * Constructor	 *	 * @param int 		$merchant_id				Google Checkout Merchant ID	 * @param string 	$merchant_key				Google Checkout Merchant Key	 * @param string 	$currency						Currency that should be processed, default USD	 * @param bool 		$test								If this is a test transaction, default false	 * @param int 		$master_merchant_id	Required if the transaction is initiated on behalf of others. 	 * 																		Should containt the Google Checkout Merchant ID of the owner of the site, default false	 * @return google_checkout	 */		function google_checkout($merchant_id, $merchant_key, $currency='USD', $test=false, $master_merchant_id=false) {		//Is it a test transaction?			if ($test === true) $this->server_url = 'https://sandbox.google.com/checkout/';		else $this->server_url = 'https://checkout.google.com/';			$this->form_url = $this->server_url.'cws/v2/Merchant/'.$merchant_id.'/checkout';		$this->request_url = $this->server_url.'cws/v2/Merchant/'.$merchant_id.'/request';				$this->currency = $currency;				$this->merchant_id = $merchant_id;		$this->merchant_key = $merchant_key;		$this->master_merchant_id = ((empty($master_merchant_id))?false:$master_merchant_id);		}		/**	 * Update the merchant information	 *	 * @param int 		$merchant_id	Google Checkout Merchant ID	 * @param string 	$merchant_key	Google Checkout Merchant Key	 */			function update_info($merchant_id, $merchant_key) {		$this->merchant_id = $merchant_id;		$this->merchant_key = $merchant_key;				$this->form_url = $this->server_url.'cws/v2/Merchant/'.$merchant_id.'/checkout';		$this->request_url = $this->server_url.'cws/v2/Merchant/'.$merchant_id.'/request';		}						/**	 * Add a product to the order	 * 	 * Note: An order need to contain at least one product!	 *	 * @param string 	$name					Product Name	 * @param string	$description	Product Description	 * @param float 	$price				Product Price	 * @param int 		$quantity			Product Quantity	 * @param string 	$product_id		Product Unique Id	 */			function add_item($name, $description, $price, $quantity, $product_id=false) {		$this->item[] = array('name' => $this->clean_data((string) $name),													'description' => $this->clean_data((string) $description),													'price' => (float) $price,													'quantity' => (int) $quantity,													'product_id' => $this->clean_data((string) $product_id));		}					/**	 * Create the XML schema for purchases	 */			function create_purchase_xml($continue_url, $edit_url) {		$this->xml_purchase .= '<?xml version="1.0" encoding="UTF-8"?><checkout-shopping-cart xmlns="'.$this->schema_url.'"><shopping-cart><items>';				foreach ($this->item as $value) {			$this->xml_purchase .= '<item><item-name>'.$value['name'].'</item-name><item-description>'.$value['description'].'</item-description><unit-price currency="'.$this->currency .'">'.number_format($value['price'], 2, '.', '').'</unit-price><quantity>'.$value['quantity'].'</quantity>';						if ($value['product_id'] !== false) $this->xml_purchase .= '<merchant-item-id>'.$value['product_id'].'</merchant-item-id>';						$this->xml_purchase .= '</item>';			}				$this->xml_purchase .= '</items></shopping-cart><checkout-flow-support><merchant-checkout-flow-support> <continue-shopping-url>'.$this->clean_data($continue_url).'</continue-shopping-url><edit-cart-url>'.$this->clean_data($edit_url).'</edit-cart-url>';		if ($this->master_merchant_id !== false) $this->xml_purchase .= '<platform-id>'.$this->master_merchant_id.'</platform-id>';		//Required?		//<order-processing-support><request-initial-auth-details>true</request-initial-auth-details></order-processing-support>				$this->xml_purchase .= '</merchant-checkout-flow-support></checkout-flow-support></checkout-shopping-cart>';		}							/**	 * Create the payment button form	 * 	 * Note: This is the final step when creating the payment form	 *	 * @return string	Returns the payment button form	 */			function create_form($continue_url, $edit_url) {		//Create the XML schema		$this->create_purchase_xml($continue_url, $edit_url);				//Create the form		$form = '<form method="post" action="'.$this->form_url.'"><input type="hidden" name="cart" value="'.base64_encode($this->xml_purchase).'"><input type="hidden" name="signature" value="'.base64_encode($this->get_hmacsha1($this->xml_purchase)).'"><input type="image" name="Google Checkout" alt="Fast checkout through Google" src="'.$this->server_url.'buttons/checkout.gif?merchant_id='.$this->merchant_id.'&w=180&h=46&style=white&variant=text&loc=en_US" height="46" width="180"></form>';				return $form;		}						/**	 * Update the order status to PROCESSING	 * 	 * Note: This is a optional feature, and is not required to charge the order.	 *	 * @param integer $order_number	The Google Checkout order number	 * @return bool									Returns true on success, false on failure	 */			function process_order($order_number) {		$data = '<?xml version="1.0" encoding="UTF-8"?><process-order xmlns="'.$this->schema_url.'" google-order-number="'.$order_number.'" />';		 		return $this->transfer_request($this->request_url, $this->create_headers(), $data);		}						/**	 * Charge the order	 * 	 * Note: Wait until Google Checkout confirm that the order has been charged before updating the internal order status!	 *	 * @param integer $order_number	The Google Checkout order number	 * @param float 	$order_amount	The amount you want to charge	 * @return bool									Returns true on success, false on failure	 */			function charge_order($order_number, $order_amount=0) {		$data = '<?xml version="1.0" encoding="UTF-8"?><charge-order xmlns="'.$this->schema_url.'" google-order-number="'.$order_number.'">';		    if ($order_amount > 0) $data .= '<amount currency="'.$this->currency.'">'.number_format($order_amount, 2, '.', '').'</amount>';          $data .= '</charge-order>';				return $this->transfer_request($this->request_url, $this->create_headers(), $data);		}			/**	 * Update the order status to DELIVERED	 *	 * @param integer $order_number	The Google Checkout order number	 * @param string		$email			If you want Google Checkout to send an order update email to the customer or not,	 * 															'true' sends email, 'false' does not.	 * @return bool									Returns true on success, false on failure	 */			function finalize_order($order_number, $email='true') {		//Note additional information can be attached to the deliver order code		//http://code.google.com/apis/checkout/developer/Google_Checkout_XML_API_Order_Level_Shipping.html#Deliver_Order				$data = '<?xml version="1.0" encoding="UTF-8"?><deliver-order xmlns="'.$this->schema_url.'" google-order-number="'.$order_number.'"><send-email>'.$email.'</send-email></deliver-order>';				return $this->transfer_request($this->request_url, $this->create_headers(), $data);		}						/**	 * Archive the order	 * 	 * Note: This function removes the order from the Google Checkout Merchant Center Inbox and puts it in the archive.	 *	 * @param unknown_type $order_number	 * @return unknown	 */			function archive_order($order_number) {		$data = '<?xml version="1.0" encoding="UTF-8"?><archive-order xmlns="'.$this->schema_url.'" google-order-number="'.$order_number.'" />';				return $this->transfer_request($this->request_url, $this->create_headers(), $data);		}						/**	 * Force response header	 * 	 * Set the response header according to if the data was validated or not.	 *	 * @param integer $status	 */			function force_header($status) {		switch ((int) $status) {			case 200:				$header_info = 'HTTP/1.0 200 OK';				break;			case 400:				$header_info = 'HTTP/1.0 400 Bad Request';				break;			default:				$header_info = 'HTTP/1.0 504 Gateway Timeout';				break;			}					header($header_info);		}						/**	 * Transfer request	 * 	 * Performs the transfer to Google Checkout and validates the response.	 *	 * @param string 	$url		The url	 * @param array 	$header	The headers	 * @param string 	$data		The xml data	 * @return bool						Returns true on success, false on failure	 */			function transfer_request($url, $header, $data) {		$handle = curl_init($url);				curl_setopt($handle, CURLOPT_POST, true);    curl_setopt($handle, CURLOPT_HTTPHEADER, $header);    curl_setopt($handle, CURLOPT_POSTFIELDS, $data);    curl_setopt($handle, CURLOPT_HEADER, true);    curl_setopt($handle, CURLOPT_RETURNTRANSFER, true); 		$response = curl_exec($handle); 		if (curl_errno($handle)) $this->error[] = curl_errno($handle).': '.curl_error($handle);				curl_close($handle);		list($response_header, $response_body) = explode("\r\n\r\n", $response, 2);    $status = $this->parse_header($response_header);		if ((int) $status == 200) {			return true;			}		else {			$this->error[] = 'Transfer Error: HTTP '.(int) $status.' Status';			return false;			}		}					/**	 * Parse Google Checkout response headers	 *	 * @param string $data	Response headers from Google Checkout	 * @return string				Returns the status code	 */			function parse_header($data) {		$header_info = explode("\r\n", $data);		foreach ($header_info as $value) {			if (empty($value)) break;						$header_info[] = trim($value);			}		preg_match('#[HTTP/\d\.\d] (\d\d\d)#', $header_info[0], $status);		return $status[1];		}						/**	 * Parse XML	 * 	 * Uses SAX for best backward compability	 *	 * @param string $data	The XML data	 * @return array|bool		Returns an array with parsed data on success, false on failure	 */		function parse_xml($data) {		$handle = xml_parser_create();				xml_parser_set_option($handle, XML_OPTION_CASE_FOLDING, 0);				xml_parse_into_struct($handle, $data, $return, $index);					xml_parser_free($handle);				if (!empty($return)) {			return array($return[0]['tag'], $this->parse_xml2array($return));			}		else {			$this->error[] = 'Parse XML Error: No data';			return false;			}		}						/**	 * Parse the complete XML array into an simpler array	 *	 * @param array $data	The complete XML array	 * @return array			Returns the simpler array	 */			function parse_xml2array($data) {		$return_data = array();		foreach ($data as $value) {   		$tag = $value['tag'];   		      if ($value['type'] == 'open' || $value['type'] == 'complete') {      	if (!empty($return_data[$tag])) {        	if (isset($return_data[$tag][0])){          	$return_data[$tag][] = array();             }          else {          	$return_data[$tag] = array($return_data[$tag], array());            }                       $temp = &$return_data[$tag][(count($return_data[$tag]) - 1)];          }        else {          $temp = &$return_data[$tag];          }				        if ($value['type'] == 'open') $temp = array();        if (isset($value['attributes'])) {         	foreach ($value['attributes'] as $key => $val) {          	$temp[$key] = $val;            }          }                       	if ($value['type'] == 'open') {       	 	$temp['_p'] = &$return_data;        	$return_data = &$temp;       		}       	else {       		$temp['value'] = (isset($value['value'])?$value['value']:null);       		}        }     	elseif ($value['type'] == 'close') {     		$return_data = &$return_data['_p'];      	}    	}    		    $this->recursive_xml2array_delete($return_data);	    			return $return_data;		}				/**	 * Recursive cleaning the simpler XML array	 *	 * @param array $data The simpler XML array	 */			function recursive_xml2array_delete(&$data) {		foreach ($data as $key => $value) {    	if ($key === '_p') {      	unset($data[$key]);        }      else if(is_array($data[$key])) {      	$this->recursive_xml2array_delete($data[$key]);        }      }		}				/**	 * Find the order and serial number	 *	 * @param array $data	Array containing the parsed XML data, without the top level of the array, i.e. use $data[$response]	 * @return array|bool	Returns an array containing the order number and serial number on success, false on failure	 */			function find_order_number($data) {		if (empty($data['google-order-number']['value'])) {			$this->error[] = 'Reference Error: Missing order number';			return false;			}		elseif (empty($data['serial-number'])){			$this->error[] = 'Reference Error: Missing serial number';			return false;				}					return array('order_number' => $data['google-order-number']['value'], 'serial_number' => $data['serial-number']);		}						/**	 * Verifying The HTTP Basic Authentication Header	 *	 * Note: 	 * 1) If the script is run as PHP CGI Module, setup .htaccess to forward the HTTP Authorization header.	 * 2) If the script is run on IIS read the note at the bottom of the article here: http://no.php.net/features.http-auth	 * 	 * return bool Returns true on success, false on failure	 */			function verify_request() {		//Perhaps add in a ip or dns check here as well?				if (!isset($_SERVER['PHP_AUTH_USER']) || !isset($_SERVER['PHP_AUTH_PW'])) {//CLI			if (isset($_SERVER['HTTP_AUTHORIZATION'])) { //CGI, force the variable with .htaccess (require apache though)				$auth_code = $_SERVER['HTTP_AUTHORIZATION'];				}			elseif (isset($_SERVER['Authorization'])) { //IIS				$auth_code = $_SERVER['Authorization'];				}			else { //Fetching Basic Authentication Header Failed				$this->error[] = 'Verify Error: No Authentication Header';				return false; 				}							list($_SERVER['PHP_AUTH_USER'], $_SERVER['PHP_AUTH_PW']) = explode(':', base64_decode(substr($auth_code, strpos($auth_code, ' ') + 1)));					}		if ($_SERVER['PHP_AUTH_USER'] != $this->merchant_id || $_SERVER['PHP_AUTH_PW'] != $this->merchant_key) {			$this->error[] = 'Verify Error: No Authentication Header';			return false;			}		return true;		}					/**	 * Create HTTP Header's	 *	 * @return array Returns the http headers	 */			function create_headers() {		$header = array();				$header[] = "Authorization: Basic ".base64_encode($this->merchant_id.':'.$this->merchant_key);		$header[] = "Content-Type: application/xml;charset=UTF-8";		$header[] = "Accept: application/xml;charset=UTF-8";		$header[] = "User-Agent: Kaizen-Web; GC Processing (0.1)";				return $header;		}						/**	 * Clean the data	 *	 * @param string $data	Data that should be cleaned	 * @return string 			Returns clean data	 */			function clean_data($data) {		$replace_find = array('&', '<', '>');		$replace_with = array('&#x26;', '&#x3c;', '&#x3c;');				return str_replace($replace_find, $replace_with, $data);		}					/**	 * Calculate the HMAC (keyed Hash Message Authentication Code)	 * 	 * Used to verify that the xml data has not been tampered with	 *	 * @param string $data	Requests XML data	 * @return binary 			Returns the HCMA-SHA-1 as binary	 */			function get_hmacsha1($data) {  	$key = $this->merchant_key;    $blocksize = 64;     if (strlen($key) > $blocksize) {    	$key = pack('H*', sha1($key));      }    $key = str_pad($key, $blocksize, chr(0x00));        $ipad = str_repeat(chr(0x36), $blocksize);    $opad = str_repeat(chr(0x5c), $blocksize);        $hmac = pack('H*', sha1(($key^$opad).pack('H*', sha1(($key^$ipad).$data))));        return $hmac;     }			}?>