<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
/*

Received from /Sub/Config.inc.php:
	$Global = An array containing preset config values.

Received from /Ipn/*.ipn.php: 
	$payer_id = ID of the person paying
	$payer = The payment processor id that the person paid with (if IPN payment)
	$payment_processor = The prefix used in the script for the payment processor used
	$payment_processor_name = The full name for the payment processor used
	
	$receiver_username = Username of the person receiving the money
	$expected_amount = The amount that was paid to the person receiving the money
	$payment_plan_id = The id of the payment plan, that the person receiving the money was paid under
	
	$program_id = The id of the program in question
	$program_name = The name of the program in question
	$program_type = If its a subscription or a normal payment
	$program_powerline = The number of powerlines in the program

	$user_payment_plan_id = The user payment plan id in question
	
	$plan_info = An array containing all the payment_plans in this user_payment_plan.
	
*/
$_SESSION['program_type'] = $program_type;

if ($_SESSION['debug'] == true) {
	echo "<br />LOGGING receiver=$receiver_username expected_amount=$expected_amount payment_plan_id=$payment_plan_id user_payment_plan=$user_payment_plan_id<br>plan_info:<br>";
	print_r($plan_info);
	echo "<br>admin_collects: $admin_collects admin_collects_tiers: $admin_collects_tiers ----<br>";
}
if ($admin_collects !== true && $admin_collects_tiers !== true) {
  //Normal payment received by the member
  if ($_SESSION['debug'] == true) echo 'calling logging-real';
  include $Global['path'].'apay/Logging-real.inc.php';
} else {
  //Admin receives some or all payments on behalf of others
    
  //Find out what payment type the selected payment plan is
 	$paymentPlanId = sanitize($payment_plan_id, 'payment_plan_id');

	$selectFields = 'plan_type';
	$mainTable = ['table' => 'payment_plan', 'as' => 'plan'];
	$where = [
		'plan.payment_plan_id' => ['=', $paymentPlanId]
	];

	$typeResult = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

	if ($typeResult) {
		$type_buffer = $typeResult[0]; // Assuming $typeResult is an array of results
	} else {
		// Handle the case where no results are found or an error occurs
		//echo "<br />Query failed or no results found<br />";
	}
  
  
  $process_type = $type_buffer['plan_type'];
  
  //Keep the real values
  $real_payment_plan_id = $payment_plan_id;
  $real_receiver_username = $receiver_username;
  $real_expected_amount = $expected_amount;
  foreach ($plan_info as $key => $value) { //Find out what payment type each payment plan is
 	$paymentPlanId = sanitize($key, 'payment_plan_id');

	$selectFields = 'plan_type';
	$mainTable = ['table' => 'payment_plan', 'as' => 'plan'];
	$where = [
		'plan.payment_plan_id' => ['=', $key]
	];

	$typeResult = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

	if ($typeResult) {
		$plantype_buffer = $typeResult[0]; // Assuming $typeResult is an array of results
	} else {
		// Handle the case where no results are found or an error occurs
		echo "<br />Plan info query failed or no results found in Logging.inc.<br />";
		exit;
	}	
    
    $plan_info[$key]['plan_type'] = $plantype_buffer['plan_type'];
    
  }
  //Then process all 
  foreach ($plan_info as $key => $value) {
    if ($value['plan_type'] == $process_type) {
	 if ($admin_collects_tiers === true || $admin_collects == true) {
      $receiver_username = $value['username'];
  		$payment_plan_id = $key;
  		
  		$expected_amount = $value['amount'];
  		
  		include $Global['path'].'apay/Logging-real.inc.php';
  		
  		$plan_info[$key]['complete'] = 'Y';
	   }
      }
    }
  
  //Lets set the payment plan and username back to the orginal values  
  $payment_plan_id = $real_payment_plan_id;
  $receiver_username = $real_receiver_username;
  $expected_amount = $real_expected_amount;
  }
?>