<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
// COPYRIGHT 2015 JIM SYMONDS, AUTOMATICWEBSOFTWARE.COM
include 'logincheck.php';
$pageName = 'Pay By Credit Card';
$pageDesc = '';
$pageIcon = 'icon-credit-card';
$pageAlign = 'center';
$pageClass = '';

//Select the correct program
if (!empty($_GET['program'])) $Global['program'] = intval($_GET['program']);
elseif (!empty($_SESSION['program'])) $Global['program'] = intval($_SESSION['program']);
else $Global['program'] = $Global['default_program'];
$program_id = $Global['program'];

if (!isset($_SESSION['p'.$program_id.'_status'])) { // WHEN THEY HAVE NO SESSION FOR THIS PAGE, THEY BOOKMARKED IT.
	// SO WE SEND THEM BACK TO PAY.PHP TO GET THEIR SESSION DATA SET UP, USED BELOW.
	header("Location: ./pay.php?program=".$_GET['program']);
	exit;
}
// Define the list of expected keys
$expectedKeys = [
    'FirstName', 'LastName', 'address', 'city', 'zip', 'country',
    'state', 'province', 'phone', 'ccnumber1', 'ccnumber2', 'ccnumber3', 'ccnumber4',
    'ccmonth', 'ccyear', 'ccv', 'ccsignature', 'selected', 'submit', 'thispagename'
];

// Initialize an array to hold the values, setting them all to an empty string initially
$values = array_fill_keys($expectedKeys, '');

// If there is POST data, overwrite the initial values with the actual submitted data where available
if (true || $_SERVER['REQUEST_METHOD'] === 'POST') {
    foreach ($expectedKeys as $key) {
        $values[$key] = $_POST[$key] ?? '';
    }
} 

foreach ($expectedKeys as $key) {
	$values[$key] = $_GET[$key] ?? '';
}	

// At this point, $values contains all the expected keys, 
// with actual POST values if submitted, or '' for any that weren't set or if no POST was made

if (!isset($_SESSION['debug'])) $_SESSION['debug'] = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
	// SECURE LOGIN FROM XSS ATTACKS!
	// ADDING IN - MUST ADD TO FORM!
	/*if ($_POST['csrf_token'] !== $_SESSION['csrf_token']) {
		//echo 'Token mismatch!';
		header("Location: /login.php");
		exit;
	}*/	
	//print_r($_POST);
	/*echo '<pre>';
	print_r($_SESSION);
	echo '</pre>';
	exit;*/
	if ($_SESSION['loggedin'] == 'demo') {
		//print_r($_POST);
		//exit;
	}	
}

//$GLOBALS['debug'] = true;
$Error_msg = ''; // INI VAR

// FORCE ADMIN COMPANY NAME WHEN ADMIN COLLECTS
// $payment_username = 'XYZ COMPANY, LLC';
if (!isset($_SESSION['test_credit_cards'])) $_SESSION['test_credit_cards'] = false;
if (($_SESSION['test_credit_cards'] == true && $_SERVER['REQUEST_METHOD'] != 'POST') || ($_SESSION['loggedin'] == 'test' || $_SESSION['loggedin'] == 'demo')) { 

	function random_cc_number ( $array ) {
	  $total = count($array);
	  $call = rand(0,$total-1);
	  return $array[$call];
	}
	$cc_number = array (
		//VISA
		"4012888888881881",	 
		"4111111111111111",
		"4003830171874018",

		//MASTERCARD
		"5419840000000003",
		"5105105105105100",
		"5500000000000004",
		"5431111111111111",
		"5496198584584769",

		//DISCOVER
		"6011000000000004"
	);
	$test_cc_number = random_cc_number($cc_number);
	$_POST['ccnumber'] = $test_cc_number;
	//$_POST['ccnumber'] = '4007000000027';
	$_POST['ccmonth'] = date('m');
	$_POST['ccyear'] = date('Y')+1;
	$_POST['ccv'] = '123';
	$_POST['ccsignature'] = $_SESSION['Firstname_loggedin']. " ".  $_SESSION['Lastname_loggedin'];
	
	$_POST['selected'] = 1; // AUTO FILL TERMS CHECKBOX!
	
	// CREATE FIRST DATA E4 TEST CREDENTIALS IF NEEDED, TO RUN TESTS, IF ADMIN OR PAYEE HAS NO E4
	/*if ($_SESSION['test_credit_cards'] === true) {
		$Global['use_E4'] = true;
		$buffer['e4MerchName'] = 'TEST MERCHANT NAME';
		$buffer['e4gatewayID'] = 1;
		$buffer['e4password'] = 1;
	}*/
} // END TEST CREDIT CARDS IS TRUE

// FREE TRIAL UPDATE

// THIS NEEDS TO BE UPDATED IN THE FUTURE TO SUPPORT GRABBING THE CC INFO, PRIOR TO FREE TRIAL
/*if ($_SESSION['freetrial'] == true && $_SESSION['freetrial_require_cc'] == false) { // FREE TRIAL IS TRUE, AND NO CREDIT CARD IS REQUIRED - SO SEND THEM TO THIS PAGE TO GET THEIR FREE TRIAL STATUS
header("Location: ./freetrial.php?program=".$_GET['program'].'&uid='.$_GET['uid'].'&dtype='.$_GET['dtype'].'&type='.$_GET['type'].'&method='.$_GET['method']);
exit;
}*/

// END FREE TRIAL UPDATE
// FREE TRIAL UPDATE

if (isset($_SESSION['freetrial']) && $_SESSION['freetrial'] == true) {
	$freetrial = true;
} else {
	$freetrial = false;
}

// RESET FREETRIAL SESSION FOR NEXT USE
if (isset($_SESSION['freetrial'])) unset($_SESSION['freetrial']);
/*
$prog_resultft = mysql_query("SELECT `freetrial_enabled`, `freetrial_require_cc`, `freetrial_days` FROM program WHERE program_id={$Global['program']}"); 
$prog_bufferft = mysql_fetch_assoc($prog_resultft);

$freetrial_enabled = $prog_bufferft['freetrial_enabled'];
$freetrial_require_cc = $prog_bufferft['freetrial_require_cc'];
$freetrial_days = $prog_bufferft['freetrial_days'];
*/
// END FREE TRIAL UPDATE

function encrypt($input) {
    global $GLOBALS;
    $key = $GLOBALS['member_taxid_algorythm_key'];	
    $method = 'AES-256-CBC';
    $ivLength = openssl_cipher_iv_length($method);
    $iv = openssl_random_pseudo_bytes($ivLength);
    $encrypted = openssl_encrypt($input, $method, $key, OPENSSL_RAW_DATA, $iv);
    return base64_encode($iv . $encrypted);
}

//We declare the constant required to include the payment files...
if (!defined('MODULE_PAYMENT')) {
    define('MODULE_PAYMENT', true);
}

// Dual Synchronous Code 
$DSflag = false;

// JS KLUDGE TO DISABLE DUAL SYNCH
$_SESSION['use_FirstData_DS'] = false;
//$_SESSION['program_collect'] == 'A' && 
if ($Global['use_FirstData_DS'] === true && $_SESSION['use_FirstData_DS'] != false) { // JS UPDATE FEB 12TH - FEB 2OTH WORKS WITH apay/Ipns.inc.php so we will not use dual synch if any payments are linkpoint or authnet!!!! 
            
            // Get ccomponents of Dual-Synchronous transactions
            $DSuid = $_GET['uid'];

            $result = mysql_query("SELECT user_payment_plan_id, plan_type FROM payment_plan WHERE payment_plan_id=$DSuid") or die(mysql_error());
  
            $buffer = mysql_fetch_assoc($result);
            
            $result = mysql_query("SELECT m.ID,p.user_payment_plan_id,p.payment_plan_id,p.payment_complete,m.paymentprocessor2 as dba,m.paymentprocessor5 as lpstore,m.paymentprocessor6 as lppem, m.e4gatewayID, m.e4password, m.e4MerchName, p.username,p.amount, m.payment_collected_by FROM (payment_plan as p join user_payment_plan as u) join members as m 
WHERE p.username = m.username AND p.user_payment_plan_id=u.user_payment_plan_id  AND p.user_payment_plan_id='{$buffer['user_payment_plan_id']}' AND p.plan_type='{$buffer['plan_type']}' ORDER BY p.payment_plan_id DESC") or die(mysql_error());

// REMOVE FROM ABOVE QRY 1/13/19 AND /* p.payment_complete!='Y' AND p.amount < 1000*/
		
            $DScount = 0;
            $DStotamount = 0;
            $DSflag = true;
            $DSarray = array(); // array of payees and amounts for DS
            while ($buffer = mysql_fetch_assoc($result)) {
				//if ($buffer['payment_collected_by'] != 'admin' && $buffer['ID'] != 1) continue; // ADDED BY DD 8/13/15 // COMMENTED BY JS 8/14 - BROKE PAGE
                $DScount++;
                $DStotamount += $buffer['amount'];
                $DSarray[$DScount]['ID'] = $buffer['ID'];
				$DSarray[$DScount]['payment_to'] = $buffer['ID'];
				$DSarray[$DScount]['payment_from'] = $_SESSION['UserID'];
                $DSarray[$DScount]['user_payment_plan_id'] = $buffer['user_payment_plan_id'];
                $DSarray[$DScount]['payment_plan_id'] = $buffer['payment_plan_id'];
                $DSarray[$DScount]['username'] = $buffer['username'];
                $DSarray[$DScount]['payment_complete'] = $buffer['payment_complete'];
                $DSarray[$DScount]['dba'] = $buffer['dba'];
                $DSarray[$DScount]['e4gatewayID'] = $buffer['e4gatewayID'];
				$DSarray[$DScount]['e4password'] = $buffer['e4password'];
				$DSarray[$DScount]['e4MerchName'] = $buffer['e4MerchName'];
				
				if ($_SESSION['test_credit_cards'] === true) {
					$DSarray[$DScount]['e4gatewayID'] = 1;
					$DSarray[$DScount]['e4password'] = 1;
					$DSarray[$DScount]['e4MerchName'] = 'TEST MERCHANT NAME';
				}
				
				//$DSarray[$DScount]['payment_type'] = $buffer['payment_type']; // - not in query anymore!

				if ($_GET['type'] == "E4") { 
					$DSarray[$DScount]['dba'] = $buffer['e4MerchName'];
				} else {
					$DSarray[$DScount]['dba'] = $buffer['dba'];
				}
                $DSarray[$DScount]['lpstore'] = $buffer['lpstore'];
                $DSarray[$DScount]['lppem'] = $buffer['lppem'];
                $DSarray[$DScount]['lppempath'] = $Global['linkpoint_path'].floor(($buffer['ID'] / 1000)).'/'.$buffer['ID'].'.pem';
                $DSarray[$DScount]['amount'] = $buffer['amount'];
                if ($DSarray[$DScount]['lppem'] != "Yes" && $DSarray[$DScount]['e4gatewayID'] == "") {

   
                    $DSflag = false;
                    $DScount--;
                }
            } // END WHILE LOOP
            if ($DScount <= 1) { 
                $DScount=1; 
                $DSarray[$DScount]['amount'] = $DStotamount;
            }
} 
  // DEBUG
if ($_SESSION['debug'] == true && $_POST) {
echo "<br/>Debugging Statements from apay/cc.php<br/>POST:<br/>";
print_r($_POST);
echo "<br/>DSArray<br/>";
print_r($DSarray);
echo "<br/><br/>";
echo "DScount $DScount DSflag ".(($DSflag) ? "TRUE":"FALSE")."<br/>";
//exit;
}

// END DUAL-SYNCH code
//First find out if its an admin collect everything or a normal payment
// Sanitize the input
$uid = sanitize((int)$_GET['uid'], 'uid');

//$uid = (int)$_GET['uid'];

// Define the select fields
$selectFields = 'real_prog.program_collect, prog.*, plan.*, master.*';

// Define the main table with alias
$mainTable = ['table' => 'payment_plan', 'as' => 'plan'];

// Define the join conditions
$joinConditions = [
    ['table' => 'user_payment_plan', 'as' => 'master', 'condition' => 'plan.user_payment_plan_id = master.user_payment_plan_id'],
    ['table' => 'user_program', 'as' => 'prog', 'condition' => 'master.user_program_id = prog.user_program_id'],
    ['table' => 'program', 'as' => 'real_prog', 'condition' => 'prog.program_id = real_prog.program_id']
];

// Define the where conditions
$where = [
    'plan.amount' => ['<', 100000],
    'plan.payment_plan_id' => ['=', $uid]
];

// Perform the select query
$resultPlan = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, 0, 1);

// Extract the first row from the result
if ($resultPlan) {
    $buffer = $resultPlan[0];
    $bufferPlan = $resultPlan[0];	
} else {
    // Handle the case where no results are found or an error occurs
}

if (empty($buffer['program_collect'])) {
	echo 'Pay plan cc page error. Contact support';
	exit;
}
//echo 'jim '.$uid; 
//print_r($buffer); 
//print_r($bufferPlan); exit;

// NEXT 4 VARS USED IN Logging_real.inc
$new_status = $buffer['user_status']; 
$new_sign_id = $buffer['sign_id']; 
$new_sponsorid = $buffer['sponsorid'];
$new_powerline_sponsorid = $buffer['powerline_sponsor'];

$admin_collects = false;

if (!isset($_SESSION['program_collect'])) { 
$_SESSION['program_collect'] = $Global['program_collect'];
}
// JS 12/6/14 DECIDE WHO SHOULD COLLECT THE PAYMENTS!
if ($_SESSION['program_collect'] == 'E') {
	$buffer['program_collect'] = 'E';
	$admin_collects = false;
} else if ($_SESSION['program_collect'] == 'A') {
	$buffer['program_collect'] = 'A';
	$admin_collects = true;
}
if ($_SESSION['program_collect'] != '') {
	$Global['program_collect'] = $_SESSION['program_collect'];
}

// Change for Dual Synchronous Linkpoint: Set $admin_collect=true only if not qualified for FirstData DS 
if ($_SESSION['program_collect'] == 'A' && $DSflag != true) {
	
	//$admin_collects = ($buffer['program_collect'] == 'A') ? true:false;
    $adminUsername = sanitize($Global['administrator'], 'administrator');

    $selectFields = 'memb.ID, memb.Username, memb.Last_Name, memb.paymentprocessor3, memb.paymentprocessor4, memb.paymentprocessor5, memb.e4gatewayID, memb.e4password, memb.e4MerchName';
    $mainTable = ['table' => 'members', 'as' => 'memb'];
	$joinConditions = [];
    $where = [
        'memb.Username' => ['=', $adminUsername]
    ];
} else {
    $uid = sanitize((int)$_GET['uid'], 'uid');

    $selectFields = 'plan.payment_plan_id, memb.ID, memb.Username, memb.Last_Name, memb.paymentprocessor3, memb.paymentprocessor4, memb.paymentprocessor5, memb.e4gatewayID, memb.e4password, memb.e4MerchName';
    $mainTable = ['table' => 'payment_plan', 'as' => 'plan'];
    $joinConditions = [
        ['table' => 'members', 'as' => 'memb', 'condition' => 'plan.username = memb.Username']
    ];
    $where = [
        'plan.payment_plan_id' => ['=', $uid]
    ];
}

$admin_collects_tiers = ($buffer['program_collect'] == 'EAT') ? true : false;

$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, 0, 1);

if ($result) {
    $buffer = $result[0]; // Assuming $result is an array of results
	if ($_SESSION['program_collect'] == 'A') $buffer_admin_override = $result[0];
} else {
    // Handle the case where no results are found or an error occurs
}


$paid_to_user_id = $buffer['ID'];


$Global['cc_process_login'] = $buffer['paymentprocessor3'];
$Global['cc_process_tran_key'] = base64_decode($buffer['paymentprocessor4']);

$Global['e4gatewayID'] = $buffer['e4gatewayID'];
$Global['e4password'] = $buffer['e4password'];
$Global['e4merch'] = $buffer['e4MerchName'];

if ($_SESSION['test_credit_cards'] === true) {
	$Global['e4gatewayID'] = 1;
	$Global['e4password'] = 1;
	$Global['e4Merch'] = 'TEST MERCHANT NAME';
}

if ($_SESSION['debug']) {
	echo "Auth Net. Credentials receiving: ".$Global['cc_process_login']."<br/>";
	echo "E4 gateway ID Credentials receiving: ".$Global['e4gatewayID']."<br/>";
	echo "E4 gateway password Credentials receiving: ".$Global['e4password']."<br/>";
}


//get the member info
$loggedInUser = sanitize($_SESSION['loggedin'], 'loggedin');

$selectFields = 'm.email, m.First_Name, m.Last_Name, m.province, ml.*';
$mainTable = ['table' => 'members', 'as' => 'm'];
$joinConditions = [
    ['table' => 'member_link', 'as' => 'ml', 'condition' => 'm.ID = ml.ID']
];
$where = [
    'm.Username' => ['=', $loggedInUser]
];
$limit = 1;

$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, $limit, 1);

if ($result) {
    $memberInfo = $result[0]; // Assuming $result is an array of results
} else {
    // Handle the case where no results are found or an error occurs
}


if ($_SESSION['debug'] == true) {
echo "<br/>memberInfo<br/>";
print_r($memberInfo);
echo "<br/>";
}

//check to see if we have to save any user details
if (isset($_POST['submit']) && isset($_POST['thispagename']) && $_POST['thispagename'] == 'cc') {
	
	
	if (isset($_POST['ccnumber1'], $_POST['ccnumber2'], $_POST['ccnumber3'], $_POST['ccnumber4'])) {
		$_POST['ccnumber'] = $_POST['ccnumber1'] . $_POST['ccnumber2'] . $_POST['ccnumber3'] . $_POST['ccnumber4'];
		// Now you can use $ccnumber for further processing
	} else {
		$_POST['ccnumber'] = '';
	}		
	
	
	if (isset($_POST['state']) && $_POST['state'] != '1') {
		$state_exists = false;

		//$state_result = mysql_query("SELECT COUNT(*) FROM states WHERE abbrev='".mysql_real_escape_string(strtoupper($_POST['state']))."'");

		//if (mysql_result($state_result, 0) != 0) {
			$state_exists = true;
			//}
		}
	elseif (isset($_POST['state']) && $_POST['state'] == '1' && ((isset($_POST['country']) && strtoupper($_POST['country']) != 'US') || (!isset($_POST['country']) && strtoupper($memberInfo['country']) != 'US'))) {
		$state_exists = true;
		}
	elseif (isset($_POST['state'])) {
		$state_exists = false;
		}

	if (isset($_POST['country'])) {
		$country_exists = false;

		//$country_result = mysql_query("SELECT COUNT(*) FROM country WHERE iso='".mysql_real_escape_string(strtoupper($_POST['country']))."'");

		//if (mysql_result($country_result, 0) != 0) {
			$country_exists = true;
			//}
		}
	//ADD SHIPPING ADDRESS INFO
  if ($Global['use_shipping'] === true) {
	if (isset($_POST['ship_state']) && $_POST['ship_state'] != '1') {
		$ship_state_exists = false;

		//$state_result = mysql_query("SELECT COUNT(*) FROM states WHERE abbrev='".mysql_real_escape_string(strtoupper($_POST['ship_state']))."'");

		//if (mysql_result($state_result, 0) != 0) {
			$ship_state_exists = true;
			//}
		}
	elseif (isset($_POST['ship_state']) && $_POST['ship_state'] == '1' && ((isset($_POST['ship_country']) && strtoupper($_POST['ship_country']) != 'US') || (!isset($_POST['ship_country']) && strtoupper($memberInfo['ship_country']) != 'US'))) {
		$ship_state_exists = true;
		}
	elseif (isset($_POST['ship_state'])) {
		$ship_state_exists = false;
		}

	if (isset($_POST['ship_country'])) {
		$ship_country_exists = false;

		//$country_result = mysql_query("SELECT COUNT(*) FROM country WHERE iso='".mysql_real_escape_string(strtoupper($_POST['ship_country']))."'");

		//if (mysql_result($country_result, 0) != 0) {
			$ship_country_exists = true;
			//}
		}
}
        
	if (isset($state_exists) && $state_exists === false) {
		$Error_msg = 'Please select a state.';
		}
	elseif (isset($country_exists) && $country_exists === false) {
		$Error_msg = 'Please select a country.';
		}
// ADD SHIPPING INFO

    elseif (($Global['use_shipping'] === true) && isset($ship_state_exists) && $ship_state_exists === false) {
		$Error_msg = 'Please select a shipping state.';
		}
	elseif (($Global['use_shipping'] === true) && isset($ship_country_exists) && $ship_country_exists === false) {
		$Error_msg = 'Please select a shipping country.';
		}

	/* // EMAIL IS NOT A FIELD IN THE CC FORM!
	elseif (isset($_POST['email']) && !preg_match('/^[-!#$%&\'*+\\.\/0-9=?A-Z^_`{|}~]+@([-0-9A-Z]+\.)+([0-9A-Z]){2,4}$/i', trim($_POST['email']))) {
		$Error_msg = 'Please use a valid email address.';
		}*/
	elseif (isset($_POST['FirstName']) && empty($_POST['FirstName'])) {
		$Error_msg = 'Please fill out the first name field.';
		}
    elseif (!isValidName($_POST['FirstName'])) {
        // This error message covers both the character type and length validation
        $Error_msg = 'Please enter a valid first name.';
		}		
	elseif (isset($_POST['LastName']) && empty($_POST['LastName'])) {
		$Error_msg = 'Please fill out the last name field.';
		}
    elseif (!isValidName($_POST['LastName'])) {
        // This error message covers both the character type and length validation
        $Error_msg = 'Please enter a valid last name.';
		}		
	elseif (isset($_POST['address']) && empty($_POST['address'])) {
		$Error_msg = 'Please fill out the address field.';
		}
	elseif (isset($_POST['city']) && empty($_POST['city'])) {
		$Error_msg = 'Please fill out the city field.';
		}
	elseif (isset($_POST['zip']) && empty($_POST['zip'])) {
		$Error_msg = 'Please fill out the zip code field.';
		}
 	elseif (($Global['use_shipping'] === true) && isset($_POST['ship_address']) && empty($_POST['ship_address'])) {
		$Error_msg = 'Please fill out the address field.';
		}
	elseif (($Global['use_shipping'] === true) && isset($_POST['ship_city']) && empty($_POST['ship_city'])) {
		$Error_msg = 'Please fill out the city field.';
		}
	elseif (($Global['use_shipping'] === true) && isset($_POST['ship_zip']) && empty($_POST['ship_zip'])) {
		$Error_msg = 'Please fill out the zip code field.';
		}

// END SHIPPING INFO
	elseif (isset($_POST['phone']) && empty($_POST['phone'])) {
		$Error_msg = 'Please fill out the phone field.';
		}		
	elseif (!isset($_POST['ccnumber']) || empty($_POST['ccnumber']) || !is_numeric($_POST['ccnumber'])) {
		$Error_msg = 'Please fill out the credit card number and ensure it is numeric.';
	}
	elseif (isset($_POST['ccnumber']) && (strlen($_POST['ccnumber']) < 13 || strlen($_POST['ccnumber']) > 19)) {
		echo 'Invalid card number length. Please ensure the card number is between 13 and 19 digits.';
		} 
	elseif (isset($_POST['ccyear']) && $_POST['ccyear'] == date('Y') && isset($_POST['ccmonth']) && $_POST['ccmonth'] < date('m')) {
		$Error_msg = 'Please select a valid date.';
		}
	elseif (isset($_POST['ccv']) && empty($_POST['ccv']) || !is_numeric($_POST['ccv'])) {
		$Error_msg = 'Please fill out the cvv security code (back of card).';
		}
	elseif (isset($_POST['ccsignature']) && empty($_POST['ccsignature'])) {
		$Error_msg = 'Please fill out your Name on Card, as it appears on your credit card.';
		}
    elseif (!isValidFullName($_POST['ccsignature'])) {
        // This error message covers both the character type and length validation
        $Error_msg = 'Please fill out Name on Card, as it appears on your credit card.';
		}		

} // END POST SUBMIT		
/* REMOVE ASKING FOR TAX ID DURING PAYMENT - REMOVED MAY 24, 2012
	elseif ($Global['member_taxid'] === true && isset($_POST['tax_id']) && empty($_POST['tax_id'])) {
		$Error_msg = 'Please fill out the Tax ID field.';
		}
*/

	//if there are no errors save the data
	if (empty($Error_msg)) {

		//the update fields and values for the members table
		$update_body = "";

		//form the query for the members table
		if (!empty($_POST['FirstName'])) {
			if (!empty($update_body)) {
				$update_body .= ", ";
				}
			//$update_body .= "First_Name='".mysql_real_escape_string($_POST['FirstName'])."'";
			$memberInfo['First_Name'] = $_POST['FirstName'];
			}

		if (!empty($_POST['LastName'])) {
			if (!empty($update_body)) {
				$update_body .= ", ";
				}
			//$update_body .= "Last_Name='".mysql_real_escape_string($_POST['LastName'])."'";
			$memberInfo['Last_Name'] = $_POST['LastName'];
			}

		if (!empty($_POST['email'])) {
			if (!empty($update_body)) {
				$update_body .= ", ";
				}
			//$update_body .= "email='".mysql_real_escape_string($_POST['email'])."'";
			$memberInfo['email'] = $_POST['email'];
			}
			
		if (!empty($_POST['province'])) {
			if (!empty($update_body)) {
				$update_body .= ", ";
				}
			//$update_body .= "province='".mysql_real_escape_string($_POST['province'])."'";
			$memberInfo['province'] = $_POST['province'];
			}

		/*if (!empty($update_body)) {
			$query = "UPDATE
									members
								SET
									".$update_body."
								WHERE
									ID=".(int)$memberInfo['ID'];
			mysql_query($query) or die(mysql_error());
			}*/

		//the update fields and values for the member_link table
		$update_body_ml = "";

		if (!empty($_POST['address'])) {
			if (!empty($update_body_ml)) {
				$update_body_ml .= ", ";
				}
			//$update_body_ml .= "address='".mysql_real_escape_string($_POST['address'])."'";
			$memberInfo['address'] = $_POST['address'];
			}

		if (!empty($_POST['city'])) {
			if (!empty($update_body_ml)) {
				$update_body_ml .= ", ";
				}
			//$update_body_ml .= "city='".mysql_real_escape_string($_POST['city'])."'";
			$memberInfo['city'] = $_POST['city'];
			}

		if (!empty($_POST['zip'])) {
			if (!empty($update_body_ml)) {
				$update_body_ml .= ", ";
				}
			//$update_body_ml .= "zip='".mysql_real_escape_string($_POST['zip'])."'";
			$memberInfo['zip'] = $_POST['zip'];
			}

		if (!empty($_POST['state'])) {
			if (!empty($update_body_ml)) {
				$update_body_ml .= ", ";
				}
			//$update_body_ml .= "state='".mysql_real_escape_string($_POST['state'])."'";
			$memberInfo['state'] = $_POST['state'];
			}

		if (!empty($_POST['country'])) {
			if (!empty($update_body_ml)) {
				$update_body_ml .= ", ";
				}
			//$update_body_ml .= "country='".mysql_real_escape_string($_POST['country'])."'";
			$memberInfo['country'] = $_POST['country'];
			}
   // ADD SHIPPING INFO
  if ($Global['use_shipping'] === true) {
   		if (!empty($_POST['ship_address'])) {
			if (!empty($update_body_ml)) {
				$update_body_ml .= ", ";
				}
			//$update_body_ml .= "ship_address='".mysql_real_escape_string($_POST['ship_address'])."'";
			$memberInfo['ship_address'] = $_POST['ship_address'];
			}

   		if (!empty($_POST['ship_address2'])) {
			if (!empty($update_body_ml)) {
				$update_body_ml .= ", ";
				}
			//$update_body_ml .= "ship_address2='".mysql_real_escape_string($_POST['ship_address2'])."'";
			$memberInfo['ship_address2'] = $_POST['ship_address2'];
			}

		if (!empty($_POST['ship_city'])) {
			if (!empty($update_body_ml)) {
				$update_body_ml .= ", ";
				}
			//$update_body_ml .= "ship_city='".mysql_real_escape_string($_POST['ship_city'])."'";
			$memberInfo['ship_city'] = $_POST['ship_city'];
			}

		if (!empty($_POST['ship_zip'])) {
			if (!empty($update_body_ml)) {
				$update_body_ml .= ", ";
				}
			//$update_body_ml .= "ship_zip='".mysql_real_escape_string($_POST['ship_zip'])."'";
			$memberInfo['ship_zip'] = $_POST['ship_zip'];
			}

		if (!empty($_POST['ship_state'])) {
			if (!empty($update_body_ml)) {
				$update_body_ml .= ", ";
				}
			//$update_body_ml .= "ship_state='".mysql_real_escape_string($_POST['ship_state'])."'";
			$memberInfo['ship_state'] = $_POST['ship_state'];
			}

		if (!empty($_POST['ship_country'])) {
			if (!empty($update_body_ml)) {
				$update_body_ml .= ", ";
				}
			//$update_body_ml .= "ship_country='".mysql_real_escape_string($_POST['ship_country'])."'";
			$memberInfo['ship_country'] = $_POST['ship_country'];
			}
}
   // END SHIPPING INFO

		if (!empty($_POST['phone'])) {
			if (!empty($update_body_ml)) {
				$update_body_ml .= ", ";
				}
			//$update_body_ml .= "phone='".mysql_real_escape_string($_POST['phone'])."'";
			$memberInfo['phone'] = $_POST['phone'];
			}
/* REMOVE REQUIREMENT TO ENTER TAX ID AT TIME OF PAYMENT - May 24, 2012
		if ($Global['member_taxid'] === true && !empty($_POST['tax_id'])) {
			if (!empty($update_body_ml)) {
				$update_body_ml .= ", ";
				}
			$update_body_ml .= "tax_id='".mysql_real_escape_string($_POST['tax_id'])."'";
			$memberInfo['tax_id'] = encrypt($_POST['tax_id']);
			}
*/

		/*if (!empty($update_body_ml)) {
			$query = "UPDATE
									member_link
								SET
									".$update_body_ml."
								WHERE
									ID=".(int)$memberInfo['ID'];
			mysql_query($query) or die(mysql_error());
		}*/
		}

//create the string with the fields that are empty and should be shown to the user to fill them in
//change so name and billing address are shown regardless
$add_info = '';
if (TRUE) {
	

	
	
	$add_info .= '<tr>
					<td>
						First Name:&nbsp;
					</td>
					<td>
					
<input class="form-control" type="text" name="FirstName" value="'.((!empty($memberInfo['First_Name'])) ? $memberInfo['First_Name']:'').'">
					</td>
				</tr>';
	}
if (TRUE) {
	$add_info .= '<tr>
					<td>
						Last Name:&nbsp;
					</td>
					<td>

						<input class="form-control" type="text" name="LastName" value="'.((!empty($memberInfo['Last_Name'])) ? $memberInfo['Last_Name']:'').'">
					</td>
				</tr>';
	}
if (TRUE) {
	$add_info .= '<tr>
					<td>
						Billing Address:&nbsp;
					</td>
					<td>
				
					<input class="form-control" type="text" name="address" value="'.((!empty($memberInfo['address'])) ? $memberInfo['address']:'').'">
					</td>
				</tr>';
	}
if (TRUE) {
	$add_info .= '<tr>
					<td>
						Billing City:&nbsp;
					</td>
					<td>
				
					<input class="form-control" type="text" name="city" value="'.((!empty($memberInfo['city'])) ? $memberInfo['city']:'').'">
					</td>
				</tr>';
	}
if (TRUE) {
	$add_info .= '<tr>
					<td>
						Billing Zip:&nbsp;
					</td>
					<td>
				
					<input class="form-control" type="text" name="zip" value="'.((!empty($memberInfo['zip'])) ? $memberInfo['zip']:'').'">
					</td>
				</tr>';
	}
if (TRUE) {
	$add_info .= '<tr>
					<td>
						Billing Country:&nbsp;
					</td>
					<td>
						<select name="country" class="form-control" onchange="show_other(this.value)">';
	if (empty($memberInfo['country'])) $memberInfo['country'] = 'US';

	// SHOW ALL COUNTRIES!
	$selectFields = '*';
	$mainTable = ['table' => 'country', 'as' => 'c'];

	$resultc = select($selectFields, $mainTable, [], ['1'], null, null, null, 0, 1);

	foreach ($resultc as $buffer) {

		if (strtoupper($memberInfo['country']) == $buffer['iso']) $selected = 'selected';
		else $selected = '';

		$add_info .= '<option value="'.$buffer['iso'].'" '.$selected.'>'.$buffer['printable_name'].'</option>';
		}
	$add_info .= '</select>
					</td>
				</tr>';
	}
if (TRUE) {
	$add_info .= '<tr id="state">
					<td>
						Billing State:&nbsp;
					</td>
					<td>
						<select name="state" class="form-control" >';
	$add_info .= '<option value="">Please select a state</option><option value="1" '.((!empty($memberInfo['state']) && strtoupper($memberInfo['state']) == 1)?'selected':'').'>Not applicable</option>';

	// SHOW ALL STATES!
	$selectFields = ['*'];
	$mainTable = 'states';

	$results = select($selectFields, $mainTable, [], ['1'], null, null, null, 0, 1);

	foreach ($results as $buffer) {
		if (!empty($memberInfo['state']) && strtoupper($memberInfo['state']) == $buffer['abbrev']) $selected = 'selected';
		else $selected = '';

		$add_info .= '<option value="'.$buffer['abbrev'].'" '.$selected.'>'.$buffer['name'].'</option>';
		}
	$add_info .= '</select>
					</td>

				</tr>';

	$add_info .= '<tr id="province">
					<td>
						Billing State or Province:&nbsp;
					</td>
					<td>
			
					<input class="form-control" type="text" name="province" value="'.((!empty($memberInfo['province'])) ? $memberInfo['province']:'').'">
					</td>
				</tr>';
	} 
if (TRUE) {
	$add_info .= '<tr>
					<td>
						Billing Phone:&nbsp;
					</td>
					<td>
		
				<input class="form-control" type="text" name="phone" value="'.((!empty($memberInfo['phone'])) ? $memberInfo['phone']:'').'">
					</td>
				</tr>';
	}
/* REMOVE REQUIREMENT TO ENTER TAX ID AT TIME OF PAYMENT - MAY 24, 2012
if ($Global['member_taxid'] === true && empty($memberInfo['tax_id'])) {
	$add_info .= '<tr>
					<td>
						Tax ID (SS#):&nbsp;
					</td>
					<td>
						<input class="form-control" type="text" name="tax_id" value="'.((!empty($_POST['tax_id'])) ? $_POST['tax_id']:'').'">
					</td>
				</tr>';
	}
*/
if (empty($memberInfo['email'])) {
	$add_info .= '<tr>
					<td>
						Billing Email:&nbsp;
					</td>
					<td>
						<input class="form-control" type="text" name="email" value="'.((!empty($_POST['email'])) ? $_POST['email']:'').'">
					</td>
				</tr>';
	}
// ADD SHIPPING INFO
//create the string with the fields that are empty and should be shown to the user to fill them in
if ($Global['use_shipping'] === true) {
$add_ship_info = '';

if (empty($memberInfo['ship_address'])) {
	$add_ship_info .= '<tr>
					<td width="40%" align="right">
						Shipping Address:&nbsp;
					</td>
					<td width="60%">
						<input  type="text" name="ship_address" value="'.((!empty($_POST['ship_address'])) ? $_POST['ship_address']:'').'">
					</td>
				</tr>';
	}

if (empty($memberInfo['ship_city'])) {
	$add_ship_info .= '<tr>
					<td width="40%" align="right">
						Shipping City:&nbsp;
					</td>
					<td width="60%">
						<input  type="text" name="ship_city" value="'.((!empty($_POST['ship_city'])) ? $_POST['ship_city']:'').'">
					</td>
				</tr>';
	}
if (empty($memberInfo['ship_zip'])) {
	$add_ship_info .= '<tr>
					<td width="40%" align="right">
						Ship Zip:&nbsp;
					</td>
					<td width="60%">
						<input  type="text" name="ship_zip" value="'.((!empty($_POST['ship_zip'])) ? $_POST['ship_zip']:'').'">
					</td>
				</tr>';
	}
if (empty($memberInfo['ship_state']) && empty($memberInfo['ship_province'])) {
	$add_ship_info .= '<tr>
					<td width="40%" align="right">
						Shipping State:&nbsp;
					</td>
					<td width="60%">
						<select name="ship_state" class="form-control">';
	$add_ship_info .= '<option value="">Please select a state</option><option value="1" '.((!empty($_POST['ship_state']) && strtoupper($_POST['ship_state']) == 1)?'selected':'').'>Not applicable</option>';

	// SHOW ALL STATES!
	foreach ($results as $buffer) {
		if (!empty($_POST['ship_state']) && strtoupper($_POST['ship_state']) == $buffer['abbrev']) $selected = 'selected';
		else $selected = '';

		$add_ship_info .= '<option value="'.$buffer['abbrev'].'" '.$selected.'>'.$buffer['name'].'</option>';
		}
	$add_ship_info .= '</select>
					</td>
				</tr>';

	$add_ship_info .= '<tr>
					<td width="40%" align="right">
						&nbsp;
					</td>
					<td width="60%">
						If you are located outside the USA, please select "Not Applicable" in the drop down box above, and add your Province/State name in the box below. Thank you.
					</td>
				</tr>';

	$add_ship_info .= '<tr>
					<td width="40%" align="right">
						Shipping Province:&nbsp;
					</td>
					<td width="60%">
						<input  type="text" name="ship_province" value="'.((!empty($_POST['ship_province'])) ? $_POST['ship_province']:'').'">
					</td>
				</tr>';
}
if (empty($memberInfo['ship_country'])) {
	$add_ship_info .= '<tr>
					<td width="40%" align="right">
						Shipping Country:&nbsp;
					</td>
					<td width="60%">
						<select name="ship_country">';
	if (empty($_POST['ship_country'])) $_POST['ship_country'] = 'US';


	foreach ($resultc as $buffer) {
		if (strtoupper($_POST['ship_country']) == $buffer['iso']) $selected = 'selected';
		else $selected = '';

		$add_ship_info .= '<option value="'.$buffer['iso'].'" '.$selected.'>'.$buffer['printable_name'].'</option>';
		}
	$add_ship_info .= '</select>
					</td>
				</tr>';
	}
} // END SHIPPING INFO
if (!empty($add_info)) {
	$add_info = '<tr><td colspan="2" align="center"><strong><h2>Billing Profile Information</h2></strong></td></tr>'.$add_info;
}
// CHANGED FOR SHIPPING INFO
  if ($Global['use_shipping'] === true) {
   if (!empty($add_ship_info)) {
    $add_info .= '<tr><td colspan="2" align="center"><strong>Shipping Profile Information</strong></td></tr>';
    $add_info .= '<tr><td colspan="2" align="center">Check if Same as Billing Information&nbsp;<input  type="checkbox" name="ship_copy" OnClick="javascript:ShipToBillPerson(this.form);" value="checkbox"></tr>'
    .$add_ship_info;
   
    }
}
if (!empty($add_info)) {

// END CHANGE FOR SHIPPING INFO    
	$add_info .= '<tr><td colspan="2">&nbsp;</td></tr><tr><td colspan="2" align="center"><strong><h2>Payment Information</h2></strong></td></tr>';
}

$programId = sanitize($Global['program'], 'program');

$selectFields = '*';
$mainTable = ['table' => 'program', 'as' => 'p'];
$where = [
    'program_id' => ['=', $programId]
];

$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

if ($result) {
    $buffer = $result[0]; // Assuming $result is an array of results
} else {
    // Handle the case where no results are found or an error occurs
}


//Make sure the program exists
if (empty($buffer['program_id'])) {
	echo 'Program does not exist!';
	exit;
}	

$_SESSION['program'] = $buffer['program_id'];
$Global['program'] = $_SESSION['program'];

$Global['program_type'] = $buffer['program_type'];
$Global['up_tier'] = $buffer['program_tier'];
$Global['up_powerline'] = $buffer['program_up'];
$Global['powerline_order'] = explode(',', $buffer['program_up_order']);
$Global['tier_amount']['N'] = $buffer['program_tier_pay'];
$Global['powerline_amount']['N'] = $buffer['program_up_pay'];
$Global['admin_amount']['N'] = $buffer['program_admin_pay'];
$Global['tier_unpaid'] = $buffer['program_tier_unpaid_level'];
$Global['tier_type'] = $buffer['program_tier_type'];
$Global['powerline_type'] = $buffer['program_up_type'];
$Global['admin_type'] = $buffer['program_admin_type'];

$Global['year_enabled'] = ($buffer['program_year_enabled'] == 'Y')?true:false;
$Global['tier_amount']['Y'] = $buffer['program_tier_year'];
$Global['powerline_amount']['Y'] = $buffer['program_up_year'];
$Global['admin_amount']['Y'] = $buffer['program_admin_year'];

$Global['life_enabled'] = ($buffer['program_life_enabled'] == 'Y')?true:false;
$Global['tier_amount']['L'] = $buffer['program_tier_life'];
$Global['powerline_amount']['L'] = $buffer['program_up_life'];
$Global['admin_amount']['L'] = $buffer['program_admin_life'];


//Select the correct payment duration (normal, year, life)
if (!empty($_GET['dtype']) && $_GET['dtype'] == 'Y' && $Global['year_enabled'] === true) {
	$Global['payment_duration'] = 'Y';
	$Global['payment_duration_name'] = 'Yearly';
} else if (!empty($_GET['dtype']) && $_GET['dtype'] == 'L' && $Global['life_enabled'] === true) {
	$Global['payment_duration'] = 'L';
	$Global['payment_duration_name'] = 'Lifetime';	
	$Global['tier_type'] = 'N';
	$Global['powerline_type'] = 'N';
	$Global['admin_type'] = 'N';
} else {
	$Global['payment_duration'] = 'N';
	$Global['payment_duration_name'] = 'Normal';
}

//Select the correct payment period, only used on normal and yearly payments
if ($Global['payment_duration'] == 'Y') {
	$Global['sub_period'] = $buffer['program_year_period'];
} else {
	$Global['sub_period'] = $buffer['program_sub_period'];
}

if (isset($_SESSION['oto']) && $_SESSION['oto'] == true) $Global['sub_period'] = $_SESSION['oto_sub_period'];	

$Global['program_name'] = $buffer['program_name'];
$Global['program_short_desc'] = $buffer['program_short_desc'];
$Global['program_desc'] = $buffer['program_desc'];

$Global['header'] = $buffer['header_file'];
$Global['footer'] = $buffer['footer_file'];

//Find out if the user already have a payment plan for this one
$user_id = $_SESSION['UserID'];
$user_status = $_SESSION['p'.$program_id.'_status'];
$user_expire = $_SESSION['p'.$program_id.'_expire'];

$user_program_id = $_SESSION['p'.$program_id.'_upid'];
$user_expire_time = $_SESSION['p'.$program_id.'_expire'];

$normal_member = false;
$comped_member = false;
$subscription_member = false;
$before_billing_extend = false;


//$user_payment_plan_id = $buffer['user_payment_plan_id']; // THIS LINE WAS MISSING, SO STARTED TO ADD, BUT DARIUS SAYS NOT TO ADD - LEAVING HERE IN CASE WE NEED IT LATER
$user_paymentplan_id = $bufferPlan['user_payment_plan_id']; 
$upp_payment_duration = $bufferPlan['payment_program']; // N for normal (monthly) period, Y for Yearly, L for Lifetime

$GLOBALS['payment_program'] = $bufferPlan['payment_program'];

$plan = array();

foreach ($resultPlan as $buffer) {

	if ($buffer['plan_type'] == 'S' || ($buffer['plan_type'] == 'N' && $buffer['payment_period'] == 0)) {
		$plan[] = array('id' => $buffer['payment_plan_id'], 'username' => $buffer['username'], 'status' => $buffer['user_status'], 'amount' => $buffer['amount'], 'type' => $buffer['payment_type'], 'tier' => $buffer['payment_tier_level'], 'complete' => (($buffer['plan_type'] == 'N' && $buffer['payment_period'] > 0)?'Y':$buffer['sec_payment_complete']), 'date' => $buffer['last_paid_date'], 'period' => $buffer['payment_period'], 'first_date' => $buffer['first_paid_date']);
	
		$pp_amount = $buffer['amount'];
	
		if (intval($_GET['uid']) == $buffer['payment_plan_id']) {			
		$payment_username = $buffer['username'];
		$payment_type = program_type($buffer['payment_type'], $buffer['payment_tier_level'], $Global['admin_amount']['N'], true);
			
			//find a way to do this properly... so it works in old authorize as well
			
			$payment_amount = $buffer['amount'];
			
			if ($buffer['plan_type'] == 'S') {
				$payment_amount_real = $buffer['amount']; //auth sub
				}
			else {
				$amount_real = $buffer['amount'];
				}
				
			$plan_real_type = $buffer['plan_type'];	
			$payment_real_type = $buffer['payment_type'];	
		}
	}
}


	
if ($admin_collects === true || ($admin_collects_tiers === true && ($payment_real_type == 'T' || strtolower($payment_username) == "admin"))) {
  if (!function_exists('admin_collects')) include $Global['path'].'apay/payment_collect.inc.php';
      
  if ($admin_collects_tiers === true) $value = admin_collects_single_tiers((int) $_GET['uid']);
  else $value = admin_collects_single($_GET['uid']);

	// Get Credentials for Admin user since Admin will be collecting this payment.  This will overwrite the credentials earlier.
	$user_id = $buffer_admin_override['ID'];

	$lp_path = $Global['linkpoint_path'].floor(($buffer_admin_override['ID'] / 1000)).'/'.$buffer_admin_override['ID'].'.pem';

	$Global['cc_process_login'] = $buffer_admin_override['paymentprocessor3'];
	$Global['cc_process_tran_key'] = base64_decode($buffer_admin_override['paymentprocessor4']);
	//$Global['lp_store'] = $buffer_admin_override['paymentprocessor5'];
	//$Global['lp_certificate'] = ((file_exists($lp_path))?$lp_path:false);
	$Global['e4gatewayID'] = $buffer_admin_override['e4gatewayID'];
	$Global['e4password'] = $buffer_admin_override['e4password'];
	$Global['e4MerchName'] = $buffer_admin_override['e4MerchName'];

	if ($_SESSION['debug']) {
	echo "Admin Auth Net. Credentials receiving: ".$Global['cc_process_login']."<br/>";
	echo "Admin E4 gateway ID Credentials receiving: ".$Global['e4gatewayID']."<br/>";
	echo "Admin E4 gateway password Credentials receiving: ".$Global['e4password']."<br/>";
	}

	if ($_SESSION['debug'] == true) {
	echo "VALUE: <br>";
	print_r($value); 
	echo "<br>";
	//exit;
	}
  $payment_username = $Global['administrator'];
  $payment_type = program_type($value['payment_type'], $value['payment_tier_level'], $Global['admin_amount']['N'], true);
  
  // JS FOUND OUT 7/9/18 THIS VALUE WAS NOT EXCLUDING PAID PLANS ON SPM
  $payment_amount = $value['amount'];
  // FUNCTION IN payment_collect.inc.php NEEDS TO BE UPDATED - DONE!
  //if ($_SESSION['pro_aff_payment'] == true) $payment_amount = $pp_amount;
  
  if ($value['plan_type'] == 'S') {
	  // JS FOUND OUT 7/9/18 THIS VALUE WAS NOT EXCLUDING PAID PLANS ON SPM  
    $payment_amount_real = $value['amount']; //auth sub
	//if ($_SESSION['pro_aff_payment'] == true) $payment_amount_real = $pp_amount;
    }
  else {
    $amount_real = $value['amount'];
    }
} // END ADMIN COLLECTS

if ($Global['program_type'] == 'S' && $upp_payment_duration != "Y" && $upp_payment_duration != "L") $one_time_or_sub = 'sub'; // if not lifetime, treat as subscription
else $one_time_or_sub = 'normal';
	
if ($Global['use_shipping'] === true) {
	$copyshipping_frombilling = true; // to include Javascript function to copy shipping info from billing info
}	
	
//if ($GLOBALS['debug'] != true) 
include $Global['path'].'Sub/tpl/'.$Global['header'];	
include $Global['path'].'apay/Program_main.inc.php';

/*if (($program_id == 1 && $_SESSION['p1_status'] == 'Unpaid') || ($program_id == 2 && $_SESSION['p2_status'] == 'Unpaid')) { 
	// ONLY SHOW COUNTDOWN TIMER TO NEW ENROLLEES (UNPAID USERS)!
	// ONLY SHOWING TO P1 OR P2, THE MATRIX PROGRAMS!
	include $Global['path'].'apay/countdown.inc.php';
}*/

// THIS LINE IS DONE AFTER HEADER, SO WE DON'T SEE ALL THE HEADER DEBUGGING!
//if (($_SERVER['REQUEST_METHOD'] === 'POST') && ($_SESSION['loggedin'] == 'test' || $_SESSION['loggedin'] == 'demo')) $GLOBALS['debug'] = true;

//$GLOBALS['debug'] = true;

//The form was submitted and there is no user details to fill in
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $_POST['submit'] != '' && $Error_msg == '') {

	if ($_SESSION['debug'] == true) {
	echo '<br/>We got to submit.<br/>';
	}
	
	if ($paid_to_user_id == $_SESSION['UserID']) {
		//include $Global['path'].'Sub/tpl/'.$Global['header'];
		echo '<h2>Loggedin user has changed! You cannot pay yourself.</h2><h3>Please logout, and try again.</h3>';
		include $Global['path'].'Sub/tpl/'.$Global['footer'];
	}
	
	
	//GET USER'S IP ADDRESS
	$Global_userip = $_SERVER['HTTP_X_FORWARDED_FOR'] ?? $_SERVER['HTTP_CLIENT_IP'] ?? $_SERVER['REMOTE_ADDR'] ?? 'UNKNOWN';

	if ($Global_userip !== 'UNKNOWN' && strpos($Global_userip, ',') !== false) {
		// If there's a comma in the IP address string, take the first value
		$ip_addresses = explode(',', $Global_userip);
		$Global_userip = trim($ip_addresses[0]);
	}

	// Proceed with IP validation and further processing as before
	if (filter_var($Global_userip, FILTER_VALIDATE_IP)) {
		// The IP address is correctly formatted
		$Global_userip = sanitize($Global_userip);
		$Global_userdns = gethostbyaddr($Global_userip);
		$Global_userbrowser = $_SERVER['HTTP_USER_AGENT'] ?? 'UNKNOWN';
		$Global_userbrowser = sanitize($Global_userbrowser);
	} else {
		// The IP address is not correctly formatted or is 'UNKNOWN'
		$Global_userip = 'Invalid IP';
		// Assuming these variables are used later for display, they should be processed at that point:
		// echo htmlentities($Global_userdns);
		// echo htmlentities($Global_userbrowser);		
		echo 'Invalid';
		exit;
	}
	
	//Include the correct modular payment file depending on what payment process the user tries to access
	if ($_GET['type'] == 'E4' && $Global['use_E4'] === true && isset($_GET['test'])) {
		$Global['cc_processor_used'] = 'E4';
		include $Global['path'].'apay/pm/E4_one_process_test.inc.php';
		}
	elseif ($_GET['type'] == 'E4' && $Global['use_E4'] === true) {
		$Global['cc_processor_used'] = 'E4';
		include $Global['path'].'apay/pm/E4process.inc.php';
		}		
	elseif ($_GET['type'] == 'AN' && $Global['use_authorize'] === true && empty($_SESSION['all_signed_up2'])) {
		$cc_page_says = 'no_error';
		$Global['cc_processor_used'] = 'AN';
		include $Global['path'].'apay/pm/AuthorizeNet/index.php';
		}
}	

// ERROR MSGS NOT SHOWING, AS THEY COME BEFORE HEADER, SO MOVING HEADER TO ABOVE PAYMENT PROCESSOR INCLUDES!
//include $Global['path'].'Sub/tpl/'.$Global['header'];
//display project name and description information
//include $Global['path'].'apay/Program_main.inc.php';

if ($_SESSION['debug'] == true) {
	echo "<br/>Debugging Statements From apay/cc.php<br/><br/>";
	$DSflag_displayvalue = ($DSflag == true) ? "true":"false";
	echo "<br/>DSflag: " . $DSflag_displayvalue ."<br/>Success_msg: ".$Success_msg."<br/>";
	print_r($DSarray);
	echo "<br/>End Debugging Statements From apay/cc.php<br/><br/>";
}

if (!empty($Error_msg) && !empty($Success_msg) && $Success_msg === true) { // PAYMENT WAS SUCCESSFUL
	echo "<h2 style='color:green; text-align: center'>".$Error_msg."</h2><br />";
		
		if ($freetrial === true && $one_time_or_sub == 'sub') {
			
			echo '<p>Your credit card has been authorized, but not charged.<br/> You will not be charged if you cancel your subscription before '.date($Global['date_setting'], (time() + ($freetrial_days * 86400))).'.<br/>Unless you cancel before this date, you will be charged $'.number_format($DStotamount, 2).' every '.$Global['sub_period'].' days,<br/>and your subscription will be charged for first time on '.date($Global['date_setting'], (time() + ($freetrial_days * 86400))).'.</p>';
		
		} else if (($_GET['type'] == 'E4' && $DSarray[1]['dba'] != '') && ($DSflag === true || $DScount == 1)) {

			for ($i = 1;$i <= $DScount;$i++) {
				echo '&nbsp;&nbsp;&bull; $'.number_format($DSarray[$i]['amount'], 2);
				echo $DSarray[$i]['username'].' (billed on your card as '.$DSarray[$i]['dba'].')';
				if ($i<$DScount) echo " and<br />";	
			}
			
			echo '.<br /><br />'; // END THE SENTENCE WITH A PERIOD. YOUR ENGLISH TEACHER WILL BE IMPRESSED!
			
			for ($i = 1;$i <= $DScount;$i++) {
				if ($DSarray[$i]['CTR'] != "") echo nl2br($DSarray[$i]['CTR']) . "<br /><br />";
			}
			
			if ($_SESSION['E4CTR'] != "") { echo nl2br($_SESSION['E4CTR']) . "<br /><br />"; unset($_SESSION['E4CTR']); } 	
		} // END USE FIRST DATA E4 OR LINKPOINT IS TRUE

	if ($finalized == true) { // ALL PAYMENTS COMPLETE - SHOW UPSELLS!!
		//unset($_SESSION['a'.$_SESSION['UserID']]['status_check']);
		$_SESSION['Returning'] = true; // NOW SHOWS MENU IN BO HEADER

		$more_shopping = '';
		//QQQ CUSTOM UPSELL FUNNEL
		/*	
		if ($_SESSION['p1_status'] != 'Active' && $_SESSION['p1_status'] != 'Comped') {
			$more_shopping .= '<a href="pay.php?program=1">'.$_SESSION['p1_name'].'</a> - ';
		}
		if ($_SESSION['p2_status'] != 'Active' && $_SESSION['p2_status'] != 'Comped') {
			$more_shopping .= '<a href="pay.php?program=2">'.$_SESSION['p2_name'].'</a> - ';
		}
		if ($_SESSION['p3_status'] != 'Active' && $_SESSION['p3_status'] != 'Comped') {
			$more_shopping .= '<a href="pay.php?program=3">'.$_SESSION['p3_name'].'</a> - ';
		}
		if ($_SESSION['p4_status'] != 'Active' && $_SESSION['p4_status'] != 'Comped') {
			$more_shopping .= '<a href="pay.php?program=4">'.$_SESSION['p4_name'].'</a> - ';
		}
		if ($_SESSION['p5_status'] != 'Active' && $_SESSION['p5_status'] != 'Comped') {
			$more_shopping .= '<a href="pay.php?program=5">'.$_SESSION['p5_name'].'</a> - ';
		}
*/	
			if ($more_shopping != '') { // SHOW UPSELL OPTIONS (FINALIZED IS TRUE & WE HAVE MORE SHOPPING OPTIONS)

				echo '<strong><h2>Please continue shopping with your selection, below.</h2>';
				echo '<h3>'.$more_shopping.'</h3>';
				echo '</strong><br/>';
				?>
				<h2>I am done shopping. <a href="../Members/paid/redirect.php?program=<?php echo $_GET['program']; ?>">Click here to access the paid area</a>.</h2>
				<?php
			} else { // FINALIZED IS TRUE, BUT WE HAVE NO UPSELLS TO SHOW!
				?>
				<h2 style="text-align: center"><a href="../Members/paid/redirect.php?program=<?php echo $_GET['program']; ?>">Please click here to continue</a>.</h2>
				<?php
			} // END SHOW UPSELLS
		
		} else { // FINALIZED NOT TRUE - SHOW REGULAR LINK TO CONTINUE
		?>
		<h2><a href="pay.php?program=<?php echo $_GET['program']; ?>">Please click here to continue</a>.</h2>	
	<?php
	} // END FINALIZED NOT TRUE	
	
	if (!empty($_SESSION['all_signed_up2'])) { // IF ALL SIGNED UP - REDIRECT USERS TO THANK YOU PAGE!	
	unset($_SESSION['all_signed_up2']);
    //header('Location: '.$_SESSION['redirect']); // REDIRECT URL IS DEFINED IN PROGRAM SETTINGS, ADMIN PANEL
			//exit; // END ALL SIGNED UP // REDIRECT
		} // END SUCCESS IS TRUE (PAYMENT WAS SUCESSFUL)

} else if (empty($Success_msg) || $Success_msg === false) { // SHOW PAYMENT INFO AND CC FORM!!!!!!	   

	if ($freetrial === true) {
		echo '<h2 style="color:green">You will not be charged during the '.$freetrial_days.'-Day Free Trial Period.</h2><br />
		<p>A valid credit card is required for the '.$Global['webpage_name'].' '.$freetrial_days.'-Day Free Trial.<br/>You will not be charged if you cancel your Free Trial before '.date($Global['date_setting'], (time() + ($freetrial_days * 86400))).'.</p>
					
		<p>Unless I cancel my Free Trial before '.date($Global['date_setting'], (time() + ($freetrial_days * 86400))).', I hereby authorize '.$DSarray[$i]['dba'].' to charge my card listed above for the total of '.$DSarray[$i]['amount'].', on '.date($Global['date_setting'], (time() + ($freetrial_days * 86400)));
		if ($one_time_or_sub == 'sub') echo ', and agree that I will be charged this amount on a recurring basis every '.$Global['sub_period'].' days.</p>';
		else echo '.';
		// END FREE TRIAL CODE					  
 
	} else if ($DSflag === true) { // FIRST DATA USING DUAL SYNCH
	 
		for ($i = 1;$i <= $DScount;$i++) {
			echo '&nbsp;&nbsp;&bull; $'.number_format($DSarray[$i]['amount'], 2).' will charged by '.$DSarray[$i]['username'].' (billed on your card as '.$DSarray[$i]['dba'].')';
			if ($i<$DScount) echo " and<br />";
		}
		echo '.<br /><br />'; // END THE SENTENCE WITH A PERIOD. YOUR ENGLISH TEACHER WILL BE IMPRESSED!
					
		
	} else { // AUTHORIZE.NET, E4 WITHOUT DUAL SYNCH
	
		if (!empty($Global['e4merch'])) $display_payment_username = $Global['e4merch'];
		else $display_payment_username = $payment_username;
	
		if ($display_payment_username == 'admin') echo '<h4 style="text-align:center">Your credit card will be charged for $'.number_format($payment_amount, 2).' in total.</h4>';
		
		else echo '<h4 style="text-align:center">Your credit card will be charged for $'.number_format($payment_amount, 2).' in total as payment to '.$display_payment_username.'.</h4>';
	}	
	
	if ($one_time_or_sub == 'normal' || $Global['sub_period'] > 90)  {
		if ($Global['sub_period'] == 365) $more_desc = '&nbsp;for a one year membership,&nbsp;';
		else $more_desc = '&nbsp;';
		echo '<h4 style="text-align:center">This is a one time payment'.$more_desc.'and it will be charged today.</h4>';
	} else {
		
		$charged_or_due = 'charged'; // INI VAR, TO STOP WARNINGS

		if ($_SESSION['p'.$program_id.'_setup_fee'] > 0 && ($Global['payment_duration'] != 'Y' || $Global['sub_period'] == 30)) {
			$desc = 'Of this, $'.$_SESSION['p'.$program_id.'_amt'].' is a subscription payment';
		} else if ($Global['sub_period'] <= 90) {
			$desc = 'This is a subscription payment, which will be';
			$charged_or_due = 'charged';
		} else if ($Global['sub_period'] >= 90) {
			$desc = 'This is a one time payment, which will be';
			$charged_or_due = 'charged today, then due';
		} else {
			$charged_or_due = 'charged';
		}
		$when = '';
		if ($Global['sub_period'] <= 90) $when = '<h4 style="text-align:center">'.$desc.' '.$charged_or_due.' every '.$Global['sub_period'].' days, unless you cancel.</h4><h4>* If you have enough earned commissions, those will be used for rebilling, and your card will not be charged.</h4><br />';
		if ($desc != '' && $when != '') {
			echo $when;
		} else if ($desc != '') {
			echo $desc;
		}		
	}

	// CREDIT CARD ORDER FORM BEGIN

	if (!empty($Error_msg)) {
		echo "<div style='color:red; font-weight:bold'><h4 style='text-align:center'>".$Error_msg."</h4></div>";
	}
	
	// TO CREATE A WALK THROUGH MODE (AND BYPASS REAL PAYMENT), SIMPLY EDIT THE $form_action LINK AS NEEDED, FOR WHERE YOU WANT TO REDIRECT USERS AFTER PAYMENT.
	//$form_action = 'thankyou.php';
	$form_action = 'cc.php';
	
	echo '<div class="container">
    <div class="row row-centered">
	<div class="col-md-3">&nbsp;</div>
	<div class="col-md-6 col-centered"><table style="float:center">';
	?>
	<form action="<?php echo $form_action; ?>?program=<?php echo $Global['program']; ?>&uid=<?php echo $_GET['uid'];?>&dtype=<?php echo $_GET['dtype'];?>&type=<?php echo $_GET['type'];?>&method=<?php echo $one_time_or_sub; ?>" method="POST" onload="dupwarning.style.display='none'; submitcc.disabled = false; submitcc.value = 'I AGREE, Submit';"  onsubmit="submitcc.value = 'Processing. Please wait...'; submitcc.disabled = true; dupwarning.style.display='inline'; ">
	
	<?php 
	if (!empty($add_info)) { echo $add_info; } ?>
	<!-- MEMBER SELECTS CC CARD TYPE TO USE --> 
	<!--
	<tr><td width="150">Card Type:</td>
    <td>
	<select class="form-control" name="cccard">
	<option value='' selected>Select Card Type</option>
	<?php echo '<option value="visa"'.((isset($_POST['cccard']) && $_POST['cccard'] == 'visa')?' selected':'').'>Visa</option>';
	echo '<option value="mc"'.((isset($_POST['cccard']) && $_POST['cccard'] == 'mc')?' selected':'').'>MasterCard</option>';
	echo '<option value="ae"'.((isset($_POST['cccard']) && $_POST['cccard'] == 'ae')?' selected':'').'>American Express</option><option value="de"'.((isset($_POST['cccard']) && $_POST['cccard'] == 'de')?' selected':'').'>Discover</option>';
	?>
	</select><br /><img src="<?php echo $Global['webpage_url_ssl'];?>images/credit_card_icons.png" width="130" height="18" border="0" style="padding-bottom:7px; padding-left:5px;" alt="Select Your Credit Card Type" title="Select Your Credit Card Type" /></td></tr>
	-->
	
	<!--
	<tr><td>Card Number:</td>
    <td>
	<input class="form-control" type="text" name="ccnumber" value="<?php if (!empty($_POST['ccnumber'])) echo $_POST['ccnumber'];?>">
	</td></tr>
	-->
	
<tr>
    <td>Card Number:</td>
    <td>
        <div style="text-align: left;">
            <input class="form-control" style="width: 60px; display: inline-block; margin-right: 10px;" type="text" name="ccnumber1" value="<?php if (!empty($_POST['ccnumber1'])) echo htmlspecialchars($_POST['ccnumber1']);?>" maxlength="4" oninput="if(this.value.length === 4) document.getElementsByName('ccnumber2')[0].focus()" required>
            <input class="form-control" style="width: 60px; display: inline-block; margin-right: 10px;" type="text" name="ccnumber2" value="<?php if (!empty($_POST['ccnumber2'])) echo htmlspecialchars($_POST['ccnumber2']);?>" maxlength="4" oninput="if(this.value.length === 4) document.getElementsByName('ccnumber3')[0].focus()" required>
            <input class="form-control" style="width: 60px; display: inline-block; margin-right: 10px;" type="text" name="ccnumber3" value="<?php if (!empty($_POST['ccnumber3'])) echo htmlspecialchars($_POST['ccnumber3']);?>" maxlength="4" oninput="if(this.value.length === 4) document.getElementsByName('ccnumber4')[0].focus()" required>
            <input class="form-control" style="width: 60px; display: inline-block;" type="text" name="ccnumber4" value="<?php if (!empty($_POST['ccnumber4'])) echo htmlspecialchars($_POST['ccnumber4']);?>" maxlength="4">
        </div>
    </td>
</tr>

	
	
	
	<tr><td>Card Expires:</td>
    <td>
	<div class="row">
	<div class="pull-left" style="margin-left: 15px; margin-top: 0px;">
	
	<select name="ccmonth" class="form-control">
	<?php if ($_SESSION['test_credit_cards'] == true) { ?>
	<option value='01' selected> 01</option>
	<?php } else { ?>
	  <option value='' <?php if ($_POST['ccmonth'] == '') echo 'selected'; ?>> Month </option>
	  <option value='01' <?php if ($_POST['ccmonth'] == '01') echo 'selected'; ?>> 01 </option>
	  <option value='02' <?php if ($_POST['ccmonth'] == '02') echo 'selected'; ?>> 02 </option>
	  <option value='03' <?php if ($_POST['ccmonth'] == '03') echo 'selected'; ?>> 03 </option>
	  <option value='04' <?php if ($_POST['ccmonth'] == '04') echo 'selected'; ?>> 04 </option>
	  <option value='05' <?php if ($_POST['ccmonth'] == '05') echo 'selected'; ?>> 05 </option>
	  <option value='06' <?php if ($_POST['ccmonth'] == '06') echo 'selected'; ?>> 06 </option>
	  <option value='07' <?php if ($_POST['ccmonth'] == '07') echo 'selected'; ?>> 07 </option>
	  <option value='08' <?php if ($_POST['ccmonth'] == '08') echo 'selected'; ?>> 08 </option>
	  <option value='09' <?php if ($_POST['ccmonth'] == '09') echo 'selected'; ?>> 09 </option>
	  <option value='10' <?php if ($_POST['ccmonth'] == '10') echo 'selected'; ?>> 10 </option>
	  <option value='11' <?php if ($_POST['ccmonth'] == '11') echo 'selected'; ?>> 11 </option>
	  <option value='12' <?php if ($_POST['ccmonth'] == '12') echo 'selected'; ?>> 12 </option>
	<?php } 
	echo '</select></div><div class="pull-left" style="margin-left: 10px; margin-top: 0px;"><select class="form-control" name="ccyear">';
	if (isset($_POST['ccyear']) && $_POST['ccyear'] == '') $selected = ' selected';
	else $selected = '';
	echo '<option value="" '. $selected .'>Year</option>';
	$total = date('Y')+10;

	for ($nr=date('Y');$nr <= $total;++$nr)
	{
		if (isset($_POST['ccyear']) && $_POST['ccyear'] == $nr) $selected = ' selected';
		else $selected = '';
		echo '<option value="'.$nr.'"'.$selected.'>'.$nr.'</option>';
	}
	?>
	</select>
	
	</div>
	</div>
	</td>
	</tr>
	<tr>
	<td>
	Security Code:</td><td>
	<div class="pull-left">	
	<input autocomplete="off" type="text" class="form-control" style="width:100px;" maxlength="4" name="ccv" value="<?php echo ((!empty($_POST['ccv']))?$_POST['ccv']:''); ?>">
	</div>
	<div class="pull-left">
	<img src="<?php echo $Global['webpage_url_ssl'];?>images/ccard_back_ccv.png" border="0">
	</div>
	</td>
	</tr>
	<tr>
	<td>Name on Card:</td>
	<td>
	<input class="form-control" type="text" name="ccsignature" value="<?php if (!empty($_POST['ccsignature'])) echo $_POST['ccsignature'];?>">
	</td>
	</tr>
	</table><p>&nbsp;</p></div>
	<div class="col-md-3">&nbsp;</div>	
	</div></div>
	<!-- INSERT NEW SIGNATURE BLOCK TEXT HERE -->
	<div class="col-sm-10 col-sm-offset-1">	
	<?php 
	//if ($one_time_or_sub == 'sub') {
	if ($one_time_or_sub == 'sub' || $Global['sub_period'] == 30) { // NEW COND FOR YEARLY PLANS ALSO SUPPORTING MONTHLY OTOS
	?>
	<p style="text-align:left; justify">I agree to pay the charges listed above according to my cardholder agreement. I understand that if I wish to cancel the automatic recurring credit card billing, I will login to my <?php echo $Global['webpage_name'];?> member's area back office, and cancel my subscription on this page: <a href="<?php echo $Global['webpage_url_ssl'];?>Members/cancel.php" target="_blank"><?php echo $Global['webpage_url_ssl'];?>Members/cancel.php</a> (preferred method), or I will open a support ticket with my cancellation request here: <a href="<?php echo $Global['webpage_url_ssl'];?>contact.php" target="_blank"><?php echo $Global['webpage_url_ssl'];?>contact.php</a> 	
	<!--email my cancellation request to <a href="mailto:<?php echo $Global['admin_email'];?>"><?php echo $Global['admin_email'];?></a>.-->
	</p> 
	
	<?php } ?>
	<p style="text-align:left; justify">
	<?php echo "<input onMouseover=\"this.focus()\" type=\"checkbox\" required=\"required\" name=\"selected\" id=\"accept\"" .((!empty($_POST['selected']))?'checked':'')."> I acknowledge that <!-- after the 3 day right of rescission period, --> this is a final and non-disputable transaction for products and services rendered. I understand and agree that there are <strong>no refunds</strong>.";
	?>
	<br/><br/></p>
	
	<div id="dupwarning" style="display: none; text-align:center"><img src="<?php echo $Global['webpage_url_ssl'];?>images/processing.gif" border="0"><br/>
	<span style="color:#666666;font-family:Arial;font-size:17px;">Please <u>DO NOT</u> Refresh Or Use Your Back Button.</span>
	<p><img src="<?php echo $Global['webpage_url_ssl'];?>images/pleasewait.gif" border="0"></p></div>	
	<div style="text-align:center"><input type="hidden" name="submit" value="submit" /><button type="submit" id="submitcc" name="submitcc" class="btn btn-success">I AGREE, Submit</button></div>
	</div>
	<input type="hidden" name="thispagename" value="cc">
	</form>	
<?php } // END SUCCESS IS FALSE
function program_type($type, $tier, $admin_fee=0, $program=false) {
	switch ($type) {
		case 'T': //Tier payment
			$payment_type = 'Tier '.$tier;
			break;
		case 'P': //Powerline payment
			$payment_type = 'Powerline';
			break;
		case 'PT': //Powerline and tier payment
			$payment_type = 'Powerline and Tier'.(($tier > 0)?' '.$tier:'');
			break;
		default: //Admin payments
			if ($program === true) {
			    // Check if $admin_fee is an array and handle it accordingly
				$adminFeeStr = is_array($admin_fee) ? implode(', ', $admin_fee) : $admin_fee;
				$payment_type = 'Administrator <a href="javascript:alert(\'The admin fee is $' . $adminFeeStr.'. The admin also accepts tier and powerline payments, just like any other member. If the amount showing is greater than $'.$admin_fee.', that is why.\');"><img src="../images/questionmark.gif" border="0"></a>';
			} else {
				$payment_type = 'Administrator';
			}	
			break;
		}
			
	return $payment_type;
}
include $Global['path'].'Sub/tpl/'.$Global['footer'];
?>