<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
// THIS FILE CREATES (OR UPDATES) AN AUTHNET BILLING PROFILE (EACH TIME IT'S RUN), AND THEN CHARGES IT
// THIS FILES ONLY RUNS AS AN INC FROM CC.php, WHEN $_POST['submit'] != '' && $Error_msg == '') COND IS MET

set_time_limit(0); // Make sure it will not expire before it's complete
//$GLOBALS['use_sandbox'] = true; // ONLY FOR TESTING IN AUTHNET SANDBOX, WITH OR WITHOUT DEBUGGING TURNED ON - TO TEST END USER EXPERIENCE!
$GLOBALS['use_sandbox'] = false; // THIS WILL MAKE PAYMENTS LIVE!
//$GLOBALS['use_sandbox'] = true;

?>

<?php
//$GLOBALS['debug'] = true;
//$GLOBALS['debug'] = false;

if ($_SESSION['loggedin'] == 'demo' || $_SESSION['loggedin'] == 'test') {
	$GLOBALS['use_sandbox'] = true;
	//$GLOBALS['debug'] = true;
}	

// MAKE SURE NO ONE CAN ACCESS THIS PAGE DIRECTLY!
if (!isset($cc_page_says) || $cc_page_says != 'no_error') exit;
if (!isset($Global['cc_processor_used']) || $Global['cc_processor_used'] != 'AN') exit;


if ($GLOBALS['debug'] == true) { ?>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<?php }
//include './../../../dbconn.php'; // FOR TESTING index.php DIRECTLY - DONE WITH THESE
//include './../../../phpcpr.php';

//include './../dbconn.php';
//$GLOBALS['debug'] = true;
//include './../phpcpr.php';

//#[\ReturnTypeWillChange]
//public function jsonSerialize()


if ($GLOBALS['debug'] == true) {
	ini_set('display_errors', 1);
	ini_set('display_startup_errors', 1);
	error_reporting(E_ALL);
} else {
	ini_set('display_errors', '0');
	ini_set('display_startup_errors', '0');
	error_reporting(0);
}	
	
//echo $GLOBALS['path'];

//$_SESSION['loggedin'] = 'demo';
//$_SESSION['UserID'] = 2;

$payer_username = $_SESSION['loggedin'];
$ID = $_SESSION['UserID'];

echo debug_stmt('up top', 1);

/*if ($_SERVER['REQUEST_METHOD'] == 'POST') {
	print_r($_POST);
	exit;
}*/

if (!function_exists('decrypt')) {
		function decrypt($input) {
			global $GLOBALS;
			$key = $GLOBALS['member_taxid_algorythm_key'];
			$method = 'AES-256-CBC';

			// Decode the base64-encoded input (which contains both the IV and encrypted data)
			$input = base64_decode($input);

			// Extract the IV and encrypted data
			$ivLength = openssl_cipher_iv_length($method);
			$iv = substr($input, 0, $ivLength);
			$encryptedData = substr($input, $ivLength);

			// Decrypt the data
			$decrypted = openssl_decrypt($encryptedData, $method, $key, OPENSSL_RAW_DATA, $iv);
			return $decrypted;
		}
}
// THIS SECTION CAN NEVER RUN, SINCE THIS FILE IS ONLY CALLED IN POST! - MOVE TO CC PAGE WHEN IT GETS UPDATED TO USE PHPCPR
if (false && $_SERVER['REQUEST_METHOD'] != 'POST') { // WE GRAB & USE DATA FROM PROFILE TO PRE-FILL THE CC FORM FOR THEM!

$selectFields = '*';
$mainTable = 'members';
$joinConditions = [];
$where = [
    'Username' => [
        ['=', $payer_username]
    ]	
];

$groupBy = null;
$having = null;
$orderBy = null;
$limit = 1;
$show_debug = 1;

if (isset($result)) unset($result);
$result = select($selectFields, $mainTable, $joinConditions, $where, $groupBy, $having, $orderBy, $limit, $show_debug);
$row = $result[0]; // Assign the first row array to $row

//print_r($row);
$payer_id = $row['ID'];
$_POST['email'] = $row['email'];
$_POST['firstname'] = $row['First_Name'];
$_POST['lastname'] = $row['Last_Name'];

echo "Payer ID: " . $payer_id . "<br>";
echo "Email: " . $_POST['email'] . "<br>";
echo "First Name: " . $_POST['firstname'] . "<br>";
echo "Last Name: " . $_POST['lastname'] . "<br>";

// NOW GET ADDRESS INFO!
$selectFields = '*';
$mainTable = 'member_link';
$joinConditions = [];
$where = [
    'ID' => [
        ['=', $ID]
    ]	
];

$groupBy = null;
$having = null;
$orderBy = null;
$limit = 1;
$show_debug = 1;

if (isset($result)) unset($result);
$result = select($selectFields, $mainTable, $joinConditions, $where, $groupBy, $having, $orderBy, $limit, $show_debug);
$row = $result[0]; // Assign the first row array to $row

	$_POST['address'] = $row['address'];
	$_POST['address2'] = $row['address2'];
	$_POST['city'] = $row['city'];
	$_POST['zip'] = $row['zip'];

	if ($row['state'] == '1') {
	   $_POST['state'] = $row['province'];		
	} else {
	   $_POST['state'] = $row['state'];
	}
	
	$_POST['country'] = $row['country'];
	$_POST['phone'] = $row['phone'];

} // END NOT POST	
	
	
require_once 'autoload.php';

use net\authorize\api\contract\v1 as AnetAPI;
use net\authorize\api\controller as AnetController;

if ($GLOBALS['use_sandbox'] == true) { // USE JIM'S AUTHNET TEST KEYS IN SANDBOX

	// TEST KEYS FOR USE IN SANDBOX
	define("MERCHANT_LOGIN_ID", "63YPu6bW");
	define("MERCHANT_TRANSACTION_KEY", "963yjqV3cP8Xc2MM");

} else { // GET ADMIN'S AUTHNET KEYS!

    // PHPCPR 'select' function
    $selectFields = ['*'];
    $mainTable = 'members';
    $where = ['Username' => [['=', 'admin']]];

    $result = select($selectFields, $mainTable, [], $where);
	
	$row = $result[0]; // Assign the first row array to $row
	//print_r($row);

	$authorize_id = $row['paymentprocessor3'];
	$authorize_key = decrypt($row['paymentprocessor4']);
	
	//SET MERCHANT KEYS HERE!
	define("MERCHANT_LOGIN_ID", $authorize_id);
	define("MERCHANT_TRANSACTION_KEY", $authorize_key);
}

function createCustomerWithPaymentProfile(
    $cardNumber,
    $cardExpiryDate,
    $cardCode,
    $description = null,
    $address = null,
    $customerId = null
) {
    $merchantAuthentication = new AnetAPI\MerchantAuthenticationType();
    $merchantAuthentication->setName(MERCHANT_LOGIN_ID);
    $merchantAuthentication->setTransactionKey(MERCHANT_TRANSACTION_KEY);

    $creditCard = new AnetAPI\CreditCardType();
    $creditCard->setCardNumber($cardNumber);
    $creditCard->setExpirationDate($cardExpiryDate);
    $creditCard->setCardCode($cardCode);

    $paymentCreditCard = new AnetAPI\PaymentType();
    $paymentCreditCard->setCreditCard($creditCard);

    $customerPaymentProfile = new AnetAPI\CustomerPaymentProfileType();
    $customerPaymentProfile->setCustomerType('individual');
    $customerPaymentProfile->setPayment($paymentCreditCard);

    if ($address !== null) {
        $billTo = new AnetAPI\CustomerAddressType();
        $billTo->setFirstName($address['firstName']);
        $billTo->setLastName($address['lastName']);
        $billTo->setCompany($address['company']);
        $billTo->setAddress($address['address']);
        $billTo->setCity($address['city']);
        $billTo->setState($address['state']);
        $billTo->setZip($address['zip']);
        $billTo->setCountry($address['country']);
        $billTo->setPhoneNumber($address['phone']);

        $customerPaymentProfile->setBillTo($billTo);
    }

    $paymentProfiles[] = $customerPaymentProfile;

    $customerProfile = new AnetAPI\CustomerProfileType();
    $customerProfile->setDescription($description);
    $customerProfile->setEmail($address['email']);
    $customerProfile->setMerchantCustomerId($customerId);
    $customerProfile->setPaymentProfiles($paymentProfiles);

    $request = new AnetAPI\CreateCustomerProfileRequest();
    $request->setMerchantAuthentication($merchantAuthentication);
    $request->setProfile($customerProfile);

    $controller = new AnetController\CreateCustomerProfileController($request);
	if ($GLOBALS['use_sandbox'] == true) {
		$response = $controller->executeWithApiResponse(\net\authorize\api\constants\ANetEnvironment::SANDBOX);
	} else {
		$response = $controller->executeWithApiResponse(\net\authorize\api\constants\ANetEnvironment::PRODUCTION);
	}
	

    if (isset($response) && $response != null && $response->getMessages()->getResultCode() == "Ok") {
        $customerProfileId = $response->getCustomerProfileId();
        $customerPaymentProfileId = $response->getCustomerPaymentProfileIdList()[0];

		echo debug_stmt("Create Customer Profile with Payment Profile SUCCESS:", 1);
        echo debug_stmt("Customer Profile ID: " . $customerProfileId, 1);
        echo debug_stmt("Payment Profile ID: " . $customerPaymentProfileId, 1);
    } else {
		echo debug_stmt("Create Customer Profile with Payment Profile ERROR: Invalid response", 0);
        $errorMessages = $response->getMessages()->getMessage();
        foreach ($errorMessages as $msg) {
            $errorMsg = "Response: " . $msg->getCode() . "  " . $msg->getText() . "\n";
            if ($GLOBALS['debug'] == true) echo $errorMsg;
            error_log($errorMsg, 3, __DIR__ . "/error.log"); // log errors
        }
    }

	return $response;

} // END createCustomerWithPaymentProfile FUNCTION


function updateCustomerPaymentProfile(
    $customerProfileId,
    $customerPaymentProfileId,
    $cardNumber,
    $cardExpiryDate,
    $cardCode,
    $address = null
) {
    $merchantAuthentication = new AnetAPI\MerchantAuthenticationType();
    $merchantAuthentication->setName(MERCHANT_LOGIN_ID);
    $merchantAuthentication->setTransactionKey(MERCHANT_TRANSACTION_KEY);

    $creditCard = new AnetAPI\CreditCardType();
    $creditCard->setCardNumber($cardNumber);
    $creditCard->setExpirationDate($cardExpiryDate);
    $creditCard->setCardCode($cardCode);

    $paymentCreditCard = new AnetAPI\PaymentType();
    $paymentCreditCard->setCreditCard($creditCard);

    $paymentProfile = new AnetAPI\CustomerPaymentProfileExType();
    $paymentProfile->setCustomerPaymentProfileId($customerPaymentProfileId);
    $paymentProfile->setPayment($paymentCreditCard);

	// Authorize.net's API does support an "address2" field for additional address information like apartment or suite numbers. However, this is optional and many implementations may choose to leave it out if it's not needed.

    /*if ($address !== null) { 
        $billTo = new AnetAPI\CustomerAddressType();
		$billTo->setFirstName(isset($address['firstName']) ? $address['firstName'] : '');
		$billTo->setLastName(isset($address['lastName']) ? $address['lastName'] : '');
		$billTo->setCompany(isset($address['company']) ? $address['company'] : '');
		$billTo->setAddress(isset($address['address']) ? $address['address'] : '');
		$billTo->setCity(isset($address['city']) ? $address['city'] : '');
		$billTo->setState(isset($address['state']) ? $address['state'] : '');
		$billTo->setZip(isset($address['zip']) ? $address['zip'] : '');
		$billTo->setCountry(isset($address['country']) ? $address['country'] : '');
		$billTo->setPhoneNumber(isset($address['phone']) ? $address['phone'] : '');

        $paymentProfile->setBillTo($billTo);
    }*/ // THE UPDATE WAS APPARENTLY OVERWRITING NAMES TO EMPTY. SO NOW, NOT OVERWRITING IF VALUE IS EMPTY!!
	if ($address !== null) {
		$billTo = new AnetAPI\CustomerAddressType();

		if (!empty($address['firstName'])) {
			$billTo->setFirstName($address['firstName']);
		}
		if (!empty($address['lastName'])) {
			$billTo->setLastName($address['lastName']);
		}
		if (!empty($address['company'])) {
			$billTo->setCompany($address['company']);
		}
		if (!empty($address['address'])) {
			$billTo->setAddress($address['address']);
		}
		if (!empty($address['city'])) {
			$billTo->setCity($address['city']);
		}
		if (!empty($address['state'])) {
			$billTo->setState($address['state']);
		}
		if (!empty($address['zip'])) {
			$billTo->setZip($address['zip']);
		}
		if (!empty($address['country'])) {
			$billTo->setCountry($address['country']);
		}
		if (!empty($address['phone'])) {
			$billTo->setPhoneNumber($address['phone']);
		}

		$paymentProfile->setBillTo($billTo);
	}
	

    $request = new AnetAPI\UpdateCustomerPaymentProfileRequest();
    $request->setMerchantAuthentication($merchantAuthentication);
    $request->setCustomerProfileId($customerProfileId);
    $request->setPaymentProfile($paymentProfile);

    $controller = new AnetController\UpdateCustomerPaymentProfileController($request);
    if ($GLOBALS['use_sandbox'] == true) {
        $response = $controller->executeWithApiResponse(\net\authorize\api\constants\ANetEnvironment::SANDBOX);
    } else {
        $response = $controller->executeWithApiResponse(\net\authorize\api\constants\ANetEnvironment::PRODUCTION);
    }

    if (($response != null) && ($response->getMessages()->getResultCode() == "Ok")) {
        echo debug_stmt("Update Customer Payment Profile SUCCESS:", 1);
    } else {
        echo debug_stmt("Update Customer Payment Profile ERROR: Invalid response", 0);
        $errorMessages = $response->getMessages()->getMessage();
        foreach ($errorMessages as $msg) {
            $errorMsg = "Response: " . $msg->getCode() . "  " . $msg->getText() . "\n";
            if ($GLOBALS['debug'] === true) echo $errorMsg;
            error_log($errorMsg, 3, __DIR__ . "/error.log"); // log errors
        }
    }

	if (($response != null) && ($response->getMessages()->getResultCode() == "Ok")) {
		return true;
	} else {
		return false;
	}
}


use net\authorize\api\contract\v1\OrderType;
use net\authorize\api\contract\v1\ExtendedAmountType;
use net\authorize\api\contract\v1\LineItemType;
use net\authorize\api\contract\v1\TransactionRequestType;

function chargeAWSCustomerProfile($customerProfileId, $customerPaymentProfileId, $amount, $refId = null, $shippingAddress = null, $description = null, $invoiceNumber = null, $tax = null, $freight = null, $duty = null)
{
    $merchantAuthentication = new AnetAPI\MerchantAuthenticationType();
    $merchantAuthentication->setName(MERCHANT_LOGIN_ID);
    $merchantAuthentication->setTransactionKey(MERCHANT_TRANSACTION_KEY);

    // Determine the environment
	if ($GLOBALS['use_sandbox'] == true) {
		$environment = \net\authorize\api\constants\ANetEnvironment::SANDBOX;
	} else {
		$environment = \net\authorize\api\constants\ANetEnvironment::PRODUCTION;
	}


    $profileToCharge = new AnetAPI\CustomerProfilePaymentType();
    $profileToCharge->setCustomerProfileId($customerProfileId);
    $paymentProfile = new AnetAPI\PaymentProfileType();
    $paymentProfile->setPaymentProfileId($customerPaymentProfileId);
    $profileToCharge->setPaymentProfile($paymentProfile);

    $transactionRequestType = new AnetAPI\TransactionRequestType();
    $transactionRequestType->setTransactionType("authCaptureTransaction");
    $transactionRequestType->setAmount($amount);
    $transactionRequestType->setProfile($profileToCharge);

    // Set the order description
    $order = new OrderType();
    $order->setDescription($description);
    $order->setInvoiceNumber($invoiceNumber);
    $transactionRequestType->setOrder($order);

    // Set the shipping address
    if ($shippingAddress !== null) {
        $shipTo = new AnetAPI\CustomerAddressType();
        $shipTo->setFirstName($shippingAddress['firstName']);
        $shipTo->setLastName($shippingAddress['lastName']);
        $shipTo->setCompany($shippingAddress['company']);
        $shipTo->setAddress($shippingAddress['address']);
        $shipTo->setCity($shippingAddress['city']);
        $shipTo->setState($shippingAddress['state']);
        $shipTo->setZip($shippingAddress['zip']);
        $shipTo->setCountry($shippingAddress['country']);
        $transactionRequestType->setShipTo($shipTo);
    }

    // Set tax
    /* // THIS IS A MESS AND CAUSING NOTHING BUT TROUBLE
	$tax = new AnetAPI\ExtendedAmountType();
    $tax->setAmount($tax);
    $tax->setName("tax");

    // Set freight
    $freight = new AnetAPI\ExtendedAmountType();
    $freight->setAmount($freight);
    $freight->setName("freight");

    // Set duty
    $duty = new AnetAPI\ExtendedAmountType();
    $duty->setAmount($duty);
    $duty->setName("duty");

    $transactionRequestType->setTax($tax);
    //$transactionRequestType->setFreight($freight);
    $transactionRequestType->setDuty($duty);*/
	

    $request = new AnetAPI\CreateTransactionRequest();
    $request->setMerchantAuthentication($merchantAuthentication);
    $request->setRefId($refId);
    $request->setTransactionRequest($transactionRequestType);

    $controller = new AnetController\CreateTransactionController($request);
    $response = $controller->executeWithApiResponse($environment);

	if ($response != null) {
		$resultCode = $response->getMessages()->getResultCode();
		
		// For debugging purposes, if you want to see the entire response
		if ($GLOBALS['debug'] == true) {
			echo '<pre>';
			print_r($response);
			echo '</pre>';	
		}

		if ($resultCode == "Ok") {
			$transactionId = $response->getTransactionResponse()->getTransId();
			echo debug_stmt("Charge Customer Profile SUCCESSFUL CALL ONLY: " . $transactionId, 1);

		} else {
			echo debug_stmt("Charge Customer Profile ERROR: Invalid response", 0);

			$errorMessages = $response->getMessages()->getMessage();
			foreach ($errorMessages as $msg) {
				$errorMsg = "Response: " . $msg->getCode() . "  " . $msg->getText() . "\n";

				// Display and log error messages
				if ($GLOBALS['debug'] == true) echo debug_stmt($errorMsg, 0);
				error_log($errorMsg, 3, __DIR__ . "/error.log"); // log errors
			}

	if (method_exists($response, 'getTransactionResponse')) {
		$transactionErrors = $response->getTransactionResponse();
		if (is_array($transactionErrors) || is_object($transactionErrors)) {
			foreach ($transactionErrors as $error) {
				if (method_exists($error, 'getErrorCode') && method_exists($error, 'getErrorText')) {
					$errorMsg = "Transaction Error: " . $error->getErrorCode() . "  " . $error->getErrorText() . "\n";

					// Display and log error messages
					if ($GLOBALS['debug'] == true) echo debug_stmt($errorMsg, 0);
					else echo $errorMsg;
					error_log($errorMsg, 3, __DIR__ . "/error.log"); // log errors
				}
			}
		}
	}

		}
	} else {
        echo debug_stmt("Charge Customer Profile ERROR: Null response", 0);
    }

	return $response;

} // END chargeAWSCustomerProfile FUNCTION


// Create customer profile with payment profile TEST DATA
/*$cardNumber = "4111111111111111";
$cardExpiryDate = "1225"; // December 2025
$cardCode = "123";
$description = "SAAS Services";
$email = "test@example.com";

$firstName = 'John';
$lastName = 'Doe';
$company = 'ABC Company';
$address1 = '123 Main Street';
$city = 'Anytown';
$state = 'NY';
$zip = '12345';
$country = 'United States';
$phone = '123-456-7890';

$shippingFirstName = 'Jane';
$shippingLastName = 'Smith';
$shippingCompany = 'XYZ Corporation';
$shippingAddress = '456 Shipping Avenue';
$shippingCity = 'Some City';
$shippingState = 'CA';
$shippingZip = '98765';
$shippingCountry = 'United States';
$shippingPhone = '987-654-3210';

$customerId = '107';

$customerProfileId =  512731975;
$customerPaymentProfileId = 519492925;
$amount = 14.00;
$refId = 8;
$description = "URL Forwarding";
$invoiceNumber = 777;
$tax = .05;
$freight = 3;
$duty = 4.07;
*/

// SET UP POST VARS!
$cardNumber = isset($_POST['ccnumber']) ? $_POST['ccnumber'] : '';
//$cardExpiryDate = isset($_POST['ccmonth']) && isset($_POST['ccyear']) ? $_POST['ccmonth'] . $_POST['ccyear'] : '';
//$cardExpiryDate = isset($_POST['ccmonth']) && isset($_POST['ccyear']) ? $_POST['ccmonth'] . substr($_POST['ccyear'], -2) : '';
$cardExpiryDate = strval(isset($_POST['ccmonth']) && isset($_POST['ccyear']) ? $_POST['ccmonth'] . substr($_POST['ccyear'], -2) : '');

$cardCode = isset($_POST['ccv']) ? $_POST['ccv'] : '';

$description = htmlentities($Global['program_name']);  // Keep as is, if not received from POST
$email = htmlentities($memberInfo['email']);  // Keep as is, if not received from POST

$amount = $payment_amount;
//if ($_SESSION['loggedin'] == 'demo') $amount = 2.00;
$refId = $_SESSION['UserID'];
$customerId = $_SESSION['UserID'];

/*$firstName = isset($_POST['FirstName']) ? htmlentities($_POST['FirstName']) : '';
$lastName = isset($_POST['LastName']) ? htmlentities($_POST['LastName']) : '';
$company = '';  // Assuming no POST data for this, so keep as is

$address1 = isset($_POST['address']) ? htmlentities($_POST['address']) : '';
$city = isset($_POST['city']) ? htmlentities($_POST['city']) : '';
$state = isset($_POST['state']) ? htmlentities($_POST['state']) : '';
$zip = isset($_POST['zip']) ? htmlentities($_POST['zip']) : '';
$country = isset($_POST['country']) ? htmlentities($_POST['country']) : '';*/

$firstName = isset($_POST['FirstName']) ? $_POST['FirstName'] : '';
$lastName = isset($_POST['LastName']) ? $_POST['LastName'] : '';
$company = '';  // Assuming no POST data for this, so keep as is

$address1 = isset($_POST['address']) ? $_POST['address'] : '';
$city = isset($_POST['city']) ? $_POST['city'] : '';
$state = isset($_POST['state']) ? $_POST['state'] : 'ME'; // QQQ FOR TEST!!
$zip = isset($_POST['zip']) ? $_POST['zip'] : '';
$country = isset($_POST['country']) ? $_POST['country'] : '';

$phone = isset($_POST['phone']) ? $_POST['phone'] : '';

$invoiceNumber = null;
$tax = null;
$freight = null;
$duty = null;

if ($GLOBALS['debug'] == true) {
	echo "Card Number: " . $cardNumber . "<br>";
	echo "Card Expiry Date: " . $cardExpiryDate . "<br>";
	echo "Card Code: " . $cardCode . "<br>";
	echo "Description: " . $description . "<br>";
	echo "Email: " . $email . "<br>";
	echo "Amount: " . $amount . "<br>";
	echo "Reference ID: " . $refId . "<br>";
	echo "Customer ID: " . $customerId . "<br>";
	echo "First Name: " . $firstName . "<br>";
	echo "Last Name: " . $lastName . "<br>";
	echo "Company: " . $company . "<br>";
	echo "Address 1: " . $address1 . "<br>";
	echo "City: " . $city . "<br>";
	echo "State: " . $state . "<br>";
	echo "ZIP: " . $zip . "<br>";
	echo "Country: " . $country . "<br>";
	echo "Phone: " . $phone . "<br>";
}


$address = array(
    'firstName' => $firstName,
    'lastName' => $lastName,
    'company' => $company,
    'address' => $address1,
    'city' => $city,
    'state' => $state,
    'zip' => $zip,
    'country' => $country,
    'phone' => $phone,
    'email' => $email
);

/*
$shippingAddress = array(
    'firstName' => $shippingFirstName, 
    'lastName' => $shippingLastName, 
    'company' => $shippingCompany,
    'address' => $shippingAddress,
    'city' => $shippingCity,
    'state' => $shippingState,
    'zip' => $shippingZip,
    'country' => $shippingCountry,
    'phone' => $shippingPhone,
);*/

$shippingAddress = $address;
unset($shippingAddress['email']);

// CHECK IF WE HAVE AN EXISTING BILLING PROFILE TO CHARGE
// PHPCPR 'select' function
$selectFields = ['customerProfileId', 'customerPaymentProfileId'];
$mainTable = 'members';
$where = ['Username' => [['=', $_SESSION['loggedin']]]];

$result = select($selectFields, $mainTable, [], $where);

$row = $result[0]; // Assign the first row array to $row

//print_r($row);
$customerProfileId = $row['customerProfileId'];
$customerPaymentProfileId = $row['customerPaymentProfileId'];

if ($GLOBALS['debug'] == true) echo "Customer Profile ID: " . $customerProfileId . "<br>";
if ($GLOBALS['debug'] == true) echo "Customer Payment Profile ID: " . $customerPaymentProfileId . "<br>";

	// SEE IF WE HAVE A PROFILE
    if ($customerProfileId > 0 && $customerPaymentProfileId > 0) {
		echo debug_stmt("we have an existing billing profile.", 1);
        $customerProfileId = $result[0]['customerProfileId'];
        $customerPaymentProfileId = $result[0]['customerPaymentProfileId'];
		
		// CUSTOMER MAY BE USING A DIFFERENT CC, SO WE MUST UPDATE THE BILLING PROFILE ON EACH MANUAL PAYMENT!
		// THIS ALLOWS THEM TO SWITCH CARDS IF NEEDED, AND LAST CARD USED WILL BE THE BILLING PROFILE FOR REBILLS FROM CRONJOB
		$response = updateCustomerPaymentProfile($customerProfileId, $customerPaymentProfileId, $cardNumber, $cardExpiryDate, $cardCode, $description, $address, $customerId);
		if ($response != null && $response != false) $charge_customer = true; // PROFILE UPDATE GOOD - CHARGE
		else $charge_customer = false;	// PROFILE UPDATE FAILED - DO NOT CHARGE	

    } else {
		
        echo debug_stmt("No billing profile found. Creating one now.", 1); // LET'S MAKE THE CUSTOMER PROFILE NOW!
		
		$response = createCustomerWithPaymentProfile($cardNumber, $cardExpiryDate, $cardCode, $description, $address, $customerId);
	
		if ($response != null && isset($customerProfileId)) { 
			$charge_customer = true; // PROFILE CREATION GOOD - CHARGE
			$customerProfileId = $response->getCustomerProfileId();
			$customerPaymentProfileId = $response->getCustomerPaymentProfileIdList()[0];
		} else {
			$charge_customer = false;	// PROFILE CREATION FAILED - DO NOT CHARGE
		}	
		
		if (isset($customerProfileId) && isset($customerPaymentProfileId) && $customerProfileId > 0 && $customerPaymentProfileId > 0) {
			// NOW UPDATE MEMBERS TABLE WITH NEW BILLING PROFILE!
			$table = 'members';
			$data = [
			'customerProfileId' => $customerProfileId,
			'customerPaymentProfileId' => $customerPaymentProfileId
			];
			$where = ['Username' => ['=', $_SESSION['loggedin']]];
			$limit = 1;  // Number of rows to update
			$live = 1;  // Whether to actually perform the update or not
			$show_debug = 1;  // Whether to show debugging information or not

			echo debug_stmt("Updating members table - adding billing profile data", 1);
			$up_result = update($table, $data, [], $where, $live, $limit, $show_debug);
		}
		if (isset($up_result)) {
		echo debug_stmt("Successfully updated.", 1); 
		} else {
		echo debug_stmt("Failed to update.", 0); 
		}
		
		if ($result) {
			echo debug_stmt("Successfully updated billing profile.", 1); 
		} else {
			echo debug_stmt("Failed to update.", 0); 
		}		
    }

if ($charge_customer == true) {
	echo debug_stmt("Attempting charge to customer profile", 1);
	$response = chargeAWSCustomerProfile($customerProfileId, $customerPaymentProfileId, $amount, $refId, $shippingAddress, $description, $invoiceNumber, $tax, $freight, $duty);
}	

if ($charge_customer == true && $response != null) {
    $resultCode = $response->getMessages()->getResultCode();
	
	$transactionResponse = $response->getTransactionResponse();
/*	A responseCode of "1" indicates a successful transaction.
	A responseCode of "2" indicates a declined transaction.
	A responseCode of "3" indicates an error with the transaction.	*/
	
	$insertData = [
        'user_payment_plan_id' => $user_paymentplan_id,
        'amount' => $amount,
        'email' => $email,
        'firstname' => $firstName,
        'lastname' => $lastName,
        'address' => $address1,
        'address2' => '',  // if applicable, not using in cc form
        'city' => $city,
        'zip' => $zip,
        'state' => $state,
        'country' => $country,
        'phone' => $phone,
        'timestamp' => time(),
        'ip' => $Global_userip,
		'transaction_id' => ($resultCode == "Ok") ? $response->getTransactionResponse()->getTransId() : '',
		'error_code' => ($resultCode != "Ok") ? $response->getMessages()->getMessage()[0]->getCode() : '',
        'error_text' => ($resultCode != "Ok") ? $response->getMessages()->getMessage()[0]->getText() : '',
		'success' => ($resultCode == "Ok" && $transactionResponse->getResponseCode() == "1") ? 'Y' : 'N'
    ];
	

	echo debug_stmt("Inserting Authnet History - return data from gateway", 1);
    $iresult = insert('authorize_history', $insertData, 1, 1);
	if ($iresult) {
		echo debug_stmt("Successfully inserted authnet history.", 1); 
	} else {
		echo debug_stmt("Failed to insert authnet history.", 0); 
	}

	//!!! 11/23/23 Check if the transaction was actually approved. It turns out $resultCode == "Ok" DOES NOT MEAN APPROVED!
	// 11/29/23 HAD TO REMOVE $resultCode == "Ok" FROM THIS COND, AS IT DID NOT SHOW ERRORS TO USER ON DECLINES!
	// SINCE DECLINE IS OK.
    if ($transactionResponse && $transactionResponse->getResponseCode() == "1") {
		// TRANSACTION WAS SUCCESSFUL!
		echo debug_stmt("Successfully charged authnet!", 1);		
		$_SESSION['ordrenr'] = $response->getTransactionResponse()->getTransId();
		$transactionId = $response->getTransactionResponse()->getTransId();
		//echo "Charge Customer Profile SUCCESS: " . $transactionId . "\n";
		define('IPN_PROCESS', true);
		
		//include $GLOBALS['path'].'apay/pm/AuthorizeNet/aws_logging.inc.php';
		include $GLOBALS['path'].'apay/process_success.php';
		echo '<h2 style="color:green">The transaction was successful!</h2';
		echo '<br><br><h2><a href="/Members/index.php">Please click here to continue</a>.</h2><br>';
		include $Global['path'].'Sub/tpl/footer_tpl.php';
		
		$_SESSION['all_signed_up2'] = true;		
		if (empty($Error_msg)) $Error_msg = '<br><br><br>The transaction was successful!';
		$Success_msg = true;		
		exit;
		
		// SEND A TEXT ALERT SMS TO ADMIN OR TECH 
		$to = '5743495401@vtext.com'; // JEREMY DUNCAN // VERIZON
		$subject = 'Payment Alert!';
		$message = $firstName.' '.$lastName.' phone: '.$phone.' user: '.$_SESSION['loggedin'].' just paid '.$amount.' for '.$description;		
		$to  = '2073218774@txt.att.net'; // JIM
		//mail($to, $subject, $message, "From: {$GLOBALS['admin_email_heading']} <{$GLOBALS['admin_email']}>\r\n");
    } else { // failed transaction
		echo debug_stmt("Charged Failed!", 0);	
        $errorMessages = $response->getMessages()->getMessage();
        $errorCode = $errorMessages[0]->getCode();
        $errorText = $errorMessages[0]->getText();

		// THIS IS TO AVOID SHOWING CONFUSING AUTHNET ERROR "Charge ERROR: I00001 - Successful." TO END USERS!!
		// NOW IT WILL SHOW "Charge ERROR: I00001" INSTEAD
        if ($errorText != 'Successful.') echo '<h2 style="color:red">Charge ERROR: '.$errorCode.' - '.$errorText.'<br>Please try again. If you continue to have issues, contact your card issuer to determine the reason.</h2><hr>';
		else echo '<h2 style="color:red">Charge ERROR: '.$errorCode.'<br>Please try again. If you continue to have have isues, contact your card issuer to determine the reason.</h2><hr>';

		// SEND A TEXT ALERT SMS TO ADMIN OR TECH 
		$to = '5743495401@vtext.com'; // JEREMY DUNCAN // VERIZON
		$subject = 'Payment Failed.';
		$message = $firstName.' '.$lastName.' phone: '.$phone.' user: '.$_SESSION['loggedin'].' just tried to pay '.$amount.' for '.$description;		
		$to  = '2073218774@txt.att.net'; // JIM
		//mail($to, $subject, $message, "From: {$GLOBALS['admin_email_heading']} <{$GLOBALS['admin_email']}>\r\n");
    }
} else {
    // Place your code for a null response here
	//echo '<h2 style="color:red">Charge ERROR: Null response. Please <a href="/apay/pay.php?resub=Y">try again</a>.<br><br>If you continue to have trouble, please contact support.</h2>';
	echo '<h2 style="color:red">Charge ERROR: Null response. Please double check all your info is correct, and try again.</h2><hr>';	
}
?>
