<?php
require 'vendor/autoload.php';

use GuzzleHttp\Client;

// Initialize Guzzle client
$client = new Client([
    'base_uri' => 'https://bitpay.com/',
    'timeout'  => 2.0,
]);

// Your BitPay API Token
$token = 'Your_BitPay_Token_Here';

// Initialize variables
$invoiceId = '';
$qrCodeUrl = '';
$errorMsg = '';
$successMsg = '';

// Function to create an invoice
function createInvoice($client, $token) {
    // Create invoice data
    $invoiceData = [
        'token' => $token,
        'price' => 10,
        'currency' => 'USD',
    ];

    try {
        // Create the invoice
        $response = $client->post('invoices', [
            'headers' => [
                'Authorization' => 'Bearer ' . $token,
                'Content-Type'  => 'application/json',
            ],
            'json' => $invoiceData
        ]);

        // Decode the JSON response
        $data = json_decode($response->getBody(), true);
        return [
            'invoiceId' => $data['id'],
            'qrCodeUrl' => $data['url'],
            'status' => 'success'
        ];

    } catch (Exception $e) {
        return [
            'errorMsg' => $e->getMessage(),
            'status' => 'error'
        ];
    }
}

// Check for payment confirmation (assuming invoiceId is available)
function checkPaymentStatus($client, $invoiceId, $token) {
    try {
        $response = $client->get("invoices/{$invoiceId}", [
            'headers' => [
                'Authorization' => 'Bearer ' . $token,
            ],
        ]);
        
        $data = json_decode($response->getBody(), true);
        if ($data['status'] === 'confirmed' || $data['status'] === 'complete') {
            return 'Payment has been confirmed.';
        }
        return 'Payment is still pending.';

    } catch (Exception $e) {
        return $e->getMessage();
    }
}

// Main logic
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $result = createInvoice($client, $token);
    
    if ($result['status'] === 'success') {
        $invoiceId = $result['invoiceId'];
        $qrCodeUrl = $result['qrCodeUrl'];
        $successMsg = checkPaymentStatus($client, $invoiceId, $token);
    } else {
        $errorMsg = $result['errorMsg'];
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>BitPay Payment</title>
</head>
<body>

<h1>BitPay Payment</h1>

<?php if ($errorMsg): ?>
    <div style="color: red;">
        <?php echo $errorMsg; ?>
    </div>
<?php endif; ?>

<?php if ($successMsg): ?>
    <div style="color: green;">
        <?php echo $successMsg; ?>
    </div>
<?php endif; ?>

<?php if ($invoiceId && $qrCodeUrl): ?>
    <p>Invoice ID: <?php echo $invoiceId; ?></p>
    <p><img src="<?php echo $qrCodeUrl; ?>" alt="QR Code"></p>
<?php else: ?>
    <form method="post">
        <button type="submit">Buy with BitPay</button>
    </form>
<?php endif; ?>

</body>
</html>




<?php
require 'vendor/autoload.php';

use GuzzleHttp\Client;

$client = new Client([
    'base_uri' => 'https://bitpay.com/',
    'timeout'  => 2.0,
]);

$token = 'Your_BitPay_Token_Here';

$invoiceId = '';
$qrCodeUrl = '';
$errorMsg = '';
$successMsg = '';

function createInvoice($client, $token) {
    $invoiceData = [
        'token' => $token,
        'price' => 10,
        'currency' => 'USD',
    ];

    try {
        $response = $client->post('invoices', [
            'headers' => [
                'Authorization' => 'Bearer ' . $token,
                'Content-Type'  => 'application/json',
            ],
            'json' => $invoiceData
        ]);

        $data = json_decode($response->getBody(), true);
        return [
            'invoiceId' => $data['id'],
            'qrCodeUrl' => $data['url'],
            'status' => 'success'
        ];
    } catch (Exception $e) {
        return [
            'errorMsg' => $e->getMessage(),
            'status' => 'error'
        ];
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $result = createInvoice($client, $token);
    
    if ($result['status'] === 'success') {
        $invoiceId = $result['invoiceId'];
        $qrCodeUrl = $result['qrCodeUrl'];
    } else {
        $errorMsg = $result['errorMsg'];
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>BitPay Payment</title>
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <script>
    function checkPaymentStatus() {
        const invoiceId = "<?php echo $invoiceId ?>";
        if (invoiceId) {
            fetch(`check_payment_status.php?invoiceId=${invoiceId}`)
            .then(response => response.json())
            .then(data => {
                if (data.status === "confirmed" || data.status === "complete") {
                    document.getElementById('status').textContent = "Payment has been confirmed.";
                    clearInterval(interval);
                }
            })
            .catch(error => {
                console.error('Error:', error);
            });
        }
    }
    const interval = setInterval(checkPaymentStatus, 5000);  // Poll every 5 seconds
    </script>
</head>
<body>

<div class="container">
    <h1 class="text-center mt-5">BitPay Payment</h1>

    <?php if ($errorMsg): ?>
        <div class="alert alert-danger">
            <?php echo $errorMsg; ?>
        </div>
    <?php endif; ?>

    <div id="status">
        <?php if ($invoiceId && $qrCodeUrl): ?>
            <p class="alert alert-primary">Invoice ID: <?php echo $invoiceId; ?></p>
            <p><img src="<?php echo $qrCodeUrl; ?>" alt="QR Code"></p>
        <?php else: ?>
            <form method="post">
                <button type="submit" class="btn btn-primary">Buy with BitPay</button>
            </form>
        <?php endif; ?>
    </div>
</div>

</body>
</html>
