<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
// COPYRIGHT JIM SYMONDS 2023, AUTOMATIC WEB SOFTWARE / DIRECTSALESMLM.COM
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
//require_once 'payment_setup.inc.php';
//require_once 'dbconn.php';
require_once ''.$_SERVER['DOCUMENT_ROOT'].'/Members/logincheck.php';
require_once ''.$_SERVER['DOCUMENT_ROOT'].'/apay/pm/stripe/vars.php';

function handleStripeException2($e) {
    echo 'Message is:' . $e->getError()->message . '\n';
    //pay with other card button
    //echo PayCardbtn($_POST['amount'], $_POST['customer_id'], $_POST['product_name'], 'Pay with other card', 'checkout.php?create_checkout_session=Y');
}

if (!empty($_SESSION['amount'])) { // FOR USE WITHOUT CRON JOB
	$amount = $_SESSION['amount'] * 100;
	$_POST['amount'] = $amount;	
} else {
	$_POST['amount'] = $_POST['amount'] * 100;	// TO SUUPORT CRON
}	
/*
foreach ($_POST as $key => $value) {
	echo $key . ': ' . $value . "<br>\n";
}
print_r($_POST);*/
	
try {
	$paymentIntent= $stripe->paymentIntents->create([
		'customer'=> $_POST['customer_id'],
		'description' => $_POST['product_name'],
		'payment_method' => $_POST['pm'],
		'confirm' => 'true',
		'amount' => $_POST['amount'],
		'currency' => $currency,
		'automatic_payment_methods' => [
			'enabled' => true,
		],
		'return_url' => $return_url,
		'metadata' => $_POST['metadata'],
	]);
	
} catch(\Stripe\Exception\CardException $e) {
	handleStripeException2($e);
} catch (\Stripe\Exception\ApiErrorException $e) {
	handleStripeException2($e);
} catch (Exception $e) {
	echo 'Message is:' . $e->getMessage() . '\n';
}		

// This code checks if $paymentIntent->id is set (not null) and not empty. If both conditions are true, it sets $url_slug to $paymentIntent->id
if (isset($paymentIntent->id) && !empty($paymentIntent->id)) {
    $url_slug = $paymentIntent->id;
} else {
	$url_slug = '';
}	

//header("HTTP/1.1 303 See Other");

/*
if($paymentIntent->next_action) {
	echo "Location: " . $paymentIntent->next_action->redirect_to_url->url;
} else if (!empty($url_slug)) {
	echo "Location: " . $return_url.'?payment_intent='.$paymentIntent->id;
} else {
	echo "Location: " . $return_url;
}*/

if($paymentIntent->next_action) {
	header("Location: " . $paymentIntent->next_action->redirect_to_url->url);
} else if (!empty($url_slug)) {
	header("Location: " . $return_url.'?payment_intent='.$paymentIntent->id);
} else {
	header("Location: " . $return_url);
}
	
//echo 'end of file';
?>