<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
// COPYRIGHT JIM SYMONDS 2023, AUTOMATIC WEB SOFTWARE / DIRECTSALESMLM.COM
//require_once 'dbconn.php';
//require_once ''.$_SERVER['DOCUMENT_ROOT'].'/Members/logincheck.php';

//echo $_SERVER['DOCUMENT_ROOT'];

//$debug = false;
//$debug = true;
//$GLOBALS['debug'] = true;

include_once ''.$_SERVER['DOCUMENT_ROOT'].'/Sub/Config.inc.php';
include_once ''.$_SERVER['DOCUMENT_ROOT'].'/phpcpr.php';


//if ($_SESSION['UserID'] < 4) $debug = true;


if (isset($_GET['uname']) && $_GET['uname'] != '') {
	$payer_username = $_GET['uname'];
	$_SESSION['payer_username'] = $_GET['uname'];	
} else if (isset($_SESSION['loggedin'])) {
	$payer_username = $_SESSION['loggedin'];
} else {
	//echo 'Error - no username found!';
	//exit; // CANNOT RUN PAGE WITHOUT USERNAME!
	// QQQ FOR TESTING ONLY!
	//$payer_username = 'test'; 
	//$_SESSION['payer_username'] = 'test';
	// END TEST!
}	

if (isset($_GET['p']) && $_GET['p'] != '') {
	$program_id = $_GET['p'];
	$_SESSION['program_id'] = $_GET['p'];	
} else if (isset($_SESSION['program_id']) && $_SESSION['program_id'] != '') {
	$program_id = $_SESSION['program_id'];
} else {
	//echo 'Error - no program_id found!';
	//exit; // CANNOT RUN PAGE WITHOUT PROGRAM ID!
	$program_id = 1; // DEFAULT TO PROGRAM 1
	$_SESSION['program_id'] = $program_id;
}

if ($debug == true) echo '<br>payer username: '.$payer_username;

//HTML Entities: When outputting data that was input by the user, you should use functions like htmlspecialchars() or htmlentities(). This will convert special characters to their HTML entities, which prevents cross-site scripting (XSS) attacks by ensuring that user input is displayed as data, not code.


// FIND ID OF PAYER
//$table, $selectFields, $where, $limit, $debug
$result = select(['ID, Username, email, First_Name, Last_Name'], 'members', [], [['Username' => $payer_username]], null, null, null, 1, 1);
//print_r($row);
$row = isset($result[0]) ? $result[0] : null;
$payer_id = $row['ID'];
$email = $row['email'];
$fname = $row['First_Name'];
$lname = $row['Last_Name'];
if ($debug == true) echo '<br>payer id is: '.$payer_id;

$post_amount = $_POST['amount'];

unset($row);
// FIND OUT WHO GETS PAID, AMOUNT, UPP
//$table, $selectFields, $where, $limit, $debug
//$row = select('payment_plan', ['username', 'amount', 'payment_plan_id', 'user_payment_plan_id'], ['payer_username' => $payer_username], 1);
$result = select(['username, amount, payment_plan_id, user_payment_plan_id'], 'payment_plan', [], [['payer_username' => $payer_username], ['payment_complete' => 'N']], null, null, null, 1, 1);
$row = isset($result[0]) ? $result[0] : null;

if (!isset($row['username'])) {
	$result = select(['username, amount, payment_plan_id, user_payment_plan_id'], 'payment_plan', [], [['payer_username' => $payer_username], ['payment_complete' => 'Y']], null, null, null, 1, 1);
	$row = isset($result[0]) ? $result[0] : null;
}

//print_r($row);
$paid_to_username = $row['username'];
$amount = $row['amount'];
$_SESSION['amount'] = $amount;
$payment_plan_id = $row['payment_plan_id'];
$_SESSION['pp'] = $payment_plan_id;
$upp = $row['user_payment_plan_id'];

if ($debug == true) {
	echo '<br>pay plan username (paid to): '.$paid_to_username;
	echo '<br>amount: '.$amount;
	echo '<br>payment_plan_id: '.$payment_plan_id;
	echo '<br>user_payment_plan_id: '.$upp;
}
// FIND STRIPE KEYS FOR WHO GETS PAID
//$table, $selectFields, $where, $limit, $debug
$row = select(['stripekey, stripesecretkey'], 'members', [], ['Username' => $paid_to_username], null, null, null, 1, 1);
//print_r($row);
$stripekey = $row['stripekey'];
$stripesecretkey = $row['stripesecretkey'];
// FOR TESTING ONLY!
// TEST KEYS FOR THE ROCKET RECRUITER!
//$stripekey = 'pk_test_51NDYfsB6H5WcUOf8JkXsBCbXWlZ75tKN32AvuNBYjbD0tUfKFyy7bIDGrb5IXzolOyxbWAyPckfnW6uteXN2KnD500eWHVLizW';
//$stripesecretkey = 'sk_test_51NDYfsB6H5WcUOf8wKrLfHlI8nRJGzMYX3EevtZtorgOkvoI3M1hpMkKniokRc8FPx7OoPGa5P43GssPQT0HHsFv002ellrc65';

$row = select(['stripe_customer_id, stripe_payment_method'], 'members', [], ['Username' => $payer_username], null, null, null, 1, 1);
$stripe_customer_id = isset($row[0]['stripe_customer_id']) ? $row[0]['stripe_customer_id'] : '';
$stripe_payment_method = isset($row[0]['stripe_payment_method']) ? $row[0]['stripe_payment_method'] : '';


if ($debug == true) {
	echo '<br>STRIPE KEY: '.$stripekey;
	// QQQ BE EXTRA CRAEFUL NEVER TO LEAVE THIS COMMENTED IN ON LIVE SITE!!
	// FOR DEV USE ONLY!!!!!
	//echo '<br>STRIPE SKEY: '.$stripesecretkey;
	echo '<br>KEEP STRIPE SKEY HIDDEN - MUST NOT BE REVEALED IN HTML ELEMENTS!';
}


  // Print all variables in the global scope one per line
 /* foreach($GLOBALS as $name => $value) {
    echo "$name: ";
    var_export($value); // var_export instead of print_r to handle all types better
    echo "\n\n";
  }*/
?>