<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
// FILE CREATED 12/3/23 TO REPLACE THE NORMAL PROCESS OF GOING THRU LOGGING AND FINALIZE, WHICH RELY ON TOO MANY VARS BEING SET UP TO RUN WITHOUT ISSUES.
// SO, GOT ONLY WHAT NEEDS TO BE DONE FROM LOGGING AND FINALIZE, AND PUT THERE HERE INSTEAD. END OF FILE CALLS Mat.give.php to PLACE IN MATRIX OR JUST CREATE MORE MATRIX COMMS (RESUBS).
if (!isset($program_id)) { // WE USE $_GET VARS WHEN PAGE IS A STAND ALONE, FOR ADMIN MARKING PAYMENTS PAID!
	include './../Sub/Config.inc.php';
	//$GLOBALS['debug'] = true;
	include $GLOBALS['path'].'phpcpr.php';
}

//Get the user information
if (!empty($_REQUEST['userid'])) {
	$temp = explode(':#:', base64_decode(urldecode($_REQUEST['userid'])));	
	
	$select_plan = (int) $temp[0];
	$select_master_plan = (int) $temp[1];
	
	if ($debug == true) echo 'plan id: '.$select_plan.' upp: '.$select_master_plan;
	//exit;
}
//if (!isset($Global['sub_period'])) $Global['sub_period'] = 30; // QQQ SHORT TERM FIX!
if (!isset($Global['sub_period'])) $Global['sub_period'] = 0; // QQQ SHORT TERM FIX!
$GLOBALS['sub_period'] = $Global['sub_period']; // TO USE IN FUNCTIONS!

include $GLOBALS['path'].'Ipn/Give/mat_place_modular_functions.php';
if (!defined('IPN_PROCESS')) define('IPN_PROCESS', true);


/* // OLD WAY FROM LOGGING NEEDED THESE VARS PASSED IN
//$payment_processor
//$payment_plan_id
//$payer_username
//$amount
//$user_program_id
//$payer_id = ID of the person paying
//$user_payment_plan_id = The id of the main payment plan system
//$program_id = The id of the program in question
//$program_type = If its a subscription or a normal payment

$program_powerline = The number of powerlines in the program
$plan_info = An array containing all the payment_plans in this user_payment_plan.
*/

// THIS FILE ONLY NEEDS THESE 2 VARS TO RUN! ($program_id, $payer_username)
if (!isset($program_id) && isset($_REQUEST['program'])) $program_id = $_REQUEST['program'];
if (!isset($payer_username) && isset($_REQUEST['payer_username'])) $payer_username = $_REQUEST['payer_username'];

/*echo $program_id;
echo $payer_username;
*/

if (!isset($program_id) || !isset($payer_username)) {
	echo 'INVALID PROCESS';
	//echo 'prog id or payer username missing.';
	exit;
}	


if (isset($Global['cc_processor_used'])) $payment_processor = $Global['cc_processor_used'];
else if (!isset($payment_processor)) $payment_processor = 'C'; // IF NOT SET, WE ASSUME IT'S A CUSTOM, MARKED PAID!

$cc_pending = 'N'; // QQQ IF NEED BE IN NON MATRIX WHERE LOGS SHOULD BE PENDING, THEN MAKE THIS Y!
$show_debug = 1;

$timestamp = time();
$run_finalize = false; // INI VAR

if (!isset($_SESSION['debug'])) $_SESSION['debug'] = false; // in header also

// DECIDE IF THE PAYMENT TYPE HERE!
 // VALUES, N (normal one time or sub), Y (yearly), L (lifetime)
if (isset($_SESSION['payment_program'])) {
	$duration_type = $_SESSION['payment_program']; // THIS IS SET IN pay.php, SO PAYER OR ADMIN MARKING PAID WILL TRIGGER / SET UP THIS VALUE! 

} else if (isset($GLOBALS['payment_program'])) { // SUSP CRON MUST USE / SET UP THIS VALUE! (AS CRONS CANNOT RUN SESSIONS)!
	$duration_type = $_GLOBALS['payment_program'];

} else {
	$duration_type = 'N'; // DEFAULT TO 'N' (ONE TIME OR 30 DAY SUB)
}

$_GLOBALS['payment_program'] = $duration_type; // THIS IS NEEDED FOR MAT FUNCTIONS FILE

// FIND OUT PAYER UPROG ID ///////////////////////////////////////////////////////////////////
// Prepare select fields, conditions, and order by parameters
$selectFields = ['m.ID, u.user_program_id'];
$mainTable = ['table' => 'members', 'as' => 'm'];
$joinConditions = [
    [
        'table' => 'user_program',
        'as' => 'u',
        'condition' => 'm.ID = u.ID'
    ]
];
$where = [
		'm.Username' => ['=', $payer_username],
		'u.program_id' => ['=', $program_id]
];
$orderBy = null;
$limit = 1;

// Use PHPCPR's select function
$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, $orderBy, $limit, 1);
$buffer = isset($result[0]) ? $result[0] : null;

$payer_id = $buffer['ID'];
$user_program_id = $buffer['user_program_id'];

unset($buffer);

// SELECT THE USER PAYMENT PLAN ///////////////////////////////////////////////////////////////////
// Prepare select fields, conditions, and order by parameters
$selectFields = 'user_payment_plan_id, valid_plan, real_sponsorid';
$mainTable = 'user_payment_plan';
$where = [
    'user_program_id' => ['=', $user_program_id],
    //'valid_plan' => ['!=', 'H'],
    'payment_program' => ['=', $duration_type]
];
//$orderBy = 'valid_plan ASC, user_payment_plan_id DESC';
$orderBy = 'user_payment_plan_id DESC';
$limit = 1;

// Use PHPCPR's select function
$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, 1);
$buffer = isset($result[0]) ? $result[0] : null;

if (isset($buffer['user_payment_plan_id'])) {
	$user_payment_plan_id = $buffer['user_payment_plan_id'];

	// FIND PAYMENT PLAN
	// Prepare select fields and conditions
	$selectFields = '*';
	$mainTable = 'payment_plan';
	$where = [
		'user_payment_plan_id' => ['=', $user_payment_plan_id]
	];
	if (isset($select_plan)) {
		$where = [
			'user_payment_plan_id' => ['=', $user_payment_plan_id],
			'payment_plan_id' => ['=', $select_plan]
		];
	}	
	// Use PHPCPR's select function
	$payment_result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
	$payment_buffer = isset($payment_result[0]) ? $payment_result[0] : null;

	$amount = $payment_buffer['amount'];
	$plan_type = $payment_buffer['plan_type'];
	$collected_by = $payment_buffer['collected_by'];
	$payment_plan_id = $payment_buffer['payment_plan_id'];
	$payment_complete = $payment_buffer['payment_complete'] ?? 'N';
	$payer_username = $payment_buffer['payer_username'];
	$payee_username = $payment_buffer['username'];
	
	// SAFEGUARD AGAINST HACKING ABUSE!
	// IF THE LOGGED IN USER IS NEITHER THE PAYER (MAKING PAYMENT), NOR THE RECEIVER (MARKING USER PAID) OF THIS PAYMENT, THEN WE ABORT!
	if ((!isset($_SESSION['admin_login']) || $_SESSION['admin_login'] == false) && $payer_username != $_SESSION['loggedin'] && $payee_username != $_SESSION['loggedin']) {
		echo 'Invalid action';
		exit;
	}	

	//FIX THE payment_period issue that might happen if someone pays for several periods at once.
	//$payment_period = ceil($amount / $buffer_log['amount']); // UPDATE TO USE 1 MONTH OR 12 MONTH (FOR YR)!
	$payment_period = 1;

	// UPDATE PAYMENT PLAN!
	$data = [
		'last_payment_method' => $payment_processor,
		'payment_period' => ['expression' => 'payment_period'.'+'.$payment_period],
		'sec_payment_complete' => 'Y',
		'payment_complete' => 'Y',
		'first_paid_date' => $timestamp,
		'last_paid_date' => $timestamp
	];
	
	// NOW SEE IF WE HAVE MORE ANY MORE PAY PLANS IN THIS UPP, STILL UNPAID	
	$where = [
		'user_payment_plan_id' => ['=', $user_payment_plan_id],
		'payment_plan_id' => ['!=', $payment_plan_id],
		'payment_complete' => ['!=', 'Y']
	];
	// Use PHPCPR's select function
	$payment_result2 = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
	$payment_buffer2 = $payment_result2[0] ?? null;

	if (isset($payment_buffer2['payment_plan_id'])) {
		$run_finalize = false;
	} else {
		if ($payment_complete == 'N') $run_finalize = true;
	}

	$where = ['payment_plan_id' => ['=', $payment_plan_id]];
	if ($payment_complete == 'N') {
		update('payment_plan', $data, [], $where, 1, 1, 1);
		if ($run_finalize == false) update('user_payment_plan', ['valid_plan' => 'S'], [], ['user_program_id' => ['=', $user_program_id], 'user_payment_plan_id' => ['=', $user_payment_plan_id], 'valid_plan' => ['NOT IN', ['S','Y']]], 1, 1, $show_debug);
	}
	
	
} else {
	$user_payment_plan_id = 0;
	$user_paymentplan_id = 0;
	$payment_plan_id = 0;
	$collected_by = 'admin';
	$payment_period = 1;
}		

if (!isset($cron)) $cron = ''; // THIS WILL BE EMPTY FOR MANUAL PAYMENTS, AND SHOW 'CRON' ON ALL CRON PAYMENTS IN PAYMENT LOGS!

if ($payment_plan_id != 0) {
	// FIND THE UPROG ID OF THE PAYEE!
	$selectFields = 'u.user_program_id';
	$mainTable = ['table' => 'members', 'as' => 'm'];
	$joinConditions = [
		['table' => 'user_program', 'as' => 'u', 'condition' => 'm.ID = u.ID'],
	];
	$where = [
		'm.Username' => ['=', $payee_username],	
		'u.program_id' => ['=', $program_id]
	];
	$groupBy = null;
	$orderBy = null;

	$result = select($selectFields, $mainTable, $joinConditions, $where, $groupBy, null, $orderBy, 1, 1);
	$buffer = isset($result[0]) ? $result[0] : null;

	$real_payee_user_program_id = $buffer['user_program_id'] ?? 1;
} else {
	$real_payee_user_program_id = 1;
}
	
// CREATE PAYMENT LOG!		
$data = [
    'collected_by' => $collected_by,
    'program_id' => $program_id,
    'payment_plan_id' => $payment_plan_id,
    'user_program_id' => $real_payee_user_program_id,
    'payment_processor' => $payment_processor,
    'payment_processor_custom' => $cron,
    'payer_username' => $payer_username,
    'amount' => $amount,
    'timestamp' => $timestamp,
    'cc_pending' => $cc_pending
];

if ($payment_complete == 'N') insert('payment_log', $data, 1, 1);

// FINALIZE ACTIONS BELOW HERE!
if ($run_finalize === true) {
	update('user_payment_plan', ['valid_plan' => 'Y'], [], ['user_program_id' => $user_program_id, 'user_payment_plan_id' => ['=', $user_payment_plan_id]], 1, 1, $show_debug);

	update('user_payment_plan', ['timestamp_started' => $timestamp], [], ['user_payment_plan_id' => $user_payment_plan_id, 'timestamp_started' => NULL], 1, 1, $show_debug);

	//update('user_payment_plan', ['valid_plan' => 'H'], [], ['user_program_id' => $user_program_id, 'user_payment_plan_id' => ['!=', $user_payment_plan_id]], $live, 0, $show_debug);

	// MAKE USER ACTIVE!
	activate_user($payer_id, $program_id, $real_payee_user_program_id); // DOES NOT GET CALLED IN MAT FUNCTIONS, WHEN IPN_PROCESS IS TRUE, WHICH IT IS HERE!

	// GIVE MORE EXPIRE TIME -- ONLY ON SUB PROGRAMS!
	// COMMENTED - ERRORS WHEN PP IS NOT FOUND
	//if ($plan_type == 'S') extend_expire_time($payer_id, $program_id);

	// THIS IS FINE, YOU WILL NOT BE PAYING AGAIN ON A ONE TIME PROGRAM!
	extend_expire_time($payer_id, $program_id);

	// FIND PROGRAM GIVEAWAY FILE TO RUN, IF ANY
	$selectFields = ['*'];
	$mainTable = 'program';
	$where = ['program_id' => ['=', $program_id]];

	$result = select($selectFields, $mainTable, [], $where);
	$buffer = $result[0]; // Assign the first row array to $buffer

	if ($buffer['giveaway_enabled'] == 'Y' && $payer_username != 'QQQdemo') {
		$giveaway_enabled = true;
		$giveaway_file = $Global['path'].'Ipn/Give/'.$buffer['giveaway_file'];
	} else {
		$giveaway_enabled = false;
	}

	if ($giveaway_enabled === true && file_exists($giveaway_file)) {
		include $giveaway_file;
	}

	if (isset($_SESSION['UserID'])) { // ADDED TO STOP WARNINGS, WHEN RUN BY CRON
		// NOW WE KILL USER STATUS CHECK SESSION, SO THE FRESH WILL SHOW THEM ACTIVE NOW!
		if (isset($_SESSION['a'.$_SESSION['UserID']]['status_check'])) unset($_SESSION['a'.$_SESSION['UserID']]['status_check']);

		// NOW WE SET THIS TRUE, SO THEY WILL SEE THE FULL MENU IN BACK OFFICE!
		$_SESSION['Returning'] = true;

		if ($payer_id == $_SESSION['UserID']) { // THIS IS THE PAYER!

			// WE ALWAYS REDIRECT BACK TO PAY PAGE, ONCE FINISHED PROCESSING PAYMENT!
			//header("Location: ./pay.php?program=".$program_id);
			//exit;
			
		} else if (!isset($cron) || $cron != 'CRON') {
			echo '<div style="text-align:center">';
			//echo '<br><br><br><h1>User '.$payer_username.' marked paid!</h1>';
			echo '<br><br><br><h1>'.$payer_username.' is now Active!</h1>';
			//echo '<h2>You may now close this window, and refresh the user in admin panel or click on their status, to verify.</h2>';
			if (!isset($_SESSION['admin_login']) || $_SESSION['admin_login'] === false) echo '<br /><a href="../Members/viewteam.php">Click here</a> to view your team.';
			echo '</div>';
		}	
	}
} else if ($payment_complete == 'N') { // FINALIZE NOT RUN, SINGLE PAYMENT WAS PROCESSED!
		echo '<div style="text-align:center">';
		//echo '<br><br><br><h1>User '.$payer_username.' marked paid!</h1>';
		echo '<br><br><br><h1>Single payment marked paid for '.$payer_username.'!</h1>';
		//echo '<h2>You may now close this window, and refresh the user in admin panel or click on their status, to verify.</h2>';
		if (!isset($_SESSION['admin_login']) || $_SESSION['admin_login'] === false) echo '<br /><a href="../Members/viewteam.php">Click here</a> to view your team.';
		echo '</div>';
} else {
		echo '<div style="text-align:center">';
		//echo '<br><br><br><h1>User '.$payer_username.' marked paid!</h1>';
		echo '<br><br><br><h1>This payment was already processed for '.$payer_username.'!</h1>';
		if (!isset($_SESSION['admin_login']) || $_SESSION['admin_login'] === false) echo '<br /><a href="../Members/viewteam.php">Click Here</a> to view your team.';
		echo '</div>';
}		