<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './cookie.php';
$pageName = 'conf_ar';
//check if we have a hash param passed
if (empty($_GET['hash'])) {
	$msg = 'No parameters passed in URL. No record found.';
}
$hash = htmlspecialchars(trim($_GET['hash']));

//$_SESSION['lead_signed_up'] = false;
$_SESSION['lead_signed_up'] = true;

//get the lead info from the DB
$selectFields = 'ID, ar_leads_firstname, ar_leads_lastname, ar_leads_email, ip, ar_leads_phone, ar_leads_date, ar_leads_id, ar_leads_status';
$mainTable = 'ar_leads';
$where = ['ar_leads_md5' => ['=', $hash]]; // Assuming $hash is already sanitized
$limit = 1;

$result = select($selectFields, $mainTable, [], $where, null, null, null, $limit, 1);
$buffer = isset($result[0]) ? $result[0] : null;

if ($buffer) {
	//echo 'found lead';
    $_SESSION['page_name'] = $buffer['ar_leads_firstname'];
    $_SESSION['page_lastname'] = $buffer['ar_leads_lastname'];
    $_SESSION['page_email'] = $buffer['ar_leads_email'];
    $_SESSION['page_phone'] = $buffer['ar_leads_phone'];

	// Query to find the sponsor
	$selectFields = ['ID', 'Username', 'First_Name', 'Last_Name', 'display_name'];
	$mainTable = 'members';
	$joinConditions = [''];
	$where = ['ID' => ['=', $buffer['ID']]];

	$result2 = select($selectFields, $mainTable, [], $where, null, null, null, 1, 1);
	$buffer2 = isset($result2[0]) ? $result2[0] : null;

	$SponsorID = $buffer2 ? $buffer2['Username'] : null;
}

//if no such lead exists go to home page
if (empty($buffer['ar_leads_id'])) {
	$msg = 'No record found.';
}

if ($buffer['ar_leads_status'] == 1) {
	$msg = 'You are already subscribed.';
} else if (isset($buffer['ar_leads_status'])) {
	//update the leads status to subscribed
	$table = 'ar_leads';
	$data = ['ar_leads_status' => 1];
	$where = ['ar_leads_id' => ['=', (int)$buffer['ar_leads_id']]];
	$live = 1;
	$limit = 1;
	$show_debug = 1;

	update($table, $data, [], $where, $live, $limit, $show_debug);

	$msg = 'You are now subscribed.';
}
	
$email = $buffer['ar_leads_email'];	
$url = '/login-check-enrollee.php?id='.$SponsorID.'&login='.$email;

echo '<meta http-equiv="refresh" content="3; url='.$url.'">';	

include './header.php';
?>

<div class="clearfix">
</div>


<div class="col-md-12 col-xs-12" style="margin-bottom:10px; text-align:center">	
	<h2>Email Sign Up Confirmation</h2>
<h2><?php echo $msg; ?></h2>

<br/><br/>
<a href="/?id=<?php echo $SponsorID; if ($_GET['rd']!='') echo '&rd='.$_GET['rd']; ?>" class="btn btn-info btn-lg">Please explore our site</a>

<br/><br/>
<br/><br/><br/><br/>

</div>
<?php 
include './footer.php';