<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include 'cookie.php';
$pageName = 'pchange';
$pageClass = '';
include 'header.php';

$timestamp = date("Y-m-d H:i:s");
$ip = $_SERVER['REMOTE_ADDR'];
$conf = urldecode($_GET['confcode']);
echo '<p>&nbsp;</p>';
echo '<p>&nbsp;</p>';

echo '<div style="text-align:center"><br /><br /><span style="font-family:Verdana;">';
//echo '<br/>confcode unhashed: '.$conf;
$error = '';

if ($conf == '') {
	$error = 'Invalid Parameter - No Changes Made</span></div>';
}


$selectFields = '*';
$mainTable = 'members_change_log';
	$where = [
		'confirmed' => [
			['=', 'N']
		],
		'confcode' => [
			['=', $conf]
		]
	];
	
$limit = 1;
$show_debug = 1;	
$result = select($selectFields, $mainTable, [], $where, null, null, null, $limit, $show_debug);

if (!$result) {
	$error = 'Invalid Code or No Unconfirmed Changes Found - No Changes Made.';
} else {
		
	$live = 1;
	$limit = 1;
	$show_debug = 1;	
	
	// Loop through the results
	foreach ($result as $buffer) {
		$table = in_array(strtolower($buffer['tablename']), ['members', 'member_link']) ? $buffer['tablename'] : null;
		$fieldname = $buffer['fieldname'];
		$newvalue = $buffer['newvalue'];
		$idx = (int)$buffer['idx'];

		if ($table && $fieldname && $idx > 0) {
			$data = [$fieldname => $newvalue];
			$where = ['ID' => ['=', $buffer['ID']]];
			echo 'updating ' .$buffer['ID'];
			update($table, $data, [], $where, $live, $limit, $show_debug);
		}
	}
	
	$data = [
		'confirmed' => 'Y',
		'timestamp_confirmed' => $timestamp,  // Assuming $timestamp is set
		'ip_confirmed' => $ip  // Assuming $ip is set
	];
	$where = ['confcode' => ['=', $conf]];  // Assuming $conf is already sanitized
	$result = update('members_change_log', $data, [], $where, $live, $limit, $show_debug);
	
	
	if (empty($error) && $result['affected_rows'] > 0) {
		$success = 'Your profile has been updated.';
	} else { 
		$error = 'Your changes could not be confirmed.';
	}
}

// FOR DESIGN TESTING
//$success = 'Your profile has been updated.';
//$error = '';

if (!empty($error)) echo '<h3>'.$error.'</h3>';
if (!empty($success)) echo '<h2>'.$success.'</h2>';
?>
<p>&nbsp;</p>
<h4> You may <a href="login.php?rd=Members/profile.php">login</a> to review your profile. Thank you!<br/>
</h4>
<!--
Contact <a href="mailto:<?php echo $adminemail;?>?subject=<?php echo $sitename;?>_Website_Inquiry&body=My username is <?php echo $_GET['c'];?>"><?php echo $adminemail;?></a> if you wish to cancel your membership.
-->

<?php
echo '</span></div><p>&nbsp;</p>';
echo '<p>&nbsp;</p>';
echo '<p>&nbsp;</p>';
echo '<p>&nbsp;</p>';
echo '<p>&nbsp;</p>';
include 'footer.php';
?>