<?php 
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include 'cookie.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Contact Information</title>
<link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css" rel="stylesheet">
<style>
    .contact-info {
        font-family: Arial, Helvetica, sans-serif;
        color: #333333;
    }
    .contact-info a {
        color: #1474D8;
    }
    .contact-info a:hover {
        color: #ff0000;
    }
    .contact-img {
        max-width: 100%;
        height: auto;
    }
</style>
</head>
<body>

<div class="container">
  <div class="row">
    <div class="col-md-12">
      <h2 class="text-center contact-info">My Contact Info</h2>
      <p class="text-center contact-info">
        <?php echo htmlspecialchars("$Firstname $Lastname"); ?><br>
        <a href="mailto:<?php echo htmlspecialchars($Email); ?>?subject=<?php echo htmlspecialchars($Global['webpage_name']); ?> Inquiry"><?php echo htmlspecialchars($Email); ?></a><br>
        <?php echo htmlspecialchars($Phone); ?>
      </p>
      <hr>
      <?php include 'aboutme_info.php'; ?>
      <div class="row">
        <div class="col-md-4">
          <?php if (!empty($image_url)) { ?>
            <img src="<?php echo htmlspecialchars($image_url); ?>" alt="Profile Image" class="contact-img">
          <?php } ?>
        </div>
        <div class="col-md-8">
          <p><?php echo nl2br(htmlspecialchars(trim($about_text))); ?></p>
        </div>
      </div>
      <?php if (!empty($youtube)) { ?>
        <iframe width="560" height="315" src="<?php echo htmlspecialchars(trim($youtube)); ?>" frameborder="0" allowfullscreen></iframe>
      <?php } ?>
    </div>
  </div>
</div>

<script src="https://code.jquery.com/jquery-3.2.1.slim.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js"></script>
</body>
</html>
