<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
// THIS FILE SCRUBS INPUT - YOU MUST USE THIS FILE AT THE TOP OF ALL PUBLIC PAGES FOR SECURITY!
// DISCOVERED YOU CANNOT POST A VARIABLE CALLED 'ID' or 'REF' FROM OFFSITE!
if (session_status() == PHP_SESSION_NONE) {
	session_start();
}

$fileName = basename(__FILE__);

//echo 'Current PHP version : ' . phpversion();
//exit;

//$debug = false;
//$debug = true;
//if ($_SESSION['admin_login'] == true) $debug = true;

//include_once './Sub/Config.inc.php';
//include_once ''.$_SERVER['DOCUMENT_ROOT'].'/Sub/Config.inc.php';
//include_once ''.$_SERVER['DOCUMENT_ROOT'].'/Sub/Config.db_conn.php';

include ''.$_SERVER['DOCUMENT_ROOT'].'/Sub/Config.inc.php';
//$GLOBALS['debug'] = true;
//if (isset($_POST['login']) && $_POST['login'] == 'demo') $GLOBALS['debug'] = true;
include ''.$_SERVER['DOCUMENT_ROOT'].'/phpcpr.php';

if (isset($_GET['id']) && $_GET['id'] === 'NULL' && $_SERVER['REQUEST_METHOD'] != 'POST') {
	header("Location: https://{$_SERVER['HTTP_HOST']}{$_SERVER['PHP_SELF']}");
	//header("Location: https://{$GLOBALS['webpage_name']}{$_SERVER['PHP_SELF']}");
	exit;
}

/*if ($_SERVER['REQUEST_METHOD'] == 'POST') {
	echo 'SERVER METHOD IS POST<br>';
} else {	
	echo 'SERVER METHOD IS NOT POST<br>';
}*/

//$_SESSION['start_time'] = '';
if (!isset($_SESSION['start_time'])) {
	$_SESSION['start_time'] = date("Y-m-d H:i:s");
}

/**
 * Logs the login attempt
 * if it's successfull saves the member id and username
 *
 * @param bool $username		The username the user tried to login with
 * @param bool $success			Whether the login was successful
 * @param array $buffer			The info of the logged member if the login was a success
 */
function log_login($username, $success = false, $buffer = array()) {
	$ip = $_SERVER['REMOTE_ADDR'] ?? 'UNKNOWN'; // IP should always be set, but we still handle the case where it's not
    if ($ip !== 'UNKNOWN') $dns = gethostbyaddr($ip);
	else $dns = 'UNKNOWN'; 
    $user_agent = $_SERVER['HTTP_USER_AGENT'] ?? 'UNKNOWN';	
    $log_time = date('Y-m-d H:i:s');

    if ($success === true) {
        $member_id = isset($buffer['ID']) ? $buffer['ID'] : null; // Assuming $buffer['ID'] is already validated
        $login_success = 1;
    } else {
        $member_id = null;
        $login_success = 0;
    }

    // Prepare data for insertion
    $data = [
        'ID' => $member_id,
        'log_login_username' => $username, // Ensure $username is sanitized
        'log_ip' => $ip, // Assuming IP is safe
        'log_dns' => $dns, // Assuming DNS is safe
        'log_user_agent' => $user_agent, // Assuming user agent is safe
        'log_time' => $log_time,
        'log_login_success' => $login_success
    ];

    // Execute the insert using your PHPCPR's insert function
    insert('member_log', $data, 1, 1); // Assuming live mode and debugging are enabled
}

function generateRandomString() {
    if (version_compare(PHP_VERSION, '7.0.0') >= 0) {
        // For PHP 7.0 and above
        return bin2hex(random_bytes(32));
    } else {
        // For PHP 5.6 (as openssl_random_pseudo_bytes is available in PHP 5.3 and later)
        return bin2hex(openssl_random_pseudo_bytes(32));
    }
}

//$randomString = generateRandomString();
//echo $randomString;


// CSRF Token for forms
if (!isset($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = generateRandomString();
}
/* // ADD TO ALL FORMS    <input type="hidden" name="csrf_token" value="<?php (isset($_SESSION['csrf_token'])) echo htmlspecialchars($_SESSION['csrf_token'], ENT_QUOTES, 'UTF-8'); ?>"> */



// PREVENT XSS (Cross-Site Scripting) 
// AUTOMATICALLY Sanitize ALL OF $_GET and $_POST! & REMOVE ALL WHITE SPACES AROUND ANY INPUTS!
// password will be left alone!

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    foreach ($_POST as $key => $value) {
        $_POST[$key] = sanitize($value, $key);
    }
    $_POST = array_map('conditionalTrim', $_POST);
}

if (!empty($_GET)) {
    foreach ($_GET as $key => $value) {
        $_GET[$key] = sanitize($value, $key);
    }
    $_GET = array_map('conditionalTrim', $_GET);
}

// REMOVE ALL WHITE SPACES AROUND ANY INPUTS!
//$_POST = array_map(function($item) { return trim($item); }, $_POST);
//$_GET = array_map(function($item) { return trim($item); }, $_GET);


// Define rate limiting variables
$rateLimit = 50; // Number of requests allowed per minute
$timeFrame = 60; // Time frame in seconds

// Get the client IP address
$clientIP = $_SERVER['REMOTE_ADDR'];

// Load or initialize the rate limiting array
if (!isset($_SESSION['rate_limit'])) {
    $_SESSION['rate_limit'] = array();
}

// Check if the IP is already in the array
if (!isset($_SESSION['rate_limit'][$clientIP])) {
    $_SESSION['rate_limit'][$clientIP] = array('hits' => 1, 'timestamp' => time());
} else {
    // Check the time difference
    $timeDifference = time() - $_SESSION['rate_limit'][$clientIP]['timestamp'];

    // If within the time frame, increment the hits
    if ($timeDifference < $timeFrame) {
        $_SESSION['rate_limit'][$clientIP]['hits']++;
        
        // If the rate limit is reached, block the request
        if ($_SESSION['rate_limit'][$clientIP]['hits'] > $rateLimit) {
            header('HTTP/1.1 429 Too Many Requests');
            die('Rate limit exceeded. Please wait and try again later.');
        }
    } else {
        // Reset the hits and timestamp if outside the time frame
        $_SESSION['rate_limit'][$clientIP] = array('hits' => 1, 'timestamp' => time());
    }
}

// INI VARS!
if (!isset($valid_sponsor)) {
    $valid_sponsor = false;
}

if (!isset($default_user)) {
    $default_user = false;
}

if (!isset($_SESSION['user_is_member'])) {
    $_SESSION['user_is_member'] = false;
}



// Secure cookie options
$cookie_options = [
    'expires' => time() + 315360000, // 10 years
    'path' => '/',
    'secure' => true,
    'httponly' => true,
    'samesite' => 'Lax'
];

//$_POST['login'] = 'demo@phpcpr.com';

if (isset($_POST['login'])) { // ENTIRE COND TESTED - WORKS GREAT
	echo debug_stmt('Post login is set!', 1);
    //$login = filter_input(INPUT_POST, 'login', FILTER_SANITIZE_STRING);
	
	$login = $_POST['login'];
    // PHP CPR for database query

	$where = [
		'OR' => [
			['Username' => $login],
			['email' => $login],
			['bounced_email' => $login]
		]
	];

    $result = select(['*'], 'members', [], $where, null, null, null, 1, 1);
	
	//print_r($result);
	
	if (isset($buffer)) unset($buffer);
    //$buffer = $result[0] ?? null; // PHP 7.0 +
	$bufferLogin = isset($result[0]) ? $result[0] : null; // 5.6

    if (isset($bufferLogin['ID'])) { // WE HAVE A MATCH! SET LOGIN COOKIE!
		// Set the cookie with the login value (will be email or username) and expiration time for 10 years
        if (version_compare(PHP_VERSION, '7.3') >= 0) {
			// For PHP 7.0 and above
			setcookie('login', $login, $cookie_options);
		} else {
			// For PHP 5.6
			setcookie('login', $login, time() + 315360000, '/', '', true, true);
		}
		echo debug_stmt('set login cookie!', 1);
    }
}


if (isset($_COOKIE['id']) || isset($_GET['id']) || isset($_GET['lead']) || isset($_GET['user']) || isset($_POST['custom_username'])) {
	
	if (isset($_POST['custom_username'])) {
		// WILL HAVE COME FROM OFFSITE - WE GIVE TOP PRIORITY!
		// $_POST['custom_username'] = substr($_POST['custom_username'],3); // GET RID OF FIRST 3 CHARACTERS (id=) 
		// SENT OVER FROM CLICK FUNNELS
		// ABOVE ISSUE NOW FIXED, WE STRIP OUT id= WITH JS ON CLICK FUNNELS PAGE, BEFORE POSTING HERE
		$check_id = $_POST['custom_username'];	
		echo debug_stmt('check id is custom username', 1);
	} else if (isset($_GET['id']) && !empty($_GET['id'])) {
		$check_id = $_GET['id'];
		echo debug_stmt('check id is get id', 1);
	} else if (isset($_COOKIE['id'])) {
		$check_id = $_COOKIE['id'];
		echo debug_stmt('check id is from cookie', 1);
	}
	
	// IF THEY CAME HERE VIA AN ADCOOP, BUT HAVE EXISTING AFFILIATE COOKIE, CREDIT GOES TO THE AFFILIATE!
	if (isset($_GET['id']) && $_GET['id'] === 'adcoop' && isset($_COOKIE['id']) && $_COOKIE['id'] !== '' && $_COOKIE['id'] !== 'adcoop') {
		header("Location: https://" . $_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF'] . "?id=" . $_COOKIE['id']);
		exit;
	}
	
	
	if (!isset($user_is_member)) $user_is_member = false; // INITALIZE VARIABLE	
	if (isset($_GET['user']) && !empty($_GET['user'])) { //SEE IF USER IS A MEMBER FIRST!

		echo debug_stmt('Get user not empty', 1);
		// Using PHP CPR for selecting data from the database
		$selectFields = ['*'];
		$mainTable = 'members';
		$where = ['unsubscribe_id' => ['=', $_GET['user']]];
		$limit = 1;

		$result = select($selectFields, $mainTable, [], $where, null, null, null, $limit, 1);
		
		// Assuming the result is returned in a format similar to fetch_assoc
		if (!empty($result)) {
			
			//$buffer = $result[0] ?? null; // PHP 7.0 +
			$user = isset($result[0]) ? $result[0] : null; // 5.6			
			
			echo debug_stmt('User is a member: '.$user['Username'], 1);
			
			if (isset($user)) unset($user);
			$user = $result[0]; // Getting the first user from the result
			echo debug_stmt('Passing $user array:', 1);
			echo debug_stmt($user, 1);
			
			$check_id = $user['Username'];
			$_SESSION['user_is_member'] = true;
			if (isset($user['First_Name']) && !empty($user['First_Name'])) {
				$_SESSION['page_name'] = $user['First_Name'];
			}
			if (isset($user['Last_Name']) && !empty($user['Last_Name'])) {
				$_SESSION['page_lastname'] = $user['Last_Name'];
			}
			if (isset($user['email']) && !empty($user['email'])) {
				$_SESSION['page_email'] = $user['email'];
			}
			if (isset($user['cellphone']) && !empty($user['cellphone'])) {
				$_SESSION['page_phone'] = $user['cellphone'];
			}
		}
	}

	
	// MAKE SURE LEADS GET THEIR ORIGINAL SPONSOR - SEE IF USER IS A LEAD (IF THEY WERE NOT A MEMBER)
	if (isset($_GET['lead']) || (isset($_GET['user']) && !isset($user['QQQID']))) {
		
		if (!empty($_GET['user'])) {
			$md5_grab = $_GET['user'];
		} else if (!empty($_GET['lead'])) {
			$md5_grab = $_GET['lead'];
		}
		
		$selectFields = [
			'al.ar_leads_email',
			'al.ar_leads_firstname',
			'al.ar_leads_lastname',
			'al.ar_leads_phone',
			'al.country',
			'm.Username',
			'm.First_Name',
			'm.Last_Name',
			'm.email',
			'ml.phone'
		];
		
		$mainTable = ['table' => 'ar_leads', 'as' => 'al'];
		$joinConditions = [
			['table' => 'members', 'as' => 'm', 'condition' => 'm.ID = al.ID'],
			['table' => 'member_link', 'as' => 'ml', 'condition' => 'm.ID = ml.ID']			
		];		

		$where = ['al.ar_leads_md5' => ['=', $md5_grab]];
		$limit = 1;

		$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, $limit, 1);

		// Handling the result
		if (!empty($result)) {
			$lead = $result[0]; // Assuming the result is an array of rows
			$check_id = $lead['Username'];
			$_SESSION['page_name'] = $lead['ar_leads_firstname'];
			$_SESSION['page_lastname'] = $lead['ar_leads_lastname'];	
			$_SESSION['page_email'] = $lead['ar_leads_email'];
			$_SESSION['page_phone'] = $lead['ar_leads_phone'];	
		
			if ($debug == true) {
				echo 'Username: ' . $lead['Username'] . '<br>';
				echo 'First Name: ' . $lead['ar_leads_firstname'] . '<br>';
				echo 'Last Name: ' . $lead['ar_leads_lastname'] . '<br>';
				echo 'Email: ' . $lead['ar_leads_email'] . '<br>';
				echo 'Phone: ' . $lead['ar_leads_phone'] . '<br>';
			}
		}	
	} // END GET LEAD OR GET USER!
	if (isset($check_id) /*&& (!isset($SponsorID) || !isset($MemID) || !isset($Firstname))*/) {

		echo debug_stmt('check id isset, being checked now!', 1);	

		$selectFields = ['m.ID', 'm.Username', 'm.First_Name', 'm.Last_Name', 'm.display_name', 'm.email', 'm.cellphone_carrier', 'm.sms_alert', 'ml.phone', 'ml.country'];
		$mainTable = ['table' => 'members', 'as' => 'm'];
		$joinConditions = [
			['table' => 'member_link', 'as' => 'ml', 'condition' => 'm.ID = ml.ID']
		];
		$where = ['m.Username' => ['=', $check_id]];
		$limit = 1;

		$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, $limit, 1);
		$buffer = isset($result[0]) ? $result[0] : null;
		
				
		/* // SELECT ONE TABLE EXAMPLE
		$selectFields = ['ID', 'Username', 'First_Name', 'Last_Name', 'display_name'];
		$mainTable = 'members';
		$joinConditions = [''];
		$where = ['Username' => ['=', $check_id]];

		$result = select($selectFields, $mainTable, $joinConditions, $where);
		$buffer = isset($result[0]) ? $result[0] : null;*/
		
		//print_r($buffer);
		
		if (!empty($buffer['Username'])) {
			//echo 'GOT UNAME!';
			$valid_sponsor = true;
			$MemID = $buffer['ID'];
			$SponsorID = $buffer['Username'];
			$Firstname = $buffer['First_Name'];
			$Lastname = $buffer['Last_Name'];
			$Phone = $buffer['phone'];
			if (isset($Phone)) $Phone = preg_replace("/^(\d{3})(\d{3})(\d{4})$/", "$1-$2-$3", $Phone);
			$Email = $buffer['email'];
			$Display_name = $buffer['display_name'];
			
			if (isset($SponsorID)) {  
				// Set the cookie with the $SponsorID value (will be username) and expiration time for 10 years
				if (version_compare(PHP_VERSION, '7.3') >= 0) {
					setcookie('id', $SponsorID, $cookie_options);
				} else { // For PHP 5.6
					setcookie('id', $SponsorID, time() + 315360000, '/', '', true, true);
				}
				// NOTE - CANNOT PRINT ANY OUTPUT BEFORE SETTING COOKIE, OR IT WILL NOT WORK!
				echo debug_stmt('set id cookie: '.$SponsorID, 1);
			}
		}
	} else if ($valid_sponsor === false && $GLOBALS['refer_deny_null'] == false) {
		echo debug_stmt('NO VALID SPONSOR', 0);
		$MemID = 1;
		$SponsorID = $GLOBALS['refer_default_username'];
		$Firstname = $GLOBALS['refer_default_firstname'];
		$Lastname = $GLOBALS['refer_default_lastname'];
		$Phone = $GLOBALS['refer_default_phone'];
		$Email = $GLOBALS['refer_default_email'];
	} else {
		echo debug_stmt('NO VALID SPONSOR - AND NO DEFAULT SPONSOR!', 0);
	}
}	

if (isset($SponsorID)) $_SESSION['SponsorID'] = $SponsorID;
else $SponsorID = null;
if (isset($MemID)) $_SESSION['MemID'] = $MemID;
else $MemID = null;
//echo $MemID; exit;

// RETHINKING IF WE NEED ALL THESE AS SESSIONS
if(isset($Firstname)) $_SESSION['Firstname'] = $Firstname;
if(isset($Lastname)) $_SESSION['Lastname'] = $Lastname;
if(isset($Email)) $_SESSION['Email'] = $Email;
if(isset($Phone)) $_SESSION['Phone'] = preg_replace("/^(\d{3})(\d{3})(\d{4})$/", "$1-$2-$3", $Phone);
if(isset($buffer['cellphone_carrier'])) $_SESSION['cellphone_carrier'] = $buffer['cellphone_carrier'];
if(isset($buffer['sms_alert'])) $_SESSION['sms_alert'] = $buffer['sms_alert'];

if(isset($_SESSION['Firstname']) && (!isset($Firstname) || $Firstname == '')) $Firstname = $_SESSION['Firstname'];
if(isset($_SESSION['Lastname']) && (!isset($Lastname) || $Lastname == '')) $Lastname = $_SESSION['Lastname'];
if(isset($_SESSION['Email']) && (!isset($Email) || $Email == '')) $Email = $_SESSION['Email'];
if(isset($_SESSION['Phone']) && (!isset($Phone) || $Phone == '')) $Phone = $_SESSION['Phone'];
if(isset($_SESSION['cellphone_carrier']) && (!isset($buffer['cellphone_carrier']) || $buffer['cellphone_carrier'] == '')) $buffer['cellphone_carrier'] = $_SESSION['cellphone_carrier'];
if(isset($_SESSION['sms_alert']) && (!isset($buffer['sms_alert']) || $buffer['sms_alert'] == '')) $buffer['sms_alert'] = $_SESSION['sms_alert'];


if (isset($Display_name) && !empty($Display_name)) {
	$Firstname = '';
	$Lastname = $Display_name; // NOW THERE WILL BE NO SPACE BEFORE PERIOD.
}

//GET USER'S IP ADDRESS
$Global_userip = $_SERVER['HTTP_X_FORWARDED_FOR'] ?? $_SERVER['HTTP_CLIENT_IP'] ?? $_SERVER['REMOTE_ADDR'] ?? 'UNKNOWN';

if ($Global_userip !== 'UNKNOWN' && strpos($Global_userip, ',') !== false) {
	// If there's a comma in the IP address string, take the first value
	$ip_addresses = explode(',', $Global_userip);
	$Global_userip = trim($ip_addresses[0]);
}

// Proceed with IP validation and further processing as before
if (filter_var($Global_userip, FILTER_VALIDATE_IP)) {
	// The IP address is correctly formatted
	$Global_userip = sanitize($Global_userip);
	$Global_userdns = gethostbyaddr($Global_userip);
	$Global_userbrowser = $_SERVER['HTTP_USER_AGENT'] ?? 'UNKNOWN';
	$Global_userbrowser = sanitize($Global_userbrowser);
} else {
	// The IP address is not correctly formatted or is 'UNKNOWN'
	$Global_userip = 'Invalid IP';
	$Global_userdns = 'Invalid DNS';
	$Global_userbrowser = $_SERVER['HTTP_USER_AGENT'] ?? 'UNKNOWN';	
	// Assuming these variables are used later for display, they should be processed at that point:
	// echo htmlentities($Global_userdns);
	// echo htmlentities($Global_userbrowser);		
	echo 'Invalid IP';
	exit;
}

// QQQ BEGINNING OF BANNED IP LIST - ADD TO DB
// Array of banned IP addresses
$bannedIPs = [
    '91.199.147.63',
    '73.116.5.177',
    '36.57.145.235',
    '36.57.134.226',
    '59.57.182.168',
    '185.220.102.243',
    '185.220.103.9',
    // Adding new IPs to the list
    '45.86.86.251',
    '45.86.86.223',
    '213.232.235.91',
    '78.40.116.193',
    '176.123.1.195',
    '94.103.188.103',
    '45.86.86.242',
    '62.3.6.71',
];

// Check if the user's IP is in the banned list or the banned email is used
if (in_array($Global_userip, $bannedIPs) || (isset($_POST['email']) && $_POST['email'] == 'any.girl99@mail.ru')) {
	exit;
}


// FORCE HTTPS 8/7/19
/*$https = substr($GLOBALS['webpage_url_ssl'], 0, 5);
if ($_SERVER['HTTPS'] == "" && $https == 'https') {
	
	if ($_SERVER['QUERY_STRING'] != '') {
		$page_name = $_SERVER['PHP_SELF'].'?'.$_SERVER['QUERY_STRING'];
	} else {
		$page_name = $_SERVER['PHP_SELF'];
	}
	
	// GET RID OF STARTING SLASH "/" IN PAGE NAME, TO CREATE THE URL, SINCE WE ALREADY HAVE ONE.
	$page_name = substr($page_name, 1, 500);
	//echo $page_name;
	
	$https_page = $GLOBALS['webpage_url_ssl'].$page_name;
	//echo $https_page;	//exit;
	header("Location: {$https_page}");
	exit;
}*/


//if (isset($_GET['c'])) $_SESSION['short'] = htmlentities($_GET['c'], ENT_QUOTES, 'UTF-8'); // CAMPAIGN SHORT URL LINK
if (isset($_GET['c'])) $_SESSION['short'] = $_GET['c']; // CAMPAIGN SHORT URL LINK -- ALREADY SANITIZED AT TOP OF COOKIE!

if (!empty($debug) && $debug === true) {
	echo '<p>&nbsp;</p>	<p>&nbsp;</p>';
	echo 'COOKIE DEBUG SESSION ACTIVE<br/>';
	
	if ($_SERVER['REQUEST_METHOD'] == 'POST') {
		echo 'SERVER METHOD IS POST<br/>';
	} else {	
		echo 'SERVER METHOD IS NOT POST<br/>';
	}		
	echo 'r= ' . (isset($_GET['r']) ? $_GET['r'] : '') . '<br/>';
	echo 'C: ' . (isset($_SESSION['short']) ? $_SESSION['short'] : '') . '<br/>';
	echo 'sponsor username=' . (isset($SponsorID) ? $SponsorID : '') . '<br/>';
	echo 'POST: ';
	print_r($_POST);
	//exit;
}

/*
//$_SESSION['rd'] = 'join.php';
//session_destroy();
error_reporting(-1);
echo 'PRINT R SESSION: ';
echo '<pre>';
print_r($_SESSION);
echo '</pre>';

echo 'PRINT R GET: ';
echo '<pre>';
print_r($_GET);
echo '</pre>';

echo 'PRINT R REQUEST: ';
echo '<pre>';
print_r($_REQUEST);
echo '</pre>';

echo 'PRINT R POST: ';
echo '<pre>';
print_r($_POST);
echo '</pre>';

echo 'sitename: '.$GLOBALS['webpage_name'];
*/

// 12/14/23 - SET COUPON LINK TO GIVE USERS FREE ACTIVE STATUS IN P2!
$special_offer_pw = 'b4548206f3d4d171a6a9b851707'; // SET ALPHANUMERIC PASSWORD HERE (NO SPACES, NO SPECIAL CHARS)!
if (!empty($_GET['special_offer']) && $_GET['special_offer'] == $special_offer_pw) {
	$_SESSION['join_active'] = true;
}

if ($GLOBALS['refer_deny_null'] === true && $SponsorID == 'admin') {	
	header("Location: https://{$_SERVER['HTTP_HOST']}/error-no-sponsor.php");
	exit;
}

// COMMENT WHEN TESTING IS DONE!!!
//$_SESSION['dev'] = '';
// LOCKING PAGE FOR DEVELOPER USE ONLY!!
/*if (($Global_userip != '98.2.226.193') && (!isset($_GET['dev']) || $_GET['dev'] == '') && (!isset($_SESSION['dev']) || $_SESSION['dev'] === false)) { 
	//include_once './header.php';
	echo 'Coming soon!';
	//include_once './footer.php';
	exit;
} else if (isset($_GET['dev']) && $_GET['dev'] == '0') { 	
	if (isset($_SESSION['dev'])) $_SESSION['dev'] = false;
} else {
	$_SESSION['dev'] = true;
}*/
?>