<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
// THIS FILE GETS INCLUDED IN HEADER.PHP, AND THE HEAD SECTION OF ALL LEAD CAP PAGES

$image_path = $GLOBALS['path'].'images/Users/'.floor(($MemID / 1000)).'/'.$MemID.'.jpg';
		
if (file_exists($image_path)) {
	$image_url = $GLOBALS['webpage_url_ssl'].'images/Users/'.floor(($MemID / 1000)).'/'.$MemID.'.jpg';
}

// THIS FILE GETS FACEBOOK AND GOOGLE RETARGETING PIXEL CODES FROM THE DB, AS WELL AS SOCIAL LINKS 
//echo 'MemID: '.$MemID;
$MemID = sanitize($MemID, 'MemID');

//echo 'MemID: '.$MemID; exit;

$selectFields = 'facebookurl, twitterurl, youtubeurl, instagramurl, fb_pixel, google_pixel';
$mainTable = 'members';
$where = ['ID' => ['=', $MemID]]; // The where condition for the first query

// Execute the first query
$result_social = select($selectFields, $mainTable, [], $where, null, null, null, 1, 1);
$buffer_social = isset($result_social[0]) ? $result_social[0] : null;

//print_r($buffer_social);
//exit;

// The where condition for the admin query
$where_admin = ['ID' => ['=', 1]]; // Admin ID is assumed to be 1

// Execute the second query for admin
$result_social_admin = select($selectFields, $mainTable, [], $where_admin, null, null, null, 1, 1);
$buffer_social_admin = isset($result_social_admin[0]) ? $result_social_admin[0] : null;

//print_r($buffer_social_admin);
//exit;

// Now $buffer_social and $buffer_social_admin have the fetched data


/* // DEFINE DEFAULT ADMIN SOCIAL URLS, IF DESIRED // ADMIN SCOOPS UP UNUSED SOCIAL ICONS
$facebook = 'https://www.facebook.com/' . $buffer_social_admin['facebookurl'];
$twitter = 'https://twitter.com/' . $buffer_social_admin['twitterurl'];
$youtube = 'https://www.youtube.com/' . $buffer_social_admin['youtubeurl'];
*/
// IF REF SPONSOR HAS SOCIAL LINKS, THEY WILL OVERWRITE ADMIN'S (IF SET ABOVE)
if (isset($buffer_social['facebookurl'])) $facebook = 'https://www.facebook.com/' . $buffer_social['facebookurl'];
if (isset($buffer_social['twitterurl'])) $twitter = 'https://twitter.com/' . $buffer_social['twitterurl'];
if (isset($buffer_social['youtubeurl'])) $youtube = 'https://www.youtube.com/' . $buffer_social['youtubeurl'];
if (isset($buffer_social['instagramurl'])) $instagram = 'https://www.instagram.com/' . $buffer_social['instagramurl'];
?>

<!-- FACEBOOK PIXEL CODE -->
<?php
if (isset($buffer_social['fb_pixel'])) $fb = $buffer_social['fb_pixel'];
else if (isset($buffer_social_admin['fb_pixel'])) $fb = $buffer_social_admin['fb_pixel']; // ADMIN SCOOPS UP UNUSED RETARGETING SPACE!
if (isset($fb)) {
?>
<script>
!function(f,b,e,v,n,t,s){if(f.fbq)return;n=f.fbq=function(){n.callMethod?
n.callMethod.apply(n,arguments):n.queue.push(arguments)};if(!f._fbq)f._fbq=n;
n.push=n;n.loaded=!0;n.version='2.0';n.queue=[];t=b.createElement(e);t.async=!0;
t.src=v;s=b.getElementsByTagName(e)[0];s.parentNode.insertBefore(t,s)}(window,
document,'script','https://connect.facebook.net/en_US/fbevents.js');
fbq('init', '<?php echo $fb; ?>'); // Insert your pixel ID here.
fbq('track', 'PageView');
</script>
<noscript><img height="1" width="1" style="display:none"
src="https://www.facebook.com/tr?id=<?php echo $fb; ?>&ev=PageView&noscript=1"
/></noscript>
<!-- DO NOT MODIFY -->
<?php } ?>
<!-- END FACEBOOK PIXEL CODE -->

<!-- GOOGLE REMARKETING TAGS -->
<?php // LATEST GOOGLE REMARKETING TAG - OCT 2018
if (isset($buffer_social['google_pixel'])) $gp = $buffer_social['google_pixel'];
else if (isset($buffer_social_admin['google_pixel'])) $gp = $buffer_social_admin['google_pixel']; // ADMIN SCOOPS UP UNUSED RETARGETING SPACE!
	//$gp = '987223604'; // SPM JFS GOOGLE PIXEL CODE
if (isset($gp)) { ?>	
	<!-- Global site tag (gtag.js) - AdWords: -->
	<script async src="https://www.googletagmanager.com/gtag/js?id=AW-<?php echo $gp; ?>"></script>
	<script>
	  window.dataLayer = window.dataLayer || [];
	  function gtag(){dataLayer.push(arguments);}
	  gtag('js', new Date());

	  gtag('config', 'AW-<?php echo $gp; ?>');
	</script>
	<script>
	  gtag('event', 'page_view', {
		'send_to': 'AW-<?php echo $gp; ?>',
		'user_id': '<?php echo $Global_userip; ?>'
	  });
	</script>
<?php }
?>
<!-- END GOOGLE REMARKETING TAGS -->