<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include 'cookie.php';
include './maintenance.inc.php'; // THIS FILE WILL LOCK THIS PAGE, WHEN SITE IS PLACED IN MAINTENANCE MODE (FROM ADMIN PANEL)
$current_page_name = basename($_SERVER['PHP_SELF']);
$current_page_name = str_replace(".php", "", $current_page_name);
$pageName = htmlspecialchars($current_page_name, ENT_QUOTES, 'UTF-8'); // 'lc', 'lc2', etc.. this new method now does not need updating for each new file.
$_SESSION['pageName'] = $pageName;
$pageClass = 'leadcap';
$page_id = 1; // SET UNIQUE PAGE ID FOR EACH LEAD CAP PAGE, NUMBERS ONLY!
//$survey_name = 'survey1';
$ar_list = 1;

$joinuser = true; // MAKE LEAD A MEMBER

// CREATE SIMPLE RANDOM CAPTCHA NUMBERS
if (!isset($_SESSION['captcha'])) {
	$_SESSION['captcha'] = rand(111,999);
	if ($_SESSION['captcha'] == 665 + 1) $_SESSION['captcha'] = 777;
	$captcha_password = $_SESSION['captcha'];
} else {
	$captcha_password = $_SESSION['captcha'];
}
$error_captcha = false; // INI VAR


if (!isset($_POST['firstname'])) {
    $_POST['firstname'] = '';
}

if (!isset($_POST['lastname'])) {
    $_POST['lastname'] = '';
}

if (!isset($_POST['email'])) {
    $_POST['email'] = '';
}

if (!isset($_POST['phone'])) {
    $_POST['phone'] = '';
}


if (isset($_GET['dev']) && $_GET['dev'] == '' && $_SESSION['dev'] == '') { // LOCKING PAGE FOR DEVELOPER USE ONLY!!
	/*
	include_once './header.php';
	echo 'We\'re sorry. This area is temporarily down for maintenance. Please check back soon!';
	include_once './footer.php';
	exit;
	*/
} else {
	//$debug = true;
}
//$debug = false;
//if ($SponsorID == 'test') $debug = true;

if (isset($_GET['fill_form']) && $_GET['fill_form'] == 'Y') {
/* // FOR TESTING ONLY!!
	$_SESSION['page_name'] = 'Tom';
	$_SESSION['page_lastname'] = 'Hill';	
	$_SESSION['page_email'] = 'thill@gmail.com';
	$_SESSION['page_phone'] = '555-555-1212';
*/
	if (!isset($_POST['firstname']) || $_POST['firstname'] == '') {
		$_POST['firstname'] = isset($_SESSION['page_name']) ? $_SESSION['page_name'] : '';
	}

	if (!isset($_POST['lastname']) || $_POST['lastname'] == '') {
		$_POST['lastname'] = isset($_SESSION['page_lastname']) ? $_SESSION['page_lastname'] : '';
	}
	
	if (!isset($_POST['email']) || $_POST['email'] == '') {
		$_POST['email'] = isset($_SESSION['page_email']) ? $_SESSION['page_email'] : '';
	}

	if (!isset($_POST['phone']) || $_POST['phone'] == '') {
		$_POST['phone'] = isset($_SESSION['page_phone']) ? $_SESSION['page_phone'] : '';
	}
}


if (isset($_POST["custom_username"]) && $_POST["custom_username"] != '') $SponsorID = $_POST["custom_username"];

if ($_SERVER['REQUEST_METHOD'] == 'POST' && !empty($debug) && $debug === true) {
    echo '<p>&nbsp;</p><p>&nbsp;</p>';
    echo 'DEBUG SESSION ACTIVE<br/>';
    echo 'r= ' . (isset($_GET['r']) ? $_GET['r'] : 'not set') . '<br/>';  
    
    echo 'firstname=' . (isset($_POST['firstname']) ? $_POST['firstname'] : 'not set') . '<br/>';
    echo 'email=' . (isset($_POST['email']) ? $_POST['email'] : 'not set') . '<br/>';
    echo 'page_id=' . (isset($_POST['page_id']) ? $_POST['page_id'] : 'not set') . '<br/>';
    echo 'redirect=' . (isset($_POST['redirect']) ? $_POST['redirect'] : 'not set') . '<br/>';
    
    echo 'ref_username=' . (isset($_POST['ref_username']) ? $_POST['ref_username'] : 'not set') . '<br/>';
    echo 'custom_username=' . (isset($_POST['custom_username']) ? $_POST['custom_username'] : 'not set') . '<br/>';  
    
    echo 'username=' . (isset($SponsorID) ? $SponsorID : 'not set') . '<br/>';  
    echo 'POST: ';
    print_r($_POST);
    exit;
}
$use_logo = false;
$brand = $GLOBALS['webpage_name'];

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_SESSION['ar_post']) && $_SESSION['ar_post'] != '' && $_SESSION['ar_post'] >= 1 && isset($_SESSION['page_email']) && $_SESSION['page_email'] == $_POST['email']) {
	// DO NOTHING
	if ($_POST['redirect'] != '') { // WORKS FINE, BUT SHOWS REDIRECT LINK IN THE SOURCE CODE. BETTER TO HIDE IT.
		//$url = htmlspecialchars($_POST['redirect'], ENT_QUOTES, 'UTF-8');
		//echo '<meta http-equiv="refresh" content="0; url='.$url.'">';
	}
} else {
	//include 'subscribe.setup.inc.php'; 
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
	
	$check_email = $_POST['email'];
	
	//$check_email = 'jim@directsalesmlm.com';

	// SECURE LOGIN FROM XSS ATTACKS!
	if (!isset($_POST['csrf_token']) || !isset($_SESSION['csrf_token']) || (isset($_POST['csrf_token']) && $_POST['csrf_token'] !== $_SESSION['csrf_token'])) {
		// Token not set in either POST or SESSION, or Token mismatch, 
		// redirect to the same page within the same domain with proper sanitization to prevent XSS
		$currentPage = htmlentities($_SERVER['PHP_SELF'], ENT_QUOTES, 'UTF-8');
		$queryString = !empty($_SERVER['QUERY_STRING']) ? '?' . http_build_query($_GET) : '';
		
		// Ensure the redirect is to a path on the current domain
		$redirectUrl = '/' . ltrim($currentPage, '/') . $queryString;
		
		header('Location: ' . $redirectUrl);
		exit;
	}
	
	/*if (isset($buffer)) unset($buffer);
	
	// CHECK IF EMAIL EXISTS - IF YES, SKIP IT AND REDIRECT!
	$where = [
		'OR' => [
			['Username' => $check_email],
			['email' => $check_email],
			['bounced_email' => $check_email]
		]
	];
	
	//select($selectFields, $mainTable, $joinConditions = [], $where = [], $groupBy = null, $having = null, $orderBy = null, $limit = 0, $show_debug = 0)
    $result = select(['email'], 'members', [], $where, null, null, null, 1, 1);	
	$buffer = isset($result[0]) ? $result[0] : null;
	
	//echo 'see 3 way email called!<br>';
	//print_r($buffer);
	//exit;

	if ($buffer['email'] != '') {
		// THEY ARE IN ALREADY A MEMBER - SKIP THEM!
		$url = 'index.php';
		echo '<meta http-equiv="refresh" content="0; url='.$url.'">';
		exit;
	}*/
	
	if ($_POST['email'] != '' && (trim($_POST['captcha']) != $captcha_password)) {
		$error_captcha = true;
     	$error_msg = 'Please enter the Captcha number: '.$captcha_password.' to pass the human test.';
		$error_msg_headline = '<h2 style="color:red">ERROR! Please scroll down and enter the Captcha number: '.$captcha_password.' and re-submit the form.</h2>';
	} else {	
		include 'subscribe.setup.inc.php';
	}	
}	

//https://developers.facebook.com/tools/debug/ - USE TO SEE AND WIPE FB CACHE FOR PAGE DATA
/*Open Graph (OG) meta tags are snippets of code that control how URLs are displayed when shared on social media. The "og:image" tag controls the image that's included when your URL is shared.

Facebook recommends the following for the "og:image" property:

Size: The optimal resolution for the og:image is 1200 x 630 pixels. This resolution will help your image to appear in the highest quality on all devices.

Aspect Ratio: Images should have an aspect ratio of 1.91:1.

File Type: The image must be a .jpg or .png file.

Use Multiple Images: If you want to specify multiple images, you can use multiple "og:image" tags.

Avoid Text in Image: Try to avoid including text in the image, as it can be cropped or not clearly visible on all devices.*/

$headline = $Global['webpage_name_short'];
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html lang="en">
<head>
<meta content="AutomaticWebSoftware.com" name="GENERATOR">
<meta content="PHP" name="CODE_LANGUAGE">
<meta name="author" content="Jim Symonds, AutomaticWebSoftware.com">
<link rel="shortcut icon" href="<?php echo $Global['webpage_url_ssl'];?>images/logo9.png">
<title><?php echo $Global['webpage_name']; ?></title>
<meta name="description" content="">
<meta name="keywords" content="">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<!-- -->
<script type="text/javascript" src="//ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.js"></script>

<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1">

  <meta property="og:locale" content="en_US" />	

  <meta property="og:type" content="website" />
  
  <meta property="og:title" content="<?php echo $headline; ?>">
  
<?php $og_desc = ''; 
$thumbnail_img = 'images/logo.png';
?> 

  <meta property="og:description" content="<?php echo $og_desc; ?>">
  <meta property="og:image" content="<?php echo $Global['webpage_url'].$thumbnail_img; ?>">
	<meta property="og:image:width" content="200" />
  <meta property="og:image:height" content="200" />
  <meta property="og:image:secure_url" content="<?php echo $Global['webpage_url'].$thumbnail_img; ?>">
  <meta property="og:url" content="<?php echo $Global['webpage_url'].'lc.php?id='.$SponsorID; ?>">  
  <meta property="og:site_name" content="<?php echo $Global['webpage_name_short']; ?>">

  
  <link rel="image_src" href="<?php echo $Global['webpage_url'].$thumbnail_img; ?>">

<!-- BELOW IS LAST WORKING IN FB AND EMAIL!-->
	<link rel="canonical" href="<?php echo $Global['webpage_url'].'lc.php?id='.$SponsorID; ?>">


	<link rel="stylesheet" href="//maxcdn.bootstrapcdn.com/bootstrap/3.3.5/css/bootstrap.min.css" type="text/css">	

	<!-- Font Awesome CSS 3.1 NEEDED FOR icon-wallet, not supported in 4.7!!! -->
	<!--
	<link href="https://maxcdn.bootstrapcdn.com/font-awesome/3.2.1/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
	-->
    <link href="//maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
    	
	<link href="Members/css/form.css" rel="stylesheet" type="text/css" />
    <style>
  h1 {
  font-family: "Georgia", Verdana, sans-serif;
  font-size: 50px;
  color: #fff;
  text-shadow: -3px 0 4px #006;
  }


.modal-backdrop {
    z-index: 2;
}  
</style>

    <style type="text/css">
	<!--
    .OverLay { position: absolute; z-index: -1; opacity: 0.35; filter: alpha(opacity = 75); top: 0; bottom: 0; left: 0; right: 0; width: 100%; height: 100%; background-color: Black; color: White;}
	-->
body, html {
    height: 100%;
    margin: 0;
}

.bg {
    /* The image used */
   background-image: url("images/tropical.jpg");
	/* background-color: #fff; */

    /* Full height */
    height: 100%; 

    /* Center and scale the image nicely */
    background-position: center;
    background-repeat: repeat;
    background-size: cover;
}
/* unvisited link */
a:link {
  color: #fff;
}

/* visited link */
a:visited {
  color: #fff;
}

/* mouse over link */
a:hover {
  color: #fff;
}

/* selected link */
a:active {
  color: #fff;
}
</style>	
	
<?php include 'header.inc.php'; ?>

		<!-- NEXT 2 INCLUDES ARE FOR ANIMATED WOW EFFECTS -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.7.0/animate.min.css" rel="stylesheet">
	<script src="https://cdnjs.cloudflare.com/ajax/libs/wow/1.1.2/wow.min.js"></script>			
	
	
<script>
new WOW().init(); 
</script>

<style>
html {
  height:100%;
}

body {
  margin:0;
}

.bg {
  animation:slide 9s ease-in-out infinite alternate;
  background-image: linear-gradient(-60deg, #6c3 50%, #09f 50%);
    background-image: url("images/100-bills-bg3.jpg");  
  bottom:0;
  left:-50%;
  opacity:.5;
  position:fixed;
  right:-50%;
  top:0;
  z-index:-1;
}

.bg2 {
  animation-direction:alternate-reverse;
  animation-duration:20s;
}

.bg3 {
  animation-duration:21s;
}

.QQQcontent {
  background-color:rgba(255,255,255,.8);
  border-radius:.25em;
  box-shadow:0 0 .25em rgba(0,0,0,.25);
  box-sizing:border-box;
  left:50%;
  padding:10vmin;
  position:fixed;
  text-align:center;
  top:50%;
  transform:translate(-25%, -25%);
}


/*@keyframes slide {
  0% {
    transform:translateX(-25%);
  }
  100% {
    transform:translateX(25%);
  }
}*/   

@keyframes slide {
  0% {
    transform:translateX(-15%);
  }
  25% {
    transform:translateX(15%);
  }
} 
</style>

</head>

<!--
<body style="background: url('images/QQQ.png') no-repeat center center fixed; background-color: #000;">
-->

<body class="QQQbg">



<body style="background: url('images/tropical.jpg') no-repeat center fixed; background-color: #fff; background-position: 0px 0px;">

<!--
<div class="OverLay">
</div>
-->
<!--
<div class="bg">
</div>
-->

<?php /*
CLASSES
class="wow fadeIn quick"
class="wow fadeInRight quick"
class="wow fadeInLeft quick"
class="wow fadeIn one"
*/?>

<!-- MONEY ANIMATIONS!
<div class="bg"></div>
<div class="bg bg2"></div>
<div class="bg QQQbg3"></div>
-->

<div class="container" style="position:relative; z-index: 900; ">
    <div class="row">
	
	    	<div class="col-xs-12" style="float:left;">
			<p>&nbsp;</p>
	      
			<h4 class="wow fadeInRight quick" style="text-align:left; color:#fff">
			<!--<img src="images/logo.png">-->
			<!--<b><span style="color:#ffffff;"><i class="fa fa-cubes"></i></span>
			<a href="/?id=admin" style="color:#eeeeee"><?php echo $Global['webpage_name_short']; ?></a>
			</b>-->
			</h4>
	</div>
<div id="landing" class="col-md-8 col-xs-12 collapse in" style="margin-top:-30px; float:left; min-height:20px">
<!--
<h2>
Earn $250 Per Sale Selling Premium Ad Space<br>for Text & Banner Ads!
</h2>
-->
<p>&nbsp;</p><!--<p>&nbsp;</p>-->
<div>

<div class="embed-responsive embed-responsive-16by9">
<!--
<iframe src="https://player.vimeo.com/video/ width="640" height="360" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" allowfullscreen></iframe>
-->
		<iframe width="560" height="315" style="margin-top:0px" src="https://www.youtube.com/embed/&rel=0" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; web-share" allowfullscreen></iframe>
</div>	
<!--
<iframe class="wow fadeInLeft" width="560" height="315" src="https://www.youtube.com/embed/f5k9B61cZoc?si=fAj_zlV_QM0YsN9P" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>
-->
<!--			
<h1 class="wow fadeInRight" style="text-align:center; color:#fff">
Time Freedom is possible, when you put the right systems to work on your behalf.
</h1>

<h2 class="wow fadeInLeft" style="text-align:center; color:#fff">50% Complete! <i class="fa fa-arrow-right"></i>&nbsp;<i class="fa fa-arrow-right"></i>&nbsp;&nbsp;<button class="btn btn-lg btn-warning" data-toggle="collapse" data-target="#signup">Show Me NOW!</button></h2>

<div class="progress progress-striped active wow fadeInLeft">
<div class="progress-bar progress-bar-success" role="progressbar" aria-valuenow="50" aria-valuemin="0" aria-valuemax="100" style="width: 50%">
</div>
</div>

<h2 class="wow fadeInRight" style="text-align:center; color:#fff">See how our Automated System can finally let you set your own hours, and earn weekly from anywhere.
</h2>
-->										

</div></div>

<!--
<div id="video" class="col-md-8 col-xs-12 collapse" style="background-color: #; margin-top:0px; float:left; min-height:20px">
	
	<h2 class="wow fadeInLeft" style="background-color: #d31927; text-align:center; color:#fff">
    HEADLINE
</h2>

	<div class="embed-responsive embed-responsive-16by9">
<iframe width="560" height="315" src="https://player.vimeo.com/video/?autoplay=0" title="Leads Are Cash" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>	  
	  
            </div>

</div>
-->
<p>&nbsp;</p>
<!-- NEW FORMAT - BELOW WAS HIIDEN WITH collapse IN END OF CLASS -->
    	<div id="signup" class="col-md-4 col-xs-12" style="background-color: #; margin-top:0px; float:right; filter:alpha(opacity=50); opacity:.9;">

<!--	<h4 class="wow fadeInLeft" style="text-align:center; color:#fff">
    &nbsp;
</h4>
	-->	
    		<div class="panel panel-default transparent" style="background-color: rgba(0,0,0,0);"> 		
			  	<div class="panel-heading" style="background-color:steelblue;">
					
		    	  <h3 class="panel-title" style="line-height:30px; color:#FFFFF;">
				  <div  class="wow fadeInLeft" style="text-align:center;  padding-top:10px;  padding-bottom:5px; font-size:21px; color:#FCB442;  font-family: Arial">
				  <div style="display:inline-block; color:#FFFFFF;"><div style="text-align:center; word-spacing:5px; color:#fff">
				  ONE STEP TO GO...
				</div></div>
				</div>
		    	  <!--<div  style="line-height:30px; color:#FFFFFF; font-family: Graphik-Light;"></strong>Fill out the form below:</div>-->
				  </h3>
			 	</div>
			  	<div class="panel-body" style="background-color: #ffffff;">
					
					<?php if (!empty($error)) { ?>
					<div style="text-align:center; color:red;"><?php echo $error; ?><br />&nbsp;</div>
					<?php } ?>
								
				<form method="post" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>?r=<?php echo $ar_list; ?>&id=<?php echo $SponsorID;?>" id="mainForm" target="_parent">
				
				<input type="hidden" name="csrf_token" value="<?php if (isset($_SESSION['csrf_token'])) echo htmlspecialchars($_SESSION['csrf_token'], ENT_QUOTES, 'UTF-8'); ?>">				
                
                    <fieldset>
			    	  	<div class="wow fadeInRight one form-group">
							<div class="left-inner-icon ">
    						<i class="fa fa-user"></i>
    						<input type="text" class="form-control" name="firstname" value="<?php echo (!empty($_POST['firstname']) ? $_POST['firstname']:''); ?>" placeholder="Enter Your FIRST NAME*" onblur="this.value = this.value.substr(0, 1).toUpperCase() + this.value.substr(1);" maxlength="50" required>
                        </div>
                        </div>						
						<div class="wow fadeInLeft two form-group">
							<div class="left-inner-icon ">
    						<i class="fa fa-user"></i>
    						<input type="text"  class="form-control" name="lastname" value="<?php echo (!empty($_POST['lastname']) ? $_POST['lastname']:''); ?>" placeholder="Enter Your LAST NAME" onblur="this.value = this.value.substr(0, 1).toUpperCase() + this.value.substr(1);" maxlength="50" required>
                        </div>						
			    		</div>
			
						<div class="wow fadeInRight one form-group">
							<div class="left-inner-icon ">
    						<i class="fa fa-envelope"></i>
    						<input type="email" class="form-control transparent" name="email" value="<?php echo (!empty($_POST['email']) ? $_POST['email']:''); ?>" placeholder="Enter Your EMAIL*" maxlength="150" required>
							</div>
			    		</div>
                        <div class="wow fadeInLeft two form-group">
							<div class="left-inner-icon ">
    						<i class="fa fa-phone"></i>
    						<input type="phone" class="form-control" name="phone" value="<?php echo (!empty($_POST['phone']) ? $_POST['phone']:''); ?>" placeholder="Enter Your MOBILE PHONE*" maxlength="20" required>
							</div>
			    		</div>
						
                        <div class="wow fadeInLeft two form-group">
<span id="error_captcha" style="color:red; background-color:yellow; font-weight:bold">

<?php if ($error_captcha == true) echo $error_msg; ?>

</span>							
							<div class="left-inner-icon ">
    						<i class="fa fa-lock"></i>
							<input type="text" name="captcha" id="captcha" class="form-control" placeholder="Enter Captcha Code: <?php echo $captcha_password; ?>" value="<?php if (!empty($_POST['captcha'])) echo htmlspecialchars($_POST['captcha'], ENT_QUOTES, 'UTF-8'); ?>" maxlength="10" required>							
							
							
							</div>
			    		</div>						

			    		</div>
			    		<!--<input class="btn btn-lg btn-success btn-block" type="submit" value="Show Me the System">-->
                      <div class="panel-body" style="background-color: #ffffff;">
					  <div class="wow fadeInRight three" style="text-align:center" style="background-color: #ffffff;">
					  <!--<div class="btn btn-lg btn-warning" style="background-color: #;">
					 <sub><sub> <i class="fa fa-youtube-play" style="font-size:40px;color:white"></i></sub></sub>
					  <input class="btn btn-lg btn-warning" style="background-color:red" type="submit" value="Yes, Show Me Now!" onMouseDown="sendForm()">
					  </div>-->
					  
					  <button type="submit" class="btn btn-lg btn-warning" style="font-size:20px;color:white;">
					  <i class="fa fa-youtube-play" style="font-size:40px;color:white;"></i><sup>&nbsp;
					  Yes, <span style="font-size:20px;color:white; text-decoration: underline; text-decoration-color: yellow;">Show Me Now</span></sup>
					  </button>					  
					  
					  
					  <!--
					  <input type="image" name="image" src="images/QQQ.png" class="img-responsive"  alt="" onMouseDown="sendForm()"/></div>
                    -->
					<!-- -->
					<input type="hidden" name="redirect" value="index.php?id=<?php echo $SponsorID; ?>">
					
					</fieldset>
					
                    </form>
                    <br>
					<small><i class="fa fa-lock"></i> Your info is safe and will never be shared with anyone.</small>
                    
		      </div>
                </div>
            </div>
        </div>
			</div>
	<p>&nbsp;</p>
	</div>
	
<?php if ($valid_sponsor != false && !empty($SponsorID) && $SponsorID != 'admin' && $SponsorID != 'NULL' && $pageClass != 'remove' && $pageName != 'contact') { ?>
<div class="wow fadeIn two"style="text-align:center; color:#fff">
 You were referred by: <?php echo $Firstname." ".$Lastname; ?>.&nbsp;
 <!--
<?php if (!empty($Email)) { ?>Questions? Email <?php echo $Firstname; ?> at: <a href="mailto:<?php echo $Email; ?>?subject=Interested_in_<?php echo $Global['webpage_name'];?>&body=<?php echo $Global['webpage_url'];?>?id=<?php echo $SponsorID; ?>"><?php echo $Email; } ?></a>
<?php if (!empty($Phone)) { ?> or call <?php echo $Firstname; ?> at: <a href="tel:+1-<?php echo $Phone; ?>"><?php echo $Phone; } ?></a>
-->
</div>
<?php }  
?> 	

<?php 
$is_include = true;
include './privacy.php'; 
include './terms.php';
?>


	
	<div class="wow fadeIn two" style="text-align:center; color:#eee"> 
	Copyright &copy; <?php echo date('Y');?>, <?php echo $Global['webpage_name']; ?>. All Rights Reserved. 
	
	<a href="#" data-toggle="modal" data-target="#privacy" style="color:#eee;">Privacy</a> 
	
	<!--
	<a href="#" data-toggle="modal" data-target="#disclaimer" style="color:#1f2e2e;">Disclaimer</a> -->
	<a href="#" data-toggle="modal" data-target="#terms" style="color:#eee;">Terms</a>

    </div>
	
	

<a name="signup_tag"></a>

<script src="//netdna.bootstrapcdn.com/bootstrap/3.0.0/js/bootstrap.min.js"></script>

<?php
 
if ($_SERVER['REQUEST_METHOD'] != 'POST') { ?>
<!--		
<script>		
		$(document).ready(function(){
			$.post("visits.php", //Required URL of the page on server
			{ // Data Sending With Request To Server
			page: "1",
			sponsor: '<?php echo $SponsorID; ?>'
			});
			return false;
		});

</script>
-->
<?php 
if (true || $SponsorID == 'test') {
	include 'popup.members.inc.php';	
}
}
?>		

</body>
</html>