<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './cookie.php';
include 'admin/admin_ip_checker.inc.php';
unset($buffer);
$pageClass = 'remove';
$admin_override = false;
//error_reporting(-1);

//echo 'got here';
if ($admin_ip == true) { // ADMIN'S IP!
	// ADMIN IS UNSUBBING AN UNDELIVERABLE - DON'T FORCE CONFIRMATIONS!
	$admin_override = true;
	//echo 'ADMIN ORIDE IS TRUE!';
}

if (isset($_GET['fix'])) {
	$id = $_GET['fix'];
} else {
	$id = htmlspecialchars($_REQUEST['id'], ENT_QUOTES, 'UTF-8');
}	

if ((!empty($_REQUEST['id']) || !empty($_REQUEST['fix'])) && (isset($_GET['confirming']) && $_GET['confirming'] != 'yes' || $admin_override == true)) {
    $id = sanitize($_REQUEST['id']);
    $selectFields = ['ID', 'Username', 'First_Name', 'Last_Name', 'email', 'ip', 'sponsorid', 'UNIX_TIMESTAMP(Signdate) as time', 'unsubscribe_id2', 'Status'];
    $mainTable = 'members';
    $where = ['unsubscribe_id' => ['=', $id]];

    $result = select($selectFields, $mainTable, [], $where, null, null, null, 1, 1);
    //echo 'got 1 ';
} else if (isset($_GET['confirming']) && $_GET['confirming'] == 'yes' || isset($_POST['unsub'])) {
    if (!empty($_POST['unsub'])) {
        $unsub = sanitize($_POST['unsub'], 'unsub');
    }
    $selectFields = ['ID', 'Username', 'First_Name', 'Last_Name', 'email', 'ip', 'sponsorid', 'UNIX_TIMESTAMP(Signdate) as time'];
    $mainTable = 'members';
    $where = ['unsubscribe_id2' => ['=', $unsub]];

    $result = select($selectFields, $mainTable, [], $where, null, null, null, 1, 1);
    //echo 'got 2 ';
}

$buffer = isset($result[0]) ? $result[0] : null;

if (empty($buffer['ID'])) {
	//header("Location: ./index.php");
	echo 'NO ID FOUND!';
	exit;
}
$user_id = $buffer['ID'];
$user_firstname = $buffer['First_Name'];
$user_lastname = $buffer['Last_Name'];
$user_username = $buffer['Username'];
$user_email = $buffer['email'];
$user_join_date = date('F jS\, Y' ,$buffer['time']);
$user_ip = $buffer['ip'];
$user_sponsor = $buffer['sponsorid'];
//perhaps add status for all the programs in a later update?
//echo 'username: '.$user_username;
$keep_user = false; // INITIALIZE VARIABLE

if ($admin_override == true) { // ADMIN IS REMOVING THIS USER DUE TO BOUNCED EMAILS, LET'S MAKE SURE THEY ARE NOT ACTIVE!!
	
	$user_id = sanitize($user_id); // Assuming $user_id is previously defined

	$selectFields = ['user_status'];
	$mainTable = 'user_program';
	$where = [
		'ID' => ['=', $user_id],
		'user_status' => ['IN', ['Active', 'Comped', 'Suspended', 'Cancelled']]
	];

	$resultp = select($selectFields, $mainTable, [], $where, null, null, null, 1, 1);
	$bufferp = isset($resultp[0]) ? $resultp[0] : null;

	if ($bufferp) {
		if ($bufferp['user_status'] != '') $keep_user = true;
	}

}

$step = 1;
$pageName = 'cancel';

// GO DIRECTLY TO STEP 4 (UPDATES) WHEN ADMIN OVERRIDE IS TRUE
if ($admin_override == true) $step = 4; // MAY CHANGE AGAIN FOR STEP 5, "UNCANCEL FIX", BELOW!

if (isset($_GET['confirm']) && $_GET['confirm'] == 'yes' && !empty($buffer['ID'])) {
	$step = 2;
	$pageName = 'cancel2';
} else if (isset($_GET['confirming']) && $_GET['confirming'] == 'yes' && !empty($buffer['ID'])) {
	$step = 3;
	$pageName = 'cancel3';
} else if (isset($_GET['confirmed']) && $_GET['confirmed'] == 'yes' && !empty($buffer['ID'])) {
	$step = 4;
	$pageName = 'cancel4';
} else if (isset($_GET['fix']) && $_GET['fix'] != '' && !empty($buffer['ID']) && $admin_override == true) {
	$step = 5;
	$pageName = 'uncancel';
}


if ($step == 2) {
	$unsubscribe_url = $GLOBALS['webpage_url'].'leave.php?confirming=yes&id='.$buffer['unsubscribe_id2'];
	//Custom Tags subject: [webpage_name] [firstname] [lastname]
	$subject_replace = array('[webpage_name]', '[firstname]', '[lastname]');	
	$subject_replace_with = array($GLOBALS['webpage_name'], $buffer['First_Name'], $buffer['Last_Name']);

	//Custom Tags message: [webpage_name]  [firstname] [lastname] [unsubscribe_link]
	$message_replace = array('[webpage_name]', '[firstname]', '[lastname]', '[unsubscribe_link]');
	$message_replace_with = array($GLOBALS['webpage_name'], $buffer['First_Name'], $buffer['Last_Name'], $unsubscribe_url);				
									
	$subject = str_replace($subject_replace, $subject_replace_with, $GLOBALS['email_unsubscribe1_subject']);
	$message = str_replace($message_replace, $message_replace_with, $GLOBALS['email_unsubscribe1_message']);				  					
	
	mail($buffer['email'], $subject, $message, "From: {$GLOBALS['admin_email_heading']} <{$GLOBALS['admin_email']}>\r\n");
}

if ($step == 4) {
	
	$datetime = date("Y-m-d H:i:s");
	
	if ($admin_override == true) {
		$cancelled_by = 'admin';
	} else {
		$cancelled_by = 'member';
	}
	
	// WE USE STATUS FIELD TO DISABLE MAILING TO MEMBER FROM ADMIN PANEL, AND SHUT OFF THEIR REPLICATED PAGES (in cookie.php)
	$user_id = sanitize($user_id); // Assuming $user_id is previously defined
	$user_email = sanitize($user_email); // Assuming $user_email is previously defined

	if ($keep_user == true && $admin_override == true) {
		$updateData = ['bounced_email' => ['expression' => 'email']];
		$whereConditions = ['ID' => ['=', $user_id], 'email' => ['!=', '']];
		update('members', $updateData, [], $whereConditions, 1, 1, 1);
		
		$updateData = ['email' => ''];
		$whereConditions = ['ID' => ['=', $user_id]];
		update('members', $updateData, [], $whereConditions, 1, 1, 1);
		$bounced_email = true;
	}	
	if ($keep_user == false) {
		$updateData = ['Status' => 'Cancelled'];
		update('members', $updateData, [], $whereConditions, 1, 1, 1);

		$updateData = [
			'user_status' => 'Cancelled',
			'date_cancelled' => $datetime, 
			'cancelled_by' => $cancelled_by,
			'end_program' => 'Y'
		];
		$whereConditions = [
			'ID' => ['=', $user_id],
			'user_status' => ['NOT IN', ['Unpaid', 'Cancelled']]
		];
		update('user_program', $updateData, [], $whereConditions, 1, 1, 1);

		$updateData = ['active' => 'N'];
		$whereConditions = ['id_paying' => ['=', $user_id]];
		update('e4_arb', $updateData, [], $whereConditions, 1, 1, 1);

		$whereConditions = ['id_receiving' => ['=', $user_id]];
		update('e4_arb', $updateData, [], $whereConditions, 1, 1, 1);

		if ($user_email != '') { // DELETE EMAIL FROM LEADS AR!
			$whereConditions = ['ar_leads_email' => ['=', $user_email]];
			delete('ar_leads', $whereConditions);
		}
	}
		
	//Custom Tags subject: [webpage_name] [firstname] [lastname]
	$subject_replace = array('[webpage_name]', '[firstname]', '[lastname]');	
	$subject_replace_with = array($GLOBALS['webpage_name'], $buffer['First_Name'], $buffer['Last_Name']);
												
	//Custom Tags message: [webpage_name]  [firstname] [lastname]
	$message_replace = array('[webpage_name]', '[firstname]', '[lastname]', '[unsubscribe_link]');
	$message_replace_with = array($GLOBALS['webpage_name'], $buffer['First_Name'], $buffer['Last_Name']);				
									
	$subject = str_replace($subject_replace, $subject_replace_with, $GLOBALS['email_unsubscribe2_subject']);
	$message = str_replace($message_replace, $message_replace_with, $GLOBALS['email_unsubscribe2_message']);				  					
	if ($admin_override != true) 
	mail($buffer['email'], $subject, $message, "From: {$GLOBALS['admin_email_heading']} <{$GLOBALS['admin_email']}>\r\n");
}
include 'header.php';

if ($step == 5) {
	
	$user_id = sanitize($user_id); // Assuming $user_id is previously defined

	// First Update Query
	$updateData = ['email' => ['expression' => 'bounced_email']];
	$whereConditions = ['ID' => ['=', $user_id], 'bounced_email' => ['!=', '']];
	update('members', $updateData, [], $whereConditions, 1, 1, 1);	

	// Second Update Query
	$updateData = ['bounced_email' => ''];
	$whereConditions = ['ID' => ['=', $user_id]];
	update('members', $updateData, [], $whereConditions, 1, 1, 1);
		
}		
?>
	<!-- *****************************************************************************************************************
	 BLUE WRAP
	 ***************************************************************************************************************** -->
	<div id="blue">
	    <div class="container">
			<div class="row">
				<h3>Membership Cancellation</h3>
			</div><!-- /row -->
	    </div> <!-- /container -->
	</div><!-- /blue -->

	<div class="row">
    <div class="center">

        <div class="col-xs-12 col-md-offset-2 col-md-8">

<?php 
if ($step == 1) { ?>
<form action="leave.php?confirm=yes" method="POST">
<h3><?php echo "$user_firstname";?>,<br/>are you sure you want to leave?</h3>
<br/>
<input type="radio" class="check" name="unsubtype" value="" checked>
REMOVE ME FROM <?php echo $GLOBALS['webpage_name'];?>.
<hr>
This option will cancel your
account. You will lose your downline referrals and ability to earn money
with our program. You will not receive
email from us anymore. <u>Email confirmation required.</u>
<hr>
Your Membership Details:<br/>
Name: <?php echo $user_firstname.' '.$user_lastname;?><br/>
Username: <?php echo $user_username;?><br/>
Contact Email: <?php echo $user_email;?><br/> 
Joined on: <?php echo $user_join_date;?> <?php echo $user_ip;?><br/>
Referred by: <?php echo $user_sponsor;?><br/> 
<input type="hidden" name="id" value="<?php echo $id; ?>">

<br><input title="" type="submit" name="Process" value="Cancel My Account"  class="btn btn-lg btn-danger">
</form>
<br/>
<form action="<?php echo $GLOBALS['webpage_url'];?>?id=<?php echo $user_username;?>" method="POST"><input title="" type="submit" value="I've Changed My Mind. I'll Stay."  class="btn btn-lg btn-success" onClick="alert('Thank you! You are being redirected now to the main site.')"></form>

<hr>
NOTE: Please allow 24-72 hours for all emails to cease, as they may be in the queue already.
<p>To report abuse, or provide us with valuable feedback on how we my improve our program, please <a href="contact.php?id=<?php echo $user_username;?>" style="text-decoration: underline">contact
us.</a> Thank you.

<?php } else if ($step == 2) { ?>

<blockquote>
<h3>
Please check your email for
membership removal confirmation.
</h3>

You must click on the link in that email,
to be removed.

<hr>
We'll be sorry to see you go, but we respect
your wishes. Thank you for giving us a try.
<hr>
Please make sure your contact email, listed
in your account profile, is up to date. If it is not, you will not get
a cancellation confirmation email.
</blockquote>

<?php } else if ($step == 3) { ?>

<form action="leave.php?confirmed=yes" method="POST">
<h2 style="color:#ff0000">LAST CHANCE <?php echo "$user_firstname";?>!</h2>
<hr>
<input type="radio" class="check" name="unsubtype" value="" checked>
REMOVE ME FROM <?php echo $GLOBALS['webpage_name'];?>.
<hr>
This option will completely cancel your
account. You will lose your downline referrals and ability to earn money
with our program. <u>This is the FINAL STEP in removing your membership.</u> You will receive one email confirming your account deletion. After that, you will not receive
further membership related emails.
<hr>
Your Membership Details:<br/>
Name: <?php echo $user_firstname.' '.$user_lastname;?><br/>
Username: <?php echo $user_username;?><br/>
Contact Email: <?php echo $user_email;?><br/> 
Joined on: <?php echo $user_join_date;?> <?php echo $user_ip;?><br/>
Referred by: <?php echo $user_sponsor;?><br/> 
<input type="hidden" name="unsub" value="<?php echo $id; ?>">
<br><input title="" type="submit" name="Process" value="Remove Me Permanently Now"  class="btn btn-lg btn-danger">
</form>
<br/>
<form action="<?php echo $GLOBALS['webpage_url'];?>?id=<?php echo $user_username;?>" method="POST">
<input title="" type="submit" value="I've Changed My Mind. I'll Stay." class="btn btn-lg btn-success" onClick="alert('Thank you! You are being redirected now our main site.')"></form>
<hr>
NOTE: Please allow 24-72 hours for all emails to cease, as they may be in the queue already.
<p>To report abuse, or provide us with valuable feedback on how we my improve our program, please <a href="contact.php?id=<?php echo $user_username;?>" style="text-decoration: underline">contact
us.</a> Thank you.

<?php } else if ($step == 4) { ?> 

	<div style="text-align:center">
	<?php if ($admin_override == true) {
		
	if ($buffer['Status'] == 'Cancelled') echo '<h1 style="color:red">This User Was Already Cancelled!</h1>';
	?>

	<h2 style="color:red">Admin Override Detected. User was cancelled.</h2>
	
	<h2 style="color:red">Cancelled by accident? <a href="leave.php?fix=<?php echo $_REQUEST['id']; ?>" class="btn btn-default">Uncancel this user!</a></h2>	
	
	<?php if ($bounced_email == true) echo '<h2>Email was moved to "bounced_email" field.</h2>'; ?>
	
	<h3>Should this user come back with a new email, they must be "uncancelled" and they may add a new email.</h3> 
	
	<h3>NOTE: Their email is kept for record keeping, but it will no longer be emailed.</h3>

	<?php
	} else { ?>

	<h2>Your membership has been cancelled.</h2>
	<h3>Please allow 72 hours to be purged from all mailings!</h3>

	<?php } ?>
	</div>
     <p>&nbsp;</p>
     <p>&nbsp;</p>     <p>&nbsp;</p>
<?php } else if ($step == 5) { ?> 

	<div style="text-align:center">
	<h1 style="color:green">Admin Override - This User Was Re-instated!</h1>
	</div>
     <p>&nbsp;</p>
     <p>&nbsp;</p>     <p>&nbsp;</p>	
<?php }?>
	
	
	</div>
    </div>
</div>
<?php 
include 'footer.php'; 
?>