<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './cookie.php';
include './maintenance.inc.php'; // THIS FILE WILL LOCK THIS PAGE, WHEN SITE IS PLACED IN MAINTENANCE MODE (FROM ADMIN PANEL)
//$fileName = basename(__FILE__);
if (!isset($_REQUEST['rd'])) {
	if (isset($_SESSION['loggedin'])) unset($_SESSION['loggedin']);
}
$pageName = 'login';
$pageClass = '';
$error_captcha = '';
$ERROR = ''; // INI VAR
$GLOBALS['member_dir'] = 'Members';


// CREATE SIMPLE RANDOM CAPTCHA NUMBERS
if (empty($_SESSION['captcha'])) {
	$_SESSION['captcha'] = rand(111,999);
	if ($_SESSION['captcha'] == 665 + 1) $_SESSION['captcha'] = 777;
	$captcha_password = $_SESSION['captcha'];
} else {
	$captcha_password = $_SESSION['captcha'];
}


// IF URL STRING RD VARIABLE IS SET, WE ADD IT INTO SESSION TO USE ON LOGIN REDIRECT
if (isset($_REQUEST['rd']) && $_REQUEST['rd']!='') $_SESSION['rd']=$_REQUEST['rd']; // ALREADY SANITIZED AT TOP OF COOKIE!

if (isset($_POST['completed']) && $_POST['completed'] == 'yes') {
	
	// SECURE LOGIN FROM XSS ATTACKS!
	if ($_POST['csrf_token'] !== $_SESSION['csrf_token']) {
		//echo 'Token mismatch!';
		header("Location: /login.php");
		exit;
	}

/*	$login = $_POST['login'];
	$selectFields = '*';
	$mainTable = 'members';

	$where = [
		'OR' => [
			['Username' => $login],
			['email' => $login],
			['bounced_email' => $login]
		]
	];	

	$result = select($selectFields, $mainTable, [], $where, null, null, null, 1, 1);

	if (isset($buffer)) unset($buffer);

	$buffer = isset($result[0]) ? $result[0] : null;
	
	//print_r($buffer);*/
	// WE ALREADY HAVE SAME QRY IN COOKIE ON POST (TO SET COOKIE), SO IT IS REDUNDANT TO HAVE IT HERE AS WELL!
	$buffer = $bufferLogin; // SET BUFFER FROM COOKIE QRY!
		
				
	// SET UP YOUR USERNAME
	if (is_array($buffer) && isset($buffer['Username']) && is_email($buffer['Username'])) {
		//echo "Username is a valid email address.";
		// SEND THEM TO PAGE TO CHANGE IT!
		$urlforloginarea = 	$GLOBALS['webpage_url_ssl'].$GLOBALS['member_dir'].'/username-setup.php';	
	
	} else if (is_array($buffer) && isset($buffer['Status']) && $buffer['Status'] == 'unpaid') { // CHK YOUR SPONSOR & PAY
		//echo "Uname is NOT a valid email address.";
		// NORMAL LOGIN
		$urlforloginarea = $GLOBALS['webpage_url_ssl'].$GLOBALS['member_dir'].'/sponsor-check.php';
		//$urlforloginarea = $GLOBALS['webpage_url_ssl'].$GLOBALS['member_dir'].'/advanced_viewer.php';
	
	} else { // NORMAL LOGIN TO DASHBOARD
		//echo "Uname is NOT a valid email address.";
		// NORMAL LOGIN
		$urlforloginarea = $GLOBALS['webpage_url_ssl'].$GLOBALS['member_dir'].'/index.php';
		//$urlforloginarea = $GLOBALS['webpage_url_ssl'].$GLOBALS['member_dir'].'/advanced_viewer.php';
	}
	
	// OVERRIDE FOR CUSTOM CLIENT PAYMENTS
	//if ($_POST['login'] == 'client') $urlforloginarea = $Global['webpage_url_ssl']."apay/pay.php?program=2";
	
	// INI VARIABLE
	$passwordAccepted = false;

	// Hash the password
	//$hashedPassword = password_hash($_POST['password'], PASSWORD_DEFAULT);
	
	// Verify the password
	//$passwordAccepted = password_verify($hashedPassword, $buffer['Password']);
	
	if (isset($_POST['password']) && isset($buffer['Password'])) {
		// Get the plain password from POST data
		$plainPassword = $_POST['password'];

		// Verify the password
		// Here, $plainPassword is the plain password entered by the user
		// $buffer['Password'] should be the hashed password stored in your database
		$passwordAccepted = password_verify($plainPassword, $buffer['Password']);
		
		
		// Backward compatibility (before pw got hashed)
		if ($_POST['password'] == $buffer['Password']) $passwordAccepted = true;
	}
	
	if (empty($buffer['ID'])) $ERROR='<h3 style="color:red">Invalid Username or Email</h3>';
	if ($passwordAccepted == false) $ERROR.='<h3 style="color:red">Invalid Password</h3>';
	if (trim($_POST['captcha']) != $captcha_password) $error_captcha = 'Please enter the Captcha number: '.$captcha_password.'<br/>below, to pass the human test.';

	// Option to disable login to admin account from here
	if (((!empty($buffer['ID']) /*&& $buffer['ID']!=1*/ && empty($ERROR) && empty($error_captcha) && $passwordAccepted === true))) { 

		// NOW WE LOGIN THE MEMBER, AND SET UP THEIR SESSION VARS!
		// Fetching member_link information
		$selectFields = '*';
		$mainTable = 'member_link';
		$where = ['ID' => ['=', $buffer['ID']]];
		$mlnkinfoResult = select($selectFields, $mainTable, [], $where, null, null, null, 1, 1);
		$mlnkinfo = isset($mlnkinfoResult[0]) ? $mlnkinfoResult[0] : null;

		// Fetching sponsor's information from members
		//echo $buffer['sponsorid'];
		$mainTable = 'members';
					/*"Status != 'Cancelled'",*/
		$where = ['Username' => ['=', $buffer['sponsorid']]];
		$spnsinfoResult = select($selectFields, $mainTable, [], $where, null, null, null, 1, 1);
		$spnsinfo = isset($spnsinfoResult[0]) ? $spnsinfoResult[0] : null;

		// Fetching sponsor's member_link information
		$mainTable = 'member_link';
		$where = ['ID' => ['=', $spnsinfo['ID']]];
		$smlnkinfoResult = select($selectFields, $mainTable, [], $where, null, null, null, 1, 1);
		$smlnkinfo = isset($smlnkinfoResult[0]) ? $smlnkinfoResult[0] : null;

		if (isset($_SESSION['status_check'])) unset($_SESSION['status_check']);
		unset($_SESSION['captcha']);

		$_SESSION['loggedin'] = $buffer['Username'];
		$_SESSION['Firstname_loggedin'] = $buffer['First_Name'];
		$_SESSION['Lastname_loggedin'] = $buffer['Last_Name'];
		//$_SESSION['SponsorID'] =  $buffer['Username'];
		$_SESSION['UserID'] =  $buffer['ID'];
		$_SESSION['Email_loggedin'] =  $buffer['email'];
		$_SESSION['Phone_loggedin'] =  $mlnkinfo['phone'];

		//Used for JV status only
		//$_SESSION['Status'] = $buffer['Status'];

		// MAYBE OVERKILL, LEAVING OUT FOR NOW!
		/*$_SESSION['affiliate_status'] = $buffer['affiliate_status'];
		$_SESSION['customer_status'] = $buffer['customer_status'];*/

		// ADDED ADDRESS INFO BACK IN, FOR ALERT SYSTEM!
		$_SESSION['Address'] =  $mlnkinfo['address'];
		$_SESSION['Address2'] =  $mlnkinfo['address2'];
		$_SESSION['City'] =  $mlnkinfo['city'];
		$_SESSION['State'] =  $mlnkinfo['state'];
		$_SESSION['Province'] = $buffer['province'];
		$_SESSION['Zip'] =  $mlnkinfo['zip'];
		$_SESSION['Country'] =  $mlnkinfo['country'];

		$_SESSION['RefFirstname'] = $spnsinfo['First_Name'];
		$_SESSION['RefLastname'] = $spnsinfo['Last_Name'];
		$_SESSION['RefSponsorID'] =  $spnsinfo['Username'];
		$_SESSION['RefUserID'] = $spnsinfo['ID'];
		$_SESSION['RefEmail'] =  $spnsinfo['email'];
		$_SESSION['RefPhone'] =  $smlnkinfo['phone'];

		$_SESSION['ulogin'] = 1; // NOT SURE THIS IS NEEDED? IF NOT, AX IT.
		log_login($_POST['login'], true, $buffer);

		//Anyone logging in from this page is returning
		//if ($_SESSION['loggedin'] != 'QQQtest') $_SESSION['Returning'] = true;
		// WE NOW ONLY SET RETURNING TRUE, AFTER THEY HAVE PAID!
		// SO THAT THEY WILL NOT SEE MENUS IN THE BACK OFFICE.
		if ($buffer['Status'] == 'paid') $_SESSION['Returning'] = true;
				
	} else {
		log_login($_POST['login']); // log failed login attempt
	}
} // END POST COMPLETED!
	
//echo $urlforloginarea;
//exit;	

//IF RD SESSION VARIABLE IS SET, WE REDIRECT TO RD VARIABLE INSTEAD OF MEMBERS INDEX PAGE.

if (isset($_SESSION['loggedin']) && (isset($_SESSION['rd']))) {
	header("Location: {$GLOBALS['webpage_url_ssl']}".$_SESSION['rd']);
	unset($_SESSION['rd']);
	exit;
} else if (isset($_SESSION['loggedin'])) {
	header("Location: {$urlforloginarea}");
	if (isset($_SESSION['rd'])) unset($_SESSION['rd']);
	exit;
}
	
include './header.php'; 
?>

<br/>



<div class="row cQQQenter-block col-md-12 col-xs-12" style="float:none; margin-top:20px; text-align:center">

<div class="col-md-4">
&nbsp;
</div> 

<!-- -->
          <div class="col-md-4 panel panel-primary">
            <div class="panel-heading">
			 <h3 class="panel-title">Member Login</h3>
            </div>
            <div class="panel-body">
<!-- -->

<?php

if (!empty($_POST['login'])) {
    $prefilled_email = $_POST['login'];
} elseif (!empty($_GET['login'])) {
    $prefilled_email = $_GET['login'];
} elseif (isset($_COOKIE['login'])) {
    $prefilled_email = $_COOKIE['login'];
} elseif (isset($_SESSION['page_email'])) {
    $prefilled_email = $_SESSION['page_email'];
} else {
    $prefilled_email = ''; // Default empty value
}

if (isset($prefilled_email)) $prefilled_email = sanitize($prefilled_email); // Sanitize the input
$login = $prefilled_email; 


// DON'T NEED THIS - WE DON'T SHOW PW TO USER / TOO RISKY FOR XSS HACK POTENTIAL
//$password = $_POST['password']; // DOES NOT GET SANITIZED!


if (!empty($ERROR)) { 
	echo '<span style="font-weight:bold; color:red">'.$ERROR.'</span>';
}	
?>
<form name="form" method="post" action="login.php">
<input type="hidden" name="csrf_token" value="<?php if (isset($_SESSION['csrf_token'])) echo htmlspecialchars($_SESSION['csrf_token'], ENT_QUOTES, 'UTF-8'); ?>">
<input type="hidden" name="completed" value="yes">

    <div class="form-group input-group">
		<div class="input-group-prepend">
            <span class="input-group-text"><i class="fa fa-user input-icon"></i></span>
		</div>
        <input class="form-control fa fa-user" type="text" placeholder="Username or Email" name="login" value="<?php echo $login; ?>" onMouseover="this.focus()" required maxlength="50" aria-label="username or email" aria-required="true">
    </div>
		  
		  
	<div class="form-group input-group">
		<div class="input-group-prepend">
			<span class="input-group-text"><i class="fa fa-lock"></i></span>
		</div>
		<input class="form-control" type="password" placeholder="Password" id="password" name="password" value="<?php /*echo $//password; // DON'T EVER ECHO PW!!!*/?>" onMouseover="this.focus()" required maxlength="50" aria-label="password" aria-required="true">
		<div class="input-group-append">
			<span class="input-group-text">
				<input type="checkbox" id="showPasswordCheckbox"/>&nbsp; <a href="#" id="showPasswordLink">Show</a>
			</span>
		</div>
	</div>

	  
<?php		  
if (!empty($error_captcha)) { 
	echo '<span style="font-weight:bold; color:red">'.$error_captcha.'</span>';
}
?>		  

<!-- FOR ACCESSIBILITY FOR THE BLIND - ARIA (Accessible Rich Internet Applications) -->
Enter Captcha Code: <?php echo $captcha_password; ?> below
<br>				  
          <div class="form-group input-group">
		   <div class="input-group-prepend">
            <span class="input-group-text"><i class="fa fa-chain"></i></span>
			</div>
			
<input class="form-control" type="text" placeholder="Enter Captcha Code: <?php echo $captcha_password; ?>" name="captcha" required value="<?php if (!empty($_POST['captcha'])) echo htmlspecialchars($_POST['captcha'], ENT_QUOTES, 'UTF-8'); ?>" onMouseover="this.focus()" maxlength="10" aria-label="Enter Captcha <?php echo $captcha_password; ?>" aria-required="true">			

          </div>		  
		  <!--
          <div class="checkbox">
            <label>
              <input type="checkbox"> Keep me logged in 
            </label>
          </div>
		  -->
          <div class="form-group">
<p>&nbsp;</p>

<input type="submit" value="Submit To Login" class="btn button btn-primary" style="margin-top:5px; background-color:#2fbad0;" name="Submit">
</form>		  
		</div>


Lost Your Details? <a href="password.php?id=<?php echo $SponsorID; ?>" class="links">Click Here</a><br/>
Not A Member Yet? <a href="join.php?id=<?php echo $SponsorID; if (isset($_GET['rd']) && $_GET['rd']!='') echo '&rd='.$_GET['rd']; ?>" class="links">Join Here</a>
<br/><br/>

<!--
<small>
&copy; Copyright <?php echo date('Y');?>, <?php echo $GLOBALS['webpage_name'];?>. All Rights Reserved.
&nbsp;
</small>
-->


     </div>
   </div>
   
  <div class="col-md-4">
&nbsp;
</div>  
   
   
</div>
<!--
<p>&nbsp;</p><p>&nbsp;</p><p>&nbsp;</p>
-->
<script>
    const showPasswordLink = document.getElementById('showPasswordLink');
    const showPasswordCheckbox = document.getElementById('showPasswordCheckbox');
    
    showPasswordLink.addEventListener('click', function(event) {
        event.preventDefault(); // Prevent anchor from navigating
        
        showPasswordCheckbox.checked = !showPasswordCheckbox.checked; // Toggle checkbox
        updatePasswordFieldVisibility();
    });
    
    showPasswordCheckbox.addEventListener('change', function() {
        updatePasswordFieldVisibility();
    });
    
    function updatePasswordFieldVisibility() {
        const passwordField = document.getElementById('password'); // Updated ID
        
        if (showPasswordCheckbox.checked) {
            passwordField.type = 'text'; // Show password
        } else {
            passwordField.type = 'password'; // Hide password
        }
    }
</script>

<?php
include './footer.php'; 
?>