<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './cookie.php';
$pageName = 'password-reset';
$error_msg = ''; // INI VAR

function password_strength($password) {
    $strength = 0;
    $length = strlen($password);
    $error_msg = "";

    // Check password length
    if ($length < 8) {
        $error_msg .= "Password must be at least 8 characters long.<br> ";
    } else {
        $strength += 1;
    }

    // Check if password contains both upper and lower case characters
	if (!preg_match("/^(?=.*[a-z])(?=.*[A-Z])\S+$/", $password)) {
	//if (!preg_match("/^(?=.*[a-z])(?=.*[A-Z]).+$/", $password)) { // OLD WAY - ALLOWED SPACES
        $error_msg .= "Password must contain both uppercase and lowercase characters.<br> ";
    } else {
        $strength += 1;
    }

    // Check if password contains numbers
    if (!preg_match("/^(?=.*\d).+$/", $password)) {
        $error_msg .= "Password must contain numbers.<br> ";
    } else {
        $strength += 1;
    }

    // Check if password contains symbols
    if (!preg_match("/^(?=.*[^a-zA-Z\d]).+$/", $password)) {
        $error_msg .= "Password must contain symbols.<br> ";
    } else {
        $strength += 1;
    }

    // Return password strength score and error message if any
    return array("strength" => $strength, "error_msg" => $error_msg);
}

if (!isset($_GET['token'])) {

	$error_msg = 'Token not found. Please request a new token <a href="password.php">here</a>.';

} else { // WE HAVE TOKEN, CONTINUE!	

	$token = isset($_GET['token']) ? $_GET['token'] : '';
	// Check if token is valid and not expired
	$selectFields = ['password_reset_expire'];
	$mainTable = 'members';
	$where = ['password_token' => ['=', $token]];
	$limit = 1;
	$show_debug = 1;
	$result = select($selectFields, $mainTable, [], $where, null, null, null, $limit, $show_debug);
	$buffer = isset($result[0]) ? $result[0] : null;
	
	print_r($buffer);

	$currentTime = date("Y-m-d H:i:s");
	$expiryTime = $buffer['password_reset_expire'] ?? 0;

	if ($currentTime > $expiryTime) {
		$error_msg = 'Token has expired. Please request a new token <a href="password.php">here</a>.';
	} elseif (!empty($_POST['reset']) && $_POST['reset'] == 'yes') {
		$password = $_POST['password'];
		$confirmPassword = $_POST['confirmPassword'];
		
		$result = password_strength($_POST['password']);
		
		if (empty($_POST['password'])) {
			$error_msg = 'Please choose a password.';
		}
		elseif (!empty($_POST['password']) && $result["strength"] === 4) {
			//echo "Password is strong!";
		} 
		elseif (!empty($_POST['password'])) {
			$error_msg = "Password is weak. Please correct the following issues:<br>" . $result["error_msg"];
		}

		if (empty($error_msg) && $password === $confirmPassword) {
			// Hash the new password
			$hashedPassword = password_hash($password, PASSWORD_DEFAULT);

			// Update the member's password in the database
			$table = 'members';
			$data = ['Password' => $hashedPassword, 'password_reset_expire' => null, 'password_token' => null];
			$where = ['password_token' => ['=', $token]];
			$live = 1;
			$limit = 1;
			$show_debug = 1;
			
			update($table, $data, [], $where, $live, $limit, $show_debug);

			$success_msg = true;
		} else {
			$error_msg .= ' The passwords do not match. Please try again.';
		}
	}
} // END WE HAVE TOKEN!
include 'header.php';
?>
<br/>

<div class="row center-block col-md-12 col-xs-12" style="float:none; margin-top:20px; text-align:center">
<?php
if (isset($success_msg) && $success_msg == true) {
    echo '<h4>Your password has been successfully reset.</h4></div>';
	echo '<a href="login.php">Please login here</a>.';
	include 'footer.php';
	exit;
} elseif (isset($error_msg)) {
    echo '<h4 style="color:red">' . $error_msg . '</h4></div>';
	if (!isset($_GET['token']) || $currentTime > $expiryTime) {
		include 'footer.php';
		exit;
	}	
}
?>
</div>

<form class="form-signin" name="form" method="post" action="password-reset.php?token=<?php echo htmlspecialchars($token); ?>">
<input type="hidden" name="reset" value="yes">
<div class="row">
    <div class="col-md-4">
        &nbsp;
    </div>
    <div class="col-md-4 well well-login">
        <h3 class="panel-title" style="text-align:center">Reset Password</h3>
		
Your password must be at least 8 characters long, and contain both uppercase and lowercase characters, numbers and symbols. No spaces.
        
        <div class="form-group input-group">
            <label for="password" class="sr-only">New Password</label>
            <div class="input-group-prepend">
                <span class="input-group-text"><i class="fa fa-lock"></i></span>
            </div>
            <input type="password" placeholder="Enter New Password" name="password" required="required" class="form-control input-login">
        </div>
        
        <div class="form-group input-group">
            <label for="confirmPassword" class="sr-only">Confirm Password</label>
            <div class="input-group-prepend">
                <span class="input-group-text"><i class="fa fa-lock"></i></span>
            </div>
            <input type="password" placeholder="Confirm New Password" name="confirmPassword" required="required" class="form-control input-login">
        </div>
        
        <button class="btn btn-info btn-block button-login" type="submit">&#10140; Reset Password</button>
    </div>
    <div class="col-md-4">
        &nbsp;
    </div> 
</div>
</form>

<br/><br/>
</div>
<?php include 'footer.php'; ?>
