<?php
/* Twilio include for sending mass texts from admin panel */
require_once $Global['path']."twilio-php/Services/Twilio.php";

$GLOBALS['AccountSid'] = $GLOBALS['twilio_AccountSid']; 
$GLOBALS['AuthToken'] = $GLOBALS['twilio_AuthToken'];
//$GLOBALS['twilio_phone'] = '+1';

if (!function_exists ('send_twilio_sms')) {
	function send_twilio_sms($phonenumber,$smstext) {

		$AccountSid = $GLOBALS['AccountSid'];
		$AuthToken = $GLOBALS['AuthToken'];
		$FromPhone = $GLOBALS['twilio_phone'];
		// instantiate a new Twilio Rest Client	
		$client = new Services_Twilio($AccountSid, $AuthToken);
		// send an SMS
		try {
			$sms = $client->account->messages->sendMessage($FromPhone,$phonenumber,$smstext);
		} catch (Exception $e) 
		{ 
			return(false); // if fault, return false
		}
		return(true); 
	}
}

/*if (!function_exists ('make_twilio_call')) {
	function make_twilio_call($phonenumber,$url) {

		$AccountSid = $GLOBALS['AccountSid'];
		$AuthToken = $GLOBALS['AuthToken'];
		// instantiate a new Twilio Rest Client	
		$client = new Services_Twilio($AccountSid, $AuthToken);
		// send an SMS
		try {
			$client->account->calls->create($GLOBALS['twilio_phone'], $phonenumber, $url, array(          
)); 
		} catch (Exception $e) 
		{ 
			return(false); // if fault, return false
		}
		return(true); 
	}
}*/

if (!function_exists('make_twilio_call')) {
    function make_twilio_call($phonenumber, $url) {

        $AccountSid = $GLOBALS['AccountSid'];
        $AuthToken = $GLOBALS['AuthToken'];
        // instantiate a new Twilio Rest Client    
        $client = new Services_Twilio($AccountSid, $AuthToken);
        // send an SMS
        try {
            $client->account->calls->create(
                $GLOBALS['twilio_phone'],
                $phonenumber,
                $url,
                array(
                    'MachineDetection' => 'Enable', // Add this line to enable machine detection
                )
            );
        } catch (Exception $e) {
            return(false); // if fault, return false
        }
        return(true);
    }
}



if (!function_exists ('twilio_get_country_code')) {
	function twilio_get_country_code($phone_number) {
		$AccountSid = $GLOBALS['AccountSid'];
		$AuthToken = $GLOBALS['AuthToken'];
		$url = 'https://lookups.twilio.com/v1/PhoneNumbers/'.$phone_number;
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL,$url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
		curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
		curl_setopt($ch, CURLOPT_USERPWD, "$AccountSid:$AuthToken");
		$result = curl_exec($ch);
		curl_close($ch);  
		$lookup_data = json_decode($result,true);
		$full_phone_number = $lookup_data['phone_number'];
		$found_country = $lookup_data['country_code'];
		return($found_country);
	}
}

if (!function_exists ('get_gmt_send_time')) {
	function get_gmt_send_time($phonenumber) {
		
		$AccountSid = $GLOBALS['AccountSid'];
		$AuthToken = $GLOBALS['AuthToken'];
		
		$hour_now = date("H");
		$hour_gmt = gmdate("H");
		$diff = $hour_now-$hour_gmt;
		$country = twilio_get_country_code($phonenumber);
		
		//echo "$hour_now $hour_gmt $diff";
		/*$sql = "SELECT * from twilio_sms_country_info WHERE country='{$country}'";
		$res = mysql_query($sql);
		$buffer = mysql_fetch_assoc($res);*/
		
		// Prepare the parameters for the select function
		$selectFields = ['*']; // Selecting all fields
		$mainTable = 'twilio_sms_country_info';
		$where = ['country' => $country]; // Assuming $country is already set and sanitized

		// Execute the query using PHPCPR's select function
		$result = select($selectFields, $mainTable, [], $where);

		// Fetch the result
		$buffer = $result[0]; // Assuming the select function returns an array of results
		
		$min_offset = $buffer['min_hrs'];
		$max_offset = $buffer['max_hrs'];
		if ($country == "US") {
			$npa = substr($phonenumber,2,3);
			if (in_array($npa,array("907","808"))) {
				$min_offset = -10;
				$max_offset = -9;
			}
		}
		$maxtime_there = ($hour_gmt + $max_offset) % 24;
		$mintime_there = ($hour_gmt + $min_offset) % 24;

		if ($maxtime_there >= 21 || $mintime_there < 8 || $maxtime_there < 8 || $mintime_there >= 21) {
			
			$next_ok_there_min = 8;
			$next_ok_there_max = 8 + abs($maxtime_there - $mintime_there);
			
			$next_ok_gmt = max(abs(($next_ok_there_min - $min_offset) % 24),abs(($next_ok_there_max - $max_offset) % 24));
			
			if ($next_ok_gmt < $hour_gmt) {
				$send_after_gmt = date("Y-m-d H:i:s",strtotime("tomorrow ".$next_ok_gmt.":00:00"));
			} else {
				$send_after_gmt = date("Y-m-d H:i:s",strtotime($next_ok_gmt.":00:00"));
			}
		
			//$wait = "Wait until ".$next_ok_gmt." GMT ($next_ok_there_min to $next_ok_there_max)";
			//$text = str_replace("'","",$smstext); // strip single quotes
				
		} else {
			$send_after_gmt = gmdate("Y-m-d H:i:s");
		}
		
		return(array($send_after_gmt,$country));
		
	}
}

if (!function_exists ('send_twilio_sms_q')) {
	function send_twilio_sms_q($phonenumber,$smstext,$ID = 0, $ar_leads_id=0) {
		$timestamp = date("Y-m-d H:i:s");
		if (trim($smstext) == "") return(false);
		
		$country = "11"; // placeholder to show that Cron needs to Calculate send time, country, etc.
		/*$insq = "INSERT INTO `twilio_sms_q`(`cellphone`, `country`, `text`, `reminder_user_ID`, `time_qed`, `ar_leads_id`) VALUES ('{$phonenumber}','{$country}','".mysql_real_escape_string($smstext)."','{$ID}','{$timestamp}', '{$ar_leads_id}')";
		//echo $insq;
			
		mysql_query($insq) or die("Houston, we have a problem:<br />$insq<br />".mysql_error());*/
				
		// Prepare the data array for insertion
		$data = [
			'cellphone'        => $phonenumber,     // Assuming $phonenumber is already set and sanitized
			'country'          => $country,         // Assuming $country is already set and sanitized
			'text'             => $smstext,         // Assuming $smstext is already set and sanitized
			'reminder_user_ID' => $ID,              // Assuming $ID is already set and sanitized
			'time_qed'         => $timestamp,       // Assuming $timestamp is already set and sanitized
			'ar_leads_id'      => $ar_leads_id      // Assuming $ar_leads_id is already set and sanitized
		];

		// Execute the insert using your PHPCPR's insert function
		$table = 'twilio_sms_q'; // The table to insert data into
		$live = 1; // Set to 1 to execute the query, 0 for test mode
		$show_debug = 1; // Set to 1 to enable debugging, or 0 to disable

		$result = insert($table, $data, $live, $show_debug);

		// Handle the result of the insertion
		if (!$result) {
			// Handle the error - replace this with your error handling logic
			echo "Houston, we have a problem with the insert operation.";
		}
		
		
		//echo "I got here";
		return(true);
		
	}
}

if (!function_exists ('twilio_standardize_phone_number')) {
	function twilio_standardize_phone_number($country_code,$phone_number) {
		$AccountSid = $GLOBALS['AccountSid'];
		$AuthToken = $GLOBALS['AuthToken'];
		$url = 'https://lookups.twilio.com/v1/PhoneNumbers/'.$phone_number.'?CountryCode='.$country_code;
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL,$url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
		curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
		curl_setopt($ch, CURLOPT_USERPWD, "$AccountSid:$AuthToken");
		$result = curl_exec($ch);
		curl_close($ch);  
		$lookup_data = json_decode($result,true);
		$full_phone_number = $lookup_data['phone_number'];
		$found_country = $lookup_data['country_code'];
		return($full_phone_number);
	}
}

if (!function_exists ('twilio_can_rcv_sms')) {
	function twilio_can_rcv_sms($full_phone_number) { // returns true if OK to reeceive SMS texts on this number, else false
		$AccountSid = $GLOBALS['AccountSid'];
		$AuthToken = $GLOBALS['AuthToken'];
		$url = 'https://lookups.twilio.com/v1/PhoneNumbers/'.$full_phone_number.'?Type=carrier';
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL,$url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
		curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
		curl_setopt($ch, CURLOPT_USERPWD, "$AccountSid:$AuthToken");
		$result = curl_exec($ch);
		curl_close($ch);  
		$lookup_data = json_decode($result,true);
		//echo "<pre>";
		//print_r($lookup_data);
		//echo "</pre>";
		$carrier_type = $lookup_data['carrier']['type'];
		$mcc = $lookup_data['carrier']['mobile_country_code'];
		$mnc = $lookup_data['carrier']['mobile_network_code'];
		$error_code = $lookup_data['carrier']['error_code'];
		$found_country = $lookup_data['country_code'];
		$carrier_name = $lookup_data['carrier']['name'];
		/*
		echo "<pre>";
		print_r($lookup_data);
		echo "</pre>";
		echo $lookup_data['phone_number']."<br />";
		*/
		if (!empty($error_code)) {
			return(false);
			//echo "Error - $error_code - Can't send text";
			//exit;
		}
		if ($carrier_type == "landline" || ($mnc == "" && substr($carrier_name,0,6) != 'Google')) {
			return(false); // if landline
			//echo "Landline";
			//exit;
		} 
		//echo "<br /><br  />";
		//echo "Carrier Info: ".$lookup_data['carrier']['mobile_network_code'] . " (".$lookup_data['carrier']['name'] .")<br />";
		$url = 'https://pricing.twilio.com/v1/Messaging/Countries/'.$found_country;
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL,$url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
		curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
		curl_setopt($ch, CURLOPT_USERPWD, "$AccountSid:$AuthToken");
		$result = curl_exec($ch);
		curl_close($ch);  
		$pricing_data = json_decode($result,true);
		foreach ($pricing_data['outbound_sms_prices'] as $key => $value_array) {
			if ($value_array['mcc'] == $mcc && $value_array['mnc'] == $mnc) {
				$price = $value_array['prices'][0]['current_price'];
				break;
			}
		}
		$price = $price + 0;
		if ($price > 0.10) return(false);
		else return(true);
		//echo "<br />Price: $price";
	}
}

?>