<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './cookie.php';
$pageName = 'ticket';
$ticket_id = '';
$idx = '';
$email = '';
if (isset($_GET['tid'])) $ticket_id = $_GET['tid'];
// ONLY SHOW TICKETS NO OLDER THAN X DAYS AGO
$datetime = date("Y-m-d H:i:s");
$too_old = date("Y-m-d H:i:s",strtotime("-6000 days"));
$rows = 0;

if (!isset($_SESSION['loggedin'])) {
	// FORCE LOGIN
	header('Location: login.php?rd=ticket-thread.php');	
	exit;
}

include 'header.php';	

	$username = $_SESSION['loggedin'];
	
	// UPDATE TICKET SET TO CLOSED!
	if ($_GET['tid'] != '' && $_GET['action'] == 'close') {
		$table = 'support_tickets';
		$updateData = ['status' => 'closed'];
		$where = [
			'ticket_id' => ['=', $ticket_id], 
			'username' => ['=', $username]
		];
		$live = 1;
		$limit = 1;
		$show_debug = 1;

		update($table, $updateData, [], $where, $live, $limit, $show_debug);		
	}

	// FIND TICKET ID
	$groupBy = null; 
	$having = null;
	$orderBy = 'idx DESC, status DESC';
	
	// SEE ONE TICKET BY ID
	if ($_GET['tid'] != '') {
		$where = [
			'ticket_id' => ['=', $ticket_id],
			'username' => ['=', $username]
		];
		$result = select('*', 'support_tickets', [], $where, null, null, $orderBy, 0, 1);
	
	} else if (isset($_POST['email'])) { // SEE ALL TICKETS FOR THIS USERjj
		$where = [
			'email' => ['=', $_POST['email']],
			'datetime' => ['>', $too_old]
		];
		$result = select('*', 'support_tickets', [], $where, null, null, $orderBy, 0, 1);
		
	} else if (isset($_SESSION['loggedin'])) { // SEE ALL TICKETS FOR THIS USER
		$where = [
			'username' => ['=', $username],
			'datetime' => ['>', $too_old]
		];
		$result = select('*', 'support_tickets', [], $where, null, null, $orderBy, 0, 1);		
	} 
	

$buffer = isset($result[0]) ? $result[0] : null;
	$rows = is_array($result) ? count($result) : 0;	
	
	
	$buffer['email'] = strtolower($buffer['email']);	
	$ticket_id = $buffer['ticket_id'];


if ($_GET['tid'] != '' && $ticket_id != $_GET['tid']) {
	$buffer['username'] = '';
	$buffer['email'] = '';
}
/* // DEBUG
echo $qry."<br/><br/>";
print_r($buffer);
exit; */

// QQQ FOR BLUE THEME
echo '<p>&nbsp;</p><p>&nbsp;</p>';

//print_r($buffer);

// CREATE SIMPLE RANDOM CAPTCHA NUMBERS
if (empty($_SESSION['captcha'])) {

	$_SESSION['captcha'] = rand(111,999);
	if ($_SESSION['captcha'] == 665 + 1) $_SESSION['captcha'] = 777;
	$captcha_password = $_SESSION['captcha'];
} else {
	$captcha_password = $_SESSION['captcha'];
}

function autolink($str, $attributes=array()) {
    $attrs = '';
    foreach ($attributes as $attribute => $value) {
        $attrs .= " {$attribute}=\"{$value}\"";
    }
    $str = ' ' . $str;
    $str = preg_replace('`([^"=\'>])((http|https|ftp)://[^\s<]+[^\s<\.)])`i','$1<a href="$2"'.$attrs.'>$2</a>',$str);
	$str = substr($str, 1);
	return $str;
}

$error_msg = '';
$_POST['captcha'] = trim($_POST['captcha']);
//print_r($_POST);

if ($_GET['tid'] != '' && $_POST['reply'] == '') {
   	$error_msg1 = 'Please enter your reply in the text area, below.';
} else if ($_GET['tid'] != '' && $_POST['reply'] != '' && ($_POST['captcha'] != $captcha_password)) {
   	$error_msg = 'Please enter the Captcha number: '.$captcha_password.' to pass the human test.';
}
//$error_msg = 'iiiiiiii';
//echo 'xxx POST CAPTCHA: '.$_POST['captcha'];
//echo $captcha_password;	

if (!empty($error_msg)) { 
	echo '<div class="table-responsive" style="background-color:#fff; text-align:center"><h3 style="color:red">'.$error_msg1.'</h3></div>';
}	

	
if (empty($_POST['id']) && empty($_SESSION['loggedin']) && $buffer['username'] != '') {
	
	/*
	echo '<div style="text-align:center"><h2>Please login to view tickets<h2>';
	echo '<a href="login.php?rd=ticket-thread.php">Login here.</a></div>';
	include 'footer.php'; 
	exit;*/
	//$visitor_is_member = true;
	header('Location: login.php?rd=ticket-thread.php');	

} // REMOVED ELSE COND 7/20/18
if (empty($_POST['id']) && $_GET['action'] != 'reply' && (empty($_SESSION['loggedin']) || $buffer['username'] == '') && ($buffer['email'] == '' || $email != $buffer['email'])) { // USER HAS NO ACCOUNT LISTED IN TICKET - USE THEIR EMAIL AS VERIFIER

	if (empty($_SESSION['loggedin']) && $buffer['idx'] == '') {
		echo '<p>&nbsp;</p><p>&nbsp;</p>';
		//print_r($buffer);
	?>

	<div class="form-group col-md-6 col-md-offset-3" style="text-align:center">	
	<h2>Members <a href="login.php?rd=ticket-thread.php">please login</a> to view tickets</h2>
	<p>&nbsp;</p>

	<?php if (true || $visitor_is_member != true) { ?>
	<h2>Not a member? Please enter your email.<h2>
	<form method="post" action="ticket-thread.php">
	<input name="email" type="text" class="form-control"/>
	<input type="submit" value="Submit!" class="btn btn-info btn-default" /></form>	
	<?php } ?>
	</div>
	<div class="clearfix"></div>

	<?php
		echo '<p>&nbsp;</p><p>&nbsp;</p>';
		include 'footer.php'; 
		exit;
	}
}

// CREATE AND EMAIL THE TICKET REPLY
if ($_POST['reply'] != '' && $_GET['tid'] != '' && $error_msg == '') {
	
	// GET FIRST TICKET WITH THIS ID -- TO GET THE CORRECT SENDING NAME!!
	$selectFields = ['*']; // Select all fields
	$mainTable = 'support_tickets'; // From support_tickets table
	$where = ['ticket_id' => ['=', $ticket_id]]; // Where ticket_id matches
	$orderBy = 'idx ASC'; // Order by idx in ascending order
	$limit = 1; // Limit to 1 record
	$show_debug = 1; // Assuming you want to enable debugging for this query

	// Execute the select query using the PHPCPR select function
	$resultrep = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, $show_debug);
	$bufferrep = isset($resultrep[0]) ? $resultrep[0] : null;

	// Assuming select returns an array of results, you can access the first (and only) result like so:
	if (empty($resultrep)) {
		// Handle the case where no records are found
		echo 'No Ticket found'; exit;
	}

	$ticket_id = $bufferrep['ticket_id'];
	$new_status = 'open';
	$email = $bufferrep['email'];
	$subject = $bufferrep['subject'];
	$message = $bufferrep['message'];
	$priority = $bufferrep['priority'];
	$username = $bufferrep['username'];
	$loggedin = $_SESSION['loggedin'];
	
	$name = $bufferrep['name'];
	$email_reply = $email;	
	
/*	
	if ($_POST['send_to'] == 'user') {
		$name = 'Admin Reply';
		$email_reply = $email;
	} else if ($_POST['send_to'] == 'support') {
		$name = 'Internal To Support';
		// QQQ SET SUPPORT EMAIL
		$email_reply = 'tech@automaticwebsoftware.com';
		$new_status = 'pending';
	} else if ($_POST['send_to'] == 'admin') {
		$name = 'Internal To Admin';
		$email_reply = $Global['admin_email'];
		$email_reply = 'jim.symonds@automaticwebsoftware.com';
		// QQQ $email_reply = 'easy1uphelp@gmail.com';
		$new_status = 'pending';		
	}
*/	
		
	$reply = $_POST['reply'];
	$reply = htmlspecialchars(trim($reply));
	$priority = $_POST['priority'];	
	//echo 'new status '.$new_status;
	//echo $reply;
	//exit;
		
	$HTTP_USER_AGENT = isset($_SERVER['HTTP_USER_AGENT']) ? sanitize($_SERVER['HTTP_USER_AGENT'], 'HTTP_USER_AGENT') : '';
	$HTTP_REFERER = isset($_SERVER['HTTP_REFERER']) ? sanitize($_SERVER['HTTP_REFERER'], 'HTTP_REFERER') : '';
	$REMOTE_HOST = isset($_SERVER['REMOTE_HOST']) ? sanitize($_SERVER['REMOTE_HOST'], 'REMOTE_HOST') : '';
	$REMOTE_ADDR = isset($_SERVER['REMOTE_ADDR']) ? sanitize($_SERVER['REMOTE_ADDR'], 'REMOTE_ADDR') : '';	

	$datetime = date("Y-m-d H:i:s");
	
$data = [
    'ticket_id' => $ticket_id ?? '',
    'status' => $new_status ?? '',
    'name' => $name ?? '',
    'username' => $username ?? '',
    'loggedin' => $loggedin ?? '',
    'email' => $email ?? '',
    'sent_to' => $email_reply ?? '',
    'subject' => $subject ?? '',
    'message' => $reply ?? '',
    'interest' => $interest ?? '',
    'datetime' => $datetime ?? '',
    'priority' => $priority ?? '',
    'ip' => $REMOTE_ADDR ?? '',
    'HTTP_USER_AGENT' => $HTTP_USER_AGENT ?? '',
    'HTTP_REFERER' => $HTTP_REFERER ?? '',
    'REMOTE_HOST' => $REMOTE_HOST ?? ''
];


// Since you prefer $live=1 and $debug=1, adjust these as needed
insert('support_tickets', $data, 1, 1);

	
	// UPDATE ALL THREADS WITH SAME TICKET ID TO THE NEW STATUS!
$updateData = [
    'status' => $new_status,
    'priority' => $priority
];

// Conditions for the update
$whereConditions = [
    'ticket_id' => ['=', $ticket_id]
];

// Again, assuming you want debugging and live execution
update('support_tickets', $updateData, [], $whereConditions, 1, 0, 1);
	

	$text = $_POST['reply'];
	
	$url = $Global['webpage_url'].'ticket-thread.php';
		
	$reply = "Your ticket response has been received. We will respond as soon as possible.
	
	If you have additional information to add to this ticket, please use the link below.
	
	==
	
	{$text}
	
	Ticket Issue: {$message}
	
	Please do not respond to this email. It will not be seen. Please review or reply to this ticket at the URL below:
	
	{$url}";
	
	//echo $reply;
	//exit;
	
	if ($Global['use_sendgrid'] == true) {
		$_SESSION['ticket-reply'] = true;
		include './sendgrid.inc.php'; // load sendgrid functions if using them
	}
	$subject = $Global['webpage_name'].' Support Ticket '.$ticket_id.' - '.$subject;
	$email = $email_reply;

	$subject = isset($subject) ? html_entity_decode($subject) : '';
	$reply = isset($reply) ? html_entity_decode($reply) : '';

// SENDING THE REPLY TO THE USER - CONFIRMATION AND LETS THEM UPDATE THE TICKET IF NEEDED.	
	if ($Global['use_sendgrid'] == true) {
		sendgrid_email($email, $subject, $reply);
			//echo "<br />";
			//echo $email."<br />";
			//echo $subject."<br />";
			//echo $reply."<br />";
	} else {
		mail($email, $subject, $reply, "From: {$Global['admin_email_heading']} <{$Global['admin_email']}>");
	}
	
	echo '<div class="" style="background-color:#fff; text-align:center"><p>&nbsp;</p><h1>Success!</h1>';
	echo '<h2>We\'ll get back to you as soon as possible.</h2> <h2><a href="ticket-thread.php?tid='.$ticket_id.'">You may view your ticket here.</a></h2><p>&nbsp;</p><p>&nbsp;</p><p>&nbsp;</p><br/></div>';
	
	$_POST['reply'] = '';
	unset($_SESSION['captcha']);
	include 'footer.php';
	exit;
}
	
if ($_GET['action'] == 'reply') { 
	// MAIL REPLY FORM HERE!
?>
<div class="col-md-6 col-md-offset-3 col-xs-12" style="background-color:#fff; text-align:center">
<h2 style="color:#000000">Ticket ID <?php echo $ticket_id; ?> Email Reply</h2>

<form enctype="multipart/form-data" method="post" action="ticket-thread.php?action=reply&tid=<?php echo $ticket_id; ?>">

<input type="hidden" name="id" value="<?php echo $idx; ?>" />
<!--
<select name="send_to" class="form-control">
<option value="user">Reply To User</option>
<option value="support">Send To Priority Support Team</option>
<option value="admin">Send To Admin</option>
</select><br />
-->
<div class="form-group"> 
<div class="text-left"></div>
<textarea class="form-control" rows="10" cols="50" required="required" name="reply"><?php echo ((!empty($_POST['reply']))?$_POST['reply']:'');?></textarea>
</div>

					  <div class="form-group">
					    <label for="subject">Captcha</label>
<span id="error_captcha" style="color:red; background-color:yellow; font-weight:bold"><?php echo $error_msg; ?></span>						
					  <input type="text" name="captcha" id="captcha" class="form-control" placeholder="Enter Code: <?php echo $captcha_password; ?>" required="required" value="<?php if (!empty($_POST['captcha'])) echo $_POST['captcha']; ?>" maxlength="10">
					  </div>


<div class="panel-body">
Priority:        <label class="radio-inline">
			                <input type="radio" name="priority" value="Low" <?php if ($_POST['priority'] == 'Low') echo 'checked=""';?>> Low
			              </label>
			              <label class="radio-inline">
			                <input type="radio" name="priority" value="Normal" <?php if ($_POST['priority'] == '' || $_POST['priority'] == 'Normal') echo 'checked=""';?>> Normal
			              </label>
			              <label class="radio-inline">
			                <input type="radio" name="priority" value="High" <?php if ($_POST['priority'] == 'High') echo 'checked=""';?>> High
			              </label>						  
						  
			            </div>
						
						
						
<!--
<div style="color:red">
*Note: reponding to this ticket will re-open the ticket.
<br> 
</div>
-->

<br />
<input type="submit" value="Send Email" name="Send Email" class="btn btn-info btn-default">
</form>
<br/>
</div>
<div class="clearfix"></div>
<?php } ?> 

 <div class="table-responsive" style="background-color:#fff">
 <h3>Ticket History</h3>
 <?php
 	if ($rows == 0) {
		echo '<p>&nbsp;</p><p>&nbsp;</p>';
		echo '<h3 style="text-align:center">NO RESULTS</h3>';
		echo '<p>&nbsp;</p><p>&nbsp;</p>';
		echo '<p>&nbsp;</p><p>&nbsp;</p></div>';
		include 'footer.php';
		exit;
	}
	?>
  <table class="table table-striped responsive" style="padding:10px">
    <thead>
      <tr>
        <th>ID</th>
        <th>Status</th>
		<th>Name</th>
        <th>Username</th>		
        <th>Subject</th>
        <th>Date</th>	
        <th>Priority</th>
		
<?php if ($_GET['action'] != 'reply') { ?> 		
        <th>Reply</th>
	
<?php } ?> 		
      </tr>
    </thead>
    <tbody>

<?php
if ($rows > 0) {
foreach ($result as $buffer) {

		if ($buffer['status'] == 'open') {
			$label = 'success';
		} else if ($buffer['status'] == 'pending') {
			$label = 'info';
		} else if ($buffer['status'] == 'closed') {
			$label = 'warning';
		} else {
			$label = 'info';	
		}	
?>	
		  <tr>
			<td>
			<!--
			<a href="ticket-thread.php?action=reply&id=<?php echo $buffer['idx']; ?>">
			<?php echo $buffer['ticket_id']; ?>
			</a>
			-->
			<?php echo $buffer['ticket_id']; ?>
			</td>
			<td style="vertical-align:middle"><span class="label label-<?php echo $label; ?>"><?php echo strtoupper($buffer['status']); ?></span></td>
			<td><?php echo $buffer['name']; ?></td>
			<td>
			<?php if ($_SESSION['admin_login'] == true) { ?>
			<a href="./admin/Sub/ticket.php?tid=<?php echo $ticket_id;?>" target="_blank"><?php echo $buffer['username']; ?></a>
			<?php } else if ($_SESSION['loggedin'] != '' && $_SESSION['loggedin'] == $buffer['username']) { ?>
			<a href="Members/index.php" target="_blank"><?php echo $buffer['username']; ?></a>
			<?php } else { ?>
			<a href="login.php?rd=ticket-thread.php" target="_blank"><?php echo $buffer['username']; ?></a>
			<?php } ?>						
			</td>		
			<td><?php echo isset($buffer['subject']) ? html_entity_decode($buffer['subject']) : ''; ?></td>
			<td><?php echo $buffer['datetime']; ?></td>	
			<td><?php echo $buffer['priority']; ?></td>		

<?php if ($_GET['action'] != 'reply') { ?> 
        <td style="vertical-align:middle"> 
		<a href="ticket-thread.php?action=reply&tid=<?php echo $buffer['ticket_id']; ?>"><span class="label label-info">REPLY</span></a>
		</td>				
<?php } ?>
			
      </tr>
	  
<tr class="child">
     <td colspan="9">
      <table class="table">
         <tr>
            <td colspan="9"><?php 
				$message = isset($buffer['message']) ? html_entity_decode($buffer['message']) : '';
				$message = stripslashes($message);
				$message = autolink($message, array("target"=>"_blank","rel"=>"nofollow"));
				echo nl2br($message); // <a href="http://example.com/" target="_blank" rel="nofollow">http://example.com/</a>
				?>
			
			
			<p>&nbsp;</p>
			
			<?php if ($buffer['status'] == 'closed') {
				
				// QQQ ADD FEEDBACK RATING HERE
				
				echo '<hr><h3 style="color:red">Issue not resolved?</h3>';
				echo '<i>Replying to any ticket will re-open the ticket. Please only <a href="contact.php?id='.$SponsorID.'">submit new tickets</a> for new issues. Thank you!</i>';
				
			} else if ($buffer['status'] == 'open' || $buffer['status'] == 'pending') {
				
				// QQQ ADD FEEDBACK RATING HERE
				
				echo '<hr><h3 style="color:red">Has this issue been resolved?</h3>';
				echo '<i>If this matter no longer needs to be addressed, please &nbsp;<a href="ticket-thread.php?tid='.$buffer['ticket_id'].'&action=close" class="btn btn-info">close this ticket now. Thank you!</a></i>';
				
			}			
			?>		
			</td>
          </tr>
      </table>
	  <!--
	  <p>&nbsp;</p>
	  -->
     </td>
</tr>			
	
<?php	} // END WHILE LOOP
} // $rows
?>

<?php if ($_SESSION['loggedin'] != '' || $ticket_id != '') { 
//echo '<a href="Members/logout.php" target="_blank">Logout here.</a></div>';
}
?>

    </tbody>
  </table>
</div> 	

<?php include 'footer.php'; ?>