<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './cookie.php';
$pageName = 'unsub_ar';
$pageAlign = 'center';
$pageClass = 'leadcap';
$this_page_name = 'unsubscribe_ar.php';
include './header.php';
include 'admin/admin_ip_checker.inc.php';
//$_SESSION['lead_signed_up'] = false;
$_SESSION['lead_signed_up'] = true;
$unsub_msg_end = '.';

$datetime = date("Y-m-d H:i:s");

/*if ($admin_ip == true) { // ADMIN'S IP!
	// ADMIN IS UNSUBBING AN UNDELIVERABLE - DON'T FORCE CONFIRMATIONS!
	$_GET['confirm'] = 'Y';
	$unsub_msg_end = '&nbsp;this user.';
}*/

// Assuming $_GET['hash'] is already sanitized and validated before this point

// Get the lead info from the DB
$selectFields = ['ID', 'ar_leads_firstname', 'ar_leads_lastname', 'ar_leads_email', 'ip', 'ar_leads_phone', 'ar_leads_date', 'ar_leads_id'];
$mainTable = 'ar_leads';
$where = [
    'ar_leads_md5' => ['=', $_GET['hash']],
    'ar_leads_status' => ['=', 1]
];
$limit = 1;

$result = select($selectFields, $mainTable, [], $where, null, null, null, $limit);
$buffer = isset($result[0]) ? $result[0] : null;

$_SESSION['page_name'] = $buffer['ar_leads_firstname'];
$_SESSION['page_lastname'] = $buffer['ar_leads_lastname'];
$_SESSION['page_email'] = $buffer['ar_leads_email'];
$_SESSION['page_phone'] = $buffer['ar_leads_phone'];

// Find the sponsor
$selectFields = ['First_Name, Last_Name, Username'];
$mainTable = 'members';
$where = ['ID' => ['=', $buffer['ID']]];

$limit = 1;
$show_debug = 1;	
$result = select($selectFields, $mainTable, [], $where, null, null, null, $limit, $show_debug);
$buffer2 = isset($result[0]) ? $result[0] : null;


$SponsorID = $buffer2['Username'];

$msg = '';

$show_upsell = false;

//check if we have a hash param passed & a record to unsub
if (!empty($_GET['hash']) && empty($buffer['ar_leads_id'])) {

	$msg = 'You have already unsubscribed';
	$msg .= $unsub_msg_end;
	
	$show_upsell = true;

} else if (empty($_GET['hash'])) {

	$msg = 'There was a problem with this request. Please contact us for assistance, to unsubscribe you.';
	$show_upsell = true;
}
	

if (isset($_GET['confirm']) && $_GET['confirm'] == 'Y') {
	$ar_lead_id = $buffer['ar_leads_id'];
	//update the leads status to unsubscribed
	$table = 'ar_leads';
	$data = ['ar_leads_status' => 3];
	$where = ['ar_leads_id' => ['=', $ar_lead_id]];
	$live = 1;
	$limit = 1;
	$show_debug = 1;

	update($table, $data, [], $where, $live, $limit, $show_debug);
	
	$msg = 'You have successfully unsubscribed from our mailing list';
	$msg .= $unsub_msg_end;
	$show_upsell = true;

	$_SESSION['lead_signed_up'] = false;
	$_SESSION['page_name'] = '';
	$_SESSION['page_lastname'] = '';
	$_SESSION['page_email'] = '';
	$_SESSION['page_phone'] = '';
	$headline = 'Removal Complete';

	if ($_GET['leave']== 'Y') {
		
		$email = $buffer['ar_leads_email'];
		$selectFields = ['ID', 'Username', 'email'];
		$mainTable = 'members';
		$where = [
			'OR' => [
				'Username' => $email,
				'email' => $email,
				'bounced_email' => $email
			]
		];
		$limit = 1; // Expecting a single result
		$show_debug = 1; // Set to 1 to enable debugging, or 0 to disable

		// Execute the query using PHPCPR's select function
		$result = select($selectFields, $mainTable, [], $where, null, null, null, $limit, $show_debug);
		
		if ($result) {
			foreach ($result as $row) {
				//$vars = create_vars($row);
				//show_vars($vars);   // This will print the variables created from create_vars.
				$uname = $row['Username'];
				$cancel_ID = $row['ID'];
			}
			//echo 'ID: ' . $row['ID'] . ' Username: ' . $row['Username'] . ' Email: ' . $row['email'] . '<br>';
		}

		if (isset($uname)) { // THIS EMAIL IS A MEMBER, LET'S CANCEL THEM NOW!
		
			$_POST['cancel_reason'] = '';
			$_POST['cancel_reason2'] = '';		
		
			// CANCEL ALL PROGRAMS
			$data = [
				'end_program' => 'Y',
				'user_status' => 'Cancelled',
				'cancelled_by' => 'member',
				'date_cancelled' => $datetime, // Ensure $datetime is properly formatted and sanitized
				'cancel_reason' => $_POST['cancel_reason'], // Sanitization needed if used directly
				'cancel_reason2' => $_POST['cancel_reason2'] // Sanitization needed if used directly
			];
			$where = [
				'ID' => ['=', $cancel_ID],
				'user_status' => ['NOT IN', ['Unpaid', 'Cancelled', 'Active']]
			];
			update('user_program', $data, [], $where, 1, 0, 1);
			
			
			if ($Global['use_E4'] === true) { // CANCEL E4 REBILLING IN ALL PROGRAMS // PAYING AND RECEIVING!!!!
				// Cancel E4 rebilling - paying
				$data = ['active' => 'N'];
				$where = ['id_paying' => ['=', $cancel_ID]];
				update('e4_arb', $data, [], $where, 1, 0, 1);

				// Cancel E4 rebilling - receiving
				$where = ['id_receiving' => ['=', $cancel_ID]];
				update('e4_arb', $data, [], $where, 1, 0, 1);
			}
			
			
			//$pw = 'CANCELLED'.$number;
			// SET STATUS TO CANCELLED	
			$data = [
				'Status' => 'Cancelled',
				// Uncomment the next line to reset the password
				// 'password' => $pw // Ensure $pw is properly prepared and sanitized
			];
			$where = ['ID' => ['=', $cancel_ID]];
			update('members', $data, [], $where, 1, 1, 1);
			
			
			// MOVE ALL THIS USER'S DOWNLINE TO THEIR UPLINE!
			//mysql_query("UPDATE members SET sponsorid='".$real_sponsorid_temp."' WHERE sponsorid='".$real_username_temp."'") or die(mysql_error());
			//echo "The user has now been cancelled out of the system!"; 
			//echo "All of his/her downline have been moved to the upline.";
			//echo "<p>&nbsp;</p>";
			
			// CANCEL USER IN MATRIX
			$data = ['active' => 'N'];
			$where = [
				'usrid' => ['=', $cancel_ID]
			];
			update('matrix', $data, [], $where, 1, 1, 1);
			$msg = 'You have been completely removed from '.$GLOBALS['webpage_name_short'];
			$msg .= $unsub_msg_end;
		} // END IS A USER
	} // END GET LEAVE	
} else {
	
	if ($msg == '') $headline = 'Unsubscribe '.$buffer['ar_leads_firstname'].'?';
}
//$upsell = '<h3><a href="https://.com" style="text-decoration:underline">Have you seen QQQ.com?<br/><br/></a></h3>';
$upsell = '';
?>
<br>
<!-- *****************************************************************************************************************
	 BLUE WRAP
	 ***************************************************************************************************************** -->
	<div id="blue">
	    <div class="container">
			<div class="row">
				<h3><?php echo $headline; ?></h3>
			</div><!-- /row -->
	    </div> <!-- /container -->
	</div><!-- /blue -->
<div class="clearfix"></div>
<div style="text-align:center">
<?php 
//print_r($buffer);
//echo '<p></p>';

if ($msg == '' && $buffer['ar_leads_id'] != '') echo '<h3>Are you sure you want to leave our email updates list, '.$buffer['ar_leads_firstname'].'?'; ?>

<?php if ($msg == '') { ?>
<br/><br/>

<a href="<?php echo $this_page_name; ?>?hash=<?php echo $_GET['hash']; ?>&confirm=Y&leave=Y" target="_blank" class="btn btn-danger btn-lg">Remove me completely from <?php echo $GLOBALS['webpage_name_short']; ?></a>

<a href="<?php echo $this_page_name; ?>?hash=<?php echo $_GET['hash']; ?>&confirm=Y" target="_blank" class="btn btn-danger btn-lg">Remove me ONLY from this list</a>


<br/><br/>
<h3>Well, hang on. I'll take another <a href="/?id=<?php echo $buffer2['Username']; ?>" style="text-decoration:underline">look around</a>, and maybe stay a while longer.</h3>

<br/><br/>

<br/>

<h4>You signed up for our mailing list on <?php echo $buffer['ar_leads_date']; if ($buffer['ip'] != '') echo ' from IP Address: '.$buffer['ip']; ?>.

<!-- HIDING FOR PRIVACY CONCERNS - AGAINST SCRAPERS
<h4>The email address you used was: <?php //echo $buffer['ar_leads_email']; ?>.</h4>
-->

<?php if ($buffer2['Username'] != 'admin') { ?>
<br>You were referred by <?php echo $buffer2['First_Name'].' '.$buffer2['First_Name'].' username: '.$buffer2['Username']; ?>.
<?php } ?>

</h4>
<?php
} else {
	echo '<h3>'.$msg.'</h3>';
	if ($show_upsell == true) echo $upsell;
	echo '<br/><br/><br/>';
}
?>	

</div>

<?php include 'footer.php'; ?>

