<?php
//---------------------------------------------------------------------
//Made by: Sven Arild Helleland 
//Firm: Kaizen Web-Productions (http://www.kaizen-web.com)
//Date: 12th September 2007
//Last Modified: 13th September 2007								
//Copyright(C), Kaizen Web-Productions, 2004-2007, All Rights Reserved.
//---------------------------------------------------------------------
error_reporting(0);

include './../Sub/Config.inc.php';

define('IPN_PROCESS', true);

include $Global['path'].'Ipn/Lib/Google_checkout.class.php';

$payment_processor = 'GC'; //E = E-Gold
$payment_processor_name = 'Google Checkout'; //The name of the payment processor

$received_ip = $_SERVER['REMOTE_ADDR'];
$received_dns = @gethostbyaddr($received_ip);	
$received_var	= '';

if (isset($HTTP_RAW_POST_DATA)) $xml_response = $HTTP_RAW_POST_DATA;
else $xml_response = file_get_contents("php://input");

if (get_magic_quotes_gpc()) {
	$xml_response = stripslashes($xml_response);
  }

if (empty($xml_response)) {
	/**
	 * Someone entered the url directly with no post data set. 
	 * Terminate the page without logging.
	 * 
	 */

	header("HTTP/1.0 504 Gateway Timeout");
	exit;
	}

//Check if .htaccess has forwarded the HTTP Header Authorization information, if populate it into the server array	
if (!empty($_GET['authorization']))	$_SERVER['HTTP_AUTHORIZATION'] = $_GET['authorization'];	
	
//Initiate the Google Checkout class, since we do not know the merchant id or key yet leave them blank
$GC = new google_checkout('', '', $Global['GC_currency'], $Global['test_mode'], $Global['GC_merchant_id']);

//Parse the XML
list($response, $data) = $GC->parse_xml($xml_response);

//Find order and serial number, if it dont exist someone is beeing naughty
$order = $GC->find_order_number($data[$response]);

if ($order === false) {
	/**
	 * Someone entered the url with post data set, but without Google Checkout Order Number and/or Serial Number.
	 * Terminate the page with logging. 
	 * Logging the data to exploit how they try to hack the script, allowing us to further prevent it in the future.
	 */
	
	//Log the information
	$query = "INSERT INTO gc_history SET order_number='', initiated_date=NOW(), error='hack', hack_error='".mysql_escape_string(Serialize($data))."'";
	
	mysql_query($query);
	
	//Error handeler
	if (mysql_errno()) ipn_api_query_error("./Error/GC_info.txt", $query, mysql_errno(), mysql_error(), $received_ip, $received_dns, $received_var);
	
	header("HTTP/1.0 504 Gateway Timeout");
	exit;
	}

if ($response == 'new-order-notification') {
	/**
	 * If its a new order, add to history table and find the receiving users information
	 */
	
	$plan_info = explode(':', $data[$response]['shopping-cart']['items']['item']['merchant-item-id']['value']);
		
	$query = "SELECT plan.payment_plan_id, memb.ID, memb.gc_id, memb.gc_key FROM payment_plan as plan LEFT JOIN members as memb ON plan.username=memb.Username WHERE plan.payment_plan_id=".(int) $plan_info[1];
	
	$result = mysql_query($query);
	
	//Error handeler
	if (mysql_errno()) ipn_api_query_error("./Error/GC_info.txt", $query, mysql_errno(), mysql_error(), $received_ip, $received_dns, $received_var);
	
	$buffer = mysql_fetch_assoc($result);
	
	if (!empty($buffer['payment_plan_id'])) {
		$query = "INSERT INTO gc_history SET payment_plan_id=".$buffer['payment_plan_id'].", order_number='".mysql_escape_string($order['order_number'])."', amount=".(float) $data[$response]['order-total']['value'].", buyer_account='".mysql_escape_string($data[$response]['buyer-id']['value'])."', initiated_date=NOW()";
		
		mysql_query($query);
	
		//Error handeler
		if (mysql_errno()) ipn_api_query_error("./Error/GC_info.txt", $query, mysql_errno(), mysql_error(), $received_ip, $received_dns, $received_var);
			
		$gc_history_id = mysql_insert_id();
		$gc_sucecss = 'N';
		$gc_failure = false;
		$gc_payer_account = $data[$response]['buyer-id']['value'];
		
		$member_id = $buffer['ID'];
		$payment_plan_id = $buffer['payment_plan_id'];
		
		$merc_id = $buffer['gc_id'];
		$merc_key = base64_decode($buffer['gc_key']);
		}
	
	//Set the merchant id and key, if it does not exist make it false
	$GC->update_info(((!empty($merc_id))?$merc_id:false), ((!empty($merc_key))?$merc_key:false));
	}
else {
	/**
	 * Find the receiving users information
	 */
	$query = "SELECT history.gc_history_id, history.amount, history.buyer_account, history.success, history.error, plan.payment_plan_id, memb.ID, memb.gc_id, memb.gc_key FROM gc_history as history, payment_plan as plan, members as memb WHERE history.order_number='".mysql_escape_string($order['order_number'])."' && history.payment_plan_id=plan.payment_plan_id && plan.username=memb.Username";
	
	$result = mysql_query($query);
	
	//Error handeler
	if (mysql_errno()) ipn_api_query_error("./Error/GC_info.txt", $query, mysql_errno(), mysql_error(), $received_ip, $received_dns, $received_var);
	
	$buffer = mysql_fetch_assoc($result);
	
	if (!empty($buffer['payment_plan_id'])) {
		$gc_history_id = $buffer['gc_history_id'];
		$gc_amount = $buffer['amount'];
		$gc_sucecss = $buffer['success'];
		$gc_failure = ((!empty($buffer['error']))?true:false);
		$gc_payer_account = $buffer['buyer_account'];
		
		$member_id = $buffer['ID'];
		$payment_plan_id = $buffer['payment_plan_id'];
		
		$merc_id = $buffer['gc_id'];
		$merc_key = base64_decode($buffer['gc_key']);
		}
		
	//Set the merchant id and key, if it does not exist make it false
	$GC->update_info(((!empty($merc_id))?$merc_id:false), ((!empty($merc_key))?$merc_key:false));
	}

if ($GC->merchant_id === false || $GC->merchant_key === false) {
	/**
	 * The member has not added the Google Checkout Merchant id or key.
	 * 
	 * Terminate the script
	 */
	
	//Log the transaction
	if (!empty($gc_history_id)) {
		$query = "INSERT INTO gc_info SET gc_history_id=$gc_history_id, serial_number='".mysql_escape_string($order['serial_number'])."', response='".mysql_escape_string($response)."', information='".mysql_escape_string(serialize($data))."', date=NOW(), error='empty_merchant_id_or_key'";
		}
  else {
		$query = "INSERT INTO gc_history SET order_number='".mysql_escape_string($order['order_number'])."', initiated_date=NOW(), error='empty_merchant_id_or_key', hack_error='".mysql_escape_string(Serialize($data))."'";
		}
	
	
	mysql_query($query);
	
	//Error handeler
	if (mysql_errno()) ipn_api_query_error("./Error/GC_info.txt", $query, mysql_errno(), mysql_error(), $received_ip, $received_dns, $received_var);	
		
	$GC->force_header(200); //Set ok header so google does not spam us with the request
	exit;
	}
	
//Check if the merchant id and key match
$status = $GC->verify_request();

if ($status === false) {
	/**
	 * Match failed.
	 * 
	 * Terminate the script.
	 */
	
	//Log the transaction
	if (!empty($gc_history_id)) {
		$query = "INSERT INTO gc_info SET gc_history_id=$gc_history_id, serial_number='".mysql_escape_string($order['serial_number'])."', response='".mysql_escape_string($response)."', information='".mysql_escape_string(serialize($data))."', date=NOW(), error='merchant_match_failed'";
		}
  else {
		$query = "INSERT INTO gc_history SET order_number='".mysql_escape_string($order['order_number'])."', initiated_date=NOW(), error='merchant_match_failed', hack_error='".mysql_escape_string(Serialize($data))."'";
		}
	
	mysql_query($query);
	
	//Error handeler
	if (mysql_errno()) ipn_api_query_error("./Error/GC_info.txt", $query, mysql_errno(), mysql_error(), $received_ip, $received_dns, $received_var);	
		
	$GC->force_header(200);
	exit;
	}

	
/**
 * Process the order information
 */
$process_order = false;
$charge_response = true;
$gc_error = '';
$error = '';

switch ($response) {
  case "request-received":
  	break;
  case "error":
  	break;
  case "diagnosis":
    break;
  case "checkout-redirect":
    break;
  case "merchant-calculation-callback":
    break;
  case "new-order-notification":
  	//First notification that is sent on an order
  	
  	//Make certain the order contain the correct amount
  	
    //First find out if its an admin collect everything or a normal payment
    $result = mysql_query("SELECT real_prog.program_collect FROM payment_plan as plan LEFT JOIN user_payment_plan as master USING (user_payment_plan_id) LEFT JOIN user_program as prog ON (master.user_program_id=prog.user_program_id) LEFT JOIN program as real_prog ON (prog.program_id=real_prog.program_id) WHERE plan.payment_plan_id=$payment_plan_id") or die(mysql_error());
    
    $buffer = mysql_fetch_assoc($result);
    
    $admin_collects = false;
	$admin_collects_tiers = false;
    
     if ($buffer['program_collect'] == 'A' || $buffer['program_collect'] == 'EAT') {
      if (!function_exists('admin_collects')) include $Global['path'].'Sub/payment_collect.inc.php';
      
      $admin_collects = ($buffer['program_collect'] == 'A') ? true:false;
      
	  $admin_collects_tiers = ($buffer['program_collect'] == 'EAT') ? true:false;
	  
	  if ($admin_collects === true) $value = admin_collects_single($payment_plan_id);
	  else $value = admin_collects_single_tiers($payment_plan_id);
      
      $result = mysql_query("SELECT amount, grace_amount FROM payment_plan WHERE payment_plan_id=$payment_plan_id") or die(mysql_error());
  	
  	  $buffer = mysql_fetch_assoc($result);
  	  
  	  $buffer['amount'] = $value['amount'];
      }
    else {  
  	  $result = mysql_query("SELECT amount, grace_amount FROM payment_plan WHERE payment_plan_id=$payment_plan_id") or die(mysql_error());
  	
  	  $buffer = mysql_fetch_assoc($result);
      }
  	
  	if (number_format(($buffer['amount'] + $buffer['grace_amount']), 2) > number_format($data[$response]['order-total']['value'], 2)) $gc_error = 'amount';
  	elseif ($Global['GC_currency'] != $data[$response]['order-total']['currency']) $gc_error = 'currency';
    break;
  case "order-state-change-notification":
		//Sent when there is a change in the order billing status
		
		//Only continue processing the order if there has been no major errors!
		if ($gc_failure === false) {
	    switch ($data[$response]['new-financial-order-state']['value']) {
	      case 'REVIEWING':
	        break;
	      case 'CHARGEABLE':    
	      	//Received if the order can be charged	
	      	
	      	/**
	      	 * ARRRRG... similar to this line should be used on all other types! For some reason the demo code or manual from Google did not take this into consideration,
	      	 * which again mean that the code/manual has a flaw. However the flaw is only "visible" when you do not send a 200 header each time the reply comes. 
	      	 * With other words the error happens in the demo code, but since it sends a 200 header every time it happens in the background. If you send a error header,
	      	 * like here, Google will keep sending the response for 30 days :P 
	      	 * 
	      	 * Hence remember to add similar functionality if the other cases are to be used!
	      	 */
	      	if ($data[$response]['previous-financial-order-state']['value'] != 'CHARGEABLE') { 
	        	$process_response = $GC->process_order($order['order_number']);
	        	$charge_response = $GC->charge_order($order['order_number'], $gc_amount);
	       
	        	if ($process_response === false) $error = 'process_order';
	        	elseif ($charge_response === false) $error = 'charge_order';
	      		}
	        break;
	      case 'CHARGING':
	        break;
	      case 'CHARGED':
	        break;
	      case 'PAYMENT_DECLINED':
	        break;
	      case 'CANCELLED':
	        break;
	      case 'CANCELLED_BY_GOOGLE':
	        break;
	      default:
	        break;
	    	}
	
	    switch ($data[$response]['new-fulfillment-order-state']['value']) {
	      case 'NEW':
	        break;
	      case 'PROCESSING':
	        break;
	      case 'DELIVERED':
	        break;
	      case 'WILL_NOT_DELIVER':
	        break;
	      default:
	        break;
	    	}
			}
    break;
  case "charge-amount-notification":
  	//Sent if the order has been successfully charged. I.e. final required response
  	
  	//Only continue processing the order if there has been no major errors!
		if ($gc_failure === false) {
	  	if (number_format($gc_amount, 2) <= number_format($data[$response]['total-charge-amount']['value'], 2) && $Global['GC_currency'] == $data[$response]['total-charge-amount']['currency']) {
	    	$finalize_response = $GC->finalize_order($order['order_number'], 'false');
	    	$archive_response = $GC->archive_order($order['order_number']);
	    
	    	if ($finalize_response === false) $error = 'finalize_order';
	    	
	    	if ($archive_response === false) $error = 'archive_order';
	    	
	    	if ($finalize_response === true) $process_order = true;
	  		}
	  	elseif (number_format($gc_amount, 2) > number_format($data[$response]['total-charge-amount']['value'], 2)) {
	  		$gc_error = 'amount2';
	  		}
	  	else {
	  		$gc_error = 'currency2';
	  		}
			}
    break;
  case "chargeback-amount-notification":
    //Received if chargeback
    break;
  case "refund-amount-notification":
    //Received if refunt
    break;
  case "risk-information-notification":
  	//Received after the first notification, can be used to review the risk of the transaction
    break;
  default:
    break;
  }	
	
//Store the current request in the info table 
$query = "INSERT INTO gc_info SET gc_history_id=$gc_history_id, serial_number='".mysql_escape_string($order['serial_number'])."', response='".mysql_escape_string($response)."', information='".mysql_escape_string(serialize($data).'//'.serialize($GC->error))."', date=NOW(), error=".((!empty($error))?"'".mysql_escape_string($error)."'":'NULL');

mysql_query($query);
	
//Error handeler
if (mysql_errno()) ipn_api_query_error("./Error/GC_info.txt", $query, mysql_errno(), mysql_error(), $received_ip, $received_dns, $received_var);
  
//Update the main reference if there is an serious error
if (!empty($gc_error)) {
	$query = "UPDATE gc_history SET closed_date=NOW(), error='".mysql_escape_string($gc_error)."' WHERE gc_history_id=$gc_history_id";
	
	mysql_query($query);
	
	//Error handeler
	if (mysql_errno()) ipn_api_query_error("./Error/GC_info.txt", $query, mysql_errno(), mysql_error(), $received_ip, $received_dns, $received_var);
	}

	
/**
 * Process the payment into the script if the payment has been received successfully
 */
if ($gc_sucecss == 'N' && $process_order === true) {
	
  //First find out if its an admin collect everything or a normal payment
  $result = mysql_query("SELECT real_prog.program_collect FROM payment_plan as plan LEFT JOIN user_payment_plan as master USING (user_payment_plan_id) LEFT JOIN user_program as prog ON (master.user_program_id=prog.user_program_id) LEFT JOIN program as real_prog ON (prog.program_id=real_prog.program_id) WHERE plan.payment_plan_id=$payment_plan_id") or die(mysql_error());
  
  $buffer = mysql_fetch_assoc($result);
  
  $admin_collects = false;
  $admin_collects_tiers = false;
  
   if ($buffer['program_collect'] == 'A' || $buffer['program_collect'] == 'EAT') {
      if (!function_exists('admin_collects')) include $Global['path'].'Sub/payment_collect.inc.php';
      
      $admin_collects = ($buffer['program_collect'] == 'A') ? true:false;
      
	  $admin_collects_tiers = ($buffer['program_collect'] == 'EAT') ? true:false;
    
    //Select the information for the guy receiving the payment	
	  $result = mysql_query("SELECT plan.user_payment_plan_id, plan.amount, plan.grace_enabled, plan.grace_amount, plan.grace_reason, plan.grace_days, plan.payment_type, plan.payment_tier_level, plan.plan_type, memb.Username, memb.First_Name, memb.Last_Name, memb.email, memb.egold, memb.egold_passphrase FROM payment_plan as plan LEFT JOIN members as memb ON (plan.username=memb.Username) WHERE plan.payment_plan_id=$payment_plan_id");
	  	
  	$buffer = mysql_fetch_assoc($result);

  	$set_program_type = $buffer['plan_type'];
    $payment_type = $value['payment_type'];
    $payment_tier = $value['payment_tier_level'];
  	
  	//Find admin information
    $result_admin = mysql_query("SELECT * FROM members WHERE Username='".mysql_escape_string($Global['administrator'])."'") or die(mysql_error());
    
    $buffer_admin = mysql_fetch_assoc($result_admin);
    }
  else {
  	$result = mysql_query("SELECT plan.user_payment_plan_id, plan.amount, plan.grace_enabled, plan.grace_amount, plan.grace_reason, plan.grace_days, plan.payment_type, plan.payment_tier_level, plan.plan_type, memb.Username, memb.First_Name, memb.Last_Name, memb.email, memb.egold, memb.egold_passphrase FROM payment_plan as plan LEFT JOIN members as memb ON (plan.username=memb.Username) WHERE plan.payment_plan_id=$payment_plan_id");
  
  	$buffer = mysql_fetch_assoc($result);

  	$set_program_type = $buffer['plan_type'];
    $payment_type = $buffer['payment_type'];
    $payment_tier = $buffer['payment_tier_level'];
  	
  	//Copy the normal receiver to the admin receiver buffer.				
  	$buffer_admin = $buffer;
    }
  					
	$receiver_username = $buffer_admin['Username'];
	$receiver_email = $buffer_admin['email'];
	$receiver_firstname = $buffer_admin['First_Name'];
	$receiver_lastname = $buffer_admin['Last_Name'];
	
	$user_payment_plan_id = $buffer['user_payment_plan_id'];
	
	$grace_status = $buffer['grace_enabled'];
	$grace_reason = $buffer['grace_reason'];
	$grace_days = $buffer['grace_days'];
								
	//Set the amount to what was paid, this can cause a grace period to be removed, but it should have no effect on the amount owed. Since the user
	//will only receive the time they paid for in any case
	$expected_amount = $gc_amount; //$buffer['amount'] + $buffer['grace_amount'];

	$plan_info = array();
	$total_info['amount'] = 0;
		  					
	//Select payment plan information, i.e. who has been paid, who should be paid etc
	$result = mysql_query("SELECT * FROM payment_plan WHERE user_payment_plan_id=$user_payment_plan_id && (plan_type='S' || plan_type='NS' || (plan_type='N' && payment_period=0)) ORDER BY payment_plan_id ASC");
		  					
	while ($buffer = mysql_fetch_assoc($result))
		{
		$plan_info[$buffer['payment_plan_id']] = array('username' => $buffer['username'], 'status' => $buffer['user_status'], 'amount' => $buffer['amount'], 'type' => $buffer['payment_type'], 'tier' => $buffer['payment_tier_level'], 'complete' => $buffer['sec_payment_complete'], 'date' => $buffer['last_paid_date'], 'first_date' => $buffer['first_paid_date']);
		  								  							
		$total_info['amount'] += $buffer['amount'];
		}
		  					
	//Select payer info and program info
	$result = mysql_query("SELECT user.ID, user.user_status, user.expire, plan.grace_enabled, plan.signup_ip, prog.* FROM user_payment_plan as plan, user_program as user, program as prog WHERE plan.user_payment_plan_id=$user_payment_plan_id && plan.user_program_id=user.user_program_id && user.program_id=prog.program_id");
		  					
	$buffer = mysql_fetch_assoc($result);	
		  					
	$payer_id = $buffer['ID'];
	$payer_status = $buffer['user_status'];
	$payer_signup_ip = $buffer['signup_ip'];
	$payer_expire = $buffer['expire'];
		  							  						  				
	$payer_grace_status = $buffer['grace_enabled'];
		  					  					
	$program_id = $buffer['program_id'];
	$program_name = $buffer['program_name'];
	$program_type = $buffer['program_type'];
	$program_sub_period = $buffer['program_sub_period'];
	$program_powerline = $buffer['program_up'];		
		  					
	if ($program_powerline == 0) $program_powerline = -1;  
		  				
	$expected_program_amount = ($buffer['program_tier_pay'] * $buffer['program_tier']) + $buffer['program_up_pay'] + $buffer['program_admin_pay'];	
		  					
	$payer = $gc_payer_account; //The payment processor id that the person paid with
		  									
	//Log the payment properly, + send out a payment received email
	include $Global['path'].'apay/Logging.inc.php';			  						
	  						
	//Check if eveyone has been paid, if update the account and do arrangements
	$nr = 0;
			  									  						
	foreach ($plan_info as $key => $value) 
		{
		if ($value['complete'] == 'Y' && $key != $payment_plan_id) ++$nr;
		}
			  									  							
	$required_payments = count($plan_info);
			  							
	$total_payments =	$nr + 1;
			  					
	//If every payment has been completed, update the payer information!
	if ($total_payments == $required_payments) include $Global['path'].'apay/Finalize.inc.php';
			  						
		  
	$query = "UPDATE gc_history SET closed_date=NOW(), payment_log_id=$payment_log, success='Y' WHERE gc_history_id=$gc_history_id";
	
	mysql_query($query);
	
	//Error handeler
	if (mysql_errno()) ipn_api_query_error("./Error/GC_info.txt", $query, mysql_errno(), mysql_error(), $received_ip, $received_dns, $received_var);
	
	$GC->force_header(200);
	}
else {
	if ($charge_response === false) {
		/**
		 * Send error header since we did not manage to process the charge data correctly,
		 * note the process order is not vital so we will not terminate on that one.
		 */
		$GC->force_header(400); 
		}
	else { 
		$GC->force_header(200);  //Set ok header so google does not spam us with the request
		}
	}
?>