<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include ''.$_SERVER['DOCUMENT_ROOT'].'/Members/logincheck.php';

// THIS FILE ALLOWS ACCESS IF THE MEMBER IS IN "$allowed_status" IN ANY PROGRAMS LISTED HERE
// USER DEFINED SETTINGS

if (!isset($program_id_array)) {
$program_id_array = array(1); // ADD THE PROGRAM ID's HERE. YOU MAY LIST ONE OR MORE PROGRAMS HERE (SEPARATED BY COMMAS), WHICH THE USER MUST HAVE $allowed_status IN, TO GET ACCESS TO THE PAGE.
} 

if (!isset($allow_any_program)) {
$allow_any_program = false; // SHOULD MEMBER BE ALLOWED ACCESS IF IN "ANY" PROGRAM LISTED IN $program_id_array. IF SET TO FALSE, REQUIRES USERS HAVE "$allowed_status" (BELOW) IN ALL PROGRAMS LISTED IN $program_id_array.
}

if (!isset($allowed_status)) {
$allowed_status = array('Active','Comped','TempComp'); // ALL STATUSES ALLOWED TO HAVE ACCESS. ADD STATUSES ,'Suspended','Cancelled' TO THIS ARRAY IF YOU WANT MEMBERS TO HAVE ACCESS IF THEY WERE EVER AN ACTIVE MEMBER.
}

if (!isset($disallow_grace_period_access)) { 
$disallow_grace_period_access = true; // DISALLOW ACCESS TO USERS IN GRACE PERIOD? true if yes, false is no.
}

// END USER DEFINED SETTINGS


// IF $REDIRECT IS SET FALSE IN THE FILE WHICH USES THIS INCLUDE, WE WILL NOT REDIRECT THE USER, BUT INSTEAD, SHOW THEM CONTENT ON THAT PAGE

if (!isset($redirect) || $redirect != false) {
$redirect = true;
}

/* // DEBUGGING
echo 'redirect';
echo ': ';

if ($redirect == false) {
echo 'false';
} else {
echo 'true';
}
*/


// PRESUME USER CANNOT ACCESS
$allow_access = false;

foreach ($program_id_array as $key) {
	
	$selectFields = ['prog.program_id', 'prog.user_status'];
	$mainTable = ['table' => 'members', 'as' => 'memb'];
	$joinConditions = [
		[
			'table' => 'user_program',
			'as' => 'prog',
			'condition' => 'memb.ID = prog.ID'
		]
	];	

	$where = [
		'memb.Username' => ['=', $_SESSION['loggedin']],
		'prog.program_id' => ['=', $key]
	];

	$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, 0, 1);
	$buffer = $result ? $result[0] : null;
	
	
	if ($_SESSION['debug']) {
		echo "<pre>".$key . ":<br />";
		if ($allow_any_program) echo "Allow Any Program ";
		print_r($allowed_status);
		
		print_r($buffer);
		echo "</pre>";
	}
	if (!in_array($buffer['user_status'], $allowed_status)) { // IF NOT ALLOWED STATUS ON THIS PROGRAM


		if ($allow_any_program == false && $redirect == true) { 
			header ("Location: {$Global['webpage_url_ssl']}{$Global['member_dir']}/unpaid.php?program=$key");
			exit;
		}

	} else { // ALLOWED STATUS ON THIS PROGRAM
			$allow_access = true;
	}

} // END FOR EACH LOOP


if ($allow_access == false && $redirect == true && $program_id != '') { // DISALLOW IF $allow_access is false - USER'S STATUS IS NOT ALLOWED.
		header ("Location: {$Global['webpage_url_ssl']}{$Global['member_dir']}/unpaid.php?program={$program_id}");
		exit;
} else if ($allow_access == false && $redirect == true && $program_id == '') { // DISALLOW IF $allow_access is false - USER'S STATUS IS NOT ALLOWED.
		header ("Location: {$Global['webpage_url_ssl']}{$Global['member_dir']}/unpaid.php");
		exit;
}

?>