<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './logincheck.php'; 

if (isset($_GET['m']) && is_numeric($_GET['m'])) {
	$matlevel = $_GET['m'];
} else {
	$matlevel = 1;
}
$program_id = $matlevel;

// COPIED HERE FOR USE WITH NEW Mat.config.inc.php
function isOnMatrix($usrid, $matlevel=1){

	// $matlevel IS NOT IN USE YET - FOR FUTURE DEV IDEA TO SUPPORT MULTIPLE MATRIX PROGRAMS
	// $matlevel IS REQUIRED FOR OLD 2X2 CYCLER CODE!
	$selectFields = '*';
	$mainTable = 'matrix';
	$where = [
	['usrid' => $usrid],
	['matlevel' => $matlevel]
	];

	// Call the PHPCPR select function	
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
	if ($result) return 1;
	else return 0;
}
$usrid = $_SESSION['UserID'];
include ''.$_SERVER['DOCUMENT_ROOT'].'/Ipn/Give/Mat.config.inc.php'; 

$mat_config = $GLOBALS['mat_config'];
$pageName = $mat_config.' Matrix Viewer'; 
$pageDesc = ''; // IF USED, THIS IS SHOWN AS THE TITLE IN THE PAGE (BLUE BAR SECTION, END OF HEADER), REPLACING $pageName.
$pageIcon = 'fa fa-sitemap'; // THE ICON USED IN THE PAGE
$pageAlign = 'center'; // HOW YOU WANT TO ALIGN THE PAGE CONTENT
$pageClass = ''; // FOR CUSTOM PROGRAMMING USES

// COMMENT WHEN TESTING IS DONE!!!
//$_SESSION['dev'] = '';
/*
if ($_SESSION['admin_login'] != true && $_GET['dev'] == '' && $_SESSION['dev'] == '' && $_SESSION['loggedin'] != '') { // LOCKING PAGE FOR DEVELOPER USE ONLY!!
include_once './header.php';
echo 'We\'re sorry. This area is temporarily down for maintenance. Please check back soon!';
//echo 'Launching soon!';
include_once './footer.php';
exit;
} else {
$do_not_display_ads = true;	
$_SESSION['dev'] = true;
}
*/


//$do_not_display_ads = true;
include './header.php';
$this_page = 'advanced_viewer.php?m='.$matlevel;
$debug = false;
//$debug = true;
$debug2 = false;
//$debug2 = true;
if ($_SESSION['admin_login'] == true) $debug2 = true;
$show_name = false;
//$show_name = true;

$_SESSION['debug'] = false;
//if ($_SESSION['admin_login'] == true) $_SESSION['debug'] = true;

/*if ($_SESSION['admin_login'] != true && $_SESSION['UserID'] > 4 && $_SESSION['loggedin'] != 'fisherman' && $_SESSION['loggedin'] != 'fisherman2') {
	echo 'launching soon';
	exit;
}*/

// END DEFINE USER RANKS, COLORS, QUALIFICATIONS!! -- NO CONFIG UPDATES NEEDED BELOW THIS POINT!

$qualified_icon1 = '<i class="fa fa-star" style="color:'.$rank1_color.'"></i>';
$qualified_icon2 = '<i class="fa fa-star" style="color:'.$rank2_color.'"></i>';
$qualified_icon3 = '<i class="fa fa-star" style="color:'.$rank3_color.'"></i>';
$qualified_icon4 = '<i class="fa fa-star" style="color:'.$rank4_color.'"></i>';
$qualified_icon5 = '<i class="fa fa-star" style="color:'.$rank5_color.'"></i>';

$cancelled_icon = '<i class="fa fa-ban" style="color:red"></i>';
$user_icon = '<i class="fa fa-user" style="color:#428bca"></i>';
?>
	<style>
.mat-cell-link {	
	/* unvisited link */
	a:link {
	  color: black;
	}

	/* visited link */
	a:visited {
	  color: black;
	}

	/* mouse over link */
	a:hover {
	  color: black;
	}

	/* selected link */
	a:active {
	  color: black;
	}
  color: black;	
}
		.mat-img-circle {
			width: 70px;
			height: 70px;
			border-radius: 75px;
			-webkit-border-radius: 75px;
			-moz-border-radius: 75px;
			box-shadow: 0 0 0px rgba(0, 0, 0, 0);
			-webkit-box-shadow: 0 0 0px rgba(0, 0, 0, .1);
			-moz-box-shadow: 0 0 0px rgba(0, 0, 0, .1);
			}
			
		.Qno-pic {
			width: 70px;
			height: 70px;
			border-radius: 75px;
			-webkit-border-radius: 75px;
			-moz-border-radius: 75px;
			box-shadow: 0 0 0px rgba(0, 0, 0, 0);
			-webkit-box-shadow: 0 0 0px rgba(0, 0, 0, .1);
			-moz-box-shadow: 0 0 0px rgba(0, 0, 0, .1);
			}				
		
.QQbrh {
  margin-top: 0.1em;*/ /* adjust this value to your desired line height */
}


.uname {
  font-size: .9em;
}  

.sponsor {
  background-color: #e5f3fb; 
  font-size: .9em;
}

.user {
  position: relative;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;	
 /* background-color: #ffffff;*/
}

.user:hover {
 /* background-color: #d1ecf1;*/
}


.glink {
  text-decoration: none;
}

.innerdiv {
  width: 7em;	
  margin-top: -15px;
  margin-bottom:-15px;
}

		</style>
<?php		
// FIND OUT IF USERS FALLS UNDER YOU!
function isThisMyDownline($check_id, $sponsorusrid, $matlevel){
	// RETURNS 1 IF TRUE, 0 IF FALSE

	$selectFields = '*';
	$mainTable = 'matrix';
	$where = [['usrid' => $check_id], ['matlevel' => $matlevel]];

	// Call the PHPCPR select function	
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
	$buffer = isset($result[0]) ? $result[0] : null;

	$placed_under_sponsorusrid = $buffer['placed_under_sponsorusrid'] ?? 0;
	
	// LAST CHECKED ID IS UNDER THE LOGGEDIN SPONSOR, FUNCTION RETURNS TRUE!
	if (/*$buffer['sponsorusrid'] == $sponsorusrid || */$placed_under_sponsorusrid == $sponsorusrid) {
		$sname = getUsername_From_Usrid($sponsorusrid);
		if ($_SESSION['debug'] == true) echo '<br>isThisMyDownline MATCH IS GOOD! SPONSOR ID: '.$sponsorusrid.' ('.$sname.')<br>';
		return 1;
	} else if (($placed_under_sponsorusrid == 1 || $placed_under_sponsorusrid == 0) && $sponsorusrid !=1) {
		// LAST CHECKED ID IS UNDER ADMIN, BUT LOGGEDIN SPONSOR IS NOT ADMIN, FUNCTION RETURNS FALSE!
		if ($_SESSION['debug'] == true) echo '<br>isThisMyDownline BACK TO ADMIN, NO MATCH!<br>';		
		return 0;
	} else {
		$check_next_id = $buffer['placed_under_sponsorusrid'];
		$uname = getUsername_From_Usrid($check_next_id);
		if ($_SESSION['debug'] == true) echo '<br>isThisMyDownline CALLS ITSELF! CHECKING ID: '.$check_next_id.' ('.$uname.')<br>';	
		return isThisMyDownline($check_next_id, $sponsorusrid, $matlevel);
	}	
}

$ID = $_SESSION['UserID'];

if (!isset($_REQUEST['uname'])) $check_uname = $_SESSION['loggedin'];
else $check_uname = $_REQUEST['uname'];

$usrid = getUsrid_From_Username($check_uname);
$check_id = $usrid;


// LOCKDOWN PAGE - USER CANNOT SEE ABOVE THEM IN MATRIX!
$sponsorusrid = $ID;
if ($_SESSION['loggedin'] == 'admin' || $_SESSION['admin_login'] === true) {
	// DO NOTHING
	$allowed_access = 1;
} else {	
	$allowed_access = isThisMyDownline($check_id, $sponsorusrid, $matlevel);
}

//QQQ ALLOW ADMIN VIEW KLUDGE!
//if ($_SESSION['loggedin'] == 'QQQ' || $_SESSION['loggedin'] == 'QQQ') $_SESSION['admin_login'] = true;

if ($allowed_access == 0 && $_SESSION['admin_login'] != true) {
	$check_id = $ID; 
	$check_uname = $_SESSION['loggedin'];
	// NOW WE REDO QRY WITH LOGGEDIN USER - WE NEED $buffer2 VARS BELOW THIS COND! - DO NOT CHANGE!

	$selectFields = 'ID, First_Name, Last_Name, Username, sponsorid';
	$mainTable = 'members';
	$where = ['Username' => $check_uname];

	// Call the PHPCPR select function
	$result2 = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
	$buffer2 = isset($result2[0]) ? $result2[0] : null;

	$check_id = $buffer2['ID'];
}

$top_spot['username'] = $buffer2['Username'] ?? null;
$top_spot['fname'] = $buffer2['First_Name'] ?? null;
$top_spot['lname'] = $buffer2['Last_Name'] ?? null;
$top_spot['upline'] = $buffer2['sponsorid'] ?? null;
$top_spot['direct_upline'] = $buffer2['sponsorid'] ?? null;
$top_spot['full_name'] = !empty($usrid) ? getFullname_From_Usrid($usrid) : null;

$selectFields = '*';
$mainTable = 'matrix';
$where = [['usrid' => $check_id], ['matlevel' => $matlevel]];

// Call the PHPCPR select function	
$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
$buffer = isset($result[0]) ? $result[0] : null;

$top_spot['upline_id'] = $buffer['placed_under_sponsorusrid'];
//echo $qry;
//print_r($buffer);
$top_id = $top_spot['upline_id'];
$top_spot_active = $buffer['active'];

$selectFields = 'sponsorid';
$mainTable = 'members';
$where = ['ID' => $top_id];

// Call the PHPCPR select function
$result2 = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

// Check if result is not false or empty, then proceed with your logic
$buffer2 = isset($result2[0]) ? $result2[0] : null;

$top_spot['upline'] = $buffer2['sponsorid'] ?? null;

///*
if ($debug2 == true) $top_spot['show_id'] = ' ID: '.$check_id.'<br>Ref: '.$top_spot['upline'].' ID: '.$top_spot['upline_id'];
else $top_spot['show_id'] = '<br>Ref: '.$top_spot['upline'];
//$top_spot['show_id'] = '';
//*/

// QQQ RESTACK NOTICE!!!
//echo '<h2>The matrix live stack is in progress.</h2>';

//echo '<h2>We will wipe and restack the matrix periodically before then, for testing purposes.</h2>';
/*
if ($buffer['idx'] == '') {
	if ($check_id == $_SESSION['UserID']) {
		echo '<br>You are not on this board. A Matrix restack may be in progress. Pls be patient. We go live on Nov 15th.';
		include './footer.php';
		exit;
	} else {
		echo '<br>'.$top_spot['username'].' is not on this board. Please ask them to pay or contact support. A Matrix restack may be in progress. Pls be patient. We go live on Nov 15th.';
		include './footer.php';
		exit;
	}	
}*/

///* // UNCOMMENT FOR LIVE SITE USE!!
if ($buffer['idx'] == '') {
	if ($check_id == $_SESSION['UserID']) {
		echo '<br>You are not on this board. <a href="/apay/pay.php?program='.$program_id.'&resub=Y"> Click here to make payment.</a>';
		include './footer.php';
		exit;
	} else {
		echo '<br>That user is not on this board. Please ask them to pay or contact support.';
		include './footer.php';
		exit;
	}	
}
//*/
// INI VARS!
$count = 0; 

$top_upline_sponsor = $buffer['placed_under_sponsorusrid'];
//echo $top_upline_sponsor; exit;
if ($top_upline_sponsor == 0) $top_upline_sponsor = 1;

$GLOBALS['path'] = $Global['path'];
$GLOBALS['webpage_url_ssl'] = $Global['webpage_url_ssl'];

function getsponsorusrid($usrid){
	
	if ($_SESSION['debug'] == true) echo 'BEGIN getsponsorusrid<br>';
	
	$selectFields = 'sponsorid';
	$mainTable = 'members';
	$where = ['ID' => $usrid];

	// Call the PHPCPR select function	
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
	$buffer = isset($result[0]) ? $result[0] : null;

	$sponsor_username = $buffer['sponsorid']; // THE SPONSOR'S UNAME
	
	$selectFields = 'ID';
	$mainTable = 'members';
	$where = ['Username' => $sponsor_username];

	// Call the PHPCPR select function
	$result2 = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
	$buffer2 = isset($result2[0]) ? $result2[0] : null;
	
	if (isset($buffer2['ID'])) $sponsorid = $buffer2['ID'];
	else $sponsorid = 0;
	
	if ($_SESSION['debug'] == true) echo 'sponsorid is: '.$sponsorid.' END getsponsorusrid<br>';		
	return $sponsorid;
}
function get_mat_daddy($usrid, $matlevel){
	if ($usrid > 0) {
		$selectFields = '*';
		$mainTable = 'matrix';
		$where = [['usrid' => $usrid], ['matlevel' => $matlevel]];

		// Call the PHPCPR select function	
		$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
		$buffer = isset($result[0]) ? $result[0] : null;		
		return $buffer['placed_under_sponsorusrid'];
	} else {
		return 0;
	}
}


function getImage($check_id) {				
	$image_exists = false; // INI VAR!
	$image_path = $GLOBALS['path'].'images/Users/'.floor(($check_id / 1000)).'/'.$check_id.'.jpg';

	if (file_exists($image_path)) {
		$image_exists = true;
		$image_url = $GLOBALS['webpage_url_ssl'].'images/Users/'.floor(($check_id / 1000)).'/'.$check_id.'.jpg';
	}				

	if ($image_exists == true) {
		$display_img = '<img alt="team member picutre" class="img-circle mat-img-circle" src="'.$image_url.'" /><br>';
		//echo 'image yes';
	} else if ($check_id > 0) {
		//$display_img = '<i class="fa fa-user fa-3x center" style="text-align:center; color:#aaa"></i>';
		$display_img = '<img alt="default image" class="mat-img-circle" src="/images/user.png" />';
		$display_img = '<div class="fa-user icon-large" style="color:#aaa"></div>';
		$display_img = '<img alt="team member picutre" class="img-circle mat-img-circle no-pic" src="'.$GLOBALS['webpage_url_ssl'].'images/user.png" /><br>';	
	} else {
		$display_img = '<img alt="default image" class="img-circle mat-img-circle no-pic" src="'.$GLOBALS['webpage_url_ssl'].'images/no-user.png" /><br><span>OPEN SLOT</span>';	
	}
	return($display_img);
}

function getUsrid_From_Username($username) {
	$selectFields = 'ID';
	$mainTable = 'members';
	$where = ['Username' => $username];

	// Call the PHPCPR select function
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

	// Check if result is not false or empty, then proceed with your logic
	$buffer = isset($result[0]) ? $result[0] : null;
	if ($_SESSION['debug'] == true) echo 'END getUsrid_From_Username: '.$username.'<br>';
	return($buffer['ID']);
}

function getUsername_From_Usrid($usrid) {
	$selectFields = 'Username';
	$mainTable = 'members';
	$where = ['ID' => $usrid];

	// Call the PHPCPR select function
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

	// Check if result is not false or empty, then proceed with your logic
	$buffer = isset($result[0]) ? $result[0] : null;
	if ($_SESSION['debug'] == true) echo 'END getUsrid_From_Username: '.$username.'<br>';
	return $buffer['Username'] ?? null;
}

function getFullname_From_Usrid($usrid) {
	$selectFields = 'First_Name, Last_Name';
	$mainTable = 'members';
	$where = ['ID' => $usrid];

	// Call the PHPCPR select function
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

	// Check if result is not false or empty, then proceed with your logic
	$buffer = isset($result[0]) ? $result[0] : null;
	if ($_SESSION['debug'] == true) echo 'END getUsrid_From_Username: '.$username.'<br>';
	return($buffer['First_Name'].' '.$buffer['Last_Name']);
}

////////////////////////////////////////////
// return number of direct sponsees
function isCommissionQualified($usrid, $matlevel){
	$selectFields = 'COUNT(usrid) AS CNT';
	$mainTable = 'matrix';
	$where = [['sponsorusrid' => $usrid], ['matlevel' => $matlevel]];

	// Call the PHPCPR select function
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

	// Check if result is not false or empty, then proceed with your logic
	if ($result && isset($result[0]['CNT'])) {
		$num = $result[0]['CNT'];
		return $num;
	}
	return 0;
}

function isActiveOnMatrix($usrid, $matlevel){

	$selectFields = '*';
	$mainTable = 'matrix';
	$where = [
	['usrid' => $usrid],
	['matlevel' => $matlevel],
	['active' => 'Y']
	];

	// Call the PHPCPR select function	
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
	if ($result) return 1;
	else return 0;
}

function find_sponsor_level($usrid, $ref_sponsorid, $level = 0, $matlevel) {
	$selectFields = 'placed_under_sponsorusrid';
	$mainTable = 'matrix';
	$where = [['usrid' => $usrid], ['matlevel' => $matlevel]];

	// Call the PHPCPR select function	
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
	$buffer = isset($result[0]) ? $result[0] : null;
	
	$level++;
	if (empty($buffer['placed_under_sponsorusrid'])) return $level;
	if ($buffer['placed_under_sponsorusrid'] != $ref_sponsorid) {
		$look_up = $buffer['placed_under_sponsorusrid'];
		return find_sponsor_level($look_up, $ref_sponsorid, $level, $matlevel);
    } else {
		return $level;
	}	
}

function find_deepest_spot($sponsorusrid, $generations = 0, $matlevel) {
	
	$selectFields = 'usrid';
	$mainTable = 'matrix';
	$where = [
	['placed_under_sponsorusrid' => $sponsorusrid], ['matlevel' => $matlevel]
	];

	// Call the PHPCPR select function	
	$result = select($selectFields, $mainTable, [], $where, null, null, 'idx ASC', $GLOBALS['before_x'], 1);
	$buffer = isset($result[0]) ? $result[0] : null;	

    $deepestSpot = null;

	if ($result && count($result) > 0) {
		foreach ($result as $buffer) {
			if ($buffer['usrid'] != '') {
				$currentResult = find_deepest_spot($buffer['usrid'], $generations + 1, $matlevel);
				if (is_null($deepestSpot)) $deepestSpot = $currentResult;
				if (is_null($deepestSpot) || $currentResult['generations'] > $deepestSpot['generations']) {
					// If the current spot is at a deeper level than the best spot found so far
					$deepestSpot = $currentResult;
				}
			}
		}	
    }

    return $deepestSpot ?: array("generations" => $generations, "sponsorusrid" => $sponsorusrid);
}
	

function find_generations($sponsorusrid, $generation = 0, $matlevel) {
	$selectFields = '*';
	$mainTable = 'matrix';
	$where = [['placed_under_sponsorusrid' => $sponsorusrid], ['matlevel' => $matlevel]];
	$orderBy = 'idx ASC';
	$limit = $GLOBALS['before_x'];

	// Call the PHPCPR select function
	$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, 1);

	$total_team_count = 0;
	$count = 0;
	$this_loop_generation_counted = false;

	if ($result && count($result) > 0 && $generation <= $GLOBALS['after_x']) {
		foreach ($result as $buffer) {
			$count++;			
			// ONLY INCREASE GENS ONCE PER EVERY 3 ROWS!
			if ($count == 1 && $buffer['usrid'] != '') {
				$generation++;
				$left_leg_id = $buffer['usrid'];
				$this_loop_generation_counted = true;
				$total_team_count++;
				if ($buffer['active'] == 'N') {
					//$total_team_count = $total_team_count - 1;
					//$cancelled_team_count++;
				}					
				if (isset($res)) unset($res);
				$res = find_generations($buffer['usrid'], $generation, $matlevel);
				if ($res) { // ONLY DONE ONCE PER 2 USERS! (ONE LOOP)!
					$total_team_count = $total_team_count + $res['total_team_count'];
					//$generation = $generation + $res['generation'];
				}
			} else if ($count == 2 && $buffer['usrid'] != '') {
				$right_leg_id = $buffer['usrid'];
				//if ($this_loop_generation_counted === false) $generation = $generation + 1;
				$total_team_count++;
				if ($buffer['active'] == 'N') {
					//$total_team_count = $total_team_count - 1;
					//$cancelled_team_count++;
				}					
				if (isset($res2)) unset($res2);
				$res2 = find_generations($buffer['usrid'], $generation, $matlevel);
				if ($res2) { // ONLY DONE ONCE PER 2 USERS! (ONE LOOP)!
					$total_team_count = $total_team_count + $res2['total_team_count'];
					//$generation = $generation + $res2['generation'];
				}
			} else if ($count == 3 && $buffer['usrid'] != '') {
				$third_leg_id = $buffer['usrid'];
				//if ($this_loop_generation_counted === false) $generation = $generation + 1;
				$total_team_count++;
				if ($buffer['active'] == 'N') {
					//$total_team_count = $total_team_count - 1;
					//$cancelled_team_count++;
				}			
				if (isset($res3)) unset($res3);
				$res3 = find_generations($buffer['usrid'], $generation, $matlevel);
				if ($res3) { // ONLY DONE ONCE PER 2 USERS! (ONE LOOP)!
					$total_team_count = $total_team_count + $res3['total_team_count'];
					//$generation = $generation + $res2['generation'];
				}
			}
        } // END WHILE
		
		//$cancelled_team_count = 0;
		//$sqrt = sqrt($total_team_count + $cancelled_team_count); // GET SQUARE ROOT OF TOTAL TEAM (ADDING BACK CANCELLED USERS FOR THIS)
		$sqrt = sqrt($total_team_count); // GET SQUARE ROOT OF TOTAL TEAM
		$roundedDown = floor($sqrt);
		$roundedUp = ceil($sqrt);
		$round = round($sqrt);
		//$generation = $roundedDown;
		$generation = $round;
		if ($generation > $GLOBALS['after_x']) $generation = $GLOBALS['after_x'];

		if (!isset($left_leg_id)) {
			$left_leg_id = 0;
		}

		if (!isset($right_leg_id)) {
			$right_leg_id = 0;
		}

		if (!isset($third_leg_id)) {
			$third_leg_id = 0;
		}
		
		
        return array("generation" => $generation, "total_team_count" => $total_team_count, "left_leg_id" => $left_leg_id, "right_leg_id" => $right_leg_id, "third_leg_id" => $third_leg_id);
    } else {
        return array("generation" => 0, "total_team_count" => 0);
    }
}

function build_user_info($usrid, $index=1, $user_can_look_up=1, $top_slot=0) {
	
    global $debug2, $this_page, $qualified_icon1, $qualified_icon2, $qualified_icon3, $qualified_icon4, $qualified_icon5, $cancelled_icon, $matlevel, $rank_levels, $rank1_qualifiers, $rank2_qualifiers, $rank3_qualifiers, $rank4_qualifiers, $rank5_qualifiers;

    $qtext = null;
    $uname = null;
    $data = null;
    $sponsor_id = null;
    $sponsor_uname = null;

    $qualification = !empty($usrid) ? isCommissionQualified($usrid, $matlevel) : 0;
	
	// NO NEED TO EDIT THIS SECTION.
    if ($rank_levels > 0 && $qualification >= $rank1_qualifiers) $qtext = $qualified_icon1;
    if ($rank_levels > 1 && $qualification >= $rank2_qualifiers) $qtext = $qualified_icon2;
    if ($rank_levels > 2 && $qualification >= $rank3_qualifiers) $qtext = $qualified_icon3;
    if ($rank_levels > 3 && $qualification >= $rank4_qualifiers) $qtext = $qualified_icon4;
    if ($rank_levels > 4 && $qualification >= $rank5_qualifiers) $qtext = $qualified_icon5;	

    if (!empty($usrid) && isActiveOnMatrix($usrid, $matlevel) != 1) $qtext = $cancelled_icon;

    $uname = !empty($usrid) ? getUsername_From_Usrid($usrid) : null;
    $data = !empty($usrid) ? find_generations($usrid, $index, $matlevel) : null;
    $sponsor_id = !empty($usrid) ? getsponsorusrid($usrid) : null;
    $sponsor_uname = !empty($usrid) ? getUsername_From_Usrid($sponsor_id) : null;
	$full_name = !empty($usrid) ? getFullname_From_Usrid($usrid) : null;
	
	if ($debug2 == true) { 
		$show_sponsor_id = $sponsor_id;
		$show_usrid = $usrid;
	} else {
		$show_sponsor_id = '';
		$show_usrid = '';
	}	

	$real_gens = find_deepest_spot($usrid, 0, $matlevel); // THIS SEEMS CORRECT NOW. THIS FUNCTION CREATED AS COUNTERPART TO HOW MATRIX IS NOW STACKED (find_open_spot)
// $data['generation'] WAS WRONG 
	//if ($top_slot == 1) $real_gens['generations'] = $real_gens['generations'] - 1;
    $display_sponsor = !empty($sponsor_uname) ? '<br class="brh"><span class="sponsor">'.strtoupper($sponsor_uname).' '.$show_sponsor_id.'</span>' : '';
    $display_team_count = !empty($usrid) ? '<br class="brh">Generations '.$real_gens['generations'].' <br class="brh">'.$qtext.'Team '.$data['total_team_count'] : '';
    $display_image = getImage($usrid);
    $display_name = !empty($uname) ? '<span class="uname">'.strtoupper(substr($uname, 0, 20)).' '.$show_usrid.'</span>' : '';

    $left_leg_id = '';
    $right_leg_id = '';
    $third_leg_id = '';
    if (!empty($data)) {
        $left_leg_id = $data['left_leg_id'] ?? '';
        $right_leg_id = $data['right_leg_id'] ?? '';
        $third_leg_id = $data['third_leg_id'] ?? '';
    }
	
	//if ($uname == $_SESSION['loggedin'] && $usrid == $_SESSION['UserID'] && $uname != $_GET['uname']) $uname_to_get = $sponsor_uname;
	//else $uname_to_get = $uname;
	
	//if ($user_can_look_up == 1) $uname_to_get = $sponsor_uname;
	//else $uname_to_get = $_SESSION['loggedin'];
	
	//if ($top_slot == 1) $uname_to_get = $sponsor_uname;
	//else $uname_to_get = $uname;
	$level = '';
	
	if ($top_slot == 1) {
		$usrid_to_get = get_mat_daddy($usrid, $matlevel);
		$uname_to_get = getUsername_From_Usrid($usrid_to_get);
	} else {
		$uname_to_get = $uname;
	}
	
	if ($usrid != $_SESSION['UserID']) {
		$level = '<br>Level '.find_sponsor_level($usrid, $_SESSION['UserID'], 0, $matlevel);
	} else {	
		$level = '';
	}
	
    $session_string = '<div class="user"><a href="'.$this_page.'&uname='.$uname_to_get.'" class="mat-cell-link" style="text-decoration: none;">'.$display_image.$display_name.$display_sponsor.$display_team_count.'</a>'.$level.'</div>';

    return array(
        'session_string' => $session_string,
        'left_leg_id' => $left_leg_id,
        'right_leg_id' => $right_leg_id,
        'third_leg_id' => $third_leg_id,
        'uname' => $uname,
        'qtext' => $qtext,
        'sponsor' => $sponsor_id,
        'sponsor_uname' => $sponsor_uname,
        'display_sponsor' => $display_sponsor,
        'display_team_count' => $display_team_count,
        'display_image' => $display_image,
        'display_name' => $display_name,
		'full_name' => $full_name
    );
}

if (isset($mtrx_name)) unset($mtrx_name);
if (isset($mtrx_tooltip)) unset($mtrx_tooltip);

// Usage

if ($allowed_access == 0 && $_SESSION['admin_login'] != true) $user_can_look_up = 0;
else $user_can_look_up = 1;

$user_info = build_user_info($check_id, 1, $user_can_look_up, 1);
//print_r($user_info);
$mtrx_name[0] = $user_info['session_string'];
$mtrx_tooltip[0] = $user_info['full_name'];

// 2X
if ($GLOBALS['before_x'] == 2) {
		
	if(!empty($user_info['left_leg_id'])) {
		$user_info2 = build_user_info($user_info['left_leg_id']);
		$mtrx_name[1] = $user_info2['session_string'] ?? '';
		$mtrx_tooltip[1] = $user_info2['full_name'] ?? '';		
	} else {
		$mtrx_name[1] = getImage(0);
		$mtrx_tooltip[1] = '';
	}

	if(!empty($user_info['right_leg_id'])) {
		$user_info3 = build_user_info($user_info['right_leg_id']);
		$mtrx_name[2] = $user_info3['session_string'] ?? '';
		$mtrx_tooltip[2] = $user_info3['full_name'] ?? '';		
	} else {
		$mtrx_name[2] = getImage(0);
		$mtrx_tooltip[2] = '';
	}

	if(!empty($user_info2['left_leg_id'])) {
		$user_info4 = build_user_info($user_info2['left_leg_id']);
		$mtrx_name[3] = $user_info4['session_string'] ?? ''; 
		$mtrx_tooltip[3] = $user_info4['full_name'] ?? '';		
	} else {
		$mtrx_name[3] = getImage(0);
		$mtrx_tooltip[3] = '';
	}

	if(!empty($user_info2['right_leg_id'])) {
		$user_info5 = build_user_info($user_info2['right_leg_id']);
		$mtrx_name[4] = $user_info5['session_string'] ?? '';
		$mtrx_tooltip[4] = $user_info5['full_name'] ?? '';		
	} else {
		$mtrx_name[4] = getImage(0);
		$mtrx_tooltip[4] = '';
	}

	if(!empty($user_info3['left_leg_id'])) {
		$user_info6 = build_user_info($user_info3['left_leg_id']);
		$mtrx_name[5] = $user_info6['session_string'] ?? '';
		$mtrx_tooltip[5] = $user_info6['full_name'] ?? '';		
	} else {
		$mtrx_name[5] = getImage(0);
		$mtrx_tooltip[5] = '';
	}

	if(!empty($user_info3['right_leg_id'])) {
		$user_info7 = build_user_info($user_info3['right_leg_id']);
		$mtrx_name[6] = $user_info7['session_string'] ?? ''; 
		$mtrx_tooltip[6] = $user_info7['full_name'] ?? '';
	} else {
		$mtrx_name[6] = getImage(0);
		$mtrx_tooltip[6] = '';
	}

	if(!empty($user_info4['left_leg_id'])) {
		$user_info8 = build_user_info($user_info4['left_leg_id']);
		$mtrx_name[7] = $user_info8['session_string'] ?? ''; 
		$mtrx_tooltip[7] = $user_info8['full_name'] ?? '';		
	} else {
		$mtrx_name[7] = getImage(0);
		$mtrx_tooltip[7] = '';
	}

	if(!empty($user_info4['right_leg_id'])) {
		$user_info9 = build_user_info($user_info4['right_leg_id']);
		$mtrx_name[8] = $user_info9['session_string'] ?? ''; 
		$mtrx_tooltip[8] = $user_info9['full_name'] ?? '';		
	} else {
		$mtrx_name[8] = getImage(0);
		$mtrx_tooltip[8] = '';
	}

	if(!empty($user_info5['left_leg_id'])) {
		$user_info10 = build_user_info($user_info5['left_leg_id']);
		$mtrx_name[9] = $user_info10['session_string'] ?? ''; 
		$mtrx_tooltip[9] = $user_info10['full_name'] ?? '';		
	} else {
		$mtrx_name[9] = getImage(0);
		$mtrx_tooltip[9] = '';
	}

	if(!empty($user_info5['right_leg_id'])) {
		$user_info11 = build_user_info($user_info5['right_leg_id']);
		$mtrx_name[10] = $user_info11['session_string'] ?? ''; 
		$mtrx_tooltip[10] = $user_info11['full_name'] ?? '';		
	} else {
		$mtrx_name[10] = getImage(0);
		$mtrx_tooltip[10] = '';
	}

	if(!empty($user_info6['left_leg_id'])) {
		$user_info12 = build_user_info($user_info6['left_leg_id']);
		$mtrx_name[11] = $user_info12['session_string'] ?? '';
		$mtrx_tooltip[11] = $user_info12['full_name'] ?? '';		
	} else {
		$mtrx_name[11] = getImage(0);
		$mtrx_tooltip[11] = '';
	}

	if(!empty($user_info6['right_leg_id'])) {
		$user_info13 = build_user_info($user_info6['right_leg_id']);
		$mtrx_name[12] = $user_info13['session_string'] ?? ''; 
		$mtrx_tooltip[12] = $user_info13['full_name'] ?? '';		
	} else {
		$mtrx_name[12] = getImage(0);
		$mtrx_tooltip[12] = '';
	}

	if(!empty($user_info7['left_leg_id'])) {
		$user_info14 = build_user_info($user_info7['left_leg_id']);
		$mtrx_name[13] = $user_info14['session_string'] ?? ''; 
		$mtrx_tooltip[13] = $user_info14['full_name'] ?? '';		
	} else {
		$mtrx_name[13] = getImage(0);
		$mtrx_tooltip[13] = '';
	}

	if(!empty($user_info7['right_leg_id'])) {
		$user_info15 = build_user_info($user_info7['right_leg_id']);
		$mtrx_name[14] = $user_info15['session_string'] ?? ''; 
		$mtrx_tooltip[14] = $user_info15['full_name'] ?? '';		
	} else {
		$mtrx_name[14] = getImage(0);
		$mtrx_tooltip[14] = '';
	}

	if(!empty($user_info8['left_leg_id'])) {
		$user_info16 = build_user_info($user_info8['left_leg_id']);
		$mtrx_name[15] = $user_info16['session_string'] ?? ''; 
		$mtrx_tooltip[15] = $user_info16['full_name'] ?? '';		
	} else {
		$mtrx_name[15] = getImage(0);
		$mtrx_tooltip[15] = '';
	}

	if(!empty($user_info8['right_leg_id'])) {
		$user_info17 = build_user_info($user_info8['right_leg_id']);
		$mtrx_name[16] = $user_info17['session_string'] ?? ''; 
		$mtrx_tooltip[16] = $user_info17['full_name'] ?? '';		
	} else {
		$mtrx_name[16] = getImage(0);
		$mtrx_tooltip[16] = '';
	}

//// 3X
} else if ($GLOBALS['before_x'] == 3) {	

	if(!empty($user_info['left_leg_id'])) {
		$user_info2 = build_user_info($user_info['left_leg_id']);
		//print_r($user_info2);
		$mtrx_name[1] = $user_info2['session_string'] ?? '';
		$mtrx_tooltip[1] = $user_info2['full_name'] ?? '';
	}  else {
		$mtrx_name[1] = getImage(0);
		$mtrx_tooltip[1] = '';
	}

	if(!empty($user_info['right_leg_id'])) {
		$user_info3 = build_user_info($user_info['right_leg_id']);
		//print_r($user_info3);
		$mtrx_name[2] = $user_info3['session_string'] ?? ''; 
		$mtrx_tooltip[2] = $user_info3['full_name'] ?? '';		
	}  else {
		$mtrx_name[2] = getImage(0);
		$mtrx_tooltip[2] = '';
	}

	if(!empty($user_info['third_leg_id'])) {
		$user_info4 = build_user_info($user_info['third_leg_id']);
		//print_r($user_info4);
		$mtrx_name[3] = $user_info4['session_string'] ?? '';
		$mtrx_tooltip[3] = $user_info4['full_name'] ?? '';		
	}  else {
		$mtrx_name[3] = getImage(0);
		$mtrx_tooltip[3] = '';
	}

	if(!empty($user_info2['left_leg_id'])) {
		$user_info5 = build_user_info($user_info2['left_leg_id']);
		//print_r($user_info5);
		$mtrx_name[4] = $user_info5['session_string'] ?? '';
		$mtrx_tooltip[4] = $user_info5['full_name'] ?? '';		
	}  else {
		$mtrx_name[4] = getImage(0);
		$mtrx_tooltip[4] = '';
	}

	if(!empty($user_info2['right_leg_id'])) {
		$user_info6 = build_user_info($user_info2['right_leg_id']);
		//print_r($user_info6);
		$mtrx_name[5] = $user_info6['session_string'] ?? '';
		$mtrx_tooltip[5] = $user_info6['full_name'] ?? '';		
	}  else {
		$mtrx_name[5] = getImage(0);
		$mtrx_tooltip[5] = '';
	}

	if(!empty($user_info2['third_leg_id'])) {
		$user_info7 = build_user_info($user_info2['third_leg_id']);
		//print_r($user_info7);
		$mtrx_name[6] = $user_info7['session_string'] ?? '';
		$mtrx_tooltip[6] = $user_info7['full_name'] ?? '';		
	}  else {
		$mtrx_name[6] = getImage(0);
		$mtrx_tooltip[6] = '';
	}


	if(!empty($user_info3['left_leg_id'])) {
		$user_info8 = build_user_info($user_info3['left_leg_id']);
		//print_r($user_info8);
		$mtrx_name[7] = $user_info8['session_string'] ?? '';
		$mtrx_tooltip[7] = $user_info8['full_name'] ?? '';		
	}  else {
		$mtrx_name[7] = getImage(0);
		$mtrx_tooltip[7] = '';
	}

	if(!empty($user_info3['right_leg_id'])) {
		$user_info9 = build_user_info($user_info3['right_leg_id']);
		//print_r($user_info9);
		$mtrx_name[8] = $user_info9['session_string'] ?? '';
		$mtrx_tooltip[8] = $user_info9['full_name'] ?? '';		
	}  else {
		$mtrx_name[8] = getImage(0);
		$mtrx_tooltip[8] = '';
	}

	if(!empty($user_info3['third_leg_id'])) {
		$user_info10 = build_user_info($user_info3['third_leg_id']);
		//print_r($user_info10);
		$mtrx_name[9] = $user_info10['session_string'] ?? ''; 
		$mtrx_tooltip[9] = $user_info10['full_name'] ?? '';		
	} else {
		$mtrx_name[9] = getImage(0);
		$mtrx_tooltip[9] = '';
	}

	if(!empty($user_info4['left_leg_id'])) {
		$user_info11 = build_user_info($user_info4['left_leg_id']);
		//print_r($user_info11);
		$mtrx_name[10] = $user_info11['session_string'] ?? '';
		$mtrx_tooltip[10] = $user_info11['full_name'] ?? '';		
	}  else {
		$mtrx_name[10] = getImage(0);
		$mtrx_tooltip[10] = '';
	}

	if(!empty($user_info4['right_leg_id'])) {
		$user_info12 = build_user_info($user_info4['right_leg_id']);
		//print_r($user_info12);
		$mtrx_name[11] = $user_info12['session_string'] ?? ''; 
		$mtrx_tooltip[11] = $user_info12['full_name'] ?? '';		
	}  else {
		$mtrx_name[11] = getImage(0);
		$mtrx_tooltip[11] = '';
	}

	if(!empty($user_info4['third_leg_id'])) {
		$user_info13 = build_user_info($user_info4['third_leg_id']);
		//print_r($user_info13);
		$mtrx_name[12] = $user_info13['session_string'] ?? ''; 
		$mtrx_tooltip[12] = $user_info13['full_name'] ?? '';		
	}  else {
		$mtrx_name[12] = getImage(0);
		$mtrx_tooltip[12] = '';
	}

}
//echo 'mat name vars: ';
//print_r($mtrx_name);
//echo ' END mat names!';
?>
    <script type='text/javascript' src='https://www.gstatic.com/charts/loader.js'></script>
    <script type='text/javascript'>
      google.load('visualization', '1', {packages:['orgchart']});
      google.setOnLoadCallback(drawChart);
      function drawChart() {
        var data = new google.visualization.DataTable();
        data.addColumn('string', 'Name');
        data.addColumn('string', 'Manager');
        data.addColumn('string', 'ToolTip');
		data.addRows([
<?php
if ($GLOBALS['before_x'] == 2) {
	
	echo "[{v: '0', f: '{$mtrx_name[0]}'},'','{$mtrx_tooltip[0]}'],
	[{v: '1', f: '{$mtrx_name[1]}'},'0','{$mtrx_tooltip[1]}'],
	[{v: '2', f: '{$mtrx_name[2]}'},'0','{$mtrx_tooltip[2]}'],
	[{v: '3', f: '{$mtrx_name[3]}'},'1','{$mtrx_tooltip[3]}'],
	[{v: '4', f: '{$mtrx_name[4]}'},'1','{$mtrx_tooltip[4]}'],
	[{v: '5', f: '{$mtrx_name[5]}'},'2','{$mtrx_tooltip[5]}'],
	[{v: '6', f: '{$mtrx_name[6]}'},'2','{$mtrx_tooltip[6]}'],
	[{v: '7', f: '{$mtrx_name[7]}'},'3','{$mtrx_tooltip[7]}'],
	[{v: '8', f: '{$mtrx_name[8]}'},'3','{$mtrx_tooltip[8]}'],
	[{v: '9', f: '{$mtrx_name[9]}'},'4','{$mtrx_tooltip[9]}'],
	[{v: '10', f: '{$mtrx_name[10]}'},'4','{$mtrx_tooltip[10]}'],
	[{v: '11', f: '{$mtrx_name[11]}'},'5','{$mtrx_tooltip[11]}'],
	[{v: '12', f: '{$mtrx_name[12]}'},'5','{$mtrx_tooltip[12]}'],
	[{v: '13', f: '{$mtrx_name[13]}'},'6','{$mtrx_tooltip[13]}'],
	[{v: '14', f: '{$mtrx_name[14]}'},'6','{$mtrx_tooltip[14]}']";
	echo "]);\n";
	
} else if ($GLOBALS['before_x'] == 3) {	

	echo "[{v: '0', f: '{$mtrx_name[0]}'},'','{$mtrx_tooltip[0]}'],
	[{v: '1', f: '{$mtrx_name[1]}'},'0','{$mtrx_tooltip[1]}'],
	[{v: '2', f: '{$mtrx_name[2]}'},'0','{$mtrx_tooltip[2]}'],
	[{v: '3', f: '{$mtrx_name[3]}'},'0','{$mtrx_tooltip[3]}'],
	[{v: '4', f: '{$mtrx_name[4]}'},'1','{$mtrx_tooltip[4]}'],
	[{v: '5', f: '{$mtrx_name[5]}'},'1','{$mtrx_tooltip[5]}'],
	[{v: '6', f: '{$mtrx_name[6]}'},'1','{$mtrx_tooltip[6]}'],
	[{v: '7', f: '{$mtrx_name[7]}'},'2','{$mtrx_tooltip[7]}'],
	[{v: '8', f: '{$mtrx_name[8]}'},'2','{$mtrx_tooltip[8]}'],
	[{v: '9', f: '{$mtrx_name[9]}'},'2','{$mtrx_tooltip[9]}'],
	[{v: '10', f: '{$mtrx_name[10]}'},'3','{$mtrx_tooltip[10]}'],
	[{v: '11', f: '{$mtrx_name[11]}'},'3','{$mtrx_tooltip[11]}'],
	[{v: '12', f: '{$mtrx_name[12]}'},'3','{$mtrx_tooltip[12]}']";
	echo "]);\n";
	
}	

//if ($twobyX == 2) $maxidx = 6;
//else $maxidx = 14;

/*$maxidx = 14;

for ($idx = 0; $idx <= $maxidx; $idx++) {
	if ($_SESSION[mtrx_format][$idx] != "") echo "data.setRowProperty({$idx}, 'style', '".$_SESSION[mtrx_format][$idx]."');
";
}*/

# JSON-encode the response
//$json_response = json_encode($arr);

// # Return the response
//echo $json_response;

?>
        // Create the chart.
        var chart = new google.visualization.OrgChart(document.getElementById('chart_div'));
        // Draw the chart, setting the allowHtml option to true for the tooltips.
        chart.draw(data, {'allowHtml':true});
      }
    </script>
  </head>

  <body>
    <div id='chart_div'></div>
  </body>
</html>

<hr>

<div style="text-align:center">
<form class="form-horizontal" action="<?php echo $this_page; ?>" method="post">
<fieldset>
<!-- Text input-->
<div class="form-group">
  <label class="col-md-4 control-label" for="uname">Search For <!--Username in the Matrix--></label>  
  <div class="col-md-4">
  <input id="textinput" name="uname" type="text" placeholder="Username" class="form-control input-md">  
  </div>
  <div class="col-md-4">
    <button id="singlebutton" name="submit" class="btn btn-primary">Search</button>
  </div>
  <br><br>
  	<a href="<?php echo $this_page; ?>" class="btn-xs btn-warning">Back To Top</a>
</div>
</fieldset>
</form>
</div>				
				
				
NOTE: A <?php echo $cancelled_icon; ?> denotes the user is cancelled.<br>

<?php 
if ($rank_levels >= 1) {
    echo 'A ' . $qualified_icon1 . ' denotes the user rank is ' . $rank1_name . ', having made ' . $rank1_qualifiers . ' or more personal sales.<br>';
}
if ($rank_levels >= 2) {
    echo 'A ' . $qualified_icon2 . ' denotes the user rank is ' . $rank2_name . ', having made ' . $rank2_qualifiers . ' or more personal sales.<br>';
}
if ($rank_levels >= 3) {
    echo 'A ' . $qualified_icon3 . ' denotes the user rank is ' . $rank3_name . ', having made ' . $rank3_qualifiers . ' or more personal sales.<br>';
}
if ($rank_levels >= 4) {
    echo 'A ' . $qualified_icon4 . ' denotes the user rank is ' . $rank4_name . ', having made ' . $rank4_qualifiers . ' or more personal sales.<br>';
}
if ($rank_levels >= 5) {
    echo 'A ' . $qualified_icon5 . ' denotes the user rank is ' . $rank5_name . ', having made ' . $rank5_qualifiers . ' or more personal sales.<br>';
}
?>



<br>
The team count is the total number of <?php echo $mat_config; ?> positions below you.<br>

<hr>
The username is followed by the inviter's username. If a profile pic has been uploaded, that will show, otherwise you will see <?php echo $user_icon; ?>

<!--
<hr>
The generation count is an approximation, calculated by the square root of your team (active and cancelled), rounded. Why? Teams can sometimes build unevenly, as the activity is largely driven by each inviter, so as the team size may span many generations, (along side empty spots), the generation count may be slightly smaller than it actually is, as it is based on the total team size. This number is simply to give you a general idea how deep your genealogy runs.-->

<hr>
Something look off? Please remember your <?php echo $GLOBALS['before_x']; ?> direct leg's team counts DO NOT include themselves,<br>so those combined counts will always be <?php echo $GLOBALS['before_x']; ?> less than YOUR team count.

<!-- NO LONGER APPLIES WITH THIS LATEST DISPLAY
<hr><b>NOTE: Your member's team count displayed here reflects your personal <?php echo $mat_config; ?>.<br>Their actual team counts will often be much higher (for their own matrix levels).<br>To see a team member's actual team size, simply click on them, putting them at the top of the matrix.</b>
-->

<?php 
include './footer.php';
?>