<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
if (!isset($alerts_display_is_include)) $alerts_display_is_include = false; 
if ($alerts_display_is_include != true) {
	include './../logincheck.php';
}
$sitename = $Global['webpage_name'] ?? '';
$date = date("Y-m-d");
$ID = $_SESSION['UserID'];

$debug = false;
//$debug = true;
//if ($_SESSION['loggedin'] == 'demo') $debug = true;
$show_debug = 1;
$debug_text = '';
$alert_to_show = '';

$reload_page = false; // INITIALIZING VARIABLE
$done = false; // INITIALIZING VARIABLE
$skip = false; // INITIALIZING VARIABLE

if (isset($_GET['notice'])) { // USER HAS RESPONDED TO ALERT, LET'S RECORD IT
	// notice - IS THE NAME OF THE ALERT!
	
	if ($_GET['action'] == 'off') {
		$status = 'off';	
	} else if ($_GET['action'] == 'remind') {
		$status = 'on';
	} else if ($_GET['action'] == 'done') {
		$status = 'done';
	}
	
	$done = true;	
	
	$name = htmlspecialchars($_GET['notice'], ENT_QUOTES, 'UTF-8');
	
	// WE KNOW THIS RECORD EXISTS, SINCE THEY GOT HERE AS A RESULT OF IT!
	$data = [
		'status' => $status
	];
	$where = [
		'name' => ['=', $name],
		'ID' => ['=', $ID]
	];
	$live = 1;

	$result_master = update('alert_member', $data, [], $where, $live, 1, $show_debug);

} else { // END RECORDING USER RESPONSE // RUN ALERT POP UPS!
	$pageClass = 'full';
		
	$selectFields = '*';
	$mainTable = 'alert_master';
	$where = [
		'start' => ['<=', $date],
		
		'OR' => [
			'expire' => ['>=', $date],
			'alert_master.expire' => ['=', '0000-00-00']
		]
	];
	if (isset($_GET['show_alert'])) { 
		$where['name'] = ['=', $_GET['show_alert']];
	} else if (isset($_GET['downsell'])) {
		$where['name'] = ['=', $_GET['downsell']];
	} else {
		$where['type'] = ['!=', 'downsell'];
		$where['alert_master.type'] = ['!=', 'passive'];	
	}	
	
	if ($_SESSION['loggedin'] == 'QQQtestjim' || $_SESSION['loggedin'] == 'QQQtestjim2') {
		// SHOW ALL ALERTS (ON OR OFF)!!
	} else {
		$where['status'] = ['=', 'on'];
	}
	$orderBy = 'priority DESC';
	//$orderBy = 'rand()';
	$limit = 100;
	$show_debug = 1;

	$result_master = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, $show_debug);
	$rows = is_array($result_master) ? count($result_master) : 0;

	$count = 0;
	if ($rows > 0) {
		foreach ($result_master as $buffer_master) {
			
			//print_r($buffer_master);

			$count++;
			$html_desc = '';	
			$alert_master_id = $buffer_master['alert_master_id'] ?? '';
			$name = $buffer_master['name'] ?? '';
			$desc = $buffer_master['html_desc'] ?? '';
			$program_id = $buffer_master['program_id'] ?? 0;
			$type = $buffer_master['type'] ?? '';
			
			// TYPES upsell, downsell, program ("upsell" AND "program" MUST USE program-finder.php INCLUDE)
			// "downsell" or "passive" WILL BE ALERT LINKED TO FROM ANOTER ALERT - SO WE WILL NOT SHOW THESE TYPES AUTOMATICALLY

			$selectFields = '*';
			$mainTable = 'alert_member';
			$where = [
				'alert_master_id' => ['=', $alert_master_id],
				'ID' => ['=', $ID]
			];

			$result_mem = select($selectFields, $mainTable, [], $where, null, null, null, 1, $show_debug);
			$buffer_mem = isset($result_mem[0]) ? $result_mem[0] : null;
			
			//var_dump($buffer_mem);
			
			//$debug_text .= '<BR>AFTER PRINT R BUFFER MEM ';
			
			if (isset($buffer_mem['idx'])) {
				$debug_text .= '<br>mem idx not empty ';
				$debug_text .= '<br>today date: '.$date;
				$debug_text .= '<br>idx date last_shown: '.$buffer_mem['last_shown'];
				// DO NOT SHOW IF ALREADY SHOWN -- UNLESS IT'S A DOWNSELL, SINCE THAT MEANS THEY GOT HERE BY CLICKING A LINK!
				if (!isset($_GET['show_alert']) && (($buffer_mem['last_shown'] == $date && !isset($_GET['downsell'])) || $buffer_mem['status'] != 'on' || ($buffer_master['max_show_times'] > 0 && $buffer_mem['shown_times'] == $buffer_master['max_show_times']))) {
					
					$skip = true;
					$debug_text .= '<br>skip is true ';
					continue; // WE SKIP THIS RECORD
				} else {
					// SINCE WE ARE SORTING BY priority DESC, WE GET HIGHEST PRIORITY FIRST!
					$alert_to_show = $buffer_mem['name']; // SHOWING HIGHEST PRIORITY NOW
					$debug_text .= '<br>we have an alert condition to run thru ';
					$skip = false;
					$debug_text .= '<br>skip is false<br>';
					$html_desc = $buffer_master['html_desc'] ?? ''; // LAST ONE IS THE SELECTION!
					break; // WE GOT HIGHEST PRIORITY ALERT, SO WE BREAK OUT OF LOOP NOW!
				}			
			} else { // NO alert_member RECORD EXISTS YET -- INSERT RECORD WITH PROPER DATA
				$data = [
					'alert_master_id' => $alert_master_id,
					'name' => $name,
					'ID' => $ID,
					'last_shown' => '0000-00-00',
					'shown_times' => 0,
					'status' => 'on'
				];
				$live = 1;
				$result_ins = insert('alert_member', $data, $live, $show_debug);
				
			
				$alert_to_show = $name;
				$debug_text .= '<br>Insert done! we have an alert condition to run thru ';
				$skip = false;
				$debug_text .= '<br>skip is false<br>';
				$html_desc = $buffer_master['html_desc'] ?? ''; // LAST ONE IS THE SELECTION!
				break; // WE GOT HIGHEST PRIORITY ALERT, SO WE BREAK OUT OF LOOP NOW!			
			}
		} // END LOOP!
	} // ROWS > 0

} // END FINDING ALERT TO SHOW

// SUPPORTS UNLIMITED INCLUDES - DEFINED IN THE DB RECORD FOR THE ALERT!
// DEEMED IMPORTANT TO KEEP THIS FILE CLEAN - AS THERE ARE SO MANY VARIOUS AFFILIATE DATA CONDITIONS TO CHECK!!
if ($skip == false && $done == false && isset($buffer_master['include']) && $buffer_master['include'] != '') {
	$inc = ''.$Global['path'].'Members/alerts/'.$buffer_master['include'].'';
	// MOVED DEBUG UP TO SHOW PRIOR TO THE INCLUDE BEING RUN!
	$debug_text .= "Include TRUE ".$inc."<br/>";	
	include $inc;
}
///////////////////////////////////////////

// PAINTING PAGES PARTY STARTS HERE

///////////////////////////////////////////
if ($alerts_display_is_include != true) {
	$pageName = ''; // THIS IS SHOWN AS A BREADCRUMB UNDER THE MENU, AND IS ALSO USED AS THE PAGE TITLE, IF $pageDesc IS LEFT EMPTY.
	$pageDesc = ''; // IF USED, THIS IS SHOWN AS THE TITLE IN THE PAGE (BLUE BAR SECTION, END OF HEADER), REPLACING $pageName.
	$pageIcon = 'fa fa-bullhorn'; // THE ICON USED IN THE PAGE
	$pageAlign = 'center'; // HOW YOU WANT TO ALIGN THE PAGE CONTENT
	include './../header.php';
}

if ($debug == true) {
	echo $debug_text;
	if (!isset($_GET['notice']) && isset($buffer_master)) echo '<br><br>'.print_r($buffer_master);
	if (!isset($_GET['notice']) && isset($buffer_mem)) echo '<br><br>'.print_r($buffer_mem);	
}
if ($done == true || $skip == true) { // QQQ EXPAND THIS AREA TO SHOW DIFFERENT MSGS BASED ON THEIR CHOICE!
	// HIDING THANK YOU RESPONSE -- NOW USING AS INCLUDE. THIS WOULD LOOK UGLY ON PAGES
	//if ($skip == false) echo '<h1>Thank You!<h1>'; 
	//if ($debug == true) echo '<br>JUST REDIRECTED TO MEM INDEX!';
	// NOW SETTING DATE WE TRIED TO SHOW THIS, SO IT WILL NOT CLOG UP THE QUEUE! THIS WAS REQUIRED FOR ALERTS USING INCLUDES, SINCE THEY MAY BE HIGHEST PRIORITY, BUT ARE ALWAYS THE LAST LINK IN THE CHAIN, SO WE NEED TO SET THE DATE TO NOT SHOW AGAIN, SO WE CAN ADVANCE TO THE NEXT AVAILABLE ALERT TO SHOW!
			
	$data = [
		'last_shown' => $date
	];
	if ($done == true) {
		$data['status'] = 'off';  // Directly assign 'off' to 'status' in the data array
	}
	$where = [
		'name' => ['=', $name],
		'ID' => ['=', $ID]
	];
	$live = 1;
	$show_debug = 1;
	$result = update('alert_member', $data, [], $where, $live, 1, $show_debug);
	
	if ($debug == true) {
		echo '<a href="' . htmlentities($_SERVER['PHP_SELF'], ENT_QUOTES, 'UTF-8') . '">RESET</a>';
	}
	
	if ($alerts_display_is_include != true) {
		// BELOW IS OLD IDEA - IF THIS ALERT IS SHOWN AS A STAND ALONE. KEEPING IN CASE OF CHANGES.
		// BUT FOR NOW THE PLAN IS TO SHOW ALL ALERTS AS AN INCLUDE!
		// WE NO LONGER EXIT, SINCE IT IS NOW AN INCLUDE.
		?>
		<!--
		<img src="<?php echo $Global['webpage_url_ssl'];?>images/logo.png">
		<script type="text/javascript">
		setTimeout("location.href='/Members/index.php'", 2);
		</script>
		-->
		<?php
		//exit;
	}
} else { // DONE IS NOT TRUE - SHOW MODAL FROM DB!
	$updateData = [
		'last_shown' => $date,
		'shown_times' => ['expression' => 'shown_times'.'+'.'1']
	];
	$where = [
		'name' => ['=', $name],
		'ID' => ['=', $ID]
	];
	$live = 1;
	$result = update('alert_member', $updateData, [], $where, $live, 1, $show_debug);

	$html_desc=str_replace('[SITENAME]',$sitename,$html_desc);
	$html_desc=str_replace('[FIRSTNAME]',$_SESSION['Firstname_loggedin'],$html_desc);
	$html_desc=str_replace('[USERNAME]',$_SESSION['loggedin'],$html_desc);	
	//$html_desc=str_replace('[page_name]','display.php',$html_desc);
	?>
	<!-- Modal -->
	<div class="modal fade" id="<?php echo $alert_to_show;?>" tabindex="-1" role="dialog" data-backdrop="true">
	  <div class="modal-dialog modal-lx" style="width: 80%" role="document">
		<div class="modal-content">
		  <div class="modal-header" style="text-align:center; background-color:red">
			<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			<h1 class="" style="color:#fff; font-weight:bold"><?php echo $sitename; ?> Alert!</h1>
		  </div>
		  <div class="modal-body" style="text-align:center">
			<?php echo $html_desc;
			if ($type == 'upsell' && isset($buffer_master['downsell_name']) && $buffer_master['downsell_name'] != '') {
				?>
				<p></p>
				<a href="<?php echo htmlentities($_SERVER['PHP_SELF'], ENT_QUOTES, 'UTF-8'); ?>?downsell=<?php echo $buffer_master['downsell_name']; ?>" class="btn btn-danger btn-lg">No Thank You</a>
				<br/>
			
			<?php
			}
			if (!isset($hide_thank_you) || $hide_thank_you != true) {
			?>
			<p></p>			
			<?php echo $_SESSION['Firstname_loggedin']; ?>, thank you for using <?php echo $sitename; ?>!
			<?php 
			} ?>
			
			
			<?php if ($name != 'find_marked_payments') { ?>
			<p></p>			
			<a href="<?php echo htmlentities($_SERVER['PHP_SELF'], ENT_QUOTES, 'UTF-8'); ?>?notice=<?php echo $name; ?>&action=off">Got it! Don't show this again</a> | 
			<a href="<?php echo htmlentities($_SERVER['PHP_SELF'], ENT_QUOTES, 'UTF-8') ?>?notice=<?php echo $name; ?>&action=remind">Remind me again please</a><?php } ?> 			
			
		  </div>
		  <div class="modal-footer" style="background-color:#eee">
			<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
		  </div>
		</div><!-- /.modal-content -->
	  </div><!-- /.modal-dialog -->
	</div><!-- /.modal -->
	<!-- End Modal -->

	<?php if ($done != true && $alert_to_show != '') { 
	?>
		<script>
		$(window).load(function(){        
		  $('#<?php echo $alert_to_show;?>').modal('show');
		}); 
		</script>
	<?php
	}
}
if ($alerts_display_is_include != true) {	
include './../footer.php';
}
?>