<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
//$debug = true;
$timestamp = time();
$date30 = date("Y-m-d",strtotime("-30 day", $timestamp));
$records = false; // INI VAR

$html_desc = '';
$has_active_level = false;

for ($i = 1; $i <= 10; $i++) { // CHECK UP TO 10 PROGRAMS, TO SEE IF THEY HAVE ACTIVE OR COMPED STATUS!
    if (isset($_SESSION['p'.$i.'_status']) && ($_SESSION['p'.$i.'_status'] == 'Active' || $_SESSION['p'.$i.'_status'] == 'Comped')) {
        $has_active_level = true;
        break; // Exit the loop as soon as one active or comped status is found
    }
}

if ($has_active_level == true && (!isset($_SESSION['admin_login']) || $_SESSION['admin_login'] == false)) {

	$selectFields = 'l.*, p.program_name';
	$mainTable = ['table' => 'leaderboard_earnings', 'as' => 'l'];
	$joinConditions = [
		['table' => 'program', 'as' => 'p', 'condition' => 'l.program_id = p.program_id']
	];
	$where = [
		'l.Username' => ['=', $_SESSION['loggedin']],
		'date' => ['>=', $date30]
	];
	$groupBy = 'l.program_id';
	$orderBy = 'l.program_id ASC';
	$limit = 10;
	$show_debug = 1;

	$result = select($selectFields, $mainTable, $joinConditions, $where, $groupBy, null, $orderBy, $limit, $show_debug);

	$rows = is_array($result) ? count($result) : 0;
	if ($rows > 0) {
		foreach ($result as $buffer) {

			$records = true;
			// POWERLINE & TIERS LEADERBOARD - USES PAYMENT LOGS
			//$leaderboard_placements .= '<h3><a href="'.$Global['webpage_url_ssl'].'Members/leaderboard_earnings.php?program='.$buffer['program_id'].'" target="_blank">'.$buffer['program_name'].' program!</a></h3><hr>';
			// MATRIX LEADERBOARD
			$leaderboard_placements .= '<h3><a href="'.$Global['webpage_url_ssl'].'Members/leaderboard_stats.php?program='.$buffer['program_id'].'" target="_blank">'.$buffer['program_name'].' program!</a></h3><hr>';
		} // END LOOP!
	} else { // END WE GOT RESULTS
		$skip = true;
	}	


	$name = 'leaderboard';
	$alert_to_show = $name;
}

if ($records == true) {
		//$hide_thank_you = true;
		$debug_text .= '<br>we have a '.$name.' alert to show ';
		$skip = false;
		$debug_text .= '<br>skip is false ';
		$html_desc .= '<h2>Guess what, [FIRSTNAME]? We have some great news for you!</h2>
<p><h3><span style="background-color:yellow">You are currently on the leaderboard in...</span></h3></p>
'.$leaderboard_placements.'
<p>Go getters like you are what makes [SITENAME] successful. Keep up the great work!<p></p>';
} else {
		$debug_text .= '<br>we have NO '.$name.' alert to show ';
		$skip = true;
		$debug_text .= '<br>skip is true ';	
}
?>