<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include 'logincheck.php';

if ($Global['use_bank'] != true) {
	header("Location: /Members/viewpayment.php");
	exit;
}

// QQQ SET PARAMETERS FOR THIS PAGE - EVENTUALLY MOVE TO CONFIG
//$cc_fee_rate = 0.20; // SET PERCENTAGE RATE of transaction (cc) fees that will be deducted from commissions
$cc_fee_rate = $Global['cc_fee_rate'];

$use_debit_card = false; // SET TRUE IF USING DEBIT CARD WITH SYSTEM
$card_fee = '19.95';
// SET MINIMUM PAYOUT HERE!! // MINIMUM AMOUNT OF AVAILABLE EARNINGS YOU MUST HAVE TO MAKE A WITHDRAWAL
$minimum_payout = $Global['minimum_payout'];
$withdrawal_fee = $Global['withdrawal_fee'];

if ($_SESSION['a'.$_SESSION['UserID']]['bank_ledger_visited'] != true) {
	header("Location: bankledger.php");
	exit;
}
$ID = $_SESSION['UserID'];

$today = date("Y-m-d");
$datetimenow = date("Y-m-d H:i:s");

$error = '';
$error_msg = '';

// SET RESERVE HERE !! 
// KEEP A RESERVE IF USER IS IN PROGRAM X, TO PAY FOR NEXT MONTH'S SUBSCRIPTION!


// IF NO RESERVE, BUT THERE IS A WITHDRAWAL FEE, SET THE RESERVE TO THE WITHDRAWAL FEE, 
// SO ACCOUNT WILL NEVER GO NEGATIVE, BY DOING A WITHDRAWAL!
if ($_SESSION['p1_status'] == 'Active') { // THEY ARE IN PROGRAM 1, HOLD THE FUNDS
	$reserve = abs($withdrawal_fee); // AMOUNT HELD IN RESERVE - SET TO 0 WHEN NOT IN USE!!
} else {
	$reserve = abs($withdrawal_fee); // AMOUNT HELD IN RESERVE
}
// OVERRIDE
$reserve = $GLOBALS['bank_reserve'];

$real_minimum_payout = $minimum_payout + $reserve + abs($withdrawal_fee);

// SET PAYOUT DATE HERE !! - NOT USING NOW - WITHDRAWALS ARE AVAIABLED TO BE PAID IMMEDIATELY. FUNDS HAVE ALREADY BEEN HELD!
//$payoutdate = date("Y-m-d",strtotime("+7 day"));
$payoutdate = $datetimenow;

//error_reporting(-1);
//error_reporting(E_ALL);

// COMMENT WHEN TESTING IS DONE!!!
//$_SESSION['dev'] = '';
 /*
if ($_GET['dev'] == '' && $_SESSION['dev'] == '' && $_SESSION['loggedin'] != 'testwalkthru' && $_SESSION['admin_login'] != true) { // LOCKING PAGE FOR DEVELOPER USE ONLY!!
//$_SESSION['UserID'] = 81; // FOR TESTING ONLY!!
include_once './header.php';
echo 'We\'re sorry. This area is temporarily down for maintenance. Please check back soon!';
include_once './footer.php';
exit;
} else {
$_SESSION['dev'] = true;
}
*/

// Check if 'bypass' is set before using it
if (!isset($_GET['bypass'])) $_GET['bypass'] = '';
if (!isset($_SESSION['admin_bypass'])) $_SESSION['admin_bypass'] = false;
if (!isset($_POST['tax_id'])) $_POST['tax_id'] = '';
if (!isset($_POST['debitcard'])) $_POST['debitcard'] = '';

if (($_GET['bypass'] == 'y' || $_SESSION['admin_bypass'] == true) && $_SESSION['admin_session_view'] == true) {
$_SESSION['admin_bypass'] = true;
} else {
$_SESSION['admin_bypass'] = false;
}
if ($_GET['bypass'] == 'n') {
$_SESSION['admin_bypass'] = false;
}

	
//Encrypts a given string with mcrypt using algorythm from config file
/*function encrypt($input){
	global $Global;
	$key = $Global['member_taxid_algorythm_key'];
	$input = str_replace("\n","",$input);
	$input = str_replace("\t","",$input);
	$input = str_replace("\r","",$input);
	$td = mcrypt_module_open ($Global['member_taxid_algorythm'], '', 'ecb', '');
	$key = substr(md5($key),0,mcrypt_enc_get_key_size($td));
	$iv = mcrypt_create_iv (mcrypt_enc_get_iv_size ($td), MCRYPT_RAND);
	mcrypt_generic_init ($td, $key, $iv);
	$encrypted_data = mcrypt_generic ($td, $input);
	mcrypt_generic_deinit ($td);
	mcrypt_module_close ($td);
	return base64_encode($encrypted_data);
}*/
	
function encrypt($input){
    global $GLOBALS;
    $key = $GLOBALS['member_taxid_algorythm_key'];
    $method = 'AES-256-CBC'; // More secure method

    // Generating an IV for CBC mode
    $ivLength = openssl_cipher_iv_length($method);
    $iv = openssl_random_pseudo_bytes($ivLength);

    $key = substr(md5($key), 0, 32); // Key size adjusted for AES-256
    $encrypted = openssl_encrypt($input, $method, $key, OPENSSL_RAW_DATA, $iv);

    // Return IV along with the encrypted data
    return base64_encode($iv . $encrypted);
}	
		
if ($_POST['tax_id'] != '') { // ADD TAX ID
	$ssn = preg_replace("/[^0-9]/", "", $_POST['tax_id']); // strip all dashes and other non-numeric characters
	if (strlen($ssn) != 9) {
		$error_msg = 'Please use a valid Social Security / Tax ID number.';
	} else {
		$_POST['tax_id'] = $ssn;
		$taxid = encrypt($_POST['tax_id']);
		// Using PHPCPR for database update
		$updateData = ['tax_id' => $taxid];
		$where = ['ID' => ['=', $_SESSION['UserID']]];
		update('member_link', $updateData, [], $where, 1, 1, 1);
	}
}
if ($_POST['debitcard'] != '') { // ADD DEBIT CARD
	// Using PHPCPR for database update
	$updateData = ['debitcard' => $_POST['debitcard']];
	$where = ['ID' => ['=', $_SESSION['UserID']]];
	update('members', $updateData, [], $where, 1, 1, 1);
}
		

// GET AVAILABLE BALANCE!!
// ALL TYPES, INCLUDING WITHDRAWAL AND DEBIT TYPES ARE ALLOWED IN QUERY HERE, SINCE ALL NEGATIVE VALUES MUST BE SUBTRACTED!! 
// WE CAN NEVER CANCEL A WITHDRAWAL, SINCE IT WOULD EFFECTIVELY PUT MONEY INTO THEIR BANK!!
// INSTEAD (IF REQUIRED) WE CREATE A POSITIVE WITHDRAWAL LOG, TO CANCEL OUT ANY PENDING WITHDRAWAL THAT MUST BE CANCELLED, THEN BOTH WILL BE MARKED PAID AT MASSPAY
// THIS IS HANDLED IN THE REFUND PROCESS IN admin/Sub/Viewplan.php
// Sum of amounts from transactions_log
$selectFields = 'SUM(amount) as balance';
$mainTable = 'transactions_log';
$where = [
    'usrid' => ['=', $_SESSION['UserID']],
    'payout_date' => ['<=', $today],
    'description' => ['!=', 'CHARGEBACKW']
];
$balanceResult = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
$balance = $balanceResult[0]['balance'];

// Get Pending Balance
$mainTable = 'user_program';
$where = ['ID' => ['=', $_SESSION['UserID']]];
$userProgramResult = select('user_program_id', $mainTable, [], $where, null, null, null, 0, 1);

$total_earned = 0;

foreach ($userProgramResult as $buffer) {
    $subSelectFields = 'SUM(log.amount) as amt';
	
	$subJoinConditions = [
        ['table' => 'user_program', 'as' => 'u', 'condition' => 'log.user_program_id = u.user_program_id']
    ];
	
    $subMainTable = ['table' => 'payment_log', 'as' => 'log'];
	
    $subWhere = [
        'log.user_program_id' => ['=', $buffer['user_program_id']],
        'log.cc_pending' => ['=', 'Y']
    ];
    $pendingResult = select($subSelectFields, $subMainTable, $subJoinConditions, $subWhere, null, null, null, 0, 1);
    
    if (!empty($pendingResult) && isset($pendingResult[0]['amt'])) {
        $total_earned += $pendingResult[0]['amt'];
    }
}
	
	
$pending_payment_logs = $total_earned;

$selectFields = 'SUM(amount) as balance';
$mainTable = 'transactions_log';
$where = [
    'usrid' => ['=', $_SESSION['UserID']],
    'payout_date' => ['>', $today],
    'description' => ['!=', 'CHARGEBACKW']
];

$result_pending = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
$buffer_pending = $result_pending[0];
	
$pending = $buffer_pending['balance'] + $pending_payment_logs;

$amt = $balance + $pending;
$total_bal = $balance + $pending;

// CALCULATE AMOUNT OF CC FEES - $cc_fee_rate IS SET AT TOP OF THIS FILE
$cc_fees = ($pending * $cc_fee_rate);

// CACLCULATE PENDING MINUS FEES
$pending_minus_fees = ($pending - $cc_fees);

$bypass='';
if ($_SESSION['admin_session_view'] == true && $_SESSION['admin_bypass'] == true) $bypass = 'Admin bypass is: TRUE';

$pageName = 'My Bank';
//$pageDesc = 'Your Current Available Balance: $'.number_format($balance,2) .' <> Your Current Commissions Pending 7 Day Hold Period (after processing fees): $'.$pending_minus_fees.' '.$bypass;
$pageDesc = 'Withdraw Funds &nbsp;<i class="icon-wallet"></i>';
$pageIcon = 'fa fa-bank';
$pageAlign = 'center';
$pageClass = '';

include './header.php';
if (!empty($error_msg)) { ?>
<div style="color:red;"><h4><?php echo $error_msg; ?></h4><br />&nbsp;
<?php echo "<a class='links' href='bank.php'>Try Again</a></div>";
include_once './footer.php';
exit;
}
//$debug = true;
if ($balance < .01) {
	//include './header.php';
	echo "<hr><h3>You Have No Funds Available To Withdraw.</h3><hr>";
	include './footer.php';
	exit;
} else if (!isset($_REQUEST['type'])) {		
	$bank_bal_headline = "<hr><h3>Your Available Bank Balance: $".number_format($balance,2)."</h3><hr>";
}

//******************************************************************
// LOCKING DOWN BANK AGAINST ANYONE WHO HAS NOT ENTERED THEIR SSN #
// Find out if member is collecting their own payments
$selectFields = 'payment_collected_by, payout_method';
$mainTable = 'members';
$where = ['ID' => ['=', $_SESSION['UserID']]];
$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
$buffer = $result[0];

// Get Tax ID
$selectFieldsML = 'country, tax_id';
$mainTableML = 'member_link';
$whereML = ['ID' => ['=', $_SESSION['UserID']]];
$resultML = select($selectFieldsML, $mainTableML, [], $whereML, null, null, null, 0, 1);
$bufferml = $resultML[0] ?? '';

$country = $bufferml['country'] ?? '';
		
/*
echo 'collected by: ';
echo $buffer['payment_collected_by'];
echo 'country: ';
echo $bufferml['country'];
echo 'tax id: ';
echo $bufferml['tax_id'];
*/
if ($buffer['payment_collected_by'] == 'member' && ($balance < .01)) { // MEMBER IS COLLECTING OWN PAYMENTS, AND HAS NO BANK BALANCE
//include 'header.php'; 
echo 'You are collecting your own payments. Therefore you will never carry a bank balance.';
echo '<br/>If you wish to have '.$Global['webpage_name'].' collect payments for you, please <a class="links" href="bankcard.php?ac=yes">click here</a>. Thank you.';
include 'footer.php'; 
exit;
// QQQ NOT REQUIRING TAX ID NUMBERS -- ADD false && TO BYPASS IT!
} else if (false && $Global['member_taxid'] == true && $buffer['payment_collected_by'] == 'admin' && $bufferml['country'] == 'US' && $bufferml['tax_id'] == '' && ($_SESSION['admin_bypass'] == false)) {
//include 'header.php'; 
echo 'U.S. residents - you must enter your SS# / Tax ID in your profile, to receive payments from '.$Global['webpage_name'].'.';
echo '<br/><h4>Please enter your <strong> Social Security Number or Tax ID number</strong> to receive payments.</h4>
<br/>Once finished, you may make withdrawals. The minimum payout amount is $'.$minimum_payout.'.<br/><br/>';
if ($withdrawal_fee < 0) echo 'NOTE: There is a withdrawal fee of $'.abs($withdrawal_fee).'<br/><br/>';
echo "<form method=\"post\"><input class=\"form-control\" onMouseover=\"this.focus()\" size=\"25\" maxlength='9' name=\"tax_id\" value=\"".((!empty($_POST['tax_id']))?$_POST['tax_id']:'')."\"><br/><br/><input class=\"btn btn-primary\" type=\"submit\" value=\"Submit\" name=\"Submit\">\n</form>";

include 'footer.php'; 
exit;
} 

// FIND OUT IF MEMBER IS COLLECTING THEIR OWN PAYMENTS
// CHECK TO SEE IF THEY ALREADY PAID THE DEBIT CARD FEE!!
// FIND OUT IF MEMBER HAS ALREADY ENTERED THEIR LAST 4 DIGITS OF THEIR DEBIT CARD
$selectFields = 'payment_collected_by, paid_for_card, debitcard, payout_method';
$mainTable = 'members';
$where = ['ID' => ['=', $_SESSION['UserID']]];

$resultPaid = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
$bufferPaid = $resultPaid[0] ?? null;

$payout_method = $bufferpaid['payout_method'] ?? '';
$paid_for_card = $bufferpaid['paid_for_card'] ?? 'N';

if (($country !='US') || $buffer['payout_method']=='check' || $payout_method =='neteller')  {  // MEMBER IS INT'L, OR IS BEING PAID BY CHECK - OPEN THE BANK! 
// DO NOTHING - WE WILL SKIP THE REST OF THE LOCKDOWN SECURITY CHECKS NOW
} else if ($use_debit_card == true && $country !='US')  {  // MEMBER IS INT'L, SEND THEM TO BANKCARD PAGE TO ENTER IT! 
	header("Location: bankcard.php");
	exit;
} else { 

if ($use_debit_card == true && $paid_for_card == 'N' && ($_SESSION['admin_bypass'] == false)) {  // MEMBER HAS NOT PAID FOR CARD YET 
	//include 'header.php'; 
	echo $bank_bal_headline;
	echo 'NOTE: You have not yet paid for your debit card. You must have at least $'.$card_fee.' (from earned commissions) in your bank account, to purhase your debit card.';
	echo '<br/><br/>You can only make withdrawals, once you have a debit card to receive your funds.';

		if ($total_bal > $card_fee) { // THEY HAVE ENOUGH FUNDS TO BUY DEBIT CARD - SO SHOW THEM LINK TO BUY
		// QQQ
		//if ($use_debit_card == true) echo '<br/><br/>Please <a class="links" href="bankcard.php?apply=yes">click here to apply for your debit card</a>.';
		if ($use_debit_card == true) echo '<br/><br/><div style="text-align:center"><a href="bankcard.php?apply=yes"><img src="../images/DebitCrdBanner.png"></a></div>';
		}

	include 'footer.php'; 
	exit;
} else if ($use_debit_card == true) { // MEMBER HAS PAID FOR CARD...

	// FIND OUT IF MEMBER HAS ALREADY ENTERED THEIR LAST 4 DIGITS OF THEIR DEBIT CARD
	$selectFields = 'debitcard';
	$mainTable = 'members';
	$where = ['ID' => ['=', $_SESSION['UserID']]];

	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
	$buffer = $result[0];
	

	if ($buffer['debitcard'] == '' && $payout_method == '' && ($_SESSION['admin_bypass'] == false)) { // MEMBER HAS NOT CARD ENTERED IN PROFILE YET - SHOW BANK CARD LINK
	//include 'header.php'; 
	echo $bank_bal_headline;
	echo 'If you have already applied for, and received your debit card, please enter the <strong> LAST 4 DIGITS OF YOUR DEBIT CARD NUMBER</strong> to receive withdrawal payments to your debit card. Thank you!';
	echo "<br/><br/><form method=\"post\"><input class=\"form-control\" onMouseover=\"this.focus()\" size=\"25\" maxlength='4' name=\"debitcard\" value=\"".((!empty($_POST['debitcard']))?$_POST['debitcard']:'')."\">\n<input class=\"btn btn-primary\" type=\"submit\" value=\"Submit\" name=\"Submit\">\n</form>";

		if ($total_bal > $card_fee) { // THEY HAVE ENOUGH FUNDS TO BUY DEBIT CARD - SO SHOW THEM LINK TO BUY
		// QQQ
		//if ($use_debit_card == true) echo '<br/><br/>If you have not already applied for you card, please <a class="links" href="bankcard.php?apply=yes">click here to apply for your debit card</a>. You only need to apply once!';
		if ($use_debit_card == true) echo '<br/><br/><div style="text-align:center"><a href="bankcard.php?apply=yes"><img src="../images/DebitCrdBanner.png"></a></div>';
		}

	include 'footer.php'; 
	exit;
	} 
} // MEMBER PAID FOR CARD CHECK
} // END MEMBER IS INT'L

// RECRUITER / CUSTOMER REQUIREMENTS - MAKE SURE THEY HAVE 2 ACTIVE IN P2 AND ONE (ACTIVE IN P1 AND UNPAID IN P2)
// REQUIREMENTS: You must personally refer 2 marketing executives (P2) PLUS 1 customer (P1), to be qualified to withdraw funds.
// 1ST WE SEARCH PROGRM 2
// 1/25/22 CHANGED sponsorid to powerline_sponsor DUE TO COMPANY FILLED MATRIX WAS CHANGING THE SPONSORID.
/*$selectFields = 'COUNT(user_program_id) AS cnt';
$mainTable = 'user_program';
$where = [
    'powerline_sponsor' => ['=', $_SESSION['loggedin']],
    'user_status' => ['IN', ['Active', 'Comped']],
    'program_id' => ['=', '1']
];*/
// NEW WAY TO GET PAID STATUS
$selectFields = 'COUNT(ID) AS cnt';
$mainTable = 'members';
$where = [
    'sponsorid' => ['=', $_SESSION['loggedin']],
    'Status' => ['IN', ['paid']]
];

$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
$buffer = $result[0] ?? null;
$recruiter_count = $buffer['cnt'] ?? 0; // Total Active in P1

if (false && $recruiter_count < 1) {
	if ($recruiter_count == 1) $recruiter_text = 'personal team member'; else $recruiter_text = 'personal team members';
	if ($recruiter_count == 0) $recruiter_text = 'personal team members';
	

	echo '<strong>NOTE: You do not have the current requirements to be able to withdraw funds.</strong>';
	echo '<br/><br/>You must directly refer 1 personal team member<br><br>to be qualified to withdraw funds.';
	echo '<br/><br/>You currently have '.$recruiter_count.' '.$recruiter_text;
	include 'footer.php'; 
	exit;
}

/*

if ($recruiter_count < 2 || $customer_count < 1) {
	if ($recruiter_count == 1) $recruiter_text = 'marketing executive'; else $recruiter_text = 'marketing executives'; 
	if ($customer_count == 1) $customer_text = 'customer'; else $customer_text = 'customers';
	echo '<strong>NOTE: You do not have the current requirements to be able to withdraw funds.</strong>';
	echo '<br/><br/>You must personally refer 2 marketing executives ($299 Level)<br><br>PLUS 1 customer (WTPE Membership $69.97), to be qualified to withdraw funds.';
	echo '<br/><br/>You currently have '.$recruiter_count.' '.$recruiter_text.' and '.$customer_count.' '.$customer_text.'.';
	include 'footer.php'; 
	exit;
}*/
// END RECRUITER / CUSTOMER REQUIREMENTS
// END BANK LOCKDOWN
//*******************************************************************

		
// BANK OPENING PAGE!
/*
if($_REQUEST['type']==''){
echo "<a class="links" href=\"#\" onclick=\"return confirm('To Buy Additional Products, Click The My Account Tab - Top Right Hand Corner, For Options');\">Buy Products.</a>| <a class="links" href=\"bank.php?type=transfer\">Transfer Funds To Another Member</a> | <a class="links" href=\"bank.php?type=withdraw\">Process Withdrawal Request</a> | <a class="links" href=\"commission_view.php\"> Transaction History</a>";
include_once './footer.php';
exit;
*/
// FORCING ONLY WITHDRAWAL TYPE FOR NOW
$_REQUEST['type']='withdraw';


$number1=rand(1,10);
$number2=rand(1,5);

// TOTAL AMOUNT THAT WILL BE WITHDRAWN
// PREVENT SQL INJECTION!!
$amount = $_REQUEST['amount'] ?? 0;
$amount = (int) $amount;
$amt = $amount;
$amtnegative = -$amount;

if ($_REQUEST['type']=='transfer') {
// DECIDE HERE WHO GETS PAID, ETC.. 
$headline = 'Transfer Funds To Another Member';
$submit = 'Process Transfer Request';
$process ='Transfer';

// PREVENT SQL INJECTION!!
$user = $_POST['reward_user'];
$processed ='transferred to '.$user;

$selectFields = 'ID, Username';
$mainTable = 'members';
$where = [
    'Username' => ['=', $user]
];

$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
$buffer = $result[0];

$usrid = $buffer['ID'];
$desc = 'Transfer From '.$_SESSION['loggedin'];
$descdebit = 'Transfer To '.$buffer['Username'];
$trans = 'TRANSFER';

} else if ($_REQUEST['type']=='withdraw') {

	//$headline = 'Withdraw Funds';
	$headline = 'AVAILABLE FUNDS: $'.number_format($balance,2); 
	$submit = 'Process Withdrawal Request';
	$process = 'Withdrawal';
	$processed ='added to the payout queue';

	$usrid = $_SESSION['UserID'];
	$desc = 'PAYOUT';
	$trans = 'WITHDRAWAL';
	$amt = -$amount;
}

if (isset($_SESSION['dev']) && $_SESSION['dev'] == true && $_SESSION['debug'] == true) {
	echo 'user you are transferring funds to is: '.$user.'<br/>';
	echo 'usrid is: '.$usrid.'<br/>';
	echo 'amount (should be positive for transfers, negative for withdrawals) is: '.$amt.'<br/>';
	echo 'amount negative (only used on transfers) is: '.$amtnegative.'<br/>';
}

if (isset($_POST['action']) && $_POST['action'] == 'save') {

	$totalnum=$_SESSION['number1']+$_SESSION['number2'];


		if ($_POST['security']!=$totalnum) {
		$error .= 'Please input a valid security code <br />';
		}
		if (is_numeric($amount)){
		} else {
		$error .= 'Please input a valid amount.<br />';
		}
	 	if ($amount <= 0) {
		$error .= 'Amount must be greater than 0. <br />';
		}
	 	if ((($balance-$amount) < $reserve) && ($reserve > 0)) {
		$error .= 'A reserve amount of $'.$reserve.' is required to remain in your account, for your next subscription payment and withdrawal fee.<br />';
		}
		if ($amount > $balance) {
		$error .= 'Amount must be within your current available balance. <br />';
		}
		if ($_REQUEST['type']=='withdraw' && ($amount < $minimum_payout) && ($amount > $reserve)) {
		$error .= 'The minimum amount you may withdraw is $'.number_format($minimum_payout,2).'.<br />';
		}
		if ($_POST['reward_user'] != '' && $usrid == '') {
		$error .= 'No member with username '.$_POST['reward_user'].' exists! Please double check your information.<br />';
		}

		if(!$error){			

			// CREATE TRANSACTION LOGS
			// WITHDRAWALS OR TRANSFERS - $amt IS POSITIVE ON A TRANSFER, AND NEGATIVE ON WITHDRAWAL
			
			// Insert into `transactions_log`
			$insertData1 = [
				'usrid' => $usrid,
				'amount' => $amt,
				'description' => $desc,
				'transtype' => $trans,
				'logdate' => $datetimenow,
				'payout_date' => $payoutdate,
				'pay_status' => 'PENDING'
			];
			insert('transactions_log', $insertData1, 1, 1);

			$insertData2 = [
				'usrid' => $usrid,
				'amount' => $withdrawal_fee,
				'description' => 'Withdrawal Fee',
				'transtype' => 'DEBIT',
				'logdate' => $datetimenow,
				'payout_date' => $payoutdate,
				'pay_status' => 'PAID'
			];
			insert('transactions_log', $insertData2, 1, 1);

			if ($_REQUEST['type'] == 'transfer') { // DEBIT AS WELL ON TRANSFERS!!
				$insertData3 = [
					'usrid' => $_SESSION['UserID'],
					'amount' => $amtnegative,
					'description' => $descdebit,
					'transtype' => 'TRANSDEBIT',
					'logdate' => $datetimenow,
					'payout_date' => $datetimenow,
					'pay_status' => 'PAID'
				];
				insert('transactions_log', $insertData3, 1, 1);
			}
			
?> 
					<div style="text-align:center">
					<h3> <?php echo $process; ?> Request Complete!</h3>
					<br/><h5>The amount of <?php echo '$'.number_format($_REQUEST['amount'],2).' has been successfully '.$processed.'.</h5></div>';
					?>
					
					<div class="form-group">
					<div style="text-align:center"><br/>
					<form action="bankledger.php" method="POST">
					<input class="btn btn-primary btn-large" type="submit" value="Return To My Bank" name="submit" id="submit">
					</form>
					</div>
					</div>
					<?php
					
			// PREVENT REPOST ON REFRESH!!!
			$_POST['amount'] = '';
			$_SESSION['a'.$_SESSION['UserID']]['bank_ledger_visited'] = false; // require visiting bank ledger page next time this page is loaded
			$balance = '';
			unset($_POST);
			$_SESSION['number1']=0;
			$_SESSION['number2']=0;
				include 'footer.php'; 
				exit;
			}	// END NO ERROR	


//echo '&nbsp;'; 
if (!empty($error)) { ?>
<div style="color:red;"><h4><?php echo $error; ?></h4></div>
<?php 
//echo "<a class='links' href='bank.php'>Try Again</a></div>";
//include_once './footer.php';
//exit;
} // END ERROR			 
} // END SAVE

if (!isset($_POST['action']) || $_POST['action'] != 'save' || !empty($error)) {
 
$_SESSION['number1']=$number1;
$_SESSION['number2']=$number2;
 
echo "<div style=\"text-align:center\"><h3>".$headline."</h3>";
?>

<!-- 
<br/>
Members with no card can request a check payout, if in the USA, if abroad. 
<br/>If you already have a card, you will continue to get paid that way for the time being.
<br/><br/>
-->

<form method="post" name="myForm" onsubmit="document.getElementById('submit').disabled=true; document.getElementById('submit').value='Submitting, please wait...';">

<input type="hidden" name="action" value="save">
<input type="hidden" name="type" value="<?php echo $_REQUEST['type'];?>">

<table style="width: 380px; margin: auto;" cellpadding="5" cellspacing="10" >
<?php if (false && $_REQUEST['type']=='transfer') { ?>
<tr>
	<td style="vertical-align:top; width: 50%; margin: right;">

					Transfer To Member:</td>

					<td style="width: 50%; margin: left;">

				<input class="form-control" onMouseover="this.focus()" size="25" name="reward_user" value="<?php if(isset($_REQUEST['reward_user'])) : echo $_REQUEST['reward_user']; else : echo ''; endif; ?>" placeholder="email or username">
	</td>
</tr>
<?php } ?>

<tr>
	<td style="vertical-align:top; width: 50%; margin: right;">
<br/>
	<div class="form-group">
					Amount to <?php echo $process; ?>:</td>

					<td style="width: 50%; margin: left;">

				<input class="form-control" onMouseover="this.focus()" size="25" name="amount">
</div>
				</td>
</tr>



<tr>
	<td style="vertical-align:top; width: 50%; margin: right;">
 <div class="form-group">
					Security Add (<?php echo $number1; ?>+<?php echo $number2; ?>):</td>

					<td style="width: 50%; margin: left;">

				<input class="form-control" onMouseover="this.focus()" size="25" name="security">
</div>
				</td>
</tr>				
 
<tr>


<td colspan="2">
<br/>
 <div class="form-group">
<div style="text-align:center">

				<input class="btn btn-primary btn-large" type="submit" value="<?php echo $submit; ?>" name="submit" id="submit">
				<br>
				<br> 
				
				NOTE: 
				The minimum payout is $<?php echo $minimum_payout; ?>. 
				
				<?php if ($reserve > 0) { ?>
				Please also keep in mind, a reserve amount of $<?php echo $reserve; ?> is required to remain in your account, to cover your next subscription payment<?php } if (abs($withdrawal_fee) > 0) { ?>, plus $<?php echo abs($withdrawal_fee); ?> to cover your next withdrawal fee<?php } ?>.
				<br><br>
				Therefore, you may withdraw $<?php echo $minimum_payout; ?>, when your bank balance reaches $<?php echo $real_minimum_payout; ?> or more. Thank you.

</div>
</td>
</tr>
</table>
</div>
</div>

<p>&nbsp;</p>


				</form>


<?php } // END ACTION IS NOT "SAVE"
include_once './footer.php';
?>
