<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './logincheck.php';

if ($Global['use_bank'] != true) {
	header("Location: /Members/viewpayment.php");
	exit;
}

include ''.$Global['path'].'admin/Lib/Pagination.function.php';
// COMMENT WHEN TESTING IS DONE!!!
//$_SESSION['dev'] = '';
/*
if ($_SESSION['admin_login'] != true && $_GET['dev'] == '' && $_SESSION['dev'] == '' && $_SESSION['loggedin'] != 'jeff') { // LOCKING PAGE FOR DEVELOPER USE ONLY!!
include_once './header.php';
echo 'We\'re sorry. This area is temporarily down for maintenance. Please check back soon!';
include_once './footer.php';
exit;
} else {
$_SESSION['dev'] = true;
}
*/
$ID = $_SESSION['UserID'];

$show_notes = false;
if ($_SESSION['admin_session_view'] == true) $show_notes = true;

$cc_fee_rate = $Global['cc_fee_rate'];
$today = date("Y-m-d");
$datetimenow = date("Y-m-d H:i:s");

$_SESSION['a'.$_SESSION['UserID']]['bank_ledger_visited'] = true;

//Select the correct program	
if (!empty($_GET['program']) && intval($_GET['program']) > 0) $Global['program'] = intval($_GET['program']);
elseif (!empty($_SESSION['program']) && intval($_SESSION['program']) > 0) $Global['program'] = intval($_SESSION['program']);
else $Global['program'] = $Global['default_program'];
	
$_SESSION['program'] = $Global['program'];
	
//if its a specific program, check its program first
if (isset($Global['program']) && intval($Global['program']) > 0) { // FIND THE PROGRAM! WORKS!			
	// Define the fields to select
	$selectFields = ['program_id', 'header_file', 'footer_file', 'program_name'];

	// Specify the main table
	$mainTable = ['table' => 'program', 'as' => 'p'];

	// Define the WHERE conditions
	$where = [
		'p.program_approved' => ['=', 'Y'],
		'p.program_id' => ['=', sanitize($Global['program'], 'int')]
	];

	// Execute the query using the PHPCPR 'select' function
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
}
// Check if the result is not empty and assign the first record to $buffer
if (!empty($result)) {
    $buffer = $result[0];
} else {
    // Handle the case where no results are found
    $buffer = null;
}	


if (empty($Global['header'])) {
	$limit = '';
	$Global['program_name'] = '';
	$Global['header'] = 'header.php';
	$Global['footer'] = 'footer.php';
}

$Global['header'] = $Global['path'].'Sub/tpl/header_tpl.php';
$Global['footer'] = $Global['path'].'Sub/tpl/footer_tpl.php';

//echo $Global['footer']; exit;

// Check if indices are set before using them to avoid "Undefined index" notices
$logdate = isset($_POST['logdate']) ? $_POST['logdate'] : '';
$payout_date = isset($_POST['payout_date']) ? $_POST['payout_date'] : '';
$payment_processor = isset($_POST['payment_processor']) ? $_POST['payment_processor'] : '';
$amount = isset($_POST['amount']) ? $_POST['amount'] : '';
$transtype = isset($_POST['transtype']) ? $_POST['transtype'] : '';
$description = isset($_POST['description']) ? $_POST['description'] : '';
$pay_status = isset($_POST['pay_status']) ? $_POST['pay_status'] : '';
$paiddate = isset($_POST['paiddate']) ? $_POST['paiddate'] : '';
// Repeat the process for any other variables that are triggering the "Undefined index" notice


function format_number($number) {
    if (intval($number) == $number) {
        return number_format($number, 0);
    } else {
        return number_format($number, 2);
    }
}
	
// JS UPDATED PAGE 5/29/17 TO SUPPORT MIXED COMP PLANS TOGETHER (MATRIX TYPES, AND X-UP INSTANT PAY) 

$selectFields = ['SUM(amount) as balance'];
$mainTable = 'transactions_log';
$where = [
	'usrid' => ['=', $ID],
	'transtype' => ['IN', ['DEPOSIT', 'COMM']],
	'payout_date' => ['<=', $today],
	'description' => ['NOT IN', ['CHARGEBACKW', 'BANK DEPOSIT VERIFICATION']]
];
$groupBy = null;
$orderBy = null;
$limit = 0;
$show_debug = 1;

$result_comm = select($selectFields, $mainTable, [], $where, $groupBy, null, $orderBy, $limit, $show_debug);

if ($show_debug) {
	echo debug_stmt($result_comm);
}

// FIND ANY PENDING BANK COMMS - (WHERE PAYOUT DATE IS IN THE FUTURE)!
$buffer_comm = $result_comm ? reset($result_comm) : '';
$comm_total = $buffer_comm['balance'];

// Define the select fields
$selectFields = ['SUM(amount) AS balance'];

// Define the main table
$mainTable = 'transactions_log';

// Define the where conditions using the correct format for PHPCPR
$where = [
	'usrid' => ['=', "{$_SESSION['UserID']}"],
	'payout_date' => ['>', $today],
	'description' => ['NOT IN', ['CHARGEBACKW', 'BANK DEPOSIT VERIFICATION']]
];

// Call the select function from PHPCPR
$result_pending = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

// Assuming the select function returns an associative array of results
$buffer_pending = $result_pending[0];	

$pending_trans_logs = $buffer_pending['balance'];


// GET BANK BALANCE!
// Define the select fields
$selectFields = ['SUM(amount) AS balance'];

// Define the main table
$mainTable = 'transactions_log';

// Define the where conditions using the correct format for PHPCPR
$where = [
	'usrid' => ['=', "{$_SESSION['UserID']}"],
	'description' => ['NOT IN', ['CHARGEBACKW', 'BANK DEPOSIT VERIFICATION']]
];

// Call the select function from PHPCPR
$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

// Assuming the select function returns an associative array of results
$buffer = $result ? reset($result) : '';

$balance = $buffer['balance']+0;

// GET PENDING BALANCE!! // UPDATE SYSTEM TO STORE AMOUNTS IN USER PROGRAM, FOR BETTER PERFORMANCE!!
// First query to get user_program_id
$selectFields = ['user_program_id'];
$mainTable = 'user_program';
$where = ['ID' => ['=', "{$_SESSION['UserID']}"]];

// Call the select function from PHPCPR for the first query
$results = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

$total_earned = 0;

foreach ($results as $buffer) {
    // Inner query to calculate the sum
    $selectFields2 = ['SUM(log.amount) AS amt'];
    $mainTable2 = ['table' => 'payment_log', 'as' => 'log'];

	$joinConditions2 = [
		[
			'table' => 'user_program',
			'as' => 'u',
			'condition' => 'log.user_program_id = u.user_program_id'
		]];
    $where2 = [
        'log.user_program_id' => ['=', $buffer['user_program_id']],
        'log.cc_pending' => ['=', 'Y'],
        'log.payment_processor' => ['!=', 'VC']
    ];

    // Call the select function from PHPCPR for the inner query
    $result2 = select($selectFields2, $mainTable2, $joinConditions2, $where2, null, null, null, 0, 1);

    // Assuming the select function returns an associative array of results
    $buffer2 = $result2 ? reset($result2) : null;

    $total_earned += $buffer2 ? $buffer2['amt'] : 0;
}
$pending_payment_logs = $total_earned;

$pending = $pending_trans_logs + $pending_payment_logs;

// QQQ DO NOT SHOW PENDING ON MATRIX PROGRAMS!
$pending = 0;

$amt = $balance + $pending;

// CALCULATE AMOUNT OF CC FEES - $cc_fee_rate IS SET AT TOP OF THIS FILE
$cc_fees = ($pending * $cc_fee_rate);

// CACLCULATE PENDING MINUS FEES
$pending_minus_fees = ($pending - $cc_fees);

$pageName = 'My Bank';
$pageDesc = 'Available Balance: $'.number_format($balance,2) .' &nbsp;<i class="icon-wallet"></i> &nbsp; &nbsp;Net Commissions Pending: $'.$pending_minus_fees.' &nbsp;<span style="display:inline-block; vertical-align: middle; margin-top:-6px; font-size:10pt;"><i class="fa fa-hourglass-half"></i></span>';
$pageIcon = 'fa fa-bank';
$pageAlign = 'center';
$pageClass = '';	

include $Global['header'];

// QQQ
//echo $pageDesc; // NOW IN HEADER IN CURRENT THEME!

//NOTE: This page only shows payments the admin has collected on your behalf, and has marked as paid.<br />The Amount Paid shown below is your commission (minus Credit Card processing fees) the admin has paid out to you.<br /><br/>If you are receiving payments directly via your own merchant account, this page does not apply to you.<br /><br />';

//Select all programs 
$limit ="";
$user_id = $_SESSION['UserID'];

$today = date("Y-m-d");

// First query to count deposits and commissions
$selectFields = ['log.id'];
$mainTable = ['table' => 'transactions_log', 'as' => 'log'];
$where = [
    'log.usrid' => ['=', $user_id],
    'transtype' => ['IN', ['DEPOSIT', 'COMM']]
];

// Call the select function from PHPCPR for counting deposits and commissions
$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
$records = count($result);
$deposits = 'Total Deposits: ' . $records;

$buffer = ['amt' => 0]; // Default value

if ($records > 0) {
    // Second query to sum amounts for deposits and commissions
    $selectFields2 = ['SUM(log.amount) AS amt'];
    $where2 = [
        'log.usrid' => ['=', $user_id],
        'transtype' => ['IN', ['DEPOSIT', 'COMM']],
        'payout_date' => ['<=', $today]
    ];

    // Call the select function from PHPCPR for summing amounts
    $result2 = select($selectFields2, $mainTable, [], $where2, null, null, null, 0, 1);
    $buffer = $result2 ? reset($result2) : ['amt' => 0];
}

$sum_deposits = 'Sum Total Commission Deposits: $' . $buffer['amt'];
$tot_deposits = $buffer['amt'];

// Third query to count debits
$where = [
    'log.usrid' => ['=', $user_id],
    'transtype' => ['=', 'DEBIT']
];

// Call the select function from PHPCPR for counting debits
$resultsDebit = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
$recordsDebit = count($resultsDebit);
$debits = 'Total Debits: ' . $recordsDebit;

$bufferDebit = ['amt' => 0]; // Default value

if ($recordsDebit > 0) {
    // Fourth query to sum amounts for debits
    $selectFieldsDebit = ['SUM(log.amount) AS amt'];
    $resultDebit = select($selectFieldsDebit, $mainTable, [], $where, null, null, null, 0, 1);
    $bufferDebit = $resultDebit ? reset($resultDebit) : ['amt' => 0];
}

// Processing the results for debits
$sum_debits = 'Sum Total Debits: $' . $bufferDebit['amt'];
$tot_debits = $bufferDebit['amt'];



// First query to count pending withdrawals
$selectFields = ['log.id'];
$mainTable = ['table' => 'transactions_log', 'as' => 'log'];
$where = [
    'log.usrid' => ['=', $user_id],
    'transtype' => ['=', 'WITHDRAWAL'],
    'pay_status' => ['=', 'PENDING']
];

// Call the select function from PHPCPR for counting pending withdrawals
$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
$records = count($result);
$withdrawals = 'Total Withdrawals Pending: ' . $records;

$buffer = ['amt' => 0]; // Default value

if ($records > 0) {
    // Second query to sum amounts for pending withdrawals
    $selectFields2 = ['SUM(log.amount) AS amt'];
    $where2 = [
        'log.usrid' => ['=', $user_id],
        'transtype' => ['=', 'WITHDRAWAL'],
        'pay_status' => ['=', 'PENDING']
    ];
    $orderBy = 'log.id DESC';

    // Call the select function from PHPCPR for summing amounts
    $result2 = select($selectFields2, $mainTable, [], $where2, null, null, $orderBy, 0, 1);
    $buffer = $result2 ? reset($result2) : ['amt' => 0];
}

$sum_withdrawals = 'Sum Total Withdrawals Pending (Net Amount Due): $' . abs($buffer['amt']);

// First query to count transactions for deposits and commissions
$selectFields = ['log.id'];
$mainTable = ['table' => 'transactions_log', 'as' => 'log'];
$where = [
    'log.usrid' => ['=', $user_id],
    'transtype' => ['IN', ['DEPOSIT', 'COMM']],
    'payout_date' => ['>', $today]
];

// Call the select function from PHPCPR for counting transactions
$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
$trans_comms = count($result);

$buffer = ['amt' => 0]; // Default value

if ($trans_comms > 0) {
    // Second query to sum amounts for deposits and commissions
    $selectFields2 = ['SUM(log.amount) AS amt'];

    // Call the select function from PHPCPR for summing amounts
    $result2 = select($selectFields2, $mainTable, [], $where, null, null, null, 0, 1);
    $buffer = $result2 ? reset($result2) : ['amt' => 0];
}

// Third query to get payment log records
$selectFields3 = ['log.*'];
$mainTable3 = ['table' => 'payment_log', 'as' => 'log'];

$where3 = [
    'log.user_program_id' => is_array($_SESSION['upidlist']) ? ['IN', $_SESSION['upidlist']] : ['=', $_SESSION['upidlist']],
    'cc_pending' => ['=', 'Y'],
    'collected_by' => ['=', 'admin']
];

$orderBy3 = ['payment_log_id DESC'];

// Call the select function from PHPCPR for payment log records
$result3 = select($selectFields3, $mainTable3, [], $where3, null, null, $orderBy3, 0, 1);
$plog_comms = count($result3);


$tot_pending = $trans_comms + $plog_comms;
$comms = 'Total Commissions Pending: '.$tot_pending;

$sum_comms = 'Sum Total Commissions Pending: $'.$pending;
if ($cc_fees > 0) {
	$sum_comms .= " - $".number_format($cc_fees,2) . " Processing Fees = <strong>$" . number_format($pending - $cc_fees,2) . " Pending</strong>"; 
}

// First query to count paid out withdrawals
$selectFields = ['log.id'];
$mainTable = ['table' => 'transactions_log', 'as' => 'log'];
$where = [
    'log.usrid' => ['=', $user_id],
    'transtype' => ['=', 'WITHDRAWAL'],
    'pay_status' => ['=', 'PAID']
];


// Call the select function from PHPCPR for counting paid out withdrawals
$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
$records = count($result);
$withdrawals_paid = 'Total Withdrawals Paid Out: ' . $records;

$buffer = ['amt' => 0]; // Default value

if ($records > 0) {
    // Second query to sum amounts for paid out withdrawals
    $selectFields2 = ['SUM(log.amount) AS amt'];

    // Call the select function from PHPCPR for summing amounts
    $result2 = select($selectFields2, $mainTable, [], $where, null, null, null, 0, 1);
    $buffer = $result2 ? reset($result2) : ['amt' => 0];
}

// $buffer now contains the sum of amounts for paid out withdrawals
$sum_withdrawals_paid = 'Sum Total Withdrawals Paid Out: $'.$buffer['amt'];

echo '<br/><h2>Account Overview</h2>
<br/>';
//Bank Green
//$color[0] = 'A3FFA3';
// COOL LIGHT BLUE
$color[0] = 'f5f9fc';
$color[1] = 'FFFFFF';
$bgcolor = $color[0];

echo <<<EOD
<table class="col-xs-12 table table-bordered" style="width:100%; margin: 0 auto;">
<tr bgcolor="$bgcolor">
<td width="30%" class="text-info"><strong>$deposits</strong></td>
<td width="70%" style="text-align:left"> $sum_deposits </td>
</tr>

<tr bgcolor="$bgcolor">
<td width="30%" class="text-info"><strong>$comms</strong></td>
<td width="70%" style="text-align:left"> $sum_comms </td>
</tr>

<tr bgcolor="$bgcolor">
<td width="30%" class="text-danger"><strong>$debits</strong></td>
<td width="70%" style="text-align:left"> $sum_debits </td>
</tr>

<tr bgcolor="$bgcolor">
<td width="30%" class="text-danger"><strong>$withdrawals</strong></td>
<td width="70%" style="text-align:left"> $sum_withdrawals </td>
</tr>

<tr bgcolor="$bgcolor">
<td width="30%" class="text-info"><strong> $withdrawals_paid </strong></td>
<td width="70%" style="text-align:left"> $sum_withdrawals_paid </td>
</tr>


</table>
<br>
EOD;
$status_msg = '';
if (isset($buffer)) unset($buffer);
// Define the select fields and main table
$selectFields = ['*']; // Select all fields
$mainTable = 'pdf_files';

// Define the where condition
$where = ['ID' => ['=', $ID]];

// Call the select function from PHPCPR
$results = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

// Fetch the result - assuming the select function returns an associative array of results
$buffer = $results ? reset($results) : '';


/*
if ($_SESSION['loggedin'] == 'Kif01') {
	echo $qry."<br/>";
	echo 'got here';
	echo $_SESSION['p1_status'];
	echo $sum_deposits;
	echo $status_msg;
		print_r($buffer); 
}
*/	
// WE ONLY HAVE PPL FILL OUT TAX FORM, IF ACTIVE, AND HAVE EARNED $600 - TO CUT DOWN ON NEEDLESS ADMIN WORK
if ($_SESSION['p1_status'] == 'Active' && $tot_deposits >= 600) {

	if (isset($buffer['auth_date']) && $buffer['auth_date'] == '0000-00-00') {
		$status_msg = "Your tax file has been received, and is pending review.<br>If you need to make a correction, click below.";
	} else if (!isset($buffer['idx']) || $buffer['idx'] == '') {
		$status_msg = 'NOTE: You must supply a tax form to activate withdrawals.';
	}

}

// QQQ GL TWEAK - BYPASS - UNCOMMENT TO NOT SHOW TAX FORM UPLOAD REQUIREMENT!
$status_msg = '';

// WE ONLY HAVE PPL FILL OUT TAX FORM, IF ACTIVE, AND HAVE EARNED $600 - TO CUT DOWN ON NEEDLESS ADMIN WORK
if ($status_msg != '' && $_SESSION['p1_status'] == 'Active' && $tot_deposits >= 600) {
	echo '<p>&nbsp;</p><div class="alert alert-warning" role="alert"><h1>'.$status_msg.'</h1>';	
	echo '<a href="tax_man.php" class="btn btn-warning">Tax Form</a></div>';
} else {
	if (isset($buffer['idx']) && (isset($buffer['auth_date']) && $buffer['auth_date'] != '0000-00-00')) echo '<p><br><br>&nbsp;</p><button class="btn btn-info btn-sm">Tax Form Completed - Thank you!</button><br><br>';
?>

	<form enctype="multipart/form-data" method="post" action="bank.php">
	<input class="btn btn-success" type="submit" value="Withdraw Funds" name="submit">
	</form>
	<br/>

<?php
}

// ADDING PENDING PAYMENT LOGS HERE -- COMMENT OUT FOR MATRIX ONLY SYSTEMS!!
// THIS SECTION WAS DESIGNED ONLY FOR WHEN ADMIN PAYS OUT (ON TIERS OR POWERLINES) -- LEGACY AWS STRUCTURE
// WHEREAS MATRIX CODE IS RUN AS GIVE FILE AND DOES NOT USE payment_log 
if (false && $_SESSION['UserID'] == 1) { // QQQ SAFEGUARD -- ONLY SHOW TO ADMIN IN MATRIX SYSTEMS. THE SESSION upidlist WAS SOMETIMES PRESENT FOR ADMIN IN DEMO USER. AFTER MORE THOUGHT - ADMIN SHOULD NEVER SEE PENDING PAYMENTS ANYWAY!
	$result = mysql_query("SELECT log.* FROM payment_log as log WHERE log.user_program_id IN (".$_SESSION['upidlist'].") AND cc_pending='Y' AND collected_by='admin' AND payment_processor!='VC' ORDER BY payment_log_id DESC");
	$records = mysql_num_rows($result);

if ($records > 0) {

if ($cc_fee_rate == 0) $explain_cc_rate = '';
else $explain_cc_rate = '(Minus Fees)';
echo '<br/><h2>Commissions Pending</h2>';
if ($Global['cc_grace'] > 0) echo '<div style="color:red">NOTE: Commissions Pending '.$explain_cc_rate.' Get Deposited into your Available Balance after '.$Global['cc_grace'].' days.<br/><br/></div>';

//Bank Green
//$color[0] = 'A3FFA3';
// COOL LIGHT BLUE
$color[0] = 'f5f9fc';
$color[1] = 'FFFFFF';
$bgcolor = $color[0];

echo <<<EOD
<table class="table table-bordered" style="width:100%">
<tr bgcolor="$bgcolor"><td><strong>Status:</strong></td><td><strong>Member Payment Date:</strong></td><td><strong>Program Name:</strong></td><td><strong>Amount:</strong></td><td><strong>Paid by:</strong></td>
EOD;

$nr = 1;
$color_ctr = 1; // start with white

while ($buffer = mysql_fetch_assoc($result))
	{
	//The status of the payment
	if ($buffer['chargeback'] == 'Y') $status = '<font color="red">Refunded</font>'; 
	elseif ($buffer['cc_pending'] == 'Y') $status = '<font color="blue">Pending Period</font>'; 

	$payment_date = date('F, jS Y', $buffer['timestamp']);
	
	$payment_processor = $Global['processor_info'][$buffer['payment_processor']];

	if ($payment_processor == '') $payment_processor = 'First Data Global Gateway E4';

	if ($buffer['collected_by'] == 'admin') $payment_processor = '<font color="green">'.$Global['webpage_name'].'</font>';
	
	$amount = format_number($buffer['amount']);	
	
	if ($buffer['payment_type'] == 'PT') $type = 'Powerline and Tier Level '.$buffer['payment_tier_level'];
	elseif ($buffer['payment_type'] == 'P') $type = 'Powerline';
	elseif ($buffer['payment_type'] == 'T') $type = 'Tier Level '.$buffer['payment_tier_level'];
	
	$query_name = "SELECT First_Name, Last_Name from members where Username='".$buffer['payer_username']."'";
	$result_name = mysql_query($query_name);
	$buffer_name = mysql_fetch_assoc($result_name);
	
	$pname = "SELECT program_name from program where program_id='".$buffer['program_id']."'";
	$presult = mysql_query($pname);
	$pbuffer = mysql_fetch_assoc($presult);

	$program_name = $pbuffer['program_name'];

$bgcolor = $color[$color_ctr];	
//Display the payment information
echo <<<EOD
<tr bgcolor="$bgcolor"><td align="center">{$status}</td><td align="center">{$payment_date}</td><td align="center">{$program_name}</td><td align="center">\${$amount}</td><td align="center">{$buffer_name['First_Name']} {$buffer_name['Last_Name']} ({$buffer['payer_username']})</td>
EOD;
	$color_ctr = ($color_ctr + 1) % 2; // set color_ctr to add one, then take mod 2. This means it counts 1, 0, 1, 0, etc...
	}

echo '</tr></table>';
} // END SHOW PENDING LOGS
} // END COND SHOW TO PENDING LOGS
echo '<br/><h2>Debits & Withdrawals</h2>';
$bgcolor = $color[0];
if ($show_notes == true) $notes = '<td align="center" width="150px" class="smallheader"><strong>Notes:</strong></td>';
else $notes = '';
echo <<<EOD
<table class="table table-bordered">
<tr bgcolor="$bgcolor">
<td align="center" width="60px" class="smallheader"><strong>Type:</strong></td>
<td align="center" width="200px"  class="smallheader"><strong>Description:</strong></td>
<td align="center" width="100px" class="smallheader"><strong>Amount:</strong></td>
<td align="center" width="170px" class="smallheader"><strong>Log Date:</strong></td>

<td align="center" width="150px" class="smallheader"><strong>Pay Status:</strong></td>
<td align="center" width="150px" class="smallheader"><strong>Paid Date:</strong></td>

{$notes}
<!--<td width="150px" align="center"  class="smallheader"><strong>Processor:</strong></td>-->
<!--
<td align="center" width="150px" class="smallheader"><strong>Paid From:</strong></td>
<td align="center" width="150px" class="smallheader"><strong>Paid To:</strong></td>
-->
<!--<td align="center" width="150px" class="smallheader"><strong>Paid by:</strong></td>-->

</tr>
EOD;

// SHOW DEBITS & WITHDRAWALS
$selectFields2 = ['*']; // Select all fields
$mainTable2 = ['table' => 'transactions_log', 'as' => 'log'];

// Define the where conditions
$where2 = [
    'transtype' => ['IN', ['WITHDRAWAL', 'DEBIT']],
    'description' => ['!=', 'BANK DEPOSIT VERIFICATION'],
    'log.usrid' => ['=', $user_id]
];

// Define order by
$orderBy2 = ['log.logdate DESC'];


// Call the select function from PHPCPR
$result2 = select($selectFields2, $mainTable2, [], $where2, null, null, $orderBy2, 0, 1);

$master = array();
$nr = 1;
$color_ctr = 1; // start with white

// Process each row in the result
foreach ($result2 as $buffer2) {

		//$program_name = $buffer2['program_name'];
		$payment_date = $buffer2['logdate'];
		//$payment_processor = $Global['processor_info'][$buffer2['payment_processor']];
		//$real_payment_processor = $buffer2['payment_processor'];
		//$payment_info = $buffer2['custom_info'];
		//$paid_from = $bfresult['payer_username'];
		//$paid_by = $buffer2['custom_info'];
		$payment_processor = '';
		$paid_from = '';
		$paid_by = '';		
		$paid_to = $_SESSION['loggedin'];

		if (floor($buffer2['amount']) == $buffer2['amount']) {
			$amount = number_format($buffer2['amount']);
		} else {
			$amount = number_format($buffer2['amount'], 2);
		}

		$type = $buffer2['transtype'];
		$description = $buffer2['description'];
		$pay_status = $buffer2['pay_status'];
		if ($pay_status == "PENDING") $paiddate = "";
		else $paiddate = $buffer2['payout_date'];
		if ($show_notes == true) $notes = '<td align="center">'.$buffer2['status_explanation'].'</td>';
		else $notes = '';

		if ($description == '' && $buffer2['transtype'] == 'DEPOSIT') {
		$description = 'DEPOSIT';
		}
		
		if ($type == 'WITHDRAWAL') $paiddate = $buffer2['paiddate'];

$bgcolor = $color[$color_ctr];
echo <<<EOD
<tr bgcolor="$bgcolor">
<td align="center">{$type}</td>
<td align="center">{$description}</td>
<td align="center">\${$amount}</td>

<!--<td align="center"> {$program_name}</td>-->
<td align="center">{$payment_date}</td>
<td align="center">{$pay_status}</td>
<td align="center">{$paiddate}</td>
{$notes}

<!--<td align="center">{$payment_processor}</td>-->
<!--<td align="center">{$paid_from}</td>
<td align="center">{$paid_to}</td>-->
<!--<td align="center">{$paid_by}</td>-->

EOD;
	$color_ctr = ($color_ctr + 1) % 2; // set color_ctr to add one, then take mod 2. This means it counts 1, 0, 1, 0, etc...	
	}

echo <<<EOD
</tr>
</table>
EOD;

echo '<mark>Be sure you have listed a withdrawal method in your <a href="profile.php">profile</a>. ';
echo 'Please allow up to 72 hours for withdrawals to process.</mark>';

// QQQ IF NO MATRICES, USE BELOW LINE
if ($Global['use_matrix'] == false) {
	echo '<br/><h2>Deposits</h2>';
} else {
	echo '<br/><h2>Deposits & Commissions</h2>';
	// THE REASON BEHIND THIS - DEPOSITS ARE DONE WITH A DIFFERENT PROCESS
	// DEPOSITS ARE MATURED COMMISSIONS FROM X-UP AND TIER PROGRAMS
	// COMMS ARE FROM BINARY OR FORCED MATRIX TYPE PROGRAMS
}
// ADDING DEPOSITS IN NEW TABLE HERE
if ($show_notes == true) $notes = '<td align="center" width="150px" class="smallheader"><strong>Notes:</strong></td>';
else $notes = '';
echo <<<EOD
<table class="table table-bordered">
<tr bgcolor="{$color[0]}">
<td align="center" width="60px" class="smallheader"><strong>Type:</strong></td>
<td align="center" width="200px"  class="smallheader"><strong>Description:</strong></td>
<td align="center" width="100px" class="smallheader"><strong>Amount:</strong></td>
<td align="center" width="170px" class="smallheader"><strong>Deposit Date:</strong></td>
{$notes}
<!--<td width="150px" align="center"  class="smallheader"><strong>Processor:</strong></td>-->
<!--
<td align="center" width="150px" class="smallheader"><strong>Paid From:</strong></td>
<td align="center" width="150px" class="smallheader"><strong>Paid To:</strong></td>
-->
<!--<td align="center" width="150px" class="smallheader"><strong>Paid by:</strong></td>-->

</tr>
EOD;

// GET THE TOTAL COUNT!
// Define the select fields and main table
$selectFields = ['COUNT(DISTINCT ID) AS cnt'];
$mainTable = 'transactions_log';

// Define the where conditions
$where = [
    'transtype' => ['IN', ['DEPOSIT', 'COMM']],
    'usrid' => ['=', $user_id]
];

// Call the select function from PHPCPR
$results = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

// Fetch the result - assuming the select function returns an associative array of results
$buffer = $results ? reset($results) : '';


//paging params
$results_per_page = 25;
$total_pages = ceil($buffer['cnt']/$results_per_page);
$page = (isset($_GET['page']) && ctype_digit((string)$_GET['page']) ? $_GET['page']:1);
if ($page > $total_pages && $total_pages > 0) {
	$page = $total_pages;
} elseif ($page < 1) {
	$page = 1;
}

//GET REAL DATA
$selectFields = ['*']; // Select all fields
$mainTable = 'transactions_log';

// Define the where conditions
$where = [
    'transtype' => ['IN', ['DEPOSIT', 'COMM']],
    'usrid' => ['=', $user_id]
];

// Call the select function from PHPCPR for the row count query
$result_rows = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
$rows = count($result_rows);

// Define the query with ORDER BY and LIMIT
$offset = ($page - 1) * $results_per_page;

	$limit = [
		'offset' => $offset,	
		'count' => $results_per_page
	];

$orderBy = ['logdate DESC'];

// Call the select function from PHPCPR for the main query
$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, 1);
$rows = count($result);

$master = array();
$nr = 1;

//Bank Green
//$color[0] = 'A3FFA3';

// COOL LIGHT BLUE
$color[0] = 'f5f9fc';

$color[1] = 'FFFFFF';
$color_ctr = 1; // start with white
foreach ($result as $buffer2) {	

		//$program_name = $buffer2['program_name'];
		$payment_date = $buffer2['logdate'];
		$payout_date = $buffer2['payout_date'];
		//$payment_processor = $Global['processor_info'][$buffer2['payment_processor']];
		//$real_payment_processor = $buffer2['payment_processor'];
		//$payment_info = $buffer2['custom_info'];
		//$paid_from = $bfresult['payer_username'];
		//$paid_by = $buffer2['custom_info'];
		// NEXT 3 LINES TO STOP WARNINGS - EVEN IN COMMENTED CODE!
		$payment_processor = '';
		$paid_from = '';
		$paid_by = '';		
		$paid_to = $_SESSION['loggedin'];
		//$amount = number_format($buffer2['amount'], 0);
		$amount = format_number($buffer2['amount']);		
		$type = $buffer2['transtype'];
		$description = $buffer2['description'];
		$pay_status = $buffer2['pay_status'];
		$paiddate = $buffer2['paiddate'];
		if ($show_notes == true) $notes = '<td align="center">'.$buffer2['status_explanation'].'</td>';
		else $notes = '';		
		
		if ($description == '' && $buffer2['transtype'] == 'DEPOSIT') {
			$description = 'DEPOSIT';
		}		
		
		$bgcolor = $color[$color_ctr];

	if ($payment_date == $payout_date) {
		$payment_date_display = $payment_date;
	} else if ($payout_date > date("Y-m-d")) {
		$payment_date_display = $payout_date . " *PENDING ";
	} else {
		$payment_date_display = $payout_date;
	}


echo <<<EOD
<tr bgcolor="$bgcolor">
<td align="center">{$type}</td>
<td align="center">{$description}</td>
<td align="center">\${$amount}</td>

<!--<td align="center"> {$program_name}</td>-->
<td align="center">{$payment_date_display}</td>
{$notes}

<!--<td align="center">{$payment_processor}</td>-->
<!--<td align="center">{$paid_from}</td>
<td align="center">{$paid_to}</td>-->
<!--<td align="center">{$paid_by}</td>-->

EOD;
		$color_ctr = ($color_ctr + 1) % 2; // set color_ctr to add one, then take mod 2. This means it counts 1, 0, 1, 0, etc...	
	}
?>

</tr>
</table>


</td></tr>


<tr>
	<td colspan="4" align="right"><?php echo pagination_links($page, $total_pages, 6, 'bankledger.php?', array('page' => 'Page', 'first' => 'first', 'last' => 'last')); ?></td>
</tr>
</table>


<?php
if (false && $_SESSION['loggedin'] == 'admin') echo '<h4>Admin please note! "DEPOSIT" transactions are actual earnings. "COMM" transactions denote cycle and bonus "commissions" -- which are derived from the initial payments, shown as deposits.</h4>';

/*
echo <<<EOD
<br /><br />
* Indicates a Deposit was paid using Bank Funds, which have no transaction fees. 
<br /><br />
EOD;
*/
include $Global['footer'];
/*
  `usrid` int(11) NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `payment_log_id` int(11) NOT NULL,
  `description` text NOT NULL,
  `transtype` varchar(10) NOT NULL,
  `logdate` datetime NOT NULL,
  `payout_date` date NOT NULL,
  `pay_status` varchar(10) NOT NULL COMMENT 'PENDING, PAID, CANCELLED',
  `paiddate` datetime NOT NULL,
  `status_explanation` text NOT NULL,
*/
?>