<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------

// BYPASS SANITIZING EMAIL SUBJ / MSG!
if (isset($_POST['subject'])) $_POST['aws_subject'] = $_POST['subject'];
if (isset($_POST['message'])) $_POST['aws_message'] = $_POST['message'];

include './logincheck.php';

// NOW WE GET THE UNSANITIZED SUBJ / EMAIL MSG!
if (isset($_POST['aws_subject'])) $_POST['subject'] = $_POST['aws_subject'];
if (isset($_POST['aws_message'])) $_POST['message'] = $_POST['aws_message'];

if (!isset($Global['use_html_email'])) $Global['use_html_email'] = false;

if ($Global['use_html_email'] == true) {
include './../Inc/cuteeditor_files/include_CuteEditor.php';
}
	
$pageName = 'Email Team';
$pageDesc = 'Encourage & Support Your Team!';
$pageIcon = 'fa fa-send';
$pageAlign = 'center';
$pageClass = '';	


//Select the correct program	
if (!empty($_GET['program']) && intval($_GET['program']) > 0) $Global['program'] = intval($_GET['program']);
elseif (isset($_POST['program']) && intval($_POST['program']) > 0) $Global['program'] = intval($_POST['program']);
elseif (!empty($_SESSION['program']) && intval($_SESSION['program']) > 0) $Global['program'] = intval($_SESSION['program']);
else $Global['program'] = $Global['default_program'];

$_SESSION['program'] = $Global['program'];

if ($Global['program'] > 0) { // FIND THE PROGRAM! WORKS!			
	// Define the fields to select
	$selectFields = ['program_id', 'header_file', 'footer_file'];

	// Specify the main table
	$mainTable = ['table' => 'program', 'as' => 'p'];

	// Define the WHERE conditions
	$where = [
		'p.program_approved' => ['=', 'Y'],
		'p.program_id' => ['=', sanitize($Global['program'], 'int')]
	];

	// Execute the query using the PHPCPR 'select' function
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
}
// Check if the result is not empty and assign the first record to $buffer
if (!empty($result)) {
    $buffer = $result[0];
} else {
    // Handle the case where no results are found
    $buffer = null;
}

			
if (!empty($buffer['program_id'])) {
	$Global['header'] = './../Sub/tpl/'.$buffer['header_file'];
	$Global['footer'] = './../Sub/tpl/'.$buffer['footer_file'];
} else {
	$Global['header'] = './real_header.php';
	$Global['footer'] = './footer.php';
}


//Process the email request
if (isset($_POST['email']) && $_POST['email'] == 'send') {
	//$program = false;
	if (empty($_POST['subject']) || empty($_POST['message'])) {
		$Error_msg = 'Please fill out both the subject and message.';
	}
	//elseif ($program === false) {
		//$Error_msg = 'Please select a program.';
		//}	
		
	//Find out if you have a active subscription to this program
	// Define the fields to select
	$selectFields = 'user_status';

	// Specify the main table and the join conditions
	$mainTable = ['table' => 'user_program', 'as' => 'u'];
	$joinConditions = [
		['table' => 'members', 'as' => 'm', 'condition' => 'u.ID = m.ID']
	];

	// Define the WHERE conditions
	$where = [
		'm.Username' => ['=', $_SESSION['loggedin']],
		/*'u.program_id' => ['=', $Global['program']]*/
		'u.user_status' => 'Active' // IF ACTIVE IN ANY PROGRAM, THEY CAN USE MAILER!
		
	];

	// Execute the query using your PHPCPR 'select' function
	$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, 1, 1);
	$buffer = isset($result[0]) ? $result[0] : null;
	
	$Global['good_status'] = ['Active', 'Comped'];
	
	if (!isset($buffer['user_status']) || !in_array($buffer['user_status'], $Global['good_status'])) {
		$Error_msg = 'You need an active account to email your team.';
	}

	if (empty($Error_msg)) {
		$timestamp = time() - (86400 * $Global['downline_email']);
		
		//Check if he has already emailed the downline the last xx days
		// Define the fields to select
		$selectFields = ['log.downline_log_id', 'log.timestamp'];

		// Specify the main table and the join conditions
		$mainTable = ['table' => 'members', 'as' => 'memb'];
		$joinConditions = [
			['table' => 'user_program', 'as' => 'prog', 'condition' => 'memb.ID = prog.ID'],
			['table' => 'downline_log', 'as' => 'log', 'condition' => 'prog.user_program_id = log.user_program_id']
		];

		// Define the WHERE conditions
		$where = [
			'memb.Username' => ['=', sanitize($_SESSION['loggedin'])],
			'prog.program_id' => ['=', sanitize($Global['program'], 'int')],
			'log.timestamp' => ['>=', sanitize($timestamp, 'int')]
		];

		// Execute the query using your PHPCPR 'select' function with additional parameters
		$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, 'downline_log_id DESC', 0, 1);

		// Check if the result is not empty and assign the first record to $buffer
		if (!empty($result)) {
			$buffer = $result[0];
		} else {
			// Handle the case where no results are found
			$buffer = null;
		}
		
		
		$today = date("Y-m-d");
		$timestamp_date = date("Y-m-d", $buffer['timestamp']);
	
		if (!empty($buffer['downline_log_id']) && $timestamp_date === $today) {
			$Error_msg = 'You have already emailed this team on '.date('F, jS Y', $buffer['timestamp']).'. Keep in mind you are only allowed to email it once every '.$Global['downline_email'].' days';
		}
	} // end empty($Error_msg)


	if (empty($Error_msg)) {
		$total_number = 0;

		// GET LOGGED IN USER'S INFO!			
		// Define the fields to select
		$selectFields = ['memb.ID', 'memb.First_Name', 'memb.Last_Name', 'memb.email', 'user.user_program_id', 'prog.program_name'];

		// Specify the main table and the join conditions
		$mainTable = ['table' => 'members', 'as' => 'memb'];
		$joinConditions = [
			['table' => 'user_program', 'as' => 'user', 'condition' => 'memb.ID = user.ID'],
			['table' => 'program', 'as' => 'prog', 'condition' => 'user.program_id = prog.program_id']
		];

		// Define the WHERE conditions
		$where = [
			'memb.Username' => ['=', sanitize($_SESSION['loggedin'])],
			'prog.program_id' => ['=', sanitize($Global['program'], 'int')]
		];

		// Execute the query using your PHPCPR 'select' function with additional parameters
		$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, 0, 1);

		// Check if the result is not empty and assign the first record to $buffer
		if (!empty($result)) {
			$buffer = $result[0];
		} else {
			// Handle the case where no results are found
			$buffer = null;
		}
		

		$sender_id = $_SESSION['UserID'];
		$user_program_id = $_SESSION['p'.$Global['program'].'_upid'];
		$sender_email = $_SESSION['Email_loggedin'];
		
		
		//Create the text that will be added at the bottom of the email
		//Custom Tags : [webpage_name] [program_name] [firstname] [lastname] [unsubscribe_link]
		$text_replace = array('[webpage_name]', '[program_name]', '[firstname]', '[lastname]', '[unsubscribe_link]');	
		$text_replace_with = array($Global['webpage_name'], $buffer['program_name'], $buffer['First_Name'], $buffer['Last_Name'], $Global['webpage_url'].'leave.php?id=[UNSUBID]');
		
		$sender_text = str_replace($text_replace, $text_replace_with, $Global['unsubscribe_email_text']);				  
			
		$email_subject = $_POST['subject'];
		$email_message = $_POST['message']."\r\n\r\n".$sender_text;

		//FIND YOUR PERSONAL DIRECT DOWNLINE
		// Define the fields to select
		$selectFields = ['prog.ID', 'memb.ID', 'memb.Username', 'memb.First_Name', 'memb.Last_Name', 'memb.email', 'memb.unsubscribe_id'];

		// Specify the main table and the join conditions
		$mainTable = ['table' => 'user_program', 'as' => 'prog'];
		$joinConditions = [
			['table' => 'members', 'as' => 'memb', 'condition' => 'prog.ID = memb.ID']
		];

		// Define the WHERE conditions
		$where = [
			'prog.sponsorid' => ['=', sanitize($_SESSION['loggedin'])],
			'prog.program_id' => ['=', sanitize($Global['program'], 'int')],
			'memb.Username' => ['!=', sanitize($_SESSION['loggedin'])],
			'memb.Username' => ['!=', 'DELETED'],
			'memb.Status' => ['!=', 'Cancelled'],
			'memb.email' => ['!=', '']			
		];
		
		if ($_POST['memsend'] == 1) {
			$where['prog.user_status'] = ['=', 'Active'];
		}
		if ($_POST['memsend'] == 2) {
			$where['prog.user_status'] = ['=', 'Unpaid'];
		}			

		// Additional parameters for grouping and ordering
		$groupBy = 'memb.email';
		$orderBy = 'prog.sign_id';

		// Execute the query using your PHPCPR 'select' function
		$result = select($selectFields, $mainTable, $joinConditions, $where, $groupBy, null, $orderBy, 0, 1);


		$headers = "From: ".stripslashes($Global['downline_admin_email'])." <".$Global['downline_admin_email']."> \r\n";
		$headers .="Reply-To: ".stripslashes($sender_email)." <".$sender_email."> \r\n";
		$headers .="X-Mailer: PHP/" . phpversion()."\r\n";
		$headers .= "MIME-Version: 1.0\r\n";
		$headers .= "Content-Type: text/plain; charset=UTF-8\r\n";		
		$dwnlnemail = "-f".$Global['downline_admin_email'];
		
		
		// Process the result
		foreach ($result as $buffer) {

			//if ($buffer['sign_id'] > $Global['up_powerline']) $username[1][] = $buffer['Username'];
				
			$replace_name = array('[USERNAME]', '[FIRSTNAME]', '[LASTNAME]', '[UNSUBID]');					
			$replace_with = array($buffer['Username'], $buffer['First_Name'], $buffer['Last_Name'], $buffer['unsubscribe_id']);
				
			$subject = str_replace($replace_name, $replace_with, $email_subject);
			$message = str_replace($replace_name, $replace_with, $email_message);

			//Send the email to direct downline + unpaid direct downline			
			mail($buffer['email'], stripslashes($subject), stripslashes($message), $headers, $dwnlnemail);
			++$total_number;			
		}
		

		$subject = 'Team Email From '.$_SESSION['loggedin'].' Sent To '.$total_number.' Users';
		$message = "Subject:\r\n".$email_subject."\r\n\r\nMessage:\r\n".$email_message;
			
		if ($total_number > 0) {
			mail($Global['downline_admin_email'], stripslashes($subject), stripslashes($message), $dwnlnheaders, $dwnlnemail);
			$Error_msg = $total_number.' Email(s) Successfully Sent!';
			
			//Add the email to the downline log, so he cant email it again before xx days
			// Prepare the data to be inserted
			$data = [
				'user_program_id' => $user_program_id,
				'timestamp' => time(),
				'subject' => $email_subject,
				'message' => $email_message
			];

			// Execute the insert using PHPCPR 'insert' function
			insert('downline_log', $data, 1, 1);			
			
		} else {
			$Error_msg = ' No Team To Email -- No Emails Sent.';
		}		
	} // END empty error
} // END POST!
		

$do_not_display_ads = true; // AD FILE BREAKS THIS PAGE!
//if ($_SESSION['loggedin'] == 'demo') $GLOBALS['debug'] = true;
//if ($_SESSION['loggedin'] != 'demo') include $Global['header'];

include $Global['header'];

// SELECT FROM ALL PROGRAMS 
// Define the fields to select - using '*' for all fields
$selectFields = '*';

// Specify the main table
$mainTable = ['table' => 'program', 'as' => 'p'];

// Define the WHERE conditions and ORDER BY clause
$where = [
    'p.program_approved' => ['=', 'Y']
];

$orderBy = 'p.program_id'; // Change to 'p.program_name' if you want to order by name

// Execute the query using your PHPCPR 'select' function
$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, 0, 1);

$program_info = '<option value="0">Select A Program</option>';
$program_name = '';

foreach ($result as $buffer) {
    $selected = (!empty($Global['program']) && $Global['program'] == $buffer['program_id']) ? ' selected' : '';
    $program_name .= (!empty($selected)) ? $buffer['program_name'].' ' : '';

    $program_info .= '<option value="'.$buffer['program_id'].'"'.$selected.'>'.$buffer['program_name'].'</option>';
}	

// END SELECT PROGRAM

// POST IS ALREADY SANITIZED!
if (!empty($_POST['subject'])) $subject = $_POST['subject'];
else $subject = '';

if (!empty($_POST['message'])) $message = $_POST['message'];
else $message = '';

if (!empty($Error_msg)) $Error = '<span color="red"><strong>'.$Error_msg.'</strong></span><br /><br />';
else $Error = '';
?>

<div class="table-responsive">
  <table class="table">
    <tr><td style="background-color: #FFFFFF">
      <h2>Email <?php echo $program_name; ?> Team</h2>
      <?php echo $Error; ?>
      <form enctype="multipart/form-data" method="post" action="emailteam.php">
        <input type="hidden" name="email" value="send">
        Program:<br />
        <select name="program" class="form-control">
          <?php echo $program_info; ?>
        </select><br /><br />
        Send Email To:<br />
        <select name="memsend" class="form-control">
          <option value="3" <?php if (isset($_POST['memsend']) && $_POST['memsend'] == '3') echo 'selected'; ?>>All Members</option>
          <option value="2" <?php if (isset($_POST['memsend']) && $_POST['memsend'] == '2') echo 'selected'; ?>>Only Unpaid Program Members</option>
          <option value="1" <?php if (isset($_POST['memsend']) && $_POST['memsend'] == '1') echo 'selected'; ?>>Only Active Program Members</option>
        </select><br />
        <br />
        Subject:<br>
        <input type="text" name="subject" value="<?php echo htmlspecialchars($subject); ?>" size="89" class="form-control"><br>
        <br>
        Message:<br>
        <textarea cols="91" rows="16" name="message" class="form-control"><?php echo htmlspecialchars($message); ?></textarea><br>
        You can use these tags to make the emails more personal (Both in subject and the message):<br>
        <br>
        To display their username use: [USERNAME]<br>
        For their first name use: [FIRSTNAME]<br>
        And for last name use: [LASTNAME]<br>
        <br>
        <div style="color:red">
          *Important Note<br>
          The email function is to be used ONLY to support your team.<br>
          It is NOT to be used to cross promote other programs, unless they are used to promote <?php echo $Global['webpage_name_short']; ?>.<br> 
        </div>
        <br/>
        All emails will be logged and reviewed by our staff.<br />
        <br />
        <input type="submit" value="Send Email" name="Send Email" class="btn btn-info btn-default">
      </form>
    </td></tr>
  </table>
</div>


<?php	
include $Global['footer'];
?>