<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include 'logincheck.php'; 
// FILE BORN FROM advanced_viewer.php
$mat_config = $GLOBALS['mat_config'];
$pageName = 'Leaderboard Rank'; // THIS IS SHOWN AS A BREADCRUMB UNDER THE MENU, AND IS ALSO USED AS THE PAGE TITLE, IF $pageDesc IS LEFT EMPTY.
$pageDesc = ''; // IF USED, THIS IS SHOWN AS THE TITLE IN THE PAGE (BLUE BAR SECTION, END OF HEADER), REPLACING $pageName.
$pageIcon = 'fa fa-bullhorn'; // THE ICON USED IN THE PAGE
$pageAlign = 'center'; // HOW YOU WANT TO ALIGN THE PAGE CONTENT
$pageClass = ''; // FOR CUSTOM PROGRAMMING USES

// QQQ SET PER PROGRAM - LIST IDS TO EXCLUDE, SEPARATED BY COMMAS
//$exclude_ids = [0, 1]; // DEFAULT - ONLY ADMIN IS EXCLUDED
$exclude_ids = [0, 1, 30, 31, 32, 33, 34, 35, 36, 37, 38, 46]; // QQQ CUSTOM PER CLIENT
//30 VAL SMYTH, 31, JEREMY DUNCAN, 46 DAVE LEAR, 32-38 ADMINS

// COMMENT WHEN TESTING IS DONE!!!
//$_SESSION['dev'] = '';
/*
if ($_SESSION['admin_login'] != true && $_GET['dev'] == '' && $_SESSION['dev'] == '' && $_SESSION['loggedin'] != '') { // LOCKING PAGE FOR DEVELOPER USE ONLY!!
include_once './header.php';
echo 'We\'re sorry. This area is temporarily down for maintenance. Please check back soon!';
//echo 'Launching soon!';
include_once './footer.php';
exit;
} else {
$do_not_display_ads = true;	
$_SESSION['dev'] = true;
}
*/


//$do_not_display_ads = true;
include './header.php';
//$this_page = '.php';
$debug = false;
//$debug = true;
$debug2 = false;
//$debug2 = true;
if ($_SESSION['admin_login'] == true) $debug2 = true;
$show_name = false;
//$show_name = true;

$_SESSION['debug'] = false;
//if ($_SESSION['admin_login'] == true) $_SESSION['debug'] = true;

/*if ($_SESSION['admin_login'] != true && $_SESSION['UserID'] > 4 && $_SESSION['loggedin'] != 'fisherman' && $_SESSION['loggedin'] != 'fisherman2') {
	echo 'launching soon';
	exit;
}*/
// DEFINE USER RANKS, COLORS, QUALIFICATIONS!!
$rank_levels = 2; // HOW MANY RANK LEVELS DOES THE PROGRAM HAVE?

// LIST EACH RANK LEVEL NAME
$rank1_name = 'Legend';
$rank2_name = 'Rock Star';
$rank3_name = 'Gold';
$rank4_name = 'Platinum';
$rank5_name = 'Diamond';

// LIST EACH RANK COLOR
$rank1_color = '#CD7F32'; // Bronze-like color
$rank2_color = '#C0C0C0'; // Silver-like color
$rank3_color = '#FFD700'; // Gold-like color
$rank4_color = '#E5E4E2'; // Platinum-like color, a bit lighter than silver for distinction
$rank5_color = '#B9F2FF'; // Diamond-like color, reflecting a bright and shiny appearance

$rank1_color = 'blue';
$rank2_color = 'gold';

// LIST EACH RANK QUALIFIER NUMBER (HOW MANY DIRECT SALES THEY NEED TO REFER, TO EARN THIS RANK?
$rank1_qualifiers = 4;
$rank2_qualifiers = 12;
$rank3_qualifiers = 3;
$rank4_qualifiers = 4;
$rank5_qualifiers = 5;

// END DEFINE USER RANKS, COLORS, QUALIFICATIONS!! -- NO CONFIG UPDATES NEEDED BELOW THIS POINT!

$qualified_icon1 = '<i class="fa fa-star" style="color:'.$rank1_color.'"></i>';
$qualified_icon2 = '<i class="fa fa-star" style="color:'.$rank2_color.'"></i>';
$qualified_icon3 = '<i class="fa fa-star" style="color:'.$rank3_color.'"></i>';
$qualified_icon4 = '<i class="fa fa-star" style="color:'.$rank4_color.'"></i>';
$qualified_icon5 = '<i class="fa fa-star" style="color:'.$rank5_color.'"></i>';

$cancelled_icon = '<i class="fa fa-ban" style="color:red"></i>';
$user_icon = '<i class="fa fa-user" style="color:#428bca"></i>';
?>
	<style>
.uname {
  font-size: .9em;
}  

.sponsor {
  background-color: #e5f3fb; 
  font-size: .9em;
}

.user {
  position: relative;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;	
 /* background-color: #ffffff;*/
}

.user:hover {
 /* background-color: #d1ecf1;*/
}


.glink {
  text-decoration: none;
}

.innerdiv {
  width: 7em;	
  margin-top: -15px;
  margin-bottom:-15px;
}

		</style>
<?php		
$ID = $_SESSION['UserID'];


$GLOBALS['path'] = $Global['path'];
$GLOBALS['webpage_url_ssl'] = $Global['webpage_url_ssl'];

function getsponsorusrid($usrid){
	
	if ($_SESSION['debug'] == true) echo 'BEGIN getsponsorusrid<br>';
	
	$selectFields = 'sponsorid';
	$mainTable = 'members';
	$where = ['ID' => $usrid];

	// Call the PHPCPR select function	
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
	$buffer = isset($result[0]) ? $result[0] : null;

	$sponsor_username = $buffer['sponsorid']; // THE SPONSOR'S UNAME
	
	$selectFields = 'ID';
	$mainTable = 'members';
	$where = ['Username' => $sponsor_username];

	// Call the PHPCPR select function
	$result2 = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
	$buffer2 = isset($result2[0]) ? $result2[0] : null;
	
	if (isset($buffer2['ID'])) $sponsorid = $buffer2['ID'];
	else $sponsorid = 0;
	
	if ($_SESSION['debug'] == true) echo 'sponsorid is: '.$sponsorid.' END getsponsorusrid<br>';		
	return $sponsorid;
}


function getImage($check_id) {				
	$image_exists = false; // INI VAR!
	$image_path = $GLOBALS['path'].'images/Users/'.floor(($check_id / 1000)).'/'.$check_id.'.jpg';

	if (file_exists($image_path)) {
		$image_exists = true;
		$image_url = $GLOBALS['webpage_url_ssl'].'images/Users/'.floor(($check_id / 1000)).'/'.$check_id.'.jpg';
	}				

	if ($image_exists == true) {
		$display_img = '<img alt="team member picutre" class="img-circle mat-img-circle" src="'.$image_url.'" /><br>';
		//echo 'image yes';
	} else if ($check_id > 0) {
		//$display_img = '<i class="fa fa-user fa-3x center" style="text-align:center; color:#aaa"></i>';
		$display_img = '<img alt="default image" class="mat-img-circle" src="/images/user.png" />';
		$display_img = '<div class="fa-user icon-large" style="color:#aaa"></div>';
		$display_img = '<img alt="team member picutre" class="img-circle mat-img-circle no-pic" src="'.$GLOBALS['webpage_url_ssl'].'images/user.png" /><br>';	
	} else {
		$display_img = '<img alt="default image" class="img-circle mat-img-circle no-pic" src="'.$GLOBALS['webpage_url_ssl'].'images/no-user.png" /><br><span>OPEN SLOT</span>';	
	}
	return($display_img);
}

function getUsrid_From_Username($username) {
	$selectFields = 'ID';
	$mainTable = 'members';
	$where = ['Username' => $username];

	// Call the PHPCPR select function
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

	// Check if result is not false or empty, then proceed with your logic
	$buffer = isset($result[0]) ? $result[0] : null;
	if ($_SESSION['debug'] == true) echo 'END getUsrid_From_Username: '.$username.'<br>';
	return($buffer['ID']);
}

function getUsername_From_Usrid($usrid) {
	$selectFields = 'Username';
	$mainTable = 'members';
	$where = ['ID' => $usrid];

	// Call the PHPCPR select function
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

	// Check if result is not false or empty, then proceed with your logic
	$buffer = isset($result[0]) ? $result[0] : null;
	if ($_SESSION['debug'] == true) echo 'END getUsrid_From_Username: '.$username.'<br>';
	return($buffer['Username']);
}

function getFullname_From_Usrid($usrid) {
	$selectFields = 'First_Name, Last_Name';
	$mainTable = 'members';
	$where = ['ID' => $usrid];

	// Call the PHPCPR select function
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

	// Check if result is not false or empty, then proceed with your logic
	$buffer = isset($result[0]) ? $result[0] : null;
	if ($_SESSION['debug'] == true) echo 'END getUsrid_From_Username: '.$username.'<br>';
	return($buffer['First_Name'].' '.$buffer['Last_Name']);
}

////////////////////////////////////////////
// return number of direct sponsees
function isCommissionQualified($usrid){
	$selectFields = 'COUNT(usrid) AS CNT';
	$mainTable = 'matrix';
	$where = ['sponsorusrid' => $usrid];

	// Call the PHPCPR select function
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

	// Check if result is not false or empty, then proceed with your logic
	if ($result && isset($result[0]['CNT'])) {
		$num = $result[0]['CNT'];
		return $num;
	}
	return 0;
}

function isActiveOnMatrix($usrid, $matlevel){

		switch ( $matlevel ) {
			case 1:
			case 2:
			case 3:
			case 4:
			case 5:
			case 6:
			case 7:
			case 8:
			case 9:
			case 10:
				break;
			default:
				$matlevel = 1;
		}
		
	$selectFields = '*';
	$mainTable = 'matrix';
	$where = [
	['usrid' => $usrid],
	['active' => 'Y']
	];

	// Call the PHPCPR select function	
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
	if ($result) return 1;
	else return 0;
}

function find_sponsor_level($usrid, $ref_sponsorid, $level = 0) {
	$selectFields = 'placed_under_sponsorusrid';
	$mainTable = 'matrix';
	$where = ['usrid' => $usrid];

	// Call the PHPCPR select function	
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
	$buffer = isset($result[0]) ? $result[0] : null;
	
	$level++;
	if (empty($buffer['placed_under_sponsorusrid'])) return $level;
	if ($buffer['placed_under_sponsorusrid'] != $ref_sponsorid) {
		$look_up = $buffer['placed_under_sponsorusrid'];
		return find_sponsor_level($look_up, $ref_sponsorid, $level);
    } else {
		return $level;
	}	
}


function build_user_info($usrid, $index=1, $user_can_look_up=1, $top_slot=0) {
	
	//$this_guy = $_SESSION['UserID'];
	
	//if (isThisMyDownline($usrid, $this_guy) === 0) return build_user_info($this_guy, 1, 0);
	
    global $debug2, $this_page, $qualified_icon1, $qualified_icon2, $qualified_icon3, $qualified_icon4, $qualified_icon5, $cancelled_icon, $matlevel;

    $qtext = null;
    $uname = null;
    $data = null;
    $sponsor_id = null;
    $sponsor_uname = null;

    $qualification = !empty($usrid) ? isCommissionQualified($usrid) : 0;
	
	// NO NEED TO EDIT THIS SECTION.
    if ($rank_levels > 0 && $qualification >= $rank1_qualifiers) $qtext = $qualified_icon1;
    if ($rank_levels > 1 && $qualification >= $rank2_qualifiers) $qtext = $qualified_icon2;
    if ($rank_levels > 2 && $qualification >= $rank3_qualifiers) $qtext = $qualified_icon3;
    if ($rank_levels > 3 && $qualification >= $rank4_qualifiers) $qtext = $qualified_icon4;
    if ($rank_levels > 4 && $qualification >= $rank5_qualifiers) $qtext = $qualified_icon5;	

    if (!empty($usrid) && isActiveOnMatrix($usrid, $matlevel) != 1) $qtext = $cancelled_icon;

    $uname = !empty($usrid) ? getUsername_From_Usrid($usrid) : null;
    $data = !empty($usrid) ? find_generations($usrid, $index) : null;
    $sponsor_id = !empty($usrid) ? getsponsorusrid($usrid) : null;
    $sponsor_uname = !empty($usrid) ? getUsername_From_Usrid($sponsor_id) : null;
	$full_name = !empty($usrid) ? getFullname_From_Usrid($usrid) : null;
	
	if ($debug2 == true) { 
		$show_sponsor_id = $sponsor_id;
		$show_usrid = $usrid;
	} else {
		$show_sponsor_id = '';
		$show_usrid = '';
	}	
		

    return array(
        'session_string' => $session_string,
        'left_leg_id' => $left_leg_id,
        'right_leg_id' => $right_leg_id,
        'third_leg_id' => $third_leg_id,
        'uname' => $uname,
        'qtext' => $qtext,
        'sponsor' => $sponsor_id,
        'sponsor_uname' => $sponsor_uname,
        'display_sponsor' => $display_sponsor,
        'display_team_count' => $display_team_count,
        'display_image' => $display_image,
        'display_name' => $display_name,
		'full_name' => $full_name
    );
}
/*
$user_info = build_user_info($check_id, 1, $user_can_look_up, 1);
//print_r($user_info);
$mtrx_name[0] = $user_info['session_string'];
$mtrx_tooltip[0] = $top_spot['full_name'];

	
if(!empty($user_info['left_leg_id'])) {
	$user_info2 = build_user_info($user_info['left_leg_id']);
	$mtrx_name[1] = $user_info2['session_string'];
	$mtrx_tooltip[1] = $user_info2['full_name'];		
} else {
	$mtrx_name[1] = getImage(0);
}*/


$selectFields = 'memb2.ID, memb2.Username, memb2.First_Name, memb2.Last_Name, COUNT(memb.sponsorid) as tot';
$mainTable = ['table' => 'members', 'as' => 'memb'];
// JOIN TABLE BACK TO THE REF SPONSOR, TO GET THEIR INFO!
$joinConditions = [
    [
        'table' => 'members',
        'as' => 'memb2',
        'condition' => 'memb.sponsorid = memb2.Username'
    ]
];
// TO COUNT REF'S FOR RANK, THEY MUST BE PAID, AND THE SPONSOR MUST ALSO BE PAID!
$where = [
	'memb.sponsorid' => ['!=', 'admin'],
	'memb.Status' => ['=', 'paid'],
	'memb2.Status' => ['=', 'paid']	
];
$groupBy = 'memb.sponsorid';
$orderBy = 'tot DESC';
$limit = 0;
$show_debug = 1;
$topdownlines = select($selectFields, $mainTable, $joinConditions, $where, $groupBy, null, $orderBy, $limit, $show_debug);

echo '<div class="col-xs-12 col-sm-12" ><span><div style="text-align:left; line-height:170%; padding: 20px; background-color:#f5f5f5"><h4><div style="margin-left: 23px; text-decoration:bold; color:#3784b1;">Ranking Leaders</div></h4><ol>';

foreach ($topdownlines as $downliners) {
	
	if (in_array($downliners['ID'], $exclude_ids)) {
		//continue; // NOT EXCLUDING ON THIS ONE!
	}
	
	if ($downliners['tot'] < $rank1_qualifiers) { // THEY HAVE NOT RANKED! WE SKIP THEM, AND STOP THE LOOP (SINCE IT GOES IN DESC ORDER)!
		break;
	}	
						
	echo "<li>{$downliners['First_Name']} {$downliners['Last_Name']}&nbsp;";
	
	if ($_SESSION['admin_session_view'] == true) echo '<a href="../admin/Sub/Finduser.php?username='.$downliners['Username'].'&prog='.$program_id.'" target="_blank">'.$downliners['Username'] .'</a>&nbsp;'. number_format($downliners['tot'],0);
	
	if ($downliners['tot'] >= $rank2_qualifiers) echo $qualified_icon2.' '.$rank2_name;
	else echo $qualified_icon1.' '.$rank1_name;
	
	echo "</li>";	
}

echo '</ol></div></span></div>';


if (false) { ?>
<div style="text-align:center">
<form class="form-horizontal" action="<?php echo $this_page; ?>" method="post">
<fieldset>
<!-- Text input-->
<div class="form-group">
  <label class="col-md-4 control-label" for="uname">Search For <!--Username in the Matrix--></label>  
  <div class="col-md-4">
  <input id="textinput" name="uname" type="text" placeholder="Username" class="form-control input-md">  
  </div>
  <div class="col-md-4">
    <button id="singlebutton" name="submit" class="btn btn-primary">Search</button>
  </div>
  <br><br>
  	<a href="<?php echo $this_page; ?>" class="btn-xs btn-warning">Back To Top</a>
</div>
</fieldset>
</form>
</div>				
<?php } ?>			
				
<?php if ($rank_levels > 0) { 
	echo 'A '.$qualified_icon1; ?> denotes the user rank is <?php echo $rank1_name; ?>, having made <?php echo $rank1_qualifiers; ?> or more personal sales.<br>
<?php } ?>		
<?php if ($rank_levels > 1) {
	echo 'A '.$qualified_icon2; ?> denotes the user rank is <?php echo $rank2_name; ?>, having made <?php echo $rank2_qualifiers; ?> or more personal sales.<br>
<?php } ?>	
<?php if ($rank_levels > 2) { ?>
	echo 'A '.$qualified_icon3; ?> denotes the user rank is <?php echo $rank3_name; ?>, having made <?php echo $rank3_qualifiers; ?> or more personal sales.<br>
<?php } ?>	
<?php if ($rank_levels > 3) { ?>
	echo 'A '.$qualified_icon4; ?> denotes the user rank is <?php echo $rank4_name; ?>, having made <?php echo $rank4_qualifiers; ?> or more personal sales.<br>
<?php } ?>	
<?php if ($rank_levels > 4) { ?>
	echo 'A '.$qualified_icon5; ?> denotes the user rank is <?php echo $rank5_name; ?>, having made <?php echo $rank5_qualifiers; ?> or more personal sales.<br>
<?php } ?>	

<?php 
include './footer.php';
?>