<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
// THIS FILE SCRUBS INPUT - YOU MUST USE THIS FILE AT THE TOP OF ALL MEMBERS PAGES FOR SECURITY!
if (session_status() == PHP_SESSION_NONE) {
	session_start();
}

if (isset($_SESSION['admin_login']) && $_SESSION['admin_login'] == true) {
	ini_set('display_errors', 1);
	ini_set('display_startup_errors', 1);
	error_reporting(E_ALL);
}

include_once ''.$_SERVER['DOCUMENT_ROOT'].'/Sub/Config.inc.php';
include_once ''.$_SERVER['DOCUMENT_ROOT'].'/phpcpr.php';

$logincheck_has_run = true;

// PREVENT XSS (Cross-Site Scripting) 
// AUTOMATICALLY Sanitize ALL OF $_GET and $_POST! & REMOVE ALL WHITE SPACES AROUND ANY INPUTS!
// password will be left alone!
// aws_message will be left alone!

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    foreach ($_POST as $key => $value) {
        // Check if the current key is 'aws_message' to bypass it
        if ($key !== 'aws_subject' && $key !== 'aws_message') {
            $_POST[$key] = sanitize($value, $key);
        }
    }
    // Apply conditionalTrim to all elements except 'aws_message'
    foreach ($_POST as $key => $value) {
        if ($key !== 'aws_subject' && $key !== 'aws_message') {
            $_POST[$key] = conditionalTrim($value);
        }
    }
}


if (!empty($_GET)) {
    foreach ($_GET as $key => $value) {
        $_GET[$key] = sanitize($value, $key);
    }
    $_GET = array_map('conditionalTrim', $_GET);
}

/*
echo $_SERVER['QUERY_STRING'];
echo '<p></p>';
echo 'Members/'.$_SERVER['QUERY_STRING'];
echo '<p>php self</p>';
echo $_SERVER['PHP_SELF'];
echo '<p>session rd</p>';
echo $_SERVER['PHP_SELF'].'?'.$_SERVER['QUERY_STRING'];
exit;
*/

$_SESSION['rd'] = $_SERVER['PHP_SELF'].'?'.$_SERVER['QUERY_STRING'];

if (isset($_GET['id']) && $_GET['id'] != '') { 
	$link = '?id='.htmlspecialchars($_GET['id'], ENT_QUOTES, 'UTF-8');
} else {
	$link = '';
}

//echo "GOT HERE";
if (!isset($_SESSION['loggedin']) || empty($_SESSION['loggedin'])) {

	if (isset($_GET['cart']) && $_GET['cart'] != '') { // SEND STORE TRAFFIC TO STORE JUMP PAGE!
		//header ("Location: /store-jump.php$link");
		header ("Location: /login.php$link"); // BYBASS STORE JUMP PAGE!	
		exit;
	} else {
		header ("Location: /login.php$link");
		exit;
	}
} else { // SESSION NOT EMPTY - WE ARE DONE WITH RD SESSION REDIRECT - TERMINATE IT!
	if (isset($_SESSION['rd'])) unset($_SESSION['rd']);
}
?>