<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './logincheck.php'; 
//include './access_check.php'; //comment out config file if using access check!!

// COMMENT WHEN TESTING IS DONE!!!
//$_SESSION['dev'] = '';
/*
if ($_GET['dev'] == '' && $_SESSION['dev'] == '' && $_SESSION['loggedin'] != 'testwalkthru' && $_SESSION['QQQadmin_login'] != true) { // LOCKING PAGE FOR DEVELOPER USE ONLY!!
include_once './header.php';
echo 'We\'re sorry. This area is temporarily down for maintenance. Please check back soon!';
include_once './footer.php';
exit;
} else {
$_SESSION['dev'] = true;
}
*/
$pageName = 'Profile';
$pageDesc = 'Your Profile Settings';
$pageIcon = 'icon-user';
$pageAlign = 'center';
$pageClass = '';

$thispage = 'profile.php'; // QQQ RENAME BACK TO PROFILE ONCE GOING LIVE!!
$thispagename = "login.php";
$error_msg = ''; // INI VAR
$dbitems_to_change = 0;	// INI VAR
include 'header.php';


//$GLOBALS['use_stripe'] = true; // MOVE TO CONFIG FILE! DONE!!

// ALLOW MEMBER TO CHOOSE HOW TO ACCEPT PAYMENT (true or false)
$member_chooses_payment_method = $GLOBALS['member_chooses_payment_method'];
$collected_by_default = $GLOBALS['collected_by_default'];
$use_debit_card = $GLOBALS['use_debit_card'];
$use_twilio = $GLOBALS['use_twilio'];
$use_sendgrid = $GLOBALS['use_sendgrid']; // SET THIS TO FALSE TO SEND CONFIRMATION EMAIL NORMALLY, TRUE TO USE SENDGRID

//$GLOBALS['use_bitcoin'] = false; // QQQ KLUDGE TO SHOW BITCOIN HERE FOR PAYOUT PURPOSES ONLY ON ADMIN COLLECTS SYSTEMS

//$GLOBALS['show_withdrawal_options'] = false; // QQQ NOT WORKING FROM CONFIG FILE FOR SOME STRANGE REASON

// NEITHER CAN BE EMPTY!
$about_width = 300; //about me image max width (px)
$about_height = 300; //about me image max height (px)

// QQQ KLUDGE TO ONLY ALLOW ADMIN COLLECTS FOR U.S. AND CANADIAN USERS
if ($GLOBALS['admin_collects'] == true && (isset($_POST['Country']) && ($_POST['Country'] == 'US' || $_POST['Country'] == 'CA') ||
isset($_SESSION['Country']) && $_SESSION['Country'] == 'US')) {
//	$allow_admin_collects = true;
//	$member_chooses_payment_method = true;
}

// WE ALLOW ALL USERS TO COLLECT VIA ADMIN, AS ADMIN CAN ALWAYS PAY OUT IN BITCOIN
$allow_admin_collects = $GLOBALS['admin_collects'];

if (!isset($_POST['payment_collected_by'])) $_POST['payment_collected_by'] = '';

if ($_POST['payment_collected_by'] == '' && $_SESSION['UserID'] != 1 && $allow_admin_collects == true) {
	$_POST['payment_collected_by'] = $collected_by_default;
} else if ($_SESSION['UserID'] == 1) {
	$_POST['payment_collected_by'] = 'admin';
} else if ($_POST['payment_collected_by'] == '' && $allow_admin_collects == false && ($GLOBALS['collected_by_default'] == 'member' && $GLOBALS['member_payment'] == true)) {
	$_POST['payment_collected_by'] = 'member'; // QQQ FORCING MEMBER COLLECTS FOR INT'L USERS
} else if ($_POST['payment_collected_by'] == '') {
	$_POST['payment_collected_by'] = $collected_by_default;
}

if ($_SESSION['admin_login'] == true) {
	$collapse = '';
} else {
	$collapse = 'collapse';
}

/* // FOR ANY SET UPS PRIOR TO 2024, WHERE WE ALREADY HAVE USERS ENCRYPTED A CERTAIN WAY
function encrypt($input){
	global $GLOBALS;
	$key = $GLOBALS['member_taxid_algorythm_key'];

	$input = str_replace("\n","",$input);
	$input = str_replace("\t","",$input);
	$input = str_replace("\r","",$input);
	$td = mcrypt_module_open ($GLOBALS['member_taxid_algorythm'], '', 'ecb', '');
	$key = substr(md5($key),0,mcrypt_enc_get_key_size($td));
	$iv = mcrypt_create_iv (mcrypt_enc_get_iv_size ($td), MCRYPT_RAND);
	mcrypt_generic_init ($td, $key, $iv);
	$encrypted_data = mcrypt_generic ($td, $input);
	mcrypt_generic_deinit ($td);
	mcrypt_module_close ($td);
	return base64_encode($encrypted_data);
}

function decrypt($input){
	global $GLOBALS;
	$key = $GLOBALS['member_taxid_algorythm_key'];

	$input = str_replace("\n","",$input);
	$input = str_replace("\t","",$input);
	$input = str_replace("\r","",$input);
	$input = base64_decode($input);
	$td = mcrypt_module_open ($GLOBALS['member_taxid_algorythm'], '', 'ecb', '');
	$key = substr(md5($key),0,mcrypt_enc_get_key_size($td));
	$iv = mcrypt_create_iv (mcrypt_enc_get_iv_size ($td), MCRYPT_RAND);
	mcrypt_generic_init ($td, $key, $iv);
	$decrypted_data = mdecrypt_generic ($td, $input);
	mcrypt_generic_deinit ($td);
	mcrypt_module_close ($td);
	return $decrypted_data;
}*/

function QQencrypt($input){
    global $GLOBALS;
    $key = $GLOBALS['member_taxid_algorythm_key'];
    $method = 'AES-256-CBC'; // More secure method

    // Generating an IV for CBC mode
    $ivLength = openssl_cipher_iv_length($method);
    $iv = openssl_random_pseudo_bytes($ivLength);

    $key = substr(md5($key), 0, 32); // Key size adjusted for AES-256
    $encrypted = openssl_encrypt($input, $method, $key, OPENSSL_RAW_DATA, $iv);

    // Return IV along with the encrypted data
    return base64_encode($iv . $encrypted);
}

function QQdecrypt($input) {
    global $GLOBALS;
    $key = $GLOBALS['member_taxid_algorythm_key'];
    $method = 'AES-256-CBC'; // More secure method

    $data = base64_decode($input);
    $ivLength = openssl_cipher_iv_length($method);
    
    // Ensure IV is exactly 16 bytes long
    $iv = substr($data, 0, $ivLength);
    /* // DEPRECATED
	if (strlen($iv) != $ivLength) {
        $iv = str_pad($iv, $ivLength, "\0", STR_PAD_RIGHT);
    }*/

    $encryptedData = substr($data, $ivLength);

    $key = substr(md5($key), 0, 32); // Key size adjusted for AES-256
    return openssl_decrypt($encryptedData, $method, $key, OPENSSL_RAW_DATA, $iv);
}


function encrypt($input) {
    // Check if the input is null or an empty string
    if ($input === null || $input === '') {
        return $input;
    }
	
    global $GLOBALS;
    $key = $GLOBALS['member_taxid_algorythm_key'];	
    $method = 'AES-256-CBC';
    $ivLength = openssl_cipher_iv_length($method);
    $iv = openssl_random_pseudo_bytes($ivLength);
    $encrypted = openssl_encrypt($input, $method, $key, OPENSSL_RAW_DATA, $iv);
    return base64_encode($iv . $encrypted);
}

function decrypt($input) {
    // Check if the input is null or an empty string
    if ($input === null || $input === '') {
        return $input;
    }

    global $GLOBALS;
    $key = $GLOBALS['member_taxid_algorythm_key'];    
    $method = 'AES-256-CBC';
    $data = base64_decode($input);
    $ivLength = openssl_cipher_iv_length($method);
    $iv = substr($data, 0, $ivLength);
    $encryptedData = substr($data, $ivLength);
    return openssl_decrypt($encryptedData, $method, $key, OPENSSL_RAW_DATA, $iv);
}


function password_strength($password) {
    $strength = 0;
    $length = strlen($password);
    $error_msg = "";

    // Check password length
    if ($length < 8) {
        $error_msg .= "Password must be at least 8 characters long.<br> ";
    } else {
        $strength += 1;
    }

    // Check if password contains both upper and lower case characters
	if (!preg_match("/^(?=.*[a-z])(?=.*[A-Z])\S+$/", $password)) {
	//if (!preg_match("/^(?=.*[a-z])(?=.*[A-Z]).+$/", $password)) { // OLD WAY - ALLOWED SPACES
        $error_msg .= "Password must contain both uppercase and lowercase characters.<br> ";
    } else {
        $strength += 1;
    }

    // Check if password contains numbers
    if (!preg_match("/^(?=.*\d).+$/", $password)) {
        $error_msg .= "Password must contain numbers.<br> ";
    } else {
        $strength += 1;
    }

    // Check if password contains symbols
    if (!preg_match("/^(?=.*[^a-zA-Z\d]).+$/", $password)) {
        $error_msg .= "Password must contain symbols.<br> ";
    } else {
        $strength += 1;
    }

    // Return password strength score and error message if any
    return array("strength" => $strength, "error_msg" => $error_msg);
}

if ($use_sendgrid == true) include '../sendgrid.inc.php'; // load sendgrid functions if using them

if ($use_twilio == true) {
	include '../sms.inc.php'; // load Twilio SMS functions
}

$ID = $_SESSION['UserID'];
$username = $_SESSION['loggedin'];

//Moved the code that adds the user to the database here
if ((isset($_GET['software']) && $_GET['software'] == "AWS")) {
	
	if (isset($_POST['password'])) $resultpw = password_strength($_POST['password']);
	
	// QQQ TO FORCE HACKER OUT OF SESSION
	if ($_SESSION['loggedin'] == 'dcmarketer582' && $_SESSION['admin_session_view'] != true) {
		//unset($_SESSION['loggedin']);
		//header("Location: /login.php");
		//exit;
	}

	//UPDATE ADD SUPPORT FOR SMS TEXT
	if ($use_twilio == true) {
		if (empty($_POST['sms_check'])) $_POST['sms_check'] = "no";
		if (preg_replace("/[^0-9+]/", "", $_POST['phone']) != "" && $_POST['country'] != "") {
			$standardized_phone_number = twilio_standardize_phone_number($country_code,preg_replace("/[^0-9+]/", "", $_POST['phone'])); // put phone number in internationally correct format
			if($standardized_phone_number != "") {
				if (twilio_can_rcv_sms($standardized_phone_number)) $_POST['cellphone'] = $standardized_phone_number; // set if possible to get sms on this phone
			} else {
				$_POST['cellphone'] = "";
			}
		}
	}

	if (isset($_POST['paypalaccount']) && $_POST['paypalaccount'] != '') {

			$paypalAccount = $_POST['paypalaccount'];

			// Using the PHPCPR select function
			$resultpp = select('ID', 'members', [], ['paypalaccount' => ['=', $paypalAccount]], null, null, null, 0, 1);

			if (is_array($resultpp) && !empty($resultpp)) {
				// Fetching the first row from the result
				$bufferpp = $resultpp[0];

				// Check if bufferpp is an array and contains 'ID'
				if (is_array($bufferpp) && isset($bufferpp['ID']) && $bufferpp['ID'] != '' && $bufferpp['ID'] != $_SESSION['UserID']) {
					$error_msg = 'That PayPal email is already being used by another account.';
				}
			}
	}


	if (isset($_POST['state']) && $_POST['state'] != '1') {
		$state_exists = false;

		$state = $_POST['state'];

		// Using the PHPCPR select function to count entries
		$result = select('COUNT(*) as stateCount', 'states', [], ['abbrev' => ['=', $state]], null, null, null, 0, 1);

		// Checking if the state exists
		if (!empty($result) && $result[0]['stateCount'] != 0) {
			$state_exists = true;
		}
	} elseif (isset($_POST['state']) && $_POST['state'] == '1' && strtoupper($_POST['country']) != 'US') {
		$state_exists = true;
	} else {
		$state_exists = false;
	}

	if (isset($_POST['country'])) {
		$country_exists = false;

		$country = $_POST['country'];
		$country = strtoupper($country);

		// Using the PHPCPR select function to count entries
		$result = select('COUNT(*) as countryCount', 'country', [], ['iso' => ['=', $country]], null, null, null, 0, 1);

		// Checking if the country exists
		if (!empty($result) && $result[0]['countryCount'] != 0) {
			$country_exists = true;
		}
			
	} else {
		$country_exists = false;
	}

	//UPDATE TO ADD SHIPPING ADDRESS INFO
	if ($GLOBALS['use_shipping'] === true) {
    

		if (isset($_POST['ship_state']) && $_POST['ship_state'] != '1') {
			$ship_state_exists = false;

			$ship_state_exists = false;

			$shipState = $_POST['ship_state'];
			$shipState = strtoupper($shipState);

			// Using the PHPCPR select function to count entries
			$result = select('COUNT(*) as stateCount', 'states', [], ['abbrev' => ['=', $shipState]], null, null, null, 0, 1);

			// Checking if the shipping state exists
			if (!empty($result) && $result[0]['stateCount'] != 0) {
				$ship_state_exists = true;
			}
		} elseif (isset($_POST['ship_state']) && $_POST['ship_state'] == '1' && strtoupper($_POST['ship_country']) != 'US') {
			$ship_state_exists = true;
		} else {
			$ship_state_exists = false;
		}

		if (isset($_POST['ship_country'])) {
			$ship_country_exists = false;

			$country = $_POST['ship_country'];
			$country = strtoupper($country);

			// Using the PHPCPR select function to count entries
			$result = select('COUNT(*) as countryCount', 'country', [], ['iso' => ['=', $country]], null, null, null, 0, 1);

			// Checking if the country exists
			if (!empty($result) && $result[0]['countryCount'] != 0) {
				$ship_country_exists = true;
			}		
		} else {
			$ship_country_exists = false;
		}
  } //END UPDATE SHIPPING ADDRESS INFO

if (empty($_POST['Email'])) {
	$error_msg = 'Please fill out the email field.';
	}
elseif (empty($_POST['FirstName'])) {
	$error_msg = 'Please fill out the first name field.';
	}
elseif (empty($_POST['LastName'])) {
	$error_msg = 'Please fill out the last name field.';
	}
elseif (empty($_POST['cellphone']) && isset($_POST['sms_check']) && $_POST['sms_check'] == "yes") {
	$_POST['sms_check'] = "no"; // if not able to receive texts, set this to no
	//$error_msg = 'We cannot send texts to this phone number: '.$standardized_phone_number.'<br />Please use a different phone or uncheck the "Send me important text alerts" box';
}
elseif (empty($_POST['password'])) {
	//$error_msg = 'Please choose a password.';
	// don't need - they already have it. now this was always forcing a new once! we don't want that!
}
elseif (!empty($_POST['password']) && $resultpw["strength"] === 4) {
	//echo "Password is strong!";
} 
elseif (!empty($_POST['password'])) {
	$error_msg = "Password is weak. Please correct the following issues:<br>" . $resultpw["error_msg"];
}


//UPDATE
	/*elseif (empty($_POST['address'])) {
		$error_msg = 'Please fill out the address field.';
		}
	elseif (empty($_POST['city'])) {
		$error_msg = 'Please fill out the city field.';
		}
	elseif (empty($_POST['zip'])) {
		$error_msg = 'Please fill out the zip code field.';
		}
	elseif (empty($_POST['phone'])) {
		$error_msg = 'Please fill out the phone field.';
		}
	elseif (empty($_POST['password'])) {
		$error_msg = 'Please fill out the password field.';
		}
	elseif ($state_exists === false) {
		$error_msg = 'Please select a state.';
		}
	elseif ($country_exists === false) {
		$error_msg = 'Please select a country.';
		}*/
	//END UPDATE

if (empty($error_msg) && !filter_var(trim($_POST['Email']), FILTER_VALIDATE_EMAIL)) {
    $error_msg = 'Please use a valid email address.';
}
	

	if (isset($_POST['tax_id'])) {
		$ssn = preg_replace( "/[^0-9]/", "",$_POST['tax_id']); // strip all dashes and other non-numeric characters

		if ($GLOBALS['member_taxid'] === true && strlen($ssn) != 9 && $_POST['country'] == 'US' && $_SESSION['admin_session_view'] != true && $_SESSION['a'.$_SESSION['UserID']]['affiliate_status'] == true && $_POST['payment_collected_by'] == 'admin' && $ID != 1) {
			//$error_msg = 'Please use a valid Social Security / Tax ID number.';
			//if ($member_chooses_payment_method == true) $error_msg .= '<br/>Or change your Payment Collection Method to collect your own payments directly.';
		} else {
	    		$_POST['tax_id'] = $ssn;
		}
	}	

//----------------------------------------------------------------------
//IMAGE FUNCTION Made by: Sven Arild Helleland, January 2004													
//Firm: Kaizen Web-Productions (http://www.kaizen-web.com)							
//Copyright(C), Kaizen Web-Productions, 2004 All Rights Reserved.	
//----------------------------------------------------------------------

function create_image($image, $extension, $width, $height, $name) {

	$size = getimagesize($image);
	
   // Check if getimagesize failed
    if ($size === false) {
        // Optionally, log the error or notify someone
        error_log("Failed to get image size for: " . $image);
        return false; // Terminate the function
    }	

	$image_width = $size[0];
	$image_height = $size[1];

	$x_ratio = $width / $image_width;
	$y_ratio = $height / $image_height;

	if ($image_width <= $width && $image_height <= $height) {
		$tn_width = $image_width;
		$tn_height = $image_height;
		}
	elseif (($x_ratio * $image_height) < $height) {
		$tn_height = ceil($x_ratio * $image_height);
		$tn_width = $width;
		}
	else {
		$tn_width = ceil($y_ratio * $image_width);
		$tn_height = $height;
		}

	if ($extension == '.jpg' || $extension == '.jpeg') $source = imagecreatefromjpeg($image);
	elseif ($extension == '.png') $source = imagecreatefrompng($image);
	elseif ($extension == '.gif') $source = imagecreatefromgif($image);

	$destination = imagecreatetruecolor($tn_width, $tn_height);

	imagecopyresampled($destination,$source, 0, 0, 0, 0, $tn_width, $tn_height, $image_width, $image_height);

	imagejpeg($destination, $name.'.jpg', 100);

	imagedestroy($source);
	imagedestroy($destination);
}
	
//End Kaizen Web-Productions Image Copyright	
	
if (!empty($_FILES['image']['tmp_name']) && is_uploaded_file($_FILES['image']['tmp_name'])) {


if (!function_exists('imagecreatetruecolor')) {
echo 'GD module must be installed in PHP on the server. If this gets added in later, ask your host to rebuild apache with GD included in PHP. This feature is required to upload pictures.';
}

	
	$extension = '.'.str_replace('.', '', strstr($_FILES['image']['name'], '.'));
	
	if (filesize($_FILES['image']['tmp_name']) < 500000) {
	
		if ($extension == '.jpg' || $extension == '.jpeg' || $extension == '.png' || $extension == '.gif') {
			
			$image_path = $GLOBALS['path'].'images/Users/'.floor(($_SESSION['UserID'] / 1000));
			
			if (!file_exists($image_path)) mkdir($image_path, 0755);
			
			$image_path .= '/'.$_SESSION['UserID'];			
			
			create_image($_FILES['image']['tmp_name'], $extension, $about_width, $about_height, $image_path);

chmod($image_path.'.jpg', 0644);
			}
		else {
			$error_msg = 'The image can only be in these formats: .jpg, .gif, .png';
			}
		}
	else {
		$error_msg = 'The image file is too large. Max filesize is 500KB';
		}
	}	



//if (empty($_POST['programs_offered_chk']) && in_array($_SESSION['p4_status'],array('Active','Suspended','Comped'))) { // QQQ NWC program 4
//	$error_msg = 'You Must Check At Least One Program To Offer';
//}

	// Fetching member details
	$loggedInUser = $_SESSION['loggedin']; // Retrieve the logged-in username from session
	$loggedInUser = sanitize($loggedInUser, 'Username'); // Sanitize the username

	// Using the PHPCPR select function
	$resultMem = select('*', 'members', [], ['Username' => ['=', $loggedInUser]], null, null, null, 0, 1);

	// Fetching the first row from the result
	$buffer_mem = isset($resultMem[0]) ? $resultMem[0] : null;
	
	//print_r($buffer_mem); exit;

	// Fetching member_link details
	$user_id = $_SESSION['UserID'];
	//$user_id = sanitize($user_id, 'ID');

	// Using the PHPCPR select function
	$resultMemLink = select('*', 'member_link', [], ['ID' => ['=', $user_id]], null, null, null, 0, 1);

	// Fetching the first row from the result
	$buffer_memlink = isset($resultMemLink[0]) ? $resultMemLink[0] : '';


if (empty($error_msg)) {
	if (!empty($_POST['programs_offered_chk'])) $_POST['programs_offered'] = implode(",",$_POST['programs_offered_chk']);

	$custom_settings = 0;
	
	if (isset($_POST['accept_cash']) && $_POST['accept_cash'] == '1') $custom_settings += 2;
	
	if (isset($_POST['accept_check']) && $_POST['accept_check'] == '1') $custom_settings += 4;
	
	if (isset($_POST['fedex']) && $_POST['fedex'] == '1') $custom_settings += 8;
	elseif (isset($_POST['fedex']) && $_POST['fedex'] == '2') $custom_settings += 16;
	
	if (isset($_POST['ups']) && $_POST['ups'] == '1') $custom_settings += 32;
	elseif (isset($_POST['ups']) && $_POST['ups'] == '2') $custom_settings += 64;
	
	if (isset($_POST['money_gram']) && $_POST['money_gram'] == '1') $custom_settings += 128;
	if (isset($_POST['western_union']) && $_POST['western_union'] == '1') $custom_settings += 256;
	if ($custom_settings > 0) $_POST['paymentprocessor9'] = $custom_settings;

	
if (isset($_POST['password']) && !empty($_POST['password'])) {
    $hashedPassword = password_hash($_POST['password'], PASSWORD_DEFAULT);
    // Now you can use $hashedPassword for storing in the database or other operations
	$_POST['password'] = $hashedPassword;
} else if (empty($_POST['password'])) { // WE DON'T HASH IT AGAIN, OR IT GETS CHANGED, AND USER WILL NOT BE ABLE TO LOGIN!!
	$_POST['password'] = $buffer_mem['Password'];
}

// QQQ BEGIN NEW PROFILE UPDATE TO LOG ALL CHANGES AND CONFIRM VIA EMAIL
$timestamp = date("Y-m-d H:i:s");
$ip = $_SERVER['REMOTE_ADDR'];
$number=rand(1,100000);
$confcode = base64_encode(uniqid($_SESSION['loggedin'].$number));
$confcode_url_enc = urlencode($confcode);

//echo '<br/>number: '.$number;
//echo '<br/>confcode: '.$confcode;
foreach ($_POST as $key => $value) {
		if ($_SESSION['debug']) echo "<br />".$key." => ".$value;
		
		switch ($key) {
			case "ID":
			case "submit":
			case "Status":
			case "Username":
			case "accept_cash":
			case "accept_check":
			case "fedex":
			case "ups":
			case "money_gram":
			case "western_union":
			case "programs_offered_chk":
				$fieldname = "";
				$tablename = "";
				$newvalue = "";
				$oldvalue = "";
				break; // ignore this field - DO NOT CHANGE
			case "sms_check":
				$fieldname = "sms_alert";
				$tablename = "members";
				$newvalue = ($value == "yes") ?"Sales":"";
				$oldvalue = $buffer_mem[$fieldname];
//echo "********* OLD: $oldvalue  NEW: $newvalue<br />";
				break;
			case "programs_offered":
				$fieldname = "programs_offered";
				$tablename = "members";
				$newvalue = $value;
				$oldvalue = $buffer_mem[$fieldname];
				break;
			case "password":	
				$fieldname = "Password";
				$tablename = "members";
				$newvalue = $value;
				$oldvalue = $buffer_mem[$fieldname];
				break; // password
			case "business_name":
				$fieldname = "business_name";
				$tablename = "members";
				$newvalue = $value;
				$oldvalue = $buffer_mem[$fieldname];
				break;
			case "website":
				$fieldname = "website";
				$tablename = "members";
				$newvalue = $value;
				$oldvalue = $buffer_mem[$fieldname];
				break;		
			case "display_name":
				$fieldname = "display_name";
				$tablename = "members";
				$newvalue = $value;
				$oldvalue = $buffer_mem[$fieldname];
				break;													
			case "FirstName":
				$fieldname = "First_Name";
				$tablename = "members";
				$newvalue = $value;
				$oldvalue = $buffer_mem[$fieldname];
				break;
			case "LastName":
				$fieldname = "Last_Name";
				$tablename = "members";
				$newvalue = $value;
				$oldvalue = $buffer_mem[$fieldname];
				break;
			case "Email":
				$fieldname = "email";
				$tablename = "members";
				$newvalue = $value;
				$oldvalue = $buffer_mem[$fieldname];
				break;
			case "google_checkout":
				$fieldname = "gc_id";
				$tablename = "members";
				$newvalue = $value;
				$oldvalue = $buffer_mem[$fieldname];
				break;
			case "google_checkout_key":
				$fieldname = "gc_key";
				$tablename = "members";
				$newvalue = encrypt($value);
				$oldvalue = $buffer_mem[$fieldname];
				break;
			case "alertpay_pass":
				$fieldname = "alertpay_passphrase";
				$tablename = "members";
				$newvalue = encrypt($value);
				$oldvalue = $buffer_mem[$fieldname];
				break;
			case "paymentprocessor4":
				$fieldname = "paymentprocessor4";
				$tablename = "members";
				$newvalue = encrypt($value);
				$oldvalue = $buffer_mem[$fieldname];
				break;
			case "stp_sec_passwd":
				$fieldname = "stp_sec_passwd";
				$tablename = "members";
				$newvalue = encrypt($value);
				$oldvalue = $buffer_mem[$fieldname];
				break;
			case "subpay":
				$fieldname = "sub_use";
				$tablename = "members";
				$newvalue = (!empty($value)) ? $value:'N';
				$oldvalue = $buffer_mem[$fieldname];
				break;
			case "paymentprocessor5":
				$fieldname = "paymentprocessor5";
				$tablename = "members";
				$newvalue = (!empty($value)) ? $value:'';
				$oldvalue = $buffer_mem[$fieldname];
				break;
			case "paymentprocessor6":
				$fieldname = "paymentprocessor6";
				$tablename = "members";
				$newvalue = ($file_uploaded === true) ? 'Yes':'';
				$oldvalue = $buffer_mem[$fieldname];
				break;
			case "paymentprocessor9":
				$fieldname = "paymentprocessor9";
				$tablename = "members";
				$newvalue = $custom_settings;
				$oldvalue = $buffer_mem[$fieldname];
				break;
			case "bank_account":
				$fieldname = "bank_account";
				$tablename = "members";
				$newvalue = encrypt($value);
				$oldvalue = $buffer_mem[$fieldname];
				break;
			case "bank_routing":
				$fieldname = "bank_routing";
				$tablename = "members";
				$newvalue = encrypt($value);
				$oldvalue = $buffer_mem[$fieldname];
				break;				
			case "tax_id":
				$fieldname = "tax_id";
				$tablename = "member_link";
				$newvalue = (($GLOBALS['member_taxid'] == true) && $value != "") ? encrypt($value):'';
				$oldvalue = $buffer_memlink[$fieldname];
				break;
			default:
				if (in_array($key,array('address','address2', 'city', 'state', 'zip', 'country', 'phone'))) { // if field in member_link table
					$fieldname = $key;
					$tablename = "member_link";
					$newvalue = $value;
					$oldvalue = $buffer_memlink[$key];
				} else if ($GLOBALS['use_shipping'] == true && in_array($key,array('ship_address','ship_address2', 'ship_city', 'ship_state', 'ship_zip', 'ship_country'))) { // if field in member_link table AND shipping address
					$fieldname = $key;
					$tablename = "member_link";
					$newvalue = $value;
					$oldvalue = $buffer_memlink[$key];
				} else { // assume all other fields are in members table, exactly as listed in $_POST(case sensitive)
					$fieldname = $key;
					$tablename = "members";
					$newvalue = $value;
					$oldvalue = $buffer_mem[$key];
				}
				
		}
		if ($fieldname != "" && $tablename != "" && $newvalue != $oldvalue) {
			$dbitems_to_change++;
		// Data array for insertion
		$data = [
			'ID' => $ID,
			'Username' => $username,
			'tablename' => $tablename,
			'fieldname' => $fieldname,
			'newvalue' => $newvalue,
			'oldvalue' => $oldvalue,
			'timestamp_initiated' => $timestamp,
			'ip_initiated' => $ip,
			'confcode' => $confcode
		];

		// Using the PHPCPR insert function
		$result_upd_mclog = insert('members_change_log', $data, 1, 1);
			//echo "<br/>".$qry."<br/>";
		}
	}
}

// CONFIRMATION BYPASS
$bypass_confirmation = false;
// LET THESE USERS BYPASS THE EMAIL CONFIRMATION PROCESS
if ($buffer_mem['sponsorid'] == 'QQQ' || $buffer_mem['sponsorid'] == 'QQQ' || $buffer_mem['Username'] == 'demo' || $buffer_mem['Username'] == 'testjim') $bypass_confirmation = true;

$bypass_confirmation = true; // BYPASS ALL CONFIRMATIONS

if ($_SESSION['admin_login'] == true) $bypass_confirmation = true;

if ($_SESSION['loggedin'] == 'QQQ') { // ADD USERNAME HERE
	$bypass_confirmation = false;
}

if (($_SESSION['admin_session_view'] || $bypass_confirmation == true) && $dbitems_to_change > 0) {

// Using the PHPCPR select function to retrieve records
$prof_admin_result = select('*', 'members_change_log', [], ['confcode' => ['=', $confcode]], null, null, null, 0, 1);

// Counting the number of records
$prof_admin_records = is_array($prof_admin_result) ? count($prof_admin_result) : 0;

	if ($prof_admin_records < 1) {
		echo "Invalid Parameter - No Changes Made";
		include 'footer.php';
		exit;
	} else {		
		foreach ($prof_admin_result as $prof_admin_buffer) {	
			//print_r($prof_admin_buffer);
			$idx = $prof_admin_buffer['idx'];
			$newvalue = $prof_admin_buffer['newvalue'];
			if (in_array(strtolower($prof_admin_buffer['tablename']),array("members","member_link"))) {
				$table = $prof_admin_buffer['tablename'];
			} else {
				echo "Invalid table information - No Changes Made";
				include 'footer.php';
				exit;	
			}
			if ($prof_admin_buffer['fieldname'] != "" && $idx > 0) {
				$fieldname = $prof_admin_buffer['fieldname'];
			} else {
				echo "Invalid fieldname information - No Changes Made";
				include 'footer.php';
				exit;	
			}
			$PROF_ID = $prof_admin_buffer['ID'];
			
			// Update query for the specified table
			$prof_admin_updqry = [
				$fieldname => $newvalue
			];

			// Using the PHPCPR update function
			if ($_SESSION['debug']) {
				echo "UPDATE `{$table}` SET `{$fieldname}`='{$newvalue}' WHERE ID='{$PROF_ID}'<br />";
			}
			$updateResult = update($table, $prof_admin_updqry, [], ['ID' => ['=', $PROF_ID]], 1, 1, 1);

		}
		// Update query for members_change_log
		$changeLogUpdateData = [
			'confirmed' => 'A',
			'timestamp_confirmed' => $timestamp,
			'ip_confirmed' => $ip
		];

		// Using the PHPCPR update function
		$updateLogResult = update('members_change_log', $changeLogUpdateData, [], ['confcode' => ['=', $confcode]], 1, 1, 1);
	}
} else if ($dbitems_to_change > 0) { // Mail for confirmation if not admin and there are database items to change
	$to  = trim($buffer_mem['email']); // send to existing email in the members table
	$subject = 'Profile Change Confirmation is required!';

	//$message = 'Hello '.mysql_real_escape_string($_POST['FirstName']).' '.mysql_real_escape_string($_POST['LastName'].'hi';
	$message = 'Hello '.$_POST['FirstName'].' '.$_POST['LastName'].',

A request has been made to change important information in your '.$GLOBALS['webpage_name'].' profile. For security purposes, we will not change your profile until you confirm.

Please confirm that you want to make these changes to your profile information by clicking on this link: '.$GLOBALS['webpage_url_ssl'].'confirmchanges.php?confcode='.$confcode_url_enc.'

If you did not request any changes, there is no need to be concerned. No changes have occured. However we strongly suggest that you please login to your account, review your profile settings and change your password immediately.

Login Here:  ==> '.$GLOBALS['webpage_url_ssl'].'login.php?rd=Members/profile.php <==

Thank you for your cooperation,
'.$GLOBALS['webpage_name'].' Support';

	if ($use_sendgrid == true) { // USING SENDGRID
		sendgrid_email($to, $subject, $message);
	} else { // NO SENDGRID CREDENTIALS - - - USING PHP MAIL	
		mail($to, $subject, $message, "From: {$GLOBALS['admin_email_heading']} <{$GLOBALS['admin_email']}>\r\n");
	}
}		
// QQQ END NEW PROFILE UPDATE TO LOG ALL CHANGES AND CONFIRM VIA EMAIL	

//UPDATE SESSION VARIABLES AFTER PROFILE UPDATE!
if ($_SESSION['loggedin']) {

		$selectFields = '*';
		$mainTable = 'members';
		$where = ['ID' => ['=', $_SESSION['UserID']]];
		$result = select($selectFields, $mainTable, [], $where, null, null, null, 1, 1);
		$buffer = isset($result[0]) ? $result[0] : '';
		
		if ($buffer['payment_collected_by'] == 'member') $show_payment_link = true;
		else $show_payment_link = false;

		// NOW WE LOGIN THE MEMBER, AND SET UP THEIR SESSION VARS!
		// Fetching member_link information
		$selectFields = '*';
		$mainTable = 'member_link';
		$where = ['ID' => ['=', $buffer['ID']]];
		$mlnkinfoResult = select($selectFields, $mainTable, [], $where, null, null, null, 1, 1);
		$mlnkinfo = isset($mlnkinfoResult[0]) ? $mlnkinfoResult[0] : null;

		$_SESSION['Firstname_loggedin'] = $buffer['First_Name'];
		$_SESSION['Lastname_loggedin'] = $buffer['Last_Name'];
		$_SESSION['Email_loggedin'] =  $buffer['email'];
		$_SESSION['Phone_loggedin'] =  $mlnkinfo['phone'];
		$_SESSION['Address'] =  $mlnkinfo['address'];
		$_SESSION['Address2'] =  $mlnkinfo['address2'];
		$_SESSION['City'] =  $mlnkinfo['city'];
		$_SESSION['State'] =  $mlnkinfo['state'];
		$_SESSION['Province'] = $buffer['province'];
		$_SESSION['Zip'] =  $mlnkinfo['zip'];
		$_SESSION['Country'] =  $mlnkinfo['country'];
}
//END UPDATE

		//Please note that we need to set the const UPDATE to true before any of the addition update files will run. Which is a security function to protect the file from beeing run by itself.
		//define('UPDATE', true);
		
		//Include file that will update any other scripts running together with MLM, this file will allow the customers to use the script side by side with any script. 
		//include './../Inc/updatemember.inc.php';
		
		$success_msg = true;
} // END IF ($_GET['software'] == "AWS")




if (isset($success_msg) && $success_msg == true) {
//include 'header.php'; 

if ($_SESSION['loggedin']=='testQQQ') {
//print_r($_POST);
echo $ID;
echo '<br>';
echo $username;
echo '<br>';
}

if ((isset($_POST['Username']) && $_POST['Username'] != $_SESSION['loggedin'])) {
	echo '<h1>SESSION CHANGED! NOTHING SAVED.</h1>';
	// THIS WAS CREATED TO STOP ADMIN FROM OVERWRITING PROFILES BY MISTAKE
	echo '<h2>User session changed or expired!</h2>';
	echo '<h2><a href="profile.php">CLICK HERE TO CONTINUE</a>.</h2>';
	include 'footer.php';	
	exit;
}


if (!empty($_FILES['image']['tmp_name']) && is_uploaded_file($_FILES['image']['tmp_name'])) { ?>
Your photo has been updated.<p></p>
<?php } ?>
<?php if ($error_msg != "") { echo $error_msg . "<br /><br />"; }?>
<?php if (($_SESSION['admin_session_view'] || $bypass_confirmation == true) && $dbitems_to_change > 0) { ?>
<div style="text-align:center"><h2>Profile Has Been Updated!</h2><br />
<h3><a href="<?php echo $thispage; ?>">Click here to view the updated profile page</a></h3></div>.
<?php } else if ($dbitems_to_change > 0) { ?>
You have requested your settings to be updated. <br /><br />An email has been sent to <?php echo $to; ?> with a link to confirm these changes.<br /><br /> For security, changes will not be made until you confirm them by clicking on the link in that email.<br>
<p></p>
Once you have clicked on that email link to confirm your changes, please view your profile again to look at your changes.
<p></p>
Thank you!
<?php } else if (!empty($_FILES['image']['tmp_name']) && is_uploaded_file($_FILES['image']['tmp_name'])) { ?>
No other changes were made.<br /><br /><a href="<?php echo $thispage; ?>">Click here to view the updated profile page</a>.
<?php } else { ?>
No changes were made.<br /><br /><a href="<?php echo $thispage; ?>">Click here to return to the profile page</a>.
<?php } ?>
<p>&nbsp;<br />&nbsp;</p>

<?php
// ADDED BY JS 12/3/2014
if ($show_payment_link == true && isset($_GET['software']) && $_GET['software'] == 'AWS') { ?>

<a href="view_paymentcode.php">To check that your payment links work properly, please click here</a>.
<?php } ?>

<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>
<p>&nbsp;</p>

<?php include 'footer.php';
exit; // JS ADDED 4/15/16 
} else {
//include 'header.php';

if ($_SESSION['loggedin']=='testQQQ') {
echo '<pre>';	
print_r($_SESSION);
echo '</pre><br>';
//echo $_SESSION['UserID'];
echo $ID;
echo '<br>';
echo $username;
echo '<br>';
}

/*
if ($additional_level != true && $_SESSION['admin_session_view'] != true) {
echo '<div style="text-align:center"><h1>You must join a Business Center,<br/>to unlock this page and all menu items</h1></div><p>&nbsp;</p>';
include './footer.php';
exit;
}
*/
		if (empty($error_msg)) {
		
		$selectFields = '*';
		$mainTable = 'members';
		$where = ['ID' => ['=', $_SESSION['UserID']]];
		$result = select($selectFields, $mainTable, [], $where, null, null, null, 1, 1);
		$buffer = isset($result[0]) ? $result[0] : '';
		
		//echo 'buffer ID: '.$buffer['ID'];

	$image_path = $GLOBALS['path'].'images/Users/'.floor(($buffer['ID'] / 1000)).'/'.$buffer['ID'].'.jpg';
		
		$image_url = '';
		if (file_exists($image_path)) {			
			$image_exists = true;
			$image_url = $GLOBALS['webpage_url_ssl'].'images/Users/'.floor(($buffer['ID'] / 1000)).'/'.$buffer['ID'].'.jpg';
			}
		else {
			$image_exists = false;
			}

			
		if ($buffer['paymentprocessor9'] & 2) $_POST['accept_cash'] = '1';
	
		if ($buffer['paymentprocessor9'] & 4) $_POST['accept_check'] = '1';
		
		if ($buffer['paymentprocessor9'] & 8) $_POST['fedex'] = '1';
		elseif ($buffer['paymentprocessor9'] & 16) $_POST['fedex'] = '2';
		
		if ($buffer['paymentprocessor9'] & 32) $_POST['ups'] = '1';
		elseif ($buffer['paymentprocessor9'] & 64) $_POST['ups'] = '2';
		
		if ($buffer['paymentprocessor9'] & 128) $_POST['money_gram'] = '1';
		if ($buffer['paymentprocessor9'] & 256) $_POST['western_union'] = '1';	

		// Fetching member_link information
		$selectFields = '*';
		$mainTable = 'member_link';
		$where = ['ID' => ['=', $buffer['ID']]];
		$mlnkinfoResult = select($selectFields, $mainTable, [], $where, null, null, null, 1, 1);
		$buffer2 = isset($mlnkinfoResult[0]) ? $mlnkinfoResult[0] : '';

		$_POST['city'] = $buffer2['city'];
		$_POST['address'] = $buffer2['address'];
		$_POST['address2'] = $buffer2['address2'];
		$_POST['zip'] = $buffer2['zip'];
		$_POST['state'] = $buffer2['state'];
		$_POST['country'] = $buffer2['country'];
		$_POST['phone'] = $buffer2['phone'];
		
	// QQQ IF PAGE IS BREAKING WHEN UPDATING PROFILE, TRY COMMENTING THIS NEXT LINE TO TEST!
// IT COULD BE THE HOST HAS DISABLED base64 functions	
		$_POST['tax_id'] = !empty($buffer2['tax_id'])?decrypt($buffer2['tax_id']):'';
  // ADD SHIPPING ADDRESS INFO
  if ($GLOBALS['use_shipping'] === true) { 
            $_POST['ship_city'] = $buffer2['ship_city'];
		$_POST['ship_address'] = $buffer2['ship_address'];
		$_POST['ship_address2'] = $buffer2['ship_address2'];
		$_POST['ship_zip'] = $buffer2['ship_zip'];
		$_POST['ship_state'] = $buffer2['ship_state'];
		$_POST['ship_country'] = $buffer2['ship_country'];
  }
  // END ADD SHIPPING ADDRESS INFO
		$_POST['payment_collected_by'] = $buffer['payment_collected_by'];
		$_POST['ID'] = $buffer['ID'];	
		$_POST['province'] = $buffer['province'];
		$_POST['bitcoin'] = $buffer['bitcoin'];
		/*$_POST['dwolla_id'] = $buffer['dwolla_id'];
		$_POST['dwolla_pin'] = $buffer['dwolla_pin'];
		$_POST['dwolla_oauth_token'] = $buffer['dwolla_oauth_token'];*/
		$_POST['youtube'] = $buffer['youtube'];
		$_POST['debitcard'] = $buffer['debitcard'];
		$_POST['paid_for_card'] = $buffer['paid_for_card'];
		$_POST['payout_method'] = trim($buffer['payout_method']);
		$_POST['cellphone'] = $buffer['cellphone'];
		$_POST['sms_alert'] = $buffer['sms_alert'];
		//END UPDATE

		if ($_SESSION['loggedin'] == 'test') {
			//print_r($buffer);
			//echo ' LINE 935 ';
		}	
		
		/*$_POST['google_checkout'] = $buffer['gc_id'];
		$_POST['google_checkout_key'] = decrypt($buffer['gc_key']);*/
		
		$_POST['business_name'] = $buffer['business_name'];
		$_POST['display_name'] = $buffer['display_name'];
		$_POST['website'] = $buffer['website'];		
		
		
		$_POST['FirstName'] = $buffer['First_Name'];
		$_POST['LastName'] = $buffer['Last_Name'];
		//$_POST['password'] = $buffer['Password'];
		$_POST['bank_account'] = decrypt($buffer['bank_account']);
		$_POST['bank_routing'] = decrypt($buffer['bank_routing']);
		$_POST['paypalaccount'] = $buffer['paypalaccount'];
		$_POST['stripekey'] = $buffer['stripekey'];
		$_POST['stripesecretkey'] = $buffer['stripesecretkey'];
		$_POST['Email'] = trim($buffer['email']);

		$_POST['e4MerchName'] = $buffer['e4MerchName'];
		$_POST['e4gatewayID'] = $buffer['e4gatewayID'];
		$_POST['e4password'] = $buffer['e4password'];

		$_POST['paymentprocessor1'] = $buffer['paymentprocessor1'];
		$_POST['paymentprocessor2'] = $buffer['paymentprocessor2'];
		$_POST['paymentprocessor3'] = $buffer['paymentprocessor3'];
		$_POST['paymentprocessor4'] = decrypt($buffer['paymentprocessor4']);
		$_POST['paymentprocessor5'] = $buffer['paymentprocessor5'];
		$_POST['paymentprocessor6'] = $buffer['paymentprocessor6'];
		$_POST['paymentprocessor7'] = $buffer['paymentprocessor7'];
		$_POST['paymentprocessor8'] = $buffer['paymentprocessor8'];
		//payment processor 9 is used earlier in the list
		$_POST['paymentprocessor10'] = $buffer['paymentprocessor10'];
				}
			else {
				$image_path = $GLOBALS['path'].'images/Users/'.floor(($buffer['ID'] / 1000)).'/'.$buffer['ID'].'.jpg';
				$image_url = '';
				if (file_exists($image_path)) {					
					$image_exists = true;
					$image_url = $GLOBALS['webpage_url_ssl'].'images/Users/'.floor(($buffer['ID'] / 1000)).'/'.$buffer['ID'].'.jpg';
					}
				else {
					$image_exists = false;
					}
				}
?>
<form role="form" method="post" enctype="multipart/form-data" action="<?php echo $thispage;?>?software=AWS">

<?php
echo "<div class='col-md-12'>";
echo "<input type=\"hidden\" name=\"ID\" value=\"{$_POST['ID']}\">";

	if (!empty($error_msg)) {
		echo '<br><div style="color:#FF0000; font-size:2">".$error_msg."<br><br></div>';
		}
?>
<style>
#cover div {
  display: none
}
</style>

<script>
var i = 1;

var go = setInterval(function(){
    
$('#slider_'+i).show('slide', { direction: 'left' }, 500);
    
            i++;
           // if (i == 4) { i = 1}

         }, 300)
</script>
<div class="cover">
	<div class="text-left" id="slider_1">
	<h4><button type="button" class="btn btn-primary btn-lg" data-target="#personal, #aboutme, #billing, #shipping, #choose_pay, #direct, #firstdata, #authnet, #paypal, #payza, #bitcoin, #cashapp, #stripe, #bank" data-toggle="collapse">
	<!--
	<sub><small><small>
	<div class="fs1 icon-ok icon-3x" aria-hidden="true"></div>
	</small></small></sub>
	-->
	>> Show All Options
	</button></h4>
	 </div>
</div>	 

<!--
	<div class="col-md-4 text-left" id="slider_1">
	<button type="button" class="btn btn-primary btn-lg" data-target="#personal" data-toggle="collapse">
	<h4><sub><small><small><div class="fs1 icon-user icon-3x" aria-hidden="true"></div></small></small></sub>
	Personal Information</h4>
	</button>
<p>&nbsp;</p>
	 </div>
	 
	<div class="col-md-4 text-left" id="slider_2">
	<button type="button" class="btn btn-primary btn-lg" data-target="#billing" data-toggle="collapse">
	<h4><sub><small><small><div class="fs1 icon-user icon-3x" aria-hidden="true"></div></small></small></sub>
	Billing Information</h4>
	</button>
<p>&nbsp;</p>
	 </div>

	<div class="col-md-4 text-left" id="slider_3">
	<button type="button" class="btn btn-primary btn-lg" data-target="#social" data-toggle="collapse">
	<h4><sub><small><small><div class="fs1 icon-user icon-3x" aria-hidden="true"></div></small></small></sub>
	Social Information</h4>
	</button>
<p>&nbsp;</p>
	 </div>	 
-->
			<div class="panel panel-primary panel-master">
				<a href="#personal" data-toggle="collapse" style="text-decoration:none;">
					<div class="panel-heading text-left">
                          <h4><sub><small><small><div class="fs1 icon-user icon-3x" style="color:#697f9c" aria-hidden="true"></div></small></small></sub>
						  My Personal Information</h4>
					</div>
				</a>
                <div id="personal" class="panel-body <?php echo $collapse; ?>">
	
<div class="col-md-6 text-left">
<div class="form-group"> 	
<label for="Username">
Username:</label>	<input class="form-control" size="50%" name="Username" placeholder="Username" title="Username" value="<?php echo $_SESSION['loggedin'];?>" readonly>
</div>
</div>

<div class="col-md-6 text-left">
<div class="form-group">
<label for="Password">
New Password: (This field is ONLY used for changing your password)</label>	<!--<input class="form-control" size="50%" name="password" placeholder="Password" title="Password" value="<?php echo ((!empty($_POST['password']))?$_POST['password']:'');?>">	-->
<input class="form-control" size="50%" name="password" placeholder="Enter new password, or leave empty to keep current password" title="Password" value="">			
</div>
</div>

<div class="col-md-6 text-left">
<div class="form-group">
<label for="Business Name">
Business Name:</label>	<input class="form-control" size="50%" name="business_name" placeholder="Business Name" title="Business Name" value="<?php echo ((!empty($_POST['business_name']))?$_POST['business_name']:'');?>">
</div>
</div>
<div class="col-md-6 text-left">
<div class="form-group">
<label for="Display Name">
Display Name:</label>	<input class="form-control" size="50%" name="display_name" placeholder="Display Name" title="Display Name" value="<?php echo ((!empty($_POST['display_name']))?$_POST['display_name']:'');?>">
</div></div>


<div class="col-md-6 text-left">
<div class="form-group">
<label for="First Name">
First Name:</label>	<input class="form-control" size="50%" name="FirstName" placeholder="First Name" title="First Name" value="<?php echo ((!empty($_POST['FirstName']))?$_POST['FirstName']:'');?>">
</div></div>
<div class="col-md-6 text-left">
<div class="form-group">
<label for="Last Name">
Last Name:</label>	<input class="form-control" size="50%" name="LastName" placeholder="Last Name" title="Last Name" value="<?php echo ((!empty($_POST['LastName']))?$_POST['LastName']:'');?>">
</div></div>

<div class="col-md-6 text-left">
<div class="form-group">
<label for="Email">
Contact Email:</label>	<input class="form-control" size="50%" name="Email" placeholder="Email" title="Email" value="<?php echo ((!empty($_POST['Email']))?$_POST['Email']:'');?>">
</div></div>

<div class="col-md-6 text-left">
<div class="form-group">
<label for="Phone">
Phone:</label>	<input class="form-control" size="50%" name="phone" placeholder="Phone" title="Phone" value="<?php echo ((!empty($_POST['phone']))?$_POST['phone']:'');?>">
</div></div>

<?php
// QQQ FOR DESIGN TESTING
//$_SESSION['a'.$_SESSION['UserID']]['affiliate_status'] = true;
//$GLOBALS['member_taxid'] = true;
//$_POST['country'] = 'US';
if ($GLOBALS['member_taxid'] === true && $_SESSION['a'.$_SESSION['UserID']]['affiliate_status'] == true && $_POST['country'] == 'US' && $ID != 1) {	
$tax = trim($_POST['tax_id']);
?>
<div class="col-md-6 text-left" style="margin-top 20pt">
<div class="form-group">
<label for="Tax ID">
Tax ID (SS#):</label> (Encrypted in database, for your protection). <input class="form-control" size="50%" name="tax_id" placeholder="Tax ID" title="Tax ID Number" value="<?php echo ((!empty($tax))?$tax:'');?>">
</div></div>
<?php } else { // USE PLACEHOLDER DIV TO KEEP MOBILE PHONE AGREEMENT UNDER THE PHONE FIELD!
?>
<div class="col-md-6 text-left" style="margin-top 20pt">
<div class="form-group">
</div></div>	
<?php	
} 
// END TAX ID INFO
if ($use_twilio == true) {
?>
<div class="col-md-6 text-left">
<div class="form-group">

<input type="checkbox" name="sms_check" title="Yes, this is a mobile phone number!" value="yes" <?php if (!empty($_POST['sms_alert'])) echo ' checked';?>> 
Yes! This is a mobile phone number. I authorize <?php echo $GLOBALS['webpage_name']; ?> to send SMS Text Alerts to notify me of important updates, new referrals and upgrades. I understand mobile data fees may apply. I may turn this setting on / off at any time by checking or unchecking this box, and updating my profile.
</div></div>
<?php } // END TWILIO TRUE
?>

</div>
</div>
<!-- END 1ST ROW -->

<?php
if ($GLOBALS['allow_custom_info'] === true && $_SESSION['a'.$_SESSION['UserID']]['affiliate_status'] === true) {
?>
			<div class="panel panel-primary panel-master">
				<a href="#aboutme" data-toggle="collapse" style="text-decoration:none;">
					<div class="panel-heading text-left">
                          <h4><sub><small><small><div class="fa fa-picture-o fa-3x" style="color:#697f9c" aria-hidden="true"></div></small></small></sub>
						  My "About Me" Information</h4>
					</div>
				</a>
                <div id="aboutme" class="panel-body collapse">
	
<div class="col-md-6 text-left">
<div class="form-group"> 

<div class="text-left">
Image:
<?php
if ($image_exists === true) { 
	echo '<img src="'.$image_url.'?'.filemtime($image_url).'" style="width: '.$about_width.'px; height: '.$about_height.'px;">';
	echo '<br/>NOTE: If you upload a NEW picture, You may need to clear your browser cache, to see your picture change here.
	</div>
	<div>
	<br /><br />If you wish to replace the image, choose a new one below.<br />';
}
?>



				<input type="file" size="50%" name="image" class="form-control"><br />
				You may upload .gif, .png and .jpg images. Max size 500KB.<br /><br />
<hr>
YouTube Video:<input class="form-control" size="50%" name="youtube" value="<?php echo ((!empty($_POST['youtube']))?$_POST['youtube']:'');?>">
<br/>				Have a Youtube video? You may embed your YouTube video html code here. You must use the embed code, and only use the following portion of the youtube embed code. Example: https://www.youtube.com/embed/_TYOnjlcF3Y

<hr>
My Website:<input class="form-control" size="50%" name="website" value="<?php echo ((!empty($_POST['website']))?$_POST['website']:'');?>">
<br/>		
</div>
</div>
</div>				
<div class="col-md-6 text-right">
<div class="form-group"> 

<?php if ($image_exists === true) { ?>
<p>&nbsp;</p>
<p>&nbsp;</p>
<?php } ?>
<div class="text-left">About Me Text:</div>
<textarea class="form-control" rows="14" cols="50" name="paymentprocessor8"><?php echo ((!empty($_POST['paymentprocessor8']))?$_POST['paymentprocessor8']:'');?></textarea>
<br/>
<div class="text-center">Please add the information you want in your "About Me" section, above.</div>
<hr>
</div>

<?php
/*
$ref_ID = $_SESSION['RefUserID'];
$selectFields = 'youtube';
$mainTable = 'members';
$where = ['ID' => ['=', $ref_ID]];
$result = select($selectFields, $mainTable, [], $where, null, null, null, 1, 1);
$buffer_social = isset($result[0]) ? $result[0] : '';

$youtube = $buffer_social['youtube'];

if (!empty($youtube)) { ?> 
<div class="text-left">A message from your sponsor:<br/><br/></div>

<div class="embed-responsive embed-responsive-16by9">
<iframe class="embed-responsive-item" src="<?php echo $youtube; ?>?rel=0&showinfo=0" frameborder="0" allowfullscreen style="margin: 0px"></iframe>
<!--<iframe src="https://player.vimeo.com/video/xxxxxxx" width="640" height="360" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>-->		
</div>
<?php }
*/ ?>
</div>
</div></div>
<?php
} // END CUSTOM ABOUT ME INFO
?>	
			<div class="panel panel-primary panel-master">
				<a href="#billing" data-toggle="collapse" style="text-decoration:none;">
					<div class="panel-heading text-left">
                          <h4><sub><small><small><div class="fs1 icon-list-alt icon-3x" style="color:#697f9c" aria-hidden="true"></div></small></small></sub>
						  My Address Information</h4>
					</div>
				</a>
                <div id="billing" class="panel-body collapse">							  
						  

<div class="col-md-6 text-left">
<div class="form-group">						  
Address:	<input class="form-control" size="50%" name="address" placeholder="Address" title="Address" value="<?php echo ((!empty($_POST['address']))?$_POST['address']:'');?>">
</div></div>
<div class="col-md-6 text-left">
<div class="form-group">
Address 2:	<input class="form-control" size="50%" name="address2" placeholder="Address 2" title="Address 2" value="<?php echo ((!empty($_POST['address2']))?$_POST['address2']:'');?>">
</div></div>
<div class="col-md-6 text-left">
<div class="form-group">
City:	<input class="form-control" size="50%" name="city" placeholder="City" title="City" value="<?php echo ((!empty($_POST['city']))?$_POST['city']:'');?>">
</div></div>
<div class="col-md-6 text-left">
<div class="form-group">
Zip:	<input class="form-control" size="50%" name="zip" placeholder="Zip" title="Zip" value="<?php echo ((!empty($_POST['zip']))?$_POST['zip']:'');?>">
</div></div>
<div class="col-md-6 text-left">
<div class="form-group">
State:						
<?php echo '<select name="state" title="State" class="form-control">
      <option value="">Please select a state</option>
      <option value="1" ' . ((!empty($_POST['state']) && strtoupper($_POST['state']) == '1') ? 'selected' : '') . '>Not applicable</option>';

// Using PHPCPR select function to fetch states
$result = select('*', 'states', [], ['id' => ['<', 5000]], null, null, null, 0, 1);

if (!empty($result)) {
    foreach ($result as $buffer) {
        $selected = (!empty($_POST['state']) && strtoupper($_POST['state']) == strtoupper($buffer['abbrev'])) ? 'selected' : '';
        echo '<option value="' . htmlspecialchars($buffer['abbrev'], ENT_QUOTES) . '" ' . $selected . '>' . htmlspecialchars($buffer['name'], ENT_QUOTES) . '</option>';
    }
}

echo '</select><br/><a href="#outside_usa" class="btn btn-default" data-toggle="collapse">Outside USA?</a></div>';
?>
					<div id="outside_usa" class="collapse">
					<div class="form-group">
If you are located outside the USA, please select "Not Applicable" in the State drop down box above, and add your Province/State below.
<br/><br/>					
Province/State:	<input class="form-control" size="50%" name="province"  placeholder="Province" title="Province" value="<?php echo ((!empty($_POST['province']))?$_POST['province']:'');?>">
</div>
					</div>
					</div>

<div class="col-md-6 text-left">
<div class="form-group">
Country:	<select name="country" title="Country" class="form-control">
<?php					
					
if (empty($_POST['country'])) $_POST['country'] = 'US';

$selectFields = ['iso', 'printable_name'];
$mainTable = 'country';
$result = select($selectFields, $mainTable, [], ['1'], null, null, null, 0, 1);

foreach ($result as $buffer) {
    $selected = (strtoupper($_POST['country']) == $buffer['iso']) ? 'selected' : '';
    echo '<option value="'.$buffer['iso'].'" '.$selected.'>'.$buffer['printable_name'].'</option>';
}

echo '</select>';
echo '</div></div>';

?>


</div>
</div> <!-- END 2ND ROW -->
<!--
<div style="text-align:center"><p>&nbsp;</p><input class="btn btn-default" type="submit" value="Update Profile" name="submit">
<p>&nbsp;</p><h5><span style="color:#ff0000">NOTE:</span> You must click the "Update Profile" button (above) for changes to take effect!</span></h5><p>&nbsp;</p>
</div>
</form>
-->
<?php
// QQQ NOTE SHIPPING HAS NOT BEEN TESTED - TEST PROFILE UPDATES, AND COUNTRY NEEDS IT'S OWN SPOT IN DB!!
//$GLOBALS['use_shipping'] = true;
//if ($GLOBALS['use_shipping'] === true || $_SESSION['loggedin'] == 'testjim') {
if ($GLOBALS['use_shipping'] === true) {	
?>

<div class="panel panel-primary panel-master">
				<a href="#shipping" data-toggle="collapse">
					<div class="panel-heading text-left">
                          <h4><sub><small><small><div class="fs1 icon-list-alt icon-3x" style="color:#697f9c" aria-hidden="true"></div></small></small></sub>
						  My Shipping Information</h4>
					</div>
				</a>
                <div id="shipping" class="panel-body collapse">	

<div class="col-md-6 text-left">						  
<div class="form-group">
Ship Address:	<input class="form-control" size="50%" name="ship_address" placeholder="Ship Address" title="Ship Address" value="<?php echo ((!empty($_POST['ship_address']))?$_POST['ship_address']:'');?>">
</div></div>
<div class="col-md-6 text-left">
<div class="form-group">
Ship Address 2:	<input class="form-control" size="50%" name="ship_address2" placeholder="Ship Address 2" title="Ship Address 2" value="<?php echo ((!empty($_POST['ship_address2']))?$_POST['ship_address2']:'');?>">
</div></div>
<div class="col-md-6 text-left">
<div class="form-group">
Ship City:	<input class="form-control" size="50%" name="ship_city" placeholder="Ship City" title="Ship City" value="<?php echo ((!empty($_POST['ship_city']))?$_POST['ship_city']:'');?>">
</div></div>
<div class="col-md-6 text-left">
<div class="form-group">
Ship Zip:	<input class="form-control" size="50%" name="ship_zip" placeholder="Ship Zip" title="Ship Zip" value="<?php echo ((!empty($_POST['ship_zip']))?$_POST['ship_zip']:'');?>">
</div></div>			  
<div class="col-md-6 text-left">
<div class="form-group">
Ship State:						
<?php echo '<select name="ship_state" title="Ship State" class="form-control"><option value="">Please select a state</option><option value="1" '.((!empty($_POST['ship_state']) && strtoupper($_POST['ship_state']) == 1)?'selected':'').'>Not applicable</option>';

		// Using the PHPCPR select function to count entries
		$result = select('COUNT(*) as stateCount', 'states', [], ['abbrev' => ['=', $state]], null, null, null, 0, 1);

    if (!empty($result)) {
        foreach ($result as $buffer) {
						if (!empty($_POST['ship_state']) && strtoupper($_POST['ship_state']) == $buffer['abbrev']) $selected = 'selected';
						else $selected = '';

						echo '<option value="'.$buffer['abbrev'].'" '.$selected.'>'.$buffer['name'].'</option>';
						}
	}	
					echo '</select>';
					//echo '</div></div>';
					
					echo '</select><br/><a href="#outside_usa_shipping" class="btn btn-default" data-toggle="collapse">Outside USA?</a></div>'; ?>
					<div id="outside_usa_shipping" class="collapse">
					<div class="form-group">
If you are located outside the USA, please select "Not Applicable" in the State drop down box above, and add your Province/State below.
<br/><br/>					
Province/State:	<input class="form-control" size="50%" name="ship_province" value="<?php echo ((!empty($_POST['ship_province']))?$_POST['ship_province']:'');?>">
</div>
		</div>					


<div class="col-md-6 text-left">
<div class="form-group">
Ship Country:	<select class="form-control" name="ship_country" title="Ship Country">
<?php
		$country = $_POST['ship_country'];
		$country = strtoupper($country);

		// Using the PHPCPR select function to count entries
		$result = select('COUNT(*) as countryCount', 'country', [], ['iso' => ['=', $country]], null, null, null, 0, 1);					
					if (empty($_POST['ship_country'])) $_POST['ship_country'] = 'US';
					
					
    if (!empty($result)) {
        foreach ($result as $buffer) {
						if (strtoupper($_POST['ship_country']) == $buffer['iso']) $selected = 'selected';
						else $selected = '';

						echo '<option value="'.$buffer['iso'].'" '.$selected.'>'.$buffer['printable_name'].'</option>';
						}
	}	
					echo '</select></div></div></div>';

} // END SHIPPING ADDRESS FIELDS

	// ALLOW MEMBER TO CHOOSE HOW TO ACCEPT PAYMENT
if ($member_chooses_payment_method === true) { 
		?>
		
		<div class="panel panel-primary panel-master">
		<a href="#choose_pay" data-toggle="collapse" style="text-decoration:none;">
			<div class="panel-heading text-left">
            <h4><sub><small><small><div class="fs1 icon-wallet icon-3x" style="color:#697f9c" aria-hidden="true"></div></small></small></sub>
			My Payment Collection Method</h4>
			</div>
			</a>
       <div id="choose_pay" class="panel-body <?php echo $collapse; ?>">					  

<div class="col-md-12 text-left">

<input type="radio" name="payment_collected_by" value="admin" <?php if ($_POST['payment_collected_by'] == 'admin') echo 'checked'; ?>> 
Please collect payments for me. I understand there is a 20% processing fee.<br />
		
<input type="radio" name="payment_collected_by" value="member" <?php if ($_POST['payment_collected_by'] == 'member') echo 'checked'; ?>>
I will collect my own payments directly, using methods I will list below.<br />

<!--
		<span style="color:#FF0000">	Note: If you choose to let us collect payment on your behalf, you will be paid any commissions due once per week on Friday (unless it is a USA holiday).
		</span><br /><br />
-->		
</div></div></div>
		<?php			
} // END ALLOW MEMBER TO CHOOSE HOW TO ACCEPT PAYMENT

if ($_SESSION['loggedin'] == $GLOBALS['administrator'] || ($GLOBALS['cust_payment'] === true && $GLOBALS['member_payment'] === true)) {
	?>
			<div class="panel panel-primary panel-master">
				<a href="#direct" data-toggle="collapse" style="text-decoration:none;">
					<div class="panel-heading text-left">
                          <h4><sub><small><small><div class="fs1 icon-money icon-3x" style="color:#697f9c" aria-hidden="true"></div></small></small></sub>
						  My Custom Payment Information</h4>
					</div>
				</a>
                <div id="direct" class="panel-body <?php echo $collapse; ?>">					  
				
<div class="col-md-6 form-inline text-left">
I will accept payment by:

			<input type="checkbox" name="accept_cash" value="1" <?php echo ((isset($_POST['accept_cash']) && $_POST['accept_cash'] == '1')?' checked="checked"':'');?>> Cash 
			<input type="checkbox" name="accept_check" value="1" <?php echo ((isset($_POST['accept_check']) && $_POST['accept_check'] == '1')?' checked="checked"':'');?>> Checks<br />
			<!--
			<span style="color:#FF0000">	Note: Cash or Checks has to be checked for Direct Payment Info to show on the payment page.</span><br />
			-->	<br/>
via the following methods (please include your phone number for contact):<br/>
<br/>
				
<?php
echo '
			<input type="radio" name="fedex" value="1"'.((isset($_POST['fedex']) && $_POST['fedex'] == '1')?' checked="checked"':'').'> Fedex (Signature Required) 
			<input type="radio" name="fedex" value="2"'.((isset($_POST['fedex']) && $_POST['fedex'] == '2')?' checked="checked"':'').'> Fedex (No Signature Required)'; 
			
			if (isset($_POST['fedex']) && ($_POST['fedex'] == '1' || $_POST['fedex'] == '2')) echo '
			<input type="radio" name="fedex" value="3"'.((isset($_POST['fedex']) && $_POST['fedex'] == '3')?' checked="checked"':'').'> No Fedex';

echo '<br/>
			<input type="radio" name="ups" value="1"'.((isset($_POST['ups']) && $_POST['ups'] == '1')?' checked="checked"':'').'> UPS (Signature Required) 
			<input type="radio" name="ups" value="2"'.((isset($_POST['ups']) && $_POST['ups'] == '2')?' checked="checked"':'').'> UPS (No Signature Required)';

			if (isset($_POST['ups']) && ($_POST['ups'] == '1' || $_POST['ups'] == '2')) echo '	
			<input type="radio" name="ups" value="3"'.((isset($_POST['ups']) && $_POST['ups'] == '3')?' checked="checked"':'').'> No UPS';

echo '<br/>
			<input type="radio" name="money_gram" value="1"'.((isset($_POST['money_gram']) && $_POST['money_gram'] == '1')?' checked="checked"':'').'> Money Gram';

			if (isset($_POST['money_gram']) && $_POST['money_gram'] == '1') echo '			
			<input type="radio" name="money_gram" value="2"'.((isset($_POST['money_gram']) && $_POST['money_gram'] == '2')?' checked="checked"':'').'> No Money Gram';
echo '<br/>
			<input type="radio" name="western_union" value="1"'.((isset($_POST['western_union']) && $_POST['western_union'] == '1')?' checked="checked"':'').'> Western Union';

			if (isset($_POST['western_union']) && $_POST['western_union'] == '1') echo '			
			<input type="radio" name="western_union" value="2"'.((isset($_POST['western_union']) && $_POST['western_union'] == '2')?' checked="checked"':'').'> No Western Union';
				
echo '<br />
</div>
<div class="col-md-6 form-inline text-left">				
<div class="text-left" style="margin-top:0px;">List all custom payment methods you accept, in the textbox below.<br/>
If you are accepting cash / checks, include your name / address / phone</div><br/>
				<textarea class="form-control" rows="3" cols="55" name="paymentprocessor10">'.((!empty($_POST['paymentprocessor10']))?$_POST['paymentprocessor10']:'').'</textarea><br/><br/>Put your payment instructions above. Your email will show by default.
				<br/>URLs must be enclosed between the tags [url] and [/url] to be clickable.
				<br/ >Begin URL http:// or https:// e.g.: [url]http://domain.com/page.html[/url]
				
<br /><br /></div></div></div>';
	}


// E4
if ($GLOBALS['use_E4'] === true && ($GLOBALS['member_payment'] === true || $_SESSION['loggedin'] == $GLOBALS['administrator'])) {
?>
			<div class="panel panel-primary panel-master">
				<a href="#firstdata" data-toggle="collapse" style="text-decoration:none;">
					<div class="panel-heading text-left">
                          <h4><sub><small><small><div class="fa fa-credit-card fa-3x" style="color:#697f9c" aria-hidden="true"></div></small></small></sub>
						  My First Data Information</h4>
					</div>
				</a>
				<div id="firstdata" class="panel-body <?php echo $collapse; ?>">	
	
<!--	
	<div class="col-md-6 form-inline text-left">	
						  
	<span style="color:red"><b>RECOMMENDED!</b></span> The Fastest and Easiest Way to Get Paid: 

	First Data has been integrated into your <?php echo $GLOBALS['webpage_name'];?> website. First Data is the world leader in credit card processing and has established a unique program that has PRE-APPROVED The <?php echo $GLOBALS['webpage_name'];?> business model and provides significantly discounted merchant services to you. This merchant account allows you to accept credit cards and enjoy the security and convenience of having the proceeds deposited quickly and directly into your bank account.

<br />
<br />
<span style="color:red"><b>SORRY USA RESIDENTS ONLY! No set up fees. Rates are very low - monthly merchant fee is half industry average (only $24.95/mo) and includes everything. Transaction fee is only .05% and .25 cents per transaction with no limits. </b></span>
<br />
<br />

<div class="panel panel-default coupon">
To get started, <a href="First-Data-Application.rtf" target="_blank" ><b>Click here</b></a> for an application, you may save to your hard drive. Then send your completed application to Joe Sestito <a href="mailto:joe@fdis-mws.com?subject=<?php echo $GLOBALS['webpage_name'];?> First Data Inquiry">joe@fdis-mws.com</a> ph. 508-226-1333  fax: 508-484-9419<br />
</div>

<br />
<span style="color:red"><b><small>DO NOT SET UP WITH FIRST DATA DIRECTLY OR YOUR ACCOUNT WILL NOT WORK WITH OUR SYSTEM, AND YOU WILL NOT GET THESE LOW RATES OR SETUP FEES WAIVED.</small></b></span>
</div>
-->
<div class="col-md-12 form-inline text-right">
<div class="text-left">
<b>HOW TO SET UP FIRST DATA:</b> 
<br /><br />
Once you receive your login details for your First Data Merchant Account, login to <a href="https://globalgatewaye4.firstdata.com" target="_blank"><b>First Data</b></a>, click on Terminals. Under the Gateway column, click on the gateway ID number. On this page you can grab your Gateway ID, and generate a new password for your gateway password shown. Next, click their update button, and then add these credentials into your profile here. You need to be using Payeeze Gateway version 11. <!--Please review <a href="../e4/E4-Gateway-Setup.pdf" target="_blank"><b>E4 Gateway Setup</b></a> for an overview. Once you have set up your account with Joe Sestito,--> Any technical questions on how to set up your account, call First Data customer service. They are available 7 days a week. 
<br />
<br />
</div>
<div style="margin-right:0px">
Merchant DBA Name:
<?php echo "<input class='form-control' size='25' name='e4MerchName' value='".((!empty($_POST['e4MerchName']))?$_POST['e4MerchName']:'')."'>
<a href='javascript:alert(\"Type or copy and paste the Merchant DBA Name exactly as it appears in the welcome emails you received.\");'><img src=\"../images/questionmark.gif\" border=\"0\"></a>
				<br /><br />
Gateway ID:
				<input class='form-control' size='25' name='e4gatewayID' value='".((!empty($_POST['e4gatewayID']))?$_POST['e4gatewayID']:'')."'>
<a href='javascript:alert(\"Type or copy and paste your e4gatewayID. If you need help locating this, click the Need Help link, above. Do NOT use your Administrative User Name that was emailed to you!\");'><img src=\"../images/questionmark.gif\" border=\"0\"></a>

<br />
<br />
Gateway Password:
				<input class='form-control' size='25' name='e4password' value='".((!empty($_POST['e4password']))?$_POST['e4password']:'')."'>
<a href='javascript:alert(\"Type or copy and paste your E4 Gateway password here. If you need help locating this, click the Need Help link, above. Do NOT use your Administrative User Password that was emailed to you!\");'><img src=\"../images/questionmark.gif\" border=\"0\"></a>

<br />
<br /></div></div></div></div>";
}
// END FIRST DATA E4 


// AUTHORIZE.NET
// QQQ FOR NWC
//if ($GLOBALS['use_authorize'] === true && ($GLOBALS['member_payment'] === true && $_POST['paymentprocessor3']!='' || $_SESSION['admin_session_view'] == true)) {
if ($GLOBALS['use_authorize'] === true && ($GLOBALS['member_payment'] === true || $_SESSION['loggedin'] == 'admin')) {	
?>

			<div class="panel panel-primary panel-master">
				<a href="#authnet" data-toggle="collapse" style="text-decoration:none;">
					<div class="panel-heading text-left">
                          <h4><sub><small><small><div class="fa fa-credit-card fa-3x" style="color:#697f9c" aria-hidden="true"></div></small></small></sub>
						  My Authorize.Net Information</h4>
					</div>
				</a>
                <div id="authnet" class="panel-body <?php echo $collapse; ?>">	

<div class="col-md-3 form-inline text-right">&nbsp;</div><div class="col-md-6 form-inline text-right">
<?php echo "
		Authorize.Net ARB Login Key:
		<input class='form-control' size='25%' name='paymentprocessor3' value='".((!empty($_POST['paymentprocessor3']))?$_POST['paymentprocessor3']:'')."'> 
		<hr>
		Authorize.Net ARB Transaction Key:
		<input class='form-control' size='25%' name='paymentprocessor4' value='".((!empty($_POST['paymentprocessor4']))?$_POST['paymentprocessor4']:'')."'><br />
<a href=\"http://authorize.net/\" target=\"_blank\">Authorize.Net Account</a><br/>
		<br /></div><div class='col-md-3 form-inline text-right'>&nbsp;</div></div></div>";
}


// STRIPE
if ($GLOBALS['use_stripe'] === true && $_SESSION['loggedin'] == 'admin') { 
?>
			<div class="panel panel-primary panel-master">
				<a href="#stripe" data-toggle="collapse" style="text-decoration:none;">
					<div class="panel-heading text-left">
                          <h4><sub><small><small><div class="fa fa-credit-card fa-3x" style="color:#697f9c" aria-hidden="true"></div></small></small></sub>
						 Stripe Information</h4>
					</div>
				</a>
               <div id="stripe" class="panel-body <?php echo $collapse; ?>">
               		Stripe key:
					<input class="form-control" size="" name="stripekey" value="<?php echo ((!empty($_POST['stripekey']))?$_POST['stripekey']:'');?>">

               		Stripe secret or restricted key:
					<input class="form-control" size="" name="stripesecretkey" value="<?php echo ((!empty($_POST['stripesecretkey']))?$_POST['stripesecretkey']:'');?>">					
               </div>
            </div>

<?php 
}

// PAYPAL
if (($GLOBALS['use_paypal'] === true || in_array('paypal', $GLOBALS['withdrawal_options_array'])) && ($GLOBALS['member_payment'] === true || $_SESSION['loggedin'] == $GLOBALS['administrator'])) {
?>
			<div class="panel panel-primary panel-master">
				<a href="#paypal" data-toggle="collapse" style="text-decoration:none;">
					<div class="panel-heading text-left">
                          <h4><sub><small><small><div class="fa fa-cc-paypal fa-3x" style="color:#697f9c" aria-hidden="true"></div></small></small></sub>
						  My Paypal Information</h4>
					</div>
				</a>
               <div id="paypal" class="panel-body <?php echo $collapse; ?>">

<?php
		echo "Paypal Email:

				<input class=\"form-control\" size=\"\" name=\"paypalaccount\" value=\"".((!empty($_POST['paypalaccount']))?$_POST['paypalaccount']:'')."\">

				<a href=\"{$GLOBALS['paypal_affiliate_link']}\" target=\"_blank\">Free Paypal Account</a>";
?><hr>
<div class='text-left'>				
<span style='color:#FF0000'><strong>NOTE:</strong></span> We do not endorse or recommend Paypal. Use it at your own risk.<!-- You must use the same email address you used to register with paypal, or the IPNs will fail, meaning people paying you, will not automatically get credit for the sale. You need a Premier or Business account with Paypal.-->
<br /></div><div class='col-md-3 form-inline text-right'></div></div></div>
<?php
}



/*
if ($GLOBALS['use_gc'] === true && ($GLOBALS['member_payment'] === true || $_SESSION['loggedin'] == $GLOBALS['administrator'])) {
	echo "<h2>Google Checkout:</h2>

		Google Checkout Merchant ID:
		<input class='form-control' size='25' name='google_checkout' value='".((!empty($_POST['google_checkout']))?$_POST['google_checkout']:'')."'> 
<a href=\"http://googlecheckout.com\" target=\"_blank\">Free Google Checkout Account</a>

				Google Checkout Merchant Key:

				<textarea class='form-control' cols='25'  name='google_checkout_key' >".((!empty($_POST['google_checkout_key']))?$_POST['google_checkout_key']:'')."</textarea><br />


<span style=\"color:red\"><b>IMPORTANT:</b></span> Google Checkout will only work with the correct settings and IPN address, in your Google account. Login to Google Checkout, click on the \"Settings\" tab, then click \"Preferences\". Select \"Automatically authorize the buyer's credit card for the full amount of the order\", then click \"Save preferences\". Next, click on \"Integration\", and check the box \"Shopping cart post security\". Next, in the box marked \"API callback URL:\" enter the URL: \"{$GLOBALS['webpage_url_ssl']}Ipn/GoogleCheckout.api.php\" without the quotation marks. Make sure the callback method is XML. On this same page, get the variables for your Google merchant ID and Google merchant key, and put these into the appropriate fields above on this page you are reading now, and click the \"Update Profile\" button, below.
<p>
Make certain that there are no additional whitespace or linebreaks after/before the Merchant ID or Merhcant Key. If there are, your members will not be able to use your payment button. If you are not able to remove the spaces or linebreaks, remove the Merchant ID or Merchant Key, then remove the spaces or linebreaks before adding the Merchant ID or Merchant Key back.
</p><span style=\"color:red\"><strong>NOTE:</strong></span>
We do not endorse or recommend Google Checkout. Due to the high volume of requests to add it as a processor, we have done so, but you agree by entering your Google Checkout account information here, that you are using Google Checkout at your own risk.<p></p>
			";
} else {
	echo '<input type="hidden" name="google_checkout" value="'.((!empty($_POST['google_checkout']))?$_POST['google_checkout']:'').'"><input type="hidden" name="google_checkout_key" value="'.((!empty($_POST['google_checkout_key']))?$_POST['google_checkout_key']:'').'">';					
}
*/

// BITCOIN - QQQ KLUDGE (ADD TRUE ||) TO SHOW IN ADMIN COLLECTS, SO WE CAN GET THEIR BITCOIN ADDRESS TO PAY COMMS TO.

if (($GLOBALS['show_withdrawal_options'] && in_array("bitcoin", $GLOBALS['withdrawal_options_array'])) || $GLOBALS['use_bitcoin'] === true && ($GLOBALS['member_payment'] === true || $_SESSION['loggedin'] == $GLOBALS['administrator'])) {
	?>
			<div class="panel panel-primary panel-master">
				<a href="#bitcoin" data-toggle="collapse" style="text-decoration:none;">
					<div class="panel-heading text-left">
                          <h4><sub><small><small><div class="fa fa-bitcoin fa-3x" style="color:#697f9c" aria-hidden="true"></div></small></small></sub>
						  My Bitcoin Information</h4>
					</div>
				</a>
				<div id="bitcoin" class="panel-body <?php echo $collapse; ?>">	
	
	
	
<div class="col-md-3 form-inline text-right"></div><div class="col-md-6 form-inline text-right">
<?php echo "Bitcoin Address:

		<input class=\"form-control\" size=\"30%\" maxlength=\"100\" name=\"bitcoin\" value=\"".((!empty($_POST['bitcoin']))?$_POST['bitcoin']:'')."\"> 

<a href='javascript:alert(\"Enter your bitcoin address where you want to receive your payments.\");'><img src=\"../images/questionmark.gif\" border=\"0\"></a>";

//echo "<a href=\"https://www.coinbase.com/join/0000\" target=\"_blank\">Free Coinbase Account</a>";

echo "<a href=\"https://bitpay.com/wallet\" target=\"_blank\">Free Bitpay Account</a>";
echo "</div><div class='col-md-3 form-inline text-right'></div>";
echo "</div></div>";
} // END BITCOIN

// Cash App
if (($GLOBALS['show_withdrawal_options'] && in_array("cashapp", $GLOBALS['withdrawal_options_array']))) {
	?>
			<div class="panel panel-primary panel-master">
				<a href="#cashapp" data-toggle="collapse" style="text-decoration:none;">
					<div class="panel-heading text-left">
                          <h4><sub><small><small><div class="fa fa-money fa-3x" style="color:#697f9c" aria-hidden="true"></div></small></small></sub>
						  My CashApp</h4>
					</div>
				</a>
				<div id="cashapp" class="panel-body <?php echo $collapse; ?>">	
	
	
	
<div class="col-md-3 form-inline text-right"></div><div class="col-md-6 form-inline text-right">
<?php echo "CashApp Cashtag:

		<input class=\"form-control\" size=\"30%\" maxlength=\"100\" name=\"paymentprocessor5\" value=\"".((!empty($_POST['paymentprocessor5']))?$_POST['paymentprocessor5']:'')."\"> 

<a href='javascript:alert(\"Enter your CashApp cashtag where you want to receive your payments.\");'><img src=\"../images/questionmark.gif\" border=\"0\"></a>";

echo "<a href=\"https://cash.app\" target=\"_blank\">Free CashApp Account</a>";
echo "</div><div class='col-md-3 form-inline text-right'></div>";
echo "</div></div>";
} // END CashApp

// DWOLLA
if ($GLOBALS['use_dwolla'] === true && ($GLOBALS['member_payment'] === true || $_SESSION['loggedin'] == $GLOBALS['administrator'])) {
	echo "<h2>Dwolla:</h2>
		Dwolla ID (10 digit number with hyphens. Example 812-000-0000):

		<input class=\"form-control\" size=\"25\" name=\"dwolla_id\" value=\"".((!empty($_POST['dwolla_id']))?$_POST['dwolla_id']:'')."\">
<a href=\"{$GLOBALS['dwolla_affiliate_link']}\" target=\"_blank\">Free Dwolla Account</a>";

/* TEMPORARILY REMOVE THIS WHILE USING DWOLLA HUB
						echo "Dwolla PIN:

				<input class=\"form-control\" size=\"25\" name=\"dwolla_pin\" value=\"".((!empty($_POST['dwolla_pin']))?$_POST['dwolla_pin']:'')."\">";

	if ($_POST['dwolla_oauth_token'] == '') {
		echo "Dwolla Oauth Token:
				<a href=\"#\"> Click Here To Authorize Access To Your Dwolla Account</a>";
	} else {
		echo '<span style=\"color:green\">Your Dwolla Account Is Authorized. Your token is '.$_POST['dwolla_oauth_token'].'</span>';
	}
*/	
}

// END DWOLLA

// BANK INFO
if (($GLOBALS['show_withdrawal_options'] && in_array("bank", $GLOBALS['withdrawal_options_array']))) {
	?>
			<div class="panel panel-primary panel-master">
				<a href="#bank" data-toggle="collapse" style="text-decoration:none;">
					<div class="panel-heading text-left">
                          <h4><sub><small><small><div class="fa fa-bank fa-3x" style="color:#697f9c" aria-hidden="true"></div></small></small></sub>
						  My Bank Information <!--(U.S. Members Only)--></h4>
					</div>
				</a>
				<div id="bank" class="panel-body <?php echo $collapse; ?>">	
	
	
	
<div class="col-md-3 form-inline text-right"></div><div class="col-md-6 form-inline text-right">
<?php echo "My Bank Account Number:

		<input type=\"password\" class=\"form-control\" size=\"30%\" maxlength=\"50\" id=\"bank_account\" name=\"bank_account\" value=\"".((!empty($_POST['bank_account']))?$_POST['bank_account']:'')."\">";
		
echo "<br/>My Bank Routing Number:

		<input type=\"password\" class=\"form-control\" size=\"30%\" maxlength=\"50\" id=\"bank_routing\" name=\"bank_routing\" value=\"".((!empty($_POST['bank_routing']))?$_POST['bank_routing']:'')."\">";		
		
echo "<br/><br/>*Requires your Tax ID (SS#) / Address Information are listed above.";		
		

echo "<br/><br/>Banking details are encrypted in our database, for your protection.";
?>
		<div class="input-group-append">
			<span class="input-group-text">
				<input type="checkbox" id="showPasswordCheckbox"/>&nbsp; <a href="#" id="showPasswordLink">Show</a>
			</span>
		</div>
<?php	
echo "</div><div class='col-md-3 form-inline text-right'></div>";
echo "</div></div>";
} // END 

///////////////////////////////////////////////////////////////////////////


/////// BEGIN WITHDRAWAL OPTIONS!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


///////////////////////////////////////////////////////////////////////////

if ($GLOBALS['show_withdrawal_options'] == true) {

	// ALLOW MEMBER TO ENTER DEBIT CARD INFO, ONLY IF THEY PAID FOR THEIR CARD!!
	if ($_POST['paid_for_card'] == 'Y' && $use_debit_card === true) { 
	?>
	<div class="col-md-12 form-inline text-center">
	<hr>
		<button type="button" class="btn btn-primary btn-lg">
				 <i class="icon-money" style="color:#697f9c"></i> My Debit Card
				</button><p>&nbsp</p>	
	<div class="col-md-3 form-inline text-right"></div><div class="col-md-6 form-inline text-left">
	Last 4 Digits of Your Debit Card:<input class="form-control" size="30%" name="debitcard" value="<?php echo ((!empty($_POST['debitcard']))?$_POST['debitcard']:'');?>" maxlength="4">
	<a href='javascript:alert("Enter only the last 4 digits of your debit card!");'><img src="../images/questionmark.gif" border="0"></a>
	<br /><br />
	</div><div class='col-md-3 form-inline text-right'></div></div>
	<?php
	} // END DEBIT CARD

/*
	if ($GLOBALS['require_ipayout_wallet'] === true) {
		include './ipayout.inc.php';
		if ($GLOBALS['ipayout_wallet_testmode'] === true) $ipayout_balance = get_ipayout_balance($_SESSION['loggedin'],$GLOBALS['ipayout_merchantGUID'],$GLOBALS['ipayout_MerchantPassword_test'],$GLOBALS['ipayout_MerchantURL_test']);
		else $ipayout_balance = get_ipayout_balance($_SESSION['loggedin'],$GLOBALS['ipayout_merchantGUID'],$GLOBALS['ipayout_MerchantPassword'],$GLOBALS['ipayout_MerchantURL']);

		echo '<h2>'.$GLOBALS['ipayout_wallet_name'].' Information:</h2>';

		if ($ipayout_balance != -500) echo 'Your '.$GLOBALS['ipayout_wallet_name'].':
		<br />Access Your eWallet Here: <a href="'.$GLOBALS['ipayout_wallet_url'].'" target="_blank">'.$GLOBALS['ipayout_wallet_url'].'</a><br />
		Your eWallet Username: <strong>'.$_SESSION['loggedin'].'</strong><br />
		Your eWallet Password: <strong>'.((!empty($_POST['password']))?$_POST['password']:'').'</strong> (unless you changed it on the eWallet site)<br />
		Your eWallet Balance:  <strong>$'.number_format($ipayout_balance,2).' USD</strong><br /><br /><br />';

		else echo ' '.(($_SESSION["ipayoutERROR"] != "") ? '<span style="color:red;"><strong>'.$_SESSION["ipayoutERROR"].' Contact the Administrator</strong></span><br/>':'NOTE: If you are not using your own <b><span style="color:green">First Data Global Gateway E4 Merchant Account (RECOMMENDED for direct sales to you!)</span></b> to receive payments, then you need our '.$GLOBALS['ipayout_wallet_name'].' to receive payments. <a href="ipayoutregister.php">Click here to register for your '.$GLOBALS['ipayout_wallet_name'].'</a>.').'<br /><br />';
		$_SESSION["ipayoutERROR"] = "";
	} // END i-payout.com eWallet*/
	?>
	<p>&nbsp;</p>
	<div class="col-md-12 form-inline text-center">

	<!-- QQQ KLUDGE
	<h4><span style="color:#ff0000">NOTE:</span> The Withdrawal section applies to paying out second tier commissions ONLY.</h4>
	<br/>
	-->

	<button type="button" class="btn btn-primary btn-lg">
	 <i class="icon-wallet" style="color:#fff"></i>&nbsp; Withdrawal Method (How I Am Paid)
	</button><p>&nbsp;</p>	

	<select name="payout_method" id="payout_method" class="form-control" onChange="show_stp()">
	
	<?php if ($_POST['payout_method'] == '') { ?>
		<option value="card" <?php if ($_POST['payout_method'] == '') echo "selected"; ?>>Please Choose An Option</option>
	<?php } ?>

	<?php if (in_array('check', $GLOBALS['withdrawal_options_array'])) { ?>
	<option value="check" <?php if ($_POST['payout_method'] == 'check') echo "selected"; ?>>By Company Check To Name / Address In My Profile</option>
	<?php } ?>
	
	<?php if (in_array('bank', $GLOBALS['withdrawal_options_array'])) { ?>
	<option value="bank" <?php if ($_POST['payout_method'] == 'bank') echo "selected"; ?>>My Bank Account</option>
	<?php } ?>	

	<?php if ($_POST['country'] == 'US' && $_POST['debitcard'] != '') { ?>
	<?php if (in_array('debitcard', $GLOBALS['withdrawal_options_array'])) { ?>
		<option value="card" <?php if ($_POST['payout_method'] == 'card') echo "selected"; ?>><?php echo $GLOBALS['webpage_name']; ?> Debit Card</option>
	<?php } ?>
	<?php } ?>
	
	
	<?php if (in_array('cashapp', $GLOBALS['withdrawal_options_array'])) { ?>
		<option value="cashapp"	<?php if ($_POST['payout_method'] == 'cashapp') echo "selected"; ?>>Cash App</option>
	<?php } ?>
	
	<?php if (in_array('zelle', $GLOBALS['withdrawal_options_array'])) { ?>
		<option value="zelle" <?php if ($_POST['payout_method'] == 'zelle') echo "selected"; ?>>Zelle</option>
	<?php } ?>	
	

	<!-- THIS OPTION NEEDS TO BE "PAYPAL", NOT "PAYPALACCOUNT" LIKE OTHER FIELDS IN THIS PAGE!! -->
	<?php if (in_array('paypal', $GLOBALS['withdrawal_options_array'])) { ?>
	<option value="paypal" <?php if ($_POST['payout_method'] == 'paypal') echo "selected"; ?>>PayPal</option>
	<?php } ?>

	<?php if (in_array('stripe', $GLOBALS['withdrawal_options_array'])) { ?>
	<option value="stripe" <?php if ($_POST['payout_method'] == 'stripe') echo "selected"; ?>>Stripe</option>	
	<?php } ?>
			
	<?php if (in_array('bitcoin', $GLOBALS['withdrawal_options_array'])) { ?>	
	<option value="bitcoin" <?php if ($_POST['payout_method'] == 'bitcoin') echo "selected"; ?>>Bitcoin</option>
	<?php } ?>
	</select>

	<script language="JavaScript" type="text/javascript">
	function show_stp() {
		var selectp = document.getElementById("payout_method").value;	
		if (selectp == 'stp') {
			$("#stp2").css("display", "block");
		} else {
			$("#stp2").css("display", "none");
		}
		return false;
	}
	</script>		
		
	<?php

	echo "</div>";


} // END WITHDRAWAL OPTIONS


// NEEDS PHP CODE UPDATE, BUT NOT IN USE!
if (false && in_array($_SESSION['p4_status'],array('Active','Suspended','Comped'))) {
	echo '<h2>Featured Products/Business Centers:</h2>
		<em>Choose which Product/Business Centers you\'d like <b>new</b> members to see upon registration. You must check at least one.&nbsp;&nbsp;</em><br/><br/>';
	$programs_offered_sql = "SELECT programs_offered FROM members WHERE Username='".$_SESSION['loggedin']."'";
	$programs_offered_res = mysql_query($programs_offered_sql);
	$programs_offered = array(); 
	if ($programs_offered_res !== false) {
		$programs_offered_buffer = mysql_fetch_row($programs_offered_res);
		if ($programs_offered_buffer[0] != "") {
			$programs_offered = explode(',', $programs_offered_buffer[0]);
		} 
	}
	$program_list_sql = "SELECT * FROM program WHERE program_approved='Y' AND program_up_pay>0 ORDER BY program_sort_order";
	$program_list_res = mysql_query($program_list_sql);
	while ($buffer_program_list = mysql_fetch_assoc($program_list_res)) {
		if (empty($programs_offered) || in_array($buffer_program_list['program_id'],$programs_offered)) {
			$program_checked = "checked";
		} else {
			$program_checked = "";
		}
		echo '<input type="checkbox" name="programs_offered_chk['.$buffer_program_list['program_id'].']" '.$program_checked.' value="'.$buffer_program_list['program_id'].'"><label>&nbsp;'.$buffer_program_list['program_name'].'</label><br />';
	}

}
?>

<div style="text-align:center"><p>&nbsp;</p><input class="btn btn-success" type="submit" value="Update My Profile" name="submit">
<p>&nbsp;</p><h5><span style="color:#ff0000">NOTE:</span> You must click the "Update My Profile" button (above) for changes to take effect!</span></h5><p>&nbsp;</p>
</div>

</form></div>

<script>
    const showPasswordLink = document.getElementById('showPasswordLink');
    const showPasswordCheckbox = document.getElementById('showPasswordCheckbox');
    
    showPasswordLink.addEventListener('click', function(event) {
        event.preventDefault(); // Prevent anchor from navigating
        
        showPasswordCheckbox.checked = !showPasswordCheckbox.checked; // Toggle checkbox
        updateFieldsVisibility();
    });
    
    showPasswordCheckbox.addEventListener('change', function() {
        updateFieldsVisibility();
    });
    
    function updateFieldsVisibility() {
        const bankField = document.getElementById('bank_account');
        const bankRoutingField = document.getElementById('bank_routing');
        
        if (showPasswordCheckbox.checked) {
            bankField.type = 'text'; // Show bank field
            bankRoutingField.type = 'text'; // Show bank routing field
        } else {
            bankField.type = 'password'; // Hide bank field
            bankRoutingField.type = 'password'; // Hide bank routing field
        }
    }
</script>

<?php
include 'footer.php';
}
?>