<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include 'logincheck.php';
$pageName = 'Check Your Sponsor';
$pageDesc = '';
$pageIcon = 'icon-user';
$pageAlign = 'center';
$pageClass = '';

include '../Sub/tpl/header_tpl.php';

if ($_SESSION['RefSponsorID'] == '') {
    // Sanitize the logged-in username
    $loggedInUsername = sanitize($_SESSION['loggedin'], 'loggedin');

    // Fetch the member's information
    $memberInfo = select('*', 'members', [], ['Username' => ['=', $loggedInUsername]]);
    
    // If there's an existing buffer, unset it
    if (isset($buffer)) {
        unset($buffer);
    }

    // Assuming select returns an array of results, get the first one
    $buffer = $memberInfo[0];

    // Fetch sponsor's information
    $sponsorUsername = sanitize($buffer['sponsorid'], 'sponsorid');
    $sponsorInfo = select('*', 'members', [], ['Username' => ['=', $sponsorUsername]]);

    // Assuming select returns an array of results, get the first one
    $spnsinfo = $sponsorInfo[0];

    // Update session variables
    $_SESSION['RefFirstname'] = $spnsinfo['First_Name'];
    $_SESSION['RefLastname'] = $spnsinfo['Last_Name'];
    $_SESSION['RefSponsorID'] = $spnsinfo['Username'];
}
	
$selectFields = 'giveaway_file';
$mainTable = ['table' => 'program', 'as' => 'p'];
$where = [
    'AND' => [
        ['p.program_id' => ['=', 1]]
    ]
];
$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
$buffer = isset($result[0]) ? $result[0] : '';

if ($buffer['giveaway_file'] == 'Mat.give.php') $program_is_matrix = true;
else $program_is_matrix = false;	

echo '<div class="alert alert-warning" role="alert"><h1 style="color:red">STOP and double check your sponsor BEFORE you pay!</h1>';	
if ($program_is_matrix == true) echo '<h2 style="color:red">We cannot change your placement once you are in the matrix!</h2>';
echo '</div>';

echo '<div class="alert alert-info" role="alert"><h2>Your referring sponsor is: 
'.$_SESSION['RefFirstname'].' '.$_SESSION['RefLastname'].' username: ('.$_SESSION['RefSponsorID'].').</h2></div>';

echo '<h3><u>If this is NOT who referred you, then STOP now, and contact support.</u><br><br>
<a href="'.$GLOBALS['webpage_url_ssl'].'contact.php" class="btn btn-warning" target="_self">Contact Support To Change Your Sponsor</a></h3><br>';

echo '<h3>If this IS who referred you, then please continue below<br><br> 
<a href="'.$GLOBALS['webpage_url_ssl'].'apay/purchase_agreement.php" class="btn btn-success" target="_self">Click Here To Make Payment</a></h3><br>';			


include '../Sub/tpl/footer_tpl.php';
?>