<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './../Sub/Config.inc.php';

$Global['viewdownline_good_status'] = array('Active','Comped','TempComp','Suspended','FreeTrial');
$viewdownline_good_status_list = "'Active','Comped','TempComp','Suspended','FreeTrial'";

session_start();

if (empty($_SESSION['loggedin'])) {
	header("Location: ../login.php");
	exit;
	}


//Select the correct program
if (!empty($_GET['program'])) {
	$temp = explode('-', $_GET['program']);
	$Global['program'] = intval($temp[(count($temp) - 1)]);
	$Global['member_status'] = $temp[0];
	}
elseif (!empty($_SESSION['program']) && !empty($_SESSION['member_status']) && intval($_SESSION['program']) > 0) {
	$Global['program'] = intval($_SESSION['program']);
	$Global['member_status'] = $_SESSION['member_status'];
	}
elseif (!empty($_SESSION['program']) && intval($_SESSION['program']) > 0) {
	$Global['program'] = intval($_SESSION['program']);
	$Global['member_status'] = 'A';
	}
else {
	$Global['program'] = $Global['default_program'];
	$Global['member_status'] = 'A';
	}

if ($Global['member_status'] != 'A' && $Global['member_status'] != 'U') $Global['member_status'] = 'A';

$_SESSION['program'] = $Global['program'];
$_SESSION['member_status'] = $Global['member_status'];

//make sure they have a program they want to view
if (!isset($Global['program']) || intval($Global['program']) < 1) {
	header("Location: ./programview.php");
	exit;
	}

//Get the program info
$result = mysql_query("SELECT * FROM program WHERE program_id={$Global['program']} && program_approved='Y'");

$buffer = mysql_fetch_assoc($result);

//if the program does not exist, send the user back
if (empty($buffer['program_id'])) {
	header("Location: ./programview.php");
	exit;
	}

$Global['program_name'] = $buffer['program_name'];
$Global['up_powerline'] = $buffer['program_up'];
$powerline_order_comma_sep = $buffer['program_up_order'];
$Global['powerline_order'] = explode(',', $buffer['program_up_order']);
$Global['require_pass_ups_to_admin'] = $buffer['require_pass_ups_to_admin'];
$Global['pass_ups_to_admin'] = explode(',', $buffer['pass_ups_to_admin']);
$Global['tier_level'] = $buffer['program_tier'];
$Global['pass_up_every_nth'] = $buffer['pass_up_every_nth'];

if (empty($Global['powerline_order'][0])) $Global['powerline_order'][0] = 0;

$Global['header'] = $buffer['header_file'];
$Global['footer'] = $buffer['footer_file'];

include './../Sub/tpl/'.$Global['header'];

//Find out if you have an active subscription to this program
$result = mysql_query("SELECT prog.user_status, prog.user_qualify, prog.user_qualify_perm FROM user_program as prog LEFT JOIN members as memb USING (ID) WHERE memb.Username='".mysql_real_escape_string($_SESSION['loggedin'])."' && prog.program_id={$Global['program']}");

$buffer = mysql_fetch_assoc($result);

if (in_array($buffer['user_status'], $Global['viewdownline_good_status'])) $program_active = true;
else $program_active = false;

if ($Global['up_powerline'] > 0) {
	$verify_qualify_qry = "SELECT sign_id FROM user_program WHERE sponsorid='".mysql_real_escape_string($_SESSION['loggedin'])."' && user_status NOT IN ('Cancelled','Unpaid') && program_id='{$Global['program']}'  && sign_id IN (".mysql_real_escape_string($powerline_order_comma_sep).")";
if ($_SESSION['debug']) echo "<br />*******************".$verify_qualify_qry."<br />";
	$verify_qualify_result = mysql_query($verify_qualify_qry);

	$member_qualify = min($Global['up_powerline'],mysql_num_rows($verify_qualify_result) + max(0,$buffer['user_qualify_perm']));
} else {
	$member_qualify = 0;
}


echo '<center><h2>'.$Global['program_name'].' Team (FULL Genealogy)</h2></center>';
//echo '<p> <center><a href="'.$Global['webpage_url_ssl'].'Members/emaildownline.php">Email Downline</a></center>';

//Select all programs
$result = mysql_query("SELECT * FROM program WHERE program_approved='Y' ORDER BY program_name");

$program_info = '<option value="0">Select a program</option>';

while ($buffer = mysql_fetch_assoc($result))
	{
	if (!empty($Global['program']) && $Global['program'] == $buffer['program_id']) $selected = ' selected';
	else $selected = '';

	$program_info .= '<option value="A-'.$buffer['program_id'].'"'.((!empty($selected) && $Global['member_status'] == 'A')?$selected:'').'>'.$buffer['program_name'].' (Active Members)</option>';
	$program_info .= '<option value="U-'.$buffer['program_id'].'"'.((!empty($selected) && $Global['member_status'] == 'U')?$selected:'').'>'.$buffer['program_name'].' (Unpaid Members)</option>';

//xxx JS adding comped member view

	//$program_info .= '<option value="C-'.$buffer['program_id'].'"'.((!empty($selected) && $Global['member_status'] == 'C')?$selected:'').'>'.$buffer['program_name'].' (Comped Members)</option>';
	}

echo <<<EOD
<a NAME="downline"></a>
<table align="center" bgcolor="#FFFFFF"><tr><td>
<form enctype="multipart/form-data" method="get" action="viewdownline_full.php">
Program:<br />
<select name="program">
{$program_info}
</select>
<input type="submit" value="View Program" name="submit">
</form>
EOD;

//display active downline
if ($Global['member_status'] == 'A') {

//find the members highest program
//ACTIVE MEMBERS ONLY $result = mysql_query("SELECT prog.active_in FROM members as memb LEFT JOIN user_program as prog USING (ID) WHERE memb.Username='".mysql_real_escape_string($_SESSION['loggedin'])."' LIMIT 1") or die(mysql_error());

$result = mysql_query("SELECT ID FROM members as memb LEFT JOIN user_program as prog USING (ID) WHERE memb.Username='".mysql_real_escape_string($_SESSION['loggedin'])."' AND prog.user_status IN (".$viewdownline_good_status_list.") LIMIT 1") or die(mysql_error());

$buffer = mysql_fetch_assoc($result);

//$Global['program_highest_id'] = explode(',', $buffer['active_in']);

$limit = '';

//if (!in_array($Global['program'], $Global['program_highest_id'])) $limit = " && prog.user_status='{$Global['active_status']}'";
//else $limit = null;

//Find your personal direct downline
$result = mysql_query("SELECT prog.*, memb.Username, memb.First_Name, memb.Last_Name, memb.email, UNIX_TIMESTAMP(memb.Signdate) as Signdate, info.phone, memb.sponsorid as memsponsorid FROM user_program as prog LEFT JOIN members as memb USING (ID) LEFT JOIN member_link as info USING (ID) WHERE prog.sponsorid='".mysql_real_escape_string($_SESSION['loggedin'])."' && prog.program_id={$Global['program']} && prog.sign_id>0{$limit} && memb.Username!='DELETED' && memb.Username!='".mysql_real_escape_string($_SESSION['loggedin'])."' && memb.Username!='' ORDER BY prog.sign_id");

//&& memb.dummy_qualify='N' ORDER BY prog.sign_id");

// added memb.sponsorid as memsponsorid

$downline = '';
$qualify = '';
$qualify_color = 1;
$normal_color = 1;

$tier_usernames = array();

while ($buffer = mysql_fetch_assoc($result))
	{
// added $buffer['memsponsorid'] == $_SESSION['loggedin'] || to line below
// also make sure username array DOES NOT contain usernames sponsored by the logged in user
// removed condition "|| $_SESSION['loggedin']=$buffer['sponsorid'] since that is already a condition of query
// so $username[1] should be only a list of direct usernames who are sponsored by $_SESSION['loggedin'] AND are NOT passed up 
	if (!in_array($buffer['sign_id'], $Global['powerline_order']) && $Global['up_powerline'] > 0 || $Global['up_powerline']==0 || ((!in_array($buffer['sign_id'], $Global['pass_ups_to_admin']) && $_SESSION['loggedin']!='admin' || (in_array($buffer['sign_id'], $Global['pass_ups_to_admin']) && $_SESSION['loggedin']=='admin' )) && $Global['require_pass_ups_to_admin']=='Y')) {
		if ($_SESSION['loggedin']=='admin' || $Global['pass_up_every_nth'] > 0 && ($buffer['sign_id'] <= max($Global['powerline_order']) || (($buffer['sign_id'] - max($Global['powerline_order'])) % $Global['pass_up_every_nth']) != 0) || $Global['pass_up_every_nth'] == 0) {
			$username[1][] = "'".mysql_real_escape_string($buffer['Username'])."'";
			if ($_SESSION['debug']) echo $buffer['Username']."added to username array<br/>";
		}
	}

	if ($buffer['sign_id'] > 0) {
		$tier_usernames[1][] = "'".mysql_real_escape_string($buffer['Username'])."'";
		$name = $buffer['First_Name'].' '.$buffer['Last_Name'];

		$test_date = ((!empty($buffer['Signdate']))?date('F, jS Y', $buffer['Signdate']):'N/A');
		$signup_date = date('F, jS Y', $buffer['started']);

		if ($program_active === true) {
			$email = $buffer['email'];
			$phone = (!empty($buffer['phone']))?$buffer['phone']:'N/A';
			}
		else {
			$email = 'Restricted (Only Available To Members)';
			$phone = 'Restricted';
			}
			
				if ($_SESSION['admin_session_view'] == true) {
				$buffer['Username'] = '<a href="../admin/Sub/Finduser.php?username='.$buffer['Username'].'" target="_blank">'.$buffer['Username'].'</a>';	
				$buffer['sponsorid'] = '<a href="../admin/Sub/Finduser.php?username='.$buffer['sponsorid'].'" target="_blank">'.$buffer['sponsorid'].'</a>';
				}	

		if ($_SESSION['loggedin']!='admin' && (in_array($buffer['sign_id'], $Global['powerline_order']) || in_array($buffer['sign_id'], $Global['pass_ups_to_admin']) && $Global['require_pass_ups_to_admin'] != "N" || $Global['pass_up_every_nth'] > 0 && $buffer['sign_id'] > max($Global['powerline_order']) && (($buffer['sign_id'] - max($Global['powerline_order'])) % $Global['pass_up_every_nth']) == 0)) {
						if ($qualify_color % 2 == 0) $bg_color = 'F0F0F0';
			else $bg_color = 'FFF';

			++$qualify_color;


			$qualify .= <<<EOD
	<tr>
		<td rowspan="2" style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$buffer['sign_id']}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-left: 5px; padding-top: 2px; padding-bottom: 2px;">
			{$name}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$phone}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$test_date}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$buffer['Username']}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; border-right: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$buffer['user_status']}
		</td>
	</tr>
	<tr>
		<td colspan="2" style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$email}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$signup_date}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$buffer['sponsorid']}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; border-right: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			&nbsp;
		</td>
	</tr>
EOD;
			}
		else {
			if ($normal_color % 2 == 0) $bg_color = 'F0F0F0';
			else $bg_color = 'FFF';

			++$normal_color;



			$downline .= <<<EOD
	<tr>
		<td rowspan="2" style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$buffer['sign_id']}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-left: 5px; padding-top: 2px; padding-bottom: 2px;">
			{$name}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$phone}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$test_date}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$buffer['Username']}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; border-right: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$buffer['user_status']}
		</td>
	</tr>
	<tr>
		<td colspan="2" style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$email}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$signup_date}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$buffer['sponsorid']}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; border-right: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			&nbsp;
		</td>
	</tr>
EOD;
		}
	}
	}

if ($member_qualify >= $Global['up_powerline']) $qualify_text = '<span style="color: green;">You are fully qualified.</span>';
elseif ($member_qualify > 0)	$qualify_text = '<span style="color: #F00;">You need to pass up '.($Global['up_powerline'] - $member_qualify) .' more sale(s).</span>';
else $qualify_text = '<span style="color: #F00;">You need to pass up '.$Global['up_powerline'] .' sale(s).</span>';

if ($Global['pass_up_every_nth'] > 0) $qualify_text = ""; // DO NOT PRINT QUALIFY STATUS IF REQUIRE UNLIMITED PASSUPS
else if ($member_qualify < $Global['up_powerline']) $qualify_text .= " NOTE: Cancelled Passups Do Not Count Toward The Passup Requirement"; // ONLY SHOW IF PASS UP EVERY NTH IS 0 AND NOT QUALIFIED

if ($Global['up_powerline'] > 0) {
echo <<<EOD
<table cellspacing="0" cellpadding="0">
	<tr>
		<td colspan="6" style="background-color: #F0F0F0; border: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; padding-left: 5px;">QUALIFY PASSUPS - {$qualify_text}</td>
	</tr>
	<tr>
		<td rowspan="2" style="background-color: #F0F0F0; width: 50px; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			ID
		</td>
		<td style="background-color: #F0F0F0; width: 200px; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-left: 5px; padding-top: 2px; padding-bottom: 2px;">
			Name
		</td>
		<td style="background-color: #F0F0F0; width: 120px; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			Phone
		</td>
		<td style="background-color: #F0F0F0; width: 150px; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			Date Registered
		</td>
		<td style="background-color: #F0F0F0; width: 110px; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			Username
		</td>
		<td style="background-color: #F0F0F0; width: 70px; border-left: 1px solid #000; border-bottom: 1px solid #000; border-right: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			Status
		</td>
	</tr>
	<tr>
		<td colspan="2" style="background-color: #F0F0F0; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			Email
		</td>
		<td style="background-color: #F0F0F0; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			Date Activated
		</td>
		<td style="background-color: #F0F0F0; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			Sponsor
		</td>
		<td style="background-color: #F0F0F0; border-left: 1px solid #000; border-bottom: 1px solid #000; border-right: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			&nbsp;
		</td>
	</tr>
{$qualify}
</table>
EOD;
	}

echo <<<EOD
<br /><br />
<table cellspacing="0" cellpadding="0">
	<tr>
		<td colspan="6" style="background-color: #F0F0F0; border: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; padding-left: 5px;">DIRECT REFERRALS (TIER 1)</td>
	</tr>
	<tr>
		<td rowspan="2" style="background-color: #F0F0F0; width: 50px; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			ID
		</td>
		<td style="background-color: #F0F0F0; width: 200px; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-left: 5px; padding-top: 2px; padding-bottom: 2px;">
			Name
		</td>
		<td style="background-color: #F0F0F0; width: 120px; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			Phone
		</td>
		<td style="background-color: #F0F0F0; width: 150px; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			Date Registered
		</td>
		<td style="background-color: #F0F0F0; width: 110px; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			Username
		</td>
		<td style="background-color: #F0F0F0; width: 70px; border-left: 1px solid #000; border-bottom: 1px solid #000; border-right: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			Status
		</td>
	</tr>
	<tr>
		<td colspan="2" style="background-color: #F0F0F0; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			Email
		</td>
		<td style="background-color: #F0F0F0; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			Date Activated
		</td>
		<td style="background-color: #F0F0F0; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			Sponsor
		</td>
		<td style="background-color: #F0F0F0; border-left: 1px solid #000; border-bottom: 1px solid #000; border-right: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			&nbsp;
		</td>
	</tr>
{$downline}
EOD;

//Find your tiers...
if ($Global['display_downline_tiers'] === true && $Global['tier_level'] > 1) {
	$nr = 1;
	$nr2 = 2;
	$stop = false;
	$tier_levels = 0;
	$tier_data = '';

	while ($stop != true)
		{
		if (empty($tier_usernames[$nr]) || $Global['tier_level'] <= $nr) break;
		++$tier_levels;

		$total = count($tier_usernames[$nr]) - 1;

		$show_heading = true;
		$normal_color = 1;

		$result = mysql_query("SELECT
														prog.*
														, memb.Username
														, memb.First_Name
														, memb.Last_Name
														, memb.email
														, UNIX_TIMESTAMP(memb.Signdate) as Signdate
														, info.phone
													FROM
														user_program as prog
														LEFT JOIN members as memb
															USING (ID)
														LEFT JOIN member_link as info
															USING (ID)
													WHERE
														prog.sponsorid IN (".implode(',', $tier_usernames[$nr]).")
														&& prog.program_id={$Global['program']}
														&& prog.sign_id>0
														{$limit}
														&& memb.Username!='DELETED'
														&& memb.Username!=''
													ORDER BY
														prog.started ASC
														, prog.sponsorid ASC") or die (mysql_error());

			while ($buffer = mysql_fetch_assoc($result))
				{
					$tier_usernames[$nr2][] = "'".mysql_real_escape_string($buffer['Username'])."'";

					$name = $buffer['First_Name'].' '.$buffer['Last_Name'];

					$test_date = ((!empty($buffer['Signdate']))?date('F, jS Y', $buffer['Signdate']):'N/A');
					$signup_date = date('F, jS Y', $buffer['started']);

					if ($program_active === true) {
						$email = $buffer['email'];
						$phone = (!empty($buffer['phone']))?$buffer['phone']:'N/A';
						}
					else {
						$email = 'Restricted (Only Available To Members)';
						$phone = 'Restricted';
						}
				if ($_SESSION['admin_session_view'] == true) {
				$buffer['Username'] = '<a href="../admin/Sub/Finduser.php?username='.$buffer['Username'].'" target="_blank">'.$buffer['Username'].'</a>';	
				$buffer['sponsorid'] = '<a href="../admin/Sub/Finduser.php?username='.$buffer['sponsorid'].'" target="_blank">'.$buffer['sponsorid'].'</a>';
				}	
					if ($show_heading == true) {
						$tier_data .= <<<EOD
</table>
<br /><br />
	<table cellspacing="0" cellpadding="0">
		<tr>
			<td colspan="6" style="background-color: #F0F0F0; border: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; padding-left: 5px;">LEVEL {$nr2} REFERRALS (TIER {$nr2})</td>
		</tr>
		<tr>
			<td rowspan="2" style="background-color: #F0F0F0; width: 50px; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
				ID
			</td>
			<td style="background-color: #F0F0F0; width: 200px; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-left: 5px; padding-top: 2px; padding-bottom: 2px;">
				Name
			</td>
			<td style="background-color: #F0F0F0; width: 120px; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
				Phone
			</td>
			<td style="background-color: #F0F0F0; width: 150px; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
				Date Registered
			</td>
			<td style="background-color: #F0F0F0; width: 110px; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
				Username
			</td>
			<td style="background-color: #F0F0F0; width: 70px; border-left: 1px solid #000; border-bottom: 1px solid #000; border-right: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
				Status
			</td>
		</tr>
		<tr>
			<td colspan="2" style="background-color: #F0F0F0; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
				Email
			</td>
			<td style="background-color: #F0F0F0; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
				Date Activated
			</td>
			<td style="background-color: #F0F0F0; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
				Sponsor
			</td>
			<td style="background-color: #F0F0F0; border-left: 1px solid #000; border-bottom: 1px solid #000; border-right: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
				&nbsp;
			</td>
		</tr>
EOD;
					$show_heading = false;
					}

					if ($normal_color % 2 == 0) $bg_color = 'F0F0F0';
					else $bg_color = 'FFF';

					++$normal_color;

					$tier_data .= <<<EOD
		<tr>
			<td rowspan="2" style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
				{$buffer['sign_id']}
			</td>
			<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-left: 5px; padding-top: 2px; padding-bottom: 2px;">
				{$name}
			</td>
			<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
				{$phone}
			</td>
			<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
				{$test_date}
			</td>
			<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
				{$buffer['Username']}
			</td>
			<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; border-right: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
				{$buffer['user_status']}
			</td>
		</tr>
		<tr>
			<td colspan="2" style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
				{$email}
			</td>
			<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
				{$signup_date}
			</td>
			<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
				{$buffer['sponsorid']}
			</td>
			<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; border-right: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
				&nbsp;
			</td>
		</tr>
EOD;
			}

		++$nr;
		++$nr2;
		}

	if ($tier_levels > 0) {
		echo $tier_data;
		}
	}

//Find your powerlines...
$nr = 1;
$nr2 = 2;
$stop = false;

while ($stop != true)
	{
	if (empty($username[$nr])) break;
if ($_SESSION['debug'] == true) {
	echo "USERNAME ARRAY LEVEL $nr2:<br/>";
	print_r($username[$nr]);
	echo "<br/>";
}
		
	$total = count($username[$nr]) - 1;

	$show_heading = true;
	$normal_color = 1;

// QQQQQQ
	$old_limit = $limit; // save old limit, if any
	$limit = "";
	if ($Global['require_pass_ups_to_admin'] == "Y") { // if admin gets required passups
		$limit = " && prog.sign_id NOT IN (".implode(',', $Global['pass_ups_to_admin']).") "; // don't display entries with sign_ids that are required to be passed up to admin
	}
	$max_passup_order_number = max($Global['powerline_order']) + 0;
	if ($Global['pass_up_every_nth'] > 0) {
		$signid_limit_clause = " && (prog.sign_id > {$max_passup_order_number} && ((prog.sign_id - {$max_passup_order_number}) % {$Global['pass_up_every_nth']}) = 0 || prog.sign_id IN (".implode(',', $Global['powerline_order']).")) ";
	} else { 
		//$signid_limit_clause = " && prog.sign_id<=".(int)(($Global['up_powerline'] > 0)?$Global['powerline_order'][((($Global['up_powerline'] > 0)?($Global['up_powerline'] - 1):0))]:0);
		// ****************** QQQQQQQQQQQQQQQQQQQQQQQQ
		$signid_limit_clause = " && (prog.sign_id IN (".implode(',', $Global['powerline_order']).")) ";
	}
	$signid_limit_clause = ""; // **************** QQQ NWC KLUGE - IGNORE PASSUPS, SHOW ALL
	
if ($_SESSION['debug'] == true) {
echo "<br/>SELECT prog.*, memb.Username, memb.First_Name, memb.Last_Name, memb.email, UNIX_TIMESTAMP(memb.Signdate) as Signdate, info.phone  FROM user_program as prog LEFT JOIN members as memb USING (ID) LEFT JOIN member_link as info USING (ID) WHERE prog.sponsorid IN (".implode(',', $username[$nr]).") && prog.program_id={$Global['program']} && prog.sign_id>0 {$signid_limit_clause} {$limit} && memb.Username!='DELETED' && memb.Username!='' ORDER BY prog.started ASC, prog.sponsorid ASC<br/>";
}

	
	$result = mysql_query("SELECT prog.*, memb.Username, memb.First_Name, memb.Last_Name, memb.email, UNIX_TIMESTAMP(memb.Signdate) as Signdate, info.phone  FROM user_program as prog LEFT JOIN members as memb USING (ID) LEFT JOIN member_link as info USING (ID) WHERE prog.sponsorid IN (".implode(',', $username[$nr]).") && prog.program_id={$Global['program']} && prog.sign_id>0 {$signid_limit_clause} {$limit} && memb.Username!='DELETED' && memb.Username!='' ORDER BY prog.started ASC, prog.sponsorid ASC") or die (mysql_error());
	$limit = $old_limit; // restore old limit, if any
		while ($buffer = mysql_fetch_assoc($result))
			{
			if (true) { // 
				$username[$nr2][] = "'".mysql_real_escape_string($buffer['Username'])."'";

				$name = $buffer['First_Name'].' '.$buffer['Last_Name'];

				$test_date = ((!empty($buffer['Signdate']))?date('F, jS Y', $buffer['Signdate']):'N/A');
				$signup_date = date('F, jS Y', $buffer['started']);

				if ($program_active === true) {
					$email = $buffer['email'];
					$phone = (!empty($buffer['phone']))?$buffer['phone']:'N/A';
				} else {
					$email = 'Restricted (Only Available To Members)';
					$phone = 'Restricted';
				}

				if ($_SESSION['admin_session_view'] == true) {
				$buffer['Username'] = '<a href="../admin/Sub/Finduser.php?username='.$buffer['Username'].'" target="_blank">'.$buffer['Username'].'</a>';	
				$buffer['sponsorid'] = '<a href="../admin/Sub/Finduser.php?username='.$buffer['sponsorid'].'" target="_blank">'.$buffer['sponsorid'].'</a>';
				}	

				if ($show_heading == true) {
					echo <<<EOD
</table><br /><br />
<table cellspacing="0" cellpadding="0">
	<tr>
		<td colspan="6" style="background-color: #F0F0F0; border: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; padding-left: 5px;">LEVEL {$nr} INDIRECT REFERRALS</td>
	</tr>
	<tr>
		<td rowspan="2" style="background-color: #F0F0F0; width: 50px; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			ID
		</td>
		<td style="background-color: #F0F0F0; width: 200px; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-left: 5px; padding-top: 2px; padding-bottom: 2px;">
			Name
		</td>
		<td style="background-color: #F0F0F0; width: 120px; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			Phone
		</td>
		<td style="background-color: #F0F0F0; width: 150px; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			Date Registered
		</td>
		<td style="background-color: #F0F0F0; width: 110px; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			Username
		</td>
		<td style="background-color: #F0F0F0; width: 70px; border-left: 1px solid #000; border-bottom: 1px solid #000; border-right: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			Status
		</td>
	</tr>
	<tr>
		<td colspan="2" style="background-color: #F0F0F0; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			Email
		</td>
		<td style="background-color: #F0F0F0; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			Date Activated
		</td>
		<td style="background-color: #F0F0F0; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			Sponsor
		</td>
		<td style="background-color: #F0F0F0; border-left: 1px solid #000; border-bottom: 1px solid #000; border-right: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			&nbsp;
		</td>
	</tr>
EOD;
				$show_heading = false;
				}

				if ($normal_color % 2 == 0) $bg_color = 'F0F0F0';
				else $bg_color = 'FFF';

				++$normal_color;

				echo <<<EOD
	<tr>
		<td rowspan="2" style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$buffer['sign_id']}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-left: 5px; padding-top: 2px; padding-bottom: 2px;">
			{$name}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$phone}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$test_date}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$buffer['Username']}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; border-right: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$buffer['user_status']}
		</td>
	</tr>
	<tr>
		<td colspan="2" style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$email}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$signup_date}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$buffer['sponsorid']}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; border-right: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			&nbsp;
		</td>
	</tr>
EOD;
				}
		}

	++$nr;
	++$nr2;
	}
// Add section if user is admin and require_pass_ups_to_admin is true
if ($Global['require_pass_ups_to_admin'] == "Y" && $_SESSION['loggedin'] == "admin") { // if admin gets required passups
		//Find required admin passups


$show_heading = true;
$normal_color = 1;

if ($_SESSION['debug'] == true) {
echo "<br/>SELECT prog.*, memb.Username, memb.First_Name, memb.Last_Name, memb.email, UNIX_TIMESTAMP(memb.Signdate) as Signdate, info.phone  FROM user_program as prog LEFT JOIN members as memb USING (ID) LEFT JOIN member_link as info USING (ID) WHERE prog.sign_id IN (".implode(',', $Global['pass_ups_to_admin']).") && prog.sponsorid!='admin' && prog.program_id={$Global['program']} && memb.Username!='DELETED' && memb.Username!='' ORDER BY prog.started ASC, prog.sponsorid ASC<br/>";
}
	
	$result = mysql_query("SELECT prog.*, memb.Username, memb.First_Name, memb.Last_Name, memb.email, UNIX_TIMESTAMP(memb.Signdate) as Signdate, info.phone  FROM user_program as prog LEFT JOIN members as memb USING (ID) LEFT JOIN member_link as info USING (ID) WHERE prog.sign_id IN (".implode(',', $Global['pass_ups_to_admin']).") && prog.sponsorid!='admin' && prog.program_id={$Global['program']} && memb.Username!='DELETED' && memb.Username!='' ORDER BY prog.started ASC, prog.sponsorid ASC") or die (mysql_error());
	
		while ($buffer = mysql_fetch_assoc($result))
			{
			if (in_array($buffer['sign_id'], $Global['powerline_order'])) {
				$username[$nr2][] = "'".mysql_real_escape_string($buffer['Username'])."'";

				$name = $buffer['First_Name'].' '.$buffer['Last_Name'];

				$test_date = ((!empty($buffer['Signdate']))?date('F, jS Y', $buffer['Signdate']):'N/A');
				$signup_date = date('F, jS Y', $buffer['started']);

				if ($program_active === true) {
					$email = $buffer['email'];
					$phone = (!empty($buffer['phone']))?$buffer['phone']:'N/A';
				} else {
					$email = 'Restricted (Only Available To Members)';
					$phone = 'Restricted';
				}
				if ($_SESSION['admin_session_view'] == true) {
				$buffer['Username'] = '<a href="../admin/Sub/Finduser.php?username='.$buffer['Username'].'" target="_blank">'.$buffer['Username'].'</a>';	
				$buffer['sponsorid'] = '<a href="../admin/Sub/Finduser.php?username='.$buffer['sponsorid'].'" target="_blank">'.$buffer['sponsorid'].'</a>';
				}

				if ($show_heading == true) {
					echo <<<EOD
</table><br /><br />
<table cellspacing="0" cellpadding="0">
	<tr>
		<td colspan="6" style="background-color: #F0F0F0; border: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; padding-left: 5px;">POWERLINE SALES PASSED UP TO admin</td>
	</tr>
	<tr>
		<td rowspan="2" style="background-color: #F0F0F0; width: 50px; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			ID
		</td>
		<td style="background-color: #F0F0F0; width: 200px; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-left: 5px; padding-top: 2px; padding-bottom: 2px;">
			Name
		</td>
		<td style="background-color: #F0F0F0; width: 120px; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			Phone
		</td>
		<td style="background-color: #F0F0F0; width: 150px; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			Date Registered
		</td>
		<td style="background-color: #F0F0F0; width: 110px; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			Username
		</td>
		<td style="background-color: #F0F0F0; width: 70px; border-left: 1px solid #000; border-bottom: 1px solid #000; border-right: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			Status
		</td>
	</tr>
	<tr>
		<td colspan="2" style="background-color: #F0F0F0; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			Email
		</td>
		<td style="background-color: #F0F0F0; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			Date Activated
		</td>
		<td style="background-color: #F0F0F0; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			Sponsor
		</td>
		<td style="background-color: #F0F0F0; border-left: 1px solid #000; border-bottom: 1px solid #000; border-right: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			&nbsp;
		</td>
	</tr>
EOD;
				$show_heading = false;
				}

				if ($normal_color % 2 == 0) $bg_color = 'F0F0F0';
				else $bg_color = 'FFF';

				++$normal_color;

				echo <<<EOD
	<tr>
		<td rowspan="2" style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$buffer['sign_id']}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-left: 5px; padding-top: 2px; padding-bottom: 2px;">
			{$name}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$phone}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$test_date}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$buffer['Username']}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; border-right: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$buffer['user_status']}
		</td>
	</tr>
	<tr>
		<td colspan="2" style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$email}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$signup_date}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$buffer['sponsorid']}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; border-right: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			&nbsp;
		</td>
	</tr>
EOD;
				}
		}

	}
} //end display active downline
//start display unpaid downline
elseif ($Global['member_status'] == 'U') {
//Find your personal direct unpaid downline

echo <<<EOD

<table cellspacing="0" cellpadding="0">
	<tr>
		<td colspan="6" style="background-color: #F0F0F0; border: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; padding-left: 5px;">DIRECT UNPAID REFERRALS</td>
	</tr>
	<tr>
		<td rowspan="2" style="background-color: #F0F0F0; width: 50px; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			ID
		</td>
		<td style="background-color: #F0F0F0; width: 200px; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-left: 5px; padding-top: 2px; padding-bottom: 2px;">
			Name
		</td>
		<td style="background-color: #F0F0F0; width: 120px; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			Phone
		</td>
		<td style="background-color: #F0F0F0; width: 150px; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			Date Registered
		</td>
		<td style="background-color: #F0F0F0; width: 110px; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			Username
		</td>
		<td style="background-color: #F0F0F0; width: 70px; border-left: 1px solid #000; border-bottom: 1px solid #000; border-right: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			Status
		</td>
	</tr>
	<tr>
		<td colspan="2" style="background-color: #F0F0F0; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			Email
		</td>
		<td style="background-color: #F0F0F0; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			Date Activated
		</td>
		<td style="background-color: #F0F0F0; border-left: 1px solid #000; border-bottom: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			Sponsor
		</td>
		<td style="background-color: #F0F0F0; border-left: 1px solid #000; border-bottom: 1px solid #000; border-right: 1px solid #000; font-weight: bold; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			&nbsp;
		</td>
	</tr>
EOD;

$result = mysql_query("SELECT prog.*, memb.Username, memb.First_Name, memb.Last_Name, memb.email, UNIX_TIMESTAMP(memb.Signdate) as Signdate, info.phone FROM user_program as prog LEFT JOIN members as memb USING (ID) LEFT JOIN member_link as info USING (ID) WHERE prog.sponsorid='".mysql_real_escape_string($_SESSION['loggedin'])."' && prog.program_id={$Global['program']} && (prog.sign_id=0 || prog.user_status='{$Global['unpaid_status']}') && memb.Username!='DELETED' && memb.Username!='' ORDER BY memb.Signdate DESC");

$normal_color = 1;

while ($buffer = mysql_fetch_assoc($result))
	{
	$name = $buffer['First_Name'].' '.$buffer['Last_Name'];

	$test_date = ((!empty($buffer['Signdate']))?date('F, jS Y', $buffer['Signdate']):'N/A');
	$signup_date = 'N/A';

	if ($program_active === true) {
		$email = $buffer['email'];
		$phone = (!empty($buffer['phone']))?$buffer['phone']:'N/A';
		}
	else {
		$email = 'Restricted (Only Available To Members)';
		$phone = 'Restricted';
		}
		if ($_SESSION['admin_session_view'] == true) {
		$buffer['Username'] = '<a href="../admin/Sub/Finduser.php?username='.$buffer['Username'].'" target="_blank">'.$buffer['Username'].'</a>';	
		$buffer['sponsorid'] = '<a href="../admin/Sub/Finduser.php?username='.$buffer['sponsorid'].'" target="_blank">'.$buffer['sponsorid'].'</a>';
		}

	if ($normal_color % 2 == 0) $bg_color = 'F0F0F0';
	else $bg_color = 'FFF';

	++$normal_color;

	echo <<<EOD
	<tr>
		<td rowspan="2" style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$buffer['sign_id']}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-left: 5px; padding-top: 2px; padding-bottom: 2px;">
			{$name}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$phone}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$test_date}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$buffer['Username']}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; border-right: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$buffer['user_status']}
		</td>
	</tr>
	<tr>
		<td colspan="2" style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$email}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$signup_date}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			{$buffer['sponsorid']}
		</td>
		<td style="background-color: #{$bg_color}; border-left: 1px solid #000; border-bottom: 1px solid #000; border-right: 1px solid #000; padding-top: 2px; padding-bottom: 2px; text-align: center;">
			&nbsp;
		</td>
	</tr>
EOD;
	}
}

echo <<<EOD
</table>
<br /><br />
</table>
<br /><br />
EOD;

include './../Sub/tpl/'.$Global['footer'];
?>