<?php
/**
 * A simple procedural pagination script
 *
 * Example:
 * echo pagination_links(((empty($_GET['page']))?1:$_GET['page']), 10, 6, 'pagination.php?', array('page' => 'Page', 'first' => 'first', 'last' => 'last'));
 * 
 * @author Sven Arild Helleland - Kaizen Web-Productions (http://www.kaizen-web.com)
 * @version 1.0
 * @copyright Copyright(C), Kaizen Web-Productions, 2004-2008, All Rights Reserved.
 * 
 * @param integer $page			The current page number
 * @param integer $total		The total number of pages
 * @param integer $display	How many page links to display in addition to the current page
 * @param string $url				The url to the page including a ending ?
 * @param array $Language		An array containing the words used, array('page' => 'Page', 'first' => 'first', 'last' => 'last')
 * @return string|bool 			String containing the pagination if required else false
 */
function pagination_links($page, $total, $display, $url, $Language) {
	//Only display the pagination if more than one page
	if ($total > 0) {
		//If page number larger than total, change page number to total
		if ($page > $total) $page = $total;
		
		$pagination = null;
		$middle = ceil($display / 2);
		//Find the lowest page number to display
		$lower_end = $page - $middle;
		if ($lower_end < 1) $lower_end = 1;
	
		//Find the highest page number to display
		$high_end = $page + $middle;
		if ($page == 1 || ($page - $middle) < $lower_end) $high_end += 1 + ($middle - $page);
		
		if ($high_end > $total) {
			$high_end = $total;
		
			if ($lower_end > 1) {
				$lower_end -= ($page + $middle) - $high_end;
				
				if ($lower_end < 1) $lower_end = 1;
				}
			}
	
		//Create the pagination
		if ($total > $display) $pagination = $Language['page'].' ('.$page.'/'.$total.'): ';
		else $pagination = $Language['page'].' ('.$page.'/'.$total.'): ';
		if ($page == 1) $pagination .= '<strong>1</strong>';
		// JS TRYING TO STOP TEXT FROM SHOWING IN BOOTSTRAP
		$pagination = '';		
			
		if ($page > 1) {
			if ($total > $display) {
				$pagination .= '<li><a href="'.$url.'page=1" class="no-under">&lt;&lt; '.$Language['first'].'</a></li><li><a href="'.$url.'page='.($page - 1).'" class="no-under">&lt;</a></li> ';
				}
			for ($nr=$lower_end;$nr < $page;++$nr) {
				$pagination .= ' <li><a href="'.$url.'page='.$nr.'">'.$nr.'</a></li>';
				}
			}
		
		// JS TRYING TO STOP TEXT FROM SHOWING IN BOOTSTRAP
		//if ($page != 1 && $page != $total) $pagination .= ' <strong>'.$page.'</strong>';
		if ($page < $total) {
			for ($nr=$page+1;$nr <= $high_end;++$nr)
				{	
				$pagination .= ' <li><a href="'.$url.'page='.$nr.'">'.$nr.'</a></li>';
				}
			}
		if ($page == $total && $total > 1) {
			// JS TRYING TO STOP TEXT FROM SHOWING IN BOOTSTRAP
			//$pagination .= ' <strong>'.$page.'</strong>';
			}
		elseif ($total > $display) {
			$pagination .= ' <li><a href="'.$url.'page='.($page + 1).'" class="no-under">&gt;</a></li><li><a href="'.$url.'page='.$total.'" class="no-under">'.$Language['last'].' &gt;&gt;</a></li>';
			}	
			
		return $pagination;	
		}
	return false;
	}
?>