<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//----------------------------------------------------------------- 
// SAFETY NET INCASE THESE NEEDED INCLUDES ARE FORGOTTEN
if (!isset($_SESSION['loggedin']) || (!isset($logincheck_has_run) || $logincheck_has_run != true)) {
	include 'logincheck.php'; // Must have for input santization!!!!!
}

if (!isset($_SESSION['admin_login'])) $_SESSION['admin_login'] = false;
if (!isset($_SESSION['admin_session_choice'])) $_SESSION['admin_session_choice'] = false;
if (!isset($paychain)) $paychain = false;
//if (!isset($pageAlign)) $pageAlign = '';
if (!isset($has_noted_payments)) $has_noted_payments = false;
if (!isset($do_not_display_ads)) $do_not_display_ads = false;

if (!isset($pageDesc) || $pageDesc =='') {
	$pageDesc = '';
}
if (!isset($pageIcon) || $pageIcon =='') {
	$pageIcon = 'fa fa-reorder';
}
if (!isset($pageAlign) || $pageAlign =='') {
	$pageAlign = 'center';
}
if (!isset($pageClass) || $pageClass =='') {
	$pageClass = '';
}


if (!isset($_SESSION['Returning']) || $_SESSION['Returning'] == false) $pageClass = 'full'; // DO NOT SHOW MENU TO NEW USERS
// QQQ FOR TESTING DESIGN
//if ($_SESSION['loggedin'] == 'test') $pageClass = 'full'; // DO NOT SHOW MENU TO NEW USERS
////////////////////////////////

if (!isset($_SESSION['admin_session_view'])) $_SESSION['admin_session_view'] = false; 
if (!isset($_SESSION['debug'])) $_SESSION['debug'] = false;
if (!isset($bypass_painting_page)) $bypass_painting_page = false;

// BYPASSING DEBUG STATEMENTS FOR THIS FILE, SO REDIRECTS CAN HAPPEN AS NEEDED, AFTER THIS INCLUDE FILE
$turn_on_debug = false;
if (isset($_SESSION['debug']) && $_SESSION['debug'] == true && $bypass_painting_page == true) {
	$_SESSION['debug'] = false;
	$turn_on_debug = true;
}

//error_reporting(-1);
/*
echo 'status check: '.$_SESSION['a'.$_SESSION['UserID']]['status_check'].'<br/>';
echo 'session userid: '.$_SESSION['UserID'].'<br/>';
echo '<pre>';
print_r($_SESSION['a'.$_SESSION['UserID']]);
echo '</pre>';
*/
//unset($_SESSION['a'.$_SESSION['UserID']]);
$show_notes_of_sent_payments = false;
	
if (isset($last_loggedin, $_SESSION['loggedin']) && $last_loggedin != $_SESSION['loggedin']) {
    if (isset($_SESSION['a'.$_SESSION['UserID']])) unset($_SESSION['a'.$_SESSION['UserID']]);
}

$last_loggedin = isset($_SESSION['loggedin']) ? $_SESSION['loggedin'] : null;

if (isset($p_username, $_SESSION['loggedin']) && $p_username != $_SESSION['loggedin']) {
    if (isset($_SESSION['a'.$_SESSION['UserID']])) unset($_SESSION['a'.$_SESSION['UserID']]);
}

// Ensure $_SESSION['a' . $_SESSION['UserID']] is an array
if (!isset($_SESSION['a' . $_SESSION['UserID']]) || !is_array($_SESSION['a' . $_SESSION['UserID']])) {
    $_SESSION['a' . $_SESSION['UserID']] = [];
}

function getPaymentInfo($loggedin, $program_id) {
	$selectFields = '*';
	$mainTable = 'payment_log';
	$where = [
		'payer_username' => ['=', $loggedin],
		'program_id' => ['=', $program_id]
	];
	$orderBy = 'payment_log_id DESC';
	$limit = 1;

	$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, 1);
	$buffer = isset($result[0]) ? $result[0] : null;    

	$sessionPrefix = 'p' . $program_id;

	// Last paid date
	if (!isset($buffer['timestamp'])) {
		$_SESSION[$sessionPrefix . '_last_paid_date'] = 'N/A';
	} else {
		$_SESSION[$sessionPrefix . '_last_paid_date'] = date('M j, Y', $buffer['timestamp']);
	}

	// Due date
	if (!isset($_SESSION[$sessionPrefix . '_expire']) || $_SESSION[$sessionPrefix . '_expire'] == 0) {
		$_SESSION[$sessionPrefix . '_due_date'] = 'N/A';
	} else if ($_SESSION[$sessionPrefix . '_program_type'] == 'S') {
		$_SESSION[$sessionPrefix . '_due_date'] = date('M j, Y', $_SESSION[$sessionPrefix . '_expire']);
	} else if ($_SESSION[$sessionPrefix . '_program_type'] == 'N' || $_SESSION[$sessionPrefix . '_status'] == 'Comped') {
		$_SESSION[$sessionPrefix . '_due_date'] = 'Never';
	} else {
		$_SESSION[$sessionPrefix . '_due_date'] = 'N/A';
	}

	// Last paid with
	$payment_processor = $buffer['payment_processor'] ?? '';
	
	if (isset($buffer['timestamp']) && $buffer['payment_processor'] != '') $_SESSION[$sessionPrefix . '_last_paid_with'] = $buffer['payment_processor'];

	if ($payment_processor == 'E4' || $payment_processor == 'E4TEST' || $payment_processor == 'AN') {
		$_SESSION[$sessionPrefix . '_last_paid_with'] = 'Credit Card';
	} else if ($payment_processor == 'A') {
		$_SESSION[$sessionPrefix . '_last_paid_with'] = 'Payza';
	} else if ($payment_processor == 'P') {
		$_SESSION[$sessionPrefix . '_last_paid_with'] = 'Paypal';
	} else if ($payment_processor == 'C') {
		$_SESSION[$sessionPrefix . '_last_paid_with'] = 'Marked Paid';
	} else if ($payment_processor == 'B') {
		$_SESSION[$sessionPrefix . '_last_paid_with'] = 'Bitcoin';
	} else if ($payment_processor == 'D') {
		$_SESSION[$sessionPrefix . '_last_paid_with'] = 'Dwolla';
	} else if ($payment_processor == 'VC') {
		$_SESSION[$sessionPrefix . '_last_paid_with'] = 'Voucher';
	} else if ($payment_processor == '') {
		$_SESSION[$sessionPrefix . '_last_paid_with'] = 'N/A';
	}
}

//unset($_SESSION['a'.$_SESSION['UserID']]['status_check']);

if (!isset($_SESSION['a'.$_SESSION['UserID']]['status_check'])) {
	//$_SESSION['p1_amt'] = '';
	//echo '<h1>DOING STATUS CHECK!!</h1>';
	//if ($_SESSION['debug'] == true) echo 'GOT TO SESSION STATUS CHECK WAS EMPTY<br/>';
	if (isset($_SESSION['a'.$_SESSION['UserID']]['affiliate_status'])) {
		unset($_SESSION['a'.$_SESSION['UserID']]['affiliate_status']);
	}

	if (isset($_SESSION['a'.$_SESSION['UserID']]['count'])) {
		unset($_SESSION['a'.$_SESSION['UserID']]['count']);
	}
	
    $_SESSION['upidlist'] = '';
	$userId = $_SESSION['UserID'];
	$selectFields = [
		'u.program_id', 
		'u.user_status', 
		'u.user_qualify', 
		'u.user_qualify_perm', 
		'u.user_program_id', 
		'u.expire', 
		'p.program_name', 
		'p.program_type', 
		'p.program_up'
	];
	$mainTable = [
		'table' => 'user_program', 
		'as' => 'u'
	];
	$joinConditions = [
		[
			'table' => 'program', 
			'as' => 'p', 
			'condition' => 'u.program_id=p.program_id AND p.program_approved=\'Y\''
		]
	];
	$where = [
		'ID' => ['=', $userId]
	];
	$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, 0, 1);
	
	$loggedin = $_SESSION['loggedin'];

	foreach ($result as $bufferp) {
		$_SESSION['p'.$bufferp['program_id'].'_name'] = $bufferp['program_name'];	
		$_SESSION['p'.$bufferp['program_id'].'_program_type'] = $bufferp['program_type'];
		$_SESSION['p'.$bufferp['program_id'].'_expire'] = $bufferp['expire'];
        $_SESSION['p'.$bufferp['program_id'].'_status'] = $bufferp['user_status'];
        $_SESSION['p'.$bufferp['program_id'].'_upid'] = $bufferp['user_program_id'];
        if ($_SESSION['upidlist'] != "") $_SESSION['upidlist'] .= ",";
        $_SESSION['upidlist'] .= $bufferp['user_program_id'];
		if ($bufferp['user_qualify'] == $bufferp['program_up'] || $bufferp['user_qualify_perm'] == $bufferp['program_up'] || $_SESSION['UserID'] == 1) {
			$_SESSION['p'.$bufferp['program_id'].'_is_qualified'] = true;
		} else {
			$_SESSION['p'.$bufferp['program_id'].'_is_qualified'] = false;
		}
		getPaymentInfo($loggedin, $bufferp['program_id']);
	}
	

	// GET AFFILIATE STATUS
	$userId = $_SESSION['UserID']; // Make sure this is sanitized if it's coming from user input
	$selectFields = ['affiliate_status'];
	$mainTable = 'members';
	$where = ['ID' => ['=', $userId]];
	$limit = 1;
	$show_debug = 1;

	// Execute the query using your PHPCPR 'select' function
	$result = select($selectFields, $mainTable, [], $where, null, null, null, $limit, $show_debug);

	// Fetch the first row from the result
	$buffer = isset($result[0]) ? $result[0] : null;

	
	if ($buffer['affiliate_status'] == 'Y') {
		$_SESSION['a'.$_SESSION['UserID']]['affiliate_status'] = true;
	} else {
		$_SESSION['a'.$_SESSION['UserID']]['affiliate_status'] = false;
	}
	// QQQ KLUDGE - EVERYONE IS ALWAYS AN AFFILIATE BY DEFAULT
	//$_SESSION['a'.$_SESSION['UserID']]['affiliate_status'] = true;	
	
	//QQQ REWRITE LONG PROGRAM NAMES TO SHORTER ONES HERE
	//$_SESSION['p1_name'] = '';
	//$_SESSION['p2_name'] = '2x2 Matrix';
	//$_SESSION['p3_name'] = '2x3 Matrix';
	/*
	if ($_SESSION['Returning'] == true && $_SESSION['nagged'] != true && $_SESSION['admin_login'] != true && $_GET['rd'] == '') {
		$_SESSION['nagged'] = true;
		header("Location: welcome-back.php");
		exit;
	}
	*/

	$_SESSION['a'.$_SESSION['UserID']]['status_check'] = true;
	
	$p_username = $_SESSION['loggedin'];
	
	// WORKS!
	$selectFields = [
		'prog.program_name', 'mp.*', 'u.program_id', 
		'p.payment_complete', 'p.noted_as_paid', 
		'p.payer_username', 'p.user_payment_plan_id'
	];

	$mainTable = ['table' => 'payment_plan', 'as' => 'p'];

	$joinConditions = [
		['table' => 'mark_payment', 'as' => 'mp', 'condition' => 'p.payment_plan_id = mp.payment_plan_id'],
		['table' => 'user_payment_plan', 'as' => 'upp', 'condition' => 'p.user_payment_plan_id = upp.user_payment_plan_id'],
		['table' => 'user_program', 'as' => 'u', 'condition' => 'upp.user_program_id = u.user_program_id'],
		['table' => 'program', 'as' => 'prog', 'condition' => 'u.program_id = prog.program_id']
	];

	$where = [
		'p.payment_complete' => ['!=', 'Y'],
		'p.noted_as_paid' => ['=', 'Y'],
		'p.username' => ['=', $p_username]
	];

	$result_marked = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, 0, 1);

	// Fetch the first row from the result
	$buffer_marked = isset($result_marked[0]) ? $result_marked[0] : null;
	
	
	if (isset($buffer_marked['noted_as_paid']) && $buffer_marked['noted_as_paid'] != '') {
		$_SESSION['a'.$_SESSION['UserID']]['has_noted_payments'] = true;
	} else {
		$_SESSION['a'.$_SESSION['UserID']]['has_noted_payments'] = false;
	}
} // END STATUS CHECK

if ($_SESSION['p1_status'] == 'Unpaid' && $_SESSION['admin_login'] == false) $pageClass = 'full'; // DO NOT SHOW MENU TO UNPAID USERS

// COUNT VISITS TO ALL B.O. PAGES - FOR POSSIBLE USE IN SHOWING ALERTS LATER
if (!isset($_SESSION['a'.$_SESSION['UserID']]['count'])) $_SESSION['a'.$_SESSION['UserID']]['count'] = 0;
$_SESSION['a'.$_SESSION['UserID']]['count']++;

$show_notes_of_sent_payments = $_SESSION['a'.$_SESSION['UserID']]['has_noted_payments'];
//echo $show_notes_of_sent_payments; exit;
//print_r($_SESSION); exit;

/*
if ($_SESSION['p1_status'] == 'Unpaid' && $_SESSION['p2_status'] == 'Unpaid') {
	$_SESSION['free_member'] = true;
}	
*/
/*
// DO NOT SHOW AFFILATE LINKS IF THEY ARE UNPAID!
// USE THIS IF -> ONLY PAID MEMBERS CAN BE AFFILIATES
// DO NOT USE THIS IF -> YOU ALLOW FREE UPGRADES!!!
if ($_SESSION['p1_status'] == 'Unpaid' && $_SESSION['p2_status'] == 'Unpaid' && $_SESSION['p3_status'] == 'Unpaid' && $_SESSION['p4_status'] == 'Unpaid') {
$_SESSION['a'.$_SESSION['UserID']]['affiliate_status'] = false;	
}
*/

/* // REDIRECT NON AFFILIATES TO RETAIL PRODUCTS THEY BOUGHT
if ($_SESSION['a'.$_SESSION['UserID']]['affiliate_status'] != true && $pageClass == 'index') {
	header('Location: /paid/1.php'); // REDIRECT
}
*/

 // IF YOU WANT USERS TO BE REQUIRED TO BE ACTIVE IN ONE OR MORE PROGRAMS, FOR ADDITIONAL PERKS
$has_active_level = false;

for ($i = 1; $i <= 10; $i++) {
    if (isset($_SESSION['p'.$i.'_status']) && ($_SESSION['p'.$i.'_status'] == 'Active' || $_SESSION['p'.$i.'_status'] == 'Comped')) {
        $has_active_level = true;
        break; // Exit the loop as soon as one active or comped status is found
    }
}


//if ($_SESSION['debug'] == true && $additional_level == true) echo 'ADDITIONAL LEVEL TRUE';
//if ($_SESSION['debug'] == true && $additional_level != true) echo 'ADDITIONAL LEVEL FALSE';

/*
if ($additional_level === true || $_SESSION['admin_session_view'] === true) { 
} 
*/

if (!isset($_SESSION['a'.$_SESSION['UserID']]['got_earnings']) || $_SESSION['a'.$_SESSION['UserID']]['got_earnings'] != true) {
	
	// Initialize the variable to store the query result
	$total_logs_earned = 0;

	// Define the condition based on the session value
	if ($_SESSION['loggedin'] == 'QQQ') {
		$selectFields = ['SUM(earned_amount) as amt'];
		$mainTable = 'user_program';
		$where = ['ID' => ['=', $_SESSION['UserID']]];
	} else {
		$selectFields = ['SUM(log.amount) as amt'];
		$mainTable = ['table' => 'payment_log', 'as' => 'log'];
		$joinConditions = [
			['table' => 'user_program', 'as' => 'u', 'condition' => 'log.user_program_id = u.user_program_id']
		];
		$where = [
			'log.chargeback' => ['!=', 'Y'],
			'u.ID' => ['=', $_SESSION['UserID']]
		];
	}

	// Execute the query using your PHPCPR 'select' function
	$result2 = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, 0, 1);

	// Fetch the first row from the result
	$buffer2 = isset($result2[0]) ? $result2[0] : null;

	// Calculate the total logs earned
	if ($buffer2 && isset($buffer2['amt'])) {
		$total_logs_earned = $buffer2['amt'] + 0;
	}		
				
	// JS ADDED MATRIX EARNINGS
	$selectFields = ['SUM(amount) as amt'];
	$mainTable = 'transactions_log';
	$where = [
		'transtype' => ['=', 'COMM'],
		'amount' => ['>', 0],
		'usrid' => ['=', $_SESSION['UserID']]
	];
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
	$buffer = isset($result[0]) ? $result[0] : null;
	$total_trans_earned = $buffer['amt'];
	$total_earned = $total_trans_earned + 0;
	
	$thirty_days_ago = strtotime("-30 days");

	$selectFields = ['SUM(log.amount) as amt'];
	$mainTable = ['table' => 'payment_log', 'as' => 'log'];
	$joinConditions = [
		['table' => 'user_program', 'as' => 'u', 'condition' => 'log.user_program_id = u.user_program_id'],
		['table' => 'program', 'as' => 'p', 'condition' => 'p.program_id = log.program_id']
	];
	$where = [
		'u.ID' => ['=', $_SESSION['UserID']],
		'p.program_type' => ['=', 'S'],
		'log.timestamp' => ['>', $thirty_days_ago],
		'log.chargeback' => ['!=', 'Y']
	];

	$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, 0, 1);
	$buffer = isset($result[0]) ? $result[0] : null;
	$total_earned_recurring = $buffer['amt'] + 0;
		
	// MATRIX & X-UP MONTHLY EARNINGS - UPDATE TO ADD FORCED MATRICES, IF RECURRING
	$amt_recurring = $total_earned_recurring;
		
	$_SESSION['amt'] = number_format($total_earned,2);
	$_SESSION['amt_recurring'] = number_format($amt_recurring,2);
	
	//echo 'AAAAAAAAA';
	//echo 'amt '.$_SESSION['amt'];
	//echo ' amt rec'.$_SESSION['amt_recurring'];
	
	$selectFields = ['ID'];
	$mainTable = 'members';
	$joinConditions = [];
	$where = ['sponsorid' => ['=', $_SESSION['loggedin']], 'Status' => ['=', 'unpaid']];

	$res_unpaid = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, 0, 1);
	//$_SESSION['count_unpaid'] = count($res_unpaid);
	$_SESSION['count_unpaid'] = is_array($res_unpaid) && !empty($res_unpaid) ? count($res_unpaid) : 0;


	$selectFields = ['ID'];
	$mainTable = 'members';
	$joinConditions = [];
	$where = ['sponsorid' => ['=', $_SESSION['loggedin']], 'Status' => ['=', 'paid']];

	$res_paid = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, 0, 1);
	//$_SESSION['count_active'] = count($res_paid);
	$_SESSION['count_active'] = is_array($res_paid) && !empty($res_paid) ? count($res_paid) : 0;

	
	//echo 'count active '.$_SESSION['count_active'];
	//echo ' count unpaid '.$_SESSION['count_unpaid'];
	//exit;

	$_SESSION['a'.$_SESSION['UserID']]['got_earnings'] = true;	
}
if ($turn_on_debug == true) {
	$_SESSION['debug'] = true;
}

//print_r($_SESSION);
//exit;

if ($bypass_painting_page == false) {
//////////////////////////////////

// LOCKING BACK OFFICE TO THOSE UNPAID IN ALL LEVELS!!					
/*$qry = "SELECT user_status FROM user_program WHERE ID={$_SESSION['UserID']} AND user_status IN ('Active','Comped')";
//echo $qry."<br/>";
$result = mysql_query($qry) or die($qry.' '.mysql_error());
$rows = mysql_num_rows($result);
*/
// SAVING FOR CUSTOM SOLUTIONS IF REQUESTED
// UNPAID IN DEFINED LEVELS
//if ($_SESSION['p1_status'] == 'Unpaid' && $_SESSION['p2_status'] == 'Unpaid' && $_SESSION['p3_status'] == 'Unpaid' && $_SESSION['p4_status'] == 'Unpaid') {
// UNPAID IN ALL LEVELS, AND NOT AN AFFILIATE
//if ($rows == 0 && $_SESSION['a'.$_SESSION['UserID']]['affiliate_status'] == false) { // LOCK MENU
/* 
// MOVE THESE ITEM TO THE MENU BELOW, TO LOCK IT
?>		
					<li>
						<a href='<?php echo $GLOBALS['webpage_url_ssl']; ?>apay/buy.php'>
							<div class="fs1 icon-signal" aria-hidden="true"></div>
							<span>Menu Locked</span>
						</a>
					</li>
					<li>
						<a href='<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/logout.php'>
							<div class="fs1 icon-user" aria-hidden="true"></div>
							<span>Logout</span>
						</a>
					</li>					
	<?php } else if ($rows > 0 || $_SESSION['a'.$_SESSION['UserID']]['affiliate_status'] == true) { // SHOW MENU
	?>	
*/	
?>


<!DOCTYPE html>
<!-- 
Template Name: Metronic - Responsive Admin Dashboard Template build with Twitter Bootstrap 3.3.7
Version: 4.7.1
Author: KeenThemes
Website: http://www.keenthemes.com/
Contact: support@keenthemes.com
Follow: www.twitter.com/keenthemes
Dribbble: www.dribbble.com/keenthemes
Like: www.facebook.com/keenthemes
Purchase: http://themeforest.net/item/metronic-responsive-admin-dashboard-template/4021469?ref=keenthemes
Renew Support: http://themeforest.net/item/metronic-responsive-admin-dashboard-template/4021469?ref=keenthemes
License: You must have a valid license purchased only from themeforest(the above link) in order to legally use the theme for your project.
-->
<!--[if IE 8]> <html lang="en" class="ie8 no-js"> <![endif]-->
<!--[if IE 9]> <html lang="en" class="ie9 no-js"> <![endif]-->
<!--[if !IE]><!-->
<html lang="en">
    <!--<![endif]-->
    <!-- BEGIN HEAD -->

    <head>
	   <meta content="AutomaticWebSoftware.com" name="GENERATOR">
		<meta content="PHP" name="CODE_LANGUAGE">
		<title><?php echo $GLOBALS['webpage_name']; ?></title>
        <meta charset="utf-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta content="width=device-width, initial-scale=1" name="viewport" />
        <meta content="" name="author" />
        <!-- BEGIN GLOBAL MANDATORY STYLES -->
        <link href="//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700&subset=all" rel="stylesheet" type="text/css" />
		
		<!--
        <link href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/assets/global/plugins/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
		-->
		<!-- Font Awesome CSS 3.1 NEEDED FOR icon-wallet, not supported in 4.7!!! -->
		<link href="//maxcdn.bootstrapcdn.com/font-awesome/3.2.1/css/font-awesome.css" rel="stylesheet" type="text/css" />
	
        <link href="//maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
		
        <link href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/assets/global/plugins/simple-line-icons/simple-line-icons.min.css" rel="stylesheet" type="text/css" />
        <!--
		<link href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/assets/global/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
		
		THESE NEXT 3 FILES MUST GO IN THIS ORDER!!!
		-->
		<?php if ($pageName == 'Ads Scroller') { ?>
			<script src="https://code.jquery.com/jquery-3.6.0.min.js" crossorigin="anonymous"></script>
			<script src="//netdna.bootstrapcdn.com/bootstrap/3.0.0/js/bootstrap.min.js"></script>
			<link rel="stylesheet" href="//maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
		<?php } else if ($pageClass == 'leads') { ?>
			<script src='//cdnjs.cloudflare.com/ajax/libs/jquery/2.1.3/jquery.min.js'></script>
			<script src='//maxcdn.bootstrapcdn.com/bootstrap/3.3.2/js/bootstrap.min.js'></script>
			<link rel='stylesheet prefetch' href='//maxcdn.bootstrapcdn.com/bootstrap/3.3.2/css/bootstrap.min.css'>		
		<?php } else { ?>
			<script src="//ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.js"></script>
			<script src="//netdna.bootstrapcdn.com/bootstrap/3.0.0/js/bootstrap.min.js"></script>
		<link rel="stylesheet" href="//maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">			
		<?php } ?>
		
		<!-- Use CDN for FlipClock CSS -->
		<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/flipclock/0.7.8/flipclock.min.css">	
		
		<!-- Use CDN for FlipClock.js -->
		<script src="https://cdnjs.cloudflare.com/ajax/libs/flipclock/0.7.8/flipclock.min.js"></script>		
		
<!-- ADDED FOR DATE PICKER	-->	
<script src='//cdnjs.cloudflare.com/ajax/libs/moment.js/2.9.0/moment-with-locales.min.js'></script>
<script src='//cdnjs.cloudflare.com/ajax/libs/bootstrap-datetimepicker/3.1.3/js/bootstrap-datetimepicker.min.js'></script>
<link rel='stylesheet prefetch' href='https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datetimepicker/3.1.3/css/bootstrap-datetimepicker.min.css'>
<!-- END --> 		

        
		
        <link href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/assets/global/plugins/bootstrap-switch/css/bootstrap-switch.min.css" rel="stylesheet" type="text/css" />
        <!-- END GLOBAL MANDATORY STYLES -->
        <!-- BEGIN PAGE LEVEL PLUGINS -->
<!-- REMOVED FOR DATEPICKER IN LEADCAP
        <link href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/assets/global/plugins/bootstrap-daterangepicker/daterangepicker.min.css" rel="stylesheet" type="text/css" />
-->
        <link href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/assets/global/plugins/morris/morris.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/assets/global/plugins/fullcalendar/fullcalendar.min.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/assets/global/plugins/jqvmap/jqvmap/jqvmap.css" rel="stylesheet" type="text/css" />
        <!-- END PAGE LEVEL PLUGINS -->
        <!-- BEGIN THEME GLOBAL STYLES -->
		<?php if ($pageClass != 'leadsQQQ') { ?>
        <link href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/assets/global/css/components.min.css" rel="stylesheet" id="style_components" type="text/css" />
        <?php } ?>
        <link href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/assets/global/css/plugins.min.css" rel="stylesheet" type="text/css" />
        <!-- END THEME GLOBAL STYLES -->
        <!-- BEGIN THEME LAYOUT STYLES -->
        <link href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/assets/layouts/layout/css/layout.min.css" rel="stylesheet" type="text/css" />
        <link href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/assets/layouts/layout/css/themes/darkblue.min.css" rel="stylesheet" type="text/css" id="style_color" />
        <link href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/assets/layouts/layout/css/custom.min.css" rel="stylesheet" type="text/css" />
        <!-- END THEME LAYOUT STYLES -->		

        <link rel="shortcut icon" href="/images/favicon.ico" />

	<!-- NEXT 2 INCLUDES ARE FOR ANIMATED WOW EFFECTS -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.7.0/animate.min.css" rel="stylesheet">
	<script src="https://cdnjs.cloudflare.com/ajax/libs/wow/1.1.2/wow.min.js"></script>	

		<!-- OLD THEME
		<link href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/css/main.css" rel="stylesheet" media="screen">
		-->
		
<script language="JavaScript"> 
<!-- 
if (parent.frames.length > 0) { 
parent.location.href = location.href; 
} 
// --> 
</script>

<script> function ARDetails() {  document.getElementById("ardetails1").style.visibility = "hidden";
document.getElementById("ardetails1").style.display = "none";
document.getElementById("ardetails2").style.visibility = "hidden";
document.getElementById("ardetails2").style.display = "none";
document.getElementById("ardetails3").style.visibility = "hidden";
document.getElementById("ardetails3").style.display = "none";
document.getElementById("ardetails4").style.visibility = "hidden";
document.getElementById("ardetails4").style.display = "none";
  var arID = document.getElementById("arid").value;  if (arID == 0)  {   document.getElementById("araddtlitems").style.visibility = "hidden";  }  else  {   var detailDiv = "ardetails"+arID;   document.getElementById("araddtlitems").style.visibility = "visible";   document.getElementById(detailDiv).style.visibility = "visible";   document.getElementById(detailDiv).style.display = "block";  } } </script>


<script type="text/javascript"> 
<!--
function SetAllCheckBoxes(FormName, FieldName, CheckValue)
{
	if(!document.forms[FormName])
		return;
	var objCheckBoxes = document.forms[FormName].elements[FieldName];
	if(!objCheckBoxes)
		return;
	var countCheckBoxes = objCheckBoxes.length;
	if(!countCheckBoxes)
		objCheckBoxes.checked = CheckValue;
	else
		// set the check value for all check boxes
		for(var i = 0; i < countCheckBoxes; i++)
			objCheckBoxes[i].checked = CheckValue;
}
// -->
</script>


<?php if (isset($copyshipping_frombilling) && $copyshipping_frombilling == true) { ?> 
<SCRIPT LANGUAGE="JavaScript">

var ShipAddress = "";
var ShipCity = "";
var ShipState = "";
var ShipStateIndex = 0;
var ShipProvince = "";
var ShipZip = "";
var ShipCountryIndex = 0;

function InitSaveVariables(form) {
ShipAddress = form.ship_address.value;
ShipCity = form.ship_city.value;
ShipZip = form.ship_zip.value;
ShipStateIndex = form.ship_state.selectedIndex;
ShipState = form.ship_state[ShipStateIndex].value;
ShipProvince = form.ship_province.value;
ShipCountryIndex = form.ship_country.selectedIndex;
ShipCountry = form.ship_country[ShipCountryIndex].value;
}

function ShipToBillPerson(form) {
if (form.ship_copy.checked) {
InitSaveVariables(form);
form.ship_address.value = form.address.value;
form.ship_city.value = form.city.value;
form.ship_zip.value = form.zip.value;
form.ship_state.selectedIndex = form.state.selectedIndex;
form.ship_province.value = form.province.value;
form.ship_country.selectedIndex = form.country.selectedIndex;
}
else {
form.ship_address.value = ShipAddress;
form.ship_city.value = ShipCity;
form.ship_zip.value = ShipZip;       
form.ship_state.selectedIndex = ShipStateIndex;
form.ship_province.value = ShipProvince;
form.ship_country.selectedIndex = ShipCountryIndex;
   }
}

</script>
<?php } ?>

<script type="text/javascript">
    // <!--
        function toggleDetails()
        {
            if(document.getElementById('whatsthis').style.display == 'none') {
                document.getElementById('whatsthis').style.display = '';
		
            } else {
                document.getElementById('whatsthis').style.display = 'none';
			
			
            }
        }
    // -->
</script>
<script type="text/javascript">
    // <!--
        function toggleDetailsa()
        {
            if(document.getElementById('whatsthisa').style.display == 'none') {
                document.getElementById('whatsthisa').style.display = '';
				document.getElementById('bannercode').checked=true;
            } else {
                document.getElementById('whatsthisa').style.display = 'none';
				document.getElementById('bannercode').checked=false;
            }
        }
    // -->
</script>

<!-- STYLE CODE COPIED FROM OLD THEME -->
<!--
<style type="text/css">
td {
overflow: hidden;
max-width: 400px;
word-wrap: break-word;
}
</style>
-->

<!-- CSS code from Bootply.com editor -->
        
<style type="text/css">
.thumbnail {margin-bottom:6px;}
.flex-video iframe,
.flex-video object,
.flex-video embed {
position: absolute;
top: 0;
left: 0;
width: 100%;
height: 100%;
}
</style>
<!--
    <script type="text/javascript" src="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/html5gallery/html5gallery.js"></script>
-->	
<style>
.nav-link {
	color: #FFF;
}
.title {
	color: #FFF;
}

h1 {
	color: gray;
}
h2 {
	color: gray;
}
 
form { display: inline-block; }
a.tip {
    border-bottom: 1px dashed;
    text-decoration: none
}
a.tip:hover {
    cursor: help;
    position: relative
}
a.tip span {
    display: none
}
a.tip:hover span {
    border: #c0c0c0 1px dotted;
    padding: 5px 20px 5px 5px;
    display: block;
    z-index: 100;
    background: url(../images/status-info.png) #f0f0f0 no-repeat 100% 5%;
    left: 0px;
    margin: 10px;
    width: 250px;
    position: absolute;
    top: 10px;
    text-decoration: none
}
</style>

<?php
	// UPDATE TO if ($paychain == true) { // AFTER ALL PAY PAGES UPDATED!
	if ($pageName != 'Profile' && $pageName != 'Buy' && $pageName != 'Make Payment' && $pageName != 'Pay By Credit Card' && $pageName != 'Pay By Bank' && $pageName != 'Pay By Bitcoin' && $paychain != true) {
		
	// NOTE!! THIS CODE BROKE THE DIVS BEING ABLE TO OPEN UP ON THE PROFILE PAGE, LIKE ABOUT SECTION. ODDLY, THE BUTTON "SHOW ALL OPTIONS" STILL WORKED!
//SO IF ANY OTHER PAGES USE SIMILAR DIVS, WE'D NEED TO EXCLUDE THOSE, OR FIND OUT HOW TO MAKE COMPATIBLE.
// ANY CHANGES HERE, NEED TO BE DONE BELOW.
?>
<!--
<script>
new WOW().init(); 
$(document).ready(function() {
    $('a[href*="#"]:not([href="#"])').click(function() {
      if (location.pathname.replace(/^\//,'') == this.pathname.replace(/^\//,'') && location.hostname == this.hostname) {
        var target = $(this.hash);
        target = target.length ? target : $('[name=' + this.hash.slice(1) +']');
        if (target.length) {
          $('html, body').animate({
            scrollTop: target.offset().top
          }, 1000);
          return false;
        }
      }
    });
  });
</script>	
-->
<style>
<?php
	}

if ($pageName == 'Matrix Viewer') {
?>
	body {
	  overflow-x: auto; /*appear when needed*/
	}
<?php
}
?>	
</style>
<!-- END STYLE CODE COPIED FROM OLD THEME -->
		</head>
    <!-- END HEAD -->
	
	    <style>
        @media screen and (max-width: 768px){
            .logo_image { width: 60px; height: px; display: QQnone;}
        }
<!--		
        @media screen and (min-width: 769px){
            .logo_image { width: 130px; height: px; display: QQnone;}
        }	-->	
        @media screen and (min-width: 768px){
            .logo_image { width: 60px; height: px; display: QQnone;}
        }		
		
    </style>	

<?php 
//If $bypass_program_page is true, auto-submit the form
if (isset($bypass_program_page) && $bypass_program_page === true && $pageName == 'Make Payment') { 
	/*	if ($_SESSION['program_select_view'] === true) {
	// XXX THIS IS SET TO AUTO SUBMIT THE SECOND FORM ON THE PAGE, IF THE ADMIN SESSION WITH PROGRAM SELECT FORM IS PRESENT!
		echo '<BODY onLoad=\'document.forms[1].submit();\'>';
	} else {
		echo '<BODY onLoad=\'document.forms[0].submit();\'>';
	}	*/
	// set unconditionally
	echo '<body onLoad=\'document.forms[0].submit();\'>';
} else {
	echo '<body class="page-header-fixed page-sidebar-closed-hide-logo page-content-white">';
}
?>	
        <div class="page-wrapper">
            <!-- BEGIN HEADER -->
            <div class="page-header navbar navbar-fixed-top" style="background-color:#">
                <!-- BEGIN HEADER INNER -->
                <div class="page-header-inner ">
                    <!-- BEGIN LOGO -->
                    <div class="page-logo">
                        <!---->
						<span class="logo-default" style="display:inline-block; margin-top:15px; color:#FFF"><?php echo $GLOBALS['webpage_name_short']; ?></span>
						
						<!--<a href="index.php">-->
						<!--
                            <img src="<?php echo $GLOBALS['webpage_url_ssl']; ?>images/logobo.png" width="200px" alt="logo" class="logo-default" style="margin-top:0px; margin-left:-25px" /> </a>
							-->
							<!--	
                        <div class="menu-toggler sidebar-toggler">
                            <span></span>
                        </div>
						-->
                    </div>
                    <!-- END LOGO -->
                    <!-- BEGIN RESPONSIVE MENU TOGGLER -->
					
                    <a href="javascript:;" class="menu-toggler responsive-toggler" data-toggle="collapse" data-target=".navbar-collapse">
                        <span></span>
                    </a>
					
                    <!-- END RESPONSIVE MENU TOGGLER -->
                    <!-- BEGIN TOP NAVIGATION MENU -->
                    <div class="top-menu">
                        <ul class="nav navbar-nav pull-right">
                            <!-- BEGIN NOTIFICATION DROPDOWN -->
                            <!-- DOC: Apply "dropdown-dark" class after "dropdown-extended" to change the dropdown styte -->
                            <!-- DOC: Apply "dropdown-hoverable" class after below "dropdown" and remove data-toggle="dropdown" data-hover="dropdown" data-close-others="true" attributes to enable hover dropdown mode -->
                            <!-- DOC: Remove "dropdown-hoverable" and add data-toggle="dropdown" data-hover="dropdown" data-close-others="true" attributes to the below A element with dropdown-toggle class -->
                            <!--QQQ--><?php if ($pageClass != 'full') { 
								$alerts = 0;
								$tasks = 0;
								// Calculate % of Profile completed
								$userId = $_SESSION['UserID'];

								// Using the PHPCPR select function
								$result = select('*', 'member_link', [], ['ID' => ['=', $userId]], null, null, null, 1, 1);

								// The select function will return an array of results, so you might need to fetch the first row, if that's what you intend.
								$profile_buffer = isset($result[0]) ? $result[0] : null;
								$profile_comp_score = 40;
								//if ($profile_buffer['tax_id']!="") $profile_comp_score += 10; 
								if ($profile_buffer['country']!="") $profile_comp_score += 10; 
								if ($profile_buffer['address']!="") $profile_comp_score += 50; 
								if ($profile_comp_score < 100) {
									//$alerts++;
									$tasks++;
								}
								
								$talerts = 0;
								$loggedinUser = $_SESSION['loggedin'];								
								$too_old = date('Y-m-d H:i:s', strtotime('-10 days'));
								$whereConditions = [
									"username" => ['=', $loggedinUser],
									"status" => ['IN', ['open', 'pending', 'closed']],
									"datetime" => ['>', $too_old]
								];

								$resultt = select('idx', 'support_tickets', [], $whereConditions, null, null, null, 10, 1);

								$talerts = 0;
								foreach ($resultt as $buffert) {
									$talerts++;
								}
							?>
<!--
							<li class="dropdown dropdown-extended dropdown-notification" id="header_notification_bar">
							  <div id="google_translate_element" style="float:right; margin-top: 5pt;"></div>
								<script type="text/javascript">
					function googleTranslateElementInit() {
					  new google.translate.TranslateElement({pageLanguage: 'en', layout: google.translate.TranslateElement.InlineLayout.SIMPLE}, 'google_translate_element');
					}
					</script><script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
							  </li>
	-->						  
							
							<li class="dropdown dropdown-extended dropdown-notification" id="header_notification_bar">
                                <a href="javascript:;" class="dropdown-toggle" data-toggle="dropdown" data-hover="dropdown" data-close-others="true">
                                    <i class="fa fa-bell"></i>
                                    <span class="badge badge-default"><?php if ($alerts>0) echo $alerts; else echo ""; ?></span>
                                </a>
                                <ul class="dropdown-menu">
                                    <li class="external">
                                        <h3>
                                            <span class="bold"><?php if ($alerts>0) { 
					echo $alerts; 
					if ($alerts > 1) $plural_alerts = "s";
					else $plural_alerts = "";
					} else {echo "No"; $plural_alerts = "s";} ?></span> alert<?php echo $plural_alerts; ?></h3>
                                        <?php if (false) { ?><a href="page_user_profile_1.html">view all</a><?php } ?>
                                    </li>
                                    <?php 
									// HIDING THIS TO SHOW OPEN TICKETS, DUE TO SIZE OF ALERT WINDOW CSS AT MOMENT!
									// THIS NEXT ALERT WAS NOT NEEDED ANYWAY, SINCE IT'S REDUNDANT (SHOWN ALSO ON CALENDAR ICON)
									if (false && $profile_comp_score < 100) { ?>
									<li>
                                        <ul class="dropdown-menu-list scroller" style="height: 250px;" data-handle-color="#637283">
                                            <li>
                                                <a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/profile.php">
                                                    <span class="time"></span>
                                                    <span class="details">
                                                        <span class="label label-sm label-icon label-success">
                                                            <i class="fa fa-plus"></i>
                                                        </span> Please complete your profile. </span>
                                                </a>
                                            </li>
                                        </ul>
                                    </li><?php } ?>
                                </ul>
                            </li>
							<!-- QQQ-->
                            <!-- END NOTIFICATION DROPDOWN -->
                            <!-- BEGIN INBOX DROPDOWN -->
                            <!-- DOC: Apply "dropdown-dark" class after below "dropdown-extended" to change the dropdown styte -->
                            
							<li class="dropdown dropdown-extended dropdown-inbox" id="header_inbox_bar">
                                <a href="javascript:;" class="dropdown-toggle" data-toggle="dropdown" data-hover="dropdown" data-close-others="true">
                                    <i class="fa fa-envelope-open"></i>
                                    <span class="badge badge-default"><?php if ($talerts>0) echo $talerts; else echo ""; ?></span>
                                </a>
                                <ul class="dropdown-menu">
                                    <li class="external" style="height: 40px;">
                                        <h3>
                                            <span class="bold"><?php if ($talerts>0) { 
					echo $talerts; 
					if ($talerts > 1) $plural_talerts = "s";
					else $plural_talerts = "";
					} else {echo "No"; $plural_talerts = "s";} ?></span> notification<?php echo $plural_talerts; ?></h3>
                                        <?php if (false) { ?><a href="page_user_profile_1.html">view all</a><?php } ?>
                                    </li>
                                    <?php 
									// SHOWING OPEN TICKETS
                                    if ($talerts > 0) { ?>
									<li>
                                        <ul class="dropdown-menu-list scroller" style="height: 100px;" data-handle-color="#637283">
                                            <li>
                                                <a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>ticket-thread.php" target="_blank">
                                                    <span class="time"></span>
                                                    <span class="details" style="height: 200px;">
                                                        <span class="label label-sm label-icon label-success">
                                                            <i class="fa fa-support"></i>
                                                        </span>&nbsp;You have open tickets. Click here!</span>					
												<br/><br/>
                                                </a>												
                                            </li>
                                        </ul>
                                    </li><?php } ?>
                                        

                                    <?php if (false) { ?><li>
                                        <ul class="dropdown-menu-list scroller" style="height: 275px;" data-handle-color="#637283">
                                            <li>
                                                <a href="#">
                                                    <span class="photo">
                                                        <img src="<?php echo $GLOBALS['webpage_url_ssl']; ?>img/admin2.png" class="img-circle" alt=""> </span>
                                                    <span class="subject">
                                                        <span class="from"> Lisa Rogers </span>
                                                        <span class="time">Just Now </span>
                                                    </span>
                                                    <span class="message"> Vivamus sed auctor nibh congue nibh. auctor nibh auctor nibh... </span>
                                                </a>
                                            </li>
                                             
                                        </ul>
                                    </li><?php } ?>
                                </ul>
                            </li>
							
                            <!-- END INBOX DROPDOWN -->
                            <!-- BEGIN TODO DROPDOWN -->
                            <!-- DOC: Apply "dropdown-dark" class after below "dropdown-extended" to change the dropdown styte -->
							
                            <li class="dropdown dropdown-extended dropdown-tasks" id="header_task_bar">
                                <a href="javascript:;" class="dropdown-toggle" data-toggle="dropdown" data-hover="dropdown" data-close-others="true">
                                    <i class="fa fa-calendar"></i>
                                    <?php if ($tasks>0) { echo '<span class="badge badge-default">'.$tasks.'</span>'; } ?>
                                </a>
                                <ul class="dropdown-menu extended tasks">
                                    <li class="external">
                                        <h3>You have
                                            <span class="bold"><?php if ($tasks>0) { 
					echo $tasks; 
					if ($tasks > 1) $plural_tasks = "s";
					else $plural_tasks = "";
					} else {echo "No"; $plural_tasks = "s";} ?> pending</span> task<?php echo $plural_tasks; ?></h3>
                                        <?php if (false) { ?><a href="app_todo.html">view all</a><?php } ?>
                                    </li>
                                    <?php if ($profile_comp_score < 100) { ?>
									<li>
                                        <ul class="dropdown-menu-list scroller" style="height: 275px;" data-handle-color="#637283">
                                            <li>
                                                <a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/profile.php">
                                                    <span class="task">
                                                        <span class="desc">Profile Completion </span>
                                                        <span class="percent"><?php echo $profile_comp_score; ?>%</span>
                                                    </span>
                                                    <span class="progress">
                                                        <span style="width: <?php echo $profile_comp_score; ?>%;" class="progress-bar progress-bar-success" aria-valuenow="<?php echo $profile_comp_score; ?>" aria-valuemin="0" aria-valuemax="100">
                                                            <span class="sr-only"><?php echo $profile_comp_score; ?>% Complete</span>
                                                        </span>
                                                    </span>
                                                </a>
                                            </li>
                                        </ul>
									<?php } ?>
                                    </li>
                                </ul>
                            </li>
							<?php } // END PAGE CLASS IS NOT 'full' 
							?>	
                            <!-- END TODO DROPDOWN -->
                            <!-- BEGIN USER LOGIN DROPDOWN -->
                            <!-- DOC: Apply "dropdown-dark" class after below "dropdown-extended" to change the dropdown styte -->
                            <li class="dropdown dropdown-user">
                                <a href="javascript:;" class="dropdown-toggle" data-toggle="dropdown" data-hover="dropdown" data-close-others="true">
								
								<?php		
								$image_path = $GLOBALS['path'].'images/Users/'.floor(($_SESSION['UserID'] / 1000)).'/'.$_SESSION['UserID'].'.jpg';
		$profile_image_exists = false;
		if (file_exists($image_path)) {
			$profile_image_exists = true;
			$image_url = $GLOBALS['webpage_url_ssl'].'images/Users/'.floor(($_SESSION['UserID'] / 1000)).'/'.$_SESSION['UserID'].'.jpg';
			}
			
			if ($profile_image_exists == true) {
			?>	
             
				<img alt="" class="img-circle" src="<?php echo $image_url; ?>" />&nbsp;
			<?php 
			} else {
				echo '<i class="fa fa-user"></i>';
			}
			?>

			 <span class="username username-hide-on-mobile" style="color:#;"> <?php echo $_SESSION['Firstname_loggedin']; ?> </span>
                                    <i class="fa fa-angle-down"></i>
                                </a>
                                <ul class="dropdown-menu dropdown-menu-default">
                                    
									<?php if ($pageClass != 'full') { ?>
                                    <li>
                                        <a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/profile.php">
                                            <i class="fa fa-user"></i> My Profile </a>
                                    </li>
									<?php } ?>
									<!--
                                    <li>
                                        <a href="app_calendar.html">
                                            <i class="fa fa-calendar"></i> My Calendar </a>
                                    </li>
                                    <li>
                                        <a href="app_inbox.html">
                                            <i class="fa fa-envelope-open"></i> My Inbox
                                            <span class="badge badge-danger"> 3 </span>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="app_todo.html">
                                            <i class="fa fa-rocket"></i> My Tasks
                                            <span class="badge badge-success"> 7 </span>
                                        </a>
                                    </li>
                                    <li class="divider"> </li>
                                    <li>
                                        <a href="page_user_lock_1.html">
                                            <i class="fa fa-lock"></i> Lock Screen </a>
                                    </li>
									-->
                                    <li>
                                        <a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/logout.php">
                                            <i class="fa fa-key"></i> Log Out </a>
                                    </li>
                                </ul>
                            </li>
                            <!-- END USER LOGIN DROPDOWN -->
                            <!-- BEGIN QUICK SIDEBAR TOGGLER -->
                            <!-- DOC: Apply "dropdown-dark" class after below "dropdown-extended" to change the dropdown styte -->
							<!--
                            <li class="dropdown dropdown-quick-sidebar-toggler">
                                <a href="javascript:;" class="dropdown-toggle">
                                    <i class="fa fa-logout"></i>
                                </a>
                            </li>
							-->
                            <!-- END QUICK SIDEBAR TOGGLER -->
                        </ul>
                    </div>
                    <!-- END TOP NAVIGATION MENU -->
                </div>
                <!-- END HEADER INNER -->
            </div>
           
			<!-- JS ADDING BLUE BAR SEPARATOR -->
			<?php if ($pageClass != 'full' && isset($pageColor) && $pageColor !='white') { 
				$bgcolor = '#384452'; // DARK BLUE-ISH GRAY
			} else if (isset($pageColor) && $pageColor == 'white') {
				$bgcolor = '#fff'; // WHITE
			} else {	
				$bgcolor = '#00b3fe'; // LIGHT BLUE
			}
			?>
			<!--
			<div class="page-sidebar navbar navbar-fixed-top"  style="background-color:<?php echo $bgcolor; ?>; min-height:.3px; max-height:.3em; height:.3px;">
			&nbsp;
			</div>
			-->
			<!-- END JS ADDING BLUE BAR SEPARATOR -->


            <!-- END HEADER -->
            <!-- BEGIN HEADER & CONTENT DIVIDER -->
			
            <div class="clearfix"> </div>
            <!-- END HEADER & CONTENT DIVIDER -->
            <!-- BEGIN CONTAINER -->
			<!-- ADDED BG STYLE HERE TO ALTER THEME COLORS -->
			<?php if ($pageClass != 'full') { ?>
            <div class="page-container" style="background-color:#384452;">
                <!-- BEGIN SIDEBAR -->
                <div class="page-sidebar-wrapper">

                    <!-- BEGIN SIDEBAR -->
                    <!-- DOC: Set data-auto-scroll="false" to disable the sidebar from auto scrolling/focusing -->
                    <!-- DOC: Change data-auto-speed="200" to adjust the sub menu slide up/down speed -->
                    <div class="page-sidebar navbar-collapse collapse">
                        <!-- BEGIN SIDEBAR MENU -->
                        <!-- DOC: Apply "page-sidebar-menu-light" class right after "page-sidebar-menu" to enable light sidebar menu style(without borders) -->
                        <!-- DOC: Apply "page-sidebar-menu-hover-submenu" class right after "page-sidebar-menu" to enable hoverable(hover vs accordion) sub menu mode -->
                        <!-- DOC: Apply "page-sidebar-menu-closed" class right after "page-sidebar-menu" to collapse("page-sidebar-closed" class must be applied to the body element) the sidebar sub menu mode -->
                        <!-- DOC: Set data-auto-scroll="false" to disable the sidebar from auto scrolling/focusing -->
                        <!-- DOC: Set data-keep-expand="true" to keep the submenues expanded -->
                        <!-- DOC: Set data-auto-speed="200" to adjust the sub menu slide up/down speed -->
                        <ul class="page-sidebar-menu  page-header-fixed " data-keep-expanded="false" data-auto-scroll="true" data-slide-speed="200" style="padding-top: 20px">
                            <!-- DOC: To remove the sidebar toggler from the sidebar you just need to completely remove the below "sidebar-toggler-wrapper" LI element -->
                            <!-- BEGIN SIDEBAR TOGGLER BUTTON -->
							<!--
                            <li class="sidebar-toggler-wrapper hide">
                                <div class="sidebar-toggler">
                                    <span></span>
                                </div>
                            </li>
							-->
                            <!-- END SIDEBAR TOGGLER BUTTON -->
                            <!-- DOC: To remove the search box from the sidebar you just need to completely remove the below "sidebar-search-wrapper" LI element -->
                     
                            <li class="heading">
                                <h3 class="uppercase">Member's Back Office</h3>
                            </li>
                            <li class="nav-item  ">

								<a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/index.php" class="nav-link">
                                    <i class="fa fa-bar-chart"></i>
                                    <span class="title">Dashboard</span>
                                </a>
                            </li>
<?php
if ($_SESSION['p1_status'] == 'Active') { ?> 							

                            <li class="nav-item  ">

								<a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>apay/pay.php?resub=Y" class="nav-link">
                                    <i class="fa fa-credit-card"></i>
                                    <span class="title">Make Payment</span>
                                </a>
                            </li>							
<?php } ?>							
                            <li class="nav-item  ">

								<a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/getting-started.php" class="nav-link">
                                    <i class="fa fa-rocket"></i>
                                    <span class="title">Getting Started</span>
                                </a>
                            </li>
							
<?php if (false && $GLOBALS['use_campaigns'] == true) { ?> 	

                            <li class="nav-item  ">

								<a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>ads/ads-scroller.php" class="nav-link">
                                    <i class="fa fa-eye" style="color:#00b3fe"></i>
                                    <span class="title">Deal Finder</span>
                                </a>
                            </li>		
<?php } ?> 
<?php if (false && $GLOBALS['use_campaigns'] == true) { ?> 
<li class="nav-item  ">
                                <a href="javascript:;" class="nav-link nav-toggle">
                                    <i class="fa fa-eye" style="color:#00b3fe"></i>
                                    <span class="title">Deal Finder</span>
                                    <span class="arrow"></span>
                                </a>
                                <ul class="sub-menu">
								  <li class="nav-item  ">
								  <!-- OLD WAY - NO FB STYLE DYNAMIC SCROLLING
									<a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>ads/index.php?type=text" class="nav-link ">
                                            <span class="title">View Text Ad Deals</span>
                                        </a>-->
										
										<!-- NEW DYNAMIC FB STYLE ADS THAT AUTO LOAD AS YOU SCROLL! -->
									<a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>ads/ads-scroller.php?type=text" target="_blank" class="nav-link ">
                                            <span class="title">View Text Ad Deals</span>
                                        </a>
                                    </li>
									
                                    <li class="nav-item  ">
										<!--
                                        <a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>ads/index.php?type=banner" class="nav-link ">
                                            <span class="title">View Banner Ad Deals</span>
                                        </a>-->
											<!-- NEW DYNAMIC FB STYLE ADS THAT AUTO LOAD AS YOU SCROLL! -->		
                                        <a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>ads/ads-scroller.php?type=banner" target="_blank" class="nav-link ">
                                            <span class="title">View Banner Ad Deals</span>
                                        </a>
                                    </li>
										
                                </ul>
                            </li>	
				<?php } ?>	
								
							<li class="nav-item  ">
                                <a href="javascript:;" class="nav-link nav-toggle">
                                    <i class="fa fa-user"></i>
                                    <span class="title">My Account</span>
                                    <span class="arrow"></span>
                                </a>
                                <ul class="sub-menu">
								
                                    <li class="nav-item  ">

									<a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/welcome.php" class="nav-link ">
                                            <span class="title">My Welcome Email</span>
                                        </a>
                                    </li>								
                                    <li class="nav-item  ">

									<a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/profile.php" class="nav-link ">
                                            <span class="title">My Profile</span>
                                        </a>
                                    </li>
									
                                    <li class="nav-item  ">
                                        <a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/profile-social.php" class="nav-link ">
                                            <span class="title">My Social Links</span>
                                        </a>
                                    </li>
									
									<!--
                                    <li class="nav-item  ">
                                        <a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/editpayments.php" class="nav-link ">
                                            <span class="title">My Payments</span>
                                        </a>
                                    </li>
									-->
                                    <li class="nav-item  ">
                                        <a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/programview.php" class="nav-link ">
                                            <span class="title">Program Stats</span>
                                        </a>
                                    </li>
									
                                    <li class="nav-item  ">
                                        <a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/cancel.php" class="nav-link ">
                                            <span class="title">Cancel Membership</span>
                                        </a>
									</li>		
									
                                    <li class="nav-item  ">
                                        <a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/logout.php" class="nav-link ">
                                            <span class="QQQtitle">Logout</span>
                                        </a>
                                    </li>										
                                </ul>
                            </li>	

<?php if ($GLOBALS['use_campaigns'] != false) { ?>				
                           <li class="nav-item  ">
							<a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>ads/dashboard.php" class="nav-link">
							
                                    <i class="fa fa-hand-o-right" style="color:#00b3fe"></i>
                                    <span class="title">Promo Dashboard</span>
                                </a>
                            </li>						
	<?php } ?>							
							<!--
                            <li class="nav-item  ">
<a href="<?php echo $GLOBALS['webpage_url_ssl'] .'Members/'; ?>" class="nav-link">
                                    <i class="fa fa-money" style="color:#00b3fe"></i>
<span class="title">90 Day Challenge </span>  &nbsp; <i class="fa fa-money"></i></a>
							
							</li>
							-->

<?php if ($GLOBALS['use_matrix'] === true) { 
if (true || $_SESSION['p1_status'] == 'Active' || $_SESSION['p1_status'] == 'Comped') {
	//$link = 'Members/paid/1.php';
	$link = 'Members/advanced_viewer.php';
	$icon = 'icon-group';
	$hline = 'See My Matrix';
} else {
	$link = '/apay/pay.php?program=1';
	//$link = 'apay/buy.php';
	$icon = 'icon-lock';
	$hline = 'Pay Here!';
}
?>
                            <li class="nav-item  ">
<a href="<?php echo $GLOBALS['webpage_url_ssl'] . $link; ?>" class="nav-link">
                                    <i class="fa fa-money" style="color:#00b3fe"></i>
<span class="title"><?php echo $hline; ?> </span>  &nbsp; <i class="<?php echo $icon; ?>"></i></a>
							
							</li>
<?php } ?>

		
							<!-- 
							<li class="nav-item  ">
<a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/co-op.php" class="nav-link">
                                    <i class="fa fa-diamond" style="color:#00b3fe"></i>
<span class="title">Ad Co-op! </span>  &nbsp; <i class="fa fa-money"></i></a>
					
							</li>-->
							
							
							<?php if ($GLOBALS['buy_vouchers'] == true) { 
							$icon = 'fa fa-rocket'; ?>
                            <li class="nav-item  ">
<a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/vouchers.php" class="nav-link">
                                    <i class="fa fa-ticket" style="color:#00b3fe"></i>
<span class="title">Get Vouchers! </span>  &nbsp; <i class="<?php echo $icon; ?>"></i></a>
					
							</li>
							<?php } ?>								
							
					<li class='nav-item'>
						<a href="javascript:;" class="nav-link nav-toggle">
							<i class="fa fa-thumbs-up" aria-hidden="true"></i>
							<span class="title">My Membership</span>
						<span class="arrow"></span>
						</a>
						<ul class="sub-menu">
<?php
if ($_SESSION['p1_status'] == 'Active' || $_SESSION['p1_status'] == 'Comped') {
	$link = 'Members/paid/1.php';
	//$link = 'Members/advanced_viewer.php';
	$icon = 'icon-unlock';
} else {
	$link = 'apay/pay.php?program=1';
	//$link = 'apay/buy.php';
	$icon = 'icon-lock';
}
?>
<li>
<a href="<?php echo $GLOBALS['webpage_url_ssl'] . $link; ?>"><span class="title"><?php echo $_SESSION['p1_name']; ?> </span>  &nbsp; <i class="<?php echo $icon; ?>"></i></a>
</li>				

<?php
if ($_SESSION['p2_status'] == 'Active' || $_SESSION['p2_status'] == 'Comped') {
	$link = 'Members/paid/2.php';
	//$link = 'Members/advanced_viewer.php';
	$icon = 'icon-unlock';
} else {
	$link = 'apay/pay.php?program=2';
	//$link = 'apay/buy.php';
	$icon = 'icon-lock';
}
?>
<li>
<a href="<?php echo $GLOBALS['webpage_url_ssl'] . $link; ?>"><span class="title"><?php echo $_SESSION['p2_name']; ?> </span>  &nbsp; <i class="<?php echo $icon; ?>"></i></a>
</li>

<?php
if ($_SESSION['p3_status'] == 'Active' || $_SESSION['p3_status'] == 'Comped') {
	$link = 'Members/paid/3.php';
	//$link = 'Members/advanced_viewer.php';
	$icon = 'icon-unlock';
} else {
	$link = 'apay/pay.php?program=3';
	//$link = 'apay/buy.php';
	$icon = 'icon-lock';
}
?>
<li>
<a href="<?php echo $GLOBALS['webpage_url_ssl'] . $link; ?>"><span class="title"><?php echo $_SESSION['p3_name']; ?> </span>  &nbsp; <i class="<?php echo $icon; ?>"></i></a>
</li>

		
							<?php if ($GLOBALS['buy_vouchers'] == true) { ?>
							<li>
								<a href='<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/vouchers.php'>
									<span class="title">Vouchers</span>
								</a>
							</li>
							<?php } ?>								

						</ul>
					</li>
								
    <li class="nav-item">
                                <a href="javascript:;" class="nav-link nav-toggle">
                                    <i class="fa fa-bullhorn"></i>
                                    <span class="title">Affiliate Marketing</span>
                                    <span class="arrow"></span>
                                </a>
                                <ul class="sub-menu">
						<!--		
                                    <li class="nav-item  ">
                                        <a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/getting-started.php" class="nav-link ">
                                            <span class="title">Fast Start</span>
                                        </a>
                                    </li>

<li class="nav-item  ">
								<a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/freetraffic.php" class="nav-link ">
									<span class="title">Traffic Resources</span>
								</a>
							</li>										
							-->
							<!--
<li class="nav-item  ">
                                        <a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/page_select.php" class="nav-link ">
                                            <span class="title">Lead Pages</span>
                                        </a>
							</li>							
-->

									
								 <li class="nav-item  ">
                                        <a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/profile-fb.php" class="nav-link ">
                                            <span class="title">Facebook Retargeting</span>
                                        </a>
                                    </li>
								 <li class="nav-item  ">
                                        <a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/profile-google.php" class="nav-link ">
                                            <span class="title">Google Remarketing</span>
                                        </a>
                                    </li>
									
<!--<li class="nav-item  ">
                                        <a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/leads.php" class="nav-link ">
                                            <span class="title">My Leads</span>
                                        </a>
                                    </li>
-->		
<!--
<li class="nav-item  ">
                                        <a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/ad-resources.php" class="nav-link ">
                                            <span class="title">Places To Advertise</span>
                                        </a>
                                    </li>							
	-->						
<li class="nav-item  ">
                                        <a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/text-ads.php" class="nav-link ">
                                            <span class="title">Text Ads</span>
                                        </a>
                                    </li>								
									
								<li class="nav-item  ">

									<a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/banners.php" class="nav-link ">
                                            <span class="title">Banners</span>
                                        </a>
                                    </li>
									<!--
								<li class="nav-item  ">

									<a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/postcards.php" class="nav-link ">
                                            <span class="title">Postcards</span>
                                        </a>
                                    </li>
-->									
                                <!--
                                     <li class="nav-item  ">

									<a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/profile-downline-builder.php" class="nav-link ">
                                            <span class="title">Recommended Programs</span>
                                        </a>
                                    </li>
-->						
									
						</ul>

</li>
<?php if (false && $has_active_level == true) { ?>
							<li class="nav-item  ">
								<a href="https://QQQ.com/" target="_blank" class="nav-link ">
                               
                                    <i class="fa fa-user"></i>
                                    <span class="title">QQQ DESC/span>
                                </a>
							</li>
<?php } ?>							

<?php if ($show_notes_of_sent_payments == true) { ?>
                            <li class="nav-item  ">

								<a href="<?php echo $_SERVER['PHP_SELF']; ?>?show_alert=find_marked_payments" class="nav-link">
                                    <i class="fa fa-money" style="color:#00b3fe"></i>
                                    <span class="title">Show Money Alerts</span>
                                </a>
                            </li>					
<?php } ?>

						
					<li class='nav-item'>
						<a href="javascript:;" class="nav-link nav-toggle">
							<i class="fa fa-sitemap" aria-hidden="true"></i>
							<span class="title"> My Team</span>
							<span class="arrow"></span>
						</a>
						<ul class="sub-menu">
<!--						
<?php
if (isset($_SESSION['p1_status']) && $_SESSION['p1_status'] == 'Active' || $_SESSION['p1_status'] == 'Comped') {
	//$link = 'Members/matrix_viewer.php?p=1';
	//$link = 'Members/vgmatrix.php?m=1';
	//$link = "Members/viewdownline.php?program=1";
	$link = 'Members/advanced_viewer.php';
	$icon = 'icon-unlock';
} else {
	$link = 'apay/buy.php';
	$link = 'apay/pay.php?program=1';	
	$icon = 'icon-lock';
}
?>
<li>
<a href="<?php echo $GLOBALS['webpage_url_ssl'] . $link; ?>"><span class="title"><?php echo $_SESSION['p1_name']; ?> </span>  &nbsp; <i class="<?php echo $icon; ?>"></i></a>
</li>-->
<?php
if (isset($_SESSION['p3_status']) && ($_SESSION['p3_status'] == 'Active' || $_SESSION['p3_status'] == 'Comped')) {
	$link = 'Members/vgmatrix.php?m=3'; 
	//$link = "Members/viewdownline.php?program=3";	
	$icon = 'icon-unlock';
} else {
	$link = 'apay/pay.php?program=3';
	$icon = 'icon-lock';
}
if (isset($_SESSION['p3_name']) && $_SESSION['p3_name'] != '') {
?><!--
<li>
<a href="<?php echo $GLOBALS['webpage_url_ssl'] . $link; ?>"><span class="title"><?php echo $_SESSION['p3_name']; ?> </span>  &nbsp; <i class="<?php echo $icon; ?>"></i></a>
</li>-->
<?php
}
if (isset($_SESSION['p4_status']) && ($_SESSION['p4_status'] == 'Active' || $_SESSION['p4_status'] == 'Comped')) {
	$link = 'Members/vgmatrix.php?m=4';
	//$link = "Members/viewdownline.php?program=4";	
	$icon = 'icon-unlock';
} else {
	$link = 'apay/pay.php?program=4';
	$icon = 'icon-lock';
}
if (isset($_SESSION['p4_name']) && $_SESSION['p4_name'] != '') {
?>
<li>
<a href="<?php echo $GLOBALS['webpage_url_ssl'] . $link; ?>"><span class="title"><?php echo $_SESSION['p4_name']; ?></span>  &nbsp; <i class="<?php echo $icon; ?>"></i></a>
</li>
<?php } ?>

<?php
if (isset($_SESSION['p5_status']) && ($_SESSION['p5_status'] == 'Active' || $_SESSION['p5_status'] == 'Comped')) {
	//$link = 'Members/paid/5.php';
	//$link = "Members/viewdownline.php?program=5";
	$link = 'Members/vgmatrix.php?m=5';	
	$icon = 'icon-unlock';
} else {
	$link = 'apay/pay.php?program=5';
	$icon = 'icon-lock';
}
if (isset($_SESSION['p5_name']) && $_SESSION['p5_name'] != '') {
?>
<li>
<a href="<?php echo $GLOBALS['webpage_url_ssl'] . $link; ?>"><span class="title"><?php echo $_SESSION['p5_name']; ?></span>  &nbsp; <i class="<?php echo $icon; ?>"></i></a>
</li>
<?php } ?>

<?php
if (isset($_SESSION['p6_status']) && ($_SESSION['p6_status'] == 'Active' || $_SESSION['p6_status'] == 'Comped')) {
	//$link = 'Members/paid/6.php';
	//$link = "Members/viewdownline.php?program=6";
	$link = 'Members/vgmatrix.php?m=6';
	$icon = 'icon-unlock';
} else {
	$link = 'apay/pay.php?program=6';
	$icon = 'icon-lock';
}
if (isset($_SESSION['p6_name']) && $_SESSION['p6_name'] != '') {
?>
<li>
<a href="<?php echo $GLOBALS['webpage_url_ssl'] . $link; ?>"><span class="title"><?php echo $_SESSION['p6_name']; ?></span>  &nbsp; <i class="<?php echo $icon; ?>"></i></a>
</li>
<?php } ?>

                                    <li class="nav-item  ">
                                        <a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/viewteam.php" class="nav-link ">
                                            <span class="title">View My Team</span>
                                        </a>
                                    </li>	
									
<!--  TOO MUCH MAIL - REMOVED  -->                           <li class="nav-item  ">									
									<a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/emailteam.php" class="nav-link ">
				
                                            <span class="title">Email My Team</span>
                                        </a>
                                    </li>
                                    <li class="nav-item  ">									
									<a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/leads.php" class="nav-link ">
				
                                            <span class="title">View My Leads</span>
                                        </a>
                                    </li>    
<!--	TOO MUCH MAIL - REMOVED								
                                    <li class="nav-item  ">									
									<a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/leads_sendemail.php" class="nav-link ">
				
                                            <span class="title">Email My Leads</span>
                                        </a>
                                    </li>-->									


						</ul>
					</li>														
					<?php if (true || $GLOBALS['use_bank'] == true) { ?>
                               <!--
							   <li class="nav-item  ">
                                        <a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/bankledger.php" class="nav-link ">
										 <i class="icon-wallet"></i>
                                            <span class="title">My Bank</span>
                                        </a>
                                </li>-->
								<!-- FOR TIERS XUP SYSTEMS
								<li class="nav-item  ">
									<a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/viewpayment.php" class="nav-link ">
									 <i class="icon-wallet"></i>
                                            <span class="title">My Commissions</span>
                                        </a>
                                </li>							
	-->
					<?php } else { ?>		
                            <li class="nav-item  ">
                                <a href="javascript:;" class="nav-link nav-toggle">
                                    <i class="icon-wallet"></i>
                                    <span class="title">My Commissions</span>
                                    <span class="arrow"></span>
                                </a>
                                <ul class="sub-menu">
		<!--						
                                    <li class="nav-item  ">
									<a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/credit-card-logs.php" class="nav-link ">
                                            <span class="title">Credit Card Logs</span>
                                        </a>
                                    </li>
		-->							
                                    <li class="nav-item  ">

									<a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/viewpayment.php" class="nav-link ">
                                            <span class="title">Commissions Earned</span>
                                        </a>
                                    </li>
									
                                    <li class="nav-item  ">
                                        <a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/bankledger.php" class="nav-link ">
                                            <span class="title">My Bank</span>
                                        </a>
                                    </li>
                                </ul>
                            </li>							
					<?php } ?>		
							
							
<!--
						   <li class="nav-item  ">

							<a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/news.php" class="nav-link ">
									<i class="fa fa-reorder"></i>
									<span class="title">News</span>
								</a>
							</li>
-->							
<!--
						   <li class="nav-item  ">

							<a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/webinars.php" class="nav-link ">
									<i class="fa fa-television"></i>
									<span class="title">Webinars</span>
								</a>
							</li>								
-->					
														
                                      
                            </li>
<!--
                            <li class="heading">
                                <h3 class="uppercase">Layouts</h3>
                            </li>
-->
<!--                        
                                  <li class="nav-item  ">
                                        <a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/leaderboard_earnings.php" class="nav-link ">
										<i class="fa fa-trophy"></i>
                                            <span class="title">Leaderboard</span>
                                        </a>
                                   </li>						
-->
                                  <li class="nav-item  ">
                                        <a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/leaderboard_stats.php" class="nav-link ">
										<i class="fa fa-trophy"></i>
                                            <span class="title">Leaderboard</span>
                                        </a>
                                   </li>	
	<!--							   
							<li class="nav-item  ">
								<a href="http://mtpmarketingsystem.com/" target="_blank" class="nav-link ">
                               
                                    <i class="fa fa-tv" style="color:#00b3fe"></i>
                                    <span class="title">Custom Lead Pages</span>
                                </a>
							</li>							
-->							

							<li class="nav-item  ">
								<a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>contact.php" target="_blank" class="nav-link ">
                               
                                    <i class="fa fa-support"></i>
                                    <span class="title">Support</span>
                                </a>
							</li>
							
							
						<!-- END CUT -->	
                        </ul>
                        <!-- END SIDEBAR MENU -->
                        <!-- END SIDEBAR MENU -->
                    </div>
                    <!-- END SIDEBAR -->
                    <!-- BEGIN SIDEBAR -->					
                </div>
                <!-- END SIDEBAR -->
                <!-- BEGIN CONTENT -->
                <div class="page-content-wrapper">
                    <!-- BEGIN CONTENT BODY -->
                    <div class="page-content" style="text-align:<?php echo $pageAlign;?>">
                        <!-- BEGIN PAGE HEADER-->
                        <!-- BEGIN THEME PANEL -->
						<!--
                        <div class="theme-panel hidden-xs hidden-sm">
                            <div class="toggler"> </div>
                            <div class="toggler-close"> </div>
                            <div class="theme-options">
                                <div class="theme-option theme-colors clearfix">
                                    <span> THEME COLOR </span>
                                    <ul>
                                        <li class="color-default current tooltips" data-style="default" data-container="body" data-original-title="Default"> </li>
                                        <li class="color-darkblue tooltips" data-style="darkblue" data-container="body" data-original-title="Dark Blue"> </li>
                                        <li class="color-blue tooltips" data-style="blue" data-container="body" data-original-title="Blue"> </li>
                                        <li class="color-grey tooltips" data-style="grey" data-container="body" data-original-title="Grey"> </li>
                                        <li class="color-light tooltips" data-style="light" data-container="body" data-original-title="Light"> </li>
                                        <li class="color-light2 tooltips" data-style="light2" data-container="body" data-html="true" data-original-title="Light 2"> </li>
                                    </ul>
                                </div>
                                <div class="theme-option">
                                    <span> Theme Style </span>
                                    <select class="layout-style-option form-control input-sm">
                                        <option value="square" selected="selected">Square corners</option>
                                        <option value="rounded">Rounded corners</option>
                                    </select>
                                </div>
                                <div class="theme-option">
                                    <span> Layout </span>
                                    <select class="layout-option form-control input-sm">
                                        <option value="fluid" selected="selected">Fluid</option>
                                        <option value="boxed">Boxed</option>
                                    </select>
                                </div>
                                <div class="theme-option">
                                    <span> Header </span>
                                    <select class="page-header-option form-control input-sm">
                                        <option value="fixed" selected="selected">Fixed</option>
                                        <option value="default">Default</option>
                                    </select>
                                </div>
                                <div class="theme-option">
                                    <span> Top Menu Dropdown</span>
                                    <select class="page-header-top-dropdown-style-option form-control input-sm">
                                        <option value="light" selected="selected">Light</option>
                                        <option value="dark">Dark</option>
                                    </select>
                                </div>
                                <div class="theme-option">
                                    <span> Sidebar Mode</span>
                                    <select class="sidebar-option form-control input-sm">
                                        <option value="fixed">Fixed</option>
                                        <option value="default" selected="selected">Default</option>
                                    </select>
                                </div>
                                <div class="theme-option">
                                    <span> Sidebar Menu </span>
                                    <select class="sidebar-menu-option form-control input-sm">
                                        <option value="accordion" selected="selected">Accordion</option>
                                        <option value="hover">Hover</option>
                                    </select>
                                </div>
                                <div class="theme-option">
                                    <span> Sidebar Style </span>
                                    <select class="sidebar-style-option form-control input-sm">
                                        <option value="default" selected="selected">Default</option>
                                        <option value="light">Light</option>
                                    </select>
                                </div>
                                <div class="theme-option">
                                    <span> Sidebar Position </span>
                                    <select class="sidebar-pos-option form-control input-sm">
                                        <option value="left" selected="selected">Left</option>
                                        <option value="right">Right</option>
                                    </select>
                                </div>
                                <div class="theme-option">
                                    <span> Footer </span>
                                    <select class="page-footer-option form-control input-sm">
                                        <option value="fixed">Fixed</option>
                                        <option value="default" selected="selected">Default</option>
                                    </select>
                                </div>
                            </div>
                        </div>
						-->
                        <!-- END THEME PANEL -->
                        <!-- BEGIN PAGE BAR -->
 <!-- BEGIN PAGE BAR -->
                        <div class="page-bar">
                            <ul class="page-breadcrumb">
                                <li>
								<!--
								<sup><span style="margin-top:50px"><i class="fa fa-home"></i></span></sup>
                                   --> <a href="index.php">Home</a>
                                    <i class="fa fa-circle"></i>
                                </li>
                                <li>
                                  <?php echo $pageName;?> &nbsp;<i class="<?php echo $pageIcon; ?> fa-1x"></i>
                                </li>
                            </ul>
							
<!-- SHOW LOGGED IN USER INFO -->

        <div style="float:right; padding: 12px 0px 10px 0px; color:#145798;">Welcome, 
		<?php if ($_SESSION['admin_session_choice'] == true) {
		echo '<a href="'.$GLOBALS['webpage_url_ssl'].'Sub/tpl/session-switchboard.php?switch=admin">';
		} ?>
		<strong><?php echo $_SESSION['Firstname_loggedin'].' '.$_SESSION['Lastname_loggedin']. '&nbsp;(' . $_SESSION['loggedin'] .')'; ?></strong>
		<?php if ($_SESSION['admin_session_choice'] == true) {
		echo '</a>';
		} ?>
		</div>							
							
                            <div class="page-toolbar">
							
                                <div id="dashboard-report-range" class="pull-right tooltips btn btn-sm" data-container="body" data-placement="bottom" data-original-title="Change dashboard date range">
<!--						
                                    <i class="fa fa-calendar"></i>&nbsp;
                                    <span class="thin uppercase hidden-xs"></span>&nbsp;
                                    <i class="fa fa-angle-down"></i>
									-->
                                </div>
                            </div>
							
                        </div>
                        <!-- END PAGE BAR -->
                        <!-- BEGIN PAGE TITLE-->
						<?php
						if ($_SESSION['admin_session_view'] == true)
	echo '<div class="panel">
<div class="panel-heading" style="padding: 6px; width:100%; margin-left:0px; margin-top:0px; line-height:20px; font-size:10pt; height:90px;">';						
						
						if ($_SESSION['admin_session_view'] == true) {	
	echo '<div class="col-md-4 col-xs-12" style="margin-top:0pt;">';
	echo 'Admin Login - User Session Data Display:<br/>';

	if ($_SESSION['test_credit_cards'] === true)
	echo '<a href="'.$GLOBALS['webpage_url_ssl'].'Sub/tpl/session-switchboard.php?switch=cc">End Credit Card Test Session</a>';

	if ($_SESSION['test_credit_cards'] != true)
	echo '<a href="'.$GLOBALS['webpage_url_ssl'].'Sub/tpl/session-switchboard.php?switch=cc">Add Credit Card Test Session</a>';

	if ($_SESSION['debug'] === true) {
		echo ' | <a href="'.$GLOBALS['webpage_url_ssl'].'Sub/tpl/session-switchboard.php?switch=debug">End Debugging Session</a>';
		echo ' | <a href="'.$GLOBALS['webpage_url_ssl'].'Sub/tpl/php-info.php" target="_blank">View PHP Info</a>';
	} else {
		echo ' | <a href="'.$GLOBALS['webpage_url_ssl'].'Sub/tpl/session-switchboard.php?switch=debug">Add Debugging Session</a>';
	}

	echo ' | <a href="'.$GLOBALS['webpage_url_ssl'].'Sub/tpl/session-switchboard.php?switch=affstatus">Change Affiliate Status</a>';
	echo '<br/><a href="'.$GLOBALS['webpage_url_ssl'].'Sub/tpl/session-switchboard.php?switch=admin">End Admin Session</a>';
	// QQQ COMMENT!
//	echo ' | <a href="'.$GLOBALS['webpage_url_ssl'] . $_SERVER['REQUEST_URI'].'?switch=theme">Switch Theme</a>';
//	echo ' | <a href="'.$GLOBALS['webpage_url_ssl'].'Members/index.php?switch=theme">Switch Theme</a>';
	echo ' | <a href="'.$GLOBALS['webpage_url_ssl'].'Members/logout.php">Logout</a>';
	
	
	if ($_SESSION['debug'] === true) {
		if ($_SESSION['a'.$_SESSION['UserID']]['affiliate_status'] == true) echo ' | Affiliate Status True!';
		if ($_SESSION['a'.$_SESSION['UserID']]['affiliate_status'] != true) echo ' | Affiliate Status False!';
	}
	echo '</div><div class="col-md-4 col-xs-12" style="margin-top:0pt;">';
	echo 'Loggedin ID: '.$_SESSION['UserID'].'<br />';
	echo 'Loggedin Username: '.$_SESSION['loggedin'].'<br />';
	echo 'Firstname: '.$_SESSION['Firstname_loggedin'].'<br />';
	echo 'Lastname: '.$_SESSION['Lastname_loggedin'];
	echo '</div><div class="col-md-4 col-xs-12" style="margin-top:0pt;">';
	echo 'Referring Sponsor ID: '.$_SESSION['RefUserID'].'<br />';
	echo 'Referring Sponsor Username: '.$_SESSION['RefSponsorID'].'<br />';
	echo 'Ref Firstname: '.$_SESSION['RefFirstname'].'<br />';
	echo 'Ref Lastname: '.$_SESSION['RefLastname'];
	echo '</div></div></div>';
} // END ADMIN SESSION VIEW
?>

			<!-- Affiliate Invite -->
						
<?php 
if (isset($_SESSION['a'.$_SESSION['UserID']]['affiliate_status']) && 
    $_SESSION['a'.$_SESSION['UserID']]['affiliate_status'] != true && 
    (
        (isset($_SESSION['p1_status']) && ($_SESSION['p1_status'] == 'Active' || $_SESSION['p1_status'] == 'Comped')) ||
        (isset($_SESSION['p2_status']) && ($_SESSION['p2_status'] == 'Active' || $_SESSION['p2_status'] == 'Comped')) ||
        (isset($_SESSION['p3_status']) && ($_SESSION['p3_status'] == 'Active' || $_SESSION['p3_status'] == 'Comped')) ||
        (isset($_SESSION['p4_status']) && ($_SESSION['p4_status'] == 'Active' || $_SESSION['p4_status'] == 'Comped'))
    ) && 
    $pageName == 'Dashboard'
) { 
    $showing_aff_invite = true; 
?> 
			
			
<div class="panel">
<div class="panel-heading" style="padding: 6px; width:100%; margin-left:0px; margin-top:0px; line-height:40px; font-size:20pt; height:90px;">			
				<a href="<?php echo $GLOBALS['webpage_url_ssl']; ?>Members/affiliate-agreement.php">
					<span style="color:#384452">
						<strong>Did you know?</strong> You may earn money by promoting <?php echo $GLOBALS['webpage_name']; ?> as an Affiliate. Click here to Activate your Affiliate Links.</span>
					</a>
					</div>
				</div>
			<?php } ?>
			
			<!-- Affiliate Invite ends -->

<?php
if (!isset($showing_aff_invite)) $showing_aff_invite = false;
if ($_SESSION['admin_session_view'] == false && $showing_aff_invite == false) {
?>			
						
						
                        <h6 class="page-title" style="text-align:left; font-size:18px;"><?php echo $pageDesc; ?>&nbsp;&nbsp;
                            <small></small>
                        </h6>
						
<?php }
} // END PAGE CLASS IS NOT 'full'
else if ($pageClass == 'full' && $bypass_painting_page == false) { ?>
<div style="text-align:<?php echo $pageAlign; ?>; background-color:#F2F3F4">
<p>&nbsp;</p><p>&nbsp;</p>
<?php /*
	// UPDATE TO if ($paychain == true) { // AFTER ALL PAY PAGES UPDATED!
	if ($pageName != 'Buy' && $pageName != 'Make Payment' && $pageName != 'Pay By Credit Card' && $pageName != 'Pay By Bank' && $pageName = 'Pay By Bitcoin') {
		// SHOW BANNER ADS HERE!!
		// SHOW ADS FROM DB 
		
		echo '<div style="text-align:'.$pageAlign.'; background-color:#fff">';
		$public = false;
		$is_ad_include = true;
		$limit = 1;
		$adtype = 'banner';
		$adtype = 'text';
		include $GLOBALS['path'].'ads/index.php';
		echo '</div>';
		//exit;
	}	
		*/
} ?>

<?php
if (!isset($_SESSION['bo_page_loads'])) $_SESSION['bo_page_loads'] = 1;
$_SESSION['bo_page_loads']++;
if (!isset($_SESSION['adtype_to_display'])) $_SESSION['adtype_to_display'] = 1;
$_SESSION['adtype_to_display'] = $_SESSION['adtype_to_display'] + 1;
$is_ad_include = false; // INITIAL VAR
	// UPDATE TO if ($paychain == true) { // AFTER ALL PAY PAGES UPDATED!
	if ($pageName != 'Profile' && $pageName != 'Buy' && $pageName != 'Make Payment' && $pageName != 'Pay By Credit Card' && $pageName != 'Pay By Bank' && $pageName != 'Pay By Bitcoin' && $do_not_display_ads != true && $paychain != true) { 

		//QQQ CHANGE TO TRUE OR TO GO LIVE!
		if (false && $_SESSION['UserID'] != 1) {
			// SHOW BANNER ADS HERE!!
			// SHOW ADS FROM DB 
			///* // ROTATE TEXT AND BANNER ADS EVENLY -- WE SHOW 1 TEXT AD, THEN 1 BANNER AD, THEN REPEAT
			/*if ($_SESSION['adtype_to_display'] == 1) $adtype = 'text';
			else $adtype = 'banner';
			if ($_SESSION['adtype_to_display'] == 2) $_SESSION['adtype_to_display'] = 0;*/
			
			// WE SHOW 4 TEXT ADS, THEN 1 BANNER AD, THEN REPEAT
			// PIF NOW HAS ABOUT 80 TEXT ADS AND 18 BANNER ADS - SO THIS ( < 5) IS A GOOD RATIO! BUT DOING ( < 11) FOR NOW TO LET TEXT AD MEMBERS GET CAUGHT UP - WITH EQUAL AIR TIME!
			// SHOWING 2 TEXT ADS TO 1 BANNER AD NOW!
			if ($_SESSION['adtype_to_display'] < 4) $adtype = 'text';
			else $adtype = 'banner';
		
			if ($debug == true) echo '<h2>Page Loads '.$_SESSION['bo_page_loads'].' Add type to display '.$_SESSION['adtype_to_display'].' '.$adtype.'</h2>';
			// RESET $_SESSION['adtype_to_display'] AFTER 5 USES!
			//if ($_SESSION['adtype_to_display'] >= 5) $_SESSION['adtype_to_display'] = 0;	

			if ($_SESSION['adtype_to_display'] > 5) $_SESSION['adtype_to_display'] = 0;
			//echo '<div class="col-xs-12" style="background-color:#fff; text-align:center;">';
			$public = false;
			$is_ad_include = true;
			if ($pageName == 'QQQ') $limit = 1;
			else $limit = 1;
			//$adtype = 'banner';
			//$adtype = 'text';
			include $GLOBALS['path'].'ads/index.php';
			//echo '</div><div class="clearfix"> </div>';
			//exit;
			//*/
		}
	}
// ADDED TO TRY TO BALANCE OUT MISSING END DIV COUNT - BUT RUINS LEADERBOARD PAGE
//echo '</div></div></div></div>';
// ADDED CLEARFIX 2/8/24 FOR $pageClass = 'full' ISSUES, BEFORE IT GOT FIXED IN ABOVE CODE. SO THIS MAY NOT BE NEEDED. KEEPING FOR NOW.
//echo '<div class="clearfix"></div>';

?>							
				<?php } 
				if (isset($_SESSION['redirected'])) unset($_SESSION['redirected']);
				// END PAINTING PAGE 
				if (isset($_SESSION['debugQueryDisplay'])) echo $_SESSION['debugQueryDisplay'];
				?>				
                        <!-- END PAGE TITLE-->
                        <!-- END PAGE HEADER-->
					