<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------

if ($cronlock != true) { // DO NOT DISABLE THIS!!
	echo "No cron lock parent. Exiting now!";
	exit;
}
$handshake = 'T'; // FOR CRON LOCK - PROVES THIS FILE RAN!

// IF THIS IS DOMAIN 1, AR LIST 2, THEN IT IS REALLY FOR DOMAIN 2, SO WE CHANGE THE URL HERE.
/*if ($GLOBALS['webpage_url'] == 'https://domain1.com/' && isset($_GET['r']) && $_GET['r'] == 2) {
	$Global['webpage_url'] = 'https://domain2.com/';
}*/
// BE SURE TO SET FALSE WHEN NOT DEBUGGING, FOR SECURITY REASONS
$debug = false;
//$debug = true; // WHEN TRUE, SHOWS VITAL INFO WHEN RUNNING FILE, DOES NOT ALTER ANY OR CHANGE ANY PROCESSES!

$test_mode = false;
//$test_mode = true; // WHEN TRUE, WILL SHOW DEBUGGING (IF $debug IS ALSO TRUE), BUT WILL NOT UPDATE DB, & NOT SEND EMAILS!

// HOW MANY EMAILS TO SEND AT ONCE (MAX)
$limit = 15; // 15 emails every 5 minutes = 180/hr, 4,320/day


$use_phpmailer = false; // NOT YET SUPPORTED IN LATEST AWS!
//use_phpmailer = true;

if ($use_phpmailer == true) {
	include_once './../Lib/phpmailer/class.phpmailer.php';
	//include_once './../Lib/phpmailer5/src/PHPMailer.php';
}
include_once './../Lib/Ar.functions.php';
$date = date("Y-m-d");
$datetime = date("Y-m-d H:i:s");

$extracted_tags = extract_ar_tags($ar_tags); // $AR_TAGS ARRAY IS SET IN Ar.functions.php

// RESET ALL LEADS FOR TESTING! 
//UPDATE `ar_leads` SET `drip_count`='0',`last_dripped_date`='00-00-00 00:00:00' WHERE 1;

/* // HANDY SQL TO FIND SUBSCRIBERS WHO ARE IN BOTH LISTS AR1 AND AR2 (ASSUMES YOU HAVE AN AR2 LIST)
SELECT ar1.ar_leads_email, ar1.ar AS AR1, ar2.ar AS AR2 
FROM `ar_leads` as ar1 JOIN ar_leads as ar2 
WHERE 
ar1.ar_leads_id !=ar2.ar_leads_id
AND
ar1.ar=1
AND
ar2.ar=2
AND
ar1.ar_leads_email=ar2.ar_leads_email
LIMIT 100
*/

// LINK THE LINKS!
function autolink($str, $attributes=array()) {
	$attrs = '';
	foreach ($attributes as $attribute => $value) {
		$attrs .= " {$attribute}=\"{$value}\"";
	}
	$str = ' ' . $str;
	$str = preg_replace('`([^"=\'>])((http|https|ftp)://[^\s<]+[^\s<\.)])`i','$1<a href="$2"'.$attrs.'>$2</a>',$str);
	$str = substr($str, 1);
	return $str;
}

if (isset($_GET['r'])) $ar_list = $_GET['r'];
else $ar_list = 1; 

// Select all emails from ar_master_email, ordered by ar_master_email_timeout ASC
// IF MULTIPLE AR lists, THIS WILL GET ALL EMAILS BY AR!
$arMasterEmails = select(
    'ar_master_email_id, ar_master_email_subject, ar_master_email_text, ar_master_email_timeout, ar_master_email_type', 
    'ar_master_email', 
    [], // No join conditions
    ['ar_master_id' => ['=', $ar_list]],
    null, // No group by
    null, // No having
    'ar_master_email_timeout ASC', // Order by
    0, // No limit
    1 // Show debug
);

$totalDrips = count($arMasterEmails);

// GET THE EMAILS QUEUED FOR SENDING, JOINING AR LEADS AND MEMBERS TABLE FOR SPONSOR INFO
$selectFields = 'ald.*, m.email, m.First_Name, m.Last_Name, m.Username, ml.phone';
$mainTable = [
        'table' => 'ar_leads',
        'as' => 'ald',
];
$joinConditions = [
    [
        'table' => 'members',
        'as' => 'm',
        'condition' => 'm.ID = ald.ID'
    ],
    [
        'table' => 'member_link',
        'as' => 'ml',
        'condition' => 'm.ID = ml.ID',
    ]
];

// Calculate the datetime for 24 hours ago
$dateTime24HoursAgo = date('Y-m-d H:i:s', strtotime('-24 hours'));

$where = [
    'ald.ar_leads_status' => ['=', 1],
    'ald.status' => ['NOT IN', ['bought', 'created']],
    'ald.last_dripped_date' => ['<', $dateTime24HoursAgo], // Only select records older than 24 hours
    'ald.drip_count' => ['<', $totalDrips],
	'ald.ar' => ['=', $ar_list]
];

// LIMIT TO ONE SPECIFIC EMAIL FOR TESTING!
if ($test_mode === true) {
	unset($where['ald.last_dripped_date']); // ALLOWING FOR MULTIPLE TESTS, SAME DAY
	$where['AND']['ald.ar_leads_email'] = ['=', 'jim@directsalesmlm.com'];
	$limit = 1;
}

$groupBy = 'ald.ar_leads_id, ald.ar_leads_email';
$orderBy = 'ald.ar_leads_id ASC';
$show_debug = 1;

$result = select($selectFields, $mainTable, $joinConditions, $where, $groupBy, null, $orderBy, $limit, $show_debug);
					
// 2/13/18 ADDED "LAST DRIPPED DATE" TO EXCLUDE THOSE WHO ALREADY GOT DRIPPED ON TODAY!
// THIS FIXES THE ISSUE OF EMAILING SOMEONE (ALL THEIR FOLLOW UPS ON THE SAME DAY), IN THE EVENT THE CRON DOES NOT RUN FOR ANY PERIOD OF TIME (AND THUS SOME OR ALL OF THEIR ar_link_date's ARE NOW IN THE PAST)

// THIS WAS DONE TO PREVENT UNITENDED MASS MAILINGS OF ALL FOLLOW UP EMAILS AT ONCE, IF THE CRON SHOULD EVER FAIL TO RUN AS INTENDED FOR AN EXTENDED PERIOD, OR BE DISABLED FOR MAINTENANCE, MISSED ON SERVER MOVE, ETC..

// NOTE: THE LEAD EMAILER (ADMIN PANEL) WILL STILL EMAIL ALL LEADS - AS THAT RELIES ON THE "last_run_date" INSTEAD FOR TRACKING MANUAL MAILINGS TO LEADS

// 2/17/23 CHANGED "LAST DRIPPED DATE" FROM DATE TO DATETIME FOR THIS NEW CRON
// ar_link, ar_member_email, ar_member_master TABLES NOW OBSOLETE, NOT USED ANYMORE
// ar_link was used to determine next date to send a drip. ar_member_email, ar_member_master were in place to support a future feature of sponsors having their own ARs, which was never implemented, and deemed a bad idea to let end users alter the brand msg.

if ($debug == true) {
	echo '<p>TEST MODE IS: '.$test_mode.'</p>';
	echo '<b>SELECT QRY LIMIT: '.$limit;
	echo '<br>TOTAL RECORDS: '.count($result);
	echo '</b><p></p>';
}

foreach ($result as $buffer) {
	
	if ($debug == true) {	
		echo '<pre>';	
		//print_r($buffer);
		echo '</pre>';
	}
	
	/* // SUPPORT ADDITIONAL URL FOR 2ND AR
	// INITIALIZE VARS - MUST HAVE FOR EACH LOOP!
	//$Global['administrator_first_name'] = '';
	//$Global['administrator_last_name'] = '';
	//$Global['admin_email'] = 'admin@domain.com';
	//$Global['webpage_url'] = 'https://domain.com/';

	if ($buffer['ar'] == 2) {
		// SPANISH LANGUAGE EMAIL, URL
		// IF ADMIN NAME IS DIFFERENT, PUT IT HERE
		//$Global['administrator_first_name'] = '';
		//$Global['administrator_last_name'] = '';		
		//$Global['admin_email'] = 'admin@yourdomain.com';
		//$Global['webpage_url'] = 'https://yourdomain.com/';
	}*/
	
	$ar_leads_firstname = '';
	$ar_leads_firstname = $buffer['ar_leads_firstname'];
	$ar_leads_id = '';
	$ar_leads_id = $buffer['ar_leads_id'];	
	
    $dripCount = 0; // INI VAR
	$emailToSend = []; // Initialize as an empty array
	
	echo 'LAST DRIPPED DATE: '.$buffer['last_dripped_date'];
	echo '<br>BUFFER DRIP COUNT: '.$buffer['drip_count'].'<br>';

    // Loop through each email in the master email list to find the next one to send
    foreach ($arMasterEmails as $emailDrip) {
		$dripCount++;
		
		if ($dripCount > $buffer['drip_count']) {
			echo '<br>EMAIL DRIP COUNT: '.$dripCount.'<br>';
            // This means the lead is due for this email, according to the timeout and their drip count
            $emailToSend = $emailDrip;
            break; // Exit the loop since we found the email to send
        }
    }
	if (empty($emailToSend)) echo 'No Drip Matches!';	
	else echo 'We Hava Match!';

	// JS UPDATE 8/28/17 WE SET IT AS SENT BEFORE EMAILING, SINCE UNDELIVERABLES BREAK THE CRON, 
	// THUS THEY CANNOT BE MARKED SENT AFTER SENDING, SO WE MARK THEM SENT NOW!
			
	if ($debug == true) {
		echo '<br>SENDING TO '.$buffer['ar_leads_email'];
		echo '<br>UPDATING LAST DRIPPED DATE!';
	}

	//if ($test_mode == false) { // MARK IT AS SENT UPDATE "LAST DRIPPED DATE, DRIP COUNT"
		$data = [
			'last_dripped_date' => $datetime,
			'drip_count' => ['expression' => 'drip_count'.'+ 1']
		];
		$where = [
			'ar_leads_id' => $ar_leads_id
		];
		update('ar_leads', $data, [], $where, 1, 1, 1);
	//}
	
	// CREATE THE UNSUBSCRIBE LINK
	if (strpos($arMasterEmails[0]['ar_master_email_text'], '[unsubscribe_url]') === false) {
		$unsub = str_replace('[link]', '<a href="'.$Global['webpage_url'].'unsubscribe_ar.php?hash='.$buffer['ar_leads_md5'].'">'.$Global['unsubscribe_link_text'].'</a>', $Global['unsubscribe_text']);
	} else {
		$unsub = '';
	}
	
	// SETUP THE LINKS
	$buffer['unsubscribe_url'] = '<a href="'.$Global['webpage_url'].'unsubscribe_ar.php?hash='.$buffer['ar_leads_md5'].'">'.$Global['unsubscribe_link_text'].'</a>';
	// THIS NEXT LINK CONTROLS [join_link]
	$buffer['subscribe_link'] = '<a href="'.$Global['webpage_url'].'join.php?lead='.$buffer['ar_leads_md5'].'">Register Here</a>';
	$buffer['confirm_link'] = '';
	$buffer['website'] = '<a href="'.$Global['webpage_url'].'?id='.$buffer['Username'].'">'.$Global['webpage_url'].'?id='.$buffer['Username'].'</a>';
	$buffer['member_website'] = '<a href="'.$Global['webpage_url'].'?id='.$buffer['Username'].'">Presentation Page</a>';
	
	$to = $buffer['ar_leads_email'];
	$sender_email = $buffer['email'];
	$sender_fname = $buffer['First_Name'];
	$sender_lname = $buffer['Last_Name'];	
	
	$ar_data = create_ar_data($buffer, $ar_tags);

	
	$subject = html_entity_decode($emailToSend['ar_master_email_subject'], ENT_QUOTES, 'UTF-8');
	$subject = replace_ar_tags($subject, $ar_data, $extracted_tags);	
	$message_text = html_entity_decode($emailToSend['ar_master_email_text'], ENT_QUOTES, 'UTF-8');	
	
	//echo 'Message Text Before: '.$message_text."<br/>";
	$message_text = stripslashes(nl2br($message_text));
	//echo 'Message Text After: ';
	//echo $message_text."<br/>AR data: ";
	
	if (!isset($buffer['phone']) || $buffer['phone'] == '') $buffer['phone'] = 'Questions? Please email me. I would love to share my story with you.';
	//if (!isset($buffer['phone'])) $buffer['phone'] = ''; // THIS DOES NOT WORK! IT SHOWS THE TAG INSTEAD! REVERTING TO ABOVE!
	else $buffer['phone'] = preg_replace("/^(\d{3})(\d{3})(\d{4})$/", "$1-$2-$3", $buffer['phone']);
	
	$message_text = autolink($message_text, array("target"=>"_blank","rel"=>"nofollow"));
	//echo nl2br($str); // <a href="http://example.com/" target="_blank" rel="nofollow">http://example.com/</a>	

	$transformed_message = replace_ar_tags($message_text, $ar_data, $extracted_tags);
	
	//$transformed_message = $transformed_message.$unsub;
	//$transformed_message = $transformed_message . "\r\n\r\n\r\n" . $unsub;
	$transformed_message = $transformed_message . '<br><br><br>
	-------------------------------------------------------------------------------------------<br>
This email was sent to you by '.$GLOBALS['webpage_name_short'].'<br>
You opted-in on '.$buffer['ar_leads_date'].' from IP address '.$buffer['ip'].'.<br><br>

To unsubscribe from our mailing list, please click here: '.$unsub;



	/*if ($debug == true) {
		print_r($ar_data);
		echo "<br/>Extracted tags: ";
		print_r($extracted_tags);
		echo "<br/>Transformed Message: ";
		echo $transformed_message;
		echo "<br/>";
		echo 'website '.$buffer['website'];
		echo '<br>';
		echo 'member_website '.$buffer['member_website'];
		//exit;
	}*/

	if ($debug == true) {
		$showing_from = "From: " . $Global['admin_email_heading'] . " " . $Global['admin_email'];
		echo $showing_from;
		echo '<br><br/><div style="text-align:left; margin-left:20px; margin-right:20px;">TO: '.$to.' REPLY TO: '.$sender_email.'<br><br/>';
		echo $subject.'<br><br/>';
		echo $transformed_message.'<br><br/>';
		echo '</div>';
	}
	
	// SEND THE EMAIL
	if ($use_phpmailer === true && $test_mode === false) {
		$mail = new PHPMailer();
		$mail->SetFrom($Global['admin_email'], $Global['admin_email_heading']);
		$mail->AddReplyTo($sender_email, $sender_fname.' '.$sender_lname);
						
		$mail->AddAddress($buffer['ar_leads_email']); // THIS IS THE EMAIL OF THE LEAD!!
		//$mail->AddAddress('Jim.Symonds@automaticwebsoftware.com');
		
		$mail->MsgHTML($transformed_message); // WORKING IN PHPMAILER 5.1 AND PHP VERSION 5.6		
		$mail->Subject = $subject;		
		$mail->WordWrap = 50;
		if ($mail->Send()) {
			if ($debug == true) echo "<br>SENDING MAIL NOW!";
		}		
		if ($debug == true) echo '<br>Mailer Error: ' . $mail->ErrorInfo;
		
	} else if (($test_mode === true && $limit < 3) || ($test_mode === false && $limit > 3)) {
        // Use PHP mail() function
		// EMAIL IS APPARENTLY SENT AS HTML, AS IT SUPPORTS A HREF AND BR TAGS
		$headers = "From: " . $Global['admin_email_heading'] . " <" . $Global['admin_email'] . ">\r\n";
		$headers .= "Reply-To: " . $sender_fname . " " . $sender_lname . " <" . $sender_email . ">\r\n";
		$headers .= "Content-Type: text/html; charset=UTF-8\r\n";

        if (mail($to, $subject, $transformed_message, $headers)) {
			echo 'Email sent successfully.';
		} else {
			echo 'Email sending failed.';
		}		
	}

} // END FOREACH LOOP

if ($debug == true) {
	echo '<br><br><b>MAILING COMPLETE!</b><br>';
}
?>