<?php
// Specify the location of your Exim log
$logFile = '/usr/sbin/exim/exim_mainlog';

// Check if the file exists
if (!file_exists($logFile)) {
    die("File not found");
}

// Read the file
$logContent = file_get_contents($logFile);

// Split the content into lines
$lines = explode("\n", $logContent);

// Array to hold the bounced email addresses
$bouncedEmails = [];

foreach ($lines as $line) {
    // Check if the line contains a bounce message
    if (strpos($line, '**') !== false) {
        // Use a regex to extract the email address
        preg_match('/[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+\.[a-zA-Z0-9-.]+/', $line, $matches);

        // Add the email address to the array
        if (count($matches) > 0) {
            $bouncedEmails[] = $matches[0];
        }
    }
}

// Remove duplicates
$bouncedEmails = array_unique($bouncedEmails);

// Print out the bounced email addresses
foreach ($bouncedEmails as $email) {
    echo $email . "\n";
}
?>