<?php
// Admin hit mark payment button multiple times in some cases, so finding out where

include_once './../../dbconn.php';

echo '<h2>Now Showing Grouped By Logs MARKED BY ADMIN > 1</h2>';

$sql = "
    SELECT log.payment_log_id, m.First_Name, m.Last_Name, log.payer_username, COUNT(*) AS log_count, FROM_UNIXTIME(log.timestamp) AS date
    FROM payment_log as log
    LEFT JOIN members AS m ON m.Username = log.payer_username
    WHERE log.payment_processor = ?
    GROUP BY log.payer_username
    HAVING COUNT(*) > 1";

$stmt = $GLOBALS['db_conn']->prepare($sql);
$ac = "AC";
$stmt->bind_param("s", $ac);
$stmt->execute();
$result = $stmt->get_result();

if ($result && $result->num_rows > 0) {
    echo '<table border="1">';
    echo '<thead>';
    echo '<tr>';
    echo '<th>Payment Log ID</th>';
    echo '<th>First Name</th>';
    echo '<th>Last Name</th>';
    echo '<th>Payer Username</th>';
    echo '<th>Log Count</th>';
    echo '<th>Date</th>';
    echo '</tr>';
    echo '</thead>';
    echo '<tbody>';
$cnt = 0;
    while ($row = $result->fetch_assoc()) {
		$cnt++;
        echo '<tr>';
        echo '<td>' . $row['payment_log_id'] . '</td>';
        echo '<td>' . $row['First_Name'] . '</td>';
        echo '<td>' . $row['Last_Name'] . '</td>';
echo '<td><a href="/admin/Sub/Payment-Logs.php?username=' . $row['payer_username'] . '&prog=1&searchway=username_who_paid&cc_pending=ALL" target="_blank">' . $row['payer_username'] . '</a></td>';
		
        echo '<td>' . $row['log_count'] . '</td>';
        echo '<td>' . $row['date'] . '</td>';
        echo '</tr>';
    }

    echo '</tbody>';
    echo '</table>';
	echo $cnt.' Total Records';
} else {
    echo 'No records found.';
}

?>
