<?php
// COPYRIGHT JIM SYMONDS 2023, AUTOMATIC WEB SOFTWARE / DIRECTSALESMLM.COM
// THIS CRON FINDS NEXT EMAIL TO SEND, WHERE MEMBER IS STILL UNPAID AND NOT CANCELLED
// SELECTS APPROPRIATE EMAIL, CRUNCHES THE DATA FOR THAT EMAIL
// INSERTS THE EMAIL TO SEND INTO send_email QUEUE
// UPDATES members 'send_next' => 'sent', 'sent_last' => $now_str
// RUN THIS CRON EVERY 5 MINS
if ($cronlock != true) {
	echo "No cron lock parent. Exiting now!";
	exit;
}
$handshake = 'T'; // FOR CRON LOCK - PROVES THIS FILE RAN!

// FILE VARS
$admin_sig = $GLOBALS['admin_sig'];
$sitename = $GLOBALS['program_name'];
$leaderboard = $GLOBALS['webpage_url'].'Members/leaderboard_stats.php';
$loginurl = $GLOBALS['webpage_url'].'login-check-enrollee.php?id=[SPONSOR_USERNAME]&login=[USERNAME]';
$program_id = $GLOBALS['powerline_program_id'];
$cutoff_day = $GLOBALS['cutoff_day']; // ONLY SHOWN IN EMAILS
$cutoff_dayOfWeek = $GLOBALS['cutoff_dayOfWeek']; // USED IN THIS FILE.

/* // FOR TESTING ONLY!!
// RESET ALL MEMBER MAILING STATUSES!
UPDATE members
SET send_next = '',
    sent_last = NULL;

// SET ALL MEMBERS TO GET POWERLINE EMAIL NEXT, AND STATUS BACK TO UNPAID (WHERE NOT CANCELLED)!
UPDATE members
SET send_next = 'powerline_email',
    Status = 'unpaid'
WHERE 
	Status != 'Cancelled';
*/
?>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<?php 
$GLOBALS['debug'] = true;

// Force PHP to report all errors
error_reporting(E_ALL); // Leave alone - will log all errors to error.log!
if ($GLOBALS['debug'] === true) ini_set('display_errors', 1); // 1 means "on"
else ini_set('display_errors', 0); // 0 means "off"

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

//date_default_timezone_set('America/Los_Angeles');
//date_default_timezone_set('America/Chicago'); // Central Time
//date_default_timezone_set('America/New_York');
//echo date('Y-m-d H:i:s'); //exit;

//require_once '../../dbconn.php';
//require_once '../../phpcpr.php';
include 'Powerline_emails.inc.php';

$today = date("Y-m-d");
$datetime = date('Y-m-d H:i:s');
$now = new DateTime();
$now_str = $now->format('Y-m-d H:i:s'); // Converts the DateTime object to a string in the 'YYYY-MM-DD HH:MM:SS' format
$dayOfWeek = $now->format('w'); // 0 (for Sunday) through 6 (for Saturday)
$hour = $now->format('G'); // 24-hour format without leading zeros
$minute = $now->format('i');

$selectFields = ['ID', 'sponsorid', 'Username', 'First_Name', 'email', 'Signdate', 'Status', 'send_next', 'unsubscribe_id'];
$mainTable = 'members';
$joinConditions = [];

/* // WORKS WELL - OLD WAY!
$where = [
    'send_next' => [
        ['=', 'cutoff_email'],
        ['=', 'powerline_email'],
        ['=', 'leaderboard_email']
    ],
    'Status' => [
        ['!=', 'Cancelled']
    ],	
    'Status' => [
        ['=', 'unpaid']
    ]
];*/
// unpaid is not cancelled, so this covers both cases!

// NEW WAY - WHEN EMAILS 'send_next' IS DEFINED BY MEMBER STATUS, SO THIS IS FINE (NO NEED TO CHECK STATUS HERE)!
/*$where = [
    'send_next' => [
        ['=', 'cutoff_email'],
        ['=', 'powerline_email'],
        ['=', 'leaderboard_email'],
		
        ['=', 'rookie_email'],
        ['=', 'pro_email'],
        ['=', 'champion_email'],
        ['=', 'legend_email'],	
        ['=', 'sales_email'],
        ['=', 'bonus_email'],
        ['=', 'rockstar_email']		
    ]
];*/
// NEW WAY 8/16/24 - THIS WILL GET ALL EMAILS, AND NO NEED TO UPDATE NEW RANK NAMES NOW!
$where = [
    'send_next' => ['!=', 'sent']
];

$groupBy = null;
$having = null;
$orderBy = 'send_next ASC';
$limit = 500;
//$limit = 10;
$show_debug = 1;

$result = select($selectFields, $mainTable, $joinConditions, $where, $groupBy, $having, $orderBy, $limit, $show_debug);

//echo "GOT TO: " . __LINE__."<BR>";	
if ($debug == true) echo "Count of result: " . count($result) . "<BR>";
$i = 0;

foreach ($result as $row) {
		if ($debug == true) echo "GOT IN FOREACH!  " . __LINE__."<BR>";
		if ($debug == true) echo "Loop iteration: " . $i . "<BR>";

/*	if (is_array($row)) {
		// $row is an array
		$vars = create_vars($row);
		show_array($vars);
		show_vars($vars); // This will print the variables created from create_vars.
	} else {
		echo 'not array'; // Display a message indicating that $row is not an array
		$vars = create_vars($result);
		show_vars($vars);   // This will print the variables created from create_vars.
	}*/

	if ($debug == true) {
		echo '<pre>';
		echo print_r($row);
		echo '</pre>';
	}	
	
	$rank = '';
			
	if ($row['send_next'] == 'cutoff_email') {
		$subject = $cutoff_email_subject;
		$body = $cutoff_email_body;
	} elseif ($row['send_next'] == 'powerline_email') {
		$subject = $powerline_email_subject;
		$body = $powerline_email_body;
	} elseif ($row['send_next'] == 'leaderboard_email') {
		$subject = $leaderboard_email_subject;
		$body = $leaderboard_email_body;
	} elseif ($row['send_next'] == 'sales_email') {
		$subject = $sales_notify_email_subject;
		$body = $sales_notify_email_body;
	} elseif ($row['send_next'] == 'bonus_email') {
		$subject = $bonus_notify_email_subject;
		$body = $bonus_notify_email_body;
		
		// NEW UNIVERSAL WAY TO AUTO DETERMINE RANKS - THE CATCH IS, IF ANY MORE EMAIL (NON RANK) TYPES GET CREATED,
		//THEN THEY MUST GET LISTED AS A COND ABOVE HERE!!
	} elseif (isset($row['send_next']) && substr($row['send_next'], -6) == '_email') {
		$rank = ucfirst(strtolower(substr($row['send_next'], 0, -6)));
		$subject = $rank_email_subject;
		$body = $rank_email_body;
			
	} else { // FAIL SAFE
		if ($debug == true) echo 'BOOB HIT';
		continue;
	}
	
	
	
	// The cutoff email goes out 7 times on weds. 12pm, 4pm, 8pm, 9pm, 10pm, 11pm
	if ($row['send_next'] == 'cutoff_email' && $dayOfWeek == $cutoff_dayOfWeek && in_array($hour, [12, 16, 20, 21, 22, 23])) {

		if ($hour == 12) {
			$subject = "[12HR WARNING] Powerline Cutoff Deadline Tonight";
			$hours_left = 12;
		} elseif ($hour == 16) {
			$subject = "[8HR WARNING] Don't Miss Out -- Deadline Tonight";
			$hours_left = 8;
		} elseif ($hour == 20) {
			$subject = "[4HR WARNING] [FIRSTNAME], you are about to lose all your powerlines";
			$hours_left = 4;
		} elseif ($hour == 21) {
			$subject = "[3HR WARNING] Last Chance, [FIRSTNAME]";
			$hours_left = 3;
		} elseif ($hour == 22) {
			$subject = "[2HR WARNING] [FIRSTNAME], Final notice powerline closes at midnight";
			$hours_left = 2;
		} elseif ($hour == 23 && $minute < 10) {
			$subject = "[1HR WARNING] Going, Going, Gone! 🧳 ✈️";
			$hours_left = 1;
		} elseif ($hour == 23 && $minute >= 10) {
			$subject = "[1HR WARNING] Final Notice Powerline is closing.";
			$hours_left = 1;
		}
	}	
	
	//echo "GOT TO: " . __LINE__;	

	if ($row['send_next'] == 'powerline_email') {
		if ($debug == true) echo 'GOT INTO COUNT UNPAID AND PAID!!<BR>';
		// GET UNPAID COUNT
		$unpaidWhere = [
			'Signdate' => [
				['>', $row['Signdate']]
			],
			'Status' => [
				['=', 'unpaid']
			]
		];
		$limit = 0;
		$unpaid_res = select(['COUNT(ID) AS count'], 'members', [], $unpaidWhere, $groupBy, $having, $orderBy, $limit, $show_debug);
		$unpaid = $unpaid_res[0]['count'];
		//$unpaid = getAssocValue($unpaid_res, 'count');

		// GET PAID COUNT
		$paidWhere = [
			'Signdate' => [
				['>', $row['Signdate']]
			],
			'Status' => [
				['=', 'paid']
			]
		];
		$paid_res = select(['COUNT(ID) AS count'], 'members', [], $paidWhere, $groupBy, $having, $orderBy, $limit, $show_debug);
		$paid = $paid_res[0]['count'];
	} else {
		$unpaid = '';
		$paid = '';
	}
	if ($debug == true) echo 'UNPAID IS: '.$unpaid.'<br>';
	if ($debug == true) echo 'PAID IS: '.$paid.'<br>';
		
	$ID = ''; // INI VAR!
	$ID = $row['ID'];	
	$firstname = $row['First_Name'];
	$sponsor_username = $row['sponsorid'];
	$username = $row['Username'];
	$email = $row['email'];
	$memstatus = $row['Status'];
	$unsub_id = $row['unsubscribe_id'];
	$unsubscribe = $GLOBALS['webpage_url'].'leave.php?id='.$unsub_id;
	if (!isset($hours_left)) {
		$hours_left = 'GOING, GOING, GONE';
	} else if ($hours_left > 1) {
		$hours_left = 'Just '.$hours_left.' HRS LEFT';
	} else {
		$hours_left = 'Just 1 HOUR LEFT';
	}
	//echo "GOT TO: " . __LINE__;

	// ALL SUPPORTED TAGS!
	// Replaces [TAG] with the actual name
	$subject = str_replace("[HOURS_LEFT]", $hours_left, $subject);
	$subject = str_replace("[FIRSTNAME]", $firstname, $subject);
	$subject = str_replace("[UNPAID]", $unpaid, $subject);	
	$subject = str_replace("[RANK]", $rank, $subject);	

	$body = str_replace("[RANK]", $rank, $body);
	$body = str_replace("[HOURS_LEFT]", $hours_left, $body);
	$body = str_replace("[FIRSTNAME]", $firstname, $body);
	$body = str_replace("[LOGINURL]", $loginurl, $body);
	$body = str_replace("[SPONSOR_USERNAME]", $sponsor_username, $body);	
	$body = str_replace("[USERNAME]", $username, $body);
	$body = str_replace("[UNPAID]", $unpaid, $body);
	$body = str_replace("[PAID]", $paid, $body);
	$body = str_replace("[SITENAME]", $sitename, $body);
	$body = str_replace("[EMAIL]", $email, $body);
	$body = str_replace("[ADMIN]", $admin_sig, $body);
	$body = str_replace("[UNSUBSCRIBE]", $unsubscribe, $body);
	$body = str_replace("[TODAY]", $today, $body);
	$body = str_replace("[LEADERBOARD]", $leaderboard, $body);
	$body = str_replace("[CUTOFF_DAY]", $cutoff_day, $body);
	
	// caused issue - likely these are already utf8
	//$subject = utf8_encode($subject);
	//$body = utf8_encode($body);
	
	$insertData = [
		'ID' => $row['ID'],
		'email' => $row['email'],
		'email_subject' => $subject,
		'email_message' => $body,
		'email_date' => $now_str,
		'email_status' => 0,
		'program_id' => $program_id,
		'user_status' => $memstatus,
		'email_sent_date' => ''
	];
	
	if ($debug == true) print_r($insertData);
	

	if (!empty($ID)) {
		
		// IF IT'S A CUTOFF EMAIL, BUT NOW IS NOT CUTOFF DAY ANYMORE, WE SKIP IT! (IT STILL GETS MARKED SENT BELOW)
		if ($row['send_next'] == 'cutoff_email' && $dayOfWeek != $cutoff_dayOfWeek) $skip_email = true;
		else $skip_email = false;
		
		// WE DON'T SEND POWERLINE EMAILS WHEN POWERLINE SYSTEM IS NOT IN USE. FAILSAFE!
		if ($GLOBALS['powerline_program_id'] == 0 && ($row['send_next'] == 'powerline_email' || $row['send_next'] == 'cutoff_email')) $skip_email = true;
		
		//debug_stmt('DOING INSERT', 1);
		// INSERT THE EMAIL TO SEND OUT!
		if ($skip_email === false && !empty($row['email'])) insert('send_email', $insertData, 1, 1);
		
		// UPDATE THE MEMBER RECORD, AS SENT!
		
		// UPDATED 10/28/23 - COMBINED A SALE NOTICE IN THE RANK EMAIL, SINCE SENDING 2 EMAILS, THE SALE NOTICE WAS LATE, BY LIKELY AN HOUR OR MORE.
		// OLD WAY -- THIS 'send_next' FIELD IS A SIMPLE SOLUTION, BUT CAN ONLY HANDLE ONE CONDITION AT A TIME, SO WE DO THIS...
		// IF WE JUST SENT A RANK EMAIL, WE FOLLOW IT WITH A SALES EMAIL (SO THEY DON'T MISS THEIR SALES EMAIL NOTICE)!
		//if ($rank != '') $send_next = 'sales_email'; // WE JUST SENT A RANK EMAIL, THAT MEANS THEY MADE A SALE, SO WE LOAD THAT UP TO SEND NEXT!
		//else $send_next = 'sent';
		
		$send_next = 'sent';
		
		$updateTable = 'members';
		$updateData = [
			'send_next' => $send_next,
			'sent_last' => $now_str
		];
		$updateWhere = [
			'ID' => [
				['=', $row['ID']]
			]
		];
		$limit = 0;
		$live = 1;
		$show_debug = 1;

		update($updateTable, $updateData, [], $updateWhere, $live, $limit, $show_debug);
	}
	$i++;
} // END FOR EACH

// CLEAN UP - IF IT'S NOT CUTOFF DAY NOW (IT'S THE NEXT DAY), AND WE HAVE ANY CUTOFF EMAILS STILL IN QUEUE (DID NOT GET OUT IN TIME) WIPE THEM OUT NOW!
if ($dayOfWeek == $cutoff_dayOfWeek + 1) {
	$where = [
		'email_subject' => [
			['LIKE', '%hr%']
		]
	];

	delete('send_email', [], $where, null, 1, 1, 1);
}
?>
