<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
if ($cronlock != true) {
	echo "No cron lock parent. Exiting now!";
	exit;
}
$handshake = 'T'; // FOR CRON LOCK - PROVES THIS FILE RAN!
//RUN EVERY 5 MINUTES
// THIS CRON WAS CREATED TO CALCULATE AND STORE DATA TO SHOW ON THE SOCIAL PROOF POP UP BUBBLES ON THE FRONT END.
// REASON FOR CREATION - E1UP HIGH TRAFFIC AND LARGE DB CAUSED TOO MUCH SERVER LOAD TO CALCULATE THIS DATA LIVE FOR EACH VISITOR!
// THE SAME DATA GATHERED BY THIS CRON ALSO GETS USED IN THE ADMIN REPORT 30 DAY PERIOD REPORTS 
//(/admin/Sub/Stats_earnings.php?range=30)
/*
CREATE TABLE IF NOT EXISTS `latest_stats` (
  `idx` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `comm_earned_all` int(11) NOT NULL,
  `comm_earned_cc` int(11) NOT NULL,  
  `comm_earned_other` int(11) NOT NULL,
  `comm_earned_man` int(11) NOT NULL,  
  `admin_earned` int(11) NOT NULL, 
  `members_joined` int(11) NOT NULL,  
  `startdate` datetime NOT NULL,
  `enddate` datetime NOT NULL,  
  PRIMARY KEY (`idx`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `latest_signups` (
  `idx` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ID` int(10) NOT NULL,
  `First_Name` varchar(100) DEFAULT NULL,
  `Last_Name` varchar(100) DEFAULT NULL,
  `Signdate` datetime NOT NULL,
  `city` varchar(100) DEFAULT NULL,
  `state` varchar(100) DEFAULT NULL,
  `country` char(2) DEFAULT NULL,
  PRIMARY KEY (`idx`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

ALTER TABLE `latest_stats` ADD `type` VARCHAR(10) NOT NULL AFTER `members_joined`;
//VALUES ARE '1day' or '30day'
*/

$join_limit = date("Y-m-d H:i:s",strtotime("-30 days"));
$startdate = date("Y-m-d H:i:s",strtotime("-30 days"));

// LET'S NOT SHOW 30 DAYS AGO, IF IT IS BEFORE THE INSTALL DATE!
if ($Global['installation_date'] > $join_limit) $join_limit = $Global['installation_date'];
if ($Global['installation_date'] > $startdate) $startdate = $Global['installation_date'];

$enddate = date("Y-m-d H:i:s");
$endday = date("Y-m-d");

//$startday = substr($startdate,0,-9); // WORKS TO GET JUST THE DATE!
//echo $startday;
//exit;

$selectFields = 'COUNT(ID) AS cnt';
$mainTable = 'members';
$where = [
		'AND' => [
			'SignDate' => ['>=', $join_limit]
			]
		];

$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
$bufferj = isset($result[0]) ? $result[0] : '';

$members_joined = $bufferj['cnt'] ?? 0;
//echo $cnt. ' Users Joined us in the last 7 days';

$range_limit = strtotime("-30 days");
$install_date = strtotime($Global['installation_date']);
if ($install_date > $range_limit) $range_limit = $install_date;

$selectFields = 'SUM(log.amount) AS tot_earned';
$mainTable = ['table' => 'payment_log', 'as' => 'log'];
$joinConditions = [
    [
        'table' => 'user_program',
        'as' => 'u',
        'condition' => 'log.user_program_id = u.user_program_id'
    ],
    [
        'table' => 'members',
        'as' => 'm',
        'condition' => 'u.ID = m.ID'
    ]
];
$where = [
    'AND' => [
		'log.timestamp' => ['>=', $range_limit],
        'm.Username' => ['!=', 'admin']
       /* 'log.payment_processor' => ['=', 'E4']*/
    ]
];
$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, 0, 1);
$buffer_earnings = isset($result[0]) ? $result[0] : '';

//echo '<h2>Our Members Gross Earnings (Last 30 Days): $'.number_format($buffer_earnings['tot_earned']).'</h2>';
$comm_earned_plog = $buffer_earnings['tot_earned'] ?? 0;

$selectFields = 'SUM(log.amount) as tot_earned';
$mainTable = ['table' => 'payment_log', 'as' => 'log'];
$joinConditions = [
    [
        'table' => 'user_program',
        'as' => 'u',
        'condition' => 'log.user_program_id = u.user_program_id'
    ],
    [
        'table' => 'members',
        'as' => 'm',
        'condition' => 'u.ID = m.ID'
    ]
];
$where = [
    'AND' => [
		'log.timestamp' => ['>=', $range_limit],
        'm.Username' => ['=', 'admin']
    ]
];

$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, 0, 1);
$buffer_earnings = isset($result[0]) ? $result[0] : '';
//echo '<h2>Our Members Gross Earnings (Last 30 Days): $'.number_format($buffer_earnings['tot_earned']).'</h2>';
$admin_earned = $buffer_earnings['tot_earned'] ?? 0;

if ($Global['use_matrix'] == true) {
	$selectFields = 'SUM(log.amount) AS tot_earned';
	$mainTable = ['table' => 'transactions_log', 'as' => 'log'];
	$where = [
		'AND' => [
			'log.usrid' => ['!=', 1],
			'log.logdate' => ['>=', $startdate],
			/*'log.logdate' => ['<=', $enddate], // NOT SUPPORTED - WILL OVERWRITE STARTDATE - NOT NEEDED ANYWAY - THIS IS TODAY! */
			'log.transtype' => ['=', 'COMM']		
		]
	];

	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
	$buffer_mat_earnings = isset($result[0]) ? $result[0] : '';
	
	$comm_earned_mat = $buffer_mat_earnings['tot_earned'] ?? 0;
	
	$admin_earned = $admin_earned - $comm_earned_mat;
	
} else {
	$comm_earned_mat = 0;
}	

$comm_earned_all = $comm_earned_mat + $comm_earned_plog;

$members_joined = $members_joined ?? 0;
$comm_earned_all = $comm_earned_all ?? 0;
$admin_earned = $admin_earned ?? 0;

if ($comm_earned_all < 0) $comm_earned_all = 0;
if ($admin_earned < 0) $admin_earned = 0;

$data = [
    'members_joined' => $members_joined,
    'comm_earned_all' => $comm_earned_all,
    'admin_earned' => $admin_earned,
    'type' => '30day',
    'startdate' => $startdate,
    'enddate' => $enddate
];
insert('latest_stats', $data, 1, 1);
	
	
$selectFields = 'm.ID, m.First_Name, m.Last_Name, m.Signdate, ml.city, ml.state, ml.country';
$mainTable = ['table' => 'members', 'as' => 'm'];
$joinConditions = [
    [
        'table' => 'member_link',
        'as' => 'ml',
        'condition' => 'm.ID = ml.ID'
    ]
];
$orderBy = 'm.SignDate DESC';
$limit = 20;
$members = select($selectFields, $mainTable, $joinConditions, ['1'], null, null, $orderBy, $limit, 1);

foreach ($members as $buffer) {
    $data = [
        'ID' => $buffer['ID'],
        'First_Name' => $buffer['First_Name'],
        'Last_Name' => $buffer['Last_Name'],
        'Signdate' => $buffer['Signdate'],
        'city' => $buffer['city'],
        'state' => $buffer['state'],
        'country' => $buffer['country']
    ];
    insert('latest_signups', $data, 1, 1);
}


// NOW COUNT LATEST SIGNUPS RECORDS TO SEE IF WE NEED TO PRUNE THEM
$selectFields = ['count(idx) AS qty'];
$mainTable = 'latest_signups';
$result = select($selectFields, $mainTable, [], ['1'], null, null, null, 50, 1);
$buffer_cnt = $result[0] ?? '';


// AUTO PRUNE EARLIER RECORDS
if (isset($buffer_cnt['qty']) && $buffer_cnt['qty'] >= 40) {
    $where = ['1']; // Deleting all
    $limit = 20; // Limiting deletion to 20 rows
    delete('latest_signups', [], $where, 'idx ASC', 1, $limit, 1);
}
	

// DELETE ALL PRIOR RECORDS OF SAME TYPE FOR SAME DAY
$orderBy = 'SignDate DESC';
$limit = 5;
$where = [
    'type' => ['=', '30day'],
    'enddate' => ['<', $enddate]
];

$selectFields = 'Signdate';
$del = select($selectFields, $mainTable, [], ['1'], null, null, $orderBy, $limit, 1);
foreach ($del as $buffer) {

	delete('latest_stats', [], $where, 'idx ASC', 1, $limit, 1);
}	

?>		