function unserialize(data) {
					var error = function (type, msg, filename, line){throw new this.window[type](msg, filename, line);};
					var read_until = function (data, offset, stopchr){
							var buf = [];
							var chr = data.slice(offset, offset + 1);
							var i = 2;
							while (chr != stopchr) {
									if ((i+offset) > data.length) {
											error('Error', 'Invalid');
									}
									buf.push(chr);
									chr = data.slice(offset + (i - 1),offset + i);
									i += 1;
							}
							return [buf.length, buf.join('')];
					};
					var read_chrs = function (data, offset, length){
							var buf;

							buf = [];
							for(var i = 0;i < length;i++){
									var chr = data.slice(offset + (i - 1),offset + i);
									buf.push(chr);
							}
							return [buf.length, buf.join('')];
					};
					var _unserialize = function (data, offset){
							var readdata;
							var readData;
							var chrs = 0;
							var ccount;
							var stringlength;
							var keyandchrs;
							var keys;

							if(!offset) {offset = 0;}
							var dtype = (data.slice(offset, offset + 1)).toLowerCase();

							var dataoffset = offset + 2;
							var typeconvert = new Function('x', 'return x');

							switch(dtype){
									case 'i':
											typeconvert = function (x) {return parseInt(x, 10);};
											readData = read_until(data, dataoffset, ';');
											chrs = readData[0];
											readdata = readData[1];
											dataoffset += chrs + 1;
									break;
									case 'b':
											typeconvert = function (x) {return parseInt(x, 10) !== 0;};
											readData = read_until(data, dataoffset, ';');
											chrs = readData[0];
											readdata = readData[1];
											dataoffset += chrs + 1;
									break;
									case 'd':
											typeconvert = function (x) {return parseFloat(x);};
											readData = read_until(data, dataoffset, ';');
											chrs = readData[0];
											readdata = readData[1];
											dataoffset += chrs + 1;
									break;
									case 'n':
											readdata = null;
									break;
									case 's':
											ccount = read_until(data, dataoffset, ':');
											chrs = ccount[0];
											stringlength = ccount[1];
											dataoffset += chrs + 2;

											readData = read_chrs(data, dataoffset+1, parseInt(stringlength, 10));
											chrs = readData[0];
											readdata = readData[1];
											dataoffset += chrs + 2;
											if(chrs != parseInt(stringlength, 10) && chrs != readdata.length){
													error('SyntaxError', 'String length mismatch');
											}
									break;
									case 'a':
											readdata = {};

											keyandchrs = read_until(data, dataoffset, ':');
											chrs = keyandchrs[0];
											keys = keyandchrs[1];
											dataoffset += chrs + 2;

											for(var i = 0;i < parseInt(keys, 10);i++){
													var kprops = _unserialize(data, dataoffset);
													var kchrs = kprops[1];
													var key = kprops[2];
													dataoffset += kchrs;

													var vprops = _unserialize(data, dataoffset);
													var vchrs = vprops[1];
													var value = vprops[2];
													dataoffset += vchrs;

													readdata[key] = value;
											}

											dataoffset += 1;
									break;
									default:
											error('SyntaxError', 'Unknown / Unhandled data type(s): ' + dtype);
									break;
							}
							return [dtype, dataoffset - offset, typeconvert(readdata)];
					};

					return _unserialize((data+''), 0)[2];
			}

	function serialize(mixed_value ) {
			var _getType = function( inp ) {
					var type = typeof inp, match;
					var key;
					if (type == 'object' && !inp) {
							return 'null';
					}
					if (type == "object") {
							if (!inp.constructor) {
									return 'object';
							}
							var cons = inp.constructor.toString();
							match = cons.match(/(\w+)\(/);
							if (match) {
									cons = match[1].toLowerCase();
							}
							var types = ["boolean", "number", "string", "array"];
							for (key in types) {
									if (cons == types[key]) {
											type = types[key];
											break;
									}
							}
					}
					return type;
			};
			var type = _getType(mixed_value);
			var val, ktype = '';

			switch (type) {
					case "function":
							val = "";
							break;
					case "boolean":
							val = "b:" + (mixed_value ? "1" : "0");
							break;
					case "number":
							val = (Math.round(mixed_value) == mixed_value ? "i" : "d") + ":" + mixed_value;
							break;
					case "string":
							val = "s:" + encodeURIComponent(mixed_value).replace(/%../g, 'x').length + ":\"" + mixed_value + "\"";
							break;
					case "array":
					case "object":
							val = "a";
							/*
							if (type == "object") {
									var objname = mixed_value.constructor.toString().match(/(\w+)\(\)/);
									if (objname == undefined) {
											return;
									}
									objname[1] = serialize(objname[1]);
									val = "O" + objname[1].substring(1, objname[1].length - 1);
							}
							*/
							var count = 0;
							var vals = "";
							var okey;
							var key;
							for (key in mixed_value) {
									ktype = _getType(mixed_value[key]);
									if (ktype == "function") {
											continue;
									}

									okey = (key.match(/^[0-9]+$/) ? parseInt(key, 10) : key);
									vals += serialize(okey) +
													serialize(mixed_value[key]);
									count++;
							}
							val += ":" + count + ":{" + vals + "}";
							break;
					case "undefined": // Fall-through
					default: // if the JS object has a property which contains a null value, the string cannot be unserialized by PHP
							val = "N";
							break;
			}
			if (type != "object" && type != "array") {
					val += ";";
			}
			return val;
	}

function print_r( array, return_val ) {
    // Prints out or returns information about the specified variable
    //
    // version: 906.801
    // discuss at: http://phpjs.org/functions/print_r
    // +   original by: Michael White (http://getsprink.com)
    // +   improved by: Ben Bryan
    // +      input by: Brett Zamir (http://brett-zamir.me)
    // +      improved by: Brett Zamir (http://brett-zamir.me)
    // +   improved by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
    // -    depends on: echo
    // *     example 1: print_r(1, true);
    // *     returns 1: 1

    var output = "", pad_char = " ", pad_val = 4, d = this.window.document;
    var getFuncName = function (fn) {
        var name = (/\W*function\s+([\w\$]+)\s*\(/).exec(fn);
        if(!name) {
            return '(Anonymous)';
        }
        return name[1];
    };

    var repeat_char = function (len, pad_char) {
        var str = "";
        for(var i=0; i < len; i++) {
            str += pad_char;
        }
        return str;
    };

    var formatArray = function (obj, cur_depth, pad_val, pad_char) {
        if (cur_depth > 0) {
            cur_depth++;
        }

        var base_pad = repeat_char(pad_val*cur_depth, pad_char);
        var thick_pad = repeat_char(pad_val*(cur_depth+1), pad_char);
        var str = "";

        if (typeof obj === 'object' && obj !== null && obj.constructor && getFuncName(obj.constructor) !== 'PHPJS_Resource') {
            str += "Array\n" + base_pad + "(\n";
            for (var key in obj) {
							
                if (obj[key] instanceof Array) {
                    str += thick_pad + "["+key+"] => "+formatArray(obj[key], cur_depth+1, pad_val, pad_char);
                } else {
                    str += thick_pad + "["+key+"] => " + obj[key] + "\n";
                }
            }
            str += base_pad + ")\n";
        } else if(obj === null || obj === undefined) {
            str = '';
        } else { // for our "resource" class
            str = obj.toString();
        }

        return str;
    };

    output = formatArray(array, 0, pad_val, pad_char);

    if (return_val !== true) {
        if (d.body) {
            alert(output);
        }
        else {
            try {
                d = XULDocument; // We're in XUL, so appending as plain text won't work; trigger an error out of XUL
                this.echo('<pre xmlns="http://www.w3.org/1999/xhtml" style="white-space:pre;">'+output+'</pre>');
            }
            catch(e) {
                alert(output); // Outputting as plain text may work in some plain XML
            }
        }
        return true;
    } else {
        return output;
    }
}

/**
 * jQuery Builder Plugin
 * Copyright (c) 2009 Nikolay Kolev, Kaizen Web-Productions (http://www.kaizen-web.com)
 * Copyright notice and license must remain intact for legal use
 * Version 0.1
 */
(function($){
	$.fn.formcreator = function(options) {

		// Extend the configuration options with user-provided
		var defaults = {
			elements: false,
			wrapper: false,
			product_id: false,
			populated_values: false
		};
		var opts = $.extend(defaults, options);

		return this.each(function() {
			var ul_obj 		= this;
			var elements = {};
			var wrapper_name = 'default_name';
			var product_id = 0;
			var populated_values = {};

			/**
			 * Count the number of properties in an object
			 */
			var count = function(myobj) {
				var count = 0;
				for (k in myobj) {
					if (myobj.hasOwnProperty(k)) {
						count++;
						}
					}
				return count;
				}

			var makeName = function(post_name, field_id, option_id) {
				var tmp = wrapper_name+'['+product_id+']['+field_id+']';

				if (option_id) {
					tmp = tmp + '['+option_id+']';
					}
				return tmp;
				}

			var returnValue = function(fld_id, default_value) {
				if (populated_values[fld_id] || populated_values[fld_id] == '') {
					return populated_values[fld_id];
					}
				return default_value;
				}

			var returnChecked = function(fld_id, default_value, option_id, value_fld, select_str) {
				var value = default_value;
				var i;

				if (populated_values[fld_id]) {

					//if this is a checkbox we check whether the option exists
					if (option_id) {

							//iterate through the checks and see if we have a match with the value
							value = false;
							if (typeof populated_values[fld_id] === 'object') {
								for(i in populated_values[fld_id]) {
									if (populated_values[fld_id][i] == value_fld) {
										value = true;
										break;
										}
									}
								}
							else if (populated_values[fld_id] == value_fld) {
								value = true;
								}
						}

					//if it's a radio we check whether this is the selected radio'
					else if (populated_values[fld_id] == value_fld) {
						value = true;
						}
					else {
						value = false;
						}
					}
				else if (count(populated_values) > 0) {
					value = false;
					}

				if (value) {
					if (select_str) {
						return 'selected="selected"';
						}
					else {
						return 'checked="checked"';
						}
					}
				else {
					return '';
					}
				}

			var drawElement = function(elem, where) {
				switch(elem['type']){
					case 'input_text':
						loadInputText(elem, where);
						break;
					case 'link':
						loadLink(elem, where);
						break;
					case 'textarea':
						loadTextArea(elem, where);
						break;
					case 'checkbox':
						loadCheckbox(elem, where);
						break;
					case 'radio':
						loadRadios(elem, where);
						break;
					case 'select':
						loadSelect(elem, where);
						break;
					}
				}

			var loadElements = function(elems, where) {
				var i;
				for(i in elems) {
					drawElement(elems[i], where);
					}
				}

			var loadMasters = function(masters, where) {
				var i;
				for(i in masters) {
					$('#'+where).append('<fieldset><legend>'+masters[i]['name']+'</legend><div id="form-creator'+masters[i]['id']+'"><!-- --></div></fieldset>');
					loadElements(unserialize(masters[i]['fields']), 'form-creator'+masters[i]['id']);
					}
				}

			var loadInputText = function(elem, where) {
				addFld(elem, '<label>'+elem['label']+'</label> <input type="text" name="'+makeName(elem['post_name'], elem['id'])+'" value="'+returnValue(elem['id'], elem['value'])+'" />', where);
				}

			var loadLink = function(elem, where) {
				addFld(elem, '<a href="'+elem['value']+'" '+(elem['blank'] == 1?'target="_blank"':'')+'>'+elem['label']+'</a>', where);
				}

			var loadTextArea = function(elem, where) {
				addFld(elem, '<label>'+elem['label']+'</label> <textarea name="'+makeName(elem['post_name'], elem['id'])+'">'+returnValue(elem['id'], elem['value'])+'</textarea>', where);
				}

			//create a checkbox
			var loadCheckbox = function(elem, where) {

				var txt = '<fieldset><legend>'+elem['label']+'</legend>', tmp, i;
				for(i in elem['checks']) {
					tmp = returnChecked(elem['id'], elem['checks'][i]['checked'], elem['checks'][i]['id'], elem['checks'][i]['value']);
					txt = txt + '<input rel="'+i+'" id="check_elem_'+elem['checks'][i]['id']+'" type="checkbox" name="'+makeName(elem['post_name'], elem['id'], elem['checks'][i]['id'])+'" value="'+elem['checks'][i]['value']+'" '+tmp+' /> <label>'+elem['checks'][i]['label']+'</label><div id="parent_id_'+elem['checks'][i]['id']+'"><!-- --></div><br />';
					}

				txt = txt + '</fieldset>';

				addFld(elem, txt, where);

				assignMultipleElementCreate(elem['checks'], elem['id']);
				}

			//for each checkbox element bind an event to populate their subelements
			var assignMultipleElementCreate = function(checks, parent_id) {
				var i;
				for(i in checks) {
					$('#check_elem_'+checks[i]['id']).bind('click', function() {
						$('#parent_id_'+checks[$(this).attr('rel')]['id']).html('');
						if ($(this).is(':checked')) {
							loadElements(checks[$(this).attr('rel')]['elements'], 'parent_id_'+checks[$(this).attr('rel')]['id']);
							}
						});
					if (returnChecked(parent_id, checks[i]['checked'], checks[i]['id'], checks[i]['value']) != '') {
						loadElements(checks[i]['elements'], 'parent_id_'+checks[i]['id']);
						}
					}
				}

			//create radiodbox element
			var loadRadios = function(elem, where) {

				var txt = '<fieldset><legend>'+elem['label']+'</legend>', i;
				for(i in elem['checks']) {
					txt = txt + '<input rel="'+i+'" id="check_elem_'+elem['checks'][i]['id']+'" type="radio" name="'+makeName(elem['post_name'], elem['id'])+'" value="'+elem['checks'][i]['value']+'" '+returnChecked(elem['id'], elem['checks'][i]['checked'], false, elem['checks'][i]['value'])+' /> <label>'+elem['checks'][i]['label']+'</label><br />';
					}
				txt = txt + '<div id="iparent_id_'+elem['id']+'"><!-- --></div></fieldset>';

				addFld(elem, txt, where);

				assignSingleElementCreate(elem['checks'], elem['id']);
				}

			//for all radios bind an event to populate with their subelements
			var assignSingleElementCreate = function(checks, parent_id) {
				var i;
				for(i in checks) {
					$('#check_elem_'+checks[i]['id']).bind('click', function() {
						$('#iparent_id_'+parent_id).html('');
						loadElements(checks[$(this).attr('rel')]['elements'], 'iparent_id_'+parent_id);
						});
					if (returnChecked(parent_id, checks[i]['checked'], false, checks[i]['value']) != '') {
						loadElements(checks[i]['elements'], 'iparent_id_'+parent_id);
						}
					}
				}

			//creates a select box
			var loadSelect = function(elem, where) {

				var i;

				var txt = '<fieldset><legend>'+elem['label']+'</legend><select id="sel_elem_'+elem['id']+'" name="'+makeName(elem['post_name'], elem['id'])+'">';
				for(i in elem['checks']) {
					txt = txt + '<option value="'+elem['checks'][i]['value']+'" '+returnChecked(elem['id'], elem['checks'][i]['checked'], false, elem['checks'][i]['value'], true)+'>'+elem['checks'][i]['label']+'</option>';
					}
				txt = txt + '</select><div id="iparent_id_'+elem['id']+'"><!-- --></div></fieldset>';

				addFld(elem, txt, where);

				//bind on onchange event for the select to populate the subelements
				$('#sel_elem_'+elem['id']).bind('change', function() {
					$('#iparent_id_'+elem['id']).html('');
					loadElements(elem['checks'][this.selectedIndex+1]['elements'], 'iparent_id_'+elem['id']);
					});

				//if we have a selected element then populate with subelements
				for(i in elem['checks']) {
					if (returnChecked(elem['id'], elem['checks'][i]['checked'], false, elem['checks'][i]['value']) != '') {
						loadElements(elem['checks'][i]['elements'], 'iparent_id_'+elem['id']);
						}
					}
				}

			var addFld = function(elem, txt, where) {
				$('#'+where).append('<div id="elem_id_"'+elem['id']+'">'+txt+'</div>');
				}

			if(opts.wrapper){
				wrapper_name = opts.wrapper;
				}

			if(opts.product_id){
				product_id = opts.product_id;
				}

			if (opts.populated_values) {
				populated_values = unserialize(opts.populated_values);
				if (count(populated_values) == 0) {
					populated_values[0] = 0;
					}
				}

			//load the initial values
			if(opts.elements){
				elements = opts.elements;
				loadMasters(elements, $(this).attr('id'));

				//remove the populated values so that the fields won't be filled with them any more'
				populated_values = {};
				}
		});
	};
})(jQuery);