function updateTier(total, newPlan) {

	var totalPlan = document.getElementById("total_plans").value;

	var totalTier = document.getElementById("total_tiers");

	

	if (newPlan === true) totalPlans = parseInt(totalPlan) + 1;

	else totalPlans = parseInt(totalPlan);

	

	var paidValue = 0;

	var unpaidValue = 0;



	for (var key=0;key < totalPlans;key++) {

		var div = document.getElementById("tiers_table_"+key);

		var newTbody = document.createElement("tbody");	

		

		var paid = new Array();

		var unpaid = new Array();

		

		if (key < totalPlan && parseInt(totalTier.value) > 0) {

			/*Fetch the current values, then clear the table*/

			for (var nr=0;nr < parseInt(totalTier.value);nr++) {

				var tierPaid = document.getElementById("plan_tier_amount_paid_"+key+"_"+nr);

				var tierUnpaid = document.getElementById("plan_tier_amount_unpaid_"+key+"_"+nr);

			

				paid[nr] = tierPaid.value;

				unpaid[nr] = tierUnpaid.value;

			} 

			

			remove(div);

		}

		

		for (var nr=0;nr < total;nr++) {

			if (typeof(paid[nr]) != 'undefined') paidValue = paid[nr];

			else paidValue = 0;

			

			if (typeof(unpaid[nr]) != 'undefined') unpaidValue = unpaid[nr];

			else unpaidValue = 0;

			

			newTbody = createTier(newTbody, key, nr, paidValue, unpaidValue);

		}

		

		div.appendChild(newTbody);

	}

	

	totalTier.value = total;

}

	

function createTier(div, key, nr, paidValue, unpaidValue) {

	var newTr = document.createElement("tr");

	var newTd = document.createElement("td");

	var newTd2 = document.createElement("td");

	var newInput = document.createElement("input");

	var newInput2 = document.createElement("input");

	var newText = document.createTextNode("Level "+(nr+1)+":");

	var newText2 = document.createTextNode(" (Paid)");

	var newText3 = document.createTextNode(" (Unpaid)");

	var newBr = document.createElement("br");

	

	newInput.name = 'plan_tier_amount_paid['+key+'][]';

	newInput.id = 'plan_tier_amount_paid_'+key+'_'+nr;

	newInput.value = paidValue;



	newInput2.name = 'plan_tier_amount_unpaid['+key+'][]';

	newInput2.id = 'plan_tier_amount_unpaid_'+key+'_'+nr;

	newInput2.value = unpaidValue;

	

	newTd.className = 'addProgramLeft';

	newTd2.width = '380px';

	

	newTd.appendChild(newText);

	newTd2.appendChild(newInput);

	newTd2.appendChild(newText2);

	newTd2.appendChild(newBr);

	newTd2.appendChild(newInput2);

	newTd2.appendChild(newText3);



	newTr.appendChild(newTd);

	newTr.appendChild(newTd2);

	

	div.appendChild(newTr);



	return div;

}



function updateMatchPowerline(total, newPlan) {

	var totalPlan = parseInt(document.getElementById("total_plans").value);

	var totalMatch = document.getElementById("total_match");

	

	if (newPlan === true) totalPlans = totalPlan + 1;

	else totalPlans = totalPlan;

	

	var matchValue = 0;

	

	for (var key=0;key < totalPlans;key++) {

		var div = document.getElementById("match_table_"+key);

		var newTbody = document.createElement("tbody");	

		

		var match = new Array();

		

		if (key < totalPlan && parseInt(totalMatch.value) > 0) {

			/*Fetch the current values, then clear the table*/

			for (var nr=0;nr < parseInt(totalMatch.value);nr++) {

				var matchPaid = document.getElementById("plan_bonus_amount_"+key+"_"+nr);

				

				match[nr] = parseFloat(matchPaid.value);

			} 

			

			remove(div);

		}

		

		for (var nr=0;nr < total;nr++) {			

			if (typeof(match[nr]) != 'undefined') matchValue = match[nr];

			else matchValue = 0;

		

			newTbody = createMatchPowerline(newTbody, key, nr, matchValue);

		}

		

		div.appendChild(newTbody);

	}

	

	totalMatch.value = total;

}

	

function createMatchPowerline(div, key, nr, matchValue) {

	var newTr = document.createElement("tr");

	var newTd = document.createElement("td");

	var newTd2 = document.createElement("td");

	var newInput = document.createElement("input");

	var newText = document.createTextNode("Level "+(nr+1)+":");

	

	newInput.name = 'plan_bonus_amount['+key+'][]';

	newInput.id = 'plan_bonus_amount_'+key+'_'+nr;

	newInput.value = matchValue;

	

	newTd.className = 'addProgramLeft';

	newTd2.width = '380px';

	

	newTd.appendChild(newText);

	newTd2.appendChild(newInput);



	newTr.appendChild(newTd);

	newTr.appendChild(newTd2);

	

	div.appendChild(newTr);



	return div;

}	



function addPlan() {

	var realKey = document.getElementById("total_plans");

	var key = parseInt(realKey.value) + 1;

	var div = document.getElementById("additional_plans");

	

	var newTable = document.createElement("table");

	var newTbody = document.createElement("tbody");	

	

	var selectYesValue = new Array();

	var selectYesName = new Array();

	

	selectYesValue[0] = 'N';

	selectYesValue[1] = 'Y';

	selectYesName[0] = language['no'];

	selectYesName[1] = language['yes'];

	

	var selectTypeValue = new Array();

	var selectTypeName = new Array();

	

	selectTypeValue[0] = 'N';

	selectTypeValue[1] = 'Y';

	selectTypeName[0] = language['normal'];

	selectTypeName[1] = language['subscription'];

	

	var selectShowSubValue = new Array();

	var selectShowSubName = new Array();

	

	selectShowSubValue[0] = 'B';

	selectShowSubValue[1] = 'N';

	selectShowSubValue[2] = 'S';

	selectShowSubName[0] = language['both'];

	selectShowSubName[1] = language['normal'];

	selectShowSubName[2] = language['subscription'];

	

	var newTable = document.createElement("table");

	var newTbody = document.createElement("tbody");	

	

	



	

		

	

	var newTr = document.createElement("tr");

	var newTd = document.createElement("td");

	var newTd2 = document.createElement("td");

	var newStrong = document.createElement("strong");

	var newTitle = document.createTextNode("Payment Plan "+key+":");

	

	newStrong.appendChild(newTitle);

	

	newTd.className = 'addProgramLeft';

	newTd2.width = '380px';

	

	newTd.appendChild(newStrong); 

	

	newTr.appendChild(newTd);

	newTr.appendChild(newTd2);

	

	newTbody.appendChild(newTr);

	

	newTbody = createInput(newTbody, language['payment_name'], 'plan_name[]', false, language['payment_name_note']);

	

	

	

	newTbody = createInput(newTbody, language['payment_invoice'], 'plan_processpor[]', false, language['payment_invoice_note']);

	

	newTbody = createSelect(newTbody, language['payment_type'], 'plan_type[]', false, selectTypeName, selectTypeValue);

	

	newTbody = createInput(newTbody, language['payment_period'], 'plan_period[]', language['payment_period_text'], language['payment_period_note']);

	

	newTbody = createSelect(newTbody, language['payment_tier_type'], 'plan_tier_type[]', language['payment_tier_type_note'], selectTypeName, selectTypeValue);

	

	newTable.className = 'addProgramTable';

	

	newTable.appendChild(newTbody);

	

	div.appendChild(newTable);



	var newTable = document.createElement("table");

	

	newTable.id = 'tiers_table_'+realKey.value;

	newTable.className = 'addProgramTable';

	

	div.appendChild(newTable);

	

	var newTable = document.createElement("table");

	var newTbody = document.createElement("tbody");	

	

	newTbody = createSelect(newTbody, language['payment_powerline_type'], 'plan_powerline_type[]', false, selectTypeName, selectTypeValue);

	

	newTbody = createInput(newTbody, language['payment_powerline_amount'], 'plan_powerline_amount[]', language['payment_powerline_amount_text'], false);

	

	newTbody = createSelect(newTbody, language['payment_qualify'], 'plan_qualify_type[]', language['payment_qualify_note'], selectTypeName, selectTypeValue);

	

	newTbody = createInput(newTbody, language['payment_qualify_amount'], 'plan_qualify_amount[]', false, language['payment_qualify_amount_note']);

	

	newTbody = createInput(newTbody, language['payment_qualified_amount'], 'plan_qualified_amount[]', false, language['payment_qualified_amount_note']);

	

	newTbody = createSelect(newTbody, language['payment_match'], 'plan_bonus_type[]', false, selectTypeName, selectTypeValue);

	

	newTable.className = 'addProgramTable';

	

	newTable.appendChild(newTbody);

	

	div.appendChild(newTable);

	

	var newTable = document.createElement("table");

	

	newTable.id = 'match_table_'+realKey.value;

	newTable.className = 'addProgramTable';

	

	div.appendChild(newTable);

	

	var newTable = document.createElement("table");

	var newTbody = document.createElement("tbody");	

	

	newTbody = createInput(newTbody, language['payment_admin_normal'], 'plan_admin_normal[]', language['payment_admin_normal_text'], false);

	

	newTbody = createInput(newTbody, language['payment_admin_sub'], 'plan_admin_sub[]', language['payment_admin_sub_text'], language['payment_admin_sub_note']);

	

	newTbody = createInput(newTbody, language['payment_total'], 'plan_total_amount[]', false, language['payment_total_note']);

	

	newTbody = createSelect(newTbody, language['payment_show_sub'], 'plan_show_sub[]', language['payment_show_sub_note'], selectShowSubName, selectShowSubValue);

	

	newTbody = createSelect(newTbody, language['payment_enabled'], 'plan_enabled[]', false, selectYesName, selectYesValue);

	

	newTable.className = 'addProgramTable';

	

	newTable.appendChild(newTbody);

	

	div.appendChild(newTable);

	

	var tierTotal = parseInt(document.getElementById("total_tiers").value);

	var matchTotal = parseInt(document.getElementById("total_match").value);

	

	if (tierTotal > 0) updateTier(tierTotal, true);

	if (matchTotal > 0) updateMatchPowerline(matchTotal, true);

	

	realKey.value = key;

	}

	

function createInput(div, title, name, text, note) {

	var newTr = document.createElement("tr");

	var newTd = document.createElement("td");

	var newTd2 = document.createElement("td");

	var newTitle = document.createTextNode(title+":");

	var newInput = document.createElement("input");

	

	newInput.name = name;

	newInput.type = 'text';

	

	newTd.className = 'addProgramLeft';

	newTd2.className = 'addProgramRight';

	

	newTd.appendChild(newTitle);

	

	newTd2.appendChild(newInput);	

		

	if (text !== false) {

		var newText = document.createTextNode(" "+text);

		

		newTd2.appendChild(newText);

	}

	

	if (note !== false) {

		var newBr = document.createElement("br");

		var newFont = document.createElement("span");

		var newNote = document.createTextNode(note);

		

		newFont.className = 'addProgramNote';

		

		newFont.appendChild(newNote);

		

		newTd2.appendChild(newBr);

		newTd2.appendChild(newFont);

	}

	

	newTr.appendChild(newTd);

	newTr.appendChild(newTd2);



	div.appendChild(newTr);

	

	return div;

}



function createSelect(div, title, name, note, valueName, value) {

	var newTr = document.createElement("tr");

	var newTd = document.createElement("td");

	var newTd2 = document.createElement("td");

	var newTitle = document.createTextNode(title+":");

	var newSelect = document.createElement("select");

	

	newSelect.name = name;

	

	for (var nr=0;nr<value.length;nr++) {

		newSelect.options[nr] = new Option(valueName[nr], value[nr]);

	}

	

	newTd.className = 'addProgramLeft';

	newTd2.className = 'addProgramRight';

	

	newTd.appendChild(newTitle);

	

	newTd2.appendChild(newSelect);	

	

	if (note !== false) {

		var newBr = document.createElement("br");

		var newFont = document.createElement("span");

		var newNote = document.createTextNode(note);

		

		newFont.className = 'addProgramNote';

		

		newFont.appendChild(newNote);

		

		newTd2.appendChild(newBr);

		newTd2.appendChild(newFont);

	}

	

	newTr.appendChild(newTd);

	newTr.appendChild(newTd2);



	div.appendChild(newTr);

	

	return div;

}