<?php

	$Global['field_types'] = array('I'=>'input_text', 'TA'=>'textarea', 'S'=>'select', 'R'=>'radio', 'C'=>'checkbox', 'L'=>'link');
	$Global['field_types_reverse'] = array('input_text'=>'I', 'textarea'=>'TA', 'select'=>'S', 'radio'=>'R', 'checkbox'=>'C', 'link'=>'L');
	$Global['field_multiple'] = array('S', 'R', 'C');

	/**
	 * From the passed serialized data we validate
	 * it to see if it's ok
	 *
	 * @param string $field
	 * @return bool
	 */
	function validate_field_data($field) {
		$field_array = unserialize($field);

		if ($field_array === false) {
			return false;
			}

		return true;
		}

	/**
	 * Fills in the $master array recursively with data
	 * from the trigger fields
	 *
	 * @param array $master
	 * @param int $parent_value
	 * @param int $ar_id
	 */
	function get_children_fields(&$master, $parent_value, $ar_id) {

		global $Global;

		$result = mysql_query("SELECT 
														imaster.*
														, opt.*
														, ifields.*
													 FROM 
														ar_form_master as imaster
														INNER JOIN ar_form_fields as ifields
															USING (form_master_id) 
														LEFT JOIN ar_form_options as opt
															ON (ifields.form_fields_id=opt.form_fields_id)
													 WHERE
														imaster.ar_id='$ar_id'
														AND ifields.form_fields_trigger='$parent_value'
													 ORDER BY
														ifields.form_fields_level ASC
														, ifields.form_fields_order ASC
														, opt.form_options_order ASC
													") or die(mysql_error());

		$number = 0;
		$processed_fields = array();

		while ($buffer = mysql_fetch_assoc($result)) {
			if (!isset($processed_fields[$buffer['form_fields_id']])) {
				$processed_fields[$buffer['form_fields_id']] = true;

				++$number;

				$master[$number]['id'] = $buffer['form_fields_id'];
				$master[$number]['order'] = $number;
				$master[$number]['post_name'] = $buffer['form_fields_name'];
				$master[$number]['label'] = $buffer['form_fields_desc'];
				$master[$number]['required'] = ($buffer['form_fields_required'] == 'Y')?true:false;
				$master[$number]['type'] = $Global['field_types'][$buffer['form_fields_type']];

				//if it's multiple choice control
				if (in_array($buffer['form_fields_type'], $Global['field_multiple'])) {
					$master[$number]['checks'] = array();

					$inner_number = 1;
					}
				}

			if (!in_array($buffer['form_fields_type'], $Global['field_multiple'])) {
				$master[$number]['value'] = $buffer['form_options_value'];

				if ($buffer['form_options'] & 1) {
					$master[$number]['blank'] = 1;
					}
				}
			else {
				$master[$number]['checks'][$inner_number]['id'] = $buffer['form_options_id'];
				$master[$number]['checks'][$inner_number]['parent_order'] = $number;
				$master[$number]['checks'][$inner_number]['order'] = $inner_number;
				$master[$number]['checks'][$inner_number]['post_name'] = $buffer['form_fields_name'];
				$master[$number]['checks'][$inner_number]['label'] = $buffer['form_options_name'];
				$master[$number]['checks'][$inner_number]['value'] = $buffer['form_options_value'];
				$master[$number]['checks'][$inner_number]['checked'] = ($buffer['form_options_selected']=='Y')?true:false;
				$master[$number]['checks'][$inner_number]['elements'] = array();

				get_children_fields($master[$number]['checks'][$inner_number]['elements'], $buffer['form_options_id'], $ar_id);

				++$inner_number;
				}
			}
		}

	/**
	 * For a given order we return the values in the form of a repopulation
	 * array for all the fields the user has saved values
	 *
	 * @param int $order_id
	 * @return array
	 */
	function get_form_info_fields($order_id) {
		$query = 'SELECT fm.leads_id, fi.*
								FROM
									ar_form_info fi
									INNER JOIN ar_form_fields ff
										USING(form_fields_id)
									INNER JOIN ar_form_master fm
										USING(form_master_id)
								WHERE fi.orders_id=\''.$order_id.'\'
								ORDER BY
									fm.leads_id ASC
									, fm.form_master_id ASC
									, ff.form_fields_level ASC
									, ff.form_fields_order ASC
';
		$result = mysql_query($query) or die(mysql_error());

		$flds = array();
		while ($buffer = mysql_fetch_assoc($result)) {
			if (isset($flds[$buffer['leads_id']]) && isset($flds[$buffer['leads_id']][$buffer['form_fields_id']])) {
				if (!is_array($flds[$buffer['leads_id']][$buffer['form_fields_id']])) {
					$flds[$buffer['leads_id']][$buffer['form_fields_id']] = array($flds[$buffer['leads_id']][$buffer['form_fields_id']]);
				}
				$flds[$buffer['leads_id']][$buffer['form_fields_id']][] = $buffer['form_info_value'];
				}
			else {
				$flds[$buffer['leads_id']][$buffer['form_fields_id']] = $buffer['form_info_value'];
				}
			}
		return $flds;
		}

	/**
	 * Validates if all the passed fields are valid
	 * If they $error var would contain the error message
	 *
	 * @param int $ar_id
	 * @param array $prod_flds
	 * @return bool
	 */
	function validate_user_fields($ar_id, $prod_flds, &$error) {

		global $Global;

		//get all the fields ids
		$fld_ids = array();
		
		if(!is_array($prod_flds)) return;
		
		foreach ($prod_flds as $prod_id => $flds) {

			//if (!is_numeric($prod_id)) {
			//	$error = 'Invalid product';
			//	return false;
			//	}

			foreach ($flds as $key_fld => $val_fld) {
				
				if (!is_numeric($key_fld)) {
					$error = 'Only numeric values for field names';
					return false;
					}

				if (in_array($key_fld, array_keys($fld_ids))) {
					$error = 'A field cannot be used twice for different products';
					return false;
					}
				$fld_ids[$key_fld] = $key_fld;
				}
			}

		if (count($prod_flds) > 0) {
			$products = get_prod_fields_for_store($ar_id, array_keys($prod_flds));
			}
		else {
			$products = get_prod_fields_for_store($ar_id);
			}

		//check if we have "extra" products that are not part of this store or do not exist
		foreach ($prod_flds as $prod_id => $flds) {
			//if (!isset ($products[$prod_id])) {
			//	$error = 'Invalid product';
			//	return false;
				//}
			}

		//check the required fields
		foreach ($products as $prod_id => $masters) {
			foreach ($masters as $master_id => $master_val) {

				//we skip the check for masters that are not shown
				if ($master_val['show'] === false) {
					continue 1;
					}

				foreach ($master_val['fields'] as $field_val) {

					$field_id = $field_val['id'];
					
					if ($field_val['required'] === true) {

						//check if this value was send with the user data
						if (!isset ($prod_flds[$prod_id][$field_id])) {
							$error = 'Field '.$field_val['label'].' is required.';
							return false;
							}

						//if these are checkboxes
						if (is_array($prod_flds[$prod_id][$field_id])) {
							if (count($prod_flds[$prod_id][$field_id]) == 0) {
								$error = 'Field '.$field_val['label'].' is required.';
								return false;
								}
							}

						//any other control
						else {
							if ($prod_flds[$prod_id][$field_id] == '') {
								$error = 'Field '.$field_val['label'].' is required.';
								return false;
								}
							}
						}

					//if this is a multiselect field then for each selected option check the subelements
					if (in_array($Global['field_types_reverse'][$field_val['type']], $Global['field_multiple'])) {
						foreach($field_val['checks'] as $option_val) {
							$option_id = $option_val['id'];

							//check if this option/check/radio is selected
							if (is_array($prod_flds[$prod_id][$field_id])) {
								foreach($prod_flds[$prod_id][$field_id] as $check_val) {
									if ($option_val['value'] == $check_val) {
										$res = validate_required_fields_deep($prod_id, $option_val['elements'], $prod_flds, $error);
										if ($res == false) {
											return false;
											}
										}
									}
								}
							else {
								if ($option_val['value'] == $prod_flds[$prod_id][$field_id]) {
									$res = validate_required_fields_deep($prod_id, $option_val['elements'], $prod_flds, $error);
									if ($res == false) {
										return false;
										}
									}
								}
							}
						}
					}
				}
			}

		return true;
		}

	function validate_required_fields_deep($prod_id, &$mfields, &$prod_flds, &$error) {

		global $Global;

		foreach ($mfields as $field_val) {

			$field_id = $field_val['id'];

			if ($field_val['required'] === true) {

				//check if this value was send with the user data
				if (!isset ($prod_flds[$prod_id][$field_id])) {
					$error = 'Field '.$field_val['label'].' is required.';
					return false;
					}

				//if these are checkboxes
				if (is_array($prod_flds[$prod_id][$field_id])) {
					if (count($prod_flds[$prod_id][$field_id]) == 0) {
						$error = 'Field '.$field_val['label'].' is required.';
						return false;
						}
					}

				//any other control
				else {
					if ($prod_flds[$prod_id][$field_id] == '') {
						$error = 'Field '.$field_val['label'].' is required.';
						return false;
						}
					}
				}

			//if this is a multiselect field then for each selected option check the subelements
			if (in_array($Global['field_types_reverse'][$field_val['type']], $Global['field_multiple'])) {
				foreach($field_val['checks'] as $option_val) {
					$option_id = $option_val['id'];

					//check if this option/check/radio is selected
					if (is_array($prod_flds[$prod_id][$field_id])) {
						foreach($prod_flds[$prod_id][$field_id] as $check_val) {
							if ($option_val['value'] == $check_val) {
								$res = validate_required_fields_deep($prod_id, $option_val['elements'], $prod_flds, $error);
								if ($res == false) {
									return false;
									}
								}
							}
						}
					else {
						if ($option_val['value'] == $prod_flds[$prod_id][$field_id]) {
							$res = validate_required_fields_deep($prod_id, $option_val['elements'], $prod_flds, $error);
							if ($res == false) {
								return false;
								}
							}
						}
					}
				}
			}
			
		return true;
		}

	/**
	 * Deletes all user input fields for a specific order
	 *
	 * @param int $order_id
	 */
	function delete_user_fields($order_id) {
		$query = 'DELETE
								FROM ar_form_info
								WHERE orders_id='.(int)$order_id;
		mysql_query($query) or die(mysql_error());
		}

	/**
	 * Inserts user input field for his selected products
	 *
	 * @param int $order_id
	 * @param array $prod_flds
	 */
	function save_user_fields($order_id, $prod_flds) {

		//delete old info first
		delete_user_fields($order_id);

		//get all field ids so that we can extract the data associated with them
		$fld_ids = array(0);
		$option_ids = array(0);
		foreach ($prod_flds as $flds) {
			$fld_ids = array_merge($fld_ids, array_keys($flds));
			foreach($flds as $fld) {
				if (is_array($fld)) {
					$option_ids = array_merge($option_ids, array_keys($fld));
					}
				}
			}

		$query = 'SELECT *
								FROM ar_form_fields
									WHERE form_fields_id IN ('.implode(',', $fld_ids).')';
		$result = mysql_query($query) or die(mysql_error());

		//gather the info in an array
		$fields = array();
		while ($buffer = mysql_fetch_assoc($result)) {
			$fields[$buffer['form_fields_id']] = $buffer;
			}

		//get all option info
		$query = 'SELECT *
								FROM ar_form_options
									WHERE form_options_id IN ('.implode(',', $option_ids).')';
		$result = mysql_query($query) or die(mysql_error());

		//gather the info in an array
		$options = array();
		while ($buffer = mysql_fetch_assoc($result)) {
			$options[$buffer['form_options_id']] = $buffer;
			}

		//create the insert query
		$first = false;
		$query = 'INSERT 
								INTO
									ar_form_info(orders_id, form_fields_id, form_info_label, form_info_value, form_info_level, form_info_order) VALUES';
		foreach ($prod_flds as $prod_id => $flds) {

			//process each field
			foreach ($flds as $fld_id => $value) {

				if ($first === true) {
					$query .= ',';
					}
				else {
					$first = true;
					}

				//if the value is an array then we have multiple options selected for this field
				if (is_array($value)) {

					//process each option value
					foreach($value as $opt_key => $option) {
						$query .= '('.$order_id.', '.$fields[$fld_id]['form_fields_id'].', "'.mysql_escape_string($options[$opt_key]['form_options_name']).'", "'.mysql_escape_string($option).'", '.$fields[$fld_id]['form_fields_level'].', '.$fields[$fld_id]['form_fields_order'].')';
						}
					}
				else {
					$query .= '('.$order_id.', '.$fields[$fld_id]['form_fields_id'].', "'.mysql_escape_string($fields[$fld_id]['form_fields_desc']).'", "'.mysql_escape_string($value).'", '.$fields[$fld_id]['form_fields_level'].', '.$fields[$fld_id]['form_fields_order'].')';
					}
				}
			}
		if ($first === true) {
			mysql_query($query) or die(mysql_error());
			}
		}

	/**
	 * For a given store we return all it's product fields
	 *
	 * @global array $Global
	 * @param int $ar_id
	 * @return array
	 */
	function get_prod_fields_for_store($ar_id, $limit_products = null) {
		global $Global;

		//echo $ar_id;
		
		/*echo "SELECT
														imaster.*
														, opt.*
														, ifields.*
													 FROM
														ar_form_master as imaster
														INNER JOIN ar_form_fields as ifields
															ON (imaster.form_master_id=ifields.form_master_id
																	AND ifields.form_fields_trigger IS NULL)
														LEFT JOIN ar_form_options as opt
															ON (ifields.form_fields_id=opt.form_fields_id)
														WHERE
															imaster.ar_id='$ar_id'
															".($limit_products !== null && is_array($limit_products) ? ' AND imaster.leads_id IN ('.implode(',', $limit_products).')':'')."
														ORDER BY
															imaster.leads_id ASC
															, imaster.form_master_id ASC
															, ifields.form_fields_level ASC
															, ifields.form_fields_order ASC
															, opt.form_options_order ASC
													 ";*/
													 
													 
		//generate the fiels array
		$result = mysql_query("SELECT
														imaster.*
														, opt.*
														, ifields.*
													 FROM
														ar_form_master as imaster
														INNER JOIN ar_form_fields as ifields
															ON (imaster.form_master_id=ifields.form_master_id
																	AND ifields.form_fields_trigger IS NULL)
														LEFT JOIN ar_form_options as opt
															ON (ifields.form_fields_id=opt.form_fields_id)
														WHERE
															imaster.ar_id='$ar_id'
															".($limit_products !== null && is_array($limit_products) ? ' AND imaster.leads_id IN ('.implode(',', $limit_products).')':'')."
														ORDER BY
															imaster.leads_id ASC
															, imaster.form_master_id ASC
															, ifields.form_fields_level ASC
															, ifields.form_fields_order ASC
															, opt.form_options_order ASC
													 ") or die(mysql_error());
		$fields = array();
		$processed_fields = array();
		$prods = array();

		while ($buffer = mysql_fetch_assoc($result)) {

			//set the product id if it's not set yet
			if (!isset($prods[$buffer['leads_id']])) {
				$prods[$buffer['leads_id']] = array();
				$fields = &$prods[$buffer['leads_id']];
				}

			//Add the master information if it does not exist
			if (!isset($fields[$buffer['form_master_id']])) {
				$fields[$buffer['form_master_id']]['id'] = $buffer['form_master_id'];
				$fields[$buffer['form_master_id']]['name'] = $buffer['form_master_name'];
				$fields[$buffer['form_master_id']]['show'] = ($buffer['form_master_show'] == 'Y')?true:false;
				$fields[$buffer['form_master_id']]['required'] = ($buffer['form_master_required'] == 'Y')?true:false;
				$fields[$buffer['form_master_id']]['fields'] = array();

				$number = 0;
				}

			//Add the field information if it does not exist
			if (!isset($processed_fields[$buffer['form_fields_id']])) {
				$processed_fields[$buffer['form_fields_id']] = true;

				++$number;

				$fields[$buffer['form_master_id']]['fields'][$number]['id'] = $buffer['form_fields_id'];
				$fields[$buffer['form_master_id']]['fields'][$number]['order'] = $number;
				$fields[$buffer['form_master_id']]['fields'][$number]['post_name'] = $buffer['form_fields_name'];
				$fields[$buffer['form_master_id']]['fields'][$number]['label'] = $buffer['form_fields_desc'];
				$fields[$buffer['form_master_id']]['fields'][$number]['required'] = ($buffer['form_fields_required'] == 'Y')?true:false;
				$fields[$buffer['form_master_id']]['fields'][$number]['type'] = $Global['field_types'][$buffer['form_fields_type']];


				//$fields[$buffer['form_master_id']]['fields'][$cnt]['value'] = $buffer['form_fields_name'];

				//if it's multiple choice control
				if (in_array($buffer['form_fields_type'], $Global['field_multiple'])) {
					$fields[$buffer['form_master_id']]['fields'][$number]['checks'] = array();

					$inner_number = 1;
					}
				}

			
				
			//Add the options if they do not exist
			if (!in_array($buffer['form_fields_type'], $Global['field_multiple'])) {
				//$fields[$buffer['form_master_id']]['fields'][$number]['value'] = $buffer['form_options_value'];

				$ORD_INFO=mysql_fetch_array(mysql_query("select * from ar_form_info where orders_id='".$Global['leads_id']."'"));
//echo "select * from ar_form_info where orders_id='".$Global['leads_id']."'<br>";
//				print_r($ORD_INFO);
//				$vflds=get_form_info_fields($ORD_INFO[orders_id]);
				if($ORD_INFO)
				$fields[$buffer['form_master_id']]['fields'][$number]['value'] = $ORD_INFO['form_info_value'];
				else
				$fields[$buffer['form_master_id']]['fields'][$number]['value'] = $buffer['form_options_value'];
				
				if ($buffer['form_options'] & 1) {
					$fields[$buffer['form_master_id']]['fields'][$number]['blank'] = 1;
					}
				}
			else {
				$fields[$buffer['form_master_id']]['fields'][$number]['checks'][$inner_number]['id'] = $buffer['form_options_id'];
				$fields[$buffer['form_master_id']]['fields'][$number]['checks'][$inner_number]['parent_order'] = $number;
				$fields[$buffer['form_master_id']]['fields'][$number]['checks'][$inner_number]['order'] = $inner_number;
				$fields[$buffer['form_master_id']]['fields'][$number]['checks'][$inner_number]['post_name'] = $buffer['form_fields_name'];
				$fields[$buffer['form_master_id']]['fields'][$number]['checks'][$inner_number]['label'] = $buffer['form_options_name'];
				//$fields[$buffer['form_master_id']]['fields'][$number]['checks'][$inner_number]['value'] = $buffer['form_options_value'];
$ORD_INFO=mysql_fetch_array(mysql_query("select * from ar_form_info where orders_id='".$Global['leads_id']."'"));
//echo "select * from ar_form_info where orders_id='".$Global['leads_id']."'<br>";
//				print_r($ORD_INFO);
//				$vflds=get_form_info_fields($ORD_INFO[orders_id]);
				if($ORD_INFO)
				$fields[$buffer['form_master_id']]['fields'][$number]['checks'][$inner_number]['value'] = $ORD_INFO['form_info_value'];
				else
				$fields[$buffer['form_master_id']]['fields'][$number]['checks'][$inner_number]['value'] = $buffer['form_options_value'];
				
				
				$fields[$buffer['form_master_id']]['fields'][$number]['checks'][$inner_number]['checked'] = ($buffer['form_options_selected'] == 'Y')?true:false;
				$fields[$buffer['form_master_id']]['fields'][$number]['checks'][$inner_number]['elements'] = array();

				get_children_fields($fields[$buffer['form_master_id']]['fields'][$number]['checks'][$inner_number]['elements'], $buffer['form_options_id'], $ar_id);

				++$inner_number;
				}
			}
			
				

		return $prods;
		}

	/**
	 * For a given product and store we return all it's fields
	 *
	 * @global array $Global
	 * @param int $leads_id
	 * @param int $ar_id
	 * @return array
	 */
	function get_fields_for_product($leads_id, $ar_id) {

		global $Global;

		//generate the fiels array
		
		/*echo "SELECT
														imaster.*
														, opt.*
														, ifields.*
													 FROM
														ar_form_master as imaster
														INNER JOIN ar_form_fields as ifields
															ON (imaster.form_master_id=ifields.form_master_id
																	AND ifields.form_fields_trigger IS NULL)
														LEFT JOIN ar_form_options as opt
															ON (ifields.form_fields_id=opt.form_fields_id)
														WHERE
															imaster.leads_id='$leads_id'
															AND imaster.ar_id='$ar_id'
														ORDER BY
															imaster.form_master_id ASC
															, ifields.form_fields_level ASC
															, ifields.form_fields_order ASC
															, opt.form_options_order ASC
													 ";*/
													 
		$result = mysql_query("SELECT
														imaster.*
														, opt.*
														, ifields.*
													 FROM
														ar_form_master as imaster
														INNER JOIN ar_form_fields as ifields
															ON (imaster.form_master_id=ifields.form_master_id
																	AND ifields.form_fields_trigger IS NULL)
														LEFT JOIN ar_form_options as opt
															ON (ifields.form_fields_id=opt.form_fields_id)
														WHERE
															imaster.leads_id='$leads_id'
															AND imaster.ar_id='$ar_id'
														ORDER BY
															imaster.form_master_id ASC
															, ifields.form_fields_level ASC
															, ifields.form_fields_order ASC
															, opt.form_options_order ASC
													 ") or die(mysql_error());
		$fields = array();
		$processed_fields = array();
		
		while ($buffer = mysql_fetch_assoc($result)) {
			//Add the master information if it does not exist
			if (!isset($fields[$buffer['form_master_id']])) {
				$fields[$buffer['form_master_id']]['id'] = $buffer['form_master_id'];
				$fields[$buffer['form_master_id']]['name'] = $buffer['form_master_name'];
				$fields[$buffer['form_master_id']]['show'] = ($buffer['form_master_show'] == 'Y')?true:false;
				$fields[$buffer['form_master_id']]['required'] = ($buffer['form_master_required'] == 'Y')?true:false;
				$fields[$buffer['form_master_id']]['fields'] = array();

				$number = 0;
				}

			//Add the field information if it does not exist
			if (!isset($processed_fields[$buffer['form_fields_id']])) {
				$processed_fields[$buffer['form_fields_id']] = true;
				
				++$number;

				$fields[$buffer['form_master_id']]['fields'][$number]['id'] = $buffer['form_fields_id'];
				$fields[$buffer['form_master_id']]['fields'][$number]['order'] = $number;
				$fields[$buffer['form_master_id']]['fields'][$number]['post_name'] = $buffer['form_fields_name'];
				$fields[$buffer['form_master_id']]['fields'][$number]['label'] = $buffer['form_fields_desc'];
				$fields[$buffer['form_master_id']]['fields'][$number]['required'] = ($buffer['form_fields_required'] == 'Y')?true:false;
				$fields[$buffer['form_master_id']]['fields'][$number]['type'] = $Global['field_types'][$buffer['form_fields_type']];

				//$fields[$buffer['form_master_id']]['fields'][$cnt]['value'] = $buffer['form_fields_name'];

				//if it's multiple choice control
				if (in_array($buffer['form_fields_type'], $Global['field_multiple'])) {
					$fields[$buffer['form_master_id']]['fields'][$number]['checks'] = array();

					$inner_number = 1;
					}
				}

			//Add the options if they do not exist
			if (!in_array($buffer['form_fields_type'], $Global['field_multiple'])) {
				$fields[$buffer['form_master_id']]['fields'][$number]['value'] = $buffer['form_options_value'];

				if ($buffer['form_options'] & 1) {
					$fields[$buffer['form_master_id']]['fields'][$number]['blank'] = 1;
					}
				}
			else {
				$fields[$buffer['form_master_id']]['fields'][$number]['checks'][$inner_number]['id'] = $buffer['form_options_id'];
				$fields[$buffer['form_master_id']]['fields'][$number]['checks'][$inner_number]['parent_order'] = $number;
				$fields[$buffer['form_master_id']]['fields'][$number]['checks'][$inner_number]['order'] = $inner_number;
				$fields[$buffer['form_master_id']]['fields'][$number]['checks'][$inner_number]['post_name'] = $buffer['form_fields_name'];
				$fields[$buffer['form_master_id']]['fields'][$number]['checks'][$inner_number]['label'] = $buffer['form_options_name'];
				$fields[$buffer['form_master_id']]['fields'][$number]['checks'][$inner_number]['value'] = $buffer['form_options_value'];
				$fields[$buffer['form_master_id']]['fields'][$number]['checks'][$inner_number]['checked'] = ($buffer['form_options_selected'] == 'Y')?true:false;
				$fields[$buffer['form_master_id']]['fields'][$number]['checks'][$inner_number]['elements'] = array();

				get_children_fields($fields[$buffer['form_master_id']]['fields'][$number]['checks'][$inner_number]['elements'], $buffer['form_options_id'], $ar_id);

				++$inner_number;
				}
			}

		return $fields;
		}

		
		/**
		 * Delete the form information
		 *
		 * @param integer $leads_id
		 * @param integer $ar_id
		 */
		function delete_form($leads_id, $ar_id) {
		

					$result = mysql_query("SELECT * FROM
										ar_form_master
									 WHERE
										ar_id='$ar_id'
										AND leads_id='$leads_id'");
			
					while ($buffer = mysql_fetch_assoc($result))
							{
									// delete all ar-form-options table
									$result1 = mysql_query("SELECT * FROM
										ar_form_fields
									 WHERE
										form_master_id='".$buffer['form_master_id']."'");
			
										while ($buffer1 = mysql_fetch_assoc($result1))
											{
							mysql_query("DELETE FROM
										ar_form_options
									 WHERE
										form_fields_id='".$buffer1['form_fields_id']."'
									") or die(mysql_error());
											}
							mysql_query("DELETE FROM
										ar_form_fields
									 WHERE
										form_master_id='".$buffer['form_master_id']."'
									") or die(mysql_error());
							}
							
							
									
			//Delete the current form information if it exists
			mysql_query("DELETE FROM
										ar_form_master
									 WHERE
										ar_id='$ar_id'
										AND leads_id='$leads_id'
									") or die(mysql_error());
			}

		/**
		 * Inserts the value from the $field parameter for the
		 * passed product and store
		 *
		 * @param string $field
		 * @param int $leads_id
		 * @param int $ar_id
		 */
		function add_fields($field, $leads_id, $ar_id) {

			global $Global;

			delete_form($leads_id, $ar_id);

			$fields_data = unserialize($field);

		//	print_r($fields_data);
			
			foreach ($fields_data as $master_key => $master_info) {
				//Store the master information into form_master
				
			/*	echo "INSERT INTO
											ar_form_master
										 SET
											ar_id='$ar_id'
											, leads_id='$leads_id'
											, form_master_name='".mysql_escape_string($master_info['name'])."'
											, form_master_show='".(($master_info['show'] === true)?'Y':'N')."'
											, form_master_required='".(($master_info['required'] === true)?'Y':'N')."'
										<br><br>";*/
										
				mysql_query("INSERT INTO
											ar_form_master
										 SET
											ar_id='$ar_id'
											, leads_id='$leads_id'
											, form_master_name='".mysql_escape_string($master_info['name'])."'
											, form_master_show='".(($master_info['show'] === true)?'Y':'N')."'
											, form_master_required='".(($master_info['required'] === true)?'Y':'N')."'
										") or die(mysql_error());

				$master_id = mysql_insert_id();

				//Prepare to loop over the fields
				$master_total = count($master_info['fields']);

			//	echo $master_total;
				
				//Loop over the fields
				for ($master_count=1;$master_count <= $master_total;++$master_count) {
					$field_info = $master_info['fields'][$master_count];
					if (!empty($field_info['level'])) {
						$level = (int) $field_info['level'];
						}
					else {
						$level = 1;
						}

					switch ($field_info['type']) {
						case 'select': //Select box
							$field_type = 'S';
							break;
						case 'input_text': //Text input
							$field_type = 'I';
							break;
						case 'textarea': //Text area
							$field_type = 'TA';
							break;
						case 'radio': //Radio input
							$field_type = 'R';
							break;
						case 'checkbox': //Checkbox input
							$field_type = 'C';
							break;
						case 'link': //Link
							$field_type = 'L';
							break;
						default:
							continue 2;
						}

				/*		echo "INSERT INTO
												ar_form_fields
											 SET
												form_master_id='$master_id'
												, form_fields_trigger=".((!empty($field_info['parent_id']))?(int) $field_info['parent_id']:'NULL')."
												, form_fields_desc='".mysql_escape_string($field_info['label'])."'
												, form_fields_name='".mysql_escape_string($field_info['post_name'])."'
												, form_fields_type='".$field_type."'
												, form_fields_required='".(($field_info['required'] === true)?'Y':'N')."'
												, form_fields_level='".$level."'
												, form_fields_order=".(int) $field_info['order']."
											";*/
											
					//Store the field into form_fields
					mysql_query("INSERT INTO
												ar_form_fields
											 SET
												form_master_id='$master_id'
												, form_fields_trigger=".((!empty($field_info['parent_id']))?(int) $field_info['parent_id']:'NULL')."
												, form_fields_desc='".mysql_escape_string($field_info['label'])."'
												, form_fields_name='".mysql_escape_string($field_info['post_name'])."'
												, form_fields_type='".$field_type."'
												, form_fields_required='".(($field_info['required'] === true)?'Y':'N')."'
												, form_fields_level='".$level."'
												, form_fields_order=".(int) $field_info['order']."
											") or die(mysql_query());

					$field_id = mysql_insert_id();

					//Loop over the field options
					if (!empty($field_info['checks'])) {
						foreach ($field_info['checks'] as $check_key => $check_info) {
							//Set any bitwise settings
							$form_options = 0;

							if (!empty($check_info['blank']) && $check_info['blank'] == 1) {
								$form_options += 1;
								}

							//Store the options into form_options
							mysql_query("INSERT INTO
														ar_form_options
													 SET
														form_fields_id='$field_id'
														, form_options_name='".mysql_escape_string($check_info['label'])."'
														, form_options_value='".mysql_escape_string($check_info['value'])."'
														, form_options_selected='".((!empty($check_info['checked']) && $check_info['checked'] === true)?'Y':'N')."'
														, form_options='$form_options'
														, form_options_order=".(int) $check_info['order']."
													") or die(mysql_error());
							
							$option_id = mysql_insert_id();

							//Loop over attached childs
							if (!empty($check_info['elements'])) {
								foreach ($check_info['elements'] as $element_key => $element_info) {
									//Push the elements into the master fields with the reference id attached
									$element_info['parent_id'] = $option_id;
									$element_info['level'] = $level + 1;
									
									$master_info['fields'][] = $element_info;
									++$master_total;
									}
								}
							}
						}
					else {
						//Set any bitwise settings
						$form_options = 0;

						if (!empty($field_info['blank']) && $field_info['blank'] == 1) {
							$form_options += 1;
							}

						//Store the "option" information
						mysql_query("INSERT INTO
													ar_form_options
												 SET
													form_fields_id='$field_id'
													, form_options_name='".mysql_escape_string($field_info['label'])."'
													, form_options_value='".mysql_escape_string($field_info['value'])."'
													, form_options_selected='N'
													, form_options='$form_options'
													, form_options_order=0
												") or die(mysql_error());
						}
					}
				}
			}